# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MetadataArgs', 'Metadata']

@pulumi.input_type
class MetadataArgs:
    def __init__(__self__, *,
                 content_id: pulumi.Input[builtins.str],
                 kind: pulumi.Input[builtins.str],
                 parent_id: pulumi.Input[builtins.str],
                 workspace_id: pulumi.Input[builtins.str],
                 author: Optional[pulumi.Input['MetadataAuthorArgs']] = None,
                 category: Optional[pulumi.Input['MetadataCategoryArgs']] = None,
                 content_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 custom_version: Optional[pulumi.Input[builtins.str]] = None,
                 dependency: Optional[pulumi.Input[builtins.str]] = None,
                 first_publish_date: Optional[pulumi.Input[builtins.str]] = None,
                 icon_id: Optional[pulumi.Input[builtins.str]] = None,
                 last_publish_date: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 preview_images: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 preview_images_darks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 providers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source: Optional[pulumi.Input['MetadataSourceArgs']] = None,
                 support: Optional[pulumi.Input['MetadataSupportArgs']] = None,
                 threat_analysis_tactics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 threat_analysis_techniques: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Metadata resource.
        :param pulumi.Input[builtins.str] content_id: The ID of the content. Used to identify dependencies and content from solutions or community.
        :param pulumi.Input[builtins.str] kind: The kind of content the metadata is for. Possible values are `AnalyticsRule`, `AnalyticsRuleTemplate`, `AutomationRule`, `AzureFunction`, `DataConnector`, `DataType`, `HuntingQuery`, `InvestigationQuery`, `LogicAppsCustomConnector`, `Parser`, `Playbook`, `PlaybookTemplate`, `Solution`, `Watchlist`, `WatchlistTemplate`, `Workbook` and `WorkbookTemplate`.
        :param pulumi.Input[builtins.str] parent_id: The ID of the parent resource ID of the content item, which the metadata belongs to.
        :param pulumi.Input[builtins.str] workspace_id: The ID of the Log Analytics Workspace. Changing this forces a new Sentinel Metadata to be created.
        :param pulumi.Input['MetadataAuthorArgs'] author: An `author` blocks as defined below.
        :param pulumi.Input['MetadataCategoryArgs'] category: A `category` block as defined below.
        :param pulumi.Input[builtins.str] content_schema_version: Schema version of the content. Can be used to distinguish between flow based on the schema version.
        :param pulumi.Input[builtins.str] custom_version: The Custom version of the content.
        :param pulumi.Input[builtins.str] dependency: A JSON formatted `dependency` block as defined below. Dependency for the content item, what other content items it requires to work.
        :param pulumi.Input[builtins.str] first_publish_date: The first publish date of solution content item.
        :param pulumi.Input[builtins.str] icon_id: The ID of the icon, this id can be fetched from the solution template.
        :param pulumi.Input[builtins.str] last_publish_date: The last publish date of solution content item.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Sentinel Metadata. Changing this forces a new Sentinel Metadata to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] preview_images: Specifies a list of preview image file names. These will be taken from solution artifacts.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] preview_images_darks: Specifies a list of preview image file names used for dark theme. These will be taken from solution artifacts.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] providers: Specifies a list of providers for the solution content item.
        :param pulumi.Input['MetadataSourceArgs'] source: A `source` block as defined below.
        :param pulumi.Input['MetadataSupportArgs'] support: A `support` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] threat_analysis_tactics: Specifies a list of tactics the resource covers. Possible values are `Reconnaissance`, `ResourceDevelopment`, `InitialAccess`, `Execution`, `Persistence`, `PrivilegeEscalation`, `DefenseEvasion`, `CredentialAccess`, `Discovery`, `LateralMovement`, `Collection`, `CommandAndControl`, `Exfiltration`, `Impact`, `ImpairProcessControl` and `InhibitResponseFunction`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] threat_analysis_techniques: Specifies a list of techniques the resource covers.
        :param pulumi.Input[builtins.str] version: Version of the content.
        """
        pulumi.set(__self__, "content_id", content_id)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "parent_id", parent_id)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if author is not None:
            pulumi.set(__self__, "author", author)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if content_schema_version is not None:
            pulumi.set(__self__, "content_schema_version", content_schema_version)
        if custom_version is not None:
            pulumi.set(__self__, "custom_version", custom_version)
        if dependency is not None:
            pulumi.set(__self__, "dependency", dependency)
        if first_publish_date is not None:
            pulumi.set(__self__, "first_publish_date", first_publish_date)
        if icon_id is not None:
            pulumi.set(__self__, "icon_id", icon_id)
        if last_publish_date is not None:
            pulumi.set(__self__, "last_publish_date", last_publish_date)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if preview_images is not None:
            pulumi.set(__self__, "preview_images", preview_images)
        if preview_images_darks is not None:
            pulumi.set(__self__, "preview_images_darks", preview_images_darks)
        if providers is not None:
            pulumi.set(__self__, "providers", providers)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if support is not None:
            pulumi.set(__self__, "support", support)
        if threat_analysis_tactics is not None:
            pulumi.set(__self__, "threat_analysis_tactics", threat_analysis_tactics)
        if threat_analysis_techniques is not None:
            pulumi.set(__self__, "threat_analysis_techniques", threat_analysis_techniques)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="contentId")
    def content_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the content. Used to identify dependencies and content from solutions or community.
        """
        return pulumi.get(self, "content_id")

    @content_id.setter
    def content_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "content_id", value)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[builtins.str]:
        """
        The kind of content the metadata is for. Possible values are `AnalyticsRule`, `AnalyticsRuleTemplate`, `AutomationRule`, `AzureFunction`, `DataConnector`, `DataType`, `HuntingQuery`, `InvestigationQuery`, `LogicAppsCustomConnector`, `Parser`, `Playbook`, `PlaybookTemplate`, `Solution`, `Watchlist`, `WatchlistTemplate`, `Workbook` and `WorkbookTemplate`.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the parent resource ID of the content item, which the metadata belongs to.
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "parent_id", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Log Analytics Workspace. Changing this forces a new Sentinel Metadata to be created.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "workspace_id", value)

    @property
    @pulumi.getter
    def author(self) -> Optional[pulumi.Input['MetadataAuthorArgs']]:
        """
        An `author` blocks as defined below.
        """
        return pulumi.get(self, "author")

    @author.setter
    def author(self, value: Optional[pulumi.Input['MetadataAuthorArgs']]):
        pulumi.set(self, "author", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input['MetadataCategoryArgs']]:
        """
        A `category` block as defined below.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input['MetadataCategoryArgs']]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter(name="contentSchemaVersion")
    def content_schema_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Schema version of the content. Can be used to distinguish between flow based on the schema version.
        """
        return pulumi.get(self, "content_schema_version")

    @content_schema_version.setter
    def content_schema_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_schema_version", value)

    @property
    @pulumi.getter(name="customVersion")
    def custom_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Custom version of the content.
        """
        return pulumi.get(self, "custom_version")

    @custom_version.setter
    def custom_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_version", value)

    @property
    @pulumi.getter
    def dependency(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A JSON formatted `dependency` block as defined below. Dependency for the content item, what other content items it requires to work.
        """
        return pulumi.get(self, "dependency")

    @dependency.setter
    def dependency(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dependency", value)

    @property
    @pulumi.getter(name="firstPublishDate")
    def first_publish_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The first publish date of solution content item.
        """
        return pulumi.get(self, "first_publish_date")

    @first_publish_date.setter
    def first_publish_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "first_publish_date", value)

    @property
    @pulumi.getter(name="iconId")
    def icon_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the icon, this id can be fetched from the solution template.
        """
        return pulumi.get(self, "icon_id")

    @icon_id.setter
    def icon_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "icon_id", value)

    @property
    @pulumi.getter(name="lastPublishDate")
    def last_publish_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The last publish date of solution content item.
        """
        return pulumi.get(self, "last_publish_date")

    @last_publish_date.setter
    def last_publish_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_publish_date", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Sentinel Metadata. Changing this forces a new Sentinel Metadata to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="previewImages")
    def preview_images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of preview image file names. These will be taken from solution artifacts.
        """
        return pulumi.get(self, "preview_images")

    @preview_images.setter
    def preview_images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "preview_images", value)

    @property
    @pulumi.getter(name="previewImagesDarks")
    def preview_images_darks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of preview image file names used for dark theme. These will be taken from solution artifacts.
        """
        return pulumi.get(self, "preview_images_darks")

    @preview_images_darks.setter
    def preview_images_darks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "preview_images_darks", value)

    @property
    @pulumi.getter
    def providers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of providers for the solution content item.
        """
        return pulumi.get(self, "providers")

    @providers.setter
    def providers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "providers", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['MetadataSourceArgs']]:
        """
        A `source` block as defined below.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['MetadataSourceArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def support(self) -> Optional[pulumi.Input['MetadataSupportArgs']]:
        """
        A `support` block as defined below.
        """
        return pulumi.get(self, "support")

    @support.setter
    def support(self, value: Optional[pulumi.Input['MetadataSupportArgs']]):
        pulumi.set(self, "support", value)

    @property
    @pulumi.getter(name="threatAnalysisTactics")
    def threat_analysis_tactics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of tactics the resource covers. Possible values are `Reconnaissance`, `ResourceDevelopment`, `InitialAccess`, `Execution`, `Persistence`, `PrivilegeEscalation`, `DefenseEvasion`, `CredentialAccess`, `Discovery`, `LateralMovement`, `Collection`, `CommandAndControl`, `Exfiltration`, `Impact`, `ImpairProcessControl` and `InhibitResponseFunction`.
        """
        return pulumi.get(self, "threat_analysis_tactics")

    @threat_analysis_tactics.setter
    def threat_analysis_tactics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "threat_analysis_tactics", value)

    @property
    @pulumi.getter(name="threatAnalysisTechniques")
    def threat_analysis_techniques(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of techniques the resource covers.
        """
        return pulumi.get(self, "threat_analysis_techniques")

    @threat_analysis_techniques.setter
    def threat_analysis_techniques(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "threat_analysis_techniques", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Version of the content.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _MetadataState:
    def __init__(__self__, *,
                 author: Optional[pulumi.Input['MetadataAuthorArgs']] = None,
                 category: Optional[pulumi.Input['MetadataCategoryArgs']] = None,
                 content_id: Optional[pulumi.Input[builtins.str]] = None,
                 content_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 custom_version: Optional[pulumi.Input[builtins.str]] = None,
                 dependency: Optional[pulumi.Input[builtins.str]] = None,
                 first_publish_date: Optional[pulumi.Input[builtins.str]] = None,
                 icon_id: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 last_publish_date: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent_id: Optional[pulumi.Input[builtins.str]] = None,
                 preview_images: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 preview_images_darks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 providers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source: Optional[pulumi.Input['MetadataSourceArgs']] = None,
                 support: Optional[pulumi.Input['MetadataSupportArgs']] = None,
                 threat_analysis_tactics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 threat_analysis_techniques: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Metadata resources.
        :param pulumi.Input['MetadataAuthorArgs'] author: An `author` blocks as defined below.
        :param pulumi.Input['MetadataCategoryArgs'] category: A `category` block as defined below.
        :param pulumi.Input[builtins.str] content_id: The ID of the content. Used to identify dependencies and content from solutions or community.
        :param pulumi.Input[builtins.str] content_schema_version: Schema version of the content. Can be used to distinguish between flow based on the schema version.
        :param pulumi.Input[builtins.str] custom_version: The Custom version of the content.
        :param pulumi.Input[builtins.str] dependency: A JSON formatted `dependency` block as defined below. Dependency for the content item, what other content items it requires to work.
        :param pulumi.Input[builtins.str] first_publish_date: The first publish date of solution content item.
        :param pulumi.Input[builtins.str] icon_id: The ID of the icon, this id can be fetched from the solution template.
        :param pulumi.Input[builtins.str] kind: The kind of content the metadata is for. Possible values are `AnalyticsRule`, `AnalyticsRuleTemplate`, `AutomationRule`, `AzureFunction`, `DataConnector`, `DataType`, `HuntingQuery`, `InvestigationQuery`, `LogicAppsCustomConnector`, `Parser`, `Playbook`, `PlaybookTemplate`, `Solution`, `Watchlist`, `WatchlistTemplate`, `Workbook` and `WorkbookTemplate`.
        :param pulumi.Input[builtins.str] last_publish_date: The last publish date of solution content item.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Sentinel Metadata. Changing this forces a new Sentinel Metadata to be created.
        :param pulumi.Input[builtins.str] parent_id: The ID of the parent resource ID of the content item, which the metadata belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] preview_images: Specifies a list of preview image file names. These will be taken from solution artifacts.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] preview_images_darks: Specifies a list of preview image file names used for dark theme. These will be taken from solution artifacts.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] providers: Specifies a list of providers for the solution content item.
        :param pulumi.Input['MetadataSourceArgs'] source: A `source` block as defined below.
        :param pulumi.Input['MetadataSupportArgs'] support: A `support` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] threat_analysis_tactics: Specifies a list of tactics the resource covers. Possible values are `Reconnaissance`, `ResourceDevelopment`, `InitialAccess`, `Execution`, `Persistence`, `PrivilegeEscalation`, `DefenseEvasion`, `CredentialAccess`, `Discovery`, `LateralMovement`, `Collection`, `CommandAndControl`, `Exfiltration`, `Impact`, `ImpairProcessControl` and `InhibitResponseFunction`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] threat_analysis_techniques: Specifies a list of techniques the resource covers.
        :param pulumi.Input[builtins.str] version: Version of the content.
        :param pulumi.Input[builtins.str] workspace_id: The ID of the Log Analytics Workspace. Changing this forces a new Sentinel Metadata to be created.
        """
        if author is not None:
            pulumi.set(__self__, "author", author)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if content_id is not None:
            pulumi.set(__self__, "content_id", content_id)
        if content_schema_version is not None:
            pulumi.set(__self__, "content_schema_version", content_schema_version)
        if custom_version is not None:
            pulumi.set(__self__, "custom_version", custom_version)
        if dependency is not None:
            pulumi.set(__self__, "dependency", dependency)
        if first_publish_date is not None:
            pulumi.set(__self__, "first_publish_date", first_publish_date)
        if icon_id is not None:
            pulumi.set(__self__, "icon_id", icon_id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if last_publish_date is not None:
            pulumi.set(__self__, "last_publish_date", last_publish_date)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_id is not None:
            pulumi.set(__self__, "parent_id", parent_id)
        if preview_images is not None:
            pulumi.set(__self__, "preview_images", preview_images)
        if preview_images_darks is not None:
            pulumi.set(__self__, "preview_images_darks", preview_images_darks)
        if providers is not None:
            pulumi.set(__self__, "providers", providers)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if support is not None:
            pulumi.set(__self__, "support", support)
        if threat_analysis_tactics is not None:
            pulumi.set(__self__, "threat_analysis_tactics", threat_analysis_tactics)
        if threat_analysis_techniques is not None:
            pulumi.set(__self__, "threat_analysis_techniques", threat_analysis_techniques)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter
    def author(self) -> Optional[pulumi.Input['MetadataAuthorArgs']]:
        """
        An `author` blocks as defined below.
        """
        return pulumi.get(self, "author")

    @author.setter
    def author(self, value: Optional[pulumi.Input['MetadataAuthorArgs']]):
        pulumi.set(self, "author", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input['MetadataCategoryArgs']]:
        """
        A `category` block as defined below.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input['MetadataCategoryArgs']]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter(name="contentId")
    def content_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the content. Used to identify dependencies and content from solutions or community.
        """
        return pulumi.get(self, "content_id")

    @content_id.setter
    def content_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_id", value)

    @property
    @pulumi.getter(name="contentSchemaVersion")
    def content_schema_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Schema version of the content. Can be used to distinguish between flow based on the schema version.
        """
        return pulumi.get(self, "content_schema_version")

    @content_schema_version.setter
    def content_schema_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_schema_version", value)

    @property
    @pulumi.getter(name="customVersion")
    def custom_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Custom version of the content.
        """
        return pulumi.get(self, "custom_version")

    @custom_version.setter
    def custom_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_version", value)

    @property
    @pulumi.getter
    def dependency(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A JSON formatted `dependency` block as defined below. Dependency for the content item, what other content items it requires to work.
        """
        return pulumi.get(self, "dependency")

    @dependency.setter
    def dependency(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dependency", value)

    @property
    @pulumi.getter(name="firstPublishDate")
    def first_publish_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The first publish date of solution content item.
        """
        return pulumi.get(self, "first_publish_date")

    @first_publish_date.setter
    def first_publish_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "first_publish_date", value)

    @property
    @pulumi.getter(name="iconId")
    def icon_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the icon, this id can be fetched from the solution template.
        """
        return pulumi.get(self, "icon_id")

    @icon_id.setter
    def icon_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "icon_id", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The kind of content the metadata is for. Possible values are `AnalyticsRule`, `AnalyticsRuleTemplate`, `AutomationRule`, `AzureFunction`, `DataConnector`, `DataType`, `HuntingQuery`, `InvestigationQuery`, `LogicAppsCustomConnector`, `Parser`, `Playbook`, `PlaybookTemplate`, `Solution`, `Watchlist`, `WatchlistTemplate`, `Workbook` and `WorkbookTemplate`.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="lastPublishDate")
    def last_publish_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The last publish date of solution content item.
        """
        return pulumi.get(self, "last_publish_date")

    @last_publish_date.setter
    def last_publish_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_publish_date", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Sentinel Metadata. Changing this forces a new Sentinel Metadata to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the parent resource ID of the content item, which the metadata belongs to.
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent_id", value)

    @property
    @pulumi.getter(name="previewImages")
    def preview_images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of preview image file names. These will be taken from solution artifacts.
        """
        return pulumi.get(self, "preview_images")

    @preview_images.setter
    def preview_images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "preview_images", value)

    @property
    @pulumi.getter(name="previewImagesDarks")
    def preview_images_darks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of preview image file names used for dark theme. These will be taken from solution artifacts.
        """
        return pulumi.get(self, "preview_images_darks")

    @preview_images_darks.setter
    def preview_images_darks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "preview_images_darks", value)

    @property
    @pulumi.getter
    def providers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of providers for the solution content item.
        """
        return pulumi.get(self, "providers")

    @providers.setter
    def providers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "providers", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['MetadataSourceArgs']]:
        """
        A `source` block as defined below.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['MetadataSourceArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def support(self) -> Optional[pulumi.Input['MetadataSupportArgs']]:
        """
        A `support` block as defined below.
        """
        return pulumi.get(self, "support")

    @support.setter
    def support(self, value: Optional[pulumi.Input['MetadataSupportArgs']]):
        pulumi.set(self, "support", value)

    @property
    @pulumi.getter(name="threatAnalysisTactics")
    def threat_analysis_tactics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of tactics the resource covers. Possible values are `Reconnaissance`, `ResourceDevelopment`, `InitialAccess`, `Execution`, `Persistence`, `PrivilegeEscalation`, `DefenseEvasion`, `CredentialAccess`, `Discovery`, `LateralMovement`, `Collection`, `CommandAndControl`, `Exfiltration`, `Impact`, `ImpairProcessControl` and `InhibitResponseFunction`.
        """
        return pulumi.get(self, "threat_analysis_tactics")

    @threat_analysis_tactics.setter
    def threat_analysis_tactics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "threat_analysis_tactics", value)

    @property
    @pulumi.getter(name="threatAnalysisTechniques")
    def threat_analysis_techniques(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of techniques the resource covers.
        """
        return pulumi.get(self, "threat_analysis_techniques")

    @threat_analysis_techniques.setter
    def threat_analysis_techniques(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "threat_analysis_techniques", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Version of the content.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Log Analytics Workspace. Changing this forces a new Sentinel Metadata to be created.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("azure:sentinel/metadata:Metadata")
class Metadata(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 author: Optional[pulumi.Input[Union['MetadataAuthorArgs', 'MetadataAuthorArgsDict']]] = None,
                 category: Optional[pulumi.Input[Union['MetadataCategoryArgs', 'MetadataCategoryArgsDict']]] = None,
                 content_id: Optional[pulumi.Input[builtins.str]] = None,
                 content_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 custom_version: Optional[pulumi.Input[builtins.str]] = None,
                 dependency: Optional[pulumi.Input[builtins.str]] = None,
                 first_publish_date: Optional[pulumi.Input[builtins.str]] = None,
                 icon_id: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 last_publish_date: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent_id: Optional[pulumi.Input[builtins.str]] = None,
                 preview_images: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 preview_images_darks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 providers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source: Optional[pulumi.Input[Union['MetadataSourceArgs', 'MetadataSourceArgsDict']]] = None,
                 support: Optional[pulumi.Input[Union['MetadataSupportArgs', 'MetadataSupportArgsDict']]] = None,
                 threat_analysis_tactics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 threat_analysis_techniques: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Sentinel Metadata.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            sku="pergb2018")
        example_analytics_solution = azure.operationalinsights.AnalyticsSolution("example",
            solution_name="SecurityInsights",
            location=example.location,
            resource_group_name=example.name,
            workspace_resource_id=example_analytics_workspace.id,
            workspace_name=example_analytics_workspace.name,
            plan={
                "publisher": "Microsoft",
                "product": "OMSGallery/SecurityInsights",
            })
        example_alert_rule_nrt = azure.sentinel.AlertRuleNrt("example",
            name="example",
            log_analytics_workspace_id=example_analytics_solution.workspace_resource_id,
            display_name="example",
            severity="High",
            query=\"\"\"AzureActivity |
          where OperationName == "Create or Update Virtual Machine" or OperationName =="Create Deployment" |
          where ActivityStatus == "Succeeded" |
          make-series dcount(ResourceId) default=0 on EventSubmissionTimestamp in range(ago(7d), now(), 1d) by Caller
        \"\"\")
        example_metadata = azure.sentinel.Metadata("example",
            name="exampl",
            workspace_id=example_analytics_solution.workspace_resource_id,
            content_id=example_alert_rule_nrt.name,
            kind="AnalyticsRule",
            parent_id=example_alert_rule_nrt.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.OperationalInsights`: 2022-10-01-preview

        ## Import

        Sentinel Metadata can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:sentinel/metadata:Metadata example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourcegroup1/providers/Microsoft.OperationalInsights/workspaces/workspace1/providers/Microsoft.SecurityInsights/metadata/metadata1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MetadataAuthorArgs', 'MetadataAuthorArgsDict']] author: An `author` blocks as defined below.
        :param pulumi.Input[Union['MetadataCategoryArgs', 'MetadataCategoryArgsDict']] category: A `category` block as defined below.
        :param pulumi.Input[builtins.str] content_id: The ID of the content. Used to identify dependencies and content from solutions or community.
        :param pulumi.Input[builtins.str] content_schema_version: Schema version of the content. Can be used to distinguish between flow based on the schema version.
        :param pulumi.Input[builtins.str] custom_version: The Custom version of the content.
        :param pulumi.Input[builtins.str] dependency: A JSON formatted `dependency` block as defined below. Dependency for the content item, what other content items it requires to work.
        :param pulumi.Input[builtins.str] first_publish_date: The first publish date of solution content item.
        :param pulumi.Input[builtins.str] icon_id: The ID of the icon, this id can be fetched from the solution template.
        :param pulumi.Input[builtins.str] kind: The kind of content the metadata is for. Possible values are `AnalyticsRule`, `AnalyticsRuleTemplate`, `AutomationRule`, `AzureFunction`, `DataConnector`, `DataType`, `HuntingQuery`, `InvestigationQuery`, `LogicAppsCustomConnector`, `Parser`, `Playbook`, `PlaybookTemplate`, `Solution`, `Watchlist`, `WatchlistTemplate`, `Workbook` and `WorkbookTemplate`.
        :param pulumi.Input[builtins.str] last_publish_date: The last publish date of solution content item.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Sentinel Metadata. Changing this forces a new Sentinel Metadata to be created.
        :param pulumi.Input[builtins.str] parent_id: The ID of the parent resource ID of the content item, which the metadata belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] preview_images: Specifies a list of preview image file names. These will be taken from solution artifacts.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] preview_images_darks: Specifies a list of preview image file names used for dark theme. These will be taken from solution artifacts.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] providers: Specifies a list of providers for the solution content item.
        :param pulumi.Input[Union['MetadataSourceArgs', 'MetadataSourceArgsDict']] source: A `source` block as defined below.
        :param pulumi.Input[Union['MetadataSupportArgs', 'MetadataSupportArgsDict']] support: A `support` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] threat_analysis_tactics: Specifies a list of tactics the resource covers. Possible values are `Reconnaissance`, `ResourceDevelopment`, `InitialAccess`, `Execution`, `Persistence`, `PrivilegeEscalation`, `DefenseEvasion`, `CredentialAccess`, `Discovery`, `LateralMovement`, `Collection`, `CommandAndControl`, `Exfiltration`, `Impact`, `ImpairProcessControl` and `InhibitResponseFunction`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] threat_analysis_techniques: Specifies a list of techniques the resource covers.
        :param pulumi.Input[builtins.str] version: Version of the content.
        :param pulumi.Input[builtins.str] workspace_id: The ID of the Log Analytics Workspace. Changing this forces a new Sentinel Metadata to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MetadataArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Sentinel Metadata.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            sku="pergb2018")
        example_analytics_solution = azure.operationalinsights.AnalyticsSolution("example",
            solution_name="SecurityInsights",
            location=example.location,
            resource_group_name=example.name,
            workspace_resource_id=example_analytics_workspace.id,
            workspace_name=example_analytics_workspace.name,
            plan={
                "publisher": "Microsoft",
                "product": "OMSGallery/SecurityInsights",
            })
        example_alert_rule_nrt = azure.sentinel.AlertRuleNrt("example",
            name="example",
            log_analytics_workspace_id=example_analytics_solution.workspace_resource_id,
            display_name="example",
            severity="High",
            query=\"\"\"AzureActivity |
          where OperationName == "Create or Update Virtual Machine" or OperationName =="Create Deployment" |
          where ActivityStatus == "Succeeded" |
          make-series dcount(ResourceId) default=0 on EventSubmissionTimestamp in range(ago(7d), now(), 1d) by Caller
        \"\"\")
        example_metadata = azure.sentinel.Metadata("example",
            name="exampl",
            workspace_id=example_analytics_solution.workspace_resource_id,
            content_id=example_alert_rule_nrt.name,
            kind="AnalyticsRule",
            parent_id=example_alert_rule_nrt.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.OperationalInsights`: 2022-10-01-preview

        ## Import

        Sentinel Metadata can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:sentinel/metadata:Metadata example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourcegroup1/providers/Microsoft.OperationalInsights/workspaces/workspace1/providers/Microsoft.SecurityInsights/metadata/metadata1
        ```

        :param str resource_name: The name of the resource.
        :param MetadataArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MetadataArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 author: Optional[pulumi.Input[Union['MetadataAuthorArgs', 'MetadataAuthorArgsDict']]] = None,
                 category: Optional[pulumi.Input[Union['MetadataCategoryArgs', 'MetadataCategoryArgsDict']]] = None,
                 content_id: Optional[pulumi.Input[builtins.str]] = None,
                 content_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 custom_version: Optional[pulumi.Input[builtins.str]] = None,
                 dependency: Optional[pulumi.Input[builtins.str]] = None,
                 first_publish_date: Optional[pulumi.Input[builtins.str]] = None,
                 icon_id: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 last_publish_date: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent_id: Optional[pulumi.Input[builtins.str]] = None,
                 preview_images: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 preview_images_darks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 providers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source: Optional[pulumi.Input[Union['MetadataSourceArgs', 'MetadataSourceArgsDict']]] = None,
                 support: Optional[pulumi.Input[Union['MetadataSupportArgs', 'MetadataSupportArgsDict']]] = None,
                 threat_analysis_tactics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 threat_analysis_techniques: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MetadataArgs.__new__(MetadataArgs)

            __props__.__dict__["author"] = author
            __props__.__dict__["category"] = category
            if content_id is None and not opts.urn:
                raise TypeError("Missing required property 'content_id'")
            __props__.__dict__["content_id"] = content_id
            __props__.__dict__["content_schema_version"] = content_schema_version
            __props__.__dict__["custom_version"] = custom_version
            __props__.__dict__["dependency"] = dependency
            __props__.__dict__["first_publish_date"] = first_publish_date
            __props__.__dict__["icon_id"] = icon_id
            if kind is None and not opts.urn:
                raise TypeError("Missing required property 'kind'")
            __props__.__dict__["kind"] = kind
            __props__.__dict__["last_publish_date"] = last_publish_date
            __props__.__dict__["name"] = name
            if parent_id is None and not opts.urn:
                raise TypeError("Missing required property 'parent_id'")
            __props__.__dict__["parent_id"] = parent_id
            __props__.__dict__["preview_images"] = preview_images
            __props__.__dict__["preview_images_darks"] = preview_images_darks
            __props__.__dict__["providers"] = providers
            __props__.__dict__["source"] = source
            __props__.__dict__["support"] = support
            __props__.__dict__["threat_analysis_tactics"] = threat_analysis_tactics
            __props__.__dict__["threat_analysis_techniques"] = threat_analysis_techniques
            __props__.__dict__["version"] = version
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
        super(Metadata, __self__).__init__(
            'azure:sentinel/metadata:Metadata',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            author: Optional[pulumi.Input[Union['MetadataAuthorArgs', 'MetadataAuthorArgsDict']]] = None,
            category: Optional[pulumi.Input[Union['MetadataCategoryArgs', 'MetadataCategoryArgsDict']]] = None,
            content_id: Optional[pulumi.Input[builtins.str]] = None,
            content_schema_version: Optional[pulumi.Input[builtins.str]] = None,
            custom_version: Optional[pulumi.Input[builtins.str]] = None,
            dependency: Optional[pulumi.Input[builtins.str]] = None,
            first_publish_date: Optional[pulumi.Input[builtins.str]] = None,
            icon_id: Optional[pulumi.Input[builtins.str]] = None,
            kind: Optional[pulumi.Input[builtins.str]] = None,
            last_publish_date: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            parent_id: Optional[pulumi.Input[builtins.str]] = None,
            preview_images: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            preview_images_darks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            providers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            source: Optional[pulumi.Input[Union['MetadataSourceArgs', 'MetadataSourceArgsDict']]] = None,
            support: Optional[pulumi.Input[Union['MetadataSupportArgs', 'MetadataSupportArgsDict']]] = None,
            threat_analysis_tactics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            threat_analysis_techniques: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[builtins.str]] = None) -> 'Metadata':
        """
        Get an existing Metadata resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MetadataAuthorArgs', 'MetadataAuthorArgsDict']] author: An `author` blocks as defined below.
        :param pulumi.Input[Union['MetadataCategoryArgs', 'MetadataCategoryArgsDict']] category: A `category` block as defined below.
        :param pulumi.Input[builtins.str] content_id: The ID of the content. Used to identify dependencies and content from solutions or community.
        :param pulumi.Input[builtins.str] content_schema_version: Schema version of the content. Can be used to distinguish between flow based on the schema version.
        :param pulumi.Input[builtins.str] custom_version: The Custom version of the content.
        :param pulumi.Input[builtins.str] dependency: A JSON formatted `dependency` block as defined below. Dependency for the content item, what other content items it requires to work.
        :param pulumi.Input[builtins.str] first_publish_date: The first publish date of solution content item.
        :param pulumi.Input[builtins.str] icon_id: The ID of the icon, this id can be fetched from the solution template.
        :param pulumi.Input[builtins.str] kind: The kind of content the metadata is for. Possible values are `AnalyticsRule`, `AnalyticsRuleTemplate`, `AutomationRule`, `AzureFunction`, `DataConnector`, `DataType`, `HuntingQuery`, `InvestigationQuery`, `LogicAppsCustomConnector`, `Parser`, `Playbook`, `PlaybookTemplate`, `Solution`, `Watchlist`, `WatchlistTemplate`, `Workbook` and `WorkbookTemplate`.
        :param pulumi.Input[builtins.str] last_publish_date: The last publish date of solution content item.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Sentinel Metadata. Changing this forces a new Sentinel Metadata to be created.
        :param pulumi.Input[builtins.str] parent_id: The ID of the parent resource ID of the content item, which the metadata belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] preview_images: Specifies a list of preview image file names. These will be taken from solution artifacts.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] preview_images_darks: Specifies a list of preview image file names used for dark theme. These will be taken from solution artifacts.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] providers: Specifies a list of providers for the solution content item.
        :param pulumi.Input[Union['MetadataSourceArgs', 'MetadataSourceArgsDict']] source: A `source` block as defined below.
        :param pulumi.Input[Union['MetadataSupportArgs', 'MetadataSupportArgsDict']] support: A `support` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] threat_analysis_tactics: Specifies a list of tactics the resource covers. Possible values are `Reconnaissance`, `ResourceDevelopment`, `InitialAccess`, `Execution`, `Persistence`, `PrivilegeEscalation`, `DefenseEvasion`, `CredentialAccess`, `Discovery`, `LateralMovement`, `Collection`, `CommandAndControl`, `Exfiltration`, `Impact`, `ImpairProcessControl` and `InhibitResponseFunction`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] threat_analysis_techniques: Specifies a list of techniques the resource covers.
        :param pulumi.Input[builtins.str] version: Version of the content.
        :param pulumi.Input[builtins.str] workspace_id: The ID of the Log Analytics Workspace. Changing this forces a new Sentinel Metadata to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MetadataState.__new__(_MetadataState)

        __props__.__dict__["author"] = author
        __props__.__dict__["category"] = category
        __props__.__dict__["content_id"] = content_id
        __props__.__dict__["content_schema_version"] = content_schema_version
        __props__.__dict__["custom_version"] = custom_version
        __props__.__dict__["dependency"] = dependency
        __props__.__dict__["first_publish_date"] = first_publish_date
        __props__.__dict__["icon_id"] = icon_id
        __props__.__dict__["kind"] = kind
        __props__.__dict__["last_publish_date"] = last_publish_date
        __props__.__dict__["name"] = name
        __props__.__dict__["parent_id"] = parent_id
        __props__.__dict__["preview_images"] = preview_images
        __props__.__dict__["preview_images_darks"] = preview_images_darks
        __props__.__dict__["providers"] = providers
        __props__.__dict__["source"] = source
        __props__.__dict__["support"] = support
        __props__.__dict__["threat_analysis_tactics"] = threat_analysis_tactics
        __props__.__dict__["threat_analysis_techniques"] = threat_analysis_techniques
        __props__.__dict__["version"] = version
        __props__.__dict__["workspace_id"] = workspace_id
        return Metadata(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def author(self) -> pulumi.Output[Optional['outputs.MetadataAuthor']]:
        """
        An `author` blocks as defined below.
        """
        return pulumi.get(self, "author")

    @property
    @pulumi.getter
    def category(self) -> pulumi.Output[Optional['outputs.MetadataCategory']]:
        """
        A `category` block as defined below.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="contentId")
    def content_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the content. Used to identify dependencies and content from solutions or community.
        """
        return pulumi.get(self, "content_id")

    @property
    @pulumi.getter(name="contentSchemaVersion")
    def content_schema_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Schema version of the content. Can be used to distinguish between flow based on the schema version.
        """
        return pulumi.get(self, "content_schema_version")

    @property
    @pulumi.getter(name="customVersion")
    def custom_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Custom version of the content.
        """
        return pulumi.get(self, "custom_version")

    @property
    @pulumi.getter
    def dependency(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A JSON formatted `dependency` block as defined below. Dependency for the content item, what other content items it requires to work.
        """
        return pulumi.get(self, "dependency")

    @property
    @pulumi.getter(name="firstPublishDate")
    def first_publish_date(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The first publish date of solution content item.
        """
        return pulumi.get(self, "first_publish_date")

    @property
    @pulumi.getter(name="iconId")
    def icon_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the icon, this id can be fetched from the solution template.
        """
        return pulumi.get(self, "icon_id")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[builtins.str]:
        """
        The kind of content the metadata is for. Possible values are `AnalyticsRule`, `AnalyticsRuleTemplate`, `AutomationRule`, `AzureFunction`, `DataConnector`, `DataType`, `HuntingQuery`, `InvestigationQuery`, `LogicAppsCustomConnector`, `Parser`, `Playbook`, `PlaybookTemplate`, `Solution`, `Watchlist`, `WatchlistTemplate`, `Workbook` and `WorkbookTemplate`.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="lastPublishDate")
    def last_publish_date(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The last publish date of solution content item.
        """
        return pulumi.get(self, "last_publish_date")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Sentinel Metadata. Changing this forces a new Sentinel Metadata to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the parent resource ID of the content item, which the metadata belongs to.
        """
        return pulumi.get(self, "parent_id")

    @property
    @pulumi.getter(name="previewImages")
    def preview_images(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Specifies a list of preview image file names. These will be taken from solution artifacts.
        """
        return pulumi.get(self, "preview_images")

    @property
    @pulumi.getter(name="previewImagesDarks")
    def preview_images_darks(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Specifies a list of preview image file names used for dark theme. These will be taken from solution artifacts.
        """
        return pulumi.get(self, "preview_images_darks")

    @property
    @pulumi.getter
    def providers(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Specifies a list of providers for the solution content item.
        """
        return pulumi.get(self, "providers")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output['outputs.MetadataSource']:
        """
        A `source` block as defined below.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def support(self) -> pulumi.Output[Optional['outputs.MetadataSupport']]:
        """
        A `support` block as defined below.
        """
        return pulumi.get(self, "support")

    @property
    @pulumi.getter(name="threatAnalysisTactics")
    def threat_analysis_tactics(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Specifies a list of tactics the resource covers. Possible values are `Reconnaissance`, `ResourceDevelopment`, `InitialAccess`, `Execution`, `Persistence`, `PrivilegeEscalation`, `DefenseEvasion`, `CredentialAccess`, `Discovery`, `LateralMovement`, `Collection`, `CommandAndControl`, `Exfiltration`, `Impact`, `ImpairProcessControl` and `InhibitResponseFunction`.
        """
        return pulumi.get(self, "threat_analysis_tactics")

    @property
    @pulumi.getter(name="threatAnalysisTechniques")
    def threat_analysis_techniques(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Specifies a list of techniques the resource covers.
        """
        return pulumi.get(self, "threat_analysis_techniques")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Version of the content.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Log Analytics Workspace. Changing this forces a new Sentinel Metadata to be created.
        """
        return pulumi.get(self, "workspace_id")

