# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ThreatIntelligenceIndicatorArgs', 'ThreatIntelligenceIndicator']

@pulumi.input_type
class ThreatIntelligenceIndicatorArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 pattern: pulumi.Input[builtins.str],
                 pattern_type: pulumi.Input[builtins.str],
                 source: pulumi.Input[builtins.str],
                 validate_from_utc: pulumi.Input[builtins.str],
                 workspace_id: pulumi.Input[builtins.str],
                 confidence: Optional[pulumi.Input[builtins.int]] = None,
                 created_by: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 extension: Optional[pulumi.Input[builtins.str]] = None,
                 external_references: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorExternalReferenceArgs']]]] = None,
                 granular_markings: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorGranularMarkingArgs']]]] = None,
                 kill_chain_phases: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorKillChainPhaseArgs']]]] = None,
                 language: Optional[pulumi.Input[builtins.str]] = None,
                 object_marking_refs: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 pattern_version: Optional[pulumi.Input[builtins.str]] = None,
                 revoked: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 threat_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 validate_until_utc: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ThreatIntelligenceIndicator resource.
        :param pulumi.Input[builtins.str] display_name: The display name of the Threat Intelligence Indicator.
        :param pulumi.Input[builtins.str] pattern: The pattern used by the Threat Intelligence Indicator. When `pattern_type` set to `file`, `pattern` must be specified with `<HashName>:<Value>` format, such as `MD5:78ecc5c05cd8b79af480df2f8fba0b9d`.
        :param pulumi.Input[builtins.str] pattern_type: The type of pattern used by the Threat Intelligence Indicator. Possible values are `domain-name`, `file`, `ipv4-addr`, `ipv6-addr` and `url`.
        :param pulumi.Input[builtins.str] source: Source of the Threat Intelligence Indicator. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] validate_from_utc: The start of validate date in RFC3339.
        :param pulumi.Input[builtins.str] workspace_id: The ID of the Log Analytics Workspace. Changing this forces a new Sentinel Threat Intelligence Indicator to be created.
        :param pulumi.Input[builtins.int] confidence: Confidence levels of the Threat Intelligence Indicator.
        :param pulumi.Input[builtins.str] created_by: The creator of the Threat Intelligence Indicator.
        :param pulumi.Input[builtins.str] description: The description of the Threat Intelligence Indicator.
        :param pulumi.Input[builtins.str] extension: The extension config of the Threat Intelligence Indicator in JSON format.
        :param pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorExternalReferenceArgs']]] external_references: One or more `external_reference` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorGranularMarkingArgs']]] granular_markings: One or more `granular_marking` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorKillChainPhaseArgs']]] kill_chain_phases: One or more `kill_chain_phase` blocks as defined below.
        :param pulumi.Input[builtins.str] language: The language of the Threat Intelligence Indicator.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] object_marking_refs: Specifies a list of Threat Intelligence marking references.
        :param pulumi.Input[builtins.str] pattern_version: The version of a Threat Intelligence entity.
        :param pulumi.Input[builtins.bool] revoked: Whether the Threat Intelligence entity revoked.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Specifies a list of tags of the Threat Intelligence Indicator.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] threat_types: Specifies a list of threat types of this Threat Intelligence Indicator.
        :param pulumi.Input[builtins.str] validate_until_utc: The end of validate date of the Threat Intelligence Indicator in RFC3339 format.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "pattern", pattern)
        pulumi.set(__self__, "pattern_type", pattern_type)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "validate_from_utc", validate_from_utc)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if confidence is not None:
            pulumi.set(__self__, "confidence", confidence)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if external_references is not None:
            pulumi.set(__self__, "external_references", external_references)
        if granular_markings is not None:
            pulumi.set(__self__, "granular_markings", granular_markings)
        if kill_chain_phases is not None:
            pulumi.set(__self__, "kill_chain_phases", kill_chain_phases)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if object_marking_refs is not None:
            pulumi.set(__self__, "object_marking_refs", object_marking_refs)
        if pattern_version is not None:
            pulumi.set(__self__, "pattern_version", pattern_version)
        if revoked is not None:
            pulumi.set(__self__, "revoked", revoked)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if threat_types is not None:
            pulumi.set(__self__, "threat_types", threat_types)
        if validate_until_utc is not None:
            pulumi.set(__self__, "validate_until_utc", validate_until_utc)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The display name of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def pattern(self) -> pulumi.Input[builtins.str]:
        """
        The pattern used by the Threat Intelligence Indicator. When `pattern_type` set to `file`, `pattern` must be specified with `<HashName>:<Value>` format, such as `MD5:78ecc5c05cd8b79af480df2f8fba0b9d`.
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "pattern", value)

    @property
    @pulumi.getter(name="patternType")
    def pattern_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of pattern used by the Threat Intelligence Indicator. Possible values are `domain-name`, `file`, `ipv4-addr`, `ipv6-addr` and `url`.
        """
        return pulumi.get(self, "pattern_type")

    @pattern_type.setter
    def pattern_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "pattern_type", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[builtins.str]:
        """
        Source of the Threat Intelligence Indicator. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="validateFromUtc")
    def validate_from_utc(self) -> pulumi.Input[builtins.str]:
        """
        The start of validate date in RFC3339.
        """
        return pulumi.get(self, "validate_from_utc")

    @validate_from_utc.setter
    def validate_from_utc(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "validate_from_utc", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Log Analytics Workspace. Changing this forces a new Sentinel Threat Intelligence Indicator to be created.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "workspace_id", value)

    @property
    @pulumi.getter
    def confidence(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Confidence levels of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "confidence")

    @confidence.setter
    def confidence(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "confidence", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The creator of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def extension(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The extension config of the Threat Intelligence Indicator in JSON format.
        """
        return pulumi.get(self, "extension")

    @extension.setter
    def extension(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "extension", value)

    @property
    @pulumi.getter(name="externalReferences")
    def external_references(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorExternalReferenceArgs']]]]:
        """
        One or more `external_reference` blocks as defined below.
        """
        return pulumi.get(self, "external_references")

    @external_references.setter
    def external_references(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorExternalReferenceArgs']]]]):
        pulumi.set(self, "external_references", value)

    @property
    @pulumi.getter(name="granularMarkings")
    def granular_markings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorGranularMarkingArgs']]]]:
        """
        One or more `granular_marking` blocks as defined below.
        """
        return pulumi.get(self, "granular_markings")

    @granular_markings.setter
    def granular_markings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorGranularMarkingArgs']]]]):
        pulumi.set(self, "granular_markings", value)

    @property
    @pulumi.getter(name="killChainPhases")
    def kill_chain_phases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorKillChainPhaseArgs']]]]:
        """
        One or more `kill_chain_phase` blocks as defined below.
        """
        return pulumi.get(self, "kill_chain_phases")

    @kill_chain_phases.setter
    def kill_chain_phases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorKillChainPhaseArgs']]]]):
        pulumi.set(self, "kill_chain_phases", value)

    @property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The language of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter(name="objectMarkingRefs")
    def object_marking_refs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of Threat Intelligence marking references.
        """
        return pulumi.get(self, "object_marking_refs")

    @object_marking_refs.setter
    def object_marking_refs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "object_marking_refs", value)

    @property
    @pulumi.getter(name="patternVersion")
    def pattern_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of a Threat Intelligence entity.
        """
        return pulumi.get(self, "pattern_version")

    @pattern_version.setter
    def pattern_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pattern_version", value)

    @property
    @pulumi.getter
    def revoked(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the Threat Intelligence entity revoked.
        """
        return pulumi.get(self, "revoked")

    @revoked.setter
    def revoked(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "revoked", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of tags of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="threatTypes")
    def threat_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of threat types of this Threat Intelligence Indicator.
        """
        return pulumi.get(self, "threat_types")

    @threat_types.setter
    def threat_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "threat_types", value)

    @property
    @pulumi.getter(name="validateUntilUtc")
    def validate_until_utc(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The end of validate date of the Threat Intelligence Indicator in RFC3339 format.
        """
        return pulumi.get(self, "validate_until_utc")

    @validate_until_utc.setter
    def validate_until_utc(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "validate_until_utc", value)


@pulumi.input_type
class _ThreatIntelligenceIndicatorState:
    def __init__(__self__, *,
                 confidence: Optional[pulumi.Input[builtins.int]] = None,
                 created_by: Optional[pulumi.Input[builtins.str]] = None,
                 created_on: Optional[pulumi.Input[builtins.str]] = None,
                 defanged: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 extension: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 external_last_updated_time_utc: Optional[pulumi.Input[builtins.str]] = None,
                 external_references: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorExternalReferenceArgs']]]] = None,
                 granular_markings: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorGranularMarkingArgs']]]] = None,
                 guid: Optional[pulumi.Input[builtins.str]] = None,
                 indicator_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 kill_chain_phases: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorKillChainPhaseArgs']]]] = None,
                 language: Optional[pulumi.Input[builtins.str]] = None,
                 last_updated_time_utc: Optional[pulumi.Input[builtins.str]] = None,
                 object_marking_refs: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 parsed_patterns: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorParsedPatternArgs']]]] = None,
                 pattern: Optional[pulumi.Input[builtins.str]] = None,
                 pattern_type: Optional[pulumi.Input[builtins.str]] = None,
                 pattern_version: Optional[pulumi.Input[builtins.str]] = None,
                 revoked: Optional[pulumi.Input[builtins.bool]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 threat_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 validate_from_utc: Optional[pulumi.Input[builtins.str]] = None,
                 validate_until_utc: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ThreatIntelligenceIndicator resources.
        :param pulumi.Input[builtins.int] confidence: Confidence levels of the Threat Intelligence Indicator.
        :param pulumi.Input[builtins.str] created_by: The creator of the Threat Intelligence Indicator.
        :param pulumi.Input[builtins.str] created_on: The date of this Threat Intelligence Indicator created.
        :param pulumi.Input[builtins.bool] defanged: Whether the Threat Intelligence entity is defanged?
        :param pulumi.Input[builtins.str] description: The description of the Threat Intelligence Indicator.
        :param pulumi.Input[builtins.str] display_name: The display name of the Threat Intelligence Indicator.
        :param pulumi.Input[builtins.str] extension: The extension config of the Threat Intelligence Indicator in JSON format.
        :param pulumi.Input[builtins.str] external_id: The external ID of the Threat Intelligence Indicator.
        :param pulumi.Input[builtins.str] external_last_updated_time_utc: the External last updated time in UTC.
        :param pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorExternalReferenceArgs']]] external_references: One or more `external_reference` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorGranularMarkingArgs']]] granular_markings: One or more `granular_marking` blocks as defined below.
        :param pulumi.Input[builtins.str] guid: The guid of this Sentinel Threat Intelligence Indicator.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] indicator_types: A list of indicator types of this Threat Intelligence Indicator.
        :param pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorKillChainPhaseArgs']]] kill_chain_phases: One or more `kill_chain_phase` blocks as defined below.
        :param pulumi.Input[builtins.str] language: The language of the Threat Intelligence Indicator.
        :param pulumi.Input[builtins.str] last_updated_time_utc: The last updated time of the Threat Intelligence Indicator in UTC.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] object_marking_refs: Specifies a list of Threat Intelligence marking references.
        :param pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorParsedPatternArgs']]] parsed_patterns: A `parsed_pattern` block as defined below.
        :param pulumi.Input[builtins.str] pattern: The pattern used by the Threat Intelligence Indicator. When `pattern_type` set to `file`, `pattern` must be specified with `<HashName>:<Value>` format, such as `MD5:78ecc5c05cd8b79af480df2f8fba0b9d`.
        :param pulumi.Input[builtins.str] pattern_type: The type of pattern used by the Threat Intelligence Indicator. Possible values are `domain-name`, `file`, `ipv4-addr`, `ipv6-addr` and `url`.
        :param pulumi.Input[builtins.str] pattern_version: The version of a Threat Intelligence entity.
        :param pulumi.Input[builtins.bool] revoked: Whether the Threat Intelligence entity revoked.
        :param pulumi.Input[builtins.str] source: Source of the Threat Intelligence Indicator. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Specifies a list of tags of the Threat Intelligence Indicator.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] threat_types: Specifies a list of threat types of this Threat Intelligence Indicator.
        :param pulumi.Input[builtins.str] validate_from_utc: The start of validate date in RFC3339.
        :param pulumi.Input[builtins.str] validate_until_utc: The end of validate date of the Threat Intelligence Indicator in RFC3339 format.
        :param pulumi.Input[builtins.str] workspace_id: The ID of the Log Analytics Workspace. Changing this forces a new Sentinel Threat Intelligence Indicator to be created.
        """
        if confidence is not None:
            pulumi.set(__self__, "confidence", confidence)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if defanged is not None:
            pulumi.set(__self__, "defanged", defanged)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if external_last_updated_time_utc is not None:
            pulumi.set(__self__, "external_last_updated_time_utc", external_last_updated_time_utc)
        if external_references is not None:
            pulumi.set(__self__, "external_references", external_references)
        if granular_markings is not None:
            pulumi.set(__self__, "granular_markings", granular_markings)
        if guid is not None:
            pulumi.set(__self__, "guid", guid)
        if indicator_types is not None:
            pulumi.set(__self__, "indicator_types", indicator_types)
        if kill_chain_phases is not None:
            pulumi.set(__self__, "kill_chain_phases", kill_chain_phases)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if last_updated_time_utc is not None:
            pulumi.set(__self__, "last_updated_time_utc", last_updated_time_utc)
        if object_marking_refs is not None:
            pulumi.set(__self__, "object_marking_refs", object_marking_refs)
        if parsed_patterns is not None:
            pulumi.set(__self__, "parsed_patterns", parsed_patterns)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if pattern_type is not None:
            pulumi.set(__self__, "pattern_type", pattern_type)
        if pattern_version is not None:
            pulumi.set(__self__, "pattern_version", pattern_version)
        if revoked is not None:
            pulumi.set(__self__, "revoked", revoked)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if threat_types is not None:
            pulumi.set(__self__, "threat_types", threat_types)
        if validate_from_utc is not None:
            pulumi.set(__self__, "validate_from_utc", validate_from_utc)
        if validate_until_utc is not None:
            pulumi.set(__self__, "validate_until_utc", validate_until_utc)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter
    def confidence(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Confidence levels of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "confidence")

    @confidence.setter
    def confidence(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "confidence", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The creator of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date of this Threat Intelligence Indicator created.
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_on", value)

    @property
    @pulumi.getter
    def defanged(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the Threat Intelligence entity is defanged?
        """
        return pulumi.get(self, "defanged")

    @defanged.setter
    def defanged(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "defanged", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The display name of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def extension(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The extension config of the Threat Intelligence Indicator in JSON format.
        """
        return pulumi.get(self, "extension")

    @extension.setter
    def extension(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "extension", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The external ID of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="externalLastUpdatedTimeUtc")
    def external_last_updated_time_utc(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        the External last updated time in UTC.
        """
        return pulumi.get(self, "external_last_updated_time_utc")

    @external_last_updated_time_utc.setter
    def external_last_updated_time_utc(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_last_updated_time_utc", value)

    @property
    @pulumi.getter(name="externalReferences")
    def external_references(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorExternalReferenceArgs']]]]:
        """
        One or more `external_reference` blocks as defined below.
        """
        return pulumi.get(self, "external_references")

    @external_references.setter
    def external_references(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorExternalReferenceArgs']]]]):
        pulumi.set(self, "external_references", value)

    @property
    @pulumi.getter(name="granularMarkings")
    def granular_markings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorGranularMarkingArgs']]]]:
        """
        One or more `granular_marking` blocks as defined below.
        """
        return pulumi.get(self, "granular_markings")

    @granular_markings.setter
    def granular_markings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorGranularMarkingArgs']]]]):
        pulumi.set(self, "granular_markings", value)

    @property
    @pulumi.getter
    def guid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The guid of this Sentinel Threat Intelligence Indicator.
        """
        return pulumi.get(self, "guid")

    @guid.setter
    def guid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "guid", value)

    @property
    @pulumi.getter(name="indicatorTypes")
    def indicator_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of indicator types of this Threat Intelligence Indicator.
        """
        return pulumi.get(self, "indicator_types")

    @indicator_types.setter
    def indicator_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "indicator_types", value)

    @property
    @pulumi.getter(name="killChainPhases")
    def kill_chain_phases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorKillChainPhaseArgs']]]]:
        """
        One or more `kill_chain_phase` blocks as defined below.
        """
        return pulumi.get(self, "kill_chain_phases")

    @kill_chain_phases.setter
    def kill_chain_phases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorKillChainPhaseArgs']]]]):
        pulumi.set(self, "kill_chain_phases", value)

    @property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The language of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter(name="lastUpdatedTimeUtc")
    def last_updated_time_utc(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The last updated time of the Threat Intelligence Indicator in UTC.
        """
        return pulumi.get(self, "last_updated_time_utc")

    @last_updated_time_utc.setter
    def last_updated_time_utc(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_updated_time_utc", value)

    @property
    @pulumi.getter(name="objectMarkingRefs")
    def object_marking_refs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of Threat Intelligence marking references.
        """
        return pulumi.get(self, "object_marking_refs")

    @object_marking_refs.setter
    def object_marking_refs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "object_marking_refs", value)

    @property
    @pulumi.getter(name="parsedPatterns")
    def parsed_patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorParsedPatternArgs']]]]:
        """
        A `parsed_pattern` block as defined below.
        """
        return pulumi.get(self, "parsed_patterns")

    @parsed_patterns.setter
    def parsed_patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorParsedPatternArgs']]]]):
        pulumi.set(self, "parsed_patterns", value)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The pattern used by the Threat Intelligence Indicator. When `pattern_type` set to `file`, `pattern` must be specified with `<HashName>:<Value>` format, such as `MD5:78ecc5c05cd8b79af480df2f8fba0b9d`.
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pattern", value)

    @property
    @pulumi.getter(name="patternType")
    def pattern_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of pattern used by the Threat Intelligence Indicator. Possible values are `domain-name`, `file`, `ipv4-addr`, `ipv6-addr` and `url`.
        """
        return pulumi.get(self, "pattern_type")

    @pattern_type.setter
    def pattern_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pattern_type", value)

    @property
    @pulumi.getter(name="patternVersion")
    def pattern_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of a Threat Intelligence entity.
        """
        return pulumi.get(self, "pattern_version")

    @pattern_version.setter
    def pattern_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pattern_version", value)

    @property
    @pulumi.getter
    def revoked(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the Threat Intelligence entity revoked.
        """
        return pulumi.get(self, "revoked")

    @revoked.setter
    def revoked(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "revoked", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Source of the Threat Intelligence Indicator. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of tags of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="threatTypes")
    def threat_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of threat types of this Threat Intelligence Indicator.
        """
        return pulumi.get(self, "threat_types")

    @threat_types.setter
    def threat_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "threat_types", value)

    @property
    @pulumi.getter(name="validateFromUtc")
    def validate_from_utc(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The start of validate date in RFC3339.
        """
        return pulumi.get(self, "validate_from_utc")

    @validate_from_utc.setter
    def validate_from_utc(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "validate_from_utc", value)

    @property
    @pulumi.getter(name="validateUntilUtc")
    def validate_until_utc(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The end of validate date of the Threat Intelligence Indicator in RFC3339 format.
        """
        return pulumi.get(self, "validate_until_utc")

    @validate_until_utc.setter
    def validate_until_utc(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "validate_until_utc", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Log Analytics Workspace. Changing this forces a new Sentinel Threat Intelligence Indicator to be created.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("azure:sentinel/threatIntelligenceIndicator:ThreatIntelligenceIndicator")
class ThreatIntelligenceIndicator(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 confidence: Optional[pulumi.Input[builtins.int]] = None,
                 created_by: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 extension: Optional[pulumi.Input[builtins.str]] = None,
                 external_references: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorExternalReferenceArgs', 'ThreatIntelligenceIndicatorExternalReferenceArgsDict']]]]] = None,
                 granular_markings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorGranularMarkingArgs', 'ThreatIntelligenceIndicatorGranularMarkingArgsDict']]]]] = None,
                 kill_chain_phases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorKillChainPhaseArgs', 'ThreatIntelligenceIndicatorKillChainPhaseArgsDict']]]]] = None,
                 language: Optional[pulumi.Input[builtins.str]] = None,
                 object_marking_refs: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 pattern: Optional[pulumi.Input[builtins.str]] = None,
                 pattern_type: Optional[pulumi.Input[builtins.str]] = None,
                 pattern_version: Optional[pulumi.Input[builtins.str]] = None,
                 revoked: Optional[pulumi.Input[builtins.bool]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 threat_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 validate_from_utc: Optional[pulumi.Input[builtins.str]] = None,
                 validate_until_utc: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Sentinel Threat Intelligence Indicator.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="east us")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example-law",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018",
            retention_in_days=30)
        example_log_analytics_workspace_onboarding = azure.sentinel.LogAnalyticsWorkspaceOnboarding("example", workspace_id=example_analytics_workspace.id)
        example_threat_intelligence_indicator = azure.sentinel.ThreatIntelligenceIndicator("example",
            workspace_id=example_log_analytics_workspace_onboarding.workspace_id,
            pattern_type="domain-name",
            pattern="http://example.com",
            source="Microsoft Sentinel",
            validate_from_utc="2022-12-14T16:00:00Z",
            display_name="example-indicator")
        ```

        ## Import

        Sentinel Threat Intelligence Indicators can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:sentinel/threatIntelligenceIndicator:ThreatIntelligenceIndicator example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourcegroup1/providers/Microsoft.OperationalInsights/workspaces/workspace1/providers/Microsoft.SecurityInsights/threatIntelligence/main/indicators/indicator1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] confidence: Confidence levels of the Threat Intelligence Indicator.
        :param pulumi.Input[builtins.str] created_by: The creator of the Threat Intelligence Indicator.
        :param pulumi.Input[builtins.str] description: The description of the Threat Intelligence Indicator.
        :param pulumi.Input[builtins.str] display_name: The display name of the Threat Intelligence Indicator.
        :param pulumi.Input[builtins.str] extension: The extension config of the Threat Intelligence Indicator in JSON format.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorExternalReferenceArgs', 'ThreatIntelligenceIndicatorExternalReferenceArgsDict']]]] external_references: One or more `external_reference` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorGranularMarkingArgs', 'ThreatIntelligenceIndicatorGranularMarkingArgsDict']]]] granular_markings: One or more `granular_marking` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorKillChainPhaseArgs', 'ThreatIntelligenceIndicatorKillChainPhaseArgsDict']]]] kill_chain_phases: One or more `kill_chain_phase` blocks as defined below.
        :param pulumi.Input[builtins.str] language: The language of the Threat Intelligence Indicator.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] object_marking_refs: Specifies a list of Threat Intelligence marking references.
        :param pulumi.Input[builtins.str] pattern: The pattern used by the Threat Intelligence Indicator. When `pattern_type` set to `file`, `pattern` must be specified with `<HashName>:<Value>` format, such as `MD5:78ecc5c05cd8b79af480df2f8fba0b9d`.
        :param pulumi.Input[builtins.str] pattern_type: The type of pattern used by the Threat Intelligence Indicator. Possible values are `domain-name`, `file`, `ipv4-addr`, `ipv6-addr` and `url`.
        :param pulumi.Input[builtins.str] pattern_version: The version of a Threat Intelligence entity.
        :param pulumi.Input[builtins.bool] revoked: Whether the Threat Intelligence entity revoked.
        :param pulumi.Input[builtins.str] source: Source of the Threat Intelligence Indicator. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Specifies a list of tags of the Threat Intelligence Indicator.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] threat_types: Specifies a list of threat types of this Threat Intelligence Indicator.
        :param pulumi.Input[builtins.str] validate_from_utc: The start of validate date in RFC3339.
        :param pulumi.Input[builtins.str] validate_until_utc: The end of validate date of the Threat Intelligence Indicator in RFC3339 format.
        :param pulumi.Input[builtins.str] workspace_id: The ID of the Log Analytics Workspace. Changing this forces a new Sentinel Threat Intelligence Indicator to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ThreatIntelligenceIndicatorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Sentinel Threat Intelligence Indicator.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="east us")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example-law",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018",
            retention_in_days=30)
        example_log_analytics_workspace_onboarding = azure.sentinel.LogAnalyticsWorkspaceOnboarding("example", workspace_id=example_analytics_workspace.id)
        example_threat_intelligence_indicator = azure.sentinel.ThreatIntelligenceIndicator("example",
            workspace_id=example_log_analytics_workspace_onboarding.workspace_id,
            pattern_type="domain-name",
            pattern="http://example.com",
            source="Microsoft Sentinel",
            validate_from_utc="2022-12-14T16:00:00Z",
            display_name="example-indicator")
        ```

        ## Import

        Sentinel Threat Intelligence Indicators can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:sentinel/threatIntelligenceIndicator:ThreatIntelligenceIndicator example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourcegroup1/providers/Microsoft.OperationalInsights/workspaces/workspace1/providers/Microsoft.SecurityInsights/threatIntelligence/main/indicators/indicator1
        ```

        :param str resource_name: The name of the resource.
        :param ThreatIntelligenceIndicatorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ThreatIntelligenceIndicatorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 confidence: Optional[pulumi.Input[builtins.int]] = None,
                 created_by: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 extension: Optional[pulumi.Input[builtins.str]] = None,
                 external_references: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorExternalReferenceArgs', 'ThreatIntelligenceIndicatorExternalReferenceArgsDict']]]]] = None,
                 granular_markings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorGranularMarkingArgs', 'ThreatIntelligenceIndicatorGranularMarkingArgsDict']]]]] = None,
                 kill_chain_phases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorKillChainPhaseArgs', 'ThreatIntelligenceIndicatorKillChainPhaseArgsDict']]]]] = None,
                 language: Optional[pulumi.Input[builtins.str]] = None,
                 object_marking_refs: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 pattern: Optional[pulumi.Input[builtins.str]] = None,
                 pattern_type: Optional[pulumi.Input[builtins.str]] = None,
                 pattern_version: Optional[pulumi.Input[builtins.str]] = None,
                 revoked: Optional[pulumi.Input[builtins.bool]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 threat_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 validate_from_utc: Optional[pulumi.Input[builtins.str]] = None,
                 validate_until_utc: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ThreatIntelligenceIndicatorArgs.__new__(ThreatIntelligenceIndicatorArgs)

            __props__.__dict__["confidence"] = confidence
            __props__.__dict__["created_by"] = created_by
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["extension"] = extension
            __props__.__dict__["external_references"] = external_references
            __props__.__dict__["granular_markings"] = granular_markings
            __props__.__dict__["kill_chain_phases"] = kill_chain_phases
            __props__.__dict__["language"] = language
            __props__.__dict__["object_marking_refs"] = object_marking_refs
            if pattern is None and not opts.urn:
                raise TypeError("Missing required property 'pattern'")
            __props__.__dict__["pattern"] = pattern
            if pattern_type is None and not opts.urn:
                raise TypeError("Missing required property 'pattern_type'")
            __props__.__dict__["pattern_type"] = pattern_type
            __props__.__dict__["pattern_version"] = pattern_version
            __props__.__dict__["revoked"] = revoked
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["tags"] = tags
            __props__.__dict__["threat_types"] = threat_types
            if validate_from_utc is None and not opts.urn:
                raise TypeError("Missing required property 'validate_from_utc'")
            __props__.__dict__["validate_from_utc"] = validate_from_utc
            __props__.__dict__["validate_until_utc"] = validate_until_utc
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["created_on"] = None
            __props__.__dict__["defanged"] = None
            __props__.__dict__["external_id"] = None
            __props__.__dict__["external_last_updated_time_utc"] = None
            __props__.__dict__["guid"] = None
            __props__.__dict__["indicator_types"] = None
            __props__.__dict__["last_updated_time_utc"] = None
            __props__.__dict__["parsed_patterns"] = None
        super(ThreatIntelligenceIndicator, __self__).__init__(
            'azure:sentinel/threatIntelligenceIndicator:ThreatIntelligenceIndicator',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            confidence: Optional[pulumi.Input[builtins.int]] = None,
            created_by: Optional[pulumi.Input[builtins.str]] = None,
            created_on: Optional[pulumi.Input[builtins.str]] = None,
            defanged: Optional[pulumi.Input[builtins.bool]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            extension: Optional[pulumi.Input[builtins.str]] = None,
            external_id: Optional[pulumi.Input[builtins.str]] = None,
            external_last_updated_time_utc: Optional[pulumi.Input[builtins.str]] = None,
            external_references: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorExternalReferenceArgs', 'ThreatIntelligenceIndicatorExternalReferenceArgsDict']]]]] = None,
            granular_markings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorGranularMarkingArgs', 'ThreatIntelligenceIndicatorGranularMarkingArgsDict']]]]] = None,
            guid: Optional[pulumi.Input[builtins.str]] = None,
            indicator_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            kill_chain_phases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorKillChainPhaseArgs', 'ThreatIntelligenceIndicatorKillChainPhaseArgsDict']]]]] = None,
            language: Optional[pulumi.Input[builtins.str]] = None,
            last_updated_time_utc: Optional[pulumi.Input[builtins.str]] = None,
            object_marking_refs: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            parsed_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorParsedPatternArgs', 'ThreatIntelligenceIndicatorParsedPatternArgsDict']]]]] = None,
            pattern: Optional[pulumi.Input[builtins.str]] = None,
            pattern_type: Optional[pulumi.Input[builtins.str]] = None,
            pattern_version: Optional[pulumi.Input[builtins.str]] = None,
            revoked: Optional[pulumi.Input[builtins.bool]] = None,
            source: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            threat_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            validate_from_utc: Optional[pulumi.Input[builtins.str]] = None,
            validate_until_utc: Optional[pulumi.Input[builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ThreatIntelligenceIndicator':
        """
        Get an existing ThreatIntelligenceIndicator resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] confidence: Confidence levels of the Threat Intelligence Indicator.
        :param pulumi.Input[builtins.str] created_by: The creator of the Threat Intelligence Indicator.
        :param pulumi.Input[builtins.str] created_on: The date of this Threat Intelligence Indicator created.
        :param pulumi.Input[builtins.bool] defanged: Whether the Threat Intelligence entity is defanged?
        :param pulumi.Input[builtins.str] description: The description of the Threat Intelligence Indicator.
        :param pulumi.Input[builtins.str] display_name: The display name of the Threat Intelligence Indicator.
        :param pulumi.Input[builtins.str] extension: The extension config of the Threat Intelligence Indicator in JSON format.
        :param pulumi.Input[builtins.str] external_id: The external ID of the Threat Intelligence Indicator.
        :param pulumi.Input[builtins.str] external_last_updated_time_utc: the External last updated time in UTC.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorExternalReferenceArgs', 'ThreatIntelligenceIndicatorExternalReferenceArgsDict']]]] external_references: One or more `external_reference` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorGranularMarkingArgs', 'ThreatIntelligenceIndicatorGranularMarkingArgsDict']]]] granular_markings: One or more `granular_marking` blocks as defined below.
        :param pulumi.Input[builtins.str] guid: The guid of this Sentinel Threat Intelligence Indicator.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] indicator_types: A list of indicator types of this Threat Intelligence Indicator.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorKillChainPhaseArgs', 'ThreatIntelligenceIndicatorKillChainPhaseArgsDict']]]] kill_chain_phases: One or more `kill_chain_phase` blocks as defined below.
        :param pulumi.Input[builtins.str] language: The language of the Threat Intelligence Indicator.
        :param pulumi.Input[builtins.str] last_updated_time_utc: The last updated time of the Threat Intelligence Indicator in UTC.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] object_marking_refs: Specifies a list of Threat Intelligence marking references.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorParsedPatternArgs', 'ThreatIntelligenceIndicatorParsedPatternArgsDict']]]] parsed_patterns: A `parsed_pattern` block as defined below.
        :param pulumi.Input[builtins.str] pattern: The pattern used by the Threat Intelligence Indicator. When `pattern_type` set to `file`, `pattern` must be specified with `<HashName>:<Value>` format, such as `MD5:78ecc5c05cd8b79af480df2f8fba0b9d`.
        :param pulumi.Input[builtins.str] pattern_type: The type of pattern used by the Threat Intelligence Indicator. Possible values are `domain-name`, `file`, `ipv4-addr`, `ipv6-addr` and `url`.
        :param pulumi.Input[builtins.str] pattern_version: The version of a Threat Intelligence entity.
        :param pulumi.Input[builtins.bool] revoked: Whether the Threat Intelligence entity revoked.
        :param pulumi.Input[builtins.str] source: Source of the Threat Intelligence Indicator. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Specifies a list of tags of the Threat Intelligence Indicator.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] threat_types: Specifies a list of threat types of this Threat Intelligence Indicator.
        :param pulumi.Input[builtins.str] validate_from_utc: The start of validate date in RFC3339.
        :param pulumi.Input[builtins.str] validate_until_utc: The end of validate date of the Threat Intelligence Indicator in RFC3339 format.
        :param pulumi.Input[builtins.str] workspace_id: The ID of the Log Analytics Workspace. Changing this forces a new Sentinel Threat Intelligence Indicator to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ThreatIntelligenceIndicatorState.__new__(_ThreatIntelligenceIndicatorState)

        __props__.__dict__["confidence"] = confidence
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["defanged"] = defanged
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["extension"] = extension
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["external_last_updated_time_utc"] = external_last_updated_time_utc
        __props__.__dict__["external_references"] = external_references
        __props__.__dict__["granular_markings"] = granular_markings
        __props__.__dict__["guid"] = guid
        __props__.__dict__["indicator_types"] = indicator_types
        __props__.__dict__["kill_chain_phases"] = kill_chain_phases
        __props__.__dict__["language"] = language
        __props__.__dict__["last_updated_time_utc"] = last_updated_time_utc
        __props__.__dict__["object_marking_refs"] = object_marking_refs
        __props__.__dict__["parsed_patterns"] = parsed_patterns
        __props__.__dict__["pattern"] = pattern
        __props__.__dict__["pattern_type"] = pattern_type
        __props__.__dict__["pattern_version"] = pattern_version
        __props__.__dict__["revoked"] = revoked
        __props__.__dict__["source"] = source
        __props__.__dict__["tags"] = tags
        __props__.__dict__["threat_types"] = threat_types
        __props__.__dict__["validate_from_utc"] = validate_from_utc
        __props__.__dict__["validate_until_utc"] = validate_until_utc
        __props__.__dict__["workspace_id"] = workspace_id
        return ThreatIntelligenceIndicator(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def confidence(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Confidence levels of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "confidence")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The creator of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[builtins.str]:
        """
        The date of this Threat Intelligence Indicator created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter
    def defanged(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the Threat Intelligence entity is defanged?
        """
        return pulumi.get(self, "defanged")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The display name of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def extension(self) -> pulumi.Output[builtins.str]:
        """
        The extension config of the Threat Intelligence Indicator in JSON format.
        """
        return pulumi.get(self, "extension")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[builtins.str]:
        """
        The external ID of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="externalLastUpdatedTimeUtc")
    def external_last_updated_time_utc(self) -> pulumi.Output[builtins.str]:
        """
        the External last updated time in UTC.
        """
        return pulumi.get(self, "external_last_updated_time_utc")

    @property
    @pulumi.getter(name="externalReferences")
    def external_references(self) -> pulumi.Output[Optional[Sequence['outputs.ThreatIntelligenceIndicatorExternalReference']]]:
        """
        One or more `external_reference` blocks as defined below.
        """
        return pulumi.get(self, "external_references")

    @property
    @pulumi.getter(name="granularMarkings")
    def granular_markings(self) -> pulumi.Output[Optional[Sequence['outputs.ThreatIntelligenceIndicatorGranularMarking']]]:
        """
        One or more `granular_marking` blocks as defined below.
        """
        return pulumi.get(self, "granular_markings")

    @property
    @pulumi.getter
    def guid(self) -> pulumi.Output[builtins.str]:
        """
        The guid of this Sentinel Threat Intelligence Indicator.
        """
        return pulumi.get(self, "guid")

    @property
    @pulumi.getter(name="indicatorTypes")
    def indicator_types(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of indicator types of this Threat Intelligence Indicator.
        """
        return pulumi.get(self, "indicator_types")

    @property
    @pulumi.getter(name="killChainPhases")
    def kill_chain_phases(self) -> pulumi.Output[Optional[Sequence['outputs.ThreatIntelligenceIndicatorKillChainPhase']]]:
        """
        One or more `kill_chain_phase` blocks as defined below.
        """
        return pulumi.get(self, "kill_chain_phases")

    @property
    @pulumi.getter
    def language(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The language of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter(name="lastUpdatedTimeUtc")
    def last_updated_time_utc(self) -> pulumi.Output[builtins.str]:
        """
        The last updated time of the Threat Intelligence Indicator in UTC.
        """
        return pulumi.get(self, "last_updated_time_utc")

    @property
    @pulumi.getter(name="objectMarkingRefs")
    def object_marking_refs(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Specifies a list of Threat Intelligence marking references.
        """
        return pulumi.get(self, "object_marking_refs")

    @property
    @pulumi.getter(name="parsedPatterns")
    def parsed_patterns(self) -> pulumi.Output[Sequence['outputs.ThreatIntelligenceIndicatorParsedPattern']]:
        """
        A `parsed_pattern` block as defined below.
        """
        return pulumi.get(self, "parsed_patterns")

    @property
    @pulumi.getter
    def pattern(self) -> pulumi.Output[builtins.str]:
        """
        The pattern used by the Threat Intelligence Indicator. When `pattern_type` set to `file`, `pattern` must be specified with `<HashName>:<Value>` format, such as `MD5:78ecc5c05cd8b79af480df2f8fba0b9d`.
        """
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter(name="patternType")
    def pattern_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of pattern used by the Threat Intelligence Indicator. Possible values are `domain-name`, `file`, `ipv4-addr`, `ipv6-addr` and `url`.
        """
        return pulumi.get(self, "pattern_type")

    @property
    @pulumi.getter(name="patternVersion")
    def pattern_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The version of a Threat Intelligence entity.
        """
        return pulumi.get(self, "pattern_version")

    @property
    @pulumi.getter
    def revoked(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the Threat Intelligence entity revoked.
        """
        return pulumi.get(self, "revoked")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[builtins.str]:
        """
        Source of the Threat Intelligence Indicator. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Specifies a list of tags of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="threatTypes")
    def threat_types(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Specifies a list of threat types of this Threat Intelligence Indicator.
        """
        return pulumi.get(self, "threat_types")

    @property
    @pulumi.getter(name="validateFromUtc")
    def validate_from_utc(self) -> pulumi.Output[builtins.str]:
        """
        The start of validate date in RFC3339.
        """
        return pulumi.get(self, "validate_from_utc")

    @property
    @pulumi.getter(name="validateUntilUtc")
    def validate_until_utc(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The end of validate date of the Threat Intelligence Indicator in RFC3339 format.
        """
        return pulumi.get(self, "validate_until_utc")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Log Analytics Workspace. Changing this forces a new Sentinel Threat Intelligence Indicator to be created.
        """
        return pulumi.get(self, "workspace_id")

