# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WatchlistArgs', 'Watchlist']

@pulumi.input_type
class WatchlistArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 item_search_key: pulumi.Input[builtins.str],
                 log_analytics_workspace_id: pulumi.Input[builtins.str],
                 default_duration: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Watchlist resource.
        :param pulumi.Input[builtins.str] display_name: The display name of this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        :param pulumi.Input[builtins.str] item_search_key: The key used to optimize query performance when using Watchlist for joins with other data. Changing this forces a new Sentinel Watchlist to be created.
        :param pulumi.Input[builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace where this Sentinel Watchlist resides in. Changing this forces a new Sentinel Watchlist to be created.
        :param pulumi.Input[builtins.str] default_duration: The default duration in ISO8601 duration form of this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        :param pulumi.Input[builtins.str] description: The description of this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] labels: Specifies a list of labels related to this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "item_search_key", item_search_key)
        pulumi.set(__self__, "log_analytics_workspace_id", log_analytics_workspace_id)
        if default_duration is not None:
            pulumi.set(__self__, "default_duration", default_duration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The display name of this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="itemSearchKey")
    def item_search_key(self) -> pulumi.Input[builtins.str]:
        """
        The key used to optimize query performance when using Watchlist for joins with other data. Changing this forces a new Sentinel Watchlist to be created.
        """
        return pulumi.get(self, "item_search_key")

    @item_search_key.setter
    def item_search_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "item_search_key", value)

    @property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Log Analytics Workspace where this Sentinel Watchlist resides in. Changing this forces a new Sentinel Watchlist to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @log_analytics_workspace_id.setter
    def log_analytics_workspace_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "log_analytics_workspace_id", value)

    @property
    @pulumi.getter(name="defaultDuration")
    def default_duration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The default duration in ISO8601 duration form of this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        """
        return pulumi.get(self, "default_duration")

    @default_duration.setter
    def default_duration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_duration", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of labels related to this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _WatchlistState:
    def __init__(__self__, *,
                 default_duration: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 item_search_key: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Watchlist resources.
        :param pulumi.Input[builtins.str] default_duration: The default duration in ISO8601 duration form of this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        :param pulumi.Input[builtins.str] description: The description of this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        :param pulumi.Input[builtins.str] display_name: The display name of this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        :param pulumi.Input[builtins.str] item_search_key: The key used to optimize query performance when using Watchlist for joins with other data. Changing this forces a new Sentinel Watchlist to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] labels: Specifies a list of labels related to this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        :param pulumi.Input[builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace where this Sentinel Watchlist resides in. Changing this forces a new Sentinel Watchlist to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        """
        if default_duration is not None:
            pulumi.set(__self__, "default_duration", default_duration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if item_search_key is not None:
            pulumi.set(__self__, "item_search_key", item_search_key)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if log_analytics_workspace_id is not None:
            pulumi.set(__self__, "log_analytics_workspace_id", log_analytics_workspace_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="defaultDuration")
    def default_duration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The default duration in ISO8601 duration form of this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        """
        return pulumi.get(self, "default_duration")

    @default_duration.setter
    def default_duration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_duration", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The display name of this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="itemSearchKey")
    def item_search_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The key used to optimize query performance when using Watchlist for joins with other data. Changing this forces a new Sentinel Watchlist to be created.
        """
        return pulumi.get(self, "item_search_key")

    @item_search_key.setter
    def item_search_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "item_search_key", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of labels related to this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Log Analytics Workspace where this Sentinel Watchlist resides in. Changing this forces a new Sentinel Watchlist to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @log_analytics_workspace_id.setter
    def log_analytics_workspace_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_analytics_workspace_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("azure:sentinel/watchlist:Watchlist")
class Watchlist(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_duration: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 item_search_key: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Sentinel Watchlist.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018")
        example_log_analytics_workspace_onboarding = azure.sentinel.LogAnalyticsWorkspaceOnboarding("example", workspace_id=example_analytics_workspace.id)
        example_watchlist = azure.sentinel.Watchlist("example",
            name="example-watchlist",
            log_analytics_workspace_id=example_log_analytics_workspace_onboarding.workspace_id,
            display_name="example-wl",
            item_search_key="Key")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.OperationalInsights`: 2022-11-01

        ## Import

        Sentinel Watchlists can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:sentinel/watchlist:Watchlist example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.OperationalInsights/workspaces/workspace1/providers/Microsoft.SecurityInsights/watchlists/list1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] default_duration: The default duration in ISO8601 duration form of this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        :param pulumi.Input[builtins.str] description: The description of this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        :param pulumi.Input[builtins.str] display_name: The display name of this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        :param pulumi.Input[builtins.str] item_search_key: The key used to optimize query performance when using Watchlist for joins with other data. Changing this forces a new Sentinel Watchlist to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] labels: Specifies a list of labels related to this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        :param pulumi.Input[builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace where this Sentinel Watchlist resides in. Changing this forces a new Sentinel Watchlist to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WatchlistArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Sentinel Watchlist.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018")
        example_log_analytics_workspace_onboarding = azure.sentinel.LogAnalyticsWorkspaceOnboarding("example", workspace_id=example_analytics_workspace.id)
        example_watchlist = azure.sentinel.Watchlist("example",
            name="example-watchlist",
            log_analytics_workspace_id=example_log_analytics_workspace_onboarding.workspace_id,
            display_name="example-wl",
            item_search_key="Key")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.OperationalInsights`: 2022-11-01

        ## Import

        Sentinel Watchlists can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:sentinel/watchlist:Watchlist example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.OperationalInsights/workspaces/workspace1/providers/Microsoft.SecurityInsights/watchlists/list1
        ```

        :param str resource_name: The name of the resource.
        :param WatchlistArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WatchlistArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_duration: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 item_search_key: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WatchlistArgs.__new__(WatchlistArgs)

            __props__.__dict__["default_duration"] = default_duration
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if item_search_key is None and not opts.urn:
                raise TypeError("Missing required property 'item_search_key'")
            __props__.__dict__["item_search_key"] = item_search_key
            __props__.__dict__["labels"] = labels
            if log_analytics_workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'log_analytics_workspace_id'")
            __props__.__dict__["log_analytics_workspace_id"] = log_analytics_workspace_id
            __props__.__dict__["name"] = name
        super(Watchlist, __self__).__init__(
            'azure:sentinel/watchlist:Watchlist',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_duration: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            item_search_key: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            log_analytics_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None) -> 'Watchlist':
        """
        Get an existing Watchlist resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] default_duration: The default duration in ISO8601 duration form of this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        :param pulumi.Input[builtins.str] description: The description of this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        :param pulumi.Input[builtins.str] display_name: The display name of this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        :param pulumi.Input[builtins.str] item_search_key: The key used to optimize query performance when using Watchlist for joins with other data. Changing this forces a new Sentinel Watchlist to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] labels: Specifies a list of labels related to this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        :param pulumi.Input[builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace where this Sentinel Watchlist resides in. Changing this forces a new Sentinel Watchlist to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WatchlistState.__new__(_WatchlistState)

        __props__.__dict__["default_duration"] = default_duration
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["item_search_key"] = item_search_key
        __props__.__dict__["labels"] = labels
        __props__.__dict__["log_analytics_workspace_id"] = log_analytics_workspace_id
        __props__.__dict__["name"] = name
        return Watchlist(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="defaultDuration")
    def default_duration(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The default duration in ISO8601 duration form of this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        """
        return pulumi.get(self, "default_duration")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The display name of this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="itemSearchKey")
    def item_search_key(self) -> pulumi.Output[builtins.str]:
        """
        The key used to optimize query performance when using Watchlist for joins with other data. Changing this forces a new Sentinel Watchlist to be created.
        """
        return pulumi.get(self, "item_search_key")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Specifies a list of labels related to this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Log Analytics Workspace where this Sentinel Watchlist resides in. Changing this forces a new Sentinel Watchlist to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Sentinel Watchlist. Changing this forces a new Sentinel Watchlist to be created.
        """
        return pulumi.get(self, "name")

