# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetQueueResult',
    'AwaitableGetQueueResult',
    'get_queue',
    'get_queue_output',
]

@pulumi.output_type
class GetQueueResult:
    """
    A collection of values returned by getQueue.
    """
    def __init__(__self__, auto_delete_on_idle=None, batched_operations_enabled=None, dead_lettering_on_message_expiration=None, default_message_ttl=None, duplicate_detection_history_time_window=None, enable_batched_operations=None, enable_express=None, enable_partitioning=None, express_enabled=None, forward_dead_lettered_messages_to=None, forward_to=None, id=None, lock_duration=None, max_delivery_count=None, max_size_in_megabytes=None, name=None, namespace_id=None, namespace_name=None, partitioning_enabled=None, requires_duplicate_detection=None, requires_session=None, resource_group_name=None, status=None):
        if auto_delete_on_idle and not isinstance(auto_delete_on_idle, str):
            raise TypeError("Expected argument 'auto_delete_on_idle' to be a str")
        pulumi.set(__self__, "auto_delete_on_idle", auto_delete_on_idle)
        if batched_operations_enabled and not isinstance(batched_operations_enabled, bool):
            raise TypeError("Expected argument 'batched_operations_enabled' to be a bool")
        pulumi.set(__self__, "batched_operations_enabled", batched_operations_enabled)
        if dead_lettering_on_message_expiration and not isinstance(dead_lettering_on_message_expiration, bool):
            raise TypeError("Expected argument 'dead_lettering_on_message_expiration' to be a bool")
        pulumi.set(__self__, "dead_lettering_on_message_expiration", dead_lettering_on_message_expiration)
        if default_message_ttl and not isinstance(default_message_ttl, str):
            raise TypeError("Expected argument 'default_message_ttl' to be a str")
        pulumi.set(__self__, "default_message_ttl", default_message_ttl)
        if duplicate_detection_history_time_window and not isinstance(duplicate_detection_history_time_window, str):
            raise TypeError("Expected argument 'duplicate_detection_history_time_window' to be a str")
        pulumi.set(__self__, "duplicate_detection_history_time_window", duplicate_detection_history_time_window)
        if enable_batched_operations and not isinstance(enable_batched_operations, bool):
            raise TypeError("Expected argument 'enable_batched_operations' to be a bool")
        pulumi.set(__self__, "enable_batched_operations", enable_batched_operations)
        if enable_express and not isinstance(enable_express, bool):
            raise TypeError("Expected argument 'enable_express' to be a bool")
        pulumi.set(__self__, "enable_express", enable_express)
        if enable_partitioning and not isinstance(enable_partitioning, bool):
            raise TypeError("Expected argument 'enable_partitioning' to be a bool")
        pulumi.set(__self__, "enable_partitioning", enable_partitioning)
        if express_enabled and not isinstance(express_enabled, bool):
            raise TypeError("Expected argument 'express_enabled' to be a bool")
        pulumi.set(__self__, "express_enabled", express_enabled)
        if forward_dead_lettered_messages_to and not isinstance(forward_dead_lettered_messages_to, str):
            raise TypeError("Expected argument 'forward_dead_lettered_messages_to' to be a str")
        pulumi.set(__self__, "forward_dead_lettered_messages_to", forward_dead_lettered_messages_to)
        if forward_to and not isinstance(forward_to, str):
            raise TypeError("Expected argument 'forward_to' to be a str")
        pulumi.set(__self__, "forward_to", forward_to)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lock_duration and not isinstance(lock_duration, str):
            raise TypeError("Expected argument 'lock_duration' to be a str")
        pulumi.set(__self__, "lock_duration", lock_duration)
        if max_delivery_count and not isinstance(max_delivery_count, int):
            raise TypeError("Expected argument 'max_delivery_count' to be a int")
        pulumi.set(__self__, "max_delivery_count", max_delivery_count)
        if max_size_in_megabytes and not isinstance(max_size_in_megabytes, int):
            raise TypeError("Expected argument 'max_size_in_megabytes' to be a int")
        pulumi.set(__self__, "max_size_in_megabytes", max_size_in_megabytes)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace_id and not isinstance(namespace_id, str):
            raise TypeError("Expected argument 'namespace_id' to be a str")
        pulumi.set(__self__, "namespace_id", namespace_id)
        if namespace_name and not isinstance(namespace_name, str):
            raise TypeError("Expected argument 'namespace_name' to be a str")
        pulumi.set(__self__, "namespace_name", namespace_name)
        if partitioning_enabled and not isinstance(partitioning_enabled, bool):
            raise TypeError("Expected argument 'partitioning_enabled' to be a bool")
        pulumi.set(__self__, "partitioning_enabled", partitioning_enabled)
        if requires_duplicate_detection and not isinstance(requires_duplicate_detection, bool):
            raise TypeError("Expected argument 'requires_duplicate_detection' to be a bool")
        pulumi.set(__self__, "requires_duplicate_detection", requires_duplicate_detection)
        if requires_session and not isinstance(requires_session, bool):
            raise TypeError("Expected argument 'requires_session' to be a bool")
        pulumi.set(__self__, "requires_session", requires_session)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="autoDeleteOnIdle")
    def auto_delete_on_idle(self) -> builtins.str:
        """
        The ISO 8601 timespan duration of the idle interval after which the Queue is automatically deleted, minimum of 5 minutes.
        """
        return pulumi.get(self, "auto_delete_on_idle")

    @property
    @pulumi.getter(name="batchedOperationsEnabled")
    def batched_operations_enabled(self) -> builtins.bool:
        """
        Boolean flag which controls whether server-side batched operations are enabled.
        """
        return pulumi.get(self, "batched_operations_enabled")

    @property
    @pulumi.getter(name="deadLetteringOnMessageExpiration")
    def dead_lettering_on_message_expiration(self) -> builtins.bool:
        """
        Boolean flag which controls whether the Queue has dead letter support when a message expires.
        """
        return pulumi.get(self, "dead_lettering_on_message_expiration")

    @property
    @pulumi.getter(name="defaultMessageTtl")
    def default_message_ttl(self) -> builtins.str:
        """
        The ISO 8601 timespan duration of the TTL of messages sent to this queue. This is the default value used when TTL is not set on a message itself.
        """
        return pulumi.get(self, "default_message_ttl")

    @property
    @pulumi.getter(name="duplicateDetectionHistoryTimeWindow")
    def duplicate_detection_history_time_window(self) -> builtins.str:
        """
        The ISO 8601 timespan duration during which duplicates can be detected.
        """
        return pulumi.get(self, "duplicate_detection_history_time_window")

    @property
    @pulumi.getter(name="enableBatchedOperations")
    def enable_batched_operations(self) -> builtins.bool:
        return pulumi.get(self, "enable_batched_operations")

    @property
    @pulumi.getter(name="enableExpress")
    def enable_express(self) -> builtins.bool:
        return pulumi.get(self, "enable_express")

    @property
    @pulumi.getter(name="enablePartitioning")
    def enable_partitioning(self) -> builtins.bool:
        return pulumi.get(self, "enable_partitioning")

    @property
    @pulumi.getter(name="expressEnabled")
    def express_enabled(self) -> builtins.bool:
        """
        Boolean flag which controls whether Express Entities are enabled. An express queue holds a message in memory temporarily before writing it to persistent storage.
        """
        return pulumi.get(self, "express_enabled")

    @property
    @pulumi.getter(name="forwardDeadLetteredMessagesTo")
    def forward_dead_lettered_messages_to(self) -> builtins.str:
        """
        The name of a Queue or Topic to automatically forward dead lettered messages to.
        """
        return pulumi.get(self, "forward_dead_lettered_messages_to")

    @property
    @pulumi.getter(name="forwardTo")
    def forward_to(self) -> builtins.str:
        """
        The name of a Queue or Topic to automatically forward messages to. Please [see the documentation](https://docs.microsoft.com/azure/service-bus-messaging/service-bus-auto-forwarding) for more information.
        """
        return pulumi.get(self, "forward_to")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lockDuration")
    def lock_duration(self) -> builtins.str:
        """
        The ISO 8601 timespan duration of a peek-lock; that is, the amount of time that the message is locked for other receivers.
        """
        return pulumi.get(self, "lock_duration")

    @property
    @pulumi.getter(name="maxDeliveryCount")
    def max_delivery_count(self) -> builtins.int:
        """
        Integer value which controls when a message is automatically dead lettered.
        """
        return pulumi.get(self, "max_delivery_count")

    @property
    @pulumi.getter(name="maxSizeInMegabytes")
    def max_size_in_megabytes(self) -> builtins.int:
        """
        Integer value which controls the size of memory allocated for the queue. For supported values see the "Queue or topic size" section of [Service Bus Quotas](https://docs.microsoft.com/azure/service-bus-messaging/service-bus-quotas).
        """
        return pulumi.get(self, "max_size_in_megabytes")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "namespace_id")

    @property
    @pulumi.getter(name="namespaceName")
    @_utilities.deprecated("""`namespace_name` will be removed in favour of the property `namespace_id` in version 5.0 of the AzureRM Provider.""")
    def namespace_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "namespace_name")

    @property
    @pulumi.getter(name="partitioningEnabled")
    def partitioning_enabled(self) -> builtins.bool:
        """
        Boolean flag which controls whether to enable the queue to be partitioned across multiple message brokers.
        """
        return pulumi.get(self, "partitioning_enabled")

    @property
    @pulumi.getter(name="requiresDuplicateDetection")
    def requires_duplicate_detection(self) -> builtins.bool:
        """
        Boolean flag which controls whether the Queue requires duplicate detection.
        """
        return pulumi.get(self, "requires_duplicate_detection")

    @property
    @pulumi.getter(name="requiresSession")
    def requires_session(self) -> builtins.bool:
        """
        Boolean flag which controls whether the Queue requires sessions. This will allow ordered handling of unbounded sequences of related messages. With sessions enabled a queue can guarantee first-in-first-out delivery of messages.
        """
        return pulumi.get(self, "requires_session")

    @property
    @pulumi.getter(name="resourceGroupName")
    @_utilities.deprecated("""`resource_group_name` will be removed in favour of the property `namespace_id` in version 5.0 of the AzureRM Provider.""")
    def resource_group_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The status of the Queue. Possible values are `Active`, `Creating`, `Deleting`, `Disabled`, `ReceiveDisabled`, `Renaming`, `SendDisabled`, `Unknown`.
        """
        return pulumi.get(self, "status")


class AwaitableGetQueueResult(GetQueueResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetQueueResult(
            auto_delete_on_idle=self.auto_delete_on_idle,
            batched_operations_enabled=self.batched_operations_enabled,
            dead_lettering_on_message_expiration=self.dead_lettering_on_message_expiration,
            default_message_ttl=self.default_message_ttl,
            duplicate_detection_history_time_window=self.duplicate_detection_history_time_window,
            enable_batched_operations=self.enable_batched_operations,
            enable_express=self.enable_express,
            enable_partitioning=self.enable_partitioning,
            express_enabled=self.express_enabled,
            forward_dead_lettered_messages_to=self.forward_dead_lettered_messages_to,
            forward_to=self.forward_to,
            id=self.id,
            lock_duration=self.lock_duration,
            max_delivery_count=self.max_delivery_count,
            max_size_in_megabytes=self.max_size_in_megabytes,
            name=self.name,
            namespace_id=self.namespace_id,
            namespace_name=self.namespace_name,
            partitioning_enabled=self.partitioning_enabled,
            requires_duplicate_detection=self.requires_duplicate_detection,
            requires_session=self.requires_session,
            resource_group_name=self.resource_group_name,
            status=self.status)


def get_queue(name: Optional[builtins.str] = None,
              namespace_id: Optional[builtins.str] = None,
              namespace_name: Optional[builtins.str] = None,
              resource_group_name: Optional[builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetQueueResult:
    """
    Use this data source to access information about an existing Service Bus Queue.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.servicebus.get_queue(name="existing",
        namespace_id="existing")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ServiceBus`: 2022-10-01-preview, 2021-06-01-preview


    :param builtins.str name: The name of this Service Bus Queue.
    :param builtins.str namespace_id: The ID of the ServiceBus Namespace where the Service Bus Queue exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['namespaceId'] = namespace_id
    __args__['namespaceName'] = namespace_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:servicebus/getQueue:getQueue', __args__, opts=opts, typ=GetQueueResult).value

    return AwaitableGetQueueResult(
        auto_delete_on_idle=pulumi.get(__ret__, 'auto_delete_on_idle'),
        batched_operations_enabled=pulumi.get(__ret__, 'batched_operations_enabled'),
        dead_lettering_on_message_expiration=pulumi.get(__ret__, 'dead_lettering_on_message_expiration'),
        default_message_ttl=pulumi.get(__ret__, 'default_message_ttl'),
        duplicate_detection_history_time_window=pulumi.get(__ret__, 'duplicate_detection_history_time_window'),
        enable_batched_operations=pulumi.get(__ret__, 'enable_batched_operations'),
        enable_express=pulumi.get(__ret__, 'enable_express'),
        enable_partitioning=pulumi.get(__ret__, 'enable_partitioning'),
        express_enabled=pulumi.get(__ret__, 'express_enabled'),
        forward_dead_lettered_messages_to=pulumi.get(__ret__, 'forward_dead_lettered_messages_to'),
        forward_to=pulumi.get(__ret__, 'forward_to'),
        id=pulumi.get(__ret__, 'id'),
        lock_duration=pulumi.get(__ret__, 'lock_duration'),
        max_delivery_count=pulumi.get(__ret__, 'max_delivery_count'),
        max_size_in_megabytes=pulumi.get(__ret__, 'max_size_in_megabytes'),
        name=pulumi.get(__ret__, 'name'),
        namespace_id=pulumi.get(__ret__, 'namespace_id'),
        namespace_name=pulumi.get(__ret__, 'namespace_name'),
        partitioning_enabled=pulumi.get(__ret__, 'partitioning_enabled'),
        requires_duplicate_detection=pulumi.get(__ret__, 'requires_duplicate_detection'),
        requires_session=pulumi.get(__ret__, 'requires_session'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        status=pulumi.get(__ret__, 'status'))
def get_queue_output(name: Optional[pulumi.Input[builtins.str]] = None,
                     namespace_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                     namespace_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                     resource_group_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetQueueResult]:
    """
    Use this data source to access information about an existing Service Bus Queue.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.servicebus.get_queue(name="existing",
        namespace_id="existing")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ServiceBus`: 2022-10-01-preview, 2021-06-01-preview


    :param builtins.str name: The name of this Service Bus Queue.
    :param builtins.str namespace_id: The ID of the ServiceBus Namespace where the Service Bus Queue exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['namespaceId'] = namespace_id
    __args__['namespaceName'] = namespace_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:servicebus/getQueue:getQueue', __args__, opts=opts, typ=GetQueueResult)
    return __ret__.apply(lambda __response__: GetQueueResult(
        auto_delete_on_idle=pulumi.get(__response__, 'auto_delete_on_idle'),
        batched_operations_enabled=pulumi.get(__response__, 'batched_operations_enabled'),
        dead_lettering_on_message_expiration=pulumi.get(__response__, 'dead_lettering_on_message_expiration'),
        default_message_ttl=pulumi.get(__response__, 'default_message_ttl'),
        duplicate_detection_history_time_window=pulumi.get(__response__, 'duplicate_detection_history_time_window'),
        enable_batched_operations=pulumi.get(__response__, 'enable_batched_operations'),
        enable_express=pulumi.get(__response__, 'enable_express'),
        enable_partitioning=pulumi.get(__response__, 'enable_partitioning'),
        express_enabled=pulumi.get(__response__, 'express_enabled'),
        forward_dead_lettered_messages_to=pulumi.get(__response__, 'forward_dead_lettered_messages_to'),
        forward_to=pulumi.get(__response__, 'forward_to'),
        id=pulumi.get(__response__, 'id'),
        lock_duration=pulumi.get(__response__, 'lock_duration'),
        max_delivery_count=pulumi.get(__response__, 'max_delivery_count'),
        max_size_in_megabytes=pulumi.get(__response__, 'max_size_in_megabytes'),
        name=pulumi.get(__response__, 'name'),
        namespace_id=pulumi.get(__response__, 'namespace_id'),
        namespace_name=pulumi.get(__response__, 'namespace_name'),
        partitioning_enabled=pulumi.get(__response__, 'partitioning_enabled'),
        requires_duplicate_detection=pulumi.get(__response__, 'requires_duplicate_detection'),
        requires_session=pulumi.get(__response__, 'requires_session'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        status=pulumi.get(__response__, 'status')))
