# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetTopicAuthorizationRuleResult',
    'AwaitableGetTopicAuthorizationRuleResult',
    'get_topic_authorization_rule',
    'get_topic_authorization_rule_output',
]

@pulumi.output_type
class GetTopicAuthorizationRuleResult:
    """
    A collection of values returned by getTopicAuthorizationRule.
    """
    def __init__(__self__, id=None, listen=None, manage=None, name=None, namespace_name=None, primary_connection_string=None, primary_connection_string_alias=None, primary_key=None, queue_name=None, resource_group_name=None, secondary_connection_string=None, secondary_connection_string_alias=None, secondary_key=None, send=None, topic_id=None, topic_name=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if listen and not isinstance(listen, bool):
            raise TypeError("Expected argument 'listen' to be a bool")
        pulumi.set(__self__, "listen", listen)
        if manage and not isinstance(manage, bool):
            raise TypeError("Expected argument 'manage' to be a bool")
        pulumi.set(__self__, "manage", manage)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace_name and not isinstance(namespace_name, str):
            raise TypeError("Expected argument 'namespace_name' to be a str")
        pulumi.set(__self__, "namespace_name", namespace_name)
        if primary_connection_string and not isinstance(primary_connection_string, str):
            raise TypeError("Expected argument 'primary_connection_string' to be a str")
        pulumi.set(__self__, "primary_connection_string", primary_connection_string)
        if primary_connection_string_alias and not isinstance(primary_connection_string_alias, str):
            raise TypeError("Expected argument 'primary_connection_string_alias' to be a str")
        pulumi.set(__self__, "primary_connection_string_alias", primary_connection_string_alias)
        if primary_key and not isinstance(primary_key, str):
            raise TypeError("Expected argument 'primary_key' to be a str")
        pulumi.set(__self__, "primary_key", primary_key)
        if queue_name and not isinstance(queue_name, str):
            raise TypeError("Expected argument 'queue_name' to be a str")
        pulumi.set(__self__, "queue_name", queue_name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if secondary_connection_string and not isinstance(secondary_connection_string, str):
            raise TypeError("Expected argument 'secondary_connection_string' to be a str")
        pulumi.set(__self__, "secondary_connection_string", secondary_connection_string)
        if secondary_connection_string_alias and not isinstance(secondary_connection_string_alias, str):
            raise TypeError("Expected argument 'secondary_connection_string_alias' to be a str")
        pulumi.set(__self__, "secondary_connection_string_alias", secondary_connection_string_alias)
        if secondary_key and not isinstance(secondary_key, str):
            raise TypeError("Expected argument 'secondary_key' to be a str")
        pulumi.set(__self__, "secondary_key", secondary_key)
        if send and not isinstance(send, bool):
            raise TypeError("Expected argument 'send' to be a bool")
        pulumi.set(__self__, "send", send)
        if topic_id and not isinstance(topic_id, str):
            raise TypeError("Expected argument 'topic_id' to be a str")
        pulumi.set(__self__, "topic_id", topic_id)
        if topic_name and not isinstance(topic_name, str):
            raise TypeError("Expected argument 'topic_name' to be a str")
        pulumi.set(__self__, "topic_name", topic_name)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def listen(self) -> builtins.bool:
        return pulumi.get(self, "listen")

    @property
    @pulumi.getter
    def manage(self) -> builtins.bool:
        return pulumi.get(self, "manage")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "namespace_name")

    @property
    @pulumi.getter(name="primaryConnectionString")
    def primary_connection_string(self) -> builtins.str:
        """
        The Primary Connection String for the ServiceBus Topic authorization Rule.
        """
        return pulumi.get(self, "primary_connection_string")

    @property
    @pulumi.getter(name="primaryConnectionStringAlias")
    def primary_connection_string_alias(self) -> builtins.str:
        """
        The alias Primary Connection String for the ServiceBus Namespace, if the namespace is Geo DR paired.
        """
        return pulumi.get(self, "primary_connection_string_alias")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> builtins.str:
        """
        The Primary Key for the ServiceBus Topic authorization Rule.
        """
        return pulumi.get(self, "primary_key")

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "queue_name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="secondaryConnectionString")
    def secondary_connection_string(self) -> builtins.str:
        """
        The Secondary Connection String for the ServiceBus Topic authorization Rule.
        """
        return pulumi.get(self, "secondary_connection_string")

    @property
    @pulumi.getter(name="secondaryConnectionStringAlias")
    def secondary_connection_string_alias(self) -> builtins.str:
        """
        The alias Secondary Connection String for the ServiceBus Namespace
        """
        return pulumi.get(self, "secondary_connection_string_alias")

    @property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> builtins.str:
        """
        The Secondary Key for the ServiceBus Topic authorization Rule.
        """
        return pulumi.get(self, "secondary_key")

    @property
    @pulumi.getter
    def send(self) -> builtins.bool:
        return pulumi.get(self, "send")

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "topic_id")

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "topic_name")


class AwaitableGetTopicAuthorizationRuleResult(GetTopicAuthorizationRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTopicAuthorizationRuleResult(
            id=self.id,
            listen=self.listen,
            manage=self.manage,
            name=self.name,
            namespace_name=self.namespace_name,
            primary_connection_string=self.primary_connection_string,
            primary_connection_string_alias=self.primary_connection_string_alias,
            primary_key=self.primary_key,
            queue_name=self.queue_name,
            resource_group_name=self.resource_group_name,
            secondary_connection_string=self.secondary_connection_string,
            secondary_connection_string_alias=self.secondary_connection_string_alias,
            secondary_key=self.secondary_key,
            send=self.send,
            topic_id=self.topic_id,
            topic_name=self.topic_name)


def get_topic_authorization_rule(name: Optional[builtins.str] = None,
                                 namespace_name: Optional[builtins.str] = None,
                                 queue_name: Optional[builtins.str] = None,
                                 resource_group_name: Optional[builtins.str] = None,
                                 topic_id: Optional[builtins.str] = None,
                                 topic_name: Optional[builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTopicAuthorizationRuleResult:
    """
    Use this data source to access information about a ServiceBus Topic Authorization Rule within a ServiceBus Topic.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.servicebus.get_topic_authorization_rule(name="example-tfex_name",
        resource_group_name="example-resources",
        namespace_name="example-namespace",
        topic_name="example-servicebus_topic")
    pulumi.export("servicebusAuthorizationRuleId", example_azurem_servicebus_topic_authorization_rule["id"])
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ServiceBus`: 2021-06-01-preview


    :param builtins.str name: The name of the ServiceBus Topic Authorization Rule resource.
    :param builtins.str namespace_name: The name of the ServiceBus Namespace.
    :param builtins.str resource_group_name: The name of the resource group in which the ServiceBus Namespace exists.
    :param builtins.str topic_name: The name of the ServiceBus Topic.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['namespaceName'] = namespace_name
    __args__['queueName'] = queue_name
    __args__['resourceGroupName'] = resource_group_name
    __args__['topicId'] = topic_id
    __args__['topicName'] = topic_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:servicebus/getTopicAuthorizationRule:getTopicAuthorizationRule', __args__, opts=opts, typ=GetTopicAuthorizationRuleResult).value

    return AwaitableGetTopicAuthorizationRuleResult(
        id=pulumi.get(__ret__, 'id'),
        listen=pulumi.get(__ret__, 'listen'),
        manage=pulumi.get(__ret__, 'manage'),
        name=pulumi.get(__ret__, 'name'),
        namespace_name=pulumi.get(__ret__, 'namespace_name'),
        primary_connection_string=pulumi.get(__ret__, 'primary_connection_string'),
        primary_connection_string_alias=pulumi.get(__ret__, 'primary_connection_string_alias'),
        primary_key=pulumi.get(__ret__, 'primary_key'),
        queue_name=pulumi.get(__ret__, 'queue_name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        secondary_connection_string=pulumi.get(__ret__, 'secondary_connection_string'),
        secondary_connection_string_alias=pulumi.get(__ret__, 'secondary_connection_string_alias'),
        secondary_key=pulumi.get(__ret__, 'secondary_key'),
        send=pulumi.get(__ret__, 'send'),
        topic_id=pulumi.get(__ret__, 'topic_id'),
        topic_name=pulumi.get(__ret__, 'topic_name'))
def get_topic_authorization_rule_output(name: Optional[pulumi.Input[builtins.str]] = None,
                                        namespace_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                        queue_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                        resource_group_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                        topic_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                        topic_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTopicAuthorizationRuleResult]:
    """
    Use this data source to access information about a ServiceBus Topic Authorization Rule within a ServiceBus Topic.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.servicebus.get_topic_authorization_rule(name="example-tfex_name",
        resource_group_name="example-resources",
        namespace_name="example-namespace",
        topic_name="example-servicebus_topic")
    pulumi.export("servicebusAuthorizationRuleId", example_azurem_servicebus_topic_authorization_rule["id"])
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ServiceBus`: 2021-06-01-preview


    :param builtins.str name: The name of the ServiceBus Topic Authorization Rule resource.
    :param builtins.str namespace_name: The name of the ServiceBus Namespace.
    :param builtins.str resource_group_name: The name of the resource group in which the ServiceBus Namespace exists.
    :param builtins.str topic_name: The name of the ServiceBus Topic.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['namespaceName'] = namespace_name
    __args__['queueName'] = queue_name
    __args__['resourceGroupName'] = resource_group_name
    __args__['topicId'] = topic_id
    __args__['topicName'] = topic_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:servicebus/getTopicAuthorizationRule:getTopicAuthorizationRule', __args__, opts=opts, typ=GetTopicAuthorizationRuleResult)
    return __ret__.apply(lambda __response__: GetTopicAuthorizationRuleResult(
        id=pulumi.get(__response__, 'id'),
        listen=pulumi.get(__response__, 'listen'),
        manage=pulumi.get(__response__, 'manage'),
        name=pulumi.get(__response__, 'name'),
        namespace_name=pulumi.get(__response__, 'namespace_name'),
        primary_connection_string=pulumi.get(__response__, 'primary_connection_string'),
        primary_connection_string_alias=pulumi.get(__response__, 'primary_connection_string_alias'),
        primary_key=pulumi.get(__response__, 'primary_key'),
        queue_name=pulumi.get(__response__, 'queue_name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        secondary_connection_string=pulumi.get(__response__, 'secondary_connection_string'),
        secondary_connection_string_alias=pulumi.get(__response__, 'secondary_connection_string_alias'),
        secondary_key=pulumi.get(__response__, 'secondary_key'),
        send=pulumi.get(__response__, 'send'),
        topic_id=pulumi.get(__response__, 'topic_id'),
        topic_name=pulumi.get(__response__, 'topic_name')))
