# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SubscriptionRuleArgs', 'SubscriptionRule']

@pulumi.input_type
class SubscriptionRuleArgs:
    def __init__(__self__, *,
                 filter_type: pulumi.Input[builtins.str],
                 subscription_id: pulumi.Input[builtins.str],
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 correlation_filter: Optional[pulumi.Input['SubscriptionRuleCorrelationFilterArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 sql_filter: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a SubscriptionRule resource.
        :param pulumi.Input[builtins.str] filter_type: Type of filter to be applied to a BrokeredMessage. Possible values are `SqlFilter` and `CorrelationFilter`.
        :param pulumi.Input[builtins.str] subscription_id: The ID of the ServiceBus Subscription in which this Rule should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] action: Represents set of actions written in SQL language-based syntax that is performed against a BrokeredMessage.
        :param pulumi.Input['SubscriptionRuleCorrelationFilterArgs'] correlation_filter: A `correlation_filter` block as documented below to be evaluated against a BrokeredMessage. Required when `filter_type` is set to `CorrelationFilter`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the ServiceBus Subscription Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sql_filter: Represents a filter written in SQL language-based syntax that to be evaluated against a BrokeredMessage. Required when `filter_type` is set to `SqlFilter`.
        """
        pulumi.set(__self__, "filter_type", filter_type)
        pulumi.set(__self__, "subscription_id", subscription_id)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if correlation_filter is not None:
            pulumi.set(__self__, "correlation_filter", correlation_filter)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sql_filter is not None:
            pulumi.set(__self__, "sql_filter", sql_filter)

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> pulumi.Input[builtins.str]:
        """
        Type of filter to be applied to a BrokeredMessage. Possible values are `SqlFilter` and `CorrelationFilter`.
        """
        return pulumi.get(self, "filter_type")

    @filter_type.setter
    def filter_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "filter_type", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the ServiceBus Subscription in which this Rule should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Represents set of actions written in SQL language-based syntax that is performed against a BrokeredMessage.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="correlationFilter")
    def correlation_filter(self) -> Optional[pulumi.Input['SubscriptionRuleCorrelationFilterArgs']]:
        """
        A `correlation_filter` block as documented below to be evaluated against a BrokeredMessage. Required when `filter_type` is set to `CorrelationFilter`.
        """
        return pulumi.get(self, "correlation_filter")

    @correlation_filter.setter
    def correlation_filter(self, value: Optional[pulumi.Input['SubscriptionRuleCorrelationFilterArgs']]):
        pulumi.set(self, "correlation_filter", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the ServiceBus Subscription Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sqlFilter")
    def sql_filter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Represents a filter written in SQL language-based syntax that to be evaluated against a BrokeredMessage. Required when `filter_type` is set to `SqlFilter`.
        """
        return pulumi.get(self, "sql_filter")

    @sql_filter.setter
    def sql_filter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sql_filter", value)


@pulumi.input_type
class _SubscriptionRuleState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 correlation_filter: Optional[pulumi.Input['SubscriptionRuleCorrelationFilterArgs']] = None,
                 filter_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 sql_filter: Optional[pulumi.Input[builtins.str]] = None,
                 sql_filter_compatibility_level: Optional[pulumi.Input[builtins.int]] = None,
                 subscription_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SubscriptionRule resources.
        :param pulumi.Input[builtins.str] action: Represents set of actions written in SQL language-based syntax that is performed against a BrokeredMessage.
        :param pulumi.Input['SubscriptionRuleCorrelationFilterArgs'] correlation_filter: A `correlation_filter` block as documented below to be evaluated against a BrokeredMessage. Required when `filter_type` is set to `CorrelationFilter`.
        :param pulumi.Input[builtins.str] filter_type: Type of filter to be applied to a BrokeredMessage. Possible values are `SqlFilter` and `CorrelationFilter`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the ServiceBus Subscription Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sql_filter: Represents a filter written in SQL language-based syntax that to be evaluated against a BrokeredMessage. Required when `filter_type` is set to `SqlFilter`.
        :param pulumi.Input[builtins.str] subscription_id: The ID of the ServiceBus Subscription in which this Rule should be created. Changing this forces a new resource to be created.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if correlation_filter is not None:
            pulumi.set(__self__, "correlation_filter", correlation_filter)
        if filter_type is not None:
            pulumi.set(__self__, "filter_type", filter_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sql_filter is not None:
            pulumi.set(__self__, "sql_filter", sql_filter)
        if sql_filter_compatibility_level is not None:
            pulumi.set(__self__, "sql_filter_compatibility_level", sql_filter_compatibility_level)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Represents set of actions written in SQL language-based syntax that is performed against a BrokeredMessage.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="correlationFilter")
    def correlation_filter(self) -> Optional[pulumi.Input['SubscriptionRuleCorrelationFilterArgs']]:
        """
        A `correlation_filter` block as documented below to be evaluated against a BrokeredMessage. Required when `filter_type` is set to `CorrelationFilter`.
        """
        return pulumi.get(self, "correlation_filter")

    @correlation_filter.setter
    def correlation_filter(self, value: Optional[pulumi.Input['SubscriptionRuleCorrelationFilterArgs']]):
        pulumi.set(self, "correlation_filter", value)

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of filter to be applied to a BrokeredMessage. Possible values are `SqlFilter` and `CorrelationFilter`.
        """
        return pulumi.get(self, "filter_type")

    @filter_type.setter
    def filter_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filter_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the ServiceBus Subscription Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sqlFilter")
    def sql_filter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Represents a filter written in SQL language-based syntax that to be evaluated against a BrokeredMessage. Required when `filter_type` is set to `SqlFilter`.
        """
        return pulumi.get(self, "sql_filter")

    @sql_filter.setter
    def sql_filter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sql_filter", value)

    @property
    @pulumi.getter(name="sqlFilterCompatibilityLevel")
    def sql_filter_compatibility_level(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "sql_filter_compatibility_level")

    @sql_filter_compatibility_level.setter
    def sql_filter_compatibility_level(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "sql_filter_compatibility_level", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the ServiceBus Subscription in which this Rule should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subscription_id", value)


@pulumi.type_token("azure:servicebus/subscriptionRule:SubscriptionRule")
class SubscriptionRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 correlation_filter: Optional[pulumi.Input[Union['SubscriptionRuleCorrelationFilterArgs', 'SubscriptionRuleCorrelationFilterArgsDict']]] = None,
                 filter_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 sql_filter: Optional[pulumi.Input[builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a ServiceBus Subscription Rule.

        ## Example Usage

        ## Import

        Service Bus Subscription Rule can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:servicebus/subscriptionRule:SubscriptionRule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ServiceBus/namespaces/sbns1/topics/sntopic1/subscriptions/sbsub1/rules/sbrule1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] action: Represents set of actions written in SQL language-based syntax that is performed against a BrokeredMessage.
        :param pulumi.Input[Union['SubscriptionRuleCorrelationFilterArgs', 'SubscriptionRuleCorrelationFilterArgsDict']] correlation_filter: A `correlation_filter` block as documented below to be evaluated against a BrokeredMessage. Required when `filter_type` is set to `CorrelationFilter`.
        :param pulumi.Input[builtins.str] filter_type: Type of filter to be applied to a BrokeredMessage. Possible values are `SqlFilter` and `CorrelationFilter`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the ServiceBus Subscription Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sql_filter: Represents a filter written in SQL language-based syntax that to be evaluated against a BrokeredMessage. Required when `filter_type` is set to `SqlFilter`.
        :param pulumi.Input[builtins.str] subscription_id: The ID of the ServiceBus Subscription in which this Rule should be created. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubscriptionRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a ServiceBus Subscription Rule.

        ## Example Usage

        ## Import

        Service Bus Subscription Rule can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:servicebus/subscriptionRule:SubscriptionRule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ServiceBus/namespaces/sbns1/topics/sntopic1/subscriptions/sbsub1/rules/sbrule1
        ```

        :param str resource_name: The name of the resource.
        :param SubscriptionRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubscriptionRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 correlation_filter: Optional[pulumi.Input[Union['SubscriptionRuleCorrelationFilterArgs', 'SubscriptionRuleCorrelationFilterArgsDict']]] = None,
                 filter_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 sql_filter: Optional[pulumi.Input[builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubscriptionRuleArgs.__new__(SubscriptionRuleArgs)

            __props__.__dict__["action"] = action
            __props__.__dict__["correlation_filter"] = correlation_filter
            if filter_type is None and not opts.urn:
                raise TypeError("Missing required property 'filter_type'")
            __props__.__dict__["filter_type"] = filter_type
            __props__.__dict__["name"] = name
            __props__.__dict__["sql_filter"] = sql_filter
            if subscription_id is None and not opts.urn:
                raise TypeError("Missing required property 'subscription_id'")
            __props__.__dict__["subscription_id"] = subscription_id
            __props__.__dict__["sql_filter_compatibility_level"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure:eventhub/subscriptionRule:SubscriptionRule")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(SubscriptionRule, __self__).__init__(
            'azure:servicebus/subscriptionRule:SubscriptionRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[builtins.str]] = None,
            correlation_filter: Optional[pulumi.Input[Union['SubscriptionRuleCorrelationFilterArgs', 'SubscriptionRuleCorrelationFilterArgsDict']]] = None,
            filter_type: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            sql_filter: Optional[pulumi.Input[builtins.str]] = None,
            sql_filter_compatibility_level: Optional[pulumi.Input[builtins.int]] = None,
            subscription_id: Optional[pulumi.Input[builtins.str]] = None) -> 'SubscriptionRule':
        """
        Get an existing SubscriptionRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] action: Represents set of actions written in SQL language-based syntax that is performed against a BrokeredMessage.
        :param pulumi.Input[Union['SubscriptionRuleCorrelationFilterArgs', 'SubscriptionRuleCorrelationFilterArgsDict']] correlation_filter: A `correlation_filter` block as documented below to be evaluated against a BrokeredMessage. Required when `filter_type` is set to `CorrelationFilter`.
        :param pulumi.Input[builtins.str] filter_type: Type of filter to be applied to a BrokeredMessage. Possible values are `SqlFilter` and `CorrelationFilter`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the ServiceBus Subscription Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sql_filter: Represents a filter written in SQL language-based syntax that to be evaluated against a BrokeredMessage. Required when `filter_type` is set to `SqlFilter`.
        :param pulumi.Input[builtins.str] subscription_id: The ID of the ServiceBus Subscription in which this Rule should be created. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SubscriptionRuleState.__new__(_SubscriptionRuleState)

        __props__.__dict__["action"] = action
        __props__.__dict__["correlation_filter"] = correlation_filter
        __props__.__dict__["filter_type"] = filter_type
        __props__.__dict__["name"] = name
        __props__.__dict__["sql_filter"] = sql_filter
        __props__.__dict__["sql_filter_compatibility_level"] = sql_filter_compatibility_level
        __props__.__dict__["subscription_id"] = subscription_id
        return SubscriptionRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Represents set of actions written in SQL language-based syntax that is performed against a BrokeredMessage.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="correlationFilter")
    def correlation_filter(self) -> pulumi.Output[Optional['outputs.SubscriptionRuleCorrelationFilter']]:
        """
        A `correlation_filter` block as documented below to be evaluated against a BrokeredMessage. Required when `filter_type` is set to `CorrelationFilter`.
        """
        return pulumi.get(self, "correlation_filter")

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> pulumi.Output[builtins.str]:
        """
        Type of filter to be applied to a BrokeredMessage. Possible values are `SqlFilter` and `CorrelationFilter`.
        """
        return pulumi.get(self, "filter_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the ServiceBus Subscription Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sqlFilter")
    def sql_filter(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Represents a filter written in SQL language-based syntax that to be evaluated against a BrokeredMessage. Required when `filter_type` is set to `SqlFilter`.
        """
        return pulumi.get(self, "sql_filter")

    @property
    @pulumi.getter(name="sqlFilterCompatibilityLevel")
    def sql_filter_compatibility_level(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "sql_filter_compatibility_level")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the ServiceBus Subscription in which this Rule should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subscription_id")

