# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TopicArgs', 'Topic']

@pulumi.input_type
class TopicArgs:
    def __init__(__self__, *,
                 namespace_id: pulumi.Input[builtins.str],
                 auto_delete_on_idle: Optional[pulumi.Input[builtins.str]] = None,
                 batched_operations_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 default_message_ttl: Optional[pulumi.Input[builtins.str]] = None,
                 duplicate_detection_history_time_window: Optional[pulumi.Input[builtins.str]] = None,
                 express_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 max_message_size_in_kilobytes: Optional[pulumi.Input[builtins.int]] = None,
                 max_size_in_megabytes: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 partitioning_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 requires_duplicate_detection: Optional[pulumi.Input[builtins.bool]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 support_ordering: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a Topic resource.
        :param pulumi.Input[builtins.str] namespace_id: The ID of the ServiceBus Namespace to create this topic in. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] auto_delete_on_idle: The ISO 8601 timespan duration of the idle interval after which the Topic is automatically deleted, minimum of 5 minutes. Defaults to `P10675199DT2H48M5.4775807S`.
        :param pulumi.Input[builtins.bool] batched_operations_enabled: Boolean flag which controls if server-side batched operations are enabled.
        :param pulumi.Input[builtins.str] default_message_ttl: The ISO 8601 timespan duration of TTL of messages sent to this topic if no TTL value is set on the message itself. Defaults to `P10675199DT2H48M5.4775807S`.
        :param pulumi.Input[builtins.str] duplicate_detection_history_time_window: The ISO 8601 timespan duration during which duplicates can be detected. Defaults to `PT10M` (10 Minutes).
        :param pulumi.Input[builtins.bool] express_enabled: Boolean flag which controls whether Express Entities are enabled. An express topic holds a message in memory temporarily before writing it to persistent storage.
        :param pulumi.Input[builtins.int] max_message_size_in_kilobytes: Integer value which controls the maximum size of a message allowed on the topic for Premium SKU. For supported values see the "Large messages support" section of [this document](https://docs.microsoft.com/azure/service-bus-messaging/service-bus-premium-messaging#large-messages-support-preview). Defaults to `256`.
        :param pulumi.Input[builtins.int] max_size_in_megabytes: Integer value which controls the size of memory allocated for the topic. For supported values see the "Queue/topic size" section of [this document](https://docs.microsoft.com/azure/service-bus-messaging/service-bus-quotas). Defaults to `5120`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the ServiceBus Topic resource. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] partitioning_enabled: Boolean flag which controls whether to enable the topic to be partitioned across multiple message brokers. Changing this forces a new resource to be created.
               
               > **Note:** Partitioning is available at entity creation for all queues and topics in Basic or Standard SKUs. It is not available for the Premium messaging SKU, but any previously existing partitioned entities in Premium namespaces continue to work as expected. For premium namespaces, partitioning is available at namespace creation and all queues and topics in the partitioned namespace will be partitioned. Premium namespaces that have `premium_messaging_partitions` set to `1` are not partitioned. Please [see the documentation](https://docs.microsoft.com/azure/service-bus-messaging/service-bus-partitioning) for more information.
        :param pulumi.Input[builtins.bool] requires_duplicate_detection: Boolean flag which controls whether the Topic requires duplicate detection. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] status: The Status of the Service Bus Topic. Acceptable values are `Active` or `Disabled`. Defaults to `Active`.
        :param pulumi.Input[builtins.bool] support_ordering: Boolean flag which controls whether the Topic supports ordering.
        """
        pulumi.set(__self__, "namespace_id", namespace_id)
        if auto_delete_on_idle is not None:
            pulumi.set(__self__, "auto_delete_on_idle", auto_delete_on_idle)
        if batched_operations_enabled is not None:
            pulumi.set(__self__, "batched_operations_enabled", batched_operations_enabled)
        if default_message_ttl is not None:
            pulumi.set(__self__, "default_message_ttl", default_message_ttl)
        if duplicate_detection_history_time_window is not None:
            pulumi.set(__self__, "duplicate_detection_history_time_window", duplicate_detection_history_time_window)
        if express_enabled is not None:
            pulumi.set(__self__, "express_enabled", express_enabled)
        if max_message_size_in_kilobytes is not None:
            pulumi.set(__self__, "max_message_size_in_kilobytes", max_message_size_in_kilobytes)
        if max_size_in_megabytes is not None:
            pulumi.set(__self__, "max_size_in_megabytes", max_size_in_megabytes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partitioning_enabled is not None:
            pulumi.set(__self__, "partitioning_enabled", partitioning_enabled)
        if requires_duplicate_detection is not None:
            pulumi.set(__self__, "requires_duplicate_detection", requires_duplicate_detection)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if support_ordering is not None:
            pulumi.set(__self__, "support_ordering", support_ordering)

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the ServiceBus Namespace to create this topic in. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "namespace_id", value)

    @property
    @pulumi.getter(name="autoDeleteOnIdle")
    def auto_delete_on_idle(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ISO 8601 timespan duration of the idle interval after which the Topic is automatically deleted, minimum of 5 minutes. Defaults to `P10675199DT2H48M5.4775807S`.
        """
        return pulumi.get(self, "auto_delete_on_idle")

    @auto_delete_on_idle.setter
    def auto_delete_on_idle(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "auto_delete_on_idle", value)

    @property
    @pulumi.getter(name="batchedOperationsEnabled")
    def batched_operations_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean flag which controls if server-side batched operations are enabled.
        """
        return pulumi.get(self, "batched_operations_enabled")

    @batched_operations_enabled.setter
    def batched_operations_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "batched_operations_enabled", value)

    @property
    @pulumi.getter(name="defaultMessageTtl")
    def default_message_ttl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ISO 8601 timespan duration of TTL of messages sent to this topic if no TTL value is set on the message itself. Defaults to `P10675199DT2H48M5.4775807S`.
        """
        return pulumi.get(self, "default_message_ttl")

    @default_message_ttl.setter
    def default_message_ttl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_message_ttl", value)

    @property
    @pulumi.getter(name="duplicateDetectionHistoryTimeWindow")
    def duplicate_detection_history_time_window(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ISO 8601 timespan duration during which duplicates can be detected. Defaults to `PT10M` (10 Minutes).
        """
        return pulumi.get(self, "duplicate_detection_history_time_window")

    @duplicate_detection_history_time_window.setter
    def duplicate_detection_history_time_window(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "duplicate_detection_history_time_window", value)

    @property
    @pulumi.getter(name="expressEnabled")
    def express_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean flag which controls whether Express Entities are enabled. An express topic holds a message in memory temporarily before writing it to persistent storage.
        """
        return pulumi.get(self, "express_enabled")

    @express_enabled.setter
    def express_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "express_enabled", value)

    @property
    @pulumi.getter(name="maxMessageSizeInKilobytes")
    def max_message_size_in_kilobytes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Integer value which controls the maximum size of a message allowed on the topic for Premium SKU. For supported values see the "Large messages support" section of [this document](https://docs.microsoft.com/azure/service-bus-messaging/service-bus-premium-messaging#large-messages-support-preview). Defaults to `256`.
        """
        return pulumi.get(self, "max_message_size_in_kilobytes")

    @max_message_size_in_kilobytes.setter
    def max_message_size_in_kilobytes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_message_size_in_kilobytes", value)

    @property
    @pulumi.getter(name="maxSizeInMegabytes")
    def max_size_in_megabytes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Integer value which controls the size of memory allocated for the topic. For supported values see the "Queue/topic size" section of [this document](https://docs.microsoft.com/azure/service-bus-messaging/service-bus-quotas). Defaults to `5120`.
        """
        return pulumi.get(self, "max_size_in_megabytes")

    @max_size_in_megabytes.setter
    def max_size_in_megabytes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_size_in_megabytes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the ServiceBus Topic resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="partitioningEnabled")
    def partitioning_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean flag which controls whether to enable the topic to be partitioned across multiple message brokers. Changing this forces a new resource to be created.

        > **Note:** Partitioning is available at entity creation for all queues and topics in Basic or Standard SKUs. It is not available for the Premium messaging SKU, but any previously existing partitioned entities in Premium namespaces continue to work as expected. For premium namespaces, partitioning is available at namespace creation and all queues and topics in the partitioned namespace will be partitioned. Premium namespaces that have `premium_messaging_partitions` set to `1` are not partitioned. Please [see the documentation](https://docs.microsoft.com/azure/service-bus-messaging/service-bus-partitioning) for more information.
        """
        return pulumi.get(self, "partitioning_enabled")

    @partitioning_enabled.setter
    def partitioning_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "partitioning_enabled", value)

    @property
    @pulumi.getter(name="requiresDuplicateDetection")
    def requires_duplicate_detection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean flag which controls whether the Topic requires duplicate detection. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "requires_duplicate_detection")

    @requires_duplicate_detection.setter
    def requires_duplicate_detection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "requires_duplicate_detection", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Status of the Service Bus Topic. Acceptable values are `Active` or `Disabled`. Defaults to `Active`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="supportOrdering")
    def support_ordering(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean flag which controls whether the Topic supports ordering.
        """
        return pulumi.get(self, "support_ordering")

    @support_ordering.setter
    def support_ordering(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "support_ordering", value)


@pulumi.input_type
class _TopicState:
    def __init__(__self__, *,
                 auto_delete_on_idle: Optional[pulumi.Input[builtins.str]] = None,
                 batched_operations_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 default_message_ttl: Optional[pulumi.Input[builtins.str]] = None,
                 duplicate_detection_history_time_window: Optional[pulumi.Input[builtins.str]] = None,
                 express_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 max_message_size_in_kilobytes: Optional[pulumi.Input[builtins.int]] = None,
                 max_size_in_megabytes: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace_id: Optional[pulumi.Input[builtins.str]] = None,
                 namespace_name: Optional[pulumi.Input[builtins.str]] = None,
                 partitioning_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 requires_duplicate_detection: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 support_ordering: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Topic resources.
        :param pulumi.Input[builtins.str] auto_delete_on_idle: The ISO 8601 timespan duration of the idle interval after which the Topic is automatically deleted, minimum of 5 minutes. Defaults to `P10675199DT2H48M5.4775807S`.
        :param pulumi.Input[builtins.bool] batched_operations_enabled: Boolean flag which controls if server-side batched operations are enabled.
        :param pulumi.Input[builtins.str] default_message_ttl: The ISO 8601 timespan duration of TTL of messages sent to this topic if no TTL value is set on the message itself. Defaults to `P10675199DT2H48M5.4775807S`.
        :param pulumi.Input[builtins.str] duplicate_detection_history_time_window: The ISO 8601 timespan duration during which duplicates can be detected. Defaults to `PT10M` (10 Minutes).
        :param pulumi.Input[builtins.bool] express_enabled: Boolean flag which controls whether Express Entities are enabled. An express topic holds a message in memory temporarily before writing it to persistent storage.
        :param pulumi.Input[builtins.int] max_message_size_in_kilobytes: Integer value which controls the maximum size of a message allowed on the topic for Premium SKU. For supported values see the "Large messages support" section of [this document](https://docs.microsoft.com/azure/service-bus-messaging/service-bus-premium-messaging#large-messages-support-preview). Defaults to `256`.
        :param pulumi.Input[builtins.int] max_size_in_megabytes: Integer value which controls the size of memory allocated for the topic. For supported values see the "Queue/topic size" section of [this document](https://docs.microsoft.com/azure/service-bus-messaging/service-bus-quotas). Defaults to `5120`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the ServiceBus Topic resource. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] namespace_id: The ID of the ServiceBus Namespace to create this topic in. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] partitioning_enabled: Boolean flag which controls whether to enable the topic to be partitioned across multiple message brokers. Changing this forces a new resource to be created.
               
               > **Note:** Partitioning is available at entity creation for all queues and topics in Basic or Standard SKUs. It is not available for the Premium messaging SKU, but any previously existing partitioned entities in Premium namespaces continue to work as expected. For premium namespaces, partitioning is available at namespace creation and all queues and topics in the partitioned namespace will be partitioned. Premium namespaces that have `premium_messaging_partitions` set to `1` are not partitioned. Please [see the documentation](https://docs.microsoft.com/azure/service-bus-messaging/service-bus-partitioning) for more information.
        :param pulumi.Input[builtins.bool] requires_duplicate_detection: Boolean flag which controls whether the Topic requires duplicate detection. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] status: The Status of the Service Bus Topic. Acceptable values are `Active` or `Disabled`. Defaults to `Active`.
        :param pulumi.Input[builtins.bool] support_ordering: Boolean flag which controls whether the Topic supports ordering.
        """
        if auto_delete_on_idle is not None:
            pulumi.set(__self__, "auto_delete_on_idle", auto_delete_on_idle)
        if batched_operations_enabled is not None:
            pulumi.set(__self__, "batched_operations_enabled", batched_operations_enabled)
        if default_message_ttl is not None:
            pulumi.set(__self__, "default_message_ttl", default_message_ttl)
        if duplicate_detection_history_time_window is not None:
            pulumi.set(__self__, "duplicate_detection_history_time_window", duplicate_detection_history_time_window)
        if express_enabled is not None:
            pulumi.set(__self__, "express_enabled", express_enabled)
        if max_message_size_in_kilobytes is not None:
            pulumi.set(__self__, "max_message_size_in_kilobytes", max_message_size_in_kilobytes)
        if max_size_in_megabytes is not None:
            pulumi.set(__self__, "max_size_in_megabytes", max_size_in_megabytes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace_id is not None:
            pulumi.set(__self__, "namespace_id", namespace_id)
        if namespace_name is not None:
            pulumi.set(__self__, "namespace_name", namespace_name)
        if partitioning_enabled is not None:
            pulumi.set(__self__, "partitioning_enabled", partitioning_enabled)
        if requires_duplicate_detection is not None:
            pulumi.set(__self__, "requires_duplicate_detection", requires_duplicate_detection)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if support_ordering is not None:
            pulumi.set(__self__, "support_ordering", support_ordering)

    @property
    @pulumi.getter(name="autoDeleteOnIdle")
    def auto_delete_on_idle(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ISO 8601 timespan duration of the idle interval after which the Topic is automatically deleted, minimum of 5 minutes. Defaults to `P10675199DT2H48M5.4775807S`.
        """
        return pulumi.get(self, "auto_delete_on_idle")

    @auto_delete_on_idle.setter
    def auto_delete_on_idle(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "auto_delete_on_idle", value)

    @property
    @pulumi.getter(name="batchedOperationsEnabled")
    def batched_operations_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean flag which controls if server-side batched operations are enabled.
        """
        return pulumi.get(self, "batched_operations_enabled")

    @batched_operations_enabled.setter
    def batched_operations_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "batched_operations_enabled", value)

    @property
    @pulumi.getter(name="defaultMessageTtl")
    def default_message_ttl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ISO 8601 timespan duration of TTL of messages sent to this topic if no TTL value is set on the message itself. Defaults to `P10675199DT2H48M5.4775807S`.
        """
        return pulumi.get(self, "default_message_ttl")

    @default_message_ttl.setter
    def default_message_ttl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_message_ttl", value)

    @property
    @pulumi.getter(name="duplicateDetectionHistoryTimeWindow")
    def duplicate_detection_history_time_window(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ISO 8601 timespan duration during which duplicates can be detected. Defaults to `PT10M` (10 Minutes).
        """
        return pulumi.get(self, "duplicate_detection_history_time_window")

    @duplicate_detection_history_time_window.setter
    def duplicate_detection_history_time_window(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "duplicate_detection_history_time_window", value)

    @property
    @pulumi.getter(name="expressEnabled")
    def express_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean flag which controls whether Express Entities are enabled. An express topic holds a message in memory temporarily before writing it to persistent storage.
        """
        return pulumi.get(self, "express_enabled")

    @express_enabled.setter
    def express_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "express_enabled", value)

    @property
    @pulumi.getter(name="maxMessageSizeInKilobytes")
    def max_message_size_in_kilobytes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Integer value which controls the maximum size of a message allowed on the topic for Premium SKU. For supported values see the "Large messages support" section of [this document](https://docs.microsoft.com/azure/service-bus-messaging/service-bus-premium-messaging#large-messages-support-preview). Defaults to `256`.
        """
        return pulumi.get(self, "max_message_size_in_kilobytes")

    @max_message_size_in_kilobytes.setter
    def max_message_size_in_kilobytes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_message_size_in_kilobytes", value)

    @property
    @pulumi.getter(name="maxSizeInMegabytes")
    def max_size_in_megabytes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Integer value which controls the size of memory allocated for the topic. For supported values see the "Queue/topic size" section of [this document](https://docs.microsoft.com/azure/service-bus-messaging/service-bus-quotas). Defaults to `5120`.
        """
        return pulumi.get(self, "max_size_in_megabytes")

    @max_size_in_megabytes.setter
    def max_size_in_megabytes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_size_in_megabytes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the ServiceBus Topic resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the ServiceBus Namespace to create this topic in. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace_id", value)

    @property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "namespace_name")

    @namespace_name.setter
    def namespace_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace_name", value)

    @property
    @pulumi.getter(name="partitioningEnabled")
    def partitioning_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean flag which controls whether to enable the topic to be partitioned across multiple message brokers. Changing this forces a new resource to be created.

        > **Note:** Partitioning is available at entity creation for all queues and topics in Basic or Standard SKUs. It is not available for the Premium messaging SKU, but any previously existing partitioned entities in Premium namespaces continue to work as expected. For premium namespaces, partitioning is available at namespace creation and all queues and topics in the partitioned namespace will be partitioned. Premium namespaces that have `premium_messaging_partitions` set to `1` are not partitioned. Please [see the documentation](https://docs.microsoft.com/azure/service-bus-messaging/service-bus-partitioning) for more information.
        """
        return pulumi.get(self, "partitioning_enabled")

    @partitioning_enabled.setter
    def partitioning_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "partitioning_enabled", value)

    @property
    @pulumi.getter(name="requiresDuplicateDetection")
    def requires_duplicate_detection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean flag which controls whether the Topic requires duplicate detection. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "requires_duplicate_detection")

    @requires_duplicate_detection.setter
    def requires_duplicate_detection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "requires_duplicate_detection", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Status of the Service Bus Topic. Acceptable values are `Active` or `Disabled`. Defaults to `Active`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="supportOrdering")
    def support_ordering(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean flag which controls whether the Topic supports ordering.
        """
        return pulumi.get(self, "support_ordering")

    @support_ordering.setter
    def support_ordering(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "support_ordering", value)


@pulumi.type_token("azure:servicebus/topic:Topic")
class Topic(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_delete_on_idle: Optional[pulumi.Input[builtins.str]] = None,
                 batched_operations_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 default_message_ttl: Optional[pulumi.Input[builtins.str]] = None,
                 duplicate_detection_history_time_window: Optional[pulumi.Input[builtins.str]] = None,
                 express_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 max_message_size_in_kilobytes: Optional[pulumi.Input[builtins.int]] = None,
                 max_size_in_megabytes: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace_id: Optional[pulumi.Input[builtins.str]] = None,
                 partitioning_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 requires_duplicate_detection: Optional[pulumi.Input[builtins.bool]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 support_ordering: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        Manages a ServiceBus Topic.

        > **Note:** Topics can only be created in Namespaces with an SKU of `Standard` or higher.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="tfex-servicebus-topic",
            location="West Europe")
        example_namespace = azure.servicebus.Namespace("example",
            name="tfex-servicebus-namespace",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard",
            tags={
                "source": "example",
            })
        example_topic = azure.servicebus.Topic("example",
            name="tfex_servicebus_topic",
            namespace_id=example_namespace.id,
            partitioning_enabled=True)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ServiceBus`: 2022-10-01-preview, 2021-06-01-preview

        ## Import

        Service Bus Topics can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:servicebus/topic:Topic example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ServiceBus/namespaces/sbns1/topics/sntopic1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] auto_delete_on_idle: The ISO 8601 timespan duration of the idle interval after which the Topic is automatically deleted, minimum of 5 minutes. Defaults to `P10675199DT2H48M5.4775807S`.
        :param pulumi.Input[builtins.bool] batched_operations_enabled: Boolean flag which controls if server-side batched operations are enabled.
        :param pulumi.Input[builtins.str] default_message_ttl: The ISO 8601 timespan duration of TTL of messages sent to this topic if no TTL value is set on the message itself. Defaults to `P10675199DT2H48M5.4775807S`.
        :param pulumi.Input[builtins.str] duplicate_detection_history_time_window: The ISO 8601 timespan duration during which duplicates can be detected. Defaults to `PT10M` (10 Minutes).
        :param pulumi.Input[builtins.bool] express_enabled: Boolean flag which controls whether Express Entities are enabled. An express topic holds a message in memory temporarily before writing it to persistent storage.
        :param pulumi.Input[builtins.int] max_message_size_in_kilobytes: Integer value which controls the maximum size of a message allowed on the topic for Premium SKU. For supported values see the "Large messages support" section of [this document](https://docs.microsoft.com/azure/service-bus-messaging/service-bus-premium-messaging#large-messages-support-preview). Defaults to `256`.
        :param pulumi.Input[builtins.int] max_size_in_megabytes: Integer value which controls the size of memory allocated for the topic. For supported values see the "Queue/topic size" section of [this document](https://docs.microsoft.com/azure/service-bus-messaging/service-bus-quotas). Defaults to `5120`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the ServiceBus Topic resource. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] namespace_id: The ID of the ServiceBus Namespace to create this topic in. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] partitioning_enabled: Boolean flag which controls whether to enable the topic to be partitioned across multiple message brokers. Changing this forces a new resource to be created.
               
               > **Note:** Partitioning is available at entity creation for all queues and topics in Basic or Standard SKUs. It is not available for the Premium messaging SKU, but any previously existing partitioned entities in Premium namespaces continue to work as expected. For premium namespaces, partitioning is available at namespace creation and all queues and topics in the partitioned namespace will be partitioned. Premium namespaces that have `premium_messaging_partitions` set to `1` are not partitioned. Please [see the documentation](https://docs.microsoft.com/azure/service-bus-messaging/service-bus-partitioning) for more information.
        :param pulumi.Input[builtins.bool] requires_duplicate_detection: Boolean flag which controls whether the Topic requires duplicate detection. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] status: The Status of the Service Bus Topic. Acceptable values are `Active` or `Disabled`. Defaults to `Active`.
        :param pulumi.Input[builtins.bool] support_ordering: Boolean flag which controls whether the Topic supports ordering.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TopicArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a ServiceBus Topic.

        > **Note:** Topics can only be created in Namespaces with an SKU of `Standard` or higher.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="tfex-servicebus-topic",
            location="West Europe")
        example_namespace = azure.servicebus.Namespace("example",
            name="tfex-servicebus-namespace",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard",
            tags={
                "source": "example",
            })
        example_topic = azure.servicebus.Topic("example",
            name="tfex_servicebus_topic",
            namespace_id=example_namespace.id,
            partitioning_enabled=True)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ServiceBus`: 2022-10-01-preview, 2021-06-01-preview

        ## Import

        Service Bus Topics can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:servicebus/topic:Topic example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ServiceBus/namespaces/sbns1/topics/sntopic1
        ```

        :param str resource_name: The name of the resource.
        :param TopicArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TopicArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_delete_on_idle: Optional[pulumi.Input[builtins.str]] = None,
                 batched_operations_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 default_message_ttl: Optional[pulumi.Input[builtins.str]] = None,
                 duplicate_detection_history_time_window: Optional[pulumi.Input[builtins.str]] = None,
                 express_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 max_message_size_in_kilobytes: Optional[pulumi.Input[builtins.int]] = None,
                 max_size_in_megabytes: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace_id: Optional[pulumi.Input[builtins.str]] = None,
                 partitioning_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 requires_duplicate_detection: Optional[pulumi.Input[builtins.bool]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 support_ordering: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TopicArgs.__new__(TopicArgs)

            __props__.__dict__["auto_delete_on_idle"] = auto_delete_on_idle
            __props__.__dict__["batched_operations_enabled"] = batched_operations_enabled
            __props__.__dict__["default_message_ttl"] = default_message_ttl
            __props__.__dict__["duplicate_detection_history_time_window"] = duplicate_detection_history_time_window
            __props__.__dict__["express_enabled"] = express_enabled
            __props__.__dict__["max_message_size_in_kilobytes"] = max_message_size_in_kilobytes
            __props__.__dict__["max_size_in_megabytes"] = max_size_in_megabytes
            __props__.__dict__["name"] = name
            if namespace_id is None and not opts.urn:
                raise TypeError("Missing required property 'namespace_id'")
            __props__.__dict__["namespace_id"] = namespace_id
            __props__.__dict__["partitioning_enabled"] = partitioning_enabled
            __props__.__dict__["requires_duplicate_detection"] = requires_duplicate_detection
            __props__.__dict__["status"] = status
            __props__.__dict__["support_ordering"] = support_ordering
            __props__.__dict__["namespace_name"] = None
            __props__.__dict__["resource_group_name"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure:eventhub/topic:Topic")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Topic, __self__).__init__(
            'azure:servicebus/topic:Topic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_delete_on_idle: Optional[pulumi.Input[builtins.str]] = None,
            batched_operations_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            default_message_ttl: Optional[pulumi.Input[builtins.str]] = None,
            duplicate_detection_history_time_window: Optional[pulumi.Input[builtins.str]] = None,
            express_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            max_message_size_in_kilobytes: Optional[pulumi.Input[builtins.int]] = None,
            max_size_in_megabytes: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            namespace_id: Optional[pulumi.Input[builtins.str]] = None,
            namespace_name: Optional[pulumi.Input[builtins.str]] = None,
            partitioning_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            requires_duplicate_detection: Optional[pulumi.Input[builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            support_ordering: Optional[pulumi.Input[builtins.bool]] = None) -> 'Topic':
        """
        Get an existing Topic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] auto_delete_on_idle: The ISO 8601 timespan duration of the idle interval after which the Topic is automatically deleted, minimum of 5 minutes. Defaults to `P10675199DT2H48M5.4775807S`.
        :param pulumi.Input[builtins.bool] batched_operations_enabled: Boolean flag which controls if server-side batched operations are enabled.
        :param pulumi.Input[builtins.str] default_message_ttl: The ISO 8601 timespan duration of TTL of messages sent to this topic if no TTL value is set on the message itself. Defaults to `P10675199DT2H48M5.4775807S`.
        :param pulumi.Input[builtins.str] duplicate_detection_history_time_window: The ISO 8601 timespan duration during which duplicates can be detected. Defaults to `PT10M` (10 Minutes).
        :param pulumi.Input[builtins.bool] express_enabled: Boolean flag which controls whether Express Entities are enabled. An express topic holds a message in memory temporarily before writing it to persistent storage.
        :param pulumi.Input[builtins.int] max_message_size_in_kilobytes: Integer value which controls the maximum size of a message allowed on the topic for Premium SKU. For supported values see the "Large messages support" section of [this document](https://docs.microsoft.com/azure/service-bus-messaging/service-bus-premium-messaging#large-messages-support-preview). Defaults to `256`.
        :param pulumi.Input[builtins.int] max_size_in_megabytes: Integer value which controls the size of memory allocated for the topic. For supported values see the "Queue/topic size" section of [this document](https://docs.microsoft.com/azure/service-bus-messaging/service-bus-quotas). Defaults to `5120`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the ServiceBus Topic resource. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] namespace_id: The ID of the ServiceBus Namespace to create this topic in. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] partitioning_enabled: Boolean flag which controls whether to enable the topic to be partitioned across multiple message brokers. Changing this forces a new resource to be created.
               
               > **Note:** Partitioning is available at entity creation for all queues and topics in Basic or Standard SKUs. It is not available for the Premium messaging SKU, but any previously existing partitioned entities in Premium namespaces continue to work as expected. For premium namespaces, partitioning is available at namespace creation and all queues and topics in the partitioned namespace will be partitioned. Premium namespaces that have `premium_messaging_partitions` set to `1` are not partitioned. Please [see the documentation](https://docs.microsoft.com/azure/service-bus-messaging/service-bus-partitioning) for more information.
        :param pulumi.Input[builtins.bool] requires_duplicate_detection: Boolean flag which controls whether the Topic requires duplicate detection. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] status: The Status of the Service Bus Topic. Acceptable values are `Active` or `Disabled`. Defaults to `Active`.
        :param pulumi.Input[builtins.bool] support_ordering: Boolean flag which controls whether the Topic supports ordering.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TopicState.__new__(_TopicState)

        __props__.__dict__["auto_delete_on_idle"] = auto_delete_on_idle
        __props__.__dict__["batched_operations_enabled"] = batched_operations_enabled
        __props__.__dict__["default_message_ttl"] = default_message_ttl
        __props__.__dict__["duplicate_detection_history_time_window"] = duplicate_detection_history_time_window
        __props__.__dict__["express_enabled"] = express_enabled
        __props__.__dict__["max_message_size_in_kilobytes"] = max_message_size_in_kilobytes
        __props__.__dict__["max_size_in_megabytes"] = max_size_in_megabytes
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace_id"] = namespace_id
        __props__.__dict__["namespace_name"] = namespace_name
        __props__.__dict__["partitioning_enabled"] = partitioning_enabled
        __props__.__dict__["requires_duplicate_detection"] = requires_duplicate_detection
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["status"] = status
        __props__.__dict__["support_ordering"] = support_ordering
        return Topic(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoDeleteOnIdle")
    def auto_delete_on_idle(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ISO 8601 timespan duration of the idle interval after which the Topic is automatically deleted, minimum of 5 minutes. Defaults to `P10675199DT2H48M5.4775807S`.
        """
        return pulumi.get(self, "auto_delete_on_idle")

    @property
    @pulumi.getter(name="batchedOperationsEnabled")
    def batched_operations_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Boolean flag which controls if server-side batched operations are enabled.
        """
        return pulumi.get(self, "batched_operations_enabled")

    @property
    @pulumi.getter(name="defaultMessageTtl")
    def default_message_ttl(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ISO 8601 timespan duration of TTL of messages sent to this topic if no TTL value is set on the message itself. Defaults to `P10675199DT2H48M5.4775807S`.
        """
        return pulumi.get(self, "default_message_ttl")

    @property
    @pulumi.getter(name="duplicateDetectionHistoryTimeWindow")
    def duplicate_detection_history_time_window(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ISO 8601 timespan duration during which duplicates can be detected. Defaults to `PT10M` (10 Minutes).
        """
        return pulumi.get(self, "duplicate_detection_history_time_window")

    @property
    @pulumi.getter(name="expressEnabled")
    def express_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Boolean flag which controls whether Express Entities are enabled. An express topic holds a message in memory temporarily before writing it to persistent storage.
        """
        return pulumi.get(self, "express_enabled")

    @property
    @pulumi.getter(name="maxMessageSizeInKilobytes")
    def max_message_size_in_kilobytes(self) -> pulumi.Output[builtins.int]:
        """
        Integer value which controls the maximum size of a message allowed on the topic for Premium SKU. For supported values see the "Large messages support" section of [this document](https://docs.microsoft.com/azure/service-bus-messaging/service-bus-premium-messaging#large-messages-support-preview). Defaults to `256`.
        """
        return pulumi.get(self, "max_message_size_in_kilobytes")

    @property
    @pulumi.getter(name="maxSizeInMegabytes")
    def max_size_in_megabytes(self) -> pulumi.Output[builtins.int]:
        """
        Integer value which controls the size of memory allocated for the topic. For supported values see the "Queue/topic size" section of [this document](https://docs.microsoft.com/azure/service-bus-messaging/service-bus-quotas). Defaults to `5120`.
        """
        return pulumi.get(self, "max_size_in_megabytes")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the ServiceBus Topic resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the ServiceBus Namespace to create this topic in. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "namespace_id")

    @property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "namespace_name")

    @property
    @pulumi.getter(name="partitioningEnabled")
    def partitioning_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Boolean flag which controls whether to enable the topic to be partitioned across multiple message brokers. Changing this forces a new resource to be created.

        > **Note:** Partitioning is available at entity creation for all queues and topics in Basic or Standard SKUs. It is not available for the Premium messaging SKU, but any previously existing partitioned entities in Premium namespaces continue to work as expected. For premium namespaces, partitioning is available at namespace creation and all queues and topics in the partitioned namespace will be partitioned. Premium namespaces that have `premium_messaging_partitions` set to `1` are not partitioned. Please [see the documentation](https://docs.microsoft.com/azure/service-bus-messaging/service-bus-partitioning) for more information.
        """
        return pulumi.get(self, "partitioning_enabled")

    @property
    @pulumi.getter(name="requiresDuplicateDetection")
    def requires_duplicate_detection(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Boolean flag which controls whether the Topic requires duplicate detection. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "requires_duplicate_detection")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Status of the Service Bus Topic. Acceptable values are `Active` or `Disabled`. Defaults to `Active`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="supportOrdering")
    def support_ordering(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Boolean flag which controls whether the Topic supports ordering.
        """
        return pulumi.get(self, "support_ordering")

