# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ClusterAzureActiveDirectoryArgs',
    'ClusterAzureActiveDirectoryArgsDict',
    'ClusterCertificateArgs',
    'ClusterCertificateArgsDict',
    'ClusterCertificateCommonNamesArgs',
    'ClusterCertificateCommonNamesArgsDict',
    'ClusterCertificateCommonNamesCommonNameArgs',
    'ClusterCertificateCommonNamesCommonNameArgsDict',
    'ClusterClientCertificateCommonNameArgs',
    'ClusterClientCertificateCommonNameArgsDict',
    'ClusterClientCertificateThumbprintArgs',
    'ClusterClientCertificateThumbprintArgsDict',
    'ClusterDiagnosticsConfigArgs',
    'ClusterDiagnosticsConfigArgsDict',
    'ClusterFabricSettingArgs',
    'ClusterFabricSettingArgsDict',
    'ClusterNodeTypeArgs',
    'ClusterNodeTypeArgsDict',
    'ClusterNodeTypeApplicationPortsArgs',
    'ClusterNodeTypeApplicationPortsArgsDict',
    'ClusterNodeTypeEphemeralPortsArgs',
    'ClusterNodeTypeEphemeralPortsArgsDict',
    'ClusterReverseProxyCertificateArgs',
    'ClusterReverseProxyCertificateArgsDict',
    'ClusterReverseProxyCertificateCommonNamesArgs',
    'ClusterReverseProxyCertificateCommonNamesArgsDict',
    'ClusterReverseProxyCertificateCommonNamesCommonNameArgs',
    'ClusterReverseProxyCertificateCommonNamesCommonNameArgsDict',
    'ClusterUpgradePolicyArgs',
    'ClusterUpgradePolicyArgsDict',
    'ClusterUpgradePolicyDeltaHealthPolicyArgs',
    'ClusterUpgradePolicyDeltaHealthPolicyArgsDict',
    'ClusterUpgradePolicyHealthPolicyArgs',
    'ClusterUpgradePolicyHealthPolicyArgsDict',
    'ManagedClusterAuthenticationArgs',
    'ManagedClusterAuthenticationArgsDict',
    'ManagedClusterAuthenticationActiveDirectoryArgs',
    'ManagedClusterAuthenticationActiveDirectoryArgsDict',
    'ManagedClusterAuthenticationCertificateArgs',
    'ManagedClusterAuthenticationCertificateArgsDict',
    'ManagedClusterCustomFabricSettingArgs',
    'ManagedClusterCustomFabricSettingArgsDict',
    'ManagedClusterLbRuleArgs',
    'ManagedClusterLbRuleArgsDict',
    'ManagedClusterNodeTypeArgs',
    'ManagedClusterNodeTypeArgsDict',
    'ManagedClusterNodeTypeVmSecretArgs',
    'ManagedClusterNodeTypeVmSecretArgsDict',
    'ManagedClusterNodeTypeVmSecretCertificateArgs',
    'ManagedClusterNodeTypeVmSecretCertificateArgsDict',
]

MYPY = False

if not MYPY:
    class ClusterAzureActiveDirectoryArgsDict(TypedDict):
        client_application_id: pulumi.Input[builtins.str]
        """
        The Azure Active Directory Client ID which should be used for the Client Application.
        """
        cluster_application_id: pulumi.Input[builtins.str]
        """
        The Azure Active Directory Cluster Application ID.
        """
        tenant_id: pulumi.Input[builtins.str]
        """
        The Azure Active Directory Tenant ID.
        """
elif False:
    ClusterAzureActiveDirectoryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterAzureActiveDirectoryArgs:
    def __init__(__self__, *,
                 client_application_id: pulumi.Input[builtins.str],
                 cluster_application_id: pulumi.Input[builtins.str],
                 tenant_id: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] client_application_id: The Azure Active Directory Client ID which should be used for the Client Application.
        :param pulumi.Input[builtins.str] cluster_application_id: The Azure Active Directory Cluster Application ID.
        :param pulumi.Input[builtins.str] tenant_id: The Azure Active Directory Tenant ID.
        """
        pulumi.set(__self__, "client_application_id", client_application_id)
        pulumi.set(__self__, "cluster_application_id", cluster_application_id)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="clientApplicationId")
    def client_application_id(self) -> pulumi.Input[builtins.str]:
        """
        The Azure Active Directory Client ID which should be used for the Client Application.
        """
        return pulumi.get(self, "client_application_id")

    @client_application_id.setter
    def client_application_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "client_application_id", value)

    @property
    @pulumi.getter(name="clusterApplicationId")
    def cluster_application_id(self) -> pulumi.Input[builtins.str]:
        """
        The Azure Active Directory Cluster Application ID.
        """
        return pulumi.get(self, "cluster_application_id")

    @cluster_application_id.setter
    def cluster_application_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster_application_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[builtins.str]:
        """
        The Azure Active Directory Tenant ID.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class ClusterCertificateArgsDict(TypedDict):
        thumbprint: pulumi.Input[builtins.str]
        """
        The Thumbprint of the Certificate.
        """
        x509_store_name: pulumi.Input[builtins.str]
        """
        The X509 Store where the Certificate Exists, such as `My`.
        """
        thumbprint_secondary: NotRequired[pulumi.Input[builtins.str]]
        """
        The Secondary Thumbprint of the Certificate.
        """
elif False:
    ClusterCertificateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterCertificateArgs:
    def __init__(__self__, *,
                 thumbprint: pulumi.Input[builtins.str],
                 x509_store_name: pulumi.Input[builtins.str],
                 thumbprint_secondary: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] thumbprint: The Thumbprint of the Certificate.
        :param pulumi.Input[builtins.str] x509_store_name: The X509 Store where the Certificate Exists, such as `My`.
        :param pulumi.Input[builtins.str] thumbprint_secondary: The Secondary Thumbprint of the Certificate.
        """
        pulumi.set(__self__, "thumbprint", thumbprint)
        pulumi.set(__self__, "x509_store_name", x509_store_name)
        if thumbprint_secondary is not None:
            pulumi.set(__self__, "thumbprint_secondary", thumbprint_secondary)

    @property
    @pulumi.getter
    def thumbprint(self) -> pulumi.Input[builtins.str]:
        """
        The Thumbprint of the Certificate.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "thumbprint", value)

    @property
    @pulumi.getter(name="x509StoreName")
    def x509_store_name(self) -> pulumi.Input[builtins.str]:
        """
        The X509 Store where the Certificate Exists, such as `My`.
        """
        return pulumi.get(self, "x509_store_name")

    @x509_store_name.setter
    def x509_store_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "x509_store_name", value)

    @property
    @pulumi.getter(name="thumbprintSecondary")
    def thumbprint_secondary(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Secondary Thumbprint of the Certificate.
        """
        return pulumi.get(self, "thumbprint_secondary")

    @thumbprint_secondary.setter
    def thumbprint_secondary(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "thumbprint_secondary", value)


if not MYPY:
    class ClusterCertificateCommonNamesArgsDict(TypedDict):
        common_names: pulumi.Input[Sequence[pulumi.Input['ClusterCertificateCommonNamesCommonNameArgsDict']]]
        """
        A `common_names` block as defined below.
        """
        x509_store_name: pulumi.Input[builtins.str]
        """
        The X509 Store where the Certificate Exists, such as `My`.
        """
elif False:
    ClusterCertificateCommonNamesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterCertificateCommonNamesArgs:
    def __init__(__self__, *,
                 common_names: pulumi.Input[Sequence[pulumi.Input['ClusterCertificateCommonNamesCommonNameArgs']]],
                 x509_store_name: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ClusterCertificateCommonNamesCommonNameArgs']]] common_names: A `common_names` block as defined below.
        :param pulumi.Input[builtins.str] x509_store_name: The X509 Store where the Certificate Exists, such as `My`.
        """
        pulumi.set(__self__, "common_names", common_names)
        pulumi.set(__self__, "x509_store_name", x509_store_name)

    @property
    @pulumi.getter(name="commonNames")
    def common_names(self) -> pulumi.Input[Sequence[pulumi.Input['ClusterCertificateCommonNamesCommonNameArgs']]]:
        """
        A `common_names` block as defined below.
        """
        return pulumi.get(self, "common_names")

    @common_names.setter
    def common_names(self, value: pulumi.Input[Sequence[pulumi.Input['ClusterCertificateCommonNamesCommonNameArgs']]]):
        pulumi.set(self, "common_names", value)

    @property
    @pulumi.getter(name="x509StoreName")
    def x509_store_name(self) -> pulumi.Input[builtins.str]:
        """
        The X509 Store where the Certificate Exists, such as `My`.
        """
        return pulumi.get(self, "x509_store_name")

    @x509_store_name.setter
    def x509_store_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "x509_store_name", value)


if not MYPY:
    class ClusterCertificateCommonNamesCommonNameArgsDict(TypedDict):
        certificate_common_name: pulumi.Input[builtins.str]
        """
        The common or subject name of the certificate.
        """
        certificate_issuer_thumbprint: NotRequired[pulumi.Input[builtins.str]]
        """
        The Issuer Thumbprint of the Certificate.

        > **Note:** Certificate Issuer Thumbprint may become required in the future, `https://docs.microsoft.com/azure/service-fabric/service-fabric-create-cluster-using-cert-cn#download-and-update-a-sample-template`.
        """
elif False:
    ClusterCertificateCommonNamesCommonNameArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterCertificateCommonNamesCommonNameArgs:
    def __init__(__self__, *,
                 certificate_common_name: pulumi.Input[builtins.str],
                 certificate_issuer_thumbprint: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] certificate_common_name: The common or subject name of the certificate.
        :param pulumi.Input[builtins.str] certificate_issuer_thumbprint: The Issuer Thumbprint of the Certificate.
               
               > **Note:** Certificate Issuer Thumbprint may become required in the future, `https://docs.microsoft.com/azure/service-fabric/service-fabric-create-cluster-using-cert-cn#download-and-update-a-sample-template`.
        """
        pulumi.set(__self__, "certificate_common_name", certificate_common_name)
        if certificate_issuer_thumbprint is not None:
            pulumi.set(__self__, "certificate_issuer_thumbprint", certificate_issuer_thumbprint)

    @property
    @pulumi.getter(name="certificateCommonName")
    def certificate_common_name(self) -> pulumi.Input[builtins.str]:
        """
        The common or subject name of the certificate.
        """
        return pulumi.get(self, "certificate_common_name")

    @certificate_common_name.setter
    def certificate_common_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "certificate_common_name", value)

    @property
    @pulumi.getter(name="certificateIssuerThumbprint")
    def certificate_issuer_thumbprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Issuer Thumbprint of the Certificate.

        > **Note:** Certificate Issuer Thumbprint may become required in the future, `https://docs.microsoft.com/azure/service-fabric/service-fabric-create-cluster-using-cert-cn#download-and-update-a-sample-template`.
        """
        return pulumi.get(self, "certificate_issuer_thumbprint")

    @certificate_issuer_thumbprint.setter
    def certificate_issuer_thumbprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_issuer_thumbprint", value)


if not MYPY:
    class ClusterClientCertificateCommonNameArgsDict(TypedDict):
        common_name: pulumi.Input[builtins.str]
        """
        The common or subject name of the certificate.
        """
        is_admin: pulumi.Input[builtins.bool]
        """
        Does the Client Certificate have Admin Access to the cluster? Non-admin clients can only perform read only operations on the cluster.
        """
        issuer_thumbprint: NotRequired[pulumi.Input[builtins.str]]
        """
        The Issuer Thumbprint of the Certificate.

        > **Note:** Certificate Issuer Thumbprint may become required in the future, `https://docs.microsoft.com/azure/service-fabric/service-fabric-create-cluster-using-cert-cn#download-and-update-a-sample-template`.
        """
elif False:
    ClusterClientCertificateCommonNameArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterClientCertificateCommonNameArgs:
    def __init__(__self__, *,
                 common_name: pulumi.Input[builtins.str],
                 is_admin: pulumi.Input[builtins.bool],
                 issuer_thumbprint: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] common_name: The common or subject name of the certificate.
        :param pulumi.Input[builtins.bool] is_admin: Does the Client Certificate have Admin Access to the cluster? Non-admin clients can only perform read only operations on the cluster.
        :param pulumi.Input[builtins.str] issuer_thumbprint: The Issuer Thumbprint of the Certificate.
               
               > **Note:** Certificate Issuer Thumbprint may become required in the future, `https://docs.microsoft.com/azure/service-fabric/service-fabric-create-cluster-using-cert-cn#download-and-update-a-sample-template`.
        """
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "is_admin", is_admin)
        if issuer_thumbprint is not None:
            pulumi.set(__self__, "issuer_thumbprint", issuer_thumbprint)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Input[builtins.str]:
        """
        The common or subject name of the certificate.
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "common_name", value)

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> pulumi.Input[builtins.bool]:
        """
        Does the Client Certificate have Admin Access to the cluster? Non-admin clients can only perform read only operations on the cluster.
        """
        return pulumi.get(self, "is_admin")

    @is_admin.setter
    def is_admin(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "is_admin", value)

    @property
    @pulumi.getter(name="issuerThumbprint")
    def issuer_thumbprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Issuer Thumbprint of the Certificate.

        > **Note:** Certificate Issuer Thumbprint may become required in the future, `https://docs.microsoft.com/azure/service-fabric/service-fabric-create-cluster-using-cert-cn#download-and-update-a-sample-template`.
        """
        return pulumi.get(self, "issuer_thumbprint")

    @issuer_thumbprint.setter
    def issuer_thumbprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "issuer_thumbprint", value)


if not MYPY:
    class ClusterClientCertificateThumbprintArgsDict(TypedDict):
        is_admin: pulumi.Input[builtins.bool]
        """
        Does the Client Certificate have Admin Access to the cluster? Non-admin clients can only perform read only operations on the cluster.
        """
        thumbprint: pulumi.Input[builtins.str]
        """
        The Thumbprint associated with the Client Certificate.
        """
elif False:
    ClusterClientCertificateThumbprintArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterClientCertificateThumbprintArgs:
    def __init__(__self__, *,
                 is_admin: pulumi.Input[builtins.bool],
                 thumbprint: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.bool] is_admin: Does the Client Certificate have Admin Access to the cluster? Non-admin clients can only perform read only operations on the cluster.
        :param pulumi.Input[builtins.str] thumbprint: The Thumbprint associated with the Client Certificate.
        """
        pulumi.set(__self__, "is_admin", is_admin)
        pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> pulumi.Input[builtins.bool]:
        """
        Does the Client Certificate have Admin Access to the cluster? Non-admin clients can only perform read only operations on the cluster.
        """
        return pulumi.get(self, "is_admin")

    @is_admin.setter
    def is_admin(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "is_admin", value)

    @property
    @pulumi.getter
    def thumbprint(self) -> pulumi.Input[builtins.str]:
        """
        The Thumbprint associated with the Client Certificate.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "thumbprint", value)


if not MYPY:
    class ClusterDiagnosticsConfigArgsDict(TypedDict):
        blob_endpoint: pulumi.Input[builtins.str]
        """
        The Blob Endpoint of the Storage Account.
        """
        protected_account_key_name: pulumi.Input[builtins.str]
        """
        The protected diagnostics storage key name, such as `StorageAccountKey1`.
        """
        queue_endpoint: pulumi.Input[builtins.str]
        """
        The Queue Endpoint of the Storage Account.
        """
        storage_account_name: pulumi.Input[builtins.str]
        """
        The name of the Storage Account where the Diagnostics should be sent to.
        """
        table_endpoint: pulumi.Input[builtins.str]
        """
        The Table Endpoint of the Storage Account.
        """
elif False:
    ClusterDiagnosticsConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterDiagnosticsConfigArgs:
    def __init__(__self__, *,
                 blob_endpoint: pulumi.Input[builtins.str],
                 protected_account_key_name: pulumi.Input[builtins.str],
                 queue_endpoint: pulumi.Input[builtins.str],
                 storage_account_name: pulumi.Input[builtins.str],
                 table_endpoint: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] blob_endpoint: The Blob Endpoint of the Storage Account.
        :param pulumi.Input[builtins.str] protected_account_key_name: The protected diagnostics storage key name, such as `StorageAccountKey1`.
        :param pulumi.Input[builtins.str] queue_endpoint: The Queue Endpoint of the Storage Account.
        :param pulumi.Input[builtins.str] storage_account_name: The name of the Storage Account where the Diagnostics should be sent to.
        :param pulumi.Input[builtins.str] table_endpoint: The Table Endpoint of the Storage Account.
        """
        pulumi.set(__self__, "blob_endpoint", blob_endpoint)
        pulumi.set(__self__, "protected_account_key_name", protected_account_key_name)
        pulumi.set(__self__, "queue_endpoint", queue_endpoint)
        pulumi.set(__self__, "storage_account_name", storage_account_name)
        pulumi.set(__self__, "table_endpoint", table_endpoint)

    @property
    @pulumi.getter(name="blobEndpoint")
    def blob_endpoint(self) -> pulumi.Input[builtins.str]:
        """
        The Blob Endpoint of the Storage Account.
        """
        return pulumi.get(self, "blob_endpoint")

    @blob_endpoint.setter
    def blob_endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "blob_endpoint", value)

    @property
    @pulumi.getter(name="protectedAccountKeyName")
    def protected_account_key_name(self) -> pulumi.Input[builtins.str]:
        """
        The protected diagnostics storage key name, such as `StorageAccountKey1`.
        """
        return pulumi.get(self, "protected_account_key_name")

    @protected_account_key_name.setter
    def protected_account_key_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "protected_account_key_name", value)

    @property
    @pulumi.getter(name="queueEndpoint")
    def queue_endpoint(self) -> pulumi.Input[builtins.str]:
        """
        The Queue Endpoint of the Storage Account.
        """
        return pulumi.get(self, "queue_endpoint")

    @queue_endpoint.setter
    def queue_endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "queue_endpoint", value)

    @property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Storage Account where the Diagnostics should be sent to.
        """
        return pulumi.get(self, "storage_account_name")

    @storage_account_name.setter
    def storage_account_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "storage_account_name", value)

    @property
    @pulumi.getter(name="tableEndpoint")
    def table_endpoint(self) -> pulumi.Input[builtins.str]:
        """
        The Table Endpoint of the Storage Account.
        """
        return pulumi.get(self, "table_endpoint")

    @table_endpoint.setter
    def table_endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "table_endpoint", value)


if not MYPY:
    class ClusterFabricSettingArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        The name of the Fabric Setting, such as `Security` or `Federation`.
        """
        parameters: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        A map containing settings for the specified Fabric Setting.
        """
elif False:
    ClusterFabricSettingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterFabricSettingArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] name: The name of the Fabric Setting, such as `Security` or `Federation`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: A map containing settings for the specified Fabric Setting.
        """
        pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Fabric Setting, such as `Security` or `Federation`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map containing settings for the specified Fabric Setting.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "parameters", value)


if not MYPY:
    class ClusterNodeTypeArgsDict(TypedDict):
        client_endpoint_port: pulumi.Input[builtins.int]
        """
        The Port used for the Client Endpoint for this Node Type.
        """
        http_endpoint_port: pulumi.Input[builtins.int]
        """
        The Port used for the HTTP Endpoint for this Node Type.
        """
        instance_count: pulumi.Input[builtins.int]
        """
        The number of nodes for this Node Type.
        """
        is_primary: pulumi.Input[builtins.bool]
        """
        Is this the Primary Node Type?
        """
        name: pulumi.Input[builtins.str]
        """
        The name of the Node Type.
        """
        application_ports: NotRequired[pulumi.Input['ClusterNodeTypeApplicationPortsArgsDict']]
        """
        A `application_ports` block as defined below.
        """
        capacities: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        The capacity tags applied to the nodes in the node type, the cluster resource manager uses these tags to understand how much resource a node has.
        """
        durability_level: NotRequired[pulumi.Input[builtins.str]]
        """
        The Durability Level for this Node Type. Possible values include `Bronze`, `Gold` and `Silver`. Defaults to `Bronze`.
        """
        ephemeral_ports: NotRequired[pulumi.Input['ClusterNodeTypeEphemeralPortsArgsDict']]
        """
        A `ephemeral_ports` block as defined below.
        """
        is_stateless: NotRequired[pulumi.Input[builtins.bool]]
        """
        Should this node type run only stateless services?
        """
        multiple_availability_zones: NotRequired[pulumi.Input[builtins.bool]]
        """
        Does this node type span availability zones?
        """
        placement_properties: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        The placement tags applied to nodes in the node type, which can be used to indicate where certain services (workload) should run.
        """
        reverse_proxy_endpoint_port: NotRequired[pulumi.Input[builtins.int]]
        """
        The Port used for the Reverse Proxy Endpoint for this Node Type. Changing this will upgrade the cluster.
        """
elif False:
    ClusterNodeTypeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeTypeArgs:
    def __init__(__self__, *,
                 client_endpoint_port: pulumi.Input[builtins.int],
                 http_endpoint_port: pulumi.Input[builtins.int],
                 instance_count: pulumi.Input[builtins.int],
                 is_primary: pulumi.Input[builtins.bool],
                 name: pulumi.Input[builtins.str],
                 application_ports: Optional[pulumi.Input['ClusterNodeTypeApplicationPortsArgs']] = None,
                 capacities: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 durability_level: Optional[pulumi.Input[builtins.str]] = None,
                 ephemeral_ports: Optional[pulumi.Input['ClusterNodeTypeEphemeralPortsArgs']] = None,
                 is_stateless: Optional[pulumi.Input[builtins.bool]] = None,
                 multiple_availability_zones: Optional[pulumi.Input[builtins.bool]] = None,
                 placement_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 reverse_proxy_endpoint_port: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] client_endpoint_port: The Port used for the Client Endpoint for this Node Type.
        :param pulumi.Input[builtins.int] http_endpoint_port: The Port used for the HTTP Endpoint for this Node Type.
        :param pulumi.Input[builtins.int] instance_count: The number of nodes for this Node Type.
        :param pulumi.Input[builtins.bool] is_primary: Is this the Primary Node Type?
        :param pulumi.Input[builtins.str] name: The name of the Node Type.
        :param pulumi.Input['ClusterNodeTypeApplicationPortsArgs'] application_ports: A `application_ports` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] capacities: The capacity tags applied to the nodes in the node type, the cluster resource manager uses these tags to understand how much resource a node has.
        :param pulumi.Input[builtins.str] durability_level: The Durability Level for this Node Type. Possible values include `Bronze`, `Gold` and `Silver`. Defaults to `Bronze`.
        :param pulumi.Input['ClusterNodeTypeEphemeralPortsArgs'] ephemeral_ports: A `ephemeral_ports` block as defined below.
        :param pulumi.Input[builtins.bool] is_stateless: Should this node type run only stateless services?
        :param pulumi.Input[builtins.bool] multiple_availability_zones: Does this node type span availability zones?
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] placement_properties: The placement tags applied to nodes in the node type, which can be used to indicate where certain services (workload) should run.
        :param pulumi.Input[builtins.int] reverse_proxy_endpoint_port: The Port used for the Reverse Proxy Endpoint for this Node Type. Changing this will upgrade the cluster.
        """
        pulumi.set(__self__, "client_endpoint_port", client_endpoint_port)
        pulumi.set(__self__, "http_endpoint_port", http_endpoint_port)
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "is_primary", is_primary)
        pulumi.set(__self__, "name", name)
        if application_ports is not None:
            pulumi.set(__self__, "application_ports", application_ports)
        if capacities is not None:
            pulumi.set(__self__, "capacities", capacities)
        if durability_level is not None:
            pulumi.set(__self__, "durability_level", durability_level)
        if ephemeral_ports is not None:
            pulumi.set(__self__, "ephemeral_ports", ephemeral_ports)
        if is_stateless is not None:
            pulumi.set(__self__, "is_stateless", is_stateless)
        if multiple_availability_zones is not None:
            pulumi.set(__self__, "multiple_availability_zones", multiple_availability_zones)
        if placement_properties is not None:
            pulumi.set(__self__, "placement_properties", placement_properties)
        if reverse_proxy_endpoint_port is not None:
            pulumi.set(__self__, "reverse_proxy_endpoint_port", reverse_proxy_endpoint_port)

    @property
    @pulumi.getter(name="clientEndpointPort")
    def client_endpoint_port(self) -> pulumi.Input[builtins.int]:
        """
        The Port used for the Client Endpoint for this Node Type.
        """
        return pulumi.get(self, "client_endpoint_port")

    @client_endpoint_port.setter
    def client_endpoint_port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "client_endpoint_port", value)

    @property
    @pulumi.getter(name="httpEndpointPort")
    def http_endpoint_port(self) -> pulumi.Input[builtins.int]:
        """
        The Port used for the HTTP Endpoint for this Node Type.
        """
        return pulumi.get(self, "http_endpoint_port")

    @http_endpoint_port.setter
    def http_endpoint_port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "http_endpoint_port", value)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> pulumi.Input[builtins.int]:
        """
        The number of nodes for this Node Type.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> pulumi.Input[builtins.bool]:
        """
        Is this the Primary Node Type?
        """
        return pulumi.get(self, "is_primary")

    @is_primary.setter
    def is_primary(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "is_primary", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Node Type.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="applicationPorts")
    def application_ports(self) -> Optional[pulumi.Input['ClusterNodeTypeApplicationPortsArgs']]:
        """
        A `application_ports` block as defined below.
        """
        return pulumi.get(self, "application_ports")

    @application_ports.setter
    def application_ports(self, value: Optional[pulumi.Input['ClusterNodeTypeApplicationPortsArgs']]):
        pulumi.set(self, "application_ports", value)

    @property
    @pulumi.getter
    def capacities(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The capacity tags applied to the nodes in the node type, the cluster resource manager uses these tags to understand how much resource a node has.
        """
        return pulumi.get(self, "capacities")

    @capacities.setter
    def capacities(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "capacities", value)

    @property
    @pulumi.getter(name="durabilityLevel")
    def durability_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Durability Level for this Node Type. Possible values include `Bronze`, `Gold` and `Silver`. Defaults to `Bronze`.
        """
        return pulumi.get(self, "durability_level")

    @durability_level.setter
    def durability_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "durability_level", value)

    @property
    @pulumi.getter(name="ephemeralPorts")
    def ephemeral_ports(self) -> Optional[pulumi.Input['ClusterNodeTypeEphemeralPortsArgs']]:
        """
        A `ephemeral_ports` block as defined below.
        """
        return pulumi.get(self, "ephemeral_ports")

    @ephemeral_ports.setter
    def ephemeral_ports(self, value: Optional[pulumi.Input['ClusterNodeTypeEphemeralPortsArgs']]):
        pulumi.set(self, "ephemeral_ports", value)

    @property
    @pulumi.getter(name="isStateless")
    def is_stateless(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should this node type run only stateless services?
        """
        return pulumi.get(self, "is_stateless")

    @is_stateless.setter
    def is_stateless(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_stateless", value)

    @property
    @pulumi.getter(name="multipleAvailabilityZones")
    def multiple_availability_zones(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Does this node type span availability zones?
        """
        return pulumi.get(self, "multiple_availability_zones")

    @multiple_availability_zones.setter
    def multiple_availability_zones(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "multiple_availability_zones", value)

    @property
    @pulumi.getter(name="placementProperties")
    def placement_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The placement tags applied to nodes in the node type, which can be used to indicate where certain services (workload) should run.
        """
        return pulumi.get(self, "placement_properties")

    @placement_properties.setter
    def placement_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "placement_properties", value)

    @property
    @pulumi.getter(name="reverseProxyEndpointPort")
    def reverse_proxy_endpoint_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The Port used for the Reverse Proxy Endpoint for this Node Type. Changing this will upgrade the cluster.
        """
        return pulumi.get(self, "reverse_proxy_endpoint_port")

    @reverse_proxy_endpoint_port.setter
    def reverse_proxy_endpoint_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "reverse_proxy_endpoint_port", value)


if not MYPY:
    class ClusterNodeTypeApplicationPortsArgsDict(TypedDict):
        end_port: pulumi.Input[builtins.int]
        """
        The end of the Application Port Range on this Node Type.
        """
        start_port: pulumi.Input[builtins.int]
        """
        The start of the Application Port Range on this Node Type.
        """
elif False:
    ClusterNodeTypeApplicationPortsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeTypeApplicationPortsArgs:
    def __init__(__self__, *,
                 end_port: pulumi.Input[builtins.int],
                 start_port: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.int] end_port: The end of the Application Port Range on this Node Type.
        :param pulumi.Input[builtins.int] start_port: The start of the Application Port Range on this Node Type.
        """
        pulumi.set(__self__, "end_port", end_port)
        pulumi.set(__self__, "start_port", start_port)

    @property
    @pulumi.getter(name="endPort")
    def end_port(self) -> pulumi.Input[builtins.int]:
        """
        The end of the Application Port Range on this Node Type.
        """
        return pulumi.get(self, "end_port")

    @end_port.setter
    def end_port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "end_port", value)

    @property
    @pulumi.getter(name="startPort")
    def start_port(self) -> pulumi.Input[builtins.int]:
        """
        The start of the Application Port Range on this Node Type.
        """
        return pulumi.get(self, "start_port")

    @start_port.setter
    def start_port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "start_port", value)


if not MYPY:
    class ClusterNodeTypeEphemeralPortsArgsDict(TypedDict):
        end_port: pulumi.Input[builtins.int]
        """
        The end of the Ephemeral Port Range on this Node Type.
        """
        start_port: pulumi.Input[builtins.int]
        """
        The start of the Ephemeral Port Range on this Node Type.
        """
elif False:
    ClusterNodeTypeEphemeralPortsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeTypeEphemeralPortsArgs:
    def __init__(__self__, *,
                 end_port: pulumi.Input[builtins.int],
                 start_port: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.int] end_port: The end of the Ephemeral Port Range on this Node Type.
        :param pulumi.Input[builtins.int] start_port: The start of the Ephemeral Port Range on this Node Type.
        """
        pulumi.set(__self__, "end_port", end_port)
        pulumi.set(__self__, "start_port", start_port)

    @property
    @pulumi.getter(name="endPort")
    def end_port(self) -> pulumi.Input[builtins.int]:
        """
        The end of the Ephemeral Port Range on this Node Type.
        """
        return pulumi.get(self, "end_port")

    @end_port.setter
    def end_port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "end_port", value)

    @property
    @pulumi.getter(name="startPort")
    def start_port(self) -> pulumi.Input[builtins.int]:
        """
        The start of the Ephemeral Port Range on this Node Type.
        """
        return pulumi.get(self, "start_port")

    @start_port.setter
    def start_port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "start_port", value)


if not MYPY:
    class ClusterReverseProxyCertificateArgsDict(TypedDict):
        thumbprint: pulumi.Input[builtins.str]
        """
        The Thumbprint of the Certificate.
        """
        x509_store_name: pulumi.Input[builtins.str]
        """
        The X509 Store where the Certificate Exists, such as `My`.
        """
        thumbprint_secondary: NotRequired[pulumi.Input[builtins.str]]
        """
        The Secondary Thumbprint of the Certificate.
        """
elif False:
    ClusterReverseProxyCertificateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterReverseProxyCertificateArgs:
    def __init__(__self__, *,
                 thumbprint: pulumi.Input[builtins.str],
                 x509_store_name: pulumi.Input[builtins.str],
                 thumbprint_secondary: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] thumbprint: The Thumbprint of the Certificate.
        :param pulumi.Input[builtins.str] x509_store_name: The X509 Store where the Certificate Exists, such as `My`.
        :param pulumi.Input[builtins.str] thumbprint_secondary: The Secondary Thumbprint of the Certificate.
        """
        pulumi.set(__self__, "thumbprint", thumbprint)
        pulumi.set(__self__, "x509_store_name", x509_store_name)
        if thumbprint_secondary is not None:
            pulumi.set(__self__, "thumbprint_secondary", thumbprint_secondary)

    @property
    @pulumi.getter
    def thumbprint(self) -> pulumi.Input[builtins.str]:
        """
        The Thumbprint of the Certificate.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "thumbprint", value)

    @property
    @pulumi.getter(name="x509StoreName")
    def x509_store_name(self) -> pulumi.Input[builtins.str]:
        """
        The X509 Store where the Certificate Exists, such as `My`.
        """
        return pulumi.get(self, "x509_store_name")

    @x509_store_name.setter
    def x509_store_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "x509_store_name", value)

    @property
    @pulumi.getter(name="thumbprintSecondary")
    def thumbprint_secondary(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Secondary Thumbprint of the Certificate.
        """
        return pulumi.get(self, "thumbprint_secondary")

    @thumbprint_secondary.setter
    def thumbprint_secondary(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "thumbprint_secondary", value)


if not MYPY:
    class ClusterReverseProxyCertificateCommonNamesArgsDict(TypedDict):
        common_names: pulumi.Input[Sequence[pulumi.Input['ClusterReverseProxyCertificateCommonNamesCommonNameArgsDict']]]
        """
        A `common_names` block as defined below.
        """
        x509_store_name: pulumi.Input[builtins.str]
        """
        The X509 Store where the Certificate Exists, such as `My`.
        """
elif False:
    ClusterReverseProxyCertificateCommonNamesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterReverseProxyCertificateCommonNamesArgs:
    def __init__(__self__, *,
                 common_names: pulumi.Input[Sequence[pulumi.Input['ClusterReverseProxyCertificateCommonNamesCommonNameArgs']]],
                 x509_store_name: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ClusterReverseProxyCertificateCommonNamesCommonNameArgs']]] common_names: A `common_names` block as defined below.
        :param pulumi.Input[builtins.str] x509_store_name: The X509 Store where the Certificate Exists, such as `My`.
        """
        pulumi.set(__self__, "common_names", common_names)
        pulumi.set(__self__, "x509_store_name", x509_store_name)

    @property
    @pulumi.getter(name="commonNames")
    def common_names(self) -> pulumi.Input[Sequence[pulumi.Input['ClusterReverseProxyCertificateCommonNamesCommonNameArgs']]]:
        """
        A `common_names` block as defined below.
        """
        return pulumi.get(self, "common_names")

    @common_names.setter
    def common_names(self, value: pulumi.Input[Sequence[pulumi.Input['ClusterReverseProxyCertificateCommonNamesCommonNameArgs']]]):
        pulumi.set(self, "common_names", value)

    @property
    @pulumi.getter(name="x509StoreName")
    def x509_store_name(self) -> pulumi.Input[builtins.str]:
        """
        The X509 Store where the Certificate Exists, such as `My`.
        """
        return pulumi.get(self, "x509_store_name")

    @x509_store_name.setter
    def x509_store_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "x509_store_name", value)


if not MYPY:
    class ClusterReverseProxyCertificateCommonNamesCommonNameArgsDict(TypedDict):
        certificate_common_name: pulumi.Input[builtins.str]
        """
        The common or subject name of the certificate.
        """
        certificate_issuer_thumbprint: NotRequired[pulumi.Input[builtins.str]]
        """
        The Issuer Thumbprint of the Certificate.

        > **Note:** Certificate Issuer Thumbprint may become required in the future, `https://docs.microsoft.com/azure/service-fabric/service-fabric-create-cluster-using-cert-cn#download-and-update-a-sample-template`.
        """
elif False:
    ClusterReverseProxyCertificateCommonNamesCommonNameArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterReverseProxyCertificateCommonNamesCommonNameArgs:
    def __init__(__self__, *,
                 certificate_common_name: pulumi.Input[builtins.str],
                 certificate_issuer_thumbprint: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] certificate_common_name: The common or subject name of the certificate.
        :param pulumi.Input[builtins.str] certificate_issuer_thumbprint: The Issuer Thumbprint of the Certificate.
               
               > **Note:** Certificate Issuer Thumbprint may become required in the future, `https://docs.microsoft.com/azure/service-fabric/service-fabric-create-cluster-using-cert-cn#download-and-update-a-sample-template`.
        """
        pulumi.set(__self__, "certificate_common_name", certificate_common_name)
        if certificate_issuer_thumbprint is not None:
            pulumi.set(__self__, "certificate_issuer_thumbprint", certificate_issuer_thumbprint)

    @property
    @pulumi.getter(name="certificateCommonName")
    def certificate_common_name(self) -> pulumi.Input[builtins.str]:
        """
        The common or subject name of the certificate.
        """
        return pulumi.get(self, "certificate_common_name")

    @certificate_common_name.setter
    def certificate_common_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "certificate_common_name", value)

    @property
    @pulumi.getter(name="certificateIssuerThumbprint")
    def certificate_issuer_thumbprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Issuer Thumbprint of the Certificate.

        > **Note:** Certificate Issuer Thumbprint may become required in the future, `https://docs.microsoft.com/azure/service-fabric/service-fabric-create-cluster-using-cert-cn#download-and-update-a-sample-template`.
        """
        return pulumi.get(self, "certificate_issuer_thumbprint")

    @certificate_issuer_thumbprint.setter
    def certificate_issuer_thumbprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_issuer_thumbprint", value)


if not MYPY:
    class ClusterUpgradePolicyArgsDict(TypedDict):
        delta_health_policy: NotRequired[pulumi.Input['ClusterUpgradePolicyDeltaHealthPolicyArgsDict']]
        """
        A `delta_health_policy` block as defined below
        """
        force_restart_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates whether to restart the Service Fabric node even if only dynamic configurations have changed.
        """
        health_check_retry_timeout: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the duration, in "hh:mm:ss" string format, after which Service Fabric retries the health check if the previous health check fails. Defaults to `00:45:00`.
        """
        health_check_stable_duration: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the duration, in "hh:mm:ss" string format, that Service Fabric waits in order to verify that the cluster is stable before it continues to the next upgrade domain or completes the upgrade. This wait duration prevents undetected changes of health right after the health check is performed. Defaults to `00:01:00`.
        """
        health_check_wait_duration: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the duration, in "hh:mm:ss" string format, that Service Fabric waits before it performs the initial health check after it finishes the upgrade on the upgrade domain. Defaults to `00:00:30`.
        """
        health_policy: NotRequired[pulumi.Input['ClusterUpgradePolicyHealthPolicyArgsDict']]
        """
        A `health_policy` block as defined below
        """
        upgrade_domain_timeout: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the duration, in "hh:mm:ss" string format, that Service Fabric takes to upgrade a single upgrade domain. After this period, the upgrade fails. Defaults to `02:00:00`.
        """
        upgrade_replica_set_check_timeout: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the duration, in "hh:mm:ss" string format, that Service Fabric waits for a replica set to reconfigure into a safe state, if it is not already in a safe state, before Service Fabric proceeds with the upgrade. Defaults to `10675199.02:48:05.4775807`.
        """
        upgrade_timeout: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the duration, in "hh:mm:ss" string format, that Service Fabric takes for the entire upgrade. After this period, the upgrade fails. Defaults to `12:00:00`.
        """
elif False:
    ClusterUpgradePolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterUpgradePolicyArgs:
    def __init__(__self__, *,
                 delta_health_policy: Optional[pulumi.Input['ClusterUpgradePolicyDeltaHealthPolicyArgs']] = None,
                 force_restart_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 health_check_retry_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 health_check_stable_duration: Optional[pulumi.Input[builtins.str]] = None,
                 health_check_wait_duration: Optional[pulumi.Input[builtins.str]] = None,
                 health_policy: Optional[pulumi.Input['ClusterUpgradePolicyHealthPolicyArgs']] = None,
                 upgrade_domain_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 upgrade_replica_set_check_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 upgrade_timeout: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input['ClusterUpgradePolicyDeltaHealthPolicyArgs'] delta_health_policy: A `delta_health_policy` block as defined below
        :param pulumi.Input[builtins.bool] force_restart_enabled: Indicates whether to restart the Service Fabric node even if only dynamic configurations have changed.
        :param pulumi.Input[builtins.str] health_check_retry_timeout: Specifies the duration, in "hh:mm:ss" string format, after which Service Fabric retries the health check if the previous health check fails. Defaults to `00:45:00`.
        :param pulumi.Input[builtins.str] health_check_stable_duration: Specifies the duration, in "hh:mm:ss" string format, that Service Fabric waits in order to verify that the cluster is stable before it continues to the next upgrade domain or completes the upgrade. This wait duration prevents undetected changes of health right after the health check is performed. Defaults to `00:01:00`.
        :param pulumi.Input[builtins.str] health_check_wait_duration: Specifies the duration, in "hh:mm:ss" string format, that Service Fabric waits before it performs the initial health check after it finishes the upgrade on the upgrade domain. Defaults to `00:00:30`.
        :param pulumi.Input['ClusterUpgradePolicyHealthPolicyArgs'] health_policy: A `health_policy` block as defined below
        :param pulumi.Input[builtins.str] upgrade_domain_timeout: Specifies the duration, in "hh:mm:ss" string format, that Service Fabric takes to upgrade a single upgrade domain. After this period, the upgrade fails. Defaults to `02:00:00`.
        :param pulumi.Input[builtins.str] upgrade_replica_set_check_timeout: Specifies the duration, in "hh:mm:ss" string format, that Service Fabric waits for a replica set to reconfigure into a safe state, if it is not already in a safe state, before Service Fabric proceeds with the upgrade. Defaults to `10675199.02:48:05.4775807`.
        :param pulumi.Input[builtins.str] upgrade_timeout: Specifies the duration, in "hh:mm:ss" string format, that Service Fabric takes for the entire upgrade. After this period, the upgrade fails. Defaults to `12:00:00`.
        """
        if delta_health_policy is not None:
            pulumi.set(__self__, "delta_health_policy", delta_health_policy)
        if force_restart_enabled is not None:
            pulumi.set(__self__, "force_restart_enabled", force_restart_enabled)
        if health_check_retry_timeout is not None:
            pulumi.set(__self__, "health_check_retry_timeout", health_check_retry_timeout)
        if health_check_stable_duration is not None:
            pulumi.set(__self__, "health_check_stable_duration", health_check_stable_duration)
        if health_check_wait_duration is not None:
            pulumi.set(__self__, "health_check_wait_duration", health_check_wait_duration)
        if health_policy is not None:
            pulumi.set(__self__, "health_policy", health_policy)
        if upgrade_domain_timeout is not None:
            pulumi.set(__self__, "upgrade_domain_timeout", upgrade_domain_timeout)
        if upgrade_replica_set_check_timeout is not None:
            pulumi.set(__self__, "upgrade_replica_set_check_timeout", upgrade_replica_set_check_timeout)
        if upgrade_timeout is not None:
            pulumi.set(__self__, "upgrade_timeout", upgrade_timeout)

    @property
    @pulumi.getter(name="deltaHealthPolicy")
    def delta_health_policy(self) -> Optional[pulumi.Input['ClusterUpgradePolicyDeltaHealthPolicyArgs']]:
        """
        A `delta_health_policy` block as defined below
        """
        return pulumi.get(self, "delta_health_policy")

    @delta_health_policy.setter
    def delta_health_policy(self, value: Optional[pulumi.Input['ClusterUpgradePolicyDeltaHealthPolicyArgs']]):
        pulumi.set(self, "delta_health_policy", value)

    @property
    @pulumi.getter(name="forceRestartEnabled")
    def force_restart_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether to restart the Service Fabric node even if only dynamic configurations have changed.
        """
        return pulumi.get(self, "force_restart_enabled")

    @force_restart_enabled.setter
    def force_restart_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_restart_enabled", value)

    @property
    @pulumi.getter(name="healthCheckRetryTimeout")
    def health_check_retry_timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the duration, in "hh:mm:ss" string format, after which Service Fabric retries the health check if the previous health check fails. Defaults to `00:45:00`.
        """
        return pulumi.get(self, "health_check_retry_timeout")

    @health_check_retry_timeout.setter
    def health_check_retry_timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "health_check_retry_timeout", value)

    @property
    @pulumi.getter(name="healthCheckStableDuration")
    def health_check_stable_duration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the duration, in "hh:mm:ss" string format, that Service Fabric waits in order to verify that the cluster is stable before it continues to the next upgrade domain or completes the upgrade. This wait duration prevents undetected changes of health right after the health check is performed. Defaults to `00:01:00`.
        """
        return pulumi.get(self, "health_check_stable_duration")

    @health_check_stable_duration.setter
    def health_check_stable_duration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "health_check_stable_duration", value)

    @property
    @pulumi.getter(name="healthCheckWaitDuration")
    def health_check_wait_duration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the duration, in "hh:mm:ss" string format, that Service Fabric waits before it performs the initial health check after it finishes the upgrade on the upgrade domain. Defaults to `00:00:30`.
        """
        return pulumi.get(self, "health_check_wait_duration")

    @health_check_wait_duration.setter
    def health_check_wait_duration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "health_check_wait_duration", value)

    @property
    @pulumi.getter(name="healthPolicy")
    def health_policy(self) -> Optional[pulumi.Input['ClusterUpgradePolicyHealthPolicyArgs']]:
        """
        A `health_policy` block as defined below
        """
        return pulumi.get(self, "health_policy")

    @health_policy.setter
    def health_policy(self, value: Optional[pulumi.Input['ClusterUpgradePolicyHealthPolicyArgs']]):
        pulumi.set(self, "health_policy", value)

    @property
    @pulumi.getter(name="upgradeDomainTimeout")
    def upgrade_domain_timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the duration, in "hh:mm:ss" string format, that Service Fabric takes to upgrade a single upgrade domain. After this period, the upgrade fails. Defaults to `02:00:00`.
        """
        return pulumi.get(self, "upgrade_domain_timeout")

    @upgrade_domain_timeout.setter
    def upgrade_domain_timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "upgrade_domain_timeout", value)

    @property
    @pulumi.getter(name="upgradeReplicaSetCheckTimeout")
    def upgrade_replica_set_check_timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the duration, in "hh:mm:ss" string format, that Service Fabric waits for a replica set to reconfigure into a safe state, if it is not already in a safe state, before Service Fabric proceeds with the upgrade. Defaults to `10675199.02:48:05.4775807`.
        """
        return pulumi.get(self, "upgrade_replica_set_check_timeout")

    @upgrade_replica_set_check_timeout.setter
    def upgrade_replica_set_check_timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "upgrade_replica_set_check_timeout", value)

    @property
    @pulumi.getter(name="upgradeTimeout")
    def upgrade_timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the duration, in "hh:mm:ss" string format, that Service Fabric takes for the entire upgrade. After this period, the upgrade fails. Defaults to `12:00:00`.
        """
        return pulumi.get(self, "upgrade_timeout")

    @upgrade_timeout.setter
    def upgrade_timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "upgrade_timeout", value)


if not MYPY:
    class ClusterUpgradePolicyDeltaHealthPolicyArgsDict(TypedDict):
        max_delta_unhealthy_applications_percent: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies the maximum tolerated percentage of delta unhealthy applications that can have aggregated health states of error. If the current unhealthy applications do not respect the percentage relative to the state at the beginning of the upgrade, the cluster is unhealthy. Defaults to `0`.
        """
        max_delta_unhealthy_nodes_percent: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies the maximum tolerated percentage of delta unhealthy nodes that can have aggregated health states of error. If the current unhealthy nodes do not respect the percentage relative to the state at the beginning of the upgrade, the cluster is unhealthy. Defaults to `0`.
        """
        max_upgrade_domain_delta_unhealthy_nodes_percent: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies the maximum tolerated percentage of upgrade domain delta unhealthy nodes that can have aggregated health state of error. If there is any upgrade domain where the current unhealthy nodes do not respect the percentage relative to the state at the beginning of the upgrade, the cluster is unhealthy. Defaults to `0`.
        """
elif False:
    ClusterUpgradePolicyDeltaHealthPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterUpgradePolicyDeltaHealthPolicyArgs:
    def __init__(__self__, *,
                 max_delta_unhealthy_applications_percent: Optional[pulumi.Input[builtins.int]] = None,
                 max_delta_unhealthy_nodes_percent: Optional[pulumi.Input[builtins.int]] = None,
                 max_upgrade_domain_delta_unhealthy_nodes_percent: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] max_delta_unhealthy_applications_percent: Specifies the maximum tolerated percentage of delta unhealthy applications that can have aggregated health states of error. If the current unhealthy applications do not respect the percentage relative to the state at the beginning of the upgrade, the cluster is unhealthy. Defaults to `0`.
        :param pulumi.Input[builtins.int] max_delta_unhealthy_nodes_percent: Specifies the maximum tolerated percentage of delta unhealthy nodes that can have aggregated health states of error. If the current unhealthy nodes do not respect the percentage relative to the state at the beginning of the upgrade, the cluster is unhealthy. Defaults to `0`.
        :param pulumi.Input[builtins.int] max_upgrade_domain_delta_unhealthy_nodes_percent: Specifies the maximum tolerated percentage of upgrade domain delta unhealthy nodes that can have aggregated health state of error. If there is any upgrade domain where the current unhealthy nodes do not respect the percentage relative to the state at the beginning of the upgrade, the cluster is unhealthy. Defaults to `0`.
        """
        if max_delta_unhealthy_applications_percent is not None:
            pulumi.set(__self__, "max_delta_unhealthy_applications_percent", max_delta_unhealthy_applications_percent)
        if max_delta_unhealthy_nodes_percent is not None:
            pulumi.set(__self__, "max_delta_unhealthy_nodes_percent", max_delta_unhealthy_nodes_percent)
        if max_upgrade_domain_delta_unhealthy_nodes_percent is not None:
            pulumi.set(__self__, "max_upgrade_domain_delta_unhealthy_nodes_percent", max_upgrade_domain_delta_unhealthy_nodes_percent)

    @property
    @pulumi.getter(name="maxDeltaUnhealthyApplicationsPercent")
    def max_delta_unhealthy_applications_percent(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the maximum tolerated percentage of delta unhealthy applications that can have aggregated health states of error. If the current unhealthy applications do not respect the percentage relative to the state at the beginning of the upgrade, the cluster is unhealthy. Defaults to `0`.
        """
        return pulumi.get(self, "max_delta_unhealthy_applications_percent")

    @max_delta_unhealthy_applications_percent.setter
    def max_delta_unhealthy_applications_percent(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_delta_unhealthy_applications_percent", value)

    @property
    @pulumi.getter(name="maxDeltaUnhealthyNodesPercent")
    def max_delta_unhealthy_nodes_percent(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the maximum tolerated percentage of delta unhealthy nodes that can have aggregated health states of error. If the current unhealthy nodes do not respect the percentage relative to the state at the beginning of the upgrade, the cluster is unhealthy. Defaults to `0`.
        """
        return pulumi.get(self, "max_delta_unhealthy_nodes_percent")

    @max_delta_unhealthy_nodes_percent.setter
    def max_delta_unhealthy_nodes_percent(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_delta_unhealthy_nodes_percent", value)

    @property
    @pulumi.getter(name="maxUpgradeDomainDeltaUnhealthyNodesPercent")
    def max_upgrade_domain_delta_unhealthy_nodes_percent(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the maximum tolerated percentage of upgrade domain delta unhealthy nodes that can have aggregated health state of error. If there is any upgrade domain where the current unhealthy nodes do not respect the percentage relative to the state at the beginning of the upgrade, the cluster is unhealthy. Defaults to `0`.
        """
        return pulumi.get(self, "max_upgrade_domain_delta_unhealthy_nodes_percent")

    @max_upgrade_domain_delta_unhealthy_nodes_percent.setter
    def max_upgrade_domain_delta_unhealthy_nodes_percent(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_upgrade_domain_delta_unhealthy_nodes_percent", value)


if not MYPY:
    class ClusterUpgradePolicyHealthPolicyArgsDict(TypedDict):
        max_unhealthy_applications_percent: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies the maximum tolerated percentage of applications that can have aggregated health state of error. If the upgrade exceeds this percentage, the cluster is unhealthy. Defaults to `0`.
        """
        max_unhealthy_nodes_percent: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies the maximum tolerated percentage of nodes that can have aggregated health states of error. If an upgrade exceeds this percentage, the cluster is unhealthy. Defaults to `0`.
        """
elif False:
    ClusterUpgradePolicyHealthPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterUpgradePolicyHealthPolicyArgs:
    def __init__(__self__, *,
                 max_unhealthy_applications_percent: Optional[pulumi.Input[builtins.int]] = None,
                 max_unhealthy_nodes_percent: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] max_unhealthy_applications_percent: Specifies the maximum tolerated percentage of applications that can have aggregated health state of error. If the upgrade exceeds this percentage, the cluster is unhealthy. Defaults to `0`.
        :param pulumi.Input[builtins.int] max_unhealthy_nodes_percent: Specifies the maximum tolerated percentage of nodes that can have aggregated health states of error. If an upgrade exceeds this percentage, the cluster is unhealthy. Defaults to `0`.
        """
        if max_unhealthy_applications_percent is not None:
            pulumi.set(__self__, "max_unhealthy_applications_percent", max_unhealthy_applications_percent)
        if max_unhealthy_nodes_percent is not None:
            pulumi.set(__self__, "max_unhealthy_nodes_percent", max_unhealthy_nodes_percent)

    @property
    @pulumi.getter(name="maxUnhealthyApplicationsPercent")
    def max_unhealthy_applications_percent(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the maximum tolerated percentage of applications that can have aggregated health state of error. If the upgrade exceeds this percentage, the cluster is unhealthy. Defaults to `0`.
        """
        return pulumi.get(self, "max_unhealthy_applications_percent")

    @max_unhealthy_applications_percent.setter
    def max_unhealthy_applications_percent(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_unhealthy_applications_percent", value)

    @property
    @pulumi.getter(name="maxUnhealthyNodesPercent")
    def max_unhealthy_nodes_percent(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the maximum tolerated percentage of nodes that can have aggregated health states of error. If an upgrade exceeds this percentage, the cluster is unhealthy. Defaults to `0`.
        """
        return pulumi.get(self, "max_unhealthy_nodes_percent")

    @max_unhealthy_nodes_percent.setter
    def max_unhealthy_nodes_percent(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_unhealthy_nodes_percent", value)


if not MYPY:
    class ManagedClusterAuthenticationArgsDict(TypedDict):
        active_directory: NotRequired[pulumi.Input['ManagedClusterAuthenticationActiveDirectoryArgsDict']]
        """
        A `active_directory` block as defined above.
        """
        certificates: NotRequired[pulumi.Input[Sequence[pulumi.Input['ManagedClusterAuthenticationCertificateArgsDict']]]]
        """
        One or more `certificate` blocks as defined below.
        """
elif False:
    ManagedClusterAuthenticationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ManagedClusterAuthenticationArgs:
    def __init__(__self__, *,
                 active_directory: Optional[pulumi.Input['ManagedClusterAuthenticationActiveDirectoryArgs']] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterAuthenticationCertificateArgs']]]] = None):
        """
        :param pulumi.Input['ManagedClusterAuthenticationActiveDirectoryArgs'] active_directory: A `active_directory` block as defined above.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedClusterAuthenticationCertificateArgs']]] certificates: One or more `certificate` blocks as defined below.
        """
        if active_directory is not None:
            pulumi.set(__self__, "active_directory", active_directory)
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)

    @property
    @pulumi.getter(name="activeDirectory")
    def active_directory(self) -> Optional[pulumi.Input['ManagedClusterAuthenticationActiveDirectoryArgs']]:
        """
        A `active_directory` block as defined above.
        """
        return pulumi.get(self, "active_directory")

    @active_directory.setter
    def active_directory(self, value: Optional[pulumi.Input['ManagedClusterAuthenticationActiveDirectoryArgs']]):
        pulumi.set(self, "active_directory", value)

    @property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterAuthenticationCertificateArgs']]]]:
        """
        One or more `certificate` blocks as defined below.
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterAuthenticationCertificateArgs']]]]):
        pulumi.set(self, "certificates", value)


if not MYPY:
    class ManagedClusterAuthenticationActiveDirectoryArgsDict(TypedDict):
        client_application_id: pulumi.Input[builtins.str]
        """
        The ID of the Client Application.
        """
        cluster_application_id: pulumi.Input[builtins.str]
        """
        The ID of the Cluster Application.
        """
        tenant_id: pulumi.Input[builtins.str]
        """
        The ID of the Tenant.
        """
elif False:
    ManagedClusterAuthenticationActiveDirectoryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ManagedClusterAuthenticationActiveDirectoryArgs:
    def __init__(__self__, *,
                 client_application_id: pulumi.Input[builtins.str],
                 cluster_application_id: pulumi.Input[builtins.str],
                 tenant_id: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] client_application_id: The ID of the Client Application.
        :param pulumi.Input[builtins.str] cluster_application_id: The ID of the Cluster Application.
        :param pulumi.Input[builtins.str] tenant_id: The ID of the Tenant.
        """
        pulumi.set(__self__, "client_application_id", client_application_id)
        pulumi.set(__self__, "cluster_application_id", cluster_application_id)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="clientApplicationId")
    def client_application_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Client Application.
        """
        return pulumi.get(self, "client_application_id")

    @client_application_id.setter
    def client_application_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "client_application_id", value)

    @property
    @pulumi.getter(name="clusterApplicationId")
    def cluster_application_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Cluster Application.
        """
        return pulumi.get(self, "cluster_application_id")

    @cluster_application_id.setter
    def cluster_application_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster_application_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Tenant.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class ManagedClusterAuthenticationCertificateArgsDict(TypedDict):
        thumbprint: pulumi.Input[builtins.str]
        """
        The thumbprint of the certificate.
        """
        type: pulumi.Input[builtins.str]
        """
        The type of the certificate. Can be `AdminClient` or `ReadOnlyClient`.
        """
        common_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The certificate's CN.
        """
elif False:
    ManagedClusterAuthenticationCertificateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ManagedClusterAuthenticationCertificateArgs:
    def __init__(__self__, *,
                 thumbprint: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 common_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] thumbprint: The thumbprint of the certificate.
        :param pulumi.Input[builtins.str] type: The type of the certificate. Can be `AdminClient` or `ReadOnlyClient`.
        :param pulumi.Input[builtins.str] common_name: The certificate's CN.
        """
        pulumi.set(__self__, "thumbprint", thumbprint)
        pulumi.set(__self__, "type", type)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)

    @property
    @pulumi.getter
    def thumbprint(self) -> pulumi.Input[builtins.str]:
        """
        The thumbprint of the certificate.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "thumbprint", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of the certificate. Can be `AdminClient` or `ReadOnlyClient`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The certificate's CN.
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "common_name", value)


if not MYPY:
    class ManagedClusterCustomFabricSettingArgsDict(TypedDict):
        parameter: pulumi.Input[builtins.str]
        """
        Parameter name.
        """
        section: pulumi.Input[builtins.str]
        """
        Section name.
        """
        value: pulumi.Input[builtins.str]
        """
        Parameter value.
        """
elif False:
    ManagedClusterCustomFabricSettingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ManagedClusterCustomFabricSettingArgs:
    def __init__(__self__, *,
                 parameter: pulumi.Input[builtins.str],
                 section: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] parameter: Parameter name.
        :param pulumi.Input[builtins.str] section: Section name.
        :param pulumi.Input[builtins.str] value: Parameter value.
        """
        pulumi.set(__self__, "parameter", parameter)
        pulumi.set(__self__, "section", section)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def parameter(self) -> pulumi.Input[builtins.str]:
        """
        Parameter name.
        """
        return pulumi.get(self, "parameter")

    @parameter.setter
    def parameter(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "parameter", value)

    @property
    @pulumi.getter
    def section(self) -> pulumi.Input[builtins.str]:
        """
        Section name.
        """
        return pulumi.get(self, "section")

    @section.setter
    def section(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "section", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        Parameter value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ManagedClusterLbRuleArgsDict(TypedDict):
        backend_port: pulumi.Input[builtins.int]
        """
        LB Backend port.
        """
        frontend_port: pulumi.Input[builtins.int]
        """
        LB Frontend port.
        """
        probe_protocol: pulumi.Input[builtins.str]
        """
        Protocol for the probe. Can be one of `tcp`, `udp`, `http`, or `https`.
        """
        protocol: pulumi.Input[builtins.str]
        """
        The transport protocol used in this rule. Can be one of `tcp` or `udp`.
        """
        probe_request_path: NotRequired[pulumi.Input[builtins.str]]
        """
        Path for the probe to check, when probe protocol is set to `http`.
        """
elif False:
    ManagedClusterLbRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ManagedClusterLbRuleArgs:
    def __init__(__self__, *,
                 backend_port: pulumi.Input[builtins.int],
                 frontend_port: pulumi.Input[builtins.int],
                 probe_protocol: pulumi.Input[builtins.str],
                 protocol: pulumi.Input[builtins.str],
                 probe_request_path: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.int] backend_port: LB Backend port.
        :param pulumi.Input[builtins.int] frontend_port: LB Frontend port.
        :param pulumi.Input[builtins.str] probe_protocol: Protocol for the probe. Can be one of `tcp`, `udp`, `http`, or `https`.
        :param pulumi.Input[builtins.str] protocol: The transport protocol used in this rule. Can be one of `tcp` or `udp`.
        :param pulumi.Input[builtins.str] probe_request_path: Path for the probe to check, when probe protocol is set to `http`.
        """
        pulumi.set(__self__, "backend_port", backend_port)
        pulumi.set(__self__, "frontend_port", frontend_port)
        pulumi.set(__self__, "probe_protocol", probe_protocol)
        pulumi.set(__self__, "protocol", protocol)
        if probe_request_path is not None:
            pulumi.set(__self__, "probe_request_path", probe_request_path)

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> pulumi.Input[builtins.int]:
        """
        LB Backend port.
        """
        return pulumi.get(self, "backend_port")

    @backend_port.setter
    def backend_port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "backend_port", value)

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> pulumi.Input[builtins.int]:
        """
        LB Frontend port.
        """
        return pulumi.get(self, "frontend_port")

    @frontend_port.setter
    def frontend_port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "frontend_port", value)

    @property
    @pulumi.getter(name="probeProtocol")
    def probe_protocol(self) -> pulumi.Input[builtins.str]:
        """
        Protocol for the probe. Can be one of `tcp`, `udp`, `http`, or `https`.
        """
        return pulumi.get(self, "probe_protocol")

    @probe_protocol.setter
    def probe_protocol(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "probe_protocol", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[builtins.str]:
        """
        The transport protocol used in this rule. Can be one of `tcp` or `udp`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="probeRequestPath")
    def probe_request_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Path for the probe to check, when probe protocol is set to `http`.
        """
        return pulumi.get(self, "probe_request_path")

    @probe_request_path.setter
    def probe_request_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "probe_request_path", value)


if not MYPY:
    class ManagedClusterNodeTypeArgsDict(TypedDict):
        application_port_range: pulumi.Input[builtins.str]
        """
        Sets the port range available for applications. Format is `<from_port>-<to_port>`, for example `10000-20000`.
        """
        data_disk_size_gb: pulumi.Input[builtins.int]
        """
        The size of the data disk in gigabytes..
        """
        ephemeral_port_range: pulumi.Input[builtins.str]
        """
        Sets the port range available for the OS. Format is `<from_port>-<to_port>`, for example `10000-20000`. There has to be at least 255 ports available and cannot overlap with `application_port_range`..
        """
        name: pulumi.Input[builtins.str]
        """
        The name which should be used for this node type.
        """
        vm_image_offer: pulumi.Input[builtins.str]
        """
        The offer type of the marketplace image cluster VMs will use.
        """
        vm_image_publisher: pulumi.Input[builtins.str]
        """
        The publisher of the marketplace image cluster VMs will use.
        """
        vm_image_sku: pulumi.Input[builtins.str]
        """
        The SKU of the marketplace image cluster VMs will use.
        """
        vm_image_version: pulumi.Input[builtins.str]
        """
        The version of the marketplace image cluster VMs will use.
        """
        vm_instance_count: pulumi.Input[builtins.int]
        """
        The number of instances this node type will launch.
        """
        vm_size: pulumi.Input[builtins.str]
        """
        The size of the instances in this node type.
        """
        capacities: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Specifies a list of key/value pairs used to set capacity tags for this node type.
        """
        data_disk_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The type of the disk to use for storing data. It can be one of `Premium_LRS`, `Standard_LRS`, or `StandardSSD_LRS`. Defaults to `Standard_LRS`.
        """
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the Resource Group.
        """
        multiple_placement_groups_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        If set the node type can be composed of multiple placement groups.
        """
        placement_properties: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Specifies a list of placement tags that can be used to indicate where services should run..
        """
        primary: NotRequired[pulumi.Input[builtins.bool]]
        """
        If set to true, system services will run on this node type. Only one node type should be marked as primary. Primary node type cannot be deleted or changed once they're created.
        """
        stateless: NotRequired[pulumi.Input[builtins.bool]]
        """
        If set to true, only stateless workloads can run on this node type.
        """
        vm_secrets: NotRequired[pulumi.Input[Sequence[pulumi.Input['ManagedClusterNodeTypeVmSecretArgsDict']]]]
        """
        One or more `vm_secrets` blocks as defined below.
        """
elif False:
    ManagedClusterNodeTypeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ManagedClusterNodeTypeArgs:
    def __init__(__self__, *,
                 application_port_range: pulumi.Input[builtins.str],
                 data_disk_size_gb: pulumi.Input[builtins.int],
                 ephemeral_port_range: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 vm_image_offer: pulumi.Input[builtins.str],
                 vm_image_publisher: pulumi.Input[builtins.str],
                 vm_image_sku: pulumi.Input[builtins.str],
                 vm_image_version: pulumi.Input[builtins.str],
                 vm_instance_count: pulumi.Input[builtins.int],
                 vm_size: pulumi.Input[builtins.str],
                 capacities: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 data_disk_type: Optional[pulumi.Input[builtins.str]] = None,
                 id: Optional[pulumi.Input[builtins.str]] = None,
                 multiple_placement_groups_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 placement_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 primary: Optional[pulumi.Input[builtins.bool]] = None,
                 stateless: Optional[pulumi.Input[builtins.bool]] = None,
                 vm_secrets: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterNodeTypeVmSecretArgs']]]] = None):
        """
        :param pulumi.Input[builtins.str] application_port_range: Sets the port range available for applications. Format is `<from_port>-<to_port>`, for example `10000-20000`.
        :param pulumi.Input[builtins.int] data_disk_size_gb: The size of the data disk in gigabytes..
        :param pulumi.Input[builtins.str] ephemeral_port_range: Sets the port range available for the OS. Format is `<from_port>-<to_port>`, for example `10000-20000`. There has to be at least 255 ports available and cannot overlap with `application_port_range`..
        :param pulumi.Input[builtins.str] name: The name which should be used for this node type.
        :param pulumi.Input[builtins.str] vm_image_offer: The offer type of the marketplace image cluster VMs will use.
        :param pulumi.Input[builtins.str] vm_image_publisher: The publisher of the marketplace image cluster VMs will use.
        :param pulumi.Input[builtins.str] vm_image_sku: The SKU of the marketplace image cluster VMs will use.
        :param pulumi.Input[builtins.str] vm_image_version: The version of the marketplace image cluster VMs will use.
        :param pulumi.Input[builtins.int] vm_instance_count: The number of instances this node type will launch.
        :param pulumi.Input[builtins.str] vm_size: The size of the instances in this node type.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] capacities: Specifies a list of key/value pairs used to set capacity tags for this node type.
        :param pulumi.Input[builtins.str] data_disk_type: The type of the disk to use for storing data. It can be one of `Premium_LRS`, `Standard_LRS`, or `StandardSSD_LRS`. Defaults to `Standard_LRS`.
        :param pulumi.Input[builtins.str] id: The ID of the Resource Group.
        :param pulumi.Input[builtins.bool] multiple_placement_groups_enabled: If set the node type can be composed of multiple placement groups.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] placement_properties: Specifies a list of placement tags that can be used to indicate where services should run..
        :param pulumi.Input[builtins.bool] primary: If set to true, system services will run on this node type. Only one node type should be marked as primary. Primary node type cannot be deleted or changed once they're created.
        :param pulumi.Input[builtins.bool] stateless: If set to true, only stateless workloads can run on this node type.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedClusterNodeTypeVmSecretArgs']]] vm_secrets: One or more `vm_secrets` blocks as defined below.
        """
        pulumi.set(__self__, "application_port_range", application_port_range)
        pulumi.set(__self__, "data_disk_size_gb", data_disk_size_gb)
        pulumi.set(__self__, "ephemeral_port_range", ephemeral_port_range)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "vm_image_offer", vm_image_offer)
        pulumi.set(__self__, "vm_image_publisher", vm_image_publisher)
        pulumi.set(__self__, "vm_image_sku", vm_image_sku)
        pulumi.set(__self__, "vm_image_version", vm_image_version)
        pulumi.set(__self__, "vm_instance_count", vm_instance_count)
        pulumi.set(__self__, "vm_size", vm_size)
        if capacities is not None:
            pulumi.set(__self__, "capacities", capacities)
        if data_disk_type is not None:
            pulumi.set(__self__, "data_disk_type", data_disk_type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if multiple_placement_groups_enabled is not None:
            pulumi.set(__self__, "multiple_placement_groups_enabled", multiple_placement_groups_enabled)
        if placement_properties is not None:
            pulumi.set(__self__, "placement_properties", placement_properties)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if stateless is not None:
            pulumi.set(__self__, "stateless", stateless)
        if vm_secrets is not None:
            pulumi.set(__self__, "vm_secrets", vm_secrets)

    @property
    @pulumi.getter(name="applicationPortRange")
    def application_port_range(self) -> pulumi.Input[builtins.str]:
        """
        Sets the port range available for applications. Format is `<from_port>-<to_port>`, for example `10000-20000`.
        """
        return pulumi.get(self, "application_port_range")

    @application_port_range.setter
    def application_port_range(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "application_port_range", value)

    @property
    @pulumi.getter(name="dataDiskSizeGb")
    def data_disk_size_gb(self) -> pulumi.Input[builtins.int]:
        """
        The size of the data disk in gigabytes..
        """
        return pulumi.get(self, "data_disk_size_gb")

    @data_disk_size_gb.setter
    def data_disk_size_gb(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "data_disk_size_gb", value)

    @property
    @pulumi.getter(name="ephemeralPortRange")
    def ephemeral_port_range(self) -> pulumi.Input[builtins.str]:
        """
        Sets the port range available for the OS. Format is `<from_port>-<to_port>`, for example `10000-20000`. There has to be at least 255 ports available and cannot overlap with `application_port_range`..
        """
        return pulumi.get(self, "ephemeral_port_range")

    @ephemeral_port_range.setter
    def ephemeral_port_range(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ephemeral_port_range", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name which should be used for this node type.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="vmImageOffer")
    def vm_image_offer(self) -> pulumi.Input[builtins.str]:
        """
        The offer type of the marketplace image cluster VMs will use.
        """
        return pulumi.get(self, "vm_image_offer")

    @vm_image_offer.setter
    def vm_image_offer(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vm_image_offer", value)

    @property
    @pulumi.getter(name="vmImagePublisher")
    def vm_image_publisher(self) -> pulumi.Input[builtins.str]:
        """
        The publisher of the marketplace image cluster VMs will use.
        """
        return pulumi.get(self, "vm_image_publisher")

    @vm_image_publisher.setter
    def vm_image_publisher(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vm_image_publisher", value)

    @property
    @pulumi.getter(name="vmImageSku")
    def vm_image_sku(self) -> pulumi.Input[builtins.str]:
        """
        The SKU of the marketplace image cluster VMs will use.
        """
        return pulumi.get(self, "vm_image_sku")

    @vm_image_sku.setter
    def vm_image_sku(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vm_image_sku", value)

    @property
    @pulumi.getter(name="vmImageVersion")
    def vm_image_version(self) -> pulumi.Input[builtins.str]:
        """
        The version of the marketplace image cluster VMs will use.
        """
        return pulumi.get(self, "vm_image_version")

    @vm_image_version.setter
    def vm_image_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vm_image_version", value)

    @property
    @pulumi.getter(name="vmInstanceCount")
    def vm_instance_count(self) -> pulumi.Input[builtins.int]:
        """
        The number of instances this node type will launch.
        """
        return pulumi.get(self, "vm_instance_count")

    @vm_instance_count.setter
    def vm_instance_count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "vm_instance_count", value)

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> pulumi.Input[builtins.str]:
        """
        The size of the instances in this node type.
        """
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vm_size", value)

    @property
    @pulumi.getter
    def capacities(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of key/value pairs used to set capacity tags for this node type.
        """
        return pulumi.get(self, "capacities")

    @capacities.setter
    def capacities(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "capacities", value)

    @property
    @pulumi.getter(name="dataDiskType")
    def data_disk_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the disk to use for storing data. It can be one of `Premium_LRS`, `Standard_LRS`, or `StandardSSD_LRS`. Defaults to `Standard_LRS`.
        """
        return pulumi.get(self, "data_disk_type")

    @data_disk_type.setter
    def data_disk_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_disk_type", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Resource Group.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="multiplePlacementGroupsEnabled")
    def multiple_placement_groups_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set the node type can be composed of multiple placement groups.
        """
        return pulumi.get(self, "multiple_placement_groups_enabled")

    @multiple_placement_groups_enabled.setter
    def multiple_placement_groups_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "multiple_placement_groups_enabled", value)

    @property
    @pulumi.getter(name="placementProperties")
    def placement_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of placement tags that can be used to indicate where services should run..
        """
        return pulumi.get(self, "placement_properties")

    @placement_properties.setter
    def placement_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "placement_properties", value)

    @property
    @pulumi.getter
    def primary(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to true, system services will run on this node type. Only one node type should be marked as primary. Primary node type cannot be deleted or changed once they're created.
        """
        return pulumi.get(self, "primary")

    @primary.setter
    def primary(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "primary", value)

    @property
    @pulumi.getter
    def stateless(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to true, only stateless workloads can run on this node type.
        """
        return pulumi.get(self, "stateless")

    @stateless.setter
    def stateless(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "stateless", value)

    @property
    @pulumi.getter(name="vmSecrets")
    def vm_secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterNodeTypeVmSecretArgs']]]]:
        """
        One or more `vm_secrets` blocks as defined below.
        """
        return pulumi.get(self, "vm_secrets")

    @vm_secrets.setter
    def vm_secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterNodeTypeVmSecretArgs']]]]):
        pulumi.set(self, "vm_secrets", value)


if not MYPY:
    class ManagedClusterNodeTypeVmSecretArgsDict(TypedDict):
        certificates: pulumi.Input[Sequence[pulumi.Input['ManagedClusterNodeTypeVmSecretCertificateArgsDict']]]
        """
        One or more `certificates` blocks as defined above.
        """
        vault_id: pulumi.Input[builtins.str]
        """
        The ID of the Vault that contain the certificates.
        """
elif False:
    ManagedClusterNodeTypeVmSecretArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ManagedClusterNodeTypeVmSecretArgs:
    def __init__(__self__, *,
                 certificates: pulumi.Input[Sequence[pulumi.Input['ManagedClusterNodeTypeVmSecretCertificateArgs']]],
                 vault_id: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ManagedClusterNodeTypeVmSecretCertificateArgs']]] certificates: One or more `certificates` blocks as defined above.
        :param pulumi.Input[builtins.str] vault_id: The ID of the Vault that contain the certificates.
        """
        pulumi.set(__self__, "certificates", certificates)
        pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter
    def certificates(self) -> pulumi.Input[Sequence[pulumi.Input['ManagedClusterNodeTypeVmSecretCertificateArgs']]]:
        """
        One or more `certificates` blocks as defined above.
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: pulumi.Input[Sequence[pulumi.Input['ManagedClusterNodeTypeVmSecretCertificateArgs']]]):
        pulumi.set(self, "certificates", value)

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Vault that contain the certificates.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vault_id", value)


if not MYPY:
    class ManagedClusterNodeTypeVmSecretCertificateArgsDict(TypedDict):
        store: pulumi.Input[builtins.str]
        """
        The certificate store on the Virtual Machine to which the certificate should be added.
        """
        url: pulumi.Input[builtins.str]
        """
        The URL of a certificate that has been uploaded to Key Vault as a secret
        """
elif False:
    ManagedClusterNodeTypeVmSecretCertificateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ManagedClusterNodeTypeVmSecretCertificateArgs:
    def __init__(__self__, *,
                 store: pulumi.Input[builtins.str],
                 url: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] store: The certificate store on the Virtual Machine to which the certificate should be added.
        :param pulumi.Input[builtins.str] url: The URL of a certificate that has been uploaded to Key Vault as a secret
        """
        pulumi.set(__self__, "store", store)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def store(self) -> pulumi.Input[builtins.str]:
        """
        The certificate store on the Virtual Machine to which the certificate should be added.
        """
        return pulumi.get(self, "store")

    @store.setter
    def store(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "store", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[builtins.str]:
        """
        The URL of a certificate that has been uploaded to Key Vault as a secret
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "url", value)


