# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceArgs', 'Service']

@pulumi.input_type
class ServiceArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[builtins.str],
                 sku: pulumi.Input['ServiceSkuArgs'],
                 aad_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 connectivity_logs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 cors: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCorArgs']]]] = None,
                 http_request_logs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 identity: Optional[pulumi.Input['ServiceIdentityArgs']] = None,
                 live_trace: Optional[pulumi.Input['ServiceLiveTraceArgs']] = None,
                 live_trace_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 local_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 messaging_logs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 serverless_connection_timeout_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 service_mode: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tls_client_cert_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 upstream_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceUpstreamEndpointArgs']]]] = None):
        """
        The set of arguments for constructing a Service resource.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the SignalR service. Changing this forces a new resource to be created.
        :param pulumi.Input['ServiceSkuArgs'] sku: A `sku` block as documented below.
        :param pulumi.Input[builtins.bool] aad_auth_enabled: Whether to enable AAD auth? Defaults to `true`.
        :param pulumi.Input[builtins.bool] connectivity_logs_enabled: Specifies if Connectivity Logs are enabled or not. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceCorArgs']]] cors: A `cors` block as documented below.
        :param pulumi.Input[builtins.bool] http_request_logs_enabled: Specifies if Http Request Logs are enabled or not. Defaults to `false`.
        :param pulumi.Input['ServiceIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input['ServiceLiveTraceArgs'] live_trace: A `live_trace` block as defined below.
        :param pulumi.Input[builtins.bool] local_auth_enabled: Whether to enable local auth? Defaults to `true`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the SignalR service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] messaging_logs_enabled: Specifies if Messaging Logs are enabled or not. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: The name of the SignalR service. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Whether to enable public network access? Defaults to `true`.
               
               > **Note:** `public_network_access_enabled` cannot be set to `false` in `Free` sku tier.
        :param pulumi.Input[builtins.int] serverless_connection_timeout_in_seconds: Specifies the client connection timeout. Defaults to `30`.
        :param pulumi.Input[builtins.str] service_mode: Specifies the service mode. Possible values are `Classic`, `Default` and `Serverless`. Defaults to `Default`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.bool] tls_client_cert_enabled: Whether to request client certificate during TLS handshake? Defaults to `false`.
               
               > **Note:** `tls_client_cert_enabled` cannot be set to `true` in `Free` sku tier.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceUpstreamEndpointArgs']]] upstream_endpoints: An `upstream_endpoint` block as documented below. Using this block requires the SignalR service to be Serverless. When creating multiple blocks they will be processed in the order they are defined in.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku", sku)
        if aad_auth_enabled is not None:
            pulumi.set(__self__, "aad_auth_enabled", aad_auth_enabled)
        if connectivity_logs_enabled is not None:
            pulumi.set(__self__, "connectivity_logs_enabled", connectivity_logs_enabled)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if http_request_logs_enabled is not None:
            pulumi.set(__self__, "http_request_logs_enabled", http_request_logs_enabled)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if live_trace is not None:
            pulumi.set(__self__, "live_trace", live_trace)
        if live_trace_enabled is not None:
            warnings.warn("""`live_trace_enabled` has been deprecated in favor of `live_trace` and will be removed in 4.0.""", DeprecationWarning)
            pulumi.log.warn("""live_trace_enabled is deprecated: `live_trace_enabled` has been deprecated in favor of `live_trace` and will be removed in 4.0.""")
        if live_trace_enabled is not None:
            pulumi.set(__self__, "live_trace_enabled", live_trace_enabled)
        if local_auth_enabled is not None:
            pulumi.set(__self__, "local_auth_enabled", local_auth_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if messaging_logs_enabled is not None:
            pulumi.set(__self__, "messaging_logs_enabled", messaging_logs_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if serverless_connection_timeout_in_seconds is not None:
            pulumi.set(__self__, "serverless_connection_timeout_in_seconds", serverless_connection_timeout_in_seconds)
        if service_mode is not None:
            pulumi.set(__self__, "service_mode", service_mode)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tls_client_cert_enabled is not None:
            pulumi.set(__self__, "tls_client_cert_enabled", tls_client_cert_enabled)
        if upstream_endpoints is not None:
            pulumi.set(__self__, "upstream_endpoints", upstream_endpoints)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group in which to create the SignalR service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Input['ServiceSkuArgs']:
        """
        A `sku` block as documented below.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input['ServiceSkuArgs']):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter(name="aadAuthEnabled")
    def aad_auth_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable AAD auth? Defaults to `true`.
        """
        return pulumi.get(self, "aad_auth_enabled")

    @aad_auth_enabled.setter
    def aad_auth_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "aad_auth_enabled", value)

    @property
    @pulumi.getter(name="connectivityLogsEnabled")
    def connectivity_logs_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if Connectivity Logs are enabled or not. Defaults to `false`.
        """
        return pulumi.get(self, "connectivity_logs_enabled")

    @connectivity_logs_enabled.setter
    def connectivity_logs_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "connectivity_logs_enabled", value)

    @property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCorArgs']]]]:
        """
        A `cors` block as documented below.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCorArgs']]]]):
        pulumi.set(self, "cors", value)

    @property
    @pulumi.getter(name="httpRequestLogsEnabled")
    def http_request_logs_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if Http Request Logs are enabled or not. Defaults to `false`.
        """
        return pulumi.get(self, "http_request_logs_enabled")

    @http_request_logs_enabled.setter
    def http_request_logs_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "http_request_logs_enabled", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ServiceIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ServiceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="liveTrace")
    def live_trace(self) -> Optional[pulumi.Input['ServiceLiveTraceArgs']]:
        """
        A `live_trace` block as defined below.
        """
        return pulumi.get(self, "live_trace")

    @live_trace.setter
    def live_trace(self, value: Optional[pulumi.Input['ServiceLiveTraceArgs']]):
        pulumi.set(self, "live_trace", value)

    @property
    @pulumi.getter(name="liveTraceEnabled")
    @_utilities.deprecated("""`live_trace_enabled` has been deprecated in favor of `live_trace` and will be removed in 4.0.""")
    def live_trace_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "live_trace_enabled")

    @live_trace_enabled.setter
    def live_trace_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "live_trace_enabled", value)

    @property
    @pulumi.getter(name="localAuthEnabled")
    def local_auth_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable local auth? Defaults to `true`.
        """
        return pulumi.get(self, "local_auth_enabled")

    @local_auth_enabled.setter
    def local_auth_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "local_auth_enabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the SignalR service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="messagingLogsEnabled")
    def messaging_logs_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if Messaging Logs are enabled or not. Defaults to `false`.
        """
        return pulumi.get(self, "messaging_logs_enabled")

    @messaging_logs_enabled.setter
    def messaging_logs_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "messaging_logs_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the SignalR service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable public network access? Defaults to `true`.

        > **Note:** `public_network_access_enabled` cannot be set to `false` in `Free` sku tier.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter(name="serverlessConnectionTimeoutInSeconds")
    def serverless_connection_timeout_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the client connection timeout. Defaults to `30`.
        """
        return pulumi.get(self, "serverless_connection_timeout_in_seconds")

    @serverless_connection_timeout_in_seconds.setter
    def serverless_connection_timeout_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "serverless_connection_timeout_in_seconds", value)

    @property
    @pulumi.getter(name="serviceMode")
    def service_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the service mode. Possible values are `Classic`, `Default` and `Serverless`. Defaults to `Default`.
        """
        return pulumi.get(self, "service_mode")

    @service_mode.setter
    def service_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_mode", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tlsClientCertEnabled")
    def tls_client_cert_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to request client certificate during TLS handshake? Defaults to `false`.

        > **Note:** `tls_client_cert_enabled` cannot be set to `true` in `Free` sku tier.
        """
        return pulumi.get(self, "tls_client_cert_enabled")

    @tls_client_cert_enabled.setter
    def tls_client_cert_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "tls_client_cert_enabled", value)

    @property
    @pulumi.getter(name="upstreamEndpoints")
    def upstream_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceUpstreamEndpointArgs']]]]:
        """
        An `upstream_endpoint` block as documented below. Using this block requires the SignalR service to be Serverless. When creating multiple blocks they will be processed in the order they are defined in.
        """
        return pulumi.get(self, "upstream_endpoints")

    @upstream_endpoints.setter
    def upstream_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceUpstreamEndpointArgs']]]]):
        pulumi.set(self, "upstream_endpoints", value)


@pulumi.input_type
class _ServiceState:
    def __init__(__self__, *,
                 aad_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 connectivity_logs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 cors: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCorArgs']]]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 http_request_logs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 identity: Optional[pulumi.Input['ServiceIdentityArgs']] = None,
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 live_trace: Optional[pulumi.Input['ServiceLiveTraceArgs']] = None,
                 live_trace_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 local_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 messaging_logs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 primary_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 primary_connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 public_port: Optional[pulumi.Input[builtins.int]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 server_port: Optional[pulumi.Input[builtins.int]] = None,
                 serverless_connection_timeout_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 service_mode: Optional[pulumi.Input[builtins.str]] = None,
                 sku: Optional[pulumi.Input['ServiceSkuArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tls_client_cert_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 upstream_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceUpstreamEndpointArgs']]]] = None):
        """
        Input properties used for looking up and filtering Service resources.
        :param pulumi.Input[builtins.bool] aad_auth_enabled: Whether to enable AAD auth? Defaults to `true`.
        :param pulumi.Input[builtins.bool] connectivity_logs_enabled: Specifies if Connectivity Logs are enabled or not. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceCorArgs']]] cors: A `cors` block as documented below.
        :param pulumi.Input[builtins.str] hostname: The FQDN of the SignalR service.
        :param pulumi.Input[builtins.bool] http_request_logs_enabled: Specifies if Http Request Logs are enabled or not. Defaults to `false`.
        :param pulumi.Input['ServiceIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[builtins.str] ip_address: The publicly accessible IP of the SignalR service.
        :param pulumi.Input['ServiceLiveTraceArgs'] live_trace: A `live_trace` block as defined below.
        :param pulumi.Input[builtins.bool] local_auth_enabled: Whether to enable local auth? Defaults to `true`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the SignalR service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] messaging_logs_enabled: Specifies if Messaging Logs are enabled or not. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: The name of the SignalR service. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] primary_access_key: The primary access key for the SignalR service.
        :param pulumi.Input[builtins.str] primary_connection_string: The primary connection string for the SignalR service.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Whether to enable public network access? Defaults to `true`.
               
               > **Note:** `public_network_access_enabled` cannot be set to `false` in `Free` sku tier.
        :param pulumi.Input[builtins.int] public_port: The publicly accessible port of the SignalR service which is designed for browser/client use.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the SignalR service. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] secondary_access_key: The secondary access key for the SignalR service.
        :param pulumi.Input[builtins.str] secondary_connection_string: The secondary connection string for the SignalR service.
        :param pulumi.Input[builtins.int] server_port: The publicly accessible port of the SignalR service which is designed for customer server side use.
        :param pulumi.Input[builtins.int] serverless_connection_timeout_in_seconds: Specifies the client connection timeout. Defaults to `30`.
        :param pulumi.Input[builtins.str] service_mode: Specifies the service mode. Possible values are `Classic`, `Default` and `Serverless`. Defaults to `Default`.
        :param pulumi.Input['ServiceSkuArgs'] sku: A `sku` block as documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.bool] tls_client_cert_enabled: Whether to request client certificate during TLS handshake? Defaults to `false`.
               
               > **Note:** `tls_client_cert_enabled` cannot be set to `true` in `Free` sku tier.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceUpstreamEndpointArgs']]] upstream_endpoints: An `upstream_endpoint` block as documented below. Using this block requires the SignalR service to be Serverless. When creating multiple blocks they will be processed in the order they are defined in.
        """
        if aad_auth_enabled is not None:
            pulumi.set(__self__, "aad_auth_enabled", aad_auth_enabled)
        if connectivity_logs_enabled is not None:
            pulumi.set(__self__, "connectivity_logs_enabled", connectivity_logs_enabled)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if http_request_logs_enabled is not None:
            pulumi.set(__self__, "http_request_logs_enabled", http_request_logs_enabled)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if live_trace is not None:
            pulumi.set(__self__, "live_trace", live_trace)
        if live_trace_enabled is not None:
            warnings.warn("""`live_trace_enabled` has been deprecated in favor of `live_trace` and will be removed in 4.0.""", DeprecationWarning)
            pulumi.log.warn("""live_trace_enabled is deprecated: `live_trace_enabled` has been deprecated in favor of `live_trace` and will be removed in 4.0.""")
        if live_trace_enabled is not None:
            pulumi.set(__self__, "live_trace_enabled", live_trace_enabled)
        if local_auth_enabled is not None:
            pulumi.set(__self__, "local_auth_enabled", local_auth_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if messaging_logs_enabled is not None:
            pulumi.set(__self__, "messaging_logs_enabled", messaging_logs_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_access_key is not None:
            pulumi.set(__self__, "primary_access_key", primary_access_key)
        if primary_connection_string is not None:
            pulumi.set(__self__, "primary_connection_string", primary_connection_string)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if public_port is not None:
            pulumi.set(__self__, "public_port", public_port)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if secondary_access_key is not None:
            pulumi.set(__self__, "secondary_access_key", secondary_access_key)
        if secondary_connection_string is not None:
            pulumi.set(__self__, "secondary_connection_string", secondary_connection_string)
        if server_port is not None:
            pulumi.set(__self__, "server_port", server_port)
        if serverless_connection_timeout_in_seconds is not None:
            pulumi.set(__self__, "serverless_connection_timeout_in_seconds", serverless_connection_timeout_in_seconds)
        if service_mode is not None:
            pulumi.set(__self__, "service_mode", service_mode)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tls_client_cert_enabled is not None:
            pulumi.set(__self__, "tls_client_cert_enabled", tls_client_cert_enabled)
        if upstream_endpoints is not None:
            pulumi.set(__self__, "upstream_endpoints", upstream_endpoints)

    @property
    @pulumi.getter(name="aadAuthEnabled")
    def aad_auth_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable AAD auth? Defaults to `true`.
        """
        return pulumi.get(self, "aad_auth_enabled")

    @aad_auth_enabled.setter
    def aad_auth_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "aad_auth_enabled", value)

    @property
    @pulumi.getter(name="connectivityLogsEnabled")
    def connectivity_logs_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if Connectivity Logs are enabled or not. Defaults to `false`.
        """
        return pulumi.get(self, "connectivity_logs_enabled")

    @connectivity_logs_enabled.setter
    def connectivity_logs_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "connectivity_logs_enabled", value)

    @property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCorArgs']]]]:
        """
        A `cors` block as documented below.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCorArgs']]]]):
        pulumi.set(self, "cors", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The FQDN of the SignalR service.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="httpRequestLogsEnabled")
    def http_request_logs_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if Http Request Logs are enabled or not. Defaults to `false`.
        """
        return pulumi.get(self, "http_request_logs_enabled")

    @http_request_logs_enabled.setter
    def http_request_logs_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "http_request_logs_enabled", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ServiceIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ServiceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The publicly accessible IP of the SignalR service.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="liveTrace")
    def live_trace(self) -> Optional[pulumi.Input['ServiceLiveTraceArgs']]:
        """
        A `live_trace` block as defined below.
        """
        return pulumi.get(self, "live_trace")

    @live_trace.setter
    def live_trace(self, value: Optional[pulumi.Input['ServiceLiveTraceArgs']]):
        pulumi.set(self, "live_trace", value)

    @property
    @pulumi.getter(name="liveTraceEnabled")
    @_utilities.deprecated("""`live_trace_enabled` has been deprecated in favor of `live_trace` and will be removed in 4.0.""")
    def live_trace_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "live_trace_enabled")

    @live_trace_enabled.setter
    def live_trace_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "live_trace_enabled", value)

    @property
    @pulumi.getter(name="localAuthEnabled")
    def local_auth_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable local auth? Defaults to `true`.
        """
        return pulumi.get(self, "local_auth_enabled")

    @local_auth_enabled.setter
    def local_auth_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "local_auth_enabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the SignalR service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="messagingLogsEnabled")
    def messaging_logs_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if Messaging Logs are enabled or not. Defaults to `false`.
        """
        return pulumi.get(self, "messaging_logs_enabled")

    @messaging_logs_enabled.setter
    def messaging_logs_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "messaging_logs_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the SignalR service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="primaryAccessKey")
    def primary_access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The primary access key for the SignalR service.
        """
        return pulumi.get(self, "primary_access_key")

    @primary_access_key.setter
    def primary_access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_access_key", value)

    @property
    @pulumi.getter(name="primaryConnectionString")
    def primary_connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The primary connection string for the SignalR service.
        """
        return pulumi.get(self, "primary_connection_string")

    @primary_connection_string.setter
    def primary_connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_connection_string", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable public network access? Defaults to `true`.

        > **Note:** `public_network_access_enabled` cannot be set to `false` in `Free` sku tier.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter(name="publicPort")
    def public_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The publicly accessible port of the SignalR service which is designed for browser/client use.
        """
        return pulumi.get(self, "public_port")

    @public_port.setter
    def public_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "public_port", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group in which to create the SignalR service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="secondaryAccessKey")
    def secondary_access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The secondary access key for the SignalR service.
        """
        return pulumi.get(self, "secondary_access_key")

    @secondary_access_key.setter
    def secondary_access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_access_key", value)

    @property
    @pulumi.getter(name="secondaryConnectionString")
    def secondary_connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The secondary connection string for the SignalR service.
        """
        return pulumi.get(self, "secondary_connection_string")

    @secondary_connection_string.setter
    def secondary_connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_connection_string", value)

    @property
    @pulumi.getter(name="serverPort")
    def server_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The publicly accessible port of the SignalR service which is designed for customer server side use.
        """
        return pulumi.get(self, "server_port")

    @server_port.setter
    def server_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "server_port", value)

    @property
    @pulumi.getter(name="serverlessConnectionTimeoutInSeconds")
    def serverless_connection_timeout_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the client connection timeout. Defaults to `30`.
        """
        return pulumi.get(self, "serverless_connection_timeout_in_seconds")

    @serverless_connection_timeout_in_seconds.setter
    def serverless_connection_timeout_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "serverless_connection_timeout_in_seconds", value)

    @property
    @pulumi.getter(name="serviceMode")
    def service_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the service mode. Possible values are `Classic`, `Default` and `Serverless`. Defaults to `Default`.
        """
        return pulumi.get(self, "service_mode")

    @service_mode.setter
    def service_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_mode", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input['ServiceSkuArgs']]:
        """
        A `sku` block as documented below.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input['ServiceSkuArgs']]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tlsClientCertEnabled")
    def tls_client_cert_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to request client certificate during TLS handshake? Defaults to `false`.

        > **Note:** `tls_client_cert_enabled` cannot be set to `true` in `Free` sku tier.
        """
        return pulumi.get(self, "tls_client_cert_enabled")

    @tls_client_cert_enabled.setter
    def tls_client_cert_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "tls_client_cert_enabled", value)

    @property
    @pulumi.getter(name="upstreamEndpoints")
    def upstream_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceUpstreamEndpointArgs']]]]:
        """
        An `upstream_endpoint` block as documented below. Using this block requires the SignalR service to be Serverless. When creating multiple blocks they will be processed in the order they are defined in.
        """
        return pulumi.get(self, "upstream_endpoints")

    @upstream_endpoints.setter
    def upstream_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceUpstreamEndpointArgs']]]]):
        pulumi.set(self, "upstream_endpoints", value)


@pulumi.type_token("azure:signalr/service:Service")
class Service(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aad_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 connectivity_logs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 cors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceCorArgs', 'ServiceCorArgsDict']]]]] = None,
                 http_request_logs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['ServiceIdentityArgs', 'ServiceIdentityArgsDict']]] = None,
                 live_trace: Optional[pulumi.Input[Union['ServiceLiveTraceArgs', 'ServiceLiveTraceArgsDict']]] = None,
                 live_trace_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 local_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 messaging_logs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 serverless_connection_timeout_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 service_mode: Optional[pulumi.Input[builtins.str]] = None,
                 sku: Optional[pulumi.Input[Union['ServiceSkuArgs', 'ServiceSkuArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tls_client_cert_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 upstream_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceUpstreamEndpointArgs', 'ServiceUpstreamEndpointArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages an Azure SignalR service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="my-signalr",
            location="West US")
        example_service = azure.signalr.Service("example",
            name="tfex-signalr",
            location=example.location,
            resource_group_name=example.name,
            sku={
                "name": "Free_F1",
                "capacity": 1,
            },
            cors=[{
                "allowed_origins": ["http://www.example.com"],
            }],
            public_network_access_enabled=False,
            connectivity_logs_enabled=True,
            messaging_logs_enabled=True,
            service_mode="Default",
            upstream_endpoints=[{
                "category_patterns": [
                    "connections",
                    "messages",
                ],
                "event_patterns": ["*"],
                "hub_patterns": ["hub1"],
                "url_template": "http://foo.com",
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.SignalRService`: 2024-03-01

        ## Import

        SignalR services can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:signalr/service:Service example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/terraform-signalr/providers/Microsoft.SignalRService/signalR/tfex-signalr
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] aad_auth_enabled: Whether to enable AAD auth? Defaults to `true`.
        :param pulumi.Input[builtins.bool] connectivity_logs_enabled: Specifies if Connectivity Logs are enabled or not. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceCorArgs', 'ServiceCorArgsDict']]]] cors: A `cors` block as documented below.
        :param pulumi.Input[builtins.bool] http_request_logs_enabled: Specifies if Http Request Logs are enabled or not. Defaults to `false`.
        :param pulumi.Input[Union['ServiceIdentityArgs', 'ServiceIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[Union['ServiceLiveTraceArgs', 'ServiceLiveTraceArgsDict']] live_trace: A `live_trace` block as defined below.
        :param pulumi.Input[builtins.bool] local_auth_enabled: Whether to enable local auth? Defaults to `true`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the SignalR service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] messaging_logs_enabled: Specifies if Messaging Logs are enabled or not. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: The name of the SignalR service. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Whether to enable public network access? Defaults to `true`.
               
               > **Note:** `public_network_access_enabled` cannot be set to `false` in `Free` sku tier.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the SignalR service. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] serverless_connection_timeout_in_seconds: Specifies the client connection timeout. Defaults to `30`.
        :param pulumi.Input[builtins.str] service_mode: Specifies the service mode. Possible values are `Classic`, `Default` and `Serverless`. Defaults to `Default`.
        :param pulumi.Input[Union['ServiceSkuArgs', 'ServiceSkuArgsDict']] sku: A `sku` block as documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.bool] tls_client_cert_enabled: Whether to request client certificate during TLS handshake? Defaults to `false`.
               
               > **Note:** `tls_client_cert_enabled` cannot be set to `true` in `Free` sku tier.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceUpstreamEndpointArgs', 'ServiceUpstreamEndpointArgsDict']]]] upstream_endpoints: An `upstream_endpoint` block as documented below. Using this block requires the SignalR service to be Serverless. When creating multiple blocks they will be processed in the order they are defined in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure SignalR service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="my-signalr",
            location="West US")
        example_service = azure.signalr.Service("example",
            name="tfex-signalr",
            location=example.location,
            resource_group_name=example.name,
            sku={
                "name": "Free_F1",
                "capacity": 1,
            },
            cors=[{
                "allowed_origins": ["http://www.example.com"],
            }],
            public_network_access_enabled=False,
            connectivity_logs_enabled=True,
            messaging_logs_enabled=True,
            service_mode="Default",
            upstream_endpoints=[{
                "category_patterns": [
                    "connections",
                    "messages",
                ],
                "event_patterns": ["*"],
                "hub_patterns": ["hub1"],
                "url_template": "http://foo.com",
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.SignalRService`: 2024-03-01

        ## Import

        SignalR services can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:signalr/service:Service example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/terraform-signalr/providers/Microsoft.SignalRService/signalR/tfex-signalr
        ```

        :param str resource_name: The name of the resource.
        :param ServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aad_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 connectivity_logs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 cors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceCorArgs', 'ServiceCorArgsDict']]]]] = None,
                 http_request_logs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['ServiceIdentityArgs', 'ServiceIdentityArgsDict']]] = None,
                 live_trace: Optional[pulumi.Input[Union['ServiceLiveTraceArgs', 'ServiceLiveTraceArgsDict']]] = None,
                 live_trace_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 local_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 messaging_logs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 serverless_connection_timeout_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 service_mode: Optional[pulumi.Input[builtins.str]] = None,
                 sku: Optional[pulumi.Input[Union['ServiceSkuArgs', 'ServiceSkuArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tls_client_cert_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 upstream_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceUpstreamEndpointArgs', 'ServiceUpstreamEndpointArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceArgs.__new__(ServiceArgs)

            __props__.__dict__["aad_auth_enabled"] = aad_auth_enabled
            __props__.__dict__["connectivity_logs_enabled"] = connectivity_logs_enabled
            __props__.__dict__["cors"] = cors
            __props__.__dict__["http_request_logs_enabled"] = http_request_logs_enabled
            __props__.__dict__["identity"] = identity
            __props__.__dict__["live_trace"] = live_trace
            __props__.__dict__["live_trace_enabled"] = live_trace_enabled
            __props__.__dict__["local_auth_enabled"] = local_auth_enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["messaging_logs_enabled"] = messaging_logs_enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["serverless_connection_timeout_in_seconds"] = serverless_connection_timeout_in_seconds
            __props__.__dict__["service_mode"] = service_mode
            if sku is None and not opts.urn:
                raise TypeError("Missing required property 'sku'")
            __props__.__dict__["sku"] = sku
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tls_client_cert_enabled"] = tls_client_cert_enabled
            __props__.__dict__["upstream_endpoints"] = upstream_endpoints
            __props__.__dict__["hostname"] = None
            __props__.__dict__["ip_address"] = None
            __props__.__dict__["primary_access_key"] = None
            __props__.__dict__["primary_connection_string"] = None
            __props__.__dict__["public_port"] = None
            __props__.__dict__["secondary_access_key"] = None
            __props__.__dict__["secondary_connection_string"] = None
            __props__.__dict__["server_port"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["primaryAccessKey", "primaryConnectionString", "secondaryAccessKey", "secondaryConnectionString"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Service, __self__).__init__(
            'azure:signalr/service:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aad_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            connectivity_logs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            cors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceCorArgs', 'ServiceCorArgsDict']]]]] = None,
            hostname: Optional[pulumi.Input[builtins.str]] = None,
            http_request_logs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            identity: Optional[pulumi.Input[Union['ServiceIdentityArgs', 'ServiceIdentityArgsDict']]] = None,
            ip_address: Optional[pulumi.Input[builtins.str]] = None,
            live_trace: Optional[pulumi.Input[Union['ServiceLiveTraceArgs', 'ServiceLiveTraceArgsDict']]] = None,
            live_trace_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            local_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            messaging_logs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            primary_access_key: Optional[pulumi.Input[builtins.str]] = None,
            primary_connection_string: Optional[pulumi.Input[builtins.str]] = None,
            public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            public_port: Optional[pulumi.Input[builtins.int]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            secondary_access_key: Optional[pulumi.Input[builtins.str]] = None,
            secondary_connection_string: Optional[pulumi.Input[builtins.str]] = None,
            server_port: Optional[pulumi.Input[builtins.int]] = None,
            serverless_connection_timeout_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
            service_mode: Optional[pulumi.Input[builtins.str]] = None,
            sku: Optional[pulumi.Input[Union['ServiceSkuArgs', 'ServiceSkuArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tls_client_cert_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            upstream_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceUpstreamEndpointArgs', 'ServiceUpstreamEndpointArgsDict']]]]] = None) -> 'Service':
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] aad_auth_enabled: Whether to enable AAD auth? Defaults to `true`.
        :param pulumi.Input[builtins.bool] connectivity_logs_enabled: Specifies if Connectivity Logs are enabled or not. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceCorArgs', 'ServiceCorArgsDict']]]] cors: A `cors` block as documented below.
        :param pulumi.Input[builtins.str] hostname: The FQDN of the SignalR service.
        :param pulumi.Input[builtins.bool] http_request_logs_enabled: Specifies if Http Request Logs are enabled or not. Defaults to `false`.
        :param pulumi.Input[Union['ServiceIdentityArgs', 'ServiceIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[builtins.str] ip_address: The publicly accessible IP of the SignalR service.
        :param pulumi.Input[Union['ServiceLiveTraceArgs', 'ServiceLiveTraceArgsDict']] live_trace: A `live_trace` block as defined below.
        :param pulumi.Input[builtins.bool] local_auth_enabled: Whether to enable local auth? Defaults to `true`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the SignalR service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] messaging_logs_enabled: Specifies if Messaging Logs are enabled or not. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: The name of the SignalR service. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] primary_access_key: The primary access key for the SignalR service.
        :param pulumi.Input[builtins.str] primary_connection_string: The primary connection string for the SignalR service.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Whether to enable public network access? Defaults to `true`.
               
               > **Note:** `public_network_access_enabled` cannot be set to `false` in `Free` sku tier.
        :param pulumi.Input[builtins.int] public_port: The publicly accessible port of the SignalR service which is designed for browser/client use.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the SignalR service. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] secondary_access_key: The secondary access key for the SignalR service.
        :param pulumi.Input[builtins.str] secondary_connection_string: The secondary connection string for the SignalR service.
        :param pulumi.Input[builtins.int] server_port: The publicly accessible port of the SignalR service which is designed for customer server side use.
        :param pulumi.Input[builtins.int] serverless_connection_timeout_in_seconds: Specifies the client connection timeout. Defaults to `30`.
        :param pulumi.Input[builtins.str] service_mode: Specifies the service mode. Possible values are `Classic`, `Default` and `Serverless`. Defaults to `Default`.
        :param pulumi.Input[Union['ServiceSkuArgs', 'ServiceSkuArgsDict']] sku: A `sku` block as documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.bool] tls_client_cert_enabled: Whether to request client certificate during TLS handshake? Defaults to `false`.
               
               > **Note:** `tls_client_cert_enabled` cannot be set to `true` in `Free` sku tier.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceUpstreamEndpointArgs', 'ServiceUpstreamEndpointArgsDict']]]] upstream_endpoints: An `upstream_endpoint` block as documented below. Using this block requires the SignalR service to be Serverless. When creating multiple blocks they will be processed in the order they are defined in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceState.__new__(_ServiceState)

        __props__.__dict__["aad_auth_enabled"] = aad_auth_enabled
        __props__.__dict__["connectivity_logs_enabled"] = connectivity_logs_enabled
        __props__.__dict__["cors"] = cors
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["http_request_logs_enabled"] = http_request_logs_enabled
        __props__.__dict__["identity"] = identity
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["live_trace"] = live_trace
        __props__.__dict__["live_trace_enabled"] = live_trace_enabled
        __props__.__dict__["local_auth_enabled"] = local_auth_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["messaging_logs_enabled"] = messaging_logs_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["primary_access_key"] = primary_access_key
        __props__.__dict__["primary_connection_string"] = primary_connection_string
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["public_port"] = public_port
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["secondary_access_key"] = secondary_access_key
        __props__.__dict__["secondary_connection_string"] = secondary_connection_string
        __props__.__dict__["server_port"] = server_port
        __props__.__dict__["serverless_connection_timeout_in_seconds"] = serverless_connection_timeout_in_seconds
        __props__.__dict__["service_mode"] = service_mode
        __props__.__dict__["sku"] = sku
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tls_client_cert_enabled"] = tls_client_cert_enabled
        __props__.__dict__["upstream_endpoints"] = upstream_endpoints
        return Service(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aadAuthEnabled")
    def aad_auth_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to enable AAD auth? Defaults to `true`.
        """
        return pulumi.get(self, "aad_auth_enabled")

    @property
    @pulumi.getter(name="connectivityLogsEnabled")
    def connectivity_logs_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies if Connectivity Logs are enabled or not. Defaults to `false`.
        """
        return pulumi.get(self, "connectivity_logs_enabled")

    @property
    @pulumi.getter
    def cors(self) -> pulumi.Output[Sequence['outputs.ServiceCor']]:
        """
        A `cors` block as documented below.
        """
        return pulumi.get(self, "cors")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[builtins.str]:
        """
        The FQDN of the SignalR service.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="httpRequestLogsEnabled")
    def http_request_logs_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies if Http Request Logs are enabled or not. Defaults to `false`.
        """
        return pulumi.get(self, "http_request_logs_enabled")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.ServiceIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[builtins.str]:
        """
        The publicly accessible IP of the SignalR service.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="liveTrace")
    def live_trace(self) -> pulumi.Output[Optional['outputs.ServiceLiveTrace']]:
        """
        A `live_trace` block as defined below.
        """
        return pulumi.get(self, "live_trace")

    @property
    @pulumi.getter(name="liveTraceEnabled")
    @_utilities.deprecated("""`live_trace_enabled` has been deprecated in favor of `live_trace` and will be removed in 4.0.""")
    def live_trace_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "live_trace_enabled")

    @property
    @pulumi.getter(name="localAuthEnabled")
    def local_auth_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to enable local auth? Defaults to `true`.
        """
        return pulumi.get(self, "local_auth_enabled")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the supported Azure location where the SignalR service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="messagingLogsEnabled")
    def messaging_logs_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies if Messaging Logs are enabled or not. Defaults to `false`.
        """
        return pulumi.get(self, "messaging_logs_enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the SignalR service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="primaryAccessKey")
    def primary_access_key(self) -> pulumi.Output[builtins.str]:
        """
        The primary access key for the SignalR service.
        """
        return pulumi.get(self, "primary_access_key")

    @property
    @pulumi.getter(name="primaryConnectionString")
    def primary_connection_string(self) -> pulumi.Output[builtins.str]:
        """
        The primary connection string for the SignalR service.
        """
        return pulumi.get(self, "primary_connection_string")

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to enable public network access? Defaults to `true`.

        > **Note:** `public_network_access_enabled` cannot be set to `false` in `Free` sku tier.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @property
    @pulumi.getter(name="publicPort")
    def public_port(self) -> pulumi.Output[builtins.int]:
        """
        The publicly accessible port of the SignalR service which is designed for browser/client use.
        """
        return pulumi.get(self, "public_port")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group in which to create the SignalR service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="secondaryAccessKey")
    def secondary_access_key(self) -> pulumi.Output[builtins.str]:
        """
        The secondary access key for the SignalR service.
        """
        return pulumi.get(self, "secondary_access_key")

    @property
    @pulumi.getter(name="secondaryConnectionString")
    def secondary_connection_string(self) -> pulumi.Output[builtins.str]:
        """
        The secondary connection string for the SignalR service.
        """
        return pulumi.get(self, "secondary_connection_string")

    @property
    @pulumi.getter(name="serverPort")
    def server_port(self) -> pulumi.Output[builtins.int]:
        """
        The publicly accessible port of the SignalR service which is designed for customer server side use.
        """
        return pulumi.get(self, "server_port")

    @property
    @pulumi.getter(name="serverlessConnectionTimeoutInSeconds")
    def serverless_connection_timeout_in_seconds(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the client connection timeout. Defaults to `30`.
        """
        return pulumi.get(self, "serverless_connection_timeout_in_seconds")

    @property
    @pulumi.getter(name="serviceMode")
    def service_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the service mode. Possible values are `Classic`, `Default` and `Serverless`. Defaults to `Default`.
        """
        return pulumi.get(self, "service_mode")

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Output['outputs.ServiceSku']:
        """
        A `sku` block as documented below.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tlsClientCertEnabled")
    def tls_client_cert_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to request client certificate during TLS handshake? Defaults to `false`.

        > **Note:** `tls_client_cert_enabled` cannot be set to `true` in `Free` sku tier.
        """
        return pulumi.get(self, "tls_client_cert_enabled")

    @property
    @pulumi.getter(name="upstreamEndpoints")
    def upstream_endpoints(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceUpstreamEndpoint']]]:
        """
        An `upstream_endpoint` block as documented below. Using this block requires the SignalR service to be Serverless. When creating multiple blocks they will be processed in the order they are defined in.
        """
        return pulumi.get(self, "upstream_endpoints")

