# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetReplicationRecoveryPlanResult',
    'AwaitableGetReplicationRecoveryPlanResult',
    'get_replication_recovery_plan',
    'get_replication_recovery_plan_output',
]

@pulumi.output_type
class GetReplicationRecoveryPlanResult:
    """
    A collection of values returned by getReplicationRecoveryPlan.
    """
    def __init__(__self__, azure_to_azure_settings=None, failover_deployment_model=None, id=None, name=None, recovery_groups=None, recovery_vault_id=None, source_recovery_fabric_id=None, target_recovery_fabric_id=None):
        if azure_to_azure_settings and not isinstance(azure_to_azure_settings, list):
            raise TypeError("Expected argument 'azure_to_azure_settings' to be a list")
        pulumi.set(__self__, "azure_to_azure_settings", azure_to_azure_settings)
        if failover_deployment_model and not isinstance(failover_deployment_model, str):
            raise TypeError("Expected argument 'failover_deployment_model' to be a str")
        pulumi.set(__self__, "failover_deployment_model", failover_deployment_model)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if recovery_groups and not isinstance(recovery_groups, list):
            raise TypeError("Expected argument 'recovery_groups' to be a list")
        pulumi.set(__self__, "recovery_groups", recovery_groups)
        if recovery_vault_id and not isinstance(recovery_vault_id, str):
            raise TypeError("Expected argument 'recovery_vault_id' to be a str")
        pulumi.set(__self__, "recovery_vault_id", recovery_vault_id)
        if source_recovery_fabric_id and not isinstance(source_recovery_fabric_id, str):
            raise TypeError("Expected argument 'source_recovery_fabric_id' to be a str")
        pulumi.set(__self__, "source_recovery_fabric_id", source_recovery_fabric_id)
        if target_recovery_fabric_id and not isinstance(target_recovery_fabric_id, str):
            raise TypeError("Expected argument 'target_recovery_fabric_id' to be a str")
        pulumi.set(__self__, "target_recovery_fabric_id", target_recovery_fabric_id)

    @property
    @pulumi.getter(name="azureToAzureSettings")
    def azure_to_azure_settings(self) -> Sequence['outputs.GetReplicationRecoveryPlanAzureToAzureSettingResult']:
        return pulumi.get(self, "azure_to_azure_settings")

    @property
    @pulumi.getter(name="failoverDeploymentModel")
    def failover_deployment_model(self) -> builtins.str:
        return pulumi.get(self, "failover_deployment_model")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the Action.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recoveryGroups")
    def recovery_groups(self) -> Sequence['outputs.GetReplicationRecoveryPlanRecoveryGroupResult']:
        """
        `recovery_group` block defined as below.
        """
        return pulumi.get(self, "recovery_groups")

    @property
    @pulumi.getter(name="recoveryVaultId")
    def recovery_vault_id(self) -> builtins.str:
        return pulumi.get(self, "recovery_vault_id")

    @property
    @pulumi.getter(name="sourceRecoveryFabricId")
    def source_recovery_fabric_id(self) -> builtins.str:
        """
        The ID of source fabric to be recovered from.
        """
        return pulumi.get(self, "source_recovery_fabric_id")

    @property
    @pulumi.getter(name="targetRecoveryFabricId")
    def target_recovery_fabric_id(self) -> builtins.str:
        """
        The ID of target fabric to recover.
        """
        return pulumi.get(self, "target_recovery_fabric_id")


class AwaitableGetReplicationRecoveryPlanResult(GetReplicationRecoveryPlanResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReplicationRecoveryPlanResult(
            azure_to_azure_settings=self.azure_to_azure_settings,
            failover_deployment_model=self.failover_deployment_model,
            id=self.id,
            name=self.name,
            recovery_groups=self.recovery_groups,
            recovery_vault_id=self.recovery_vault_id,
            source_recovery_fabric_id=self.source_recovery_fabric_id,
            target_recovery_fabric_id=self.target_recovery_fabric_id)


def get_replication_recovery_plan(name: Optional[builtins.str] = None,
                                  recovery_vault_id: Optional[builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReplicationRecoveryPlanResult:
    """
    Get information about an Azure Site Recovery Plan within a Recovery Services vault. A recovery plan gathers machines into recovery groups for the purpose of failover.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    vault = azure.recoveryservices.get_vault(name="tfex-recovery_vault",
        resource_group_name="tfex-resource_group")
    example = azure.siterecovery.get_replication_recovery_plan(name="example-recovery-plan",
        recovery_vault_id=vault.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.RecoveryServices`: 2024-04-01


    :param builtins.str name: The name of the Replication Plan.
    :param builtins.str recovery_vault_id: The ID of the vault that should be updated.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['recoveryVaultId'] = recovery_vault_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:siterecovery/getReplicationRecoveryPlan:getReplicationRecoveryPlan', __args__, opts=opts, typ=GetReplicationRecoveryPlanResult).value

    return AwaitableGetReplicationRecoveryPlanResult(
        azure_to_azure_settings=pulumi.get(__ret__, 'azure_to_azure_settings'),
        failover_deployment_model=pulumi.get(__ret__, 'failover_deployment_model'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        recovery_groups=pulumi.get(__ret__, 'recovery_groups'),
        recovery_vault_id=pulumi.get(__ret__, 'recovery_vault_id'),
        source_recovery_fabric_id=pulumi.get(__ret__, 'source_recovery_fabric_id'),
        target_recovery_fabric_id=pulumi.get(__ret__, 'target_recovery_fabric_id'))
def get_replication_recovery_plan_output(name: Optional[pulumi.Input[builtins.str]] = None,
                                         recovery_vault_id: Optional[pulumi.Input[builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetReplicationRecoveryPlanResult]:
    """
    Get information about an Azure Site Recovery Plan within a Recovery Services vault. A recovery plan gathers machines into recovery groups for the purpose of failover.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    vault = azure.recoveryservices.get_vault(name="tfex-recovery_vault",
        resource_group_name="tfex-resource_group")
    example = azure.siterecovery.get_replication_recovery_plan(name="example-recovery-plan",
        recovery_vault_id=vault.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.RecoveryServices`: 2024-04-01


    :param builtins.str name: The name of the Replication Plan.
    :param builtins.str recovery_vault_id: The ID of the vault that should be updated.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['recoveryVaultId'] = recovery_vault_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:siterecovery/getReplicationRecoveryPlan:getReplicationRecoveryPlan', __args__, opts=opts, typ=GetReplicationRecoveryPlanResult)
    return __ret__.apply(lambda __response__: GetReplicationRecoveryPlanResult(
        azure_to_azure_settings=pulumi.get(__response__, 'azure_to_azure_settings'),
        failover_deployment_model=pulumi.get(__response__, 'failover_deployment_model'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        recovery_groups=pulumi.get(__response__, 'recovery_groups'),
        recovery_vault_id=pulumi.get(__response__, 'recovery_vault_id'),
        source_recovery_fabric_id=pulumi.get(__response__, 'source_recovery_fabric_id'),
        target_recovery_fabric_id=pulumi.get(__response__, 'target_recovery_fabric_id')))
