# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NetworkMappingArgs', 'NetworkMapping']

@pulumi.input_type
class NetworkMappingArgs:
    def __init__(__self__, *,
                 recovery_vault_name: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 source_network_id: pulumi.Input[builtins.str],
                 source_recovery_fabric_name: pulumi.Input[builtins.str],
                 target_network_id: pulumi.Input[builtins.str],
                 target_recovery_fabric_name: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkMapping resource.
        :param pulumi.Input[builtins.str] recovery_vault_name: The name of the vault that should be updated. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Name of the resource group where the vault that should be updated is located. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_network_id: The id of the primary network. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_recovery_fabric_name: Specifies the ASR fabric where mapping should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_network_id: The id of the recovery network. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_recovery_fabric_name: The Azure Site Recovery fabric object corresponding to the recovery Azure region. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the network mapping. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "recovery_vault_name", recovery_vault_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "source_network_id", source_network_id)
        pulumi.set(__self__, "source_recovery_fabric_name", source_recovery_fabric_name)
        pulumi.set(__self__, "target_network_id", target_network_id)
        pulumi.set(__self__, "target_recovery_fabric_name", target_recovery_fabric_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="recoveryVaultName")
    def recovery_vault_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the vault that should be updated. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_vault_name")

    @recovery_vault_name.setter
    def recovery_vault_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "recovery_vault_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the resource group where the vault that should be updated is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="sourceNetworkId")
    def source_network_id(self) -> pulumi.Input[builtins.str]:
        """
        The id of the primary network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_network_id")

    @source_network_id.setter
    def source_network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_network_id", value)

    @property
    @pulumi.getter(name="sourceRecoveryFabricName")
    def source_recovery_fabric_name(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the ASR fabric where mapping should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_recovery_fabric_name")

    @source_recovery_fabric_name.setter
    def source_recovery_fabric_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_recovery_fabric_name", value)

    @property
    @pulumi.getter(name="targetNetworkId")
    def target_network_id(self) -> pulumi.Input[builtins.str]:
        """
        The id of the recovery network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_network_id")

    @target_network_id.setter
    def target_network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_network_id", value)

    @property
    @pulumi.getter(name="targetRecoveryFabricName")
    def target_recovery_fabric_name(self) -> pulumi.Input[builtins.str]:
        """
        The Azure Site Recovery fabric object corresponding to the recovery Azure region. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_recovery_fabric_name")

    @target_recovery_fabric_name.setter
    def target_recovery_fabric_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_recovery_fabric_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the network mapping. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NetworkMappingState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 recovery_vault_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 source_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 source_recovery_fabric_name: Optional[pulumi.Input[builtins.str]] = None,
                 target_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_recovery_fabric_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkMapping resources.
        :param pulumi.Input[builtins.str] name: The name of the network mapping. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] recovery_vault_name: The name of the vault that should be updated. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Name of the resource group where the vault that should be updated is located. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_network_id: The id of the primary network. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_recovery_fabric_name: Specifies the ASR fabric where mapping should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_network_id: The id of the recovery network. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_recovery_fabric_name: The Azure Site Recovery fabric object corresponding to the recovery Azure region. Changing this forces a new resource to be created.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if recovery_vault_name is not None:
            pulumi.set(__self__, "recovery_vault_name", recovery_vault_name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if source_network_id is not None:
            pulumi.set(__self__, "source_network_id", source_network_id)
        if source_recovery_fabric_name is not None:
            pulumi.set(__self__, "source_recovery_fabric_name", source_recovery_fabric_name)
        if target_network_id is not None:
            pulumi.set(__self__, "target_network_id", target_network_id)
        if target_recovery_fabric_name is not None:
            pulumi.set(__self__, "target_recovery_fabric_name", target_recovery_fabric_name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the network mapping. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="recoveryVaultName")
    def recovery_vault_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the vault that should be updated. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_vault_name")

    @recovery_vault_name.setter
    def recovery_vault_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "recovery_vault_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource group where the vault that should be updated is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="sourceNetworkId")
    def source_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The id of the primary network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_network_id")

    @source_network_id.setter
    def source_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_network_id", value)

    @property
    @pulumi.getter(name="sourceRecoveryFabricName")
    def source_recovery_fabric_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the ASR fabric where mapping should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_recovery_fabric_name")

    @source_recovery_fabric_name.setter
    def source_recovery_fabric_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_recovery_fabric_name", value)

    @property
    @pulumi.getter(name="targetNetworkId")
    def target_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The id of the recovery network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_network_id")

    @target_network_id.setter
    def target_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_network_id", value)

    @property
    @pulumi.getter(name="targetRecoveryFabricName")
    def target_recovery_fabric_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Site Recovery fabric object corresponding to the recovery Azure region. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_recovery_fabric_name")

    @target_recovery_fabric_name.setter
    def target_recovery_fabric_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_recovery_fabric_name", value)


@pulumi.type_token("azure:siterecovery/networkMapping:NetworkMapping")
class NetworkMapping(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 recovery_vault_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 source_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 source_recovery_fabric_name: Optional[pulumi.Input[builtins.str]] = None,
                 target_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_recovery_fabric_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a site recovery network mapping on Azure. A network mapping decides how to translate connected networks when a VM is migrated from one region to another.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        primary = azure.core.ResourceGroup("primary",
            name="tfex-network-mapping-primary",
            location="West US")
        secondary = azure.core.ResourceGroup("secondary",
            name="tfex-network-mapping-secondary",
            location="East US")
        vault = azure.recoveryservices.Vault("vault",
            name="example-recovery-vault",
            location=secondary.location,
            resource_group_name=secondary.name,
            sku="Standard")
        primary_fabric = azure.siterecovery.Fabric("primary",
            name="primary-fabric",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            location=primary.location)
        secondary_fabric = azure.siterecovery.Fabric("secondary",
            name="secondary-fabric",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            location=secondary.location,
            opts = pulumi.ResourceOptions(depends_on=[primary_fabric]))
        primary_virtual_network = azure.network.VirtualNetwork("primary",
            name="network1",
            resource_group_name=primary.name,
            address_spaces=["192.168.1.0/24"],
            location=primary.location)
        secondary_virtual_network = azure.network.VirtualNetwork("secondary",
            name="network2",
            resource_group_name=secondary.name,
            address_spaces=["192.168.2.0/24"],
            location=secondary.location)
        recovery_mapping = azure.siterecovery.NetworkMapping("recovery-mapping",
            name="recovery-network-mapping-1",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            source_recovery_fabric_name="primary-fabric",
            target_recovery_fabric_name="secondary-fabric",
            source_network_id=primary_virtual_network.id,
            target_network_id=secondary_virtual_network.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.RecoveryServices`: 2024-04-01

        ## Import

        Site Recovery Network Mapping can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:siterecovery/networkMapping:NetworkMapping mymapping /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resource-group-name/providers/Microsoft.RecoveryServices/vaults/recovery-vault-name/replicationFabrics/primary-fabric-name/replicationNetworks/azureNetwork/replicationNetworkMappings/mapping-name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The name of the network mapping. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] recovery_vault_name: The name of the vault that should be updated. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Name of the resource group where the vault that should be updated is located. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_network_id: The id of the primary network. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_recovery_fabric_name: Specifies the ASR fabric where mapping should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_network_id: The id of the recovery network. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_recovery_fabric_name: The Azure Site Recovery fabric object corresponding to the recovery Azure region. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkMappingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a site recovery network mapping on Azure. A network mapping decides how to translate connected networks when a VM is migrated from one region to another.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        primary = azure.core.ResourceGroup("primary",
            name="tfex-network-mapping-primary",
            location="West US")
        secondary = azure.core.ResourceGroup("secondary",
            name="tfex-network-mapping-secondary",
            location="East US")
        vault = azure.recoveryservices.Vault("vault",
            name="example-recovery-vault",
            location=secondary.location,
            resource_group_name=secondary.name,
            sku="Standard")
        primary_fabric = azure.siterecovery.Fabric("primary",
            name="primary-fabric",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            location=primary.location)
        secondary_fabric = azure.siterecovery.Fabric("secondary",
            name="secondary-fabric",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            location=secondary.location,
            opts = pulumi.ResourceOptions(depends_on=[primary_fabric]))
        primary_virtual_network = azure.network.VirtualNetwork("primary",
            name="network1",
            resource_group_name=primary.name,
            address_spaces=["192.168.1.0/24"],
            location=primary.location)
        secondary_virtual_network = azure.network.VirtualNetwork("secondary",
            name="network2",
            resource_group_name=secondary.name,
            address_spaces=["192.168.2.0/24"],
            location=secondary.location)
        recovery_mapping = azure.siterecovery.NetworkMapping("recovery-mapping",
            name="recovery-network-mapping-1",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            source_recovery_fabric_name="primary-fabric",
            target_recovery_fabric_name="secondary-fabric",
            source_network_id=primary_virtual_network.id,
            target_network_id=secondary_virtual_network.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.RecoveryServices`: 2024-04-01

        ## Import

        Site Recovery Network Mapping can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:siterecovery/networkMapping:NetworkMapping mymapping /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resource-group-name/providers/Microsoft.RecoveryServices/vaults/recovery-vault-name/replicationFabrics/primary-fabric-name/replicationNetworks/azureNetwork/replicationNetworkMappings/mapping-name
        ```

        :param str resource_name: The name of the resource.
        :param NetworkMappingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkMappingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 recovery_vault_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 source_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 source_recovery_fabric_name: Optional[pulumi.Input[builtins.str]] = None,
                 target_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_recovery_fabric_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkMappingArgs.__new__(NetworkMappingArgs)

            __props__.__dict__["name"] = name
            if recovery_vault_name is None and not opts.urn:
                raise TypeError("Missing required property 'recovery_vault_name'")
            __props__.__dict__["recovery_vault_name"] = recovery_vault_name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if source_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_network_id'")
            __props__.__dict__["source_network_id"] = source_network_id
            if source_recovery_fabric_name is None and not opts.urn:
                raise TypeError("Missing required property 'source_recovery_fabric_name'")
            __props__.__dict__["source_recovery_fabric_name"] = source_recovery_fabric_name
            if target_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_network_id'")
            __props__.__dict__["target_network_id"] = target_network_id
            if target_recovery_fabric_name is None and not opts.urn:
                raise TypeError("Missing required property 'target_recovery_fabric_name'")
            __props__.__dict__["target_recovery_fabric_name"] = target_recovery_fabric_name
        super(NetworkMapping, __self__).__init__(
            'azure:siterecovery/networkMapping:NetworkMapping',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            recovery_vault_name: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            source_network_id: Optional[pulumi.Input[builtins.str]] = None,
            source_recovery_fabric_name: Optional[pulumi.Input[builtins.str]] = None,
            target_network_id: Optional[pulumi.Input[builtins.str]] = None,
            target_recovery_fabric_name: Optional[pulumi.Input[builtins.str]] = None) -> 'NetworkMapping':
        """
        Get an existing NetworkMapping resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The name of the network mapping. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] recovery_vault_name: The name of the vault that should be updated. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Name of the resource group where the vault that should be updated is located. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_network_id: The id of the primary network. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_recovery_fabric_name: Specifies the ASR fabric where mapping should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_network_id: The id of the recovery network. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_recovery_fabric_name: The Azure Site Recovery fabric object corresponding to the recovery Azure region. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkMappingState.__new__(_NetworkMappingState)

        __props__.__dict__["name"] = name
        __props__.__dict__["recovery_vault_name"] = recovery_vault_name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["source_network_id"] = source_network_id
        __props__.__dict__["source_recovery_fabric_name"] = source_recovery_fabric_name
        __props__.__dict__["target_network_id"] = target_network_id
        __props__.__dict__["target_recovery_fabric_name"] = target_recovery_fabric_name
        return NetworkMapping(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the network mapping. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recoveryVaultName")
    def recovery_vault_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the vault that should be updated. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_vault_name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the resource group where the vault that should be updated is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="sourceNetworkId")
    def source_network_id(self) -> pulumi.Output[builtins.str]:
        """
        The id of the primary network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_network_id")

    @property
    @pulumi.getter(name="sourceRecoveryFabricName")
    def source_recovery_fabric_name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the ASR fabric where mapping should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_recovery_fabric_name")

    @property
    @pulumi.getter(name="targetNetworkId")
    def target_network_id(self) -> pulumi.Output[builtins.str]:
        """
        The id of the recovery network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_network_id")

    @property
    @pulumi.getter(name="targetRecoveryFabricName")
    def target_recovery_fabric_name(self) -> pulumi.Output[builtins.str]:
        """
        The Azure Site Recovery fabric object corresponding to the recovery Azure region. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_recovery_fabric_name")

