# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReplicatedVMArgs', 'ReplicatedVM']

@pulumi.input_type
class ReplicatedVMArgs:
    def __init__(__self__, *,
                 recovery_replication_policy_id: pulumi.Input[builtins.str],
                 recovery_vault_name: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 source_recovery_fabric_name: pulumi.Input[builtins.str],
                 source_recovery_protection_container_name: pulumi.Input[builtins.str],
                 source_vm_id: pulumi.Input[builtins.str],
                 target_recovery_fabric_id: pulumi.Input[builtins.str],
                 target_recovery_protection_container_id: pulumi.Input[builtins.str],
                 target_resource_group_id: pulumi.Input[builtins.str],
                 managed_disks: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicatedVMManagedDiskArgs']]]] = None,
                 multi_vm_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicatedVMNetworkInterfaceArgs']]]] = None,
                 target_availability_set_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_boot_diagnostic_storage_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_capacity_reservation_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_edge_zone: Optional[pulumi.Input[builtins.str]] = None,
                 target_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_proximity_placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_virtual_machine_scale_set_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_virtual_machine_size: Optional[pulumi.Input[builtins.str]] = None,
                 target_zone: Optional[pulumi.Input[builtins.str]] = None,
                 test_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 unmanaged_disks: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicatedVMUnmanagedDiskArgs']]]] = None):
        """
        The set of arguments for constructing a ReplicatedVM resource.
        :param pulumi.Input[builtins.str] recovery_replication_policy_id: Id of the policy to use for this replicated vm. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] recovery_vault_name: The name of the vault that should be updated. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Name of the resource group where the vault that should be updated is located. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_recovery_fabric_name: Name of fabric that should contain this replication. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_recovery_protection_container_name: Name of the protection container to use. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_vm_id: Id of the VM to replicate Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_recovery_fabric_id: Id of fabric where the VM replication should be handled when a failover is done. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_recovery_protection_container_id: Id of protection container where the VM replication should be created when a failover is done. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_resource_group_id: Id of resource group where the VM should be created when a failover is done. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicatedVMManagedDiskArgs']]] managed_disks: One or more `managed_disk` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] multi_vm_group_name: Name of group in which all machines will replicate together and have shared crash consistent and app-consistent recovery points when failed over.
        :param pulumi.Input[builtins.str] name: The name of the replication for the replicated VM. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicatedVMNetworkInterfaceArgs']]] network_interfaces: One or more `network_interface` block as defined below.
        :param pulumi.Input[builtins.str] target_availability_set_id: Id of availability set that the new VM should belong to when a failover is done.
        :param pulumi.Input[builtins.str] target_boot_diagnostic_storage_account_id: Id of the storage account which the new VM should used for boot diagnostic when a failover is done.
        :param pulumi.Input[builtins.str] target_capacity_reservation_group_id: Id of the Capacity reservation group where the new VM should belong to when a failover is done.
        :param pulumi.Input[builtins.str] target_edge_zone: Specifies the Edge Zone within the Azure Region where this Managed Kubernetes Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_network_id: Network to use when a failover is done (recommended to set if any network_interface is configured for failover).
        :param pulumi.Input[builtins.str] target_proximity_placement_group_id: Id of Proximity Placement Group the new VM should belong to when a failover is done.
        :param pulumi.Input[builtins.str] target_virtual_machine_scale_set_id: Id of the Virtual Machine Scale Set which the new Vm should belong to when a failover is done.
        :param pulumi.Input[builtins.str] target_virtual_machine_size: Specifies the size the Virtual Machine should have.
        :param pulumi.Input[builtins.str] target_zone: Specifies the Availability Zone where the Failover VM should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] test_network_id: Network to use when a test failover is done.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicatedVMUnmanagedDiskArgs']]] unmanaged_disks: One or more `unmanaged_disk` block as defined below. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "recovery_replication_policy_id", recovery_replication_policy_id)
        pulumi.set(__self__, "recovery_vault_name", recovery_vault_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "source_recovery_fabric_name", source_recovery_fabric_name)
        pulumi.set(__self__, "source_recovery_protection_container_name", source_recovery_protection_container_name)
        pulumi.set(__self__, "source_vm_id", source_vm_id)
        pulumi.set(__self__, "target_recovery_fabric_id", target_recovery_fabric_id)
        pulumi.set(__self__, "target_recovery_protection_container_id", target_recovery_protection_container_id)
        pulumi.set(__self__, "target_resource_group_id", target_resource_group_id)
        if managed_disks is not None:
            pulumi.set(__self__, "managed_disks", managed_disks)
        if multi_vm_group_name is not None:
            pulumi.set(__self__, "multi_vm_group_name", multi_vm_group_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if target_availability_set_id is not None:
            pulumi.set(__self__, "target_availability_set_id", target_availability_set_id)
        if target_boot_diagnostic_storage_account_id is not None:
            pulumi.set(__self__, "target_boot_diagnostic_storage_account_id", target_boot_diagnostic_storage_account_id)
        if target_capacity_reservation_group_id is not None:
            pulumi.set(__self__, "target_capacity_reservation_group_id", target_capacity_reservation_group_id)
        if target_edge_zone is not None:
            pulumi.set(__self__, "target_edge_zone", target_edge_zone)
        if target_network_id is not None:
            pulumi.set(__self__, "target_network_id", target_network_id)
        if target_proximity_placement_group_id is not None:
            pulumi.set(__self__, "target_proximity_placement_group_id", target_proximity_placement_group_id)
        if target_virtual_machine_scale_set_id is not None:
            pulumi.set(__self__, "target_virtual_machine_scale_set_id", target_virtual_machine_scale_set_id)
        if target_virtual_machine_size is not None:
            pulumi.set(__self__, "target_virtual_machine_size", target_virtual_machine_size)
        if target_zone is not None:
            pulumi.set(__self__, "target_zone", target_zone)
        if test_network_id is not None:
            pulumi.set(__self__, "test_network_id", test_network_id)
        if unmanaged_disks is not None:
            pulumi.set(__self__, "unmanaged_disks", unmanaged_disks)

    @property
    @pulumi.getter(name="recoveryReplicationPolicyId")
    def recovery_replication_policy_id(self) -> pulumi.Input[builtins.str]:
        """
        Id of the policy to use for this replicated vm. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_replication_policy_id")

    @recovery_replication_policy_id.setter
    def recovery_replication_policy_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "recovery_replication_policy_id", value)

    @property
    @pulumi.getter(name="recoveryVaultName")
    def recovery_vault_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the vault that should be updated. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_vault_name")

    @recovery_vault_name.setter
    def recovery_vault_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "recovery_vault_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the resource group where the vault that should be updated is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="sourceRecoveryFabricName")
    def source_recovery_fabric_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of fabric that should contain this replication. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_recovery_fabric_name")

    @source_recovery_fabric_name.setter
    def source_recovery_fabric_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_recovery_fabric_name", value)

    @property
    @pulumi.getter(name="sourceRecoveryProtectionContainerName")
    def source_recovery_protection_container_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the protection container to use. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_recovery_protection_container_name")

    @source_recovery_protection_container_name.setter
    def source_recovery_protection_container_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_recovery_protection_container_name", value)

    @property
    @pulumi.getter(name="sourceVmId")
    def source_vm_id(self) -> pulumi.Input[builtins.str]:
        """
        Id of the VM to replicate Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_vm_id")

    @source_vm_id.setter
    def source_vm_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_vm_id", value)

    @property
    @pulumi.getter(name="targetRecoveryFabricId")
    def target_recovery_fabric_id(self) -> pulumi.Input[builtins.str]:
        """
        Id of fabric where the VM replication should be handled when a failover is done. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_recovery_fabric_id")

    @target_recovery_fabric_id.setter
    def target_recovery_fabric_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_recovery_fabric_id", value)

    @property
    @pulumi.getter(name="targetRecoveryProtectionContainerId")
    def target_recovery_protection_container_id(self) -> pulumi.Input[builtins.str]:
        """
        Id of protection container where the VM replication should be created when a failover is done. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_recovery_protection_container_id")

    @target_recovery_protection_container_id.setter
    def target_recovery_protection_container_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_recovery_protection_container_id", value)

    @property
    @pulumi.getter(name="targetResourceGroupId")
    def target_resource_group_id(self) -> pulumi.Input[builtins.str]:
        """
        Id of resource group where the VM should be created when a failover is done. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_resource_group_id")

    @target_resource_group_id.setter
    def target_resource_group_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_resource_group_id", value)

    @property
    @pulumi.getter(name="managedDisks")
    def managed_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicatedVMManagedDiskArgs']]]]:
        """
        One or more `managed_disk` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_disks")

    @managed_disks.setter
    def managed_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicatedVMManagedDiskArgs']]]]):
        pulumi.set(self, "managed_disks", value)

    @property
    @pulumi.getter(name="multiVmGroupName")
    def multi_vm_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of group in which all machines will replicate together and have shared crash consistent and app-consistent recovery points when failed over.
        """
        return pulumi.get(self, "multi_vm_group_name")

    @multi_vm_group_name.setter
    def multi_vm_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "multi_vm_group_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the replication for the replicated VM. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicatedVMNetworkInterfaceArgs']]]]:
        """
        One or more `network_interface` block as defined below.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicatedVMNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="targetAvailabilitySetId")
    def target_availability_set_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id of availability set that the new VM should belong to when a failover is done.
        """
        return pulumi.get(self, "target_availability_set_id")

    @target_availability_set_id.setter
    def target_availability_set_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_availability_set_id", value)

    @property
    @pulumi.getter(name="targetBootDiagnosticStorageAccountId")
    def target_boot_diagnostic_storage_account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id of the storage account which the new VM should used for boot diagnostic when a failover is done.
        """
        return pulumi.get(self, "target_boot_diagnostic_storage_account_id")

    @target_boot_diagnostic_storage_account_id.setter
    def target_boot_diagnostic_storage_account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_boot_diagnostic_storage_account_id", value)

    @property
    @pulumi.getter(name="targetCapacityReservationGroupId")
    def target_capacity_reservation_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id of the Capacity reservation group where the new VM should belong to when a failover is done.
        """
        return pulumi.get(self, "target_capacity_reservation_group_id")

    @target_capacity_reservation_group_id.setter
    def target_capacity_reservation_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_capacity_reservation_group_id", value)

    @property
    @pulumi.getter(name="targetEdgeZone")
    def target_edge_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Edge Zone within the Azure Region where this Managed Kubernetes Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_edge_zone")

    @target_edge_zone.setter
    def target_edge_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_edge_zone", value)

    @property
    @pulumi.getter(name="targetNetworkId")
    def target_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Network to use when a failover is done (recommended to set if any network_interface is configured for failover).
        """
        return pulumi.get(self, "target_network_id")

    @target_network_id.setter
    def target_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_network_id", value)

    @property
    @pulumi.getter(name="targetProximityPlacementGroupId")
    def target_proximity_placement_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id of Proximity Placement Group the new VM should belong to when a failover is done.
        """
        return pulumi.get(self, "target_proximity_placement_group_id")

    @target_proximity_placement_group_id.setter
    def target_proximity_placement_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_proximity_placement_group_id", value)

    @property
    @pulumi.getter(name="targetVirtualMachineScaleSetId")
    def target_virtual_machine_scale_set_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id of the Virtual Machine Scale Set which the new Vm should belong to when a failover is done.
        """
        return pulumi.get(self, "target_virtual_machine_scale_set_id")

    @target_virtual_machine_scale_set_id.setter
    def target_virtual_machine_scale_set_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_virtual_machine_scale_set_id", value)

    @property
    @pulumi.getter(name="targetVirtualMachineSize")
    def target_virtual_machine_size(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the size the Virtual Machine should have.
        """
        return pulumi.get(self, "target_virtual_machine_size")

    @target_virtual_machine_size.setter
    def target_virtual_machine_size(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_virtual_machine_size", value)

    @property
    @pulumi.getter(name="targetZone")
    def target_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Availability Zone where the Failover VM should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_zone")

    @target_zone.setter
    def target_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_zone", value)

    @property
    @pulumi.getter(name="testNetworkId")
    def test_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Network to use when a test failover is done.
        """
        return pulumi.get(self, "test_network_id")

    @test_network_id.setter
    def test_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "test_network_id", value)

    @property
    @pulumi.getter(name="unmanagedDisks")
    def unmanaged_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicatedVMUnmanagedDiskArgs']]]]:
        """
        One or more `unmanaged_disk` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "unmanaged_disks")

    @unmanaged_disks.setter
    def unmanaged_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicatedVMUnmanagedDiskArgs']]]]):
        pulumi.set(self, "unmanaged_disks", value)


@pulumi.input_type
class _ReplicatedVMState:
    def __init__(__self__, *,
                 managed_disks: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicatedVMManagedDiskArgs']]]] = None,
                 multi_vm_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicatedVMNetworkInterfaceArgs']]]] = None,
                 recovery_replication_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 recovery_vault_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 source_recovery_fabric_name: Optional[pulumi.Input[builtins.str]] = None,
                 source_recovery_protection_container_name: Optional[pulumi.Input[builtins.str]] = None,
                 source_vm_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_availability_set_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_boot_diagnostic_storage_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_capacity_reservation_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_edge_zone: Optional[pulumi.Input[builtins.str]] = None,
                 target_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_proximity_placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_recovery_fabric_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_recovery_protection_container_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_resource_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_virtual_machine_scale_set_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_virtual_machine_size: Optional[pulumi.Input[builtins.str]] = None,
                 target_zone: Optional[pulumi.Input[builtins.str]] = None,
                 test_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 unmanaged_disks: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicatedVMUnmanagedDiskArgs']]]] = None):
        """
        Input properties used for looking up and filtering ReplicatedVM resources.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicatedVMManagedDiskArgs']]] managed_disks: One or more `managed_disk` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] multi_vm_group_name: Name of group in which all machines will replicate together and have shared crash consistent and app-consistent recovery points when failed over.
        :param pulumi.Input[builtins.str] name: The name of the replication for the replicated VM. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicatedVMNetworkInterfaceArgs']]] network_interfaces: One or more `network_interface` block as defined below.
        :param pulumi.Input[builtins.str] recovery_replication_policy_id: Id of the policy to use for this replicated vm. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] recovery_vault_name: The name of the vault that should be updated. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Name of the resource group where the vault that should be updated is located. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_recovery_fabric_name: Name of fabric that should contain this replication. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_recovery_protection_container_name: Name of the protection container to use. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_vm_id: Id of the VM to replicate Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_availability_set_id: Id of availability set that the new VM should belong to when a failover is done.
        :param pulumi.Input[builtins.str] target_boot_diagnostic_storage_account_id: Id of the storage account which the new VM should used for boot diagnostic when a failover is done.
        :param pulumi.Input[builtins.str] target_capacity_reservation_group_id: Id of the Capacity reservation group where the new VM should belong to when a failover is done.
        :param pulumi.Input[builtins.str] target_edge_zone: Specifies the Edge Zone within the Azure Region where this Managed Kubernetes Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_network_id: Network to use when a failover is done (recommended to set if any network_interface is configured for failover).
        :param pulumi.Input[builtins.str] target_proximity_placement_group_id: Id of Proximity Placement Group the new VM should belong to when a failover is done.
        :param pulumi.Input[builtins.str] target_recovery_fabric_id: Id of fabric where the VM replication should be handled when a failover is done. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_recovery_protection_container_id: Id of protection container where the VM replication should be created when a failover is done. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_resource_group_id: Id of resource group where the VM should be created when a failover is done. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_virtual_machine_scale_set_id: Id of the Virtual Machine Scale Set which the new Vm should belong to when a failover is done.
        :param pulumi.Input[builtins.str] target_virtual_machine_size: Specifies the size the Virtual Machine should have.
        :param pulumi.Input[builtins.str] target_zone: Specifies the Availability Zone where the Failover VM should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] test_network_id: Network to use when a test failover is done.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicatedVMUnmanagedDiskArgs']]] unmanaged_disks: One or more `unmanaged_disk` block as defined below. Changing this forces a new resource to be created.
        """
        if managed_disks is not None:
            pulumi.set(__self__, "managed_disks", managed_disks)
        if multi_vm_group_name is not None:
            pulumi.set(__self__, "multi_vm_group_name", multi_vm_group_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if recovery_replication_policy_id is not None:
            pulumi.set(__self__, "recovery_replication_policy_id", recovery_replication_policy_id)
        if recovery_vault_name is not None:
            pulumi.set(__self__, "recovery_vault_name", recovery_vault_name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if source_recovery_fabric_name is not None:
            pulumi.set(__self__, "source_recovery_fabric_name", source_recovery_fabric_name)
        if source_recovery_protection_container_name is not None:
            pulumi.set(__self__, "source_recovery_protection_container_name", source_recovery_protection_container_name)
        if source_vm_id is not None:
            pulumi.set(__self__, "source_vm_id", source_vm_id)
        if target_availability_set_id is not None:
            pulumi.set(__self__, "target_availability_set_id", target_availability_set_id)
        if target_boot_diagnostic_storage_account_id is not None:
            pulumi.set(__self__, "target_boot_diagnostic_storage_account_id", target_boot_diagnostic_storage_account_id)
        if target_capacity_reservation_group_id is not None:
            pulumi.set(__self__, "target_capacity_reservation_group_id", target_capacity_reservation_group_id)
        if target_edge_zone is not None:
            pulumi.set(__self__, "target_edge_zone", target_edge_zone)
        if target_network_id is not None:
            pulumi.set(__self__, "target_network_id", target_network_id)
        if target_proximity_placement_group_id is not None:
            pulumi.set(__self__, "target_proximity_placement_group_id", target_proximity_placement_group_id)
        if target_recovery_fabric_id is not None:
            pulumi.set(__self__, "target_recovery_fabric_id", target_recovery_fabric_id)
        if target_recovery_protection_container_id is not None:
            pulumi.set(__self__, "target_recovery_protection_container_id", target_recovery_protection_container_id)
        if target_resource_group_id is not None:
            pulumi.set(__self__, "target_resource_group_id", target_resource_group_id)
        if target_virtual_machine_scale_set_id is not None:
            pulumi.set(__self__, "target_virtual_machine_scale_set_id", target_virtual_machine_scale_set_id)
        if target_virtual_machine_size is not None:
            pulumi.set(__self__, "target_virtual_machine_size", target_virtual_machine_size)
        if target_zone is not None:
            pulumi.set(__self__, "target_zone", target_zone)
        if test_network_id is not None:
            pulumi.set(__self__, "test_network_id", test_network_id)
        if unmanaged_disks is not None:
            pulumi.set(__self__, "unmanaged_disks", unmanaged_disks)

    @property
    @pulumi.getter(name="managedDisks")
    def managed_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicatedVMManagedDiskArgs']]]]:
        """
        One or more `managed_disk` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_disks")

    @managed_disks.setter
    def managed_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicatedVMManagedDiskArgs']]]]):
        pulumi.set(self, "managed_disks", value)

    @property
    @pulumi.getter(name="multiVmGroupName")
    def multi_vm_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of group in which all machines will replicate together and have shared crash consistent and app-consistent recovery points when failed over.
        """
        return pulumi.get(self, "multi_vm_group_name")

    @multi_vm_group_name.setter
    def multi_vm_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "multi_vm_group_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the replication for the replicated VM. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicatedVMNetworkInterfaceArgs']]]]:
        """
        One or more `network_interface` block as defined below.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicatedVMNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="recoveryReplicationPolicyId")
    def recovery_replication_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id of the policy to use for this replicated vm. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_replication_policy_id")

    @recovery_replication_policy_id.setter
    def recovery_replication_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "recovery_replication_policy_id", value)

    @property
    @pulumi.getter(name="recoveryVaultName")
    def recovery_vault_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the vault that should be updated. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_vault_name")

    @recovery_vault_name.setter
    def recovery_vault_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "recovery_vault_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource group where the vault that should be updated is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="sourceRecoveryFabricName")
    def source_recovery_fabric_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of fabric that should contain this replication. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_recovery_fabric_name")

    @source_recovery_fabric_name.setter
    def source_recovery_fabric_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_recovery_fabric_name", value)

    @property
    @pulumi.getter(name="sourceRecoveryProtectionContainerName")
    def source_recovery_protection_container_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the protection container to use. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_recovery_protection_container_name")

    @source_recovery_protection_container_name.setter
    def source_recovery_protection_container_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_recovery_protection_container_name", value)

    @property
    @pulumi.getter(name="sourceVmId")
    def source_vm_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id of the VM to replicate Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_vm_id")

    @source_vm_id.setter
    def source_vm_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_vm_id", value)

    @property
    @pulumi.getter(name="targetAvailabilitySetId")
    def target_availability_set_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id of availability set that the new VM should belong to when a failover is done.
        """
        return pulumi.get(self, "target_availability_set_id")

    @target_availability_set_id.setter
    def target_availability_set_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_availability_set_id", value)

    @property
    @pulumi.getter(name="targetBootDiagnosticStorageAccountId")
    def target_boot_diagnostic_storage_account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id of the storage account which the new VM should used for boot diagnostic when a failover is done.
        """
        return pulumi.get(self, "target_boot_diagnostic_storage_account_id")

    @target_boot_diagnostic_storage_account_id.setter
    def target_boot_diagnostic_storage_account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_boot_diagnostic_storage_account_id", value)

    @property
    @pulumi.getter(name="targetCapacityReservationGroupId")
    def target_capacity_reservation_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id of the Capacity reservation group where the new VM should belong to when a failover is done.
        """
        return pulumi.get(self, "target_capacity_reservation_group_id")

    @target_capacity_reservation_group_id.setter
    def target_capacity_reservation_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_capacity_reservation_group_id", value)

    @property
    @pulumi.getter(name="targetEdgeZone")
    def target_edge_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Edge Zone within the Azure Region where this Managed Kubernetes Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_edge_zone")

    @target_edge_zone.setter
    def target_edge_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_edge_zone", value)

    @property
    @pulumi.getter(name="targetNetworkId")
    def target_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Network to use when a failover is done (recommended to set if any network_interface is configured for failover).
        """
        return pulumi.get(self, "target_network_id")

    @target_network_id.setter
    def target_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_network_id", value)

    @property
    @pulumi.getter(name="targetProximityPlacementGroupId")
    def target_proximity_placement_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id of Proximity Placement Group the new VM should belong to when a failover is done.
        """
        return pulumi.get(self, "target_proximity_placement_group_id")

    @target_proximity_placement_group_id.setter
    def target_proximity_placement_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_proximity_placement_group_id", value)

    @property
    @pulumi.getter(name="targetRecoveryFabricId")
    def target_recovery_fabric_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id of fabric where the VM replication should be handled when a failover is done. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_recovery_fabric_id")

    @target_recovery_fabric_id.setter
    def target_recovery_fabric_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_recovery_fabric_id", value)

    @property
    @pulumi.getter(name="targetRecoveryProtectionContainerId")
    def target_recovery_protection_container_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id of protection container where the VM replication should be created when a failover is done. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_recovery_protection_container_id")

    @target_recovery_protection_container_id.setter
    def target_recovery_protection_container_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_recovery_protection_container_id", value)

    @property
    @pulumi.getter(name="targetResourceGroupId")
    def target_resource_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id of resource group where the VM should be created when a failover is done. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_resource_group_id")

    @target_resource_group_id.setter
    def target_resource_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_resource_group_id", value)

    @property
    @pulumi.getter(name="targetVirtualMachineScaleSetId")
    def target_virtual_machine_scale_set_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id of the Virtual Machine Scale Set which the new Vm should belong to when a failover is done.
        """
        return pulumi.get(self, "target_virtual_machine_scale_set_id")

    @target_virtual_machine_scale_set_id.setter
    def target_virtual_machine_scale_set_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_virtual_machine_scale_set_id", value)

    @property
    @pulumi.getter(name="targetVirtualMachineSize")
    def target_virtual_machine_size(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the size the Virtual Machine should have.
        """
        return pulumi.get(self, "target_virtual_machine_size")

    @target_virtual_machine_size.setter
    def target_virtual_machine_size(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_virtual_machine_size", value)

    @property
    @pulumi.getter(name="targetZone")
    def target_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Availability Zone where the Failover VM should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_zone")

    @target_zone.setter
    def target_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_zone", value)

    @property
    @pulumi.getter(name="testNetworkId")
    def test_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Network to use when a test failover is done.
        """
        return pulumi.get(self, "test_network_id")

    @test_network_id.setter
    def test_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "test_network_id", value)

    @property
    @pulumi.getter(name="unmanagedDisks")
    def unmanaged_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicatedVMUnmanagedDiskArgs']]]]:
        """
        One or more `unmanaged_disk` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "unmanaged_disks")

    @unmanaged_disks.setter
    def unmanaged_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicatedVMUnmanagedDiskArgs']]]]):
        pulumi.set(self, "unmanaged_disks", value)


@pulumi.type_token("azure:siterecovery/replicatedVM:ReplicatedVM")
class ReplicatedVM(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 managed_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicatedVMManagedDiskArgs', 'ReplicatedVMManagedDiskArgsDict']]]]] = None,
                 multi_vm_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicatedVMNetworkInterfaceArgs', 'ReplicatedVMNetworkInterfaceArgsDict']]]]] = None,
                 recovery_replication_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 recovery_vault_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 source_recovery_fabric_name: Optional[pulumi.Input[builtins.str]] = None,
                 source_recovery_protection_container_name: Optional[pulumi.Input[builtins.str]] = None,
                 source_vm_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_availability_set_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_boot_diagnostic_storage_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_capacity_reservation_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_edge_zone: Optional[pulumi.Input[builtins.str]] = None,
                 target_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_proximity_placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_recovery_fabric_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_recovery_protection_container_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_resource_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_virtual_machine_scale_set_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_virtual_machine_size: Optional[pulumi.Input[builtins.str]] = None,
                 target_zone: Optional[pulumi.Input[builtins.str]] = None,
                 test_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 unmanaged_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicatedVMUnmanagedDiskArgs', 'ReplicatedVMUnmanagedDiskArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages a VM replicated using Azure Site Recovery (Azure to Azure only). A replicated VM keeps a copiously updated image of the VM in another region in order to be able to start the VM in that region in case of a disaster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        primary = azure.core.ResourceGroup("primary",
            name="tfex-replicated-vm-primary",
            location="West US")
        secondary = azure.core.ResourceGroup("secondary",
            name="tfex-replicated-vm-secondary",
            location="East US")
        primary_virtual_network = azure.network.VirtualNetwork("primary",
            name="network1",
            resource_group_name=primary.name,
            address_spaces=["192.168.1.0/24"],
            location=primary.location)
        primary_subnet = azure.network.Subnet("primary",
            name="network1-subnet",
            resource_group_name=primary.name,
            virtual_network_name=primary_virtual_network.name,
            address_prefixes=["192.168.1.0/24"])
        primary_public_ip = azure.network.PublicIp("primary",
            name="vm-public-ip-primary",
            allocation_method="Static",
            location=primary.location,
            resource_group_name=primary.name,
            sku="Basic")
        vm_network_interface = azure.network.NetworkInterface("vm",
            name="vm-nic",
            location=primary.location,
            resource_group_name=primary.name,
            ip_configurations=[{
                "name": "vm",
                "subnet_id": primary_subnet.id,
                "private_ip_address_allocation": "Dynamic",
                "public_ip_address_id": primary_public_ip.id,
            }])
        vm = azure.compute.VirtualMachine("vm",
            name="vm",
            location=primary.location,
            resource_group_name=primary.name,
            vm_size="Standard_B1s",
            network_interface_ids=[vm_network_interface.id],
            storage_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            },
            storage_os_disk={
                "name": "vm-os-disk",
                "os_type": "Linux",
                "caching": "ReadWrite",
                "create_option": "FromImage",
                "managed_disk_type": "Premium_LRS",
            },
            os_profile={
                "admin_username": "test-admin-123",
                "admin_password": "test-pwd-123",
                "computer_name": "vm",
            },
            os_profile_linux_config={
                "disable_password_authentication": False,
            })
        vault = azure.recoveryservices.Vault("vault",
            name="example-recovery-vault",
            location=secondary.location,
            resource_group_name=secondary.name,
            sku="Standard")
        primary_fabric = azure.siterecovery.Fabric("primary",
            name="primary-fabric",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            location=primary.location)
        secondary_fabric = azure.siterecovery.Fabric("secondary",
            name="secondary-fabric",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            location=secondary.location)
        primary_protection_container = azure.siterecovery.ProtectionContainer("primary",
            name="primary-protection-container",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            recovery_fabric_name=primary_fabric.name)
        secondary_protection_container = azure.siterecovery.ProtectionContainer("secondary",
            name="secondary-protection-container",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            recovery_fabric_name=secondary_fabric.name)
        policy = azure.siterecovery.ReplicationPolicy("policy",
            name="policy",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            recovery_point_retention_in_minutes=24 * 60,
            application_consistent_snapshot_frequency_in_minutes=4 * 60)
        container_mapping = azure.siterecovery.ProtectionContainerMapping("container-mapping",
            name="container-mapping",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            recovery_fabric_name=primary_fabric.name,
            recovery_source_protection_container_name=primary_protection_container.name,
            recovery_target_protection_container_id=secondary_protection_container.id,
            recovery_replication_policy_id=policy.id)
        secondary_virtual_network = azure.network.VirtualNetwork("secondary",
            name="network2",
            resource_group_name=secondary.name,
            address_spaces=["192.168.2.0/24"],
            location=secondary.location)
        network_mapping = azure.siterecovery.NetworkMapping("network-mapping",
            name="network-mapping",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            source_recovery_fabric_name=primary_fabric.name,
            target_recovery_fabric_name=secondary_fabric.name,
            source_network_id=primary_virtual_network.id,
            target_network_id=secondary_virtual_network.id)
        primary_account = azure.storage.Account("primary",
            name="primaryrecoverycache",
            location=primary.location,
            resource_group_name=primary.name,
            account_tier="Standard",
            account_replication_type="LRS")
        secondary_subnet = azure.network.Subnet("secondary",
            name="network2-subnet",
            resource_group_name=secondary.name,
            virtual_network_name=secondary_virtual_network.name,
            address_prefixes=["192.168.2.0/24"])
        secondary_public_ip = azure.network.PublicIp("secondary",
            name="vm-public-ip-secondary",
            allocation_method="Static",
            location=secondary.location,
            resource_group_name=secondary.name,
            sku="Basic")
        vm_replication = azure.siterecovery.ReplicatedVM("vm-replication",
            name="vm-replication",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            source_recovery_fabric_name=primary_fabric.name,
            source_vm_id=vm.id,
            recovery_replication_policy_id=policy.id,
            source_recovery_protection_container_name=primary_protection_container.name,
            target_resource_group_id=secondary.id,
            target_recovery_fabric_id=secondary_fabric.id,
            target_recovery_protection_container_id=secondary_protection_container.id,
            managed_disks=[{
                "disk_id": vm.storage_os_disk.managed_disk_id,
                "staging_storage_account_id": primary_account.id,
                "target_resource_group_id": secondary.id,
                "target_disk_type": "Premium_LRS",
                "target_replica_disk_type": "Premium_LRS",
            }],
            network_interfaces=[{
                "source_network_interface_id": vm_network_interface.id,
                "target_subnet_name": secondary_subnet.name,
                "recovery_public_ip_address_id": secondary_public_ip.id,
            }],
            opts = pulumi.ResourceOptions(depends_on=[
                    container_mapping,
                    network_mapping,
                ]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.RecoveryServices`: 2024-04-01

        ## Import

        Site Recovery Replicated VM's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:siterecovery/replicatedVM:ReplicatedVM vmreplication /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resource-group-name/providers/Microsoft.RecoveryServices/vaults/recovery-vault-name/replicationFabrics/fabric-name/replicationProtectionContainers/protection-container-name/replicationProtectedItems/vm-replication-name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReplicatedVMManagedDiskArgs', 'ReplicatedVMManagedDiskArgsDict']]]] managed_disks: One or more `managed_disk` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] multi_vm_group_name: Name of group in which all machines will replicate together and have shared crash consistent and app-consistent recovery points when failed over.
        :param pulumi.Input[builtins.str] name: The name of the replication for the replicated VM. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReplicatedVMNetworkInterfaceArgs', 'ReplicatedVMNetworkInterfaceArgsDict']]]] network_interfaces: One or more `network_interface` block as defined below.
        :param pulumi.Input[builtins.str] recovery_replication_policy_id: Id of the policy to use for this replicated vm. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] recovery_vault_name: The name of the vault that should be updated. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Name of the resource group where the vault that should be updated is located. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_recovery_fabric_name: Name of fabric that should contain this replication. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_recovery_protection_container_name: Name of the protection container to use. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_vm_id: Id of the VM to replicate Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_availability_set_id: Id of availability set that the new VM should belong to when a failover is done.
        :param pulumi.Input[builtins.str] target_boot_diagnostic_storage_account_id: Id of the storage account which the new VM should used for boot diagnostic when a failover is done.
        :param pulumi.Input[builtins.str] target_capacity_reservation_group_id: Id of the Capacity reservation group where the new VM should belong to when a failover is done.
        :param pulumi.Input[builtins.str] target_edge_zone: Specifies the Edge Zone within the Azure Region where this Managed Kubernetes Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_network_id: Network to use when a failover is done (recommended to set if any network_interface is configured for failover).
        :param pulumi.Input[builtins.str] target_proximity_placement_group_id: Id of Proximity Placement Group the new VM should belong to when a failover is done.
        :param pulumi.Input[builtins.str] target_recovery_fabric_id: Id of fabric where the VM replication should be handled when a failover is done. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_recovery_protection_container_id: Id of protection container where the VM replication should be created when a failover is done. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_resource_group_id: Id of resource group where the VM should be created when a failover is done. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_virtual_machine_scale_set_id: Id of the Virtual Machine Scale Set which the new Vm should belong to when a failover is done.
        :param pulumi.Input[builtins.str] target_virtual_machine_size: Specifies the size the Virtual Machine should have.
        :param pulumi.Input[builtins.str] target_zone: Specifies the Availability Zone where the Failover VM should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] test_network_id: Network to use when a test failover is done.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReplicatedVMUnmanagedDiskArgs', 'ReplicatedVMUnmanagedDiskArgsDict']]]] unmanaged_disks: One or more `unmanaged_disk` block as defined below. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReplicatedVMArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VM replicated using Azure Site Recovery (Azure to Azure only). A replicated VM keeps a copiously updated image of the VM in another region in order to be able to start the VM in that region in case of a disaster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        primary = azure.core.ResourceGroup("primary",
            name="tfex-replicated-vm-primary",
            location="West US")
        secondary = azure.core.ResourceGroup("secondary",
            name="tfex-replicated-vm-secondary",
            location="East US")
        primary_virtual_network = azure.network.VirtualNetwork("primary",
            name="network1",
            resource_group_name=primary.name,
            address_spaces=["192.168.1.0/24"],
            location=primary.location)
        primary_subnet = azure.network.Subnet("primary",
            name="network1-subnet",
            resource_group_name=primary.name,
            virtual_network_name=primary_virtual_network.name,
            address_prefixes=["192.168.1.0/24"])
        primary_public_ip = azure.network.PublicIp("primary",
            name="vm-public-ip-primary",
            allocation_method="Static",
            location=primary.location,
            resource_group_name=primary.name,
            sku="Basic")
        vm_network_interface = azure.network.NetworkInterface("vm",
            name="vm-nic",
            location=primary.location,
            resource_group_name=primary.name,
            ip_configurations=[{
                "name": "vm",
                "subnet_id": primary_subnet.id,
                "private_ip_address_allocation": "Dynamic",
                "public_ip_address_id": primary_public_ip.id,
            }])
        vm = azure.compute.VirtualMachine("vm",
            name="vm",
            location=primary.location,
            resource_group_name=primary.name,
            vm_size="Standard_B1s",
            network_interface_ids=[vm_network_interface.id],
            storage_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            },
            storage_os_disk={
                "name": "vm-os-disk",
                "os_type": "Linux",
                "caching": "ReadWrite",
                "create_option": "FromImage",
                "managed_disk_type": "Premium_LRS",
            },
            os_profile={
                "admin_username": "test-admin-123",
                "admin_password": "test-pwd-123",
                "computer_name": "vm",
            },
            os_profile_linux_config={
                "disable_password_authentication": False,
            })
        vault = azure.recoveryservices.Vault("vault",
            name="example-recovery-vault",
            location=secondary.location,
            resource_group_name=secondary.name,
            sku="Standard")
        primary_fabric = azure.siterecovery.Fabric("primary",
            name="primary-fabric",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            location=primary.location)
        secondary_fabric = azure.siterecovery.Fabric("secondary",
            name="secondary-fabric",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            location=secondary.location)
        primary_protection_container = azure.siterecovery.ProtectionContainer("primary",
            name="primary-protection-container",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            recovery_fabric_name=primary_fabric.name)
        secondary_protection_container = azure.siterecovery.ProtectionContainer("secondary",
            name="secondary-protection-container",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            recovery_fabric_name=secondary_fabric.name)
        policy = azure.siterecovery.ReplicationPolicy("policy",
            name="policy",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            recovery_point_retention_in_minutes=24 * 60,
            application_consistent_snapshot_frequency_in_minutes=4 * 60)
        container_mapping = azure.siterecovery.ProtectionContainerMapping("container-mapping",
            name="container-mapping",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            recovery_fabric_name=primary_fabric.name,
            recovery_source_protection_container_name=primary_protection_container.name,
            recovery_target_protection_container_id=secondary_protection_container.id,
            recovery_replication_policy_id=policy.id)
        secondary_virtual_network = azure.network.VirtualNetwork("secondary",
            name="network2",
            resource_group_name=secondary.name,
            address_spaces=["192.168.2.0/24"],
            location=secondary.location)
        network_mapping = azure.siterecovery.NetworkMapping("network-mapping",
            name="network-mapping",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            source_recovery_fabric_name=primary_fabric.name,
            target_recovery_fabric_name=secondary_fabric.name,
            source_network_id=primary_virtual_network.id,
            target_network_id=secondary_virtual_network.id)
        primary_account = azure.storage.Account("primary",
            name="primaryrecoverycache",
            location=primary.location,
            resource_group_name=primary.name,
            account_tier="Standard",
            account_replication_type="LRS")
        secondary_subnet = azure.network.Subnet("secondary",
            name="network2-subnet",
            resource_group_name=secondary.name,
            virtual_network_name=secondary_virtual_network.name,
            address_prefixes=["192.168.2.0/24"])
        secondary_public_ip = azure.network.PublicIp("secondary",
            name="vm-public-ip-secondary",
            allocation_method="Static",
            location=secondary.location,
            resource_group_name=secondary.name,
            sku="Basic")
        vm_replication = azure.siterecovery.ReplicatedVM("vm-replication",
            name="vm-replication",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            source_recovery_fabric_name=primary_fabric.name,
            source_vm_id=vm.id,
            recovery_replication_policy_id=policy.id,
            source_recovery_protection_container_name=primary_protection_container.name,
            target_resource_group_id=secondary.id,
            target_recovery_fabric_id=secondary_fabric.id,
            target_recovery_protection_container_id=secondary_protection_container.id,
            managed_disks=[{
                "disk_id": vm.storage_os_disk.managed_disk_id,
                "staging_storage_account_id": primary_account.id,
                "target_resource_group_id": secondary.id,
                "target_disk_type": "Premium_LRS",
                "target_replica_disk_type": "Premium_LRS",
            }],
            network_interfaces=[{
                "source_network_interface_id": vm_network_interface.id,
                "target_subnet_name": secondary_subnet.name,
                "recovery_public_ip_address_id": secondary_public_ip.id,
            }],
            opts = pulumi.ResourceOptions(depends_on=[
                    container_mapping,
                    network_mapping,
                ]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.RecoveryServices`: 2024-04-01

        ## Import

        Site Recovery Replicated VM's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:siterecovery/replicatedVM:ReplicatedVM vmreplication /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resource-group-name/providers/Microsoft.RecoveryServices/vaults/recovery-vault-name/replicationFabrics/fabric-name/replicationProtectionContainers/protection-container-name/replicationProtectedItems/vm-replication-name
        ```

        :param str resource_name: The name of the resource.
        :param ReplicatedVMArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReplicatedVMArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 managed_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicatedVMManagedDiskArgs', 'ReplicatedVMManagedDiskArgsDict']]]]] = None,
                 multi_vm_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicatedVMNetworkInterfaceArgs', 'ReplicatedVMNetworkInterfaceArgsDict']]]]] = None,
                 recovery_replication_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 recovery_vault_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 source_recovery_fabric_name: Optional[pulumi.Input[builtins.str]] = None,
                 source_recovery_protection_container_name: Optional[pulumi.Input[builtins.str]] = None,
                 source_vm_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_availability_set_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_boot_diagnostic_storage_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_capacity_reservation_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_edge_zone: Optional[pulumi.Input[builtins.str]] = None,
                 target_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_proximity_placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_recovery_fabric_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_recovery_protection_container_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_resource_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_virtual_machine_scale_set_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_virtual_machine_size: Optional[pulumi.Input[builtins.str]] = None,
                 target_zone: Optional[pulumi.Input[builtins.str]] = None,
                 test_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 unmanaged_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicatedVMUnmanagedDiskArgs', 'ReplicatedVMUnmanagedDiskArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReplicatedVMArgs.__new__(ReplicatedVMArgs)

            __props__.__dict__["managed_disks"] = managed_disks
            __props__.__dict__["multi_vm_group_name"] = multi_vm_group_name
            __props__.__dict__["name"] = name
            __props__.__dict__["network_interfaces"] = network_interfaces
            if recovery_replication_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'recovery_replication_policy_id'")
            __props__.__dict__["recovery_replication_policy_id"] = recovery_replication_policy_id
            if recovery_vault_name is None and not opts.urn:
                raise TypeError("Missing required property 'recovery_vault_name'")
            __props__.__dict__["recovery_vault_name"] = recovery_vault_name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if source_recovery_fabric_name is None and not opts.urn:
                raise TypeError("Missing required property 'source_recovery_fabric_name'")
            __props__.__dict__["source_recovery_fabric_name"] = source_recovery_fabric_name
            if source_recovery_protection_container_name is None and not opts.urn:
                raise TypeError("Missing required property 'source_recovery_protection_container_name'")
            __props__.__dict__["source_recovery_protection_container_name"] = source_recovery_protection_container_name
            if source_vm_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_vm_id'")
            __props__.__dict__["source_vm_id"] = source_vm_id
            __props__.__dict__["target_availability_set_id"] = target_availability_set_id
            __props__.__dict__["target_boot_diagnostic_storage_account_id"] = target_boot_diagnostic_storage_account_id
            __props__.__dict__["target_capacity_reservation_group_id"] = target_capacity_reservation_group_id
            __props__.__dict__["target_edge_zone"] = target_edge_zone
            __props__.__dict__["target_network_id"] = target_network_id
            __props__.__dict__["target_proximity_placement_group_id"] = target_proximity_placement_group_id
            if target_recovery_fabric_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_recovery_fabric_id'")
            __props__.__dict__["target_recovery_fabric_id"] = target_recovery_fabric_id
            if target_recovery_protection_container_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_recovery_protection_container_id'")
            __props__.__dict__["target_recovery_protection_container_id"] = target_recovery_protection_container_id
            if target_resource_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_resource_group_id'")
            __props__.__dict__["target_resource_group_id"] = target_resource_group_id
            __props__.__dict__["target_virtual_machine_scale_set_id"] = target_virtual_machine_scale_set_id
            __props__.__dict__["target_virtual_machine_size"] = target_virtual_machine_size
            __props__.__dict__["target_zone"] = target_zone
            __props__.__dict__["test_network_id"] = test_network_id
            __props__.__dict__["unmanaged_disks"] = unmanaged_disks
        super(ReplicatedVM, __self__).__init__(
            'azure:siterecovery/replicatedVM:ReplicatedVM',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            managed_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicatedVMManagedDiskArgs', 'ReplicatedVMManagedDiskArgsDict']]]]] = None,
            multi_vm_group_name: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicatedVMNetworkInterfaceArgs', 'ReplicatedVMNetworkInterfaceArgsDict']]]]] = None,
            recovery_replication_policy_id: Optional[pulumi.Input[builtins.str]] = None,
            recovery_vault_name: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            source_recovery_fabric_name: Optional[pulumi.Input[builtins.str]] = None,
            source_recovery_protection_container_name: Optional[pulumi.Input[builtins.str]] = None,
            source_vm_id: Optional[pulumi.Input[builtins.str]] = None,
            target_availability_set_id: Optional[pulumi.Input[builtins.str]] = None,
            target_boot_diagnostic_storage_account_id: Optional[pulumi.Input[builtins.str]] = None,
            target_capacity_reservation_group_id: Optional[pulumi.Input[builtins.str]] = None,
            target_edge_zone: Optional[pulumi.Input[builtins.str]] = None,
            target_network_id: Optional[pulumi.Input[builtins.str]] = None,
            target_proximity_placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
            target_recovery_fabric_id: Optional[pulumi.Input[builtins.str]] = None,
            target_recovery_protection_container_id: Optional[pulumi.Input[builtins.str]] = None,
            target_resource_group_id: Optional[pulumi.Input[builtins.str]] = None,
            target_virtual_machine_scale_set_id: Optional[pulumi.Input[builtins.str]] = None,
            target_virtual_machine_size: Optional[pulumi.Input[builtins.str]] = None,
            target_zone: Optional[pulumi.Input[builtins.str]] = None,
            test_network_id: Optional[pulumi.Input[builtins.str]] = None,
            unmanaged_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicatedVMUnmanagedDiskArgs', 'ReplicatedVMUnmanagedDiskArgsDict']]]]] = None) -> 'ReplicatedVM':
        """
        Get an existing ReplicatedVM resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReplicatedVMManagedDiskArgs', 'ReplicatedVMManagedDiskArgsDict']]]] managed_disks: One or more `managed_disk` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] multi_vm_group_name: Name of group in which all machines will replicate together and have shared crash consistent and app-consistent recovery points when failed over.
        :param pulumi.Input[builtins.str] name: The name of the replication for the replicated VM. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReplicatedVMNetworkInterfaceArgs', 'ReplicatedVMNetworkInterfaceArgsDict']]]] network_interfaces: One or more `network_interface` block as defined below.
        :param pulumi.Input[builtins.str] recovery_replication_policy_id: Id of the policy to use for this replicated vm. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] recovery_vault_name: The name of the vault that should be updated. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Name of the resource group where the vault that should be updated is located. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_recovery_fabric_name: Name of fabric that should contain this replication. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_recovery_protection_container_name: Name of the protection container to use. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_vm_id: Id of the VM to replicate Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_availability_set_id: Id of availability set that the new VM should belong to when a failover is done.
        :param pulumi.Input[builtins.str] target_boot_diagnostic_storage_account_id: Id of the storage account which the new VM should used for boot diagnostic when a failover is done.
        :param pulumi.Input[builtins.str] target_capacity_reservation_group_id: Id of the Capacity reservation group where the new VM should belong to when a failover is done.
        :param pulumi.Input[builtins.str] target_edge_zone: Specifies the Edge Zone within the Azure Region where this Managed Kubernetes Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_network_id: Network to use when a failover is done (recommended to set if any network_interface is configured for failover).
        :param pulumi.Input[builtins.str] target_proximity_placement_group_id: Id of Proximity Placement Group the new VM should belong to when a failover is done.
        :param pulumi.Input[builtins.str] target_recovery_fabric_id: Id of fabric where the VM replication should be handled when a failover is done. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_recovery_protection_container_id: Id of protection container where the VM replication should be created when a failover is done. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_resource_group_id: Id of resource group where the VM should be created when a failover is done. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_virtual_machine_scale_set_id: Id of the Virtual Machine Scale Set which the new Vm should belong to when a failover is done.
        :param pulumi.Input[builtins.str] target_virtual_machine_size: Specifies the size the Virtual Machine should have.
        :param pulumi.Input[builtins.str] target_zone: Specifies the Availability Zone where the Failover VM should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] test_network_id: Network to use when a test failover is done.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReplicatedVMUnmanagedDiskArgs', 'ReplicatedVMUnmanagedDiskArgsDict']]]] unmanaged_disks: One or more `unmanaged_disk` block as defined below. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReplicatedVMState.__new__(_ReplicatedVMState)

        __props__.__dict__["managed_disks"] = managed_disks
        __props__.__dict__["multi_vm_group_name"] = multi_vm_group_name
        __props__.__dict__["name"] = name
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["recovery_replication_policy_id"] = recovery_replication_policy_id
        __props__.__dict__["recovery_vault_name"] = recovery_vault_name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["source_recovery_fabric_name"] = source_recovery_fabric_name
        __props__.__dict__["source_recovery_protection_container_name"] = source_recovery_protection_container_name
        __props__.__dict__["source_vm_id"] = source_vm_id
        __props__.__dict__["target_availability_set_id"] = target_availability_set_id
        __props__.__dict__["target_boot_diagnostic_storage_account_id"] = target_boot_diagnostic_storage_account_id
        __props__.__dict__["target_capacity_reservation_group_id"] = target_capacity_reservation_group_id
        __props__.__dict__["target_edge_zone"] = target_edge_zone
        __props__.__dict__["target_network_id"] = target_network_id
        __props__.__dict__["target_proximity_placement_group_id"] = target_proximity_placement_group_id
        __props__.__dict__["target_recovery_fabric_id"] = target_recovery_fabric_id
        __props__.__dict__["target_recovery_protection_container_id"] = target_recovery_protection_container_id
        __props__.__dict__["target_resource_group_id"] = target_resource_group_id
        __props__.__dict__["target_virtual_machine_scale_set_id"] = target_virtual_machine_scale_set_id
        __props__.__dict__["target_virtual_machine_size"] = target_virtual_machine_size
        __props__.__dict__["target_zone"] = target_zone
        __props__.__dict__["test_network_id"] = test_network_id
        __props__.__dict__["unmanaged_disks"] = unmanaged_disks
        return ReplicatedVM(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="managedDisks")
    def managed_disks(self) -> pulumi.Output[Sequence['outputs.ReplicatedVMManagedDisk']]:
        """
        One or more `managed_disk` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_disks")

    @property
    @pulumi.getter(name="multiVmGroupName")
    def multi_vm_group_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Name of group in which all machines will replicate together and have shared crash consistent and app-consistent recovery points when failed over.
        """
        return pulumi.get(self, "multi_vm_group_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the replication for the replicated VM. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Sequence['outputs.ReplicatedVMNetworkInterface']]:
        """
        One or more `network_interface` block as defined below.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="recoveryReplicationPolicyId")
    def recovery_replication_policy_id(self) -> pulumi.Output[builtins.str]:
        """
        Id of the policy to use for this replicated vm. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_replication_policy_id")

    @property
    @pulumi.getter(name="recoveryVaultName")
    def recovery_vault_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the vault that should be updated. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_vault_name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the resource group where the vault that should be updated is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="sourceRecoveryFabricName")
    def source_recovery_fabric_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of fabric that should contain this replication. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_recovery_fabric_name")

    @property
    @pulumi.getter(name="sourceRecoveryProtectionContainerName")
    def source_recovery_protection_container_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the protection container to use. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_recovery_protection_container_name")

    @property
    @pulumi.getter(name="sourceVmId")
    def source_vm_id(self) -> pulumi.Output[builtins.str]:
        """
        Id of the VM to replicate Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_vm_id")

    @property
    @pulumi.getter(name="targetAvailabilitySetId")
    def target_availability_set_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Id of availability set that the new VM should belong to when a failover is done.
        """
        return pulumi.get(self, "target_availability_set_id")

    @property
    @pulumi.getter(name="targetBootDiagnosticStorageAccountId")
    def target_boot_diagnostic_storage_account_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Id of the storage account which the new VM should used for boot diagnostic when a failover is done.
        """
        return pulumi.get(self, "target_boot_diagnostic_storage_account_id")

    @property
    @pulumi.getter(name="targetCapacityReservationGroupId")
    def target_capacity_reservation_group_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Id of the Capacity reservation group where the new VM should belong to when a failover is done.
        """
        return pulumi.get(self, "target_capacity_reservation_group_id")

    @property
    @pulumi.getter(name="targetEdgeZone")
    def target_edge_zone(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the Edge Zone within the Azure Region where this Managed Kubernetes Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_edge_zone")

    @property
    @pulumi.getter(name="targetNetworkId")
    def target_network_id(self) -> pulumi.Output[builtins.str]:
        """
        Network to use when a failover is done (recommended to set if any network_interface is configured for failover).
        """
        return pulumi.get(self, "target_network_id")

    @property
    @pulumi.getter(name="targetProximityPlacementGroupId")
    def target_proximity_placement_group_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Id of Proximity Placement Group the new VM should belong to when a failover is done.
        """
        return pulumi.get(self, "target_proximity_placement_group_id")

    @property
    @pulumi.getter(name="targetRecoveryFabricId")
    def target_recovery_fabric_id(self) -> pulumi.Output[builtins.str]:
        """
        Id of fabric where the VM replication should be handled when a failover is done. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_recovery_fabric_id")

    @property
    @pulumi.getter(name="targetRecoveryProtectionContainerId")
    def target_recovery_protection_container_id(self) -> pulumi.Output[builtins.str]:
        """
        Id of protection container where the VM replication should be created when a failover is done. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_recovery_protection_container_id")

    @property
    @pulumi.getter(name="targetResourceGroupId")
    def target_resource_group_id(self) -> pulumi.Output[builtins.str]:
        """
        Id of resource group where the VM should be created when a failover is done. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_resource_group_id")

    @property
    @pulumi.getter(name="targetVirtualMachineScaleSetId")
    def target_virtual_machine_scale_set_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Id of the Virtual Machine Scale Set which the new Vm should belong to when a failover is done.
        """
        return pulumi.get(self, "target_virtual_machine_scale_set_id")

    @property
    @pulumi.getter(name="targetVirtualMachineSize")
    def target_virtual_machine_size(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the size the Virtual Machine should have.
        """
        return pulumi.get(self, "target_virtual_machine_size")

    @property
    @pulumi.getter(name="targetZone")
    def target_zone(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the Availability Zone where the Failover VM should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_zone")

    @property
    @pulumi.getter(name="testNetworkId")
    def test_network_id(self) -> pulumi.Output[builtins.str]:
        """
        Network to use when a test failover is done.
        """
        return pulumi.get(self, "test_network_id")

    @property
    @pulumi.getter(name="unmanagedDisks")
    def unmanaged_disks(self) -> pulumi.Output[Sequence['outputs.ReplicatedVMUnmanagedDisk']]:
        """
        One or more `unmanaged_disk` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "unmanaged_disks")

