# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReplicationRecoveryPlanArgs', 'ReplicationRecoveryPlan']

@pulumi.input_type
class ReplicationRecoveryPlanArgs:
    def __init__(__self__, *,
                 boot_recovery_groups: pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanBootRecoveryGroupArgs']]],
                 failover_recovery_group: pulumi.Input['ReplicationRecoveryPlanFailoverRecoveryGroupArgs'],
                 recovery_vault_id: pulumi.Input[builtins.str],
                 shutdown_recovery_group: pulumi.Input['ReplicationRecoveryPlanShutdownRecoveryGroupArgs'],
                 source_recovery_fabric_id: pulumi.Input[builtins.str],
                 target_recovery_fabric_id: pulumi.Input[builtins.str],
                 azure_to_azure_settings: Optional[pulumi.Input['ReplicationRecoveryPlanAzureToAzureSettingsArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ReplicationRecoveryPlan resource.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanBootRecoveryGroupArgs']]] boot_recovery_groups: One or more `boot_recovery_group` blocks as defined below.
        :param pulumi.Input['ReplicationRecoveryPlanFailoverRecoveryGroupArgs'] failover_recovery_group: One `failover_recovery_group` block as defined below.
        :param pulumi.Input[builtins.str] recovery_vault_id: The ID of the vault that should be updated. Changing this forces a new resource to be created.
        :param pulumi.Input['ReplicationRecoveryPlanShutdownRecoveryGroupArgs'] shutdown_recovery_group: One `shutdown_recovery_group` block as defined below.
        :param pulumi.Input[builtins.str] source_recovery_fabric_id: ID of source fabric to be recovered from. Changing this forces a new Replication Plan to be created.
        :param pulumi.Input[builtins.str] target_recovery_fabric_id: ID of target fabric to recover. Changing this forces a new Replication Plan to be created.
        :param pulumi.Input['ReplicationRecoveryPlanAzureToAzureSettingsArgs'] azure_to_azure_settings: An `azure_to_azure_settings` block as defined below.
        :param pulumi.Input[builtins.str] name: The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "boot_recovery_groups", boot_recovery_groups)
        pulumi.set(__self__, "failover_recovery_group", failover_recovery_group)
        pulumi.set(__self__, "recovery_vault_id", recovery_vault_id)
        pulumi.set(__self__, "shutdown_recovery_group", shutdown_recovery_group)
        pulumi.set(__self__, "source_recovery_fabric_id", source_recovery_fabric_id)
        pulumi.set(__self__, "target_recovery_fabric_id", target_recovery_fabric_id)
        if azure_to_azure_settings is not None:
            pulumi.set(__self__, "azure_to_azure_settings", azure_to_azure_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="bootRecoveryGroups")
    def boot_recovery_groups(self) -> pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanBootRecoveryGroupArgs']]]:
        """
        One or more `boot_recovery_group` blocks as defined below.
        """
        return pulumi.get(self, "boot_recovery_groups")

    @boot_recovery_groups.setter
    def boot_recovery_groups(self, value: pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanBootRecoveryGroupArgs']]]):
        pulumi.set(self, "boot_recovery_groups", value)

    @property
    @pulumi.getter(name="failoverRecoveryGroup")
    def failover_recovery_group(self) -> pulumi.Input['ReplicationRecoveryPlanFailoverRecoveryGroupArgs']:
        """
        One `failover_recovery_group` block as defined below.
        """
        return pulumi.get(self, "failover_recovery_group")

    @failover_recovery_group.setter
    def failover_recovery_group(self, value: pulumi.Input['ReplicationRecoveryPlanFailoverRecoveryGroupArgs']):
        pulumi.set(self, "failover_recovery_group", value)

    @property
    @pulumi.getter(name="recoveryVaultId")
    def recovery_vault_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the vault that should be updated. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_vault_id")

    @recovery_vault_id.setter
    def recovery_vault_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "recovery_vault_id", value)

    @property
    @pulumi.getter(name="shutdownRecoveryGroup")
    def shutdown_recovery_group(self) -> pulumi.Input['ReplicationRecoveryPlanShutdownRecoveryGroupArgs']:
        """
        One `shutdown_recovery_group` block as defined below.
        """
        return pulumi.get(self, "shutdown_recovery_group")

    @shutdown_recovery_group.setter
    def shutdown_recovery_group(self, value: pulumi.Input['ReplicationRecoveryPlanShutdownRecoveryGroupArgs']):
        pulumi.set(self, "shutdown_recovery_group", value)

    @property
    @pulumi.getter(name="sourceRecoveryFabricId")
    def source_recovery_fabric_id(self) -> pulumi.Input[builtins.str]:
        """
        ID of source fabric to be recovered from. Changing this forces a new Replication Plan to be created.
        """
        return pulumi.get(self, "source_recovery_fabric_id")

    @source_recovery_fabric_id.setter
    def source_recovery_fabric_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_recovery_fabric_id", value)

    @property
    @pulumi.getter(name="targetRecoveryFabricId")
    def target_recovery_fabric_id(self) -> pulumi.Input[builtins.str]:
        """
        ID of target fabric to recover. Changing this forces a new Replication Plan to be created.
        """
        return pulumi.get(self, "target_recovery_fabric_id")

    @target_recovery_fabric_id.setter
    def target_recovery_fabric_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_recovery_fabric_id", value)

    @property
    @pulumi.getter(name="azureToAzureSettings")
    def azure_to_azure_settings(self) -> Optional[pulumi.Input['ReplicationRecoveryPlanAzureToAzureSettingsArgs']]:
        """
        An `azure_to_azure_settings` block as defined below.
        """
        return pulumi.get(self, "azure_to_azure_settings")

    @azure_to_azure_settings.setter
    def azure_to_azure_settings(self, value: Optional[pulumi.Input['ReplicationRecoveryPlanAzureToAzureSettingsArgs']]):
        pulumi.set(self, "azure_to_azure_settings", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ReplicationRecoveryPlanState:
    def __init__(__self__, *,
                 azure_to_azure_settings: Optional[pulumi.Input['ReplicationRecoveryPlanAzureToAzureSettingsArgs']] = None,
                 boot_recovery_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanBootRecoveryGroupArgs']]]] = None,
                 failover_recovery_group: Optional[pulumi.Input['ReplicationRecoveryPlanFailoverRecoveryGroupArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 recovery_vault_id: Optional[pulumi.Input[builtins.str]] = None,
                 shutdown_recovery_group: Optional[pulumi.Input['ReplicationRecoveryPlanShutdownRecoveryGroupArgs']] = None,
                 source_recovery_fabric_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_recovery_fabric_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ReplicationRecoveryPlan resources.
        :param pulumi.Input['ReplicationRecoveryPlanAzureToAzureSettingsArgs'] azure_to_azure_settings: An `azure_to_azure_settings` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanBootRecoveryGroupArgs']]] boot_recovery_groups: One or more `boot_recovery_group` blocks as defined below.
        :param pulumi.Input['ReplicationRecoveryPlanFailoverRecoveryGroupArgs'] failover_recovery_group: One `failover_recovery_group` block as defined below.
        :param pulumi.Input[builtins.str] name: The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] recovery_vault_id: The ID of the vault that should be updated. Changing this forces a new resource to be created.
        :param pulumi.Input['ReplicationRecoveryPlanShutdownRecoveryGroupArgs'] shutdown_recovery_group: One `shutdown_recovery_group` block as defined below.
        :param pulumi.Input[builtins.str] source_recovery_fabric_id: ID of source fabric to be recovered from. Changing this forces a new Replication Plan to be created.
        :param pulumi.Input[builtins.str] target_recovery_fabric_id: ID of target fabric to recover. Changing this forces a new Replication Plan to be created.
        """
        if azure_to_azure_settings is not None:
            pulumi.set(__self__, "azure_to_azure_settings", azure_to_azure_settings)
        if boot_recovery_groups is not None:
            pulumi.set(__self__, "boot_recovery_groups", boot_recovery_groups)
        if failover_recovery_group is not None:
            pulumi.set(__self__, "failover_recovery_group", failover_recovery_group)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if recovery_vault_id is not None:
            pulumi.set(__self__, "recovery_vault_id", recovery_vault_id)
        if shutdown_recovery_group is not None:
            pulumi.set(__self__, "shutdown_recovery_group", shutdown_recovery_group)
        if source_recovery_fabric_id is not None:
            pulumi.set(__self__, "source_recovery_fabric_id", source_recovery_fabric_id)
        if target_recovery_fabric_id is not None:
            pulumi.set(__self__, "target_recovery_fabric_id", target_recovery_fabric_id)

    @property
    @pulumi.getter(name="azureToAzureSettings")
    def azure_to_azure_settings(self) -> Optional[pulumi.Input['ReplicationRecoveryPlanAzureToAzureSettingsArgs']]:
        """
        An `azure_to_azure_settings` block as defined below.
        """
        return pulumi.get(self, "azure_to_azure_settings")

    @azure_to_azure_settings.setter
    def azure_to_azure_settings(self, value: Optional[pulumi.Input['ReplicationRecoveryPlanAzureToAzureSettingsArgs']]):
        pulumi.set(self, "azure_to_azure_settings", value)

    @property
    @pulumi.getter(name="bootRecoveryGroups")
    def boot_recovery_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanBootRecoveryGroupArgs']]]]:
        """
        One or more `boot_recovery_group` blocks as defined below.
        """
        return pulumi.get(self, "boot_recovery_groups")

    @boot_recovery_groups.setter
    def boot_recovery_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanBootRecoveryGroupArgs']]]]):
        pulumi.set(self, "boot_recovery_groups", value)

    @property
    @pulumi.getter(name="failoverRecoveryGroup")
    def failover_recovery_group(self) -> Optional[pulumi.Input['ReplicationRecoveryPlanFailoverRecoveryGroupArgs']]:
        """
        One `failover_recovery_group` block as defined below.
        """
        return pulumi.get(self, "failover_recovery_group")

    @failover_recovery_group.setter
    def failover_recovery_group(self, value: Optional[pulumi.Input['ReplicationRecoveryPlanFailoverRecoveryGroupArgs']]):
        pulumi.set(self, "failover_recovery_group", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="recoveryVaultId")
    def recovery_vault_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the vault that should be updated. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_vault_id")

    @recovery_vault_id.setter
    def recovery_vault_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "recovery_vault_id", value)

    @property
    @pulumi.getter(name="shutdownRecoveryGroup")
    def shutdown_recovery_group(self) -> Optional[pulumi.Input['ReplicationRecoveryPlanShutdownRecoveryGroupArgs']]:
        """
        One `shutdown_recovery_group` block as defined below.
        """
        return pulumi.get(self, "shutdown_recovery_group")

    @shutdown_recovery_group.setter
    def shutdown_recovery_group(self, value: Optional[pulumi.Input['ReplicationRecoveryPlanShutdownRecoveryGroupArgs']]):
        pulumi.set(self, "shutdown_recovery_group", value)

    @property
    @pulumi.getter(name="sourceRecoveryFabricId")
    def source_recovery_fabric_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of source fabric to be recovered from. Changing this forces a new Replication Plan to be created.
        """
        return pulumi.get(self, "source_recovery_fabric_id")

    @source_recovery_fabric_id.setter
    def source_recovery_fabric_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_recovery_fabric_id", value)

    @property
    @pulumi.getter(name="targetRecoveryFabricId")
    def target_recovery_fabric_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of target fabric to recover. Changing this forces a new Replication Plan to be created.
        """
        return pulumi.get(self, "target_recovery_fabric_id")

    @target_recovery_fabric_id.setter
    def target_recovery_fabric_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_recovery_fabric_id", value)


@pulumi.type_token("azure:siterecovery/replicationRecoveryPlan:ReplicationRecoveryPlan")
class ReplicationRecoveryPlan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 azure_to_azure_settings: Optional[pulumi.Input[Union['ReplicationRecoveryPlanAzureToAzureSettingsArgs', 'ReplicationRecoveryPlanAzureToAzureSettingsArgsDict']]] = None,
                 boot_recovery_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicationRecoveryPlanBootRecoveryGroupArgs', 'ReplicationRecoveryPlanBootRecoveryGroupArgsDict']]]]] = None,
                 failover_recovery_group: Optional[pulumi.Input[Union['ReplicationRecoveryPlanFailoverRecoveryGroupArgs', 'ReplicationRecoveryPlanFailoverRecoveryGroupArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 recovery_vault_id: Optional[pulumi.Input[builtins.str]] = None,
                 shutdown_recovery_group: Optional[pulumi.Input[Union['ReplicationRecoveryPlanShutdownRecoveryGroupArgs', 'ReplicationRecoveryPlanShutdownRecoveryGroupArgsDict']]] = None,
                 source_recovery_fabric_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_recovery_fabric_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Site Recovery Replication Recovery Plan within a Recovery Services vault. A recovery plan gathers machines into recovery groups for the purpose of failover.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        primary = azure.core.ResourceGroup("primary",
            name="tfex-replicated-vm-primary",
            location="West US")
        secondary = azure.core.ResourceGroup("secondary",
            name="tfex-replicated-vm-secondary",
            location="East US")
        primary_virtual_network = azure.network.VirtualNetwork("primary",
            name="network1",
            resource_group_name=primary.name,
            address_spaces=["192.168.1.0/24"],
            location=primary.location)
        primary_subnet = azure.network.Subnet("primary",
            name="network1-subnet",
            resource_group_name=primary.name,
            virtual_network_name=primary_virtual_network.name,
            address_prefixes=["192.168.1.0/24"])
        primary_public_ip = azure.network.PublicIp("primary",
            name="vm-public-ip-primary",
            allocation_method="Static",
            location=primary.location,
            resource_group_name=primary.name,
            sku="Basic")
        vm_network_interface = azure.network.NetworkInterface("vm",
            name="vm-nic",
            location=primary.location,
            resource_group_name=primary.name,
            ip_configurations=[{
                "name": "vm",
                "subnet_id": primary_subnet.id,
                "private_ip_address_allocation": "Dynamic",
                "public_ip_address_id": primary_public_ip.id,
            }])
        vm = azure.compute.VirtualMachine("vm",
            name="vm",
            location=primary.location,
            resource_group_name=primary.name,
            vm_size="Standard_B1s",
            network_interface_ids=[vm_network_interface.id],
            storage_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            },
            storage_os_disk={
                "name": "vm-os-disk",
                "os_type": "Linux",
                "caching": "ReadWrite",
                "create_option": "FromImage",
                "managed_disk_type": "Premium_LRS",
            },
            os_profile={
                "admin_username": "test-admin-123",
                "admin_password": "test-pwd-123",
                "computer_name": "vm",
            },
            os_profile_linux_config={
                "disable_password_authentication": False,
            })
        vault = azure.recoveryservices.Vault("vault",
            name="example-recovery-vault",
            location=secondary.location,
            resource_group_name=secondary.name,
            sku="Standard")
        primary_fabric = azure.siterecovery.Fabric("primary",
            name="primary-fabric",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            location=primary.location)
        secondary_fabric = azure.siterecovery.Fabric("secondary",
            name="secondary-fabric",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            location=secondary.location)
        primary_protection_container = azure.siterecovery.ProtectionContainer("primary",
            name="primary-protection-container",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            recovery_fabric_name=primary_fabric.name)
        secondary_protection_container = azure.siterecovery.ProtectionContainer("secondary",
            name="secondary-protection-container",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            recovery_fabric_name=secondary_fabric.name)
        policy = azure.siterecovery.ReplicationPolicy("policy",
            name="policy",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            recovery_point_retention_in_minutes=24 * 60,
            application_consistent_snapshot_frequency_in_minutes=4 * 60)
        container_mapping = azure.siterecovery.ProtectionContainerMapping("container-mapping",
            name="container-mapping",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            recovery_fabric_name=primary_fabric.name,
            recovery_source_protection_container_name=primary_protection_container.name,
            recovery_target_protection_container_id=secondary_protection_container.id,
            recovery_replication_policy_id=policy.id)
        secondary_virtual_network = azure.network.VirtualNetwork("secondary",
            name="network2",
            resource_group_name=secondary.name,
            address_spaces=["192.168.2.0/24"],
            location=secondary.location)
        network_mapping = azure.siterecovery.NetworkMapping("network-mapping",
            name="network-mapping",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            source_recovery_fabric_name=primary_fabric.name,
            target_recovery_fabric_name=secondary_fabric.name,
            source_network_id=primary_virtual_network.id,
            target_network_id=secondary_virtual_network.id)
        primary_account = azure.storage.Account("primary",
            name="primaryrecoverycache",
            location=primary.location,
            resource_group_name=primary.name,
            account_tier="Standard",
            account_replication_type="LRS")
        secondary_subnet = azure.network.Subnet("secondary",
            name="network2-subnet",
            resource_group_name=secondary.name,
            virtual_network_name=secondary_virtual_network.name,
            address_prefixes=["192.168.2.0/24"])
        secondary_public_ip = azure.network.PublicIp("secondary",
            name="vm-public-ip-secondary",
            allocation_method="Static",
            location=secondary.location,
            resource_group_name=secondary.name,
            sku="Basic")
        vm_replication = azure.siterecovery.ReplicatedVM("vm-replication",
            name="vm-replication",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            source_recovery_fabric_name=primary_fabric.name,
            source_vm_id=vm.id,
            recovery_replication_policy_id=policy.id,
            source_recovery_protection_container_name=primary_protection_container.name,
            target_resource_group_id=secondary.id,
            target_recovery_fabric_id=secondary_fabric.id,
            target_recovery_protection_container_id=secondary_protection_container.id,
            managed_disks=[{
                "disk_id": vm.storage_os_disk.managed_disk_id,
                "staging_storage_account_id": primary_account.id,
                "target_resource_group_id": secondary.id,
                "target_disk_type": "Premium_LRS",
                "target_replica_disk_type": "Premium_LRS",
            }],
            network_interfaces=[{
                "source_network_interface_id": vm_network_interface.id,
                "target_subnet_name": secondary_subnet.name,
                "recovery_public_ip_address_id": secondary_public_ip.id,
            }],
            opts = pulumi.ResourceOptions(depends_on=[
                    container_mapping,
                    network_mapping,
                ]))
        example = azure.siterecovery.ReplicationRecoveryPlan("example",
            name="example-recover-plan",
            recovery_vault_id=vault.id,
            source_recovery_fabric_id=primary_fabric.id,
            target_recovery_fabric_id=secondary_fabric.id,
            shutdown_recovery_group={},
            failover_recovery_group={},
            boot_recovery_groups=[{
                "replicated_protected_items": [vm_replication.id],
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.RecoveryServices`: 2024-04-01

        ## Import

        Site Recovery Fabric can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:siterecovery/replicationRecoveryPlan:ReplicationRecoveryPlan  azurerm_site_recovery_replication_recovery_plan.example /subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/groupName/providers/Microsoft.RecoveryServices/vaults/vaultName/replicationRecoveryPlans/planName
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ReplicationRecoveryPlanAzureToAzureSettingsArgs', 'ReplicationRecoveryPlanAzureToAzureSettingsArgsDict']] azure_to_azure_settings: An `azure_to_azure_settings` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReplicationRecoveryPlanBootRecoveryGroupArgs', 'ReplicationRecoveryPlanBootRecoveryGroupArgsDict']]]] boot_recovery_groups: One or more `boot_recovery_group` blocks as defined below.
        :param pulumi.Input[Union['ReplicationRecoveryPlanFailoverRecoveryGroupArgs', 'ReplicationRecoveryPlanFailoverRecoveryGroupArgsDict']] failover_recovery_group: One `failover_recovery_group` block as defined below.
        :param pulumi.Input[builtins.str] name: The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] recovery_vault_id: The ID of the vault that should be updated. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ReplicationRecoveryPlanShutdownRecoveryGroupArgs', 'ReplicationRecoveryPlanShutdownRecoveryGroupArgsDict']] shutdown_recovery_group: One `shutdown_recovery_group` block as defined below.
        :param pulumi.Input[builtins.str] source_recovery_fabric_id: ID of source fabric to be recovered from. Changing this forces a new Replication Plan to be created.
        :param pulumi.Input[builtins.str] target_recovery_fabric_id: ID of target fabric to recover. Changing this forces a new Replication Plan to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReplicationRecoveryPlanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Site Recovery Replication Recovery Plan within a Recovery Services vault. A recovery plan gathers machines into recovery groups for the purpose of failover.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        primary = azure.core.ResourceGroup("primary",
            name="tfex-replicated-vm-primary",
            location="West US")
        secondary = azure.core.ResourceGroup("secondary",
            name="tfex-replicated-vm-secondary",
            location="East US")
        primary_virtual_network = azure.network.VirtualNetwork("primary",
            name="network1",
            resource_group_name=primary.name,
            address_spaces=["192.168.1.0/24"],
            location=primary.location)
        primary_subnet = azure.network.Subnet("primary",
            name="network1-subnet",
            resource_group_name=primary.name,
            virtual_network_name=primary_virtual_network.name,
            address_prefixes=["192.168.1.0/24"])
        primary_public_ip = azure.network.PublicIp("primary",
            name="vm-public-ip-primary",
            allocation_method="Static",
            location=primary.location,
            resource_group_name=primary.name,
            sku="Basic")
        vm_network_interface = azure.network.NetworkInterface("vm",
            name="vm-nic",
            location=primary.location,
            resource_group_name=primary.name,
            ip_configurations=[{
                "name": "vm",
                "subnet_id": primary_subnet.id,
                "private_ip_address_allocation": "Dynamic",
                "public_ip_address_id": primary_public_ip.id,
            }])
        vm = azure.compute.VirtualMachine("vm",
            name="vm",
            location=primary.location,
            resource_group_name=primary.name,
            vm_size="Standard_B1s",
            network_interface_ids=[vm_network_interface.id],
            storage_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            },
            storage_os_disk={
                "name": "vm-os-disk",
                "os_type": "Linux",
                "caching": "ReadWrite",
                "create_option": "FromImage",
                "managed_disk_type": "Premium_LRS",
            },
            os_profile={
                "admin_username": "test-admin-123",
                "admin_password": "test-pwd-123",
                "computer_name": "vm",
            },
            os_profile_linux_config={
                "disable_password_authentication": False,
            })
        vault = azure.recoveryservices.Vault("vault",
            name="example-recovery-vault",
            location=secondary.location,
            resource_group_name=secondary.name,
            sku="Standard")
        primary_fabric = azure.siterecovery.Fabric("primary",
            name="primary-fabric",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            location=primary.location)
        secondary_fabric = azure.siterecovery.Fabric("secondary",
            name="secondary-fabric",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            location=secondary.location)
        primary_protection_container = azure.siterecovery.ProtectionContainer("primary",
            name="primary-protection-container",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            recovery_fabric_name=primary_fabric.name)
        secondary_protection_container = azure.siterecovery.ProtectionContainer("secondary",
            name="secondary-protection-container",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            recovery_fabric_name=secondary_fabric.name)
        policy = azure.siterecovery.ReplicationPolicy("policy",
            name="policy",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            recovery_point_retention_in_minutes=24 * 60,
            application_consistent_snapshot_frequency_in_minutes=4 * 60)
        container_mapping = azure.siterecovery.ProtectionContainerMapping("container-mapping",
            name="container-mapping",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            recovery_fabric_name=primary_fabric.name,
            recovery_source_protection_container_name=primary_protection_container.name,
            recovery_target_protection_container_id=secondary_protection_container.id,
            recovery_replication_policy_id=policy.id)
        secondary_virtual_network = azure.network.VirtualNetwork("secondary",
            name="network2",
            resource_group_name=secondary.name,
            address_spaces=["192.168.2.0/24"],
            location=secondary.location)
        network_mapping = azure.siterecovery.NetworkMapping("network-mapping",
            name="network-mapping",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            source_recovery_fabric_name=primary_fabric.name,
            target_recovery_fabric_name=secondary_fabric.name,
            source_network_id=primary_virtual_network.id,
            target_network_id=secondary_virtual_network.id)
        primary_account = azure.storage.Account("primary",
            name="primaryrecoverycache",
            location=primary.location,
            resource_group_name=primary.name,
            account_tier="Standard",
            account_replication_type="LRS")
        secondary_subnet = azure.network.Subnet("secondary",
            name="network2-subnet",
            resource_group_name=secondary.name,
            virtual_network_name=secondary_virtual_network.name,
            address_prefixes=["192.168.2.0/24"])
        secondary_public_ip = azure.network.PublicIp("secondary",
            name="vm-public-ip-secondary",
            allocation_method="Static",
            location=secondary.location,
            resource_group_name=secondary.name,
            sku="Basic")
        vm_replication = azure.siterecovery.ReplicatedVM("vm-replication",
            name="vm-replication",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            source_recovery_fabric_name=primary_fabric.name,
            source_vm_id=vm.id,
            recovery_replication_policy_id=policy.id,
            source_recovery_protection_container_name=primary_protection_container.name,
            target_resource_group_id=secondary.id,
            target_recovery_fabric_id=secondary_fabric.id,
            target_recovery_protection_container_id=secondary_protection_container.id,
            managed_disks=[{
                "disk_id": vm.storage_os_disk.managed_disk_id,
                "staging_storage_account_id": primary_account.id,
                "target_resource_group_id": secondary.id,
                "target_disk_type": "Premium_LRS",
                "target_replica_disk_type": "Premium_LRS",
            }],
            network_interfaces=[{
                "source_network_interface_id": vm_network_interface.id,
                "target_subnet_name": secondary_subnet.name,
                "recovery_public_ip_address_id": secondary_public_ip.id,
            }],
            opts = pulumi.ResourceOptions(depends_on=[
                    container_mapping,
                    network_mapping,
                ]))
        example = azure.siterecovery.ReplicationRecoveryPlan("example",
            name="example-recover-plan",
            recovery_vault_id=vault.id,
            source_recovery_fabric_id=primary_fabric.id,
            target_recovery_fabric_id=secondary_fabric.id,
            shutdown_recovery_group={},
            failover_recovery_group={},
            boot_recovery_groups=[{
                "replicated_protected_items": [vm_replication.id],
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.RecoveryServices`: 2024-04-01

        ## Import

        Site Recovery Fabric can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:siterecovery/replicationRecoveryPlan:ReplicationRecoveryPlan  azurerm_site_recovery_replication_recovery_plan.example /subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/groupName/providers/Microsoft.RecoveryServices/vaults/vaultName/replicationRecoveryPlans/planName
        ```

        :param str resource_name: The name of the resource.
        :param ReplicationRecoveryPlanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReplicationRecoveryPlanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 azure_to_azure_settings: Optional[pulumi.Input[Union['ReplicationRecoveryPlanAzureToAzureSettingsArgs', 'ReplicationRecoveryPlanAzureToAzureSettingsArgsDict']]] = None,
                 boot_recovery_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicationRecoveryPlanBootRecoveryGroupArgs', 'ReplicationRecoveryPlanBootRecoveryGroupArgsDict']]]]] = None,
                 failover_recovery_group: Optional[pulumi.Input[Union['ReplicationRecoveryPlanFailoverRecoveryGroupArgs', 'ReplicationRecoveryPlanFailoverRecoveryGroupArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 recovery_vault_id: Optional[pulumi.Input[builtins.str]] = None,
                 shutdown_recovery_group: Optional[pulumi.Input[Union['ReplicationRecoveryPlanShutdownRecoveryGroupArgs', 'ReplicationRecoveryPlanShutdownRecoveryGroupArgsDict']]] = None,
                 source_recovery_fabric_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_recovery_fabric_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReplicationRecoveryPlanArgs.__new__(ReplicationRecoveryPlanArgs)

            __props__.__dict__["azure_to_azure_settings"] = azure_to_azure_settings
            if boot_recovery_groups is None and not opts.urn:
                raise TypeError("Missing required property 'boot_recovery_groups'")
            __props__.__dict__["boot_recovery_groups"] = boot_recovery_groups
            if failover_recovery_group is None and not opts.urn:
                raise TypeError("Missing required property 'failover_recovery_group'")
            __props__.__dict__["failover_recovery_group"] = failover_recovery_group
            __props__.__dict__["name"] = name
            if recovery_vault_id is None and not opts.urn:
                raise TypeError("Missing required property 'recovery_vault_id'")
            __props__.__dict__["recovery_vault_id"] = recovery_vault_id
            if shutdown_recovery_group is None and not opts.urn:
                raise TypeError("Missing required property 'shutdown_recovery_group'")
            __props__.__dict__["shutdown_recovery_group"] = shutdown_recovery_group
            if source_recovery_fabric_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_recovery_fabric_id'")
            __props__.__dict__["source_recovery_fabric_id"] = source_recovery_fabric_id
            if target_recovery_fabric_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_recovery_fabric_id'")
            __props__.__dict__["target_recovery_fabric_id"] = target_recovery_fabric_id
        super(ReplicationRecoveryPlan, __self__).__init__(
            'azure:siterecovery/replicationRecoveryPlan:ReplicationRecoveryPlan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            azure_to_azure_settings: Optional[pulumi.Input[Union['ReplicationRecoveryPlanAzureToAzureSettingsArgs', 'ReplicationRecoveryPlanAzureToAzureSettingsArgsDict']]] = None,
            boot_recovery_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicationRecoveryPlanBootRecoveryGroupArgs', 'ReplicationRecoveryPlanBootRecoveryGroupArgsDict']]]]] = None,
            failover_recovery_group: Optional[pulumi.Input[Union['ReplicationRecoveryPlanFailoverRecoveryGroupArgs', 'ReplicationRecoveryPlanFailoverRecoveryGroupArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            recovery_vault_id: Optional[pulumi.Input[builtins.str]] = None,
            shutdown_recovery_group: Optional[pulumi.Input[Union['ReplicationRecoveryPlanShutdownRecoveryGroupArgs', 'ReplicationRecoveryPlanShutdownRecoveryGroupArgsDict']]] = None,
            source_recovery_fabric_id: Optional[pulumi.Input[builtins.str]] = None,
            target_recovery_fabric_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ReplicationRecoveryPlan':
        """
        Get an existing ReplicationRecoveryPlan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ReplicationRecoveryPlanAzureToAzureSettingsArgs', 'ReplicationRecoveryPlanAzureToAzureSettingsArgsDict']] azure_to_azure_settings: An `azure_to_azure_settings` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReplicationRecoveryPlanBootRecoveryGroupArgs', 'ReplicationRecoveryPlanBootRecoveryGroupArgsDict']]]] boot_recovery_groups: One or more `boot_recovery_group` blocks as defined below.
        :param pulumi.Input[Union['ReplicationRecoveryPlanFailoverRecoveryGroupArgs', 'ReplicationRecoveryPlanFailoverRecoveryGroupArgsDict']] failover_recovery_group: One `failover_recovery_group` block as defined below.
        :param pulumi.Input[builtins.str] name: The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] recovery_vault_id: The ID of the vault that should be updated. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ReplicationRecoveryPlanShutdownRecoveryGroupArgs', 'ReplicationRecoveryPlanShutdownRecoveryGroupArgsDict']] shutdown_recovery_group: One `shutdown_recovery_group` block as defined below.
        :param pulumi.Input[builtins.str] source_recovery_fabric_id: ID of source fabric to be recovered from. Changing this forces a new Replication Plan to be created.
        :param pulumi.Input[builtins.str] target_recovery_fabric_id: ID of target fabric to recover. Changing this forces a new Replication Plan to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReplicationRecoveryPlanState.__new__(_ReplicationRecoveryPlanState)

        __props__.__dict__["azure_to_azure_settings"] = azure_to_azure_settings
        __props__.__dict__["boot_recovery_groups"] = boot_recovery_groups
        __props__.__dict__["failover_recovery_group"] = failover_recovery_group
        __props__.__dict__["name"] = name
        __props__.__dict__["recovery_vault_id"] = recovery_vault_id
        __props__.__dict__["shutdown_recovery_group"] = shutdown_recovery_group
        __props__.__dict__["source_recovery_fabric_id"] = source_recovery_fabric_id
        __props__.__dict__["target_recovery_fabric_id"] = target_recovery_fabric_id
        return ReplicationRecoveryPlan(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="azureToAzureSettings")
    def azure_to_azure_settings(self) -> pulumi.Output[Optional['outputs.ReplicationRecoveryPlanAzureToAzureSettings']]:
        """
        An `azure_to_azure_settings` block as defined below.
        """
        return pulumi.get(self, "azure_to_azure_settings")

    @property
    @pulumi.getter(name="bootRecoveryGroups")
    def boot_recovery_groups(self) -> pulumi.Output[Sequence['outputs.ReplicationRecoveryPlanBootRecoveryGroup']]:
        """
        One or more `boot_recovery_group` blocks as defined below.
        """
        return pulumi.get(self, "boot_recovery_groups")

    @property
    @pulumi.getter(name="failoverRecoveryGroup")
    def failover_recovery_group(self) -> pulumi.Output['outputs.ReplicationRecoveryPlanFailoverRecoveryGroup']:
        """
        One `failover_recovery_group` block as defined below.
        """
        return pulumi.get(self, "failover_recovery_group")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recoveryVaultId")
    def recovery_vault_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the vault that should be updated. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_vault_id")

    @property
    @pulumi.getter(name="shutdownRecoveryGroup")
    def shutdown_recovery_group(self) -> pulumi.Output['outputs.ReplicationRecoveryPlanShutdownRecoveryGroup']:
        """
        One `shutdown_recovery_group` block as defined below.
        """
        return pulumi.get(self, "shutdown_recovery_group")

    @property
    @pulumi.getter(name="sourceRecoveryFabricId")
    def source_recovery_fabric_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of source fabric to be recovered from. Changing this forces a new Replication Plan to be created.
        """
        return pulumi.get(self, "source_recovery_fabric_id")

    @property
    @pulumi.getter(name="targetRecoveryFabricId")
    def target_recovery_fabric_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of target fabric to recover. Changing this forces a new Replication Plan to be created.
        """
        return pulumi.get(self, "target_recovery_fabric_id")

