# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccountArgs', 'Account']

@pulumi.input_type
class AccountArgs:
    def __init__(__self__, *,
                 account_replication_type: pulumi.Input[builtins.str],
                 account_tier: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 access_tier: Optional[pulumi.Input[builtins.str]] = None,
                 account_kind: Optional[pulumi.Input[builtins.str]] = None,
                 allow_nested_items_to_be_public: Optional[pulumi.Input[builtins.bool]] = None,
                 allowed_copy_scope: Optional[pulumi.Input[builtins.str]] = None,
                 azure_files_authentication: Optional[pulumi.Input['AccountAzureFilesAuthenticationArgs']] = None,
                 blob_properties: Optional[pulumi.Input['AccountBlobPropertiesArgs']] = None,
                 cross_tenant_replication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 custom_domain: Optional[pulumi.Input['AccountCustomDomainArgs']] = None,
                 customer_managed_key: Optional[pulumi.Input['AccountCustomerManagedKeyArgs']] = None,
                 default_to_oauth_authentication: Optional[pulumi.Input[builtins.bool]] = None,
                 dns_endpoint_type: Optional[pulumi.Input[builtins.str]] = None,
                 edge_zone: Optional[pulumi.Input[builtins.str]] = None,
                 https_traffic_only_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 identity: Optional[pulumi.Input['AccountIdentityArgs']] = None,
                 immutability_policy: Optional[pulumi.Input['AccountImmutabilityPolicyArgs']] = None,
                 infrastructure_encryption_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_hns_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 large_file_share_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 local_user_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 min_tls_version: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_rules: Optional[pulumi.Input['AccountNetworkRulesArgs']] = None,
                 nfsv3_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 queue_encryption_key_type: Optional[pulumi.Input[builtins.str]] = None,
                 queue_properties: Optional[pulumi.Input['AccountQueuePropertiesArgs']] = None,
                 routing: Optional[pulumi.Input['AccountRoutingArgs']] = None,
                 sas_policy: Optional[pulumi.Input['AccountSasPolicyArgs']] = None,
                 sftp_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 share_properties: Optional[pulumi.Input['AccountSharePropertiesArgs']] = None,
                 shared_access_key_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 static_website: Optional[pulumi.Input['AccountStaticWebsiteArgs']] = None,
                 table_encryption_key_type: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Account resource.
        :param pulumi.Input[builtins.str] account_replication_type: Defines the type of replication to use for this storage account. Valid options are `LRS`, `GRS`, `RAGRS`, `ZRS`, `GZRS` and `RAGZRS`. Changing this forces a new resource to be created when types `LRS`, `GRS` and `RAGRS` are changed to `ZRS`, `GZRS` or `RAGZRS` and vice versa.
        :param pulumi.Input[builtins.str] account_tier: Defines the Tier to use for this storage account. Valid options are `Standard` and `Premium`. For `BlockBlobStorage` and `FileStorage` accounts only `Premium` is valid. Changing this forces a new resource to be created.
               
               > **Note:** Blobs with a tier of `Premium` are of account kind `StorageV2`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the storage account. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] access_tier: Defines the access tier for `BlobStorage`, `FileStorage` and `StorageV2` accounts. Valid options are `Hot`, `Cool`, `Cold` and `Premium`. Defaults to `Hot`.
        :param pulumi.Input[builtins.str] account_kind: Defines the Kind of account. Valid options are `BlobStorage`, `BlockBlobStorage`, `FileStorage`, `Storage` and `StorageV2`. Defaults to `StorageV2`.
               
               > **Note:** Changing the `account_kind` value from `Storage` to `StorageV2` will not trigger a force new on the storage account, it will only upgrade the existing storage account from `Storage` to `StorageV2` keeping the existing storage account in place.
        :param pulumi.Input[builtins.bool] allow_nested_items_to_be_public: Allow or disallow nested items within this Account to opt into being public. Defaults to `true`.
               
               > **Note:** At this time `allow_nested_items_to_be_public` is only supported in the Public Cloud, China Cloud, and US Government Cloud.
        :param pulumi.Input[builtins.str] allowed_copy_scope: Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet. Possible values are `AAD` and `PrivateLink`.
        :param pulumi.Input['AccountAzureFilesAuthenticationArgs'] azure_files_authentication: A `azure_files_authentication` block as defined below.
        :param pulumi.Input['AccountBlobPropertiesArgs'] blob_properties: A `blob_properties` block as defined below.
        :param pulumi.Input[builtins.bool] cross_tenant_replication_enabled: Should cross Tenant replication be enabled? Defaults to `false`.
        :param pulumi.Input['AccountCustomDomainArgs'] custom_domain: A `custom_domain` block as documented below.
        :param pulumi.Input['AccountCustomerManagedKeyArgs'] customer_managed_key: A `customer_managed_key` block as documented below.
               
               > **Note:** It's possible to define a Customer Managed Key both within either the `customer_managed_key` block or by using the `storage.CustomerManagedKey` resource. However, it's not possible to use both methods to manage a Customer Managed Key for a Storage Account, since these will conflict. When using the `storage.CustomerManagedKey` resource, you will need to use `ignore_changes` on the `customer_managed_key` block.
        :param pulumi.Input[builtins.bool] default_to_oauth_authentication: Default to Azure Active Directory authorization in the Azure portal when accessing the Storage Account. The default value is `false`
        :param pulumi.Input[builtins.str] dns_endpoint_type: Specifies which DNS endpoint type to use. Possible values are `Standard` and `AzureDnsZone`. Defaults to `Standard`. Changing this forces a new resource to be created.
               
               > **Note:** Azure DNS zone support requires `PartitionedDns` feature to be enabled. To enable this feature for your subscription, use the following command: `az feature register --namespace "Microsoft.Storage" --name "PartitionedDns"`.
        :param pulumi.Input[builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Storage Account should exist. Changing this forces a new Storage Account to be created.
        :param pulumi.Input[builtins.bool] https_traffic_only_enabled: Boolean flag which forces HTTPS if enabled, see [here](https://docs.microsoft.com/azure/storage/storage-require-secure-transfer/) for more information. Defaults to `true`.
        :param pulumi.Input['AccountIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input['AccountImmutabilityPolicyArgs'] immutability_policy: An `immutability_policy` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] infrastructure_encryption_enabled: Is infrastructure encryption enabled? Changing this forces a new resource to be created. Defaults to `false`.
               
               > **Note:** This can only be `true` when `account_kind` is `StorageV2` or when `account_tier` is `Premium` *and* `account_kind` is one of `BlockBlobStorage` or `FileStorage`.
        :param pulumi.Input[builtins.bool] is_hns_enabled: Is Hierarchical Namespace enabled? This can be used with Azure Data Lake Storage Gen 2 ([see here for more information](https://docs.microsoft.com/azure/storage/blobs/data-lake-storage-quickstart-create-account/)). Changing this forces a new resource to be created.
               
               > **Note:** This can only be `true` when `account_tier` is `Standard` or when `account_tier` is `Premium` *and* `account_kind` is `BlockBlobStorage`
        :param pulumi.Input[builtins.bool] large_file_share_enabled: Are Large File Shares Enabled? Defaults to `false`.
               
               > **Note:** Large File Shares are enabled by default when using an `account_kind` of `FileStorage`.
        :param pulumi.Input[builtins.bool] local_user_enabled: Is Local User Enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] min_tls_version: The minimum supported TLS version for the storage account. Possible values are `TLS1_0`, `TLS1_1`, and `TLS1_2`. Defaults to `TLS1_2` for new storage accounts.
               
               > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
               
               > **Note:** At this time `min_tls_version` is only supported in the Public Cloud, China Cloud, and US Government Cloud.
        :param pulumi.Input[builtins.str] name: Specifies the name of the storage account. Only lowercase Alphanumeric characters allowed. Changing this forces a new resource to be created. This must be unique across the entire Azure service, not just within the resource group.
        :param pulumi.Input['AccountNetworkRulesArgs'] network_rules: A `network_rules` block as documented below.
        :param pulumi.Input[builtins.bool] nfsv3_enabled: Is NFSv3 protocol enabled? Changing this forces a new resource to be created. Defaults to `false`.
               
               > **Note:** This can only be `true` when `account_tier` is `Standard` and `account_kind` is `StorageV2`, or `account_tier` is `Premium` and `account_kind` is `BlockBlobStorage`. Additionally, the `is_hns_enabled` is `true` and `account_replication_type` must be `LRS` or `RAGRS`.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Whether the public network access is enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] queue_encryption_key_type: The encryption type of the queue service. Possible values are `Service` and `Account`. Changing this forces a new resource to be created. Default value is `Service`.
        :param pulumi.Input['AccountQueuePropertiesArgs'] queue_properties: A `queue_properties` block as defined below.
               
               > **Note:** `queue_properties` can only be configured when `account_tier` is set to `Standard` and `account_kind` is set to either `Storage` or `StorageV2`.
        :param pulumi.Input['AccountRoutingArgs'] routing: A `routing` block as defined below.
        :param pulumi.Input['AccountSasPolicyArgs'] sas_policy: A `sas_policy` block as defined below.
        :param pulumi.Input[builtins.bool] sftp_enabled: Boolean, enable SFTP for the storage account
               
               > **Note:** SFTP support requires `is_hns_enabled` set to `true`. [More information on SFTP support can be found here](https://learn.microsoft.com/azure/storage/blobs/secure-file-transfer-protocol-support). Defaults to `false`
        :param pulumi.Input['AccountSharePropertiesArgs'] share_properties: A `share_properties` block as defined below.
               
               > **Note:** `share_properties` can only be configured when either `account_tier` is `Standard` and `account_kind` is either `Storage` or `StorageV2` - or when `account_tier` is `Premium` and `account_kind` is `FileStorage`.
        :param pulumi.Input['AccountStaticWebsiteArgs'] static_website: A `static_website` block as defined below.
               
               > **Note:** `static_website` can only be set when the `account_kind` is set to `StorageV2` or `BlockBlobStorage`.
               
               > **Note:** If `static_website` is specified, the service will automatically create a `storage.Container` named `$web`.
        :param pulumi.Input[builtins.str] table_encryption_key_type: The encryption type of the table service. Possible values are `Service` and `Account`. Changing this forces a new resource to be created. Default value is `Service`.
               
               > **Note:** `queue_encryption_key_type` and `table_encryption_key_type` cannot be set to `Account` when `account_kind` is set `Storage`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "account_replication_type", account_replication_type)
        pulumi.set(__self__, "account_tier", account_tier)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if access_tier is not None:
            pulumi.set(__self__, "access_tier", access_tier)
        if account_kind is not None:
            pulumi.set(__self__, "account_kind", account_kind)
        if allow_nested_items_to_be_public is not None:
            pulumi.set(__self__, "allow_nested_items_to_be_public", allow_nested_items_to_be_public)
        if allowed_copy_scope is not None:
            pulumi.set(__self__, "allowed_copy_scope", allowed_copy_scope)
        if azure_files_authentication is not None:
            pulumi.set(__self__, "azure_files_authentication", azure_files_authentication)
        if blob_properties is not None:
            pulumi.set(__self__, "blob_properties", blob_properties)
        if cross_tenant_replication_enabled is not None:
            pulumi.set(__self__, "cross_tenant_replication_enabled", cross_tenant_replication_enabled)
        if custom_domain is not None:
            pulumi.set(__self__, "custom_domain", custom_domain)
        if customer_managed_key is not None:
            pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if default_to_oauth_authentication is not None:
            pulumi.set(__self__, "default_to_oauth_authentication", default_to_oauth_authentication)
        if dns_endpoint_type is not None:
            pulumi.set(__self__, "dns_endpoint_type", dns_endpoint_type)
        if edge_zone is not None:
            pulumi.set(__self__, "edge_zone", edge_zone)
        if https_traffic_only_enabled is not None:
            pulumi.set(__self__, "https_traffic_only_enabled", https_traffic_only_enabled)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if immutability_policy is not None:
            pulumi.set(__self__, "immutability_policy", immutability_policy)
        if infrastructure_encryption_enabled is not None:
            pulumi.set(__self__, "infrastructure_encryption_enabled", infrastructure_encryption_enabled)
        if is_hns_enabled is not None:
            pulumi.set(__self__, "is_hns_enabled", is_hns_enabled)
        if large_file_share_enabled is not None:
            pulumi.set(__self__, "large_file_share_enabled", large_file_share_enabled)
        if local_user_enabled is not None:
            pulumi.set(__self__, "local_user_enabled", local_user_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if min_tls_version is not None:
            pulumi.set(__self__, "min_tls_version", min_tls_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_rules is not None:
            pulumi.set(__self__, "network_rules", network_rules)
        if nfsv3_enabled is not None:
            pulumi.set(__self__, "nfsv3_enabled", nfsv3_enabled)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if queue_encryption_key_type is not None:
            pulumi.set(__self__, "queue_encryption_key_type", queue_encryption_key_type)
        if queue_properties is not None:
            warnings.warn("""this block has been deprecated and superseded by the `storage.AccountQueueProperties` resource and will be removed in v5.0 of the AzureRM provider""", DeprecationWarning)
            pulumi.log.warn("""queue_properties is deprecated: this block has been deprecated and superseded by the `storage.AccountQueueProperties` resource and will be removed in v5.0 of the AzureRM provider""")
        if queue_properties is not None:
            pulumi.set(__self__, "queue_properties", queue_properties)
        if routing is not None:
            pulumi.set(__self__, "routing", routing)
        if sas_policy is not None:
            pulumi.set(__self__, "sas_policy", sas_policy)
        if sftp_enabled is not None:
            pulumi.set(__self__, "sftp_enabled", sftp_enabled)
        if share_properties is not None:
            pulumi.set(__self__, "share_properties", share_properties)
        if shared_access_key_enabled is not None:
            pulumi.set(__self__, "shared_access_key_enabled", shared_access_key_enabled)
        if static_website is not None:
            warnings.warn("""this block has been deprecated and superseded by the `storage.AccountStaticWebsite` resource and will be removed in v5.0 of the AzureRM provider""", DeprecationWarning)
            pulumi.log.warn("""static_website is deprecated: this block has been deprecated and superseded by the `storage.AccountStaticWebsite` resource and will be removed in v5.0 of the AzureRM provider""")
        if static_website is not None:
            pulumi.set(__self__, "static_website", static_website)
        if table_encryption_key_type is not None:
            pulumi.set(__self__, "table_encryption_key_type", table_encryption_key_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accountReplicationType")
    def account_replication_type(self) -> pulumi.Input[builtins.str]:
        """
        Defines the type of replication to use for this storage account. Valid options are `LRS`, `GRS`, `RAGRS`, `ZRS`, `GZRS` and `RAGZRS`. Changing this forces a new resource to be created when types `LRS`, `GRS` and `RAGRS` are changed to `ZRS`, `GZRS` or `RAGZRS` and vice versa.
        """
        return pulumi.get(self, "account_replication_type")

    @account_replication_type.setter
    def account_replication_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_replication_type", value)

    @property
    @pulumi.getter(name="accountTier")
    def account_tier(self) -> pulumi.Input[builtins.str]:
        """
        Defines the Tier to use for this storage account. Valid options are `Standard` and `Premium`. For `BlockBlobStorage` and `FileStorage` accounts only `Premium` is valid. Changing this forces a new resource to be created.

        > **Note:** Blobs with a tier of `Premium` are of account kind `StorageV2`.
        """
        return pulumi.get(self, "account_tier")

    @account_tier.setter
    def account_tier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_tier", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group in which to create the storage account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="accessTier")
    def access_tier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Defines the access tier for `BlobStorage`, `FileStorage` and `StorageV2` accounts. Valid options are `Hot`, `Cool`, `Cold` and `Premium`. Defaults to `Hot`.
        """
        return pulumi.get(self, "access_tier")

    @access_tier.setter
    def access_tier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_tier", value)

    @property
    @pulumi.getter(name="accountKind")
    def account_kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Defines the Kind of account. Valid options are `BlobStorage`, `BlockBlobStorage`, `FileStorage`, `Storage` and `StorageV2`. Defaults to `StorageV2`.

        > **Note:** Changing the `account_kind` value from `Storage` to `StorageV2` will not trigger a force new on the storage account, it will only upgrade the existing storage account from `Storage` to `StorageV2` keeping the existing storage account in place.
        """
        return pulumi.get(self, "account_kind")

    @account_kind.setter
    def account_kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_kind", value)

    @property
    @pulumi.getter(name="allowNestedItemsToBePublic")
    def allow_nested_items_to_be_public(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow or disallow nested items within this Account to opt into being public. Defaults to `true`.

        > **Note:** At this time `allow_nested_items_to_be_public` is only supported in the Public Cloud, China Cloud, and US Government Cloud.
        """
        return pulumi.get(self, "allow_nested_items_to_be_public")

    @allow_nested_items_to_be_public.setter
    def allow_nested_items_to_be_public(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_nested_items_to_be_public", value)

    @property
    @pulumi.getter(name="allowedCopyScope")
    def allowed_copy_scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet. Possible values are `AAD` and `PrivateLink`.
        """
        return pulumi.get(self, "allowed_copy_scope")

    @allowed_copy_scope.setter
    def allowed_copy_scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "allowed_copy_scope", value)

    @property
    @pulumi.getter(name="azureFilesAuthentication")
    def azure_files_authentication(self) -> Optional[pulumi.Input['AccountAzureFilesAuthenticationArgs']]:
        """
        A `azure_files_authentication` block as defined below.
        """
        return pulumi.get(self, "azure_files_authentication")

    @azure_files_authentication.setter
    def azure_files_authentication(self, value: Optional[pulumi.Input['AccountAzureFilesAuthenticationArgs']]):
        pulumi.set(self, "azure_files_authentication", value)

    @property
    @pulumi.getter(name="blobProperties")
    def blob_properties(self) -> Optional[pulumi.Input['AccountBlobPropertiesArgs']]:
        """
        A `blob_properties` block as defined below.
        """
        return pulumi.get(self, "blob_properties")

    @blob_properties.setter
    def blob_properties(self, value: Optional[pulumi.Input['AccountBlobPropertiesArgs']]):
        pulumi.set(self, "blob_properties", value)

    @property
    @pulumi.getter(name="crossTenantReplicationEnabled")
    def cross_tenant_replication_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should cross Tenant replication be enabled? Defaults to `false`.
        """
        return pulumi.get(self, "cross_tenant_replication_enabled")

    @cross_tenant_replication_enabled.setter
    def cross_tenant_replication_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "cross_tenant_replication_enabled", value)

    @property
    @pulumi.getter(name="customDomain")
    def custom_domain(self) -> Optional[pulumi.Input['AccountCustomDomainArgs']]:
        """
        A `custom_domain` block as documented below.
        """
        return pulumi.get(self, "custom_domain")

    @custom_domain.setter
    def custom_domain(self, value: Optional[pulumi.Input['AccountCustomDomainArgs']]):
        pulumi.set(self, "custom_domain", value)

    @property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> Optional[pulumi.Input['AccountCustomerManagedKeyArgs']]:
        """
        A `customer_managed_key` block as documented below.

        > **Note:** It's possible to define a Customer Managed Key both within either the `customer_managed_key` block or by using the `storage.CustomerManagedKey` resource. However, it's not possible to use both methods to manage a Customer Managed Key for a Storage Account, since these will conflict. When using the `storage.CustomerManagedKey` resource, you will need to use `ignore_changes` on the `customer_managed_key` block.
        """
        return pulumi.get(self, "customer_managed_key")

    @customer_managed_key.setter
    def customer_managed_key(self, value: Optional[pulumi.Input['AccountCustomerManagedKeyArgs']]):
        pulumi.set(self, "customer_managed_key", value)

    @property
    @pulumi.getter(name="defaultToOauthAuthentication")
    def default_to_oauth_authentication(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Default to Azure Active Directory authorization in the Azure portal when accessing the Storage Account. The default value is `false`
        """
        return pulumi.get(self, "default_to_oauth_authentication")

    @default_to_oauth_authentication.setter
    def default_to_oauth_authentication(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "default_to_oauth_authentication", value)

    @property
    @pulumi.getter(name="dnsEndpointType")
    def dns_endpoint_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies which DNS endpoint type to use. Possible values are `Standard` and `AzureDnsZone`. Defaults to `Standard`. Changing this forces a new resource to be created.

        > **Note:** Azure DNS zone support requires `PartitionedDns` feature to be enabled. To enable this feature for your subscription, use the following command: `az feature register --namespace "Microsoft.Storage" --name "PartitionedDns"`.
        """
        return pulumi.get(self, "dns_endpoint_type")

    @dns_endpoint_type.setter
    def dns_endpoint_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dns_endpoint_type", value)

    @property
    @pulumi.getter(name="edgeZone")
    def edge_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Edge Zone within the Azure Region where this Storage Account should exist. Changing this forces a new Storage Account to be created.
        """
        return pulumi.get(self, "edge_zone")

    @edge_zone.setter
    def edge_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "edge_zone", value)

    @property
    @pulumi.getter(name="httpsTrafficOnlyEnabled")
    def https_traffic_only_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean flag which forces HTTPS if enabled, see [here](https://docs.microsoft.com/azure/storage/storage-require-secure-transfer/) for more information. Defaults to `true`.
        """
        return pulumi.get(self, "https_traffic_only_enabled")

    @https_traffic_only_enabled.setter
    def https_traffic_only_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "https_traffic_only_enabled", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['AccountIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['AccountIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="immutabilityPolicy")
    def immutability_policy(self) -> Optional[pulumi.Input['AccountImmutabilityPolicyArgs']]:
        """
        An `immutability_policy` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "immutability_policy")

    @immutability_policy.setter
    def immutability_policy(self, value: Optional[pulumi.Input['AccountImmutabilityPolicyArgs']]):
        pulumi.set(self, "immutability_policy", value)

    @property
    @pulumi.getter(name="infrastructureEncryptionEnabled")
    def infrastructure_encryption_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is infrastructure encryption enabled? Changing this forces a new resource to be created. Defaults to `false`.

        > **Note:** This can only be `true` when `account_kind` is `StorageV2` or when `account_tier` is `Premium` *and* `account_kind` is one of `BlockBlobStorage` or `FileStorage`.
        """
        return pulumi.get(self, "infrastructure_encryption_enabled")

    @infrastructure_encryption_enabled.setter
    def infrastructure_encryption_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "infrastructure_encryption_enabled", value)

    @property
    @pulumi.getter(name="isHnsEnabled")
    def is_hns_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is Hierarchical Namespace enabled? This can be used with Azure Data Lake Storage Gen 2 ([see here for more information](https://docs.microsoft.com/azure/storage/blobs/data-lake-storage-quickstart-create-account/)). Changing this forces a new resource to be created.

        > **Note:** This can only be `true` when `account_tier` is `Standard` or when `account_tier` is `Premium` *and* `account_kind` is `BlockBlobStorage`
        """
        return pulumi.get(self, "is_hns_enabled")

    @is_hns_enabled.setter
    def is_hns_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_hns_enabled", value)

    @property
    @pulumi.getter(name="largeFileShareEnabled")
    def large_file_share_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Are Large File Shares Enabled? Defaults to `false`.

        > **Note:** Large File Shares are enabled by default when using an `account_kind` of `FileStorage`.
        """
        return pulumi.get(self, "large_file_share_enabled")

    @large_file_share_enabled.setter
    def large_file_share_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "large_file_share_enabled", value)

    @property
    @pulumi.getter(name="localUserEnabled")
    def local_user_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is Local User Enabled? Defaults to `true`.
        """
        return pulumi.get(self, "local_user_enabled")

    @local_user_enabled.setter
    def local_user_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "local_user_enabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The minimum supported TLS version for the storage account. Possible values are `TLS1_0`, `TLS1_1`, and `TLS1_2`. Defaults to `TLS1_2` for new storage accounts.

        > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.

        > **Note:** At this time `min_tls_version` is only supported in the Public Cloud, China Cloud, and US Government Cloud.
        """
        return pulumi.get(self, "min_tls_version")

    @min_tls_version.setter
    def min_tls_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "min_tls_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the storage account. Only lowercase Alphanumeric characters allowed. Changing this forces a new resource to be created. This must be unique across the entire Azure service, not just within the resource group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkRules")
    def network_rules(self) -> Optional[pulumi.Input['AccountNetworkRulesArgs']]:
        """
        A `network_rules` block as documented below.
        """
        return pulumi.get(self, "network_rules")

    @network_rules.setter
    def network_rules(self, value: Optional[pulumi.Input['AccountNetworkRulesArgs']]):
        pulumi.set(self, "network_rules", value)

    @property
    @pulumi.getter(name="nfsv3Enabled")
    def nfsv3_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is NFSv3 protocol enabled? Changing this forces a new resource to be created. Defaults to `false`.

        > **Note:** This can only be `true` when `account_tier` is `Standard` and `account_kind` is `StorageV2`, or `account_tier` is `Premium` and `account_kind` is `BlockBlobStorage`. Additionally, the `is_hns_enabled` is `true` and `account_replication_type` must be `LRS` or `RAGRS`.
        """
        return pulumi.get(self, "nfsv3_enabled")

    @nfsv3_enabled.setter
    def nfsv3_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "nfsv3_enabled", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the public network access is enabled? Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter(name="queueEncryptionKeyType")
    def queue_encryption_key_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The encryption type of the queue service. Possible values are `Service` and `Account`. Changing this forces a new resource to be created. Default value is `Service`.
        """
        return pulumi.get(self, "queue_encryption_key_type")

    @queue_encryption_key_type.setter
    def queue_encryption_key_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "queue_encryption_key_type", value)

    @property
    @pulumi.getter(name="queueProperties")
    @_utilities.deprecated("""this block has been deprecated and superseded by the `storage.AccountQueueProperties` resource and will be removed in v5.0 of the AzureRM provider""")
    def queue_properties(self) -> Optional[pulumi.Input['AccountQueuePropertiesArgs']]:
        """
        A `queue_properties` block as defined below.

        > **Note:** `queue_properties` can only be configured when `account_tier` is set to `Standard` and `account_kind` is set to either `Storage` or `StorageV2`.
        """
        return pulumi.get(self, "queue_properties")

    @queue_properties.setter
    def queue_properties(self, value: Optional[pulumi.Input['AccountQueuePropertiesArgs']]):
        pulumi.set(self, "queue_properties", value)

    @property
    @pulumi.getter
    def routing(self) -> Optional[pulumi.Input['AccountRoutingArgs']]:
        """
        A `routing` block as defined below.
        """
        return pulumi.get(self, "routing")

    @routing.setter
    def routing(self, value: Optional[pulumi.Input['AccountRoutingArgs']]):
        pulumi.set(self, "routing", value)

    @property
    @pulumi.getter(name="sasPolicy")
    def sas_policy(self) -> Optional[pulumi.Input['AccountSasPolicyArgs']]:
        """
        A `sas_policy` block as defined below.
        """
        return pulumi.get(self, "sas_policy")

    @sas_policy.setter
    def sas_policy(self, value: Optional[pulumi.Input['AccountSasPolicyArgs']]):
        pulumi.set(self, "sas_policy", value)

    @property
    @pulumi.getter(name="sftpEnabled")
    def sftp_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean, enable SFTP for the storage account

        > **Note:** SFTP support requires `is_hns_enabled` set to `true`. [More information on SFTP support can be found here](https://learn.microsoft.com/azure/storage/blobs/secure-file-transfer-protocol-support). Defaults to `false`
        """
        return pulumi.get(self, "sftp_enabled")

    @sftp_enabled.setter
    def sftp_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "sftp_enabled", value)

    @property
    @pulumi.getter(name="shareProperties")
    def share_properties(self) -> Optional[pulumi.Input['AccountSharePropertiesArgs']]:
        """
        A `share_properties` block as defined below.

        > **Note:** `share_properties` can only be configured when either `account_tier` is `Standard` and `account_kind` is either `Storage` or `StorageV2` - or when `account_tier` is `Premium` and `account_kind` is `FileStorage`.
        """
        return pulumi.get(self, "share_properties")

    @share_properties.setter
    def share_properties(self, value: Optional[pulumi.Input['AccountSharePropertiesArgs']]):
        pulumi.set(self, "share_properties", value)

    @property
    @pulumi.getter(name="sharedAccessKeyEnabled")
    def shared_access_key_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "shared_access_key_enabled")

    @shared_access_key_enabled.setter
    def shared_access_key_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "shared_access_key_enabled", value)

    @property
    @pulumi.getter(name="staticWebsite")
    @_utilities.deprecated("""this block has been deprecated and superseded by the `storage.AccountStaticWebsite` resource and will be removed in v5.0 of the AzureRM provider""")
    def static_website(self) -> Optional[pulumi.Input['AccountStaticWebsiteArgs']]:
        """
        A `static_website` block as defined below.

        > **Note:** `static_website` can only be set when the `account_kind` is set to `StorageV2` or `BlockBlobStorage`.

        > **Note:** If `static_website` is specified, the service will automatically create a `storage.Container` named `$web`.
        """
        return pulumi.get(self, "static_website")

    @static_website.setter
    def static_website(self, value: Optional[pulumi.Input['AccountStaticWebsiteArgs']]):
        pulumi.set(self, "static_website", value)

    @property
    @pulumi.getter(name="tableEncryptionKeyType")
    def table_encryption_key_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The encryption type of the table service. Possible values are `Service` and `Account`. Changing this forces a new resource to be created. Default value is `Service`.

        > **Note:** `queue_encryption_key_type` and `table_encryption_key_type` cannot be set to `Account` when `account_kind` is set `Storage`
        """
        return pulumi.get(self, "table_encryption_key_type")

    @table_encryption_key_type.setter
    def table_encryption_key_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "table_encryption_key_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AccountState:
    def __init__(__self__, *,
                 access_tier: Optional[pulumi.Input[builtins.str]] = None,
                 account_kind: Optional[pulumi.Input[builtins.str]] = None,
                 account_replication_type: Optional[pulumi.Input[builtins.str]] = None,
                 account_tier: Optional[pulumi.Input[builtins.str]] = None,
                 allow_nested_items_to_be_public: Optional[pulumi.Input[builtins.bool]] = None,
                 allowed_copy_scope: Optional[pulumi.Input[builtins.str]] = None,
                 azure_files_authentication: Optional[pulumi.Input['AccountAzureFilesAuthenticationArgs']] = None,
                 blob_properties: Optional[pulumi.Input['AccountBlobPropertiesArgs']] = None,
                 cross_tenant_replication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 custom_domain: Optional[pulumi.Input['AccountCustomDomainArgs']] = None,
                 customer_managed_key: Optional[pulumi.Input['AccountCustomerManagedKeyArgs']] = None,
                 default_to_oauth_authentication: Optional[pulumi.Input[builtins.bool]] = None,
                 dns_endpoint_type: Optional[pulumi.Input[builtins.str]] = None,
                 edge_zone: Optional[pulumi.Input[builtins.str]] = None,
                 https_traffic_only_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 identity: Optional[pulumi.Input['AccountIdentityArgs']] = None,
                 immutability_policy: Optional[pulumi.Input['AccountImmutabilityPolicyArgs']] = None,
                 infrastructure_encryption_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_hns_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 large_file_share_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 local_user_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 min_tls_version: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_rules: Optional[pulumi.Input['AccountNetworkRulesArgs']] = None,
                 nfsv3_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 primary_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 primary_blob_connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 primary_blob_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 primary_blob_host: Optional[pulumi.Input[builtins.str]] = None,
                 primary_blob_internet_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 primary_blob_internet_host: Optional[pulumi.Input[builtins.str]] = None,
                 primary_blob_microsoft_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 primary_blob_microsoft_host: Optional[pulumi.Input[builtins.str]] = None,
                 primary_connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 primary_dfs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 primary_dfs_host: Optional[pulumi.Input[builtins.str]] = None,
                 primary_dfs_internet_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 primary_dfs_internet_host: Optional[pulumi.Input[builtins.str]] = None,
                 primary_dfs_microsoft_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 primary_dfs_microsoft_host: Optional[pulumi.Input[builtins.str]] = None,
                 primary_file_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 primary_file_host: Optional[pulumi.Input[builtins.str]] = None,
                 primary_file_internet_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 primary_file_internet_host: Optional[pulumi.Input[builtins.str]] = None,
                 primary_file_microsoft_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 primary_file_microsoft_host: Optional[pulumi.Input[builtins.str]] = None,
                 primary_location: Optional[pulumi.Input[builtins.str]] = None,
                 primary_queue_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 primary_queue_host: Optional[pulumi.Input[builtins.str]] = None,
                 primary_queue_microsoft_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 primary_queue_microsoft_host: Optional[pulumi.Input[builtins.str]] = None,
                 primary_table_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 primary_table_host: Optional[pulumi.Input[builtins.str]] = None,
                 primary_table_microsoft_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 primary_table_microsoft_host: Optional[pulumi.Input[builtins.str]] = None,
                 primary_web_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 primary_web_host: Optional[pulumi.Input[builtins.str]] = None,
                 primary_web_internet_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 primary_web_internet_host: Optional[pulumi.Input[builtins.str]] = None,
                 primary_web_microsoft_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 primary_web_microsoft_host: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 queue_encryption_key_type: Optional[pulumi.Input[builtins.str]] = None,
                 queue_properties: Optional[pulumi.Input['AccountQueuePropertiesArgs']] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing: Optional[pulumi.Input['AccountRoutingArgs']] = None,
                 sas_policy: Optional[pulumi.Input['AccountSasPolicyArgs']] = None,
                 secondary_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_blob_connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_blob_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_blob_host: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_blob_internet_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_blob_internet_host: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_blob_microsoft_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_blob_microsoft_host: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dfs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dfs_host: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dfs_internet_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dfs_internet_host: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dfs_microsoft_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_dfs_microsoft_host: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_file_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_file_host: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_file_internet_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_file_internet_host: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_file_microsoft_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_file_microsoft_host: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_location: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_queue_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_queue_host: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_queue_microsoft_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_queue_microsoft_host: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_table_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_table_host: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_table_microsoft_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_table_microsoft_host: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_web_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_web_host: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_web_internet_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_web_internet_host: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_web_microsoft_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_web_microsoft_host: Optional[pulumi.Input[builtins.str]] = None,
                 sftp_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 share_properties: Optional[pulumi.Input['AccountSharePropertiesArgs']] = None,
                 shared_access_key_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 static_website: Optional[pulumi.Input['AccountStaticWebsiteArgs']] = None,
                 table_encryption_key_type: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Account resources.
        :param pulumi.Input[builtins.str] access_tier: Defines the access tier for `BlobStorage`, `FileStorage` and `StorageV2` accounts. Valid options are `Hot`, `Cool`, `Cold` and `Premium`. Defaults to `Hot`.
        :param pulumi.Input[builtins.str] account_kind: Defines the Kind of account. Valid options are `BlobStorage`, `BlockBlobStorage`, `FileStorage`, `Storage` and `StorageV2`. Defaults to `StorageV2`.
               
               > **Note:** Changing the `account_kind` value from `Storage` to `StorageV2` will not trigger a force new on the storage account, it will only upgrade the existing storage account from `Storage` to `StorageV2` keeping the existing storage account in place.
        :param pulumi.Input[builtins.str] account_replication_type: Defines the type of replication to use for this storage account. Valid options are `LRS`, `GRS`, `RAGRS`, `ZRS`, `GZRS` and `RAGZRS`. Changing this forces a new resource to be created when types `LRS`, `GRS` and `RAGRS` are changed to `ZRS`, `GZRS` or `RAGZRS` and vice versa.
        :param pulumi.Input[builtins.str] account_tier: Defines the Tier to use for this storage account. Valid options are `Standard` and `Premium`. For `BlockBlobStorage` and `FileStorage` accounts only `Premium` is valid. Changing this forces a new resource to be created.
               
               > **Note:** Blobs with a tier of `Premium` are of account kind `StorageV2`.
        :param pulumi.Input[builtins.bool] allow_nested_items_to_be_public: Allow or disallow nested items within this Account to opt into being public. Defaults to `true`.
               
               > **Note:** At this time `allow_nested_items_to_be_public` is only supported in the Public Cloud, China Cloud, and US Government Cloud.
        :param pulumi.Input[builtins.str] allowed_copy_scope: Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet. Possible values are `AAD` and `PrivateLink`.
        :param pulumi.Input['AccountAzureFilesAuthenticationArgs'] azure_files_authentication: A `azure_files_authentication` block as defined below.
        :param pulumi.Input['AccountBlobPropertiesArgs'] blob_properties: A `blob_properties` block as defined below.
        :param pulumi.Input[builtins.bool] cross_tenant_replication_enabled: Should cross Tenant replication be enabled? Defaults to `false`.
        :param pulumi.Input['AccountCustomDomainArgs'] custom_domain: A `custom_domain` block as documented below.
        :param pulumi.Input['AccountCustomerManagedKeyArgs'] customer_managed_key: A `customer_managed_key` block as documented below.
               
               > **Note:** It's possible to define a Customer Managed Key both within either the `customer_managed_key` block or by using the `storage.CustomerManagedKey` resource. However, it's not possible to use both methods to manage a Customer Managed Key for a Storage Account, since these will conflict. When using the `storage.CustomerManagedKey` resource, you will need to use `ignore_changes` on the `customer_managed_key` block.
        :param pulumi.Input[builtins.bool] default_to_oauth_authentication: Default to Azure Active Directory authorization in the Azure portal when accessing the Storage Account. The default value is `false`
        :param pulumi.Input[builtins.str] dns_endpoint_type: Specifies which DNS endpoint type to use. Possible values are `Standard` and `AzureDnsZone`. Defaults to `Standard`. Changing this forces a new resource to be created.
               
               > **Note:** Azure DNS zone support requires `PartitionedDns` feature to be enabled. To enable this feature for your subscription, use the following command: `az feature register --namespace "Microsoft.Storage" --name "PartitionedDns"`.
        :param pulumi.Input[builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Storage Account should exist. Changing this forces a new Storage Account to be created.
        :param pulumi.Input[builtins.bool] https_traffic_only_enabled: Boolean flag which forces HTTPS if enabled, see [here](https://docs.microsoft.com/azure/storage/storage-require-secure-transfer/) for more information. Defaults to `true`.
        :param pulumi.Input['AccountIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input['AccountImmutabilityPolicyArgs'] immutability_policy: An `immutability_policy` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] infrastructure_encryption_enabled: Is infrastructure encryption enabled? Changing this forces a new resource to be created. Defaults to `false`.
               
               > **Note:** This can only be `true` when `account_kind` is `StorageV2` or when `account_tier` is `Premium` *and* `account_kind` is one of `BlockBlobStorage` or `FileStorage`.
        :param pulumi.Input[builtins.bool] is_hns_enabled: Is Hierarchical Namespace enabled? This can be used with Azure Data Lake Storage Gen 2 ([see here for more information](https://docs.microsoft.com/azure/storage/blobs/data-lake-storage-quickstart-create-account/)). Changing this forces a new resource to be created.
               
               > **Note:** This can only be `true` when `account_tier` is `Standard` or when `account_tier` is `Premium` *and* `account_kind` is `BlockBlobStorage`
        :param pulumi.Input[builtins.bool] large_file_share_enabled: Are Large File Shares Enabled? Defaults to `false`.
               
               > **Note:** Large File Shares are enabled by default when using an `account_kind` of `FileStorage`.
        :param pulumi.Input[builtins.bool] local_user_enabled: Is Local User Enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] min_tls_version: The minimum supported TLS version for the storage account. Possible values are `TLS1_0`, `TLS1_1`, and `TLS1_2`. Defaults to `TLS1_2` for new storage accounts.
               
               > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
               
               > **Note:** At this time `min_tls_version` is only supported in the Public Cloud, China Cloud, and US Government Cloud.
        :param pulumi.Input[builtins.str] name: Specifies the name of the storage account. Only lowercase Alphanumeric characters allowed. Changing this forces a new resource to be created. This must be unique across the entire Azure service, not just within the resource group.
        :param pulumi.Input['AccountNetworkRulesArgs'] network_rules: A `network_rules` block as documented below.
        :param pulumi.Input[builtins.bool] nfsv3_enabled: Is NFSv3 protocol enabled? Changing this forces a new resource to be created. Defaults to `false`.
               
               > **Note:** This can only be `true` when `account_tier` is `Standard` and `account_kind` is `StorageV2`, or `account_tier` is `Premium` and `account_kind` is `BlockBlobStorage`. Additionally, the `is_hns_enabled` is `true` and `account_replication_type` must be `LRS` or `RAGRS`.
        :param pulumi.Input[builtins.str] primary_access_key: The primary access key for the storage account.
        :param pulumi.Input[builtins.str] primary_blob_connection_string: The connection string associated with the primary blob location.
        :param pulumi.Input[builtins.str] primary_blob_endpoint: The endpoint URL for blob storage in the primary location.
        :param pulumi.Input[builtins.str] primary_blob_host: The hostname with port if applicable for blob storage in the primary location.
        :param pulumi.Input[builtins.str] primary_blob_internet_endpoint: The internet routing endpoint URL for blob storage in the primary location.
        :param pulumi.Input[builtins.str] primary_blob_internet_host: The internet routing hostname with port if applicable for blob storage in the primary location.
        :param pulumi.Input[builtins.str] primary_blob_microsoft_endpoint: The microsoft routing endpoint URL for blob storage in the primary location.
        :param pulumi.Input[builtins.str] primary_blob_microsoft_host: The microsoft routing hostname with port if applicable for blob storage in the primary location.
        :param pulumi.Input[builtins.str] primary_connection_string: The connection string associated with the primary location.
        :param pulumi.Input[builtins.str] primary_dfs_endpoint: The endpoint URL for DFS storage in the primary location.
        :param pulumi.Input[builtins.str] primary_dfs_host: The hostname with port if applicable for DFS storage in the primary location.
        :param pulumi.Input[builtins.str] primary_dfs_internet_endpoint: The internet routing endpoint URL for DFS storage in the primary location.
        :param pulumi.Input[builtins.str] primary_dfs_internet_host: The internet routing hostname with port if applicable for DFS storage in the primary location.
        :param pulumi.Input[builtins.str] primary_dfs_microsoft_endpoint: The microsoft routing endpoint URL for DFS storage in the primary location.
        :param pulumi.Input[builtins.str] primary_dfs_microsoft_host: The microsoft routing hostname with port if applicable for DFS storage in the primary location.
        :param pulumi.Input[builtins.str] primary_file_endpoint: The endpoint URL for file storage in the primary location.
        :param pulumi.Input[builtins.str] primary_file_host: The hostname with port if applicable for file storage in the primary location.
        :param pulumi.Input[builtins.str] primary_file_internet_endpoint: The internet routing endpoint URL for file storage in the primary location.
        :param pulumi.Input[builtins.str] primary_file_internet_host: The internet routing hostname with port if applicable for file storage in the primary location.
        :param pulumi.Input[builtins.str] primary_file_microsoft_endpoint: The microsoft routing endpoint URL for file storage in the primary location.
        :param pulumi.Input[builtins.str] primary_file_microsoft_host: The microsoft routing hostname with port if applicable for file storage in the primary location.
        :param pulumi.Input[builtins.str] primary_location: The primary location of the storage account.
        :param pulumi.Input[builtins.str] primary_queue_endpoint: The endpoint URL for queue storage in the primary location.
        :param pulumi.Input[builtins.str] primary_queue_host: The hostname with port if applicable for queue storage in the primary location.
        :param pulumi.Input[builtins.str] primary_queue_microsoft_endpoint: The microsoft routing endpoint URL for queue storage in the primary location.
        :param pulumi.Input[builtins.str] primary_queue_microsoft_host: The microsoft routing hostname with port if applicable for queue storage in the primary location.
        :param pulumi.Input[builtins.str] primary_table_endpoint: The endpoint URL for table storage in the primary location.
        :param pulumi.Input[builtins.str] primary_table_host: The hostname with port if applicable for table storage in the primary location.
        :param pulumi.Input[builtins.str] primary_table_microsoft_endpoint: The microsoft routing endpoint URL for table storage in the primary location.
        :param pulumi.Input[builtins.str] primary_table_microsoft_host: The microsoft routing hostname with port if applicable for table storage in the primary location.
        :param pulumi.Input[builtins.str] primary_web_endpoint: The endpoint URL for web storage in the primary location.
        :param pulumi.Input[builtins.str] primary_web_host: The hostname with port if applicable for web storage in the primary location.
        :param pulumi.Input[builtins.str] primary_web_internet_endpoint: The internet routing endpoint URL for web storage in the primary location.
        :param pulumi.Input[builtins.str] primary_web_internet_host: The internet routing hostname with port if applicable for web storage in the primary location.
        :param pulumi.Input[builtins.str] primary_web_microsoft_endpoint: The microsoft routing endpoint URL for web storage in the primary location.
        :param pulumi.Input[builtins.str] primary_web_microsoft_host: The microsoft routing hostname with port if applicable for web storage in the primary location.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Whether the public network access is enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] queue_encryption_key_type: The encryption type of the queue service. Possible values are `Service` and `Account`. Changing this forces a new resource to be created. Default value is `Service`.
        :param pulumi.Input['AccountQueuePropertiesArgs'] queue_properties: A `queue_properties` block as defined below.
               
               > **Note:** `queue_properties` can only be configured when `account_tier` is set to `Standard` and `account_kind` is set to either `Storage` or `StorageV2`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the storage account. Changing this forces a new resource to be created.
        :param pulumi.Input['AccountRoutingArgs'] routing: A `routing` block as defined below.
        :param pulumi.Input['AccountSasPolicyArgs'] sas_policy: A `sas_policy` block as defined below.
        :param pulumi.Input[builtins.str] secondary_access_key: The secondary access key for the storage account.
        :param pulumi.Input[builtins.str] secondary_blob_connection_string: The connection string associated with the secondary blob location.
        :param pulumi.Input[builtins.str] secondary_blob_endpoint: The endpoint URL for blob storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_blob_host: The hostname with port if applicable for blob storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_blob_internet_endpoint: The internet routing endpoint URL for blob storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_blob_internet_host: The internet routing hostname with port if applicable for blob storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_blob_microsoft_endpoint: The microsoft routing endpoint URL for blob storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_blob_microsoft_host: The microsoft routing hostname with port if applicable for blob storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_connection_string: The connection string associated with the secondary location.
        :param pulumi.Input[builtins.str] secondary_dfs_endpoint: The endpoint URL for DFS storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_dfs_host: The hostname with port if applicable for DFS storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_dfs_internet_endpoint: The internet routing endpoint URL for DFS storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_dfs_internet_host: The internet routing hostname with port if applicable for DFS storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_dfs_microsoft_endpoint: The microsoft routing endpoint URL for DFS storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_dfs_microsoft_host: The microsoft routing hostname with port if applicable for DFS storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_file_endpoint: The endpoint URL for file storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_file_host: The hostname with port if applicable for file storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_file_internet_endpoint: The internet routing endpoint URL for file storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_file_internet_host: The internet routing hostname with port if applicable for file storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_file_microsoft_endpoint: The microsoft routing endpoint URL for file storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_file_microsoft_host: The microsoft routing hostname with port if applicable for file storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_location: The secondary location of the storage account.
        :param pulumi.Input[builtins.str] secondary_queue_endpoint: The endpoint URL for queue storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_queue_host: The hostname with port if applicable for queue storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_queue_microsoft_endpoint: The microsoft routing endpoint URL for queue storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_queue_microsoft_host: The microsoft routing hostname with port if applicable for queue storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_table_endpoint: The endpoint URL for table storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_table_host: The hostname with port if applicable for table storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_table_microsoft_endpoint: The microsoft routing endpoint URL for table storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_table_microsoft_host: The microsoft routing hostname with port if applicable for table storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_web_endpoint: The endpoint URL for web storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_web_host: The hostname with port if applicable for web storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_web_internet_endpoint: The internet routing endpoint URL for web storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_web_internet_host: The internet routing hostname with port if applicable for web storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_web_microsoft_endpoint: The microsoft routing endpoint URL for web storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_web_microsoft_host: The microsoft routing hostname with port if applicable for web storage in the secondary location.
        :param pulumi.Input[builtins.bool] sftp_enabled: Boolean, enable SFTP for the storage account
               
               > **Note:** SFTP support requires `is_hns_enabled` set to `true`. [More information on SFTP support can be found here](https://learn.microsoft.com/azure/storage/blobs/secure-file-transfer-protocol-support). Defaults to `false`
        :param pulumi.Input['AccountSharePropertiesArgs'] share_properties: A `share_properties` block as defined below.
               
               > **Note:** `share_properties` can only be configured when either `account_tier` is `Standard` and `account_kind` is either `Storage` or `StorageV2` - or when `account_tier` is `Premium` and `account_kind` is `FileStorage`.
        :param pulumi.Input['AccountStaticWebsiteArgs'] static_website: A `static_website` block as defined below.
               
               > **Note:** `static_website` can only be set when the `account_kind` is set to `StorageV2` or `BlockBlobStorage`.
               
               > **Note:** If `static_website` is specified, the service will automatically create a `storage.Container` named `$web`.
        :param pulumi.Input[builtins.str] table_encryption_key_type: The encryption type of the table service. Possible values are `Service` and `Account`. Changing this forces a new resource to be created. Default value is `Service`.
               
               > **Note:** `queue_encryption_key_type` and `table_encryption_key_type` cannot be set to `Account` when `account_kind` is set `Storage`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if access_tier is not None:
            pulumi.set(__self__, "access_tier", access_tier)
        if account_kind is not None:
            pulumi.set(__self__, "account_kind", account_kind)
        if account_replication_type is not None:
            pulumi.set(__self__, "account_replication_type", account_replication_type)
        if account_tier is not None:
            pulumi.set(__self__, "account_tier", account_tier)
        if allow_nested_items_to_be_public is not None:
            pulumi.set(__self__, "allow_nested_items_to_be_public", allow_nested_items_to_be_public)
        if allowed_copy_scope is not None:
            pulumi.set(__self__, "allowed_copy_scope", allowed_copy_scope)
        if azure_files_authentication is not None:
            pulumi.set(__self__, "azure_files_authentication", azure_files_authentication)
        if blob_properties is not None:
            pulumi.set(__self__, "blob_properties", blob_properties)
        if cross_tenant_replication_enabled is not None:
            pulumi.set(__self__, "cross_tenant_replication_enabled", cross_tenant_replication_enabled)
        if custom_domain is not None:
            pulumi.set(__self__, "custom_domain", custom_domain)
        if customer_managed_key is not None:
            pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if default_to_oauth_authentication is not None:
            pulumi.set(__self__, "default_to_oauth_authentication", default_to_oauth_authentication)
        if dns_endpoint_type is not None:
            pulumi.set(__self__, "dns_endpoint_type", dns_endpoint_type)
        if edge_zone is not None:
            pulumi.set(__self__, "edge_zone", edge_zone)
        if https_traffic_only_enabled is not None:
            pulumi.set(__self__, "https_traffic_only_enabled", https_traffic_only_enabled)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if immutability_policy is not None:
            pulumi.set(__self__, "immutability_policy", immutability_policy)
        if infrastructure_encryption_enabled is not None:
            pulumi.set(__self__, "infrastructure_encryption_enabled", infrastructure_encryption_enabled)
        if is_hns_enabled is not None:
            pulumi.set(__self__, "is_hns_enabled", is_hns_enabled)
        if large_file_share_enabled is not None:
            pulumi.set(__self__, "large_file_share_enabled", large_file_share_enabled)
        if local_user_enabled is not None:
            pulumi.set(__self__, "local_user_enabled", local_user_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if min_tls_version is not None:
            pulumi.set(__self__, "min_tls_version", min_tls_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_rules is not None:
            pulumi.set(__self__, "network_rules", network_rules)
        if nfsv3_enabled is not None:
            pulumi.set(__self__, "nfsv3_enabled", nfsv3_enabled)
        if primary_access_key is not None:
            pulumi.set(__self__, "primary_access_key", primary_access_key)
        if primary_blob_connection_string is not None:
            pulumi.set(__self__, "primary_blob_connection_string", primary_blob_connection_string)
        if primary_blob_endpoint is not None:
            pulumi.set(__self__, "primary_blob_endpoint", primary_blob_endpoint)
        if primary_blob_host is not None:
            pulumi.set(__self__, "primary_blob_host", primary_blob_host)
        if primary_blob_internet_endpoint is not None:
            pulumi.set(__self__, "primary_blob_internet_endpoint", primary_blob_internet_endpoint)
        if primary_blob_internet_host is not None:
            pulumi.set(__self__, "primary_blob_internet_host", primary_blob_internet_host)
        if primary_blob_microsoft_endpoint is not None:
            pulumi.set(__self__, "primary_blob_microsoft_endpoint", primary_blob_microsoft_endpoint)
        if primary_blob_microsoft_host is not None:
            pulumi.set(__self__, "primary_blob_microsoft_host", primary_blob_microsoft_host)
        if primary_connection_string is not None:
            pulumi.set(__self__, "primary_connection_string", primary_connection_string)
        if primary_dfs_endpoint is not None:
            pulumi.set(__self__, "primary_dfs_endpoint", primary_dfs_endpoint)
        if primary_dfs_host is not None:
            pulumi.set(__self__, "primary_dfs_host", primary_dfs_host)
        if primary_dfs_internet_endpoint is not None:
            pulumi.set(__self__, "primary_dfs_internet_endpoint", primary_dfs_internet_endpoint)
        if primary_dfs_internet_host is not None:
            pulumi.set(__self__, "primary_dfs_internet_host", primary_dfs_internet_host)
        if primary_dfs_microsoft_endpoint is not None:
            pulumi.set(__self__, "primary_dfs_microsoft_endpoint", primary_dfs_microsoft_endpoint)
        if primary_dfs_microsoft_host is not None:
            pulumi.set(__self__, "primary_dfs_microsoft_host", primary_dfs_microsoft_host)
        if primary_file_endpoint is not None:
            pulumi.set(__self__, "primary_file_endpoint", primary_file_endpoint)
        if primary_file_host is not None:
            pulumi.set(__self__, "primary_file_host", primary_file_host)
        if primary_file_internet_endpoint is not None:
            pulumi.set(__self__, "primary_file_internet_endpoint", primary_file_internet_endpoint)
        if primary_file_internet_host is not None:
            pulumi.set(__self__, "primary_file_internet_host", primary_file_internet_host)
        if primary_file_microsoft_endpoint is not None:
            pulumi.set(__self__, "primary_file_microsoft_endpoint", primary_file_microsoft_endpoint)
        if primary_file_microsoft_host is not None:
            pulumi.set(__self__, "primary_file_microsoft_host", primary_file_microsoft_host)
        if primary_location is not None:
            pulumi.set(__self__, "primary_location", primary_location)
        if primary_queue_endpoint is not None:
            pulumi.set(__self__, "primary_queue_endpoint", primary_queue_endpoint)
        if primary_queue_host is not None:
            pulumi.set(__self__, "primary_queue_host", primary_queue_host)
        if primary_queue_microsoft_endpoint is not None:
            pulumi.set(__self__, "primary_queue_microsoft_endpoint", primary_queue_microsoft_endpoint)
        if primary_queue_microsoft_host is not None:
            pulumi.set(__self__, "primary_queue_microsoft_host", primary_queue_microsoft_host)
        if primary_table_endpoint is not None:
            pulumi.set(__self__, "primary_table_endpoint", primary_table_endpoint)
        if primary_table_host is not None:
            pulumi.set(__self__, "primary_table_host", primary_table_host)
        if primary_table_microsoft_endpoint is not None:
            pulumi.set(__self__, "primary_table_microsoft_endpoint", primary_table_microsoft_endpoint)
        if primary_table_microsoft_host is not None:
            pulumi.set(__self__, "primary_table_microsoft_host", primary_table_microsoft_host)
        if primary_web_endpoint is not None:
            pulumi.set(__self__, "primary_web_endpoint", primary_web_endpoint)
        if primary_web_host is not None:
            pulumi.set(__self__, "primary_web_host", primary_web_host)
        if primary_web_internet_endpoint is not None:
            pulumi.set(__self__, "primary_web_internet_endpoint", primary_web_internet_endpoint)
        if primary_web_internet_host is not None:
            pulumi.set(__self__, "primary_web_internet_host", primary_web_internet_host)
        if primary_web_microsoft_endpoint is not None:
            pulumi.set(__self__, "primary_web_microsoft_endpoint", primary_web_microsoft_endpoint)
        if primary_web_microsoft_host is not None:
            pulumi.set(__self__, "primary_web_microsoft_host", primary_web_microsoft_host)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if queue_encryption_key_type is not None:
            pulumi.set(__self__, "queue_encryption_key_type", queue_encryption_key_type)
        if queue_properties is not None:
            warnings.warn("""this block has been deprecated and superseded by the `storage.AccountQueueProperties` resource and will be removed in v5.0 of the AzureRM provider""", DeprecationWarning)
            pulumi.log.warn("""queue_properties is deprecated: this block has been deprecated and superseded by the `storage.AccountQueueProperties` resource and will be removed in v5.0 of the AzureRM provider""")
        if queue_properties is not None:
            pulumi.set(__self__, "queue_properties", queue_properties)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if routing is not None:
            pulumi.set(__self__, "routing", routing)
        if sas_policy is not None:
            pulumi.set(__self__, "sas_policy", sas_policy)
        if secondary_access_key is not None:
            pulumi.set(__self__, "secondary_access_key", secondary_access_key)
        if secondary_blob_connection_string is not None:
            pulumi.set(__self__, "secondary_blob_connection_string", secondary_blob_connection_string)
        if secondary_blob_endpoint is not None:
            pulumi.set(__self__, "secondary_blob_endpoint", secondary_blob_endpoint)
        if secondary_blob_host is not None:
            pulumi.set(__self__, "secondary_blob_host", secondary_blob_host)
        if secondary_blob_internet_endpoint is not None:
            pulumi.set(__self__, "secondary_blob_internet_endpoint", secondary_blob_internet_endpoint)
        if secondary_blob_internet_host is not None:
            pulumi.set(__self__, "secondary_blob_internet_host", secondary_blob_internet_host)
        if secondary_blob_microsoft_endpoint is not None:
            pulumi.set(__self__, "secondary_blob_microsoft_endpoint", secondary_blob_microsoft_endpoint)
        if secondary_blob_microsoft_host is not None:
            pulumi.set(__self__, "secondary_blob_microsoft_host", secondary_blob_microsoft_host)
        if secondary_connection_string is not None:
            pulumi.set(__self__, "secondary_connection_string", secondary_connection_string)
        if secondary_dfs_endpoint is not None:
            pulumi.set(__self__, "secondary_dfs_endpoint", secondary_dfs_endpoint)
        if secondary_dfs_host is not None:
            pulumi.set(__self__, "secondary_dfs_host", secondary_dfs_host)
        if secondary_dfs_internet_endpoint is not None:
            pulumi.set(__self__, "secondary_dfs_internet_endpoint", secondary_dfs_internet_endpoint)
        if secondary_dfs_internet_host is not None:
            pulumi.set(__self__, "secondary_dfs_internet_host", secondary_dfs_internet_host)
        if secondary_dfs_microsoft_endpoint is not None:
            pulumi.set(__self__, "secondary_dfs_microsoft_endpoint", secondary_dfs_microsoft_endpoint)
        if secondary_dfs_microsoft_host is not None:
            pulumi.set(__self__, "secondary_dfs_microsoft_host", secondary_dfs_microsoft_host)
        if secondary_file_endpoint is not None:
            pulumi.set(__self__, "secondary_file_endpoint", secondary_file_endpoint)
        if secondary_file_host is not None:
            pulumi.set(__self__, "secondary_file_host", secondary_file_host)
        if secondary_file_internet_endpoint is not None:
            pulumi.set(__self__, "secondary_file_internet_endpoint", secondary_file_internet_endpoint)
        if secondary_file_internet_host is not None:
            pulumi.set(__self__, "secondary_file_internet_host", secondary_file_internet_host)
        if secondary_file_microsoft_endpoint is not None:
            pulumi.set(__self__, "secondary_file_microsoft_endpoint", secondary_file_microsoft_endpoint)
        if secondary_file_microsoft_host is not None:
            pulumi.set(__self__, "secondary_file_microsoft_host", secondary_file_microsoft_host)
        if secondary_location is not None:
            pulumi.set(__self__, "secondary_location", secondary_location)
        if secondary_queue_endpoint is not None:
            pulumi.set(__self__, "secondary_queue_endpoint", secondary_queue_endpoint)
        if secondary_queue_host is not None:
            pulumi.set(__self__, "secondary_queue_host", secondary_queue_host)
        if secondary_queue_microsoft_endpoint is not None:
            pulumi.set(__self__, "secondary_queue_microsoft_endpoint", secondary_queue_microsoft_endpoint)
        if secondary_queue_microsoft_host is not None:
            pulumi.set(__self__, "secondary_queue_microsoft_host", secondary_queue_microsoft_host)
        if secondary_table_endpoint is not None:
            pulumi.set(__self__, "secondary_table_endpoint", secondary_table_endpoint)
        if secondary_table_host is not None:
            pulumi.set(__self__, "secondary_table_host", secondary_table_host)
        if secondary_table_microsoft_endpoint is not None:
            pulumi.set(__self__, "secondary_table_microsoft_endpoint", secondary_table_microsoft_endpoint)
        if secondary_table_microsoft_host is not None:
            pulumi.set(__self__, "secondary_table_microsoft_host", secondary_table_microsoft_host)
        if secondary_web_endpoint is not None:
            pulumi.set(__self__, "secondary_web_endpoint", secondary_web_endpoint)
        if secondary_web_host is not None:
            pulumi.set(__self__, "secondary_web_host", secondary_web_host)
        if secondary_web_internet_endpoint is not None:
            pulumi.set(__self__, "secondary_web_internet_endpoint", secondary_web_internet_endpoint)
        if secondary_web_internet_host is not None:
            pulumi.set(__self__, "secondary_web_internet_host", secondary_web_internet_host)
        if secondary_web_microsoft_endpoint is not None:
            pulumi.set(__self__, "secondary_web_microsoft_endpoint", secondary_web_microsoft_endpoint)
        if secondary_web_microsoft_host is not None:
            pulumi.set(__self__, "secondary_web_microsoft_host", secondary_web_microsoft_host)
        if sftp_enabled is not None:
            pulumi.set(__self__, "sftp_enabled", sftp_enabled)
        if share_properties is not None:
            pulumi.set(__self__, "share_properties", share_properties)
        if shared_access_key_enabled is not None:
            pulumi.set(__self__, "shared_access_key_enabled", shared_access_key_enabled)
        if static_website is not None:
            warnings.warn("""this block has been deprecated and superseded by the `storage.AccountStaticWebsite` resource and will be removed in v5.0 of the AzureRM provider""", DeprecationWarning)
            pulumi.log.warn("""static_website is deprecated: this block has been deprecated and superseded by the `storage.AccountStaticWebsite` resource and will be removed in v5.0 of the AzureRM provider""")
        if static_website is not None:
            pulumi.set(__self__, "static_website", static_website)
        if table_encryption_key_type is not None:
            pulumi.set(__self__, "table_encryption_key_type", table_encryption_key_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accessTier")
    def access_tier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Defines the access tier for `BlobStorage`, `FileStorage` and `StorageV2` accounts. Valid options are `Hot`, `Cool`, `Cold` and `Premium`. Defaults to `Hot`.
        """
        return pulumi.get(self, "access_tier")

    @access_tier.setter
    def access_tier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_tier", value)

    @property
    @pulumi.getter(name="accountKind")
    def account_kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Defines the Kind of account. Valid options are `BlobStorage`, `BlockBlobStorage`, `FileStorage`, `Storage` and `StorageV2`. Defaults to `StorageV2`.

        > **Note:** Changing the `account_kind` value from `Storage` to `StorageV2` will not trigger a force new on the storage account, it will only upgrade the existing storage account from `Storage` to `StorageV2` keeping the existing storage account in place.
        """
        return pulumi.get(self, "account_kind")

    @account_kind.setter
    def account_kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_kind", value)

    @property
    @pulumi.getter(name="accountReplicationType")
    def account_replication_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Defines the type of replication to use for this storage account. Valid options are `LRS`, `GRS`, `RAGRS`, `ZRS`, `GZRS` and `RAGZRS`. Changing this forces a new resource to be created when types `LRS`, `GRS` and `RAGRS` are changed to `ZRS`, `GZRS` or `RAGZRS` and vice versa.
        """
        return pulumi.get(self, "account_replication_type")

    @account_replication_type.setter
    def account_replication_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_replication_type", value)

    @property
    @pulumi.getter(name="accountTier")
    def account_tier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Defines the Tier to use for this storage account. Valid options are `Standard` and `Premium`. For `BlockBlobStorage` and `FileStorage` accounts only `Premium` is valid. Changing this forces a new resource to be created.

        > **Note:** Blobs with a tier of `Premium` are of account kind `StorageV2`.
        """
        return pulumi.get(self, "account_tier")

    @account_tier.setter
    def account_tier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_tier", value)

    @property
    @pulumi.getter(name="allowNestedItemsToBePublic")
    def allow_nested_items_to_be_public(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow or disallow nested items within this Account to opt into being public. Defaults to `true`.

        > **Note:** At this time `allow_nested_items_to_be_public` is only supported in the Public Cloud, China Cloud, and US Government Cloud.
        """
        return pulumi.get(self, "allow_nested_items_to_be_public")

    @allow_nested_items_to_be_public.setter
    def allow_nested_items_to_be_public(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_nested_items_to_be_public", value)

    @property
    @pulumi.getter(name="allowedCopyScope")
    def allowed_copy_scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet. Possible values are `AAD` and `PrivateLink`.
        """
        return pulumi.get(self, "allowed_copy_scope")

    @allowed_copy_scope.setter
    def allowed_copy_scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "allowed_copy_scope", value)

    @property
    @pulumi.getter(name="azureFilesAuthentication")
    def azure_files_authentication(self) -> Optional[pulumi.Input['AccountAzureFilesAuthenticationArgs']]:
        """
        A `azure_files_authentication` block as defined below.
        """
        return pulumi.get(self, "azure_files_authentication")

    @azure_files_authentication.setter
    def azure_files_authentication(self, value: Optional[pulumi.Input['AccountAzureFilesAuthenticationArgs']]):
        pulumi.set(self, "azure_files_authentication", value)

    @property
    @pulumi.getter(name="blobProperties")
    def blob_properties(self) -> Optional[pulumi.Input['AccountBlobPropertiesArgs']]:
        """
        A `blob_properties` block as defined below.
        """
        return pulumi.get(self, "blob_properties")

    @blob_properties.setter
    def blob_properties(self, value: Optional[pulumi.Input['AccountBlobPropertiesArgs']]):
        pulumi.set(self, "blob_properties", value)

    @property
    @pulumi.getter(name="crossTenantReplicationEnabled")
    def cross_tenant_replication_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should cross Tenant replication be enabled? Defaults to `false`.
        """
        return pulumi.get(self, "cross_tenant_replication_enabled")

    @cross_tenant_replication_enabled.setter
    def cross_tenant_replication_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "cross_tenant_replication_enabled", value)

    @property
    @pulumi.getter(name="customDomain")
    def custom_domain(self) -> Optional[pulumi.Input['AccountCustomDomainArgs']]:
        """
        A `custom_domain` block as documented below.
        """
        return pulumi.get(self, "custom_domain")

    @custom_domain.setter
    def custom_domain(self, value: Optional[pulumi.Input['AccountCustomDomainArgs']]):
        pulumi.set(self, "custom_domain", value)

    @property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> Optional[pulumi.Input['AccountCustomerManagedKeyArgs']]:
        """
        A `customer_managed_key` block as documented below.

        > **Note:** It's possible to define a Customer Managed Key both within either the `customer_managed_key` block or by using the `storage.CustomerManagedKey` resource. However, it's not possible to use both methods to manage a Customer Managed Key for a Storage Account, since these will conflict. When using the `storage.CustomerManagedKey` resource, you will need to use `ignore_changes` on the `customer_managed_key` block.
        """
        return pulumi.get(self, "customer_managed_key")

    @customer_managed_key.setter
    def customer_managed_key(self, value: Optional[pulumi.Input['AccountCustomerManagedKeyArgs']]):
        pulumi.set(self, "customer_managed_key", value)

    @property
    @pulumi.getter(name="defaultToOauthAuthentication")
    def default_to_oauth_authentication(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Default to Azure Active Directory authorization in the Azure portal when accessing the Storage Account. The default value is `false`
        """
        return pulumi.get(self, "default_to_oauth_authentication")

    @default_to_oauth_authentication.setter
    def default_to_oauth_authentication(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "default_to_oauth_authentication", value)

    @property
    @pulumi.getter(name="dnsEndpointType")
    def dns_endpoint_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies which DNS endpoint type to use. Possible values are `Standard` and `AzureDnsZone`. Defaults to `Standard`. Changing this forces a new resource to be created.

        > **Note:** Azure DNS zone support requires `PartitionedDns` feature to be enabled. To enable this feature for your subscription, use the following command: `az feature register --namespace "Microsoft.Storage" --name "PartitionedDns"`.
        """
        return pulumi.get(self, "dns_endpoint_type")

    @dns_endpoint_type.setter
    def dns_endpoint_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dns_endpoint_type", value)

    @property
    @pulumi.getter(name="edgeZone")
    def edge_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Edge Zone within the Azure Region where this Storage Account should exist. Changing this forces a new Storage Account to be created.
        """
        return pulumi.get(self, "edge_zone")

    @edge_zone.setter
    def edge_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "edge_zone", value)

    @property
    @pulumi.getter(name="httpsTrafficOnlyEnabled")
    def https_traffic_only_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean flag which forces HTTPS if enabled, see [here](https://docs.microsoft.com/azure/storage/storage-require-secure-transfer/) for more information. Defaults to `true`.
        """
        return pulumi.get(self, "https_traffic_only_enabled")

    @https_traffic_only_enabled.setter
    def https_traffic_only_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "https_traffic_only_enabled", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['AccountIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['AccountIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="immutabilityPolicy")
    def immutability_policy(self) -> Optional[pulumi.Input['AccountImmutabilityPolicyArgs']]:
        """
        An `immutability_policy` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "immutability_policy")

    @immutability_policy.setter
    def immutability_policy(self, value: Optional[pulumi.Input['AccountImmutabilityPolicyArgs']]):
        pulumi.set(self, "immutability_policy", value)

    @property
    @pulumi.getter(name="infrastructureEncryptionEnabled")
    def infrastructure_encryption_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is infrastructure encryption enabled? Changing this forces a new resource to be created. Defaults to `false`.

        > **Note:** This can only be `true` when `account_kind` is `StorageV2` or when `account_tier` is `Premium` *and* `account_kind` is one of `BlockBlobStorage` or `FileStorage`.
        """
        return pulumi.get(self, "infrastructure_encryption_enabled")

    @infrastructure_encryption_enabled.setter
    def infrastructure_encryption_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "infrastructure_encryption_enabled", value)

    @property
    @pulumi.getter(name="isHnsEnabled")
    def is_hns_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is Hierarchical Namespace enabled? This can be used with Azure Data Lake Storage Gen 2 ([see here for more information](https://docs.microsoft.com/azure/storage/blobs/data-lake-storage-quickstart-create-account/)). Changing this forces a new resource to be created.

        > **Note:** This can only be `true` when `account_tier` is `Standard` or when `account_tier` is `Premium` *and* `account_kind` is `BlockBlobStorage`
        """
        return pulumi.get(self, "is_hns_enabled")

    @is_hns_enabled.setter
    def is_hns_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_hns_enabled", value)

    @property
    @pulumi.getter(name="largeFileShareEnabled")
    def large_file_share_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Are Large File Shares Enabled? Defaults to `false`.

        > **Note:** Large File Shares are enabled by default when using an `account_kind` of `FileStorage`.
        """
        return pulumi.get(self, "large_file_share_enabled")

    @large_file_share_enabled.setter
    def large_file_share_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "large_file_share_enabled", value)

    @property
    @pulumi.getter(name="localUserEnabled")
    def local_user_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is Local User Enabled? Defaults to `true`.
        """
        return pulumi.get(self, "local_user_enabled")

    @local_user_enabled.setter
    def local_user_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "local_user_enabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The minimum supported TLS version for the storage account. Possible values are `TLS1_0`, `TLS1_1`, and `TLS1_2`. Defaults to `TLS1_2` for new storage accounts.

        > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.

        > **Note:** At this time `min_tls_version` is only supported in the Public Cloud, China Cloud, and US Government Cloud.
        """
        return pulumi.get(self, "min_tls_version")

    @min_tls_version.setter
    def min_tls_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "min_tls_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the storage account. Only lowercase Alphanumeric characters allowed. Changing this forces a new resource to be created. This must be unique across the entire Azure service, not just within the resource group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkRules")
    def network_rules(self) -> Optional[pulumi.Input['AccountNetworkRulesArgs']]:
        """
        A `network_rules` block as documented below.
        """
        return pulumi.get(self, "network_rules")

    @network_rules.setter
    def network_rules(self, value: Optional[pulumi.Input['AccountNetworkRulesArgs']]):
        pulumi.set(self, "network_rules", value)

    @property
    @pulumi.getter(name="nfsv3Enabled")
    def nfsv3_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is NFSv3 protocol enabled? Changing this forces a new resource to be created. Defaults to `false`.

        > **Note:** This can only be `true` when `account_tier` is `Standard` and `account_kind` is `StorageV2`, or `account_tier` is `Premium` and `account_kind` is `BlockBlobStorage`. Additionally, the `is_hns_enabled` is `true` and `account_replication_type` must be `LRS` or `RAGRS`.
        """
        return pulumi.get(self, "nfsv3_enabled")

    @nfsv3_enabled.setter
    def nfsv3_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "nfsv3_enabled", value)

    @property
    @pulumi.getter(name="primaryAccessKey")
    def primary_access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The primary access key for the storage account.
        """
        return pulumi.get(self, "primary_access_key")

    @primary_access_key.setter
    def primary_access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_access_key", value)

    @property
    @pulumi.getter(name="primaryBlobConnectionString")
    def primary_blob_connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The connection string associated with the primary blob location.
        """
        return pulumi.get(self, "primary_blob_connection_string")

    @primary_blob_connection_string.setter
    def primary_blob_connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_blob_connection_string", value)

    @property
    @pulumi.getter(name="primaryBlobEndpoint")
    def primary_blob_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint URL for blob storage in the primary location.
        """
        return pulumi.get(self, "primary_blob_endpoint")

    @primary_blob_endpoint.setter
    def primary_blob_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_blob_endpoint", value)

    @property
    @pulumi.getter(name="primaryBlobHost")
    def primary_blob_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname with port if applicable for blob storage in the primary location.
        """
        return pulumi.get(self, "primary_blob_host")

    @primary_blob_host.setter
    def primary_blob_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_blob_host", value)

    @property
    @pulumi.getter(name="primaryBlobInternetEndpoint")
    def primary_blob_internet_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The internet routing endpoint URL for blob storage in the primary location.
        """
        return pulumi.get(self, "primary_blob_internet_endpoint")

    @primary_blob_internet_endpoint.setter
    def primary_blob_internet_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_blob_internet_endpoint", value)

    @property
    @pulumi.getter(name="primaryBlobInternetHost")
    def primary_blob_internet_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The internet routing hostname with port if applicable for blob storage in the primary location.
        """
        return pulumi.get(self, "primary_blob_internet_host")

    @primary_blob_internet_host.setter
    def primary_blob_internet_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_blob_internet_host", value)

    @property
    @pulumi.getter(name="primaryBlobMicrosoftEndpoint")
    def primary_blob_microsoft_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The microsoft routing endpoint URL for blob storage in the primary location.
        """
        return pulumi.get(self, "primary_blob_microsoft_endpoint")

    @primary_blob_microsoft_endpoint.setter
    def primary_blob_microsoft_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_blob_microsoft_endpoint", value)

    @property
    @pulumi.getter(name="primaryBlobMicrosoftHost")
    def primary_blob_microsoft_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The microsoft routing hostname with port if applicable for blob storage in the primary location.
        """
        return pulumi.get(self, "primary_blob_microsoft_host")

    @primary_blob_microsoft_host.setter
    def primary_blob_microsoft_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_blob_microsoft_host", value)

    @property
    @pulumi.getter(name="primaryConnectionString")
    def primary_connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The connection string associated with the primary location.
        """
        return pulumi.get(self, "primary_connection_string")

    @primary_connection_string.setter
    def primary_connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_connection_string", value)

    @property
    @pulumi.getter(name="primaryDfsEndpoint")
    def primary_dfs_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint URL for DFS storage in the primary location.
        """
        return pulumi.get(self, "primary_dfs_endpoint")

    @primary_dfs_endpoint.setter
    def primary_dfs_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_dfs_endpoint", value)

    @property
    @pulumi.getter(name="primaryDfsHost")
    def primary_dfs_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname with port if applicable for DFS storage in the primary location.
        """
        return pulumi.get(self, "primary_dfs_host")

    @primary_dfs_host.setter
    def primary_dfs_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_dfs_host", value)

    @property
    @pulumi.getter(name="primaryDfsInternetEndpoint")
    def primary_dfs_internet_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The internet routing endpoint URL for DFS storage in the primary location.
        """
        return pulumi.get(self, "primary_dfs_internet_endpoint")

    @primary_dfs_internet_endpoint.setter
    def primary_dfs_internet_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_dfs_internet_endpoint", value)

    @property
    @pulumi.getter(name="primaryDfsInternetHost")
    def primary_dfs_internet_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The internet routing hostname with port if applicable for DFS storage in the primary location.
        """
        return pulumi.get(self, "primary_dfs_internet_host")

    @primary_dfs_internet_host.setter
    def primary_dfs_internet_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_dfs_internet_host", value)

    @property
    @pulumi.getter(name="primaryDfsMicrosoftEndpoint")
    def primary_dfs_microsoft_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The microsoft routing endpoint URL for DFS storage in the primary location.
        """
        return pulumi.get(self, "primary_dfs_microsoft_endpoint")

    @primary_dfs_microsoft_endpoint.setter
    def primary_dfs_microsoft_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_dfs_microsoft_endpoint", value)

    @property
    @pulumi.getter(name="primaryDfsMicrosoftHost")
    def primary_dfs_microsoft_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The microsoft routing hostname with port if applicable for DFS storage in the primary location.
        """
        return pulumi.get(self, "primary_dfs_microsoft_host")

    @primary_dfs_microsoft_host.setter
    def primary_dfs_microsoft_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_dfs_microsoft_host", value)

    @property
    @pulumi.getter(name="primaryFileEndpoint")
    def primary_file_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint URL for file storage in the primary location.
        """
        return pulumi.get(self, "primary_file_endpoint")

    @primary_file_endpoint.setter
    def primary_file_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_file_endpoint", value)

    @property
    @pulumi.getter(name="primaryFileHost")
    def primary_file_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname with port if applicable for file storage in the primary location.
        """
        return pulumi.get(self, "primary_file_host")

    @primary_file_host.setter
    def primary_file_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_file_host", value)

    @property
    @pulumi.getter(name="primaryFileInternetEndpoint")
    def primary_file_internet_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The internet routing endpoint URL for file storage in the primary location.
        """
        return pulumi.get(self, "primary_file_internet_endpoint")

    @primary_file_internet_endpoint.setter
    def primary_file_internet_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_file_internet_endpoint", value)

    @property
    @pulumi.getter(name="primaryFileInternetHost")
    def primary_file_internet_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The internet routing hostname with port if applicable for file storage in the primary location.
        """
        return pulumi.get(self, "primary_file_internet_host")

    @primary_file_internet_host.setter
    def primary_file_internet_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_file_internet_host", value)

    @property
    @pulumi.getter(name="primaryFileMicrosoftEndpoint")
    def primary_file_microsoft_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The microsoft routing endpoint URL for file storage in the primary location.
        """
        return pulumi.get(self, "primary_file_microsoft_endpoint")

    @primary_file_microsoft_endpoint.setter
    def primary_file_microsoft_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_file_microsoft_endpoint", value)

    @property
    @pulumi.getter(name="primaryFileMicrosoftHost")
    def primary_file_microsoft_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The microsoft routing hostname with port if applicable for file storage in the primary location.
        """
        return pulumi.get(self, "primary_file_microsoft_host")

    @primary_file_microsoft_host.setter
    def primary_file_microsoft_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_file_microsoft_host", value)

    @property
    @pulumi.getter(name="primaryLocation")
    def primary_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The primary location of the storage account.
        """
        return pulumi.get(self, "primary_location")

    @primary_location.setter
    def primary_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_location", value)

    @property
    @pulumi.getter(name="primaryQueueEndpoint")
    def primary_queue_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint URL for queue storage in the primary location.
        """
        return pulumi.get(self, "primary_queue_endpoint")

    @primary_queue_endpoint.setter
    def primary_queue_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_queue_endpoint", value)

    @property
    @pulumi.getter(name="primaryQueueHost")
    def primary_queue_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname with port if applicable for queue storage in the primary location.
        """
        return pulumi.get(self, "primary_queue_host")

    @primary_queue_host.setter
    def primary_queue_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_queue_host", value)

    @property
    @pulumi.getter(name="primaryQueueMicrosoftEndpoint")
    def primary_queue_microsoft_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The microsoft routing endpoint URL for queue storage in the primary location.
        """
        return pulumi.get(self, "primary_queue_microsoft_endpoint")

    @primary_queue_microsoft_endpoint.setter
    def primary_queue_microsoft_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_queue_microsoft_endpoint", value)

    @property
    @pulumi.getter(name="primaryQueueMicrosoftHost")
    def primary_queue_microsoft_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The microsoft routing hostname with port if applicable for queue storage in the primary location.
        """
        return pulumi.get(self, "primary_queue_microsoft_host")

    @primary_queue_microsoft_host.setter
    def primary_queue_microsoft_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_queue_microsoft_host", value)

    @property
    @pulumi.getter(name="primaryTableEndpoint")
    def primary_table_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint URL for table storage in the primary location.
        """
        return pulumi.get(self, "primary_table_endpoint")

    @primary_table_endpoint.setter
    def primary_table_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_table_endpoint", value)

    @property
    @pulumi.getter(name="primaryTableHost")
    def primary_table_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname with port if applicable for table storage in the primary location.
        """
        return pulumi.get(self, "primary_table_host")

    @primary_table_host.setter
    def primary_table_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_table_host", value)

    @property
    @pulumi.getter(name="primaryTableMicrosoftEndpoint")
    def primary_table_microsoft_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The microsoft routing endpoint URL for table storage in the primary location.
        """
        return pulumi.get(self, "primary_table_microsoft_endpoint")

    @primary_table_microsoft_endpoint.setter
    def primary_table_microsoft_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_table_microsoft_endpoint", value)

    @property
    @pulumi.getter(name="primaryTableMicrosoftHost")
    def primary_table_microsoft_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The microsoft routing hostname with port if applicable for table storage in the primary location.
        """
        return pulumi.get(self, "primary_table_microsoft_host")

    @primary_table_microsoft_host.setter
    def primary_table_microsoft_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_table_microsoft_host", value)

    @property
    @pulumi.getter(name="primaryWebEndpoint")
    def primary_web_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint URL for web storage in the primary location.
        """
        return pulumi.get(self, "primary_web_endpoint")

    @primary_web_endpoint.setter
    def primary_web_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_web_endpoint", value)

    @property
    @pulumi.getter(name="primaryWebHost")
    def primary_web_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname with port if applicable for web storage in the primary location.
        """
        return pulumi.get(self, "primary_web_host")

    @primary_web_host.setter
    def primary_web_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_web_host", value)

    @property
    @pulumi.getter(name="primaryWebInternetEndpoint")
    def primary_web_internet_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The internet routing endpoint URL for web storage in the primary location.
        """
        return pulumi.get(self, "primary_web_internet_endpoint")

    @primary_web_internet_endpoint.setter
    def primary_web_internet_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_web_internet_endpoint", value)

    @property
    @pulumi.getter(name="primaryWebInternetHost")
    def primary_web_internet_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The internet routing hostname with port if applicable for web storage in the primary location.
        """
        return pulumi.get(self, "primary_web_internet_host")

    @primary_web_internet_host.setter
    def primary_web_internet_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_web_internet_host", value)

    @property
    @pulumi.getter(name="primaryWebMicrosoftEndpoint")
    def primary_web_microsoft_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The microsoft routing endpoint URL for web storage in the primary location.
        """
        return pulumi.get(self, "primary_web_microsoft_endpoint")

    @primary_web_microsoft_endpoint.setter
    def primary_web_microsoft_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_web_microsoft_endpoint", value)

    @property
    @pulumi.getter(name="primaryWebMicrosoftHost")
    def primary_web_microsoft_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The microsoft routing hostname with port if applicable for web storage in the primary location.
        """
        return pulumi.get(self, "primary_web_microsoft_host")

    @primary_web_microsoft_host.setter
    def primary_web_microsoft_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_web_microsoft_host", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the public network access is enabled? Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter(name="queueEncryptionKeyType")
    def queue_encryption_key_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The encryption type of the queue service. Possible values are `Service` and `Account`. Changing this forces a new resource to be created. Default value is `Service`.
        """
        return pulumi.get(self, "queue_encryption_key_type")

    @queue_encryption_key_type.setter
    def queue_encryption_key_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "queue_encryption_key_type", value)

    @property
    @pulumi.getter(name="queueProperties")
    @_utilities.deprecated("""this block has been deprecated and superseded by the `storage.AccountQueueProperties` resource and will be removed in v5.0 of the AzureRM provider""")
    def queue_properties(self) -> Optional[pulumi.Input['AccountQueuePropertiesArgs']]:
        """
        A `queue_properties` block as defined below.

        > **Note:** `queue_properties` can only be configured when `account_tier` is set to `Standard` and `account_kind` is set to either `Storage` or `StorageV2`.
        """
        return pulumi.get(self, "queue_properties")

    @queue_properties.setter
    def queue_properties(self, value: Optional[pulumi.Input['AccountQueuePropertiesArgs']]):
        pulumi.set(self, "queue_properties", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group in which to create the storage account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def routing(self) -> Optional[pulumi.Input['AccountRoutingArgs']]:
        """
        A `routing` block as defined below.
        """
        return pulumi.get(self, "routing")

    @routing.setter
    def routing(self, value: Optional[pulumi.Input['AccountRoutingArgs']]):
        pulumi.set(self, "routing", value)

    @property
    @pulumi.getter(name="sasPolicy")
    def sas_policy(self) -> Optional[pulumi.Input['AccountSasPolicyArgs']]:
        """
        A `sas_policy` block as defined below.
        """
        return pulumi.get(self, "sas_policy")

    @sas_policy.setter
    def sas_policy(self, value: Optional[pulumi.Input['AccountSasPolicyArgs']]):
        pulumi.set(self, "sas_policy", value)

    @property
    @pulumi.getter(name="secondaryAccessKey")
    def secondary_access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The secondary access key for the storage account.
        """
        return pulumi.get(self, "secondary_access_key")

    @secondary_access_key.setter
    def secondary_access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_access_key", value)

    @property
    @pulumi.getter(name="secondaryBlobConnectionString")
    def secondary_blob_connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The connection string associated with the secondary blob location.
        """
        return pulumi.get(self, "secondary_blob_connection_string")

    @secondary_blob_connection_string.setter
    def secondary_blob_connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_blob_connection_string", value)

    @property
    @pulumi.getter(name="secondaryBlobEndpoint")
    def secondary_blob_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint URL for blob storage in the secondary location.
        """
        return pulumi.get(self, "secondary_blob_endpoint")

    @secondary_blob_endpoint.setter
    def secondary_blob_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_blob_endpoint", value)

    @property
    @pulumi.getter(name="secondaryBlobHost")
    def secondary_blob_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname with port if applicable for blob storage in the secondary location.
        """
        return pulumi.get(self, "secondary_blob_host")

    @secondary_blob_host.setter
    def secondary_blob_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_blob_host", value)

    @property
    @pulumi.getter(name="secondaryBlobInternetEndpoint")
    def secondary_blob_internet_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The internet routing endpoint URL for blob storage in the secondary location.
        """
        return pulumi.get(self, "secondary_blob_internet_endpoint")

    @secondary_blob_internet_endpoint.setter
    def secondary_blob_internet_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_blob_internet_endpoint", value)

    @property
    @pulumi.getter(name="secondaryBlobInternetHost")
    def secondary_blob_internet_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The internet routing hostname with port if applicable for blob storage in the secondary location.
        """
        return pulumi.get(self, "secondary_blob_internet_host")

    @secondary_blob_internet_host.setter
    def secondary_blob_internet_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_blob_internet_host", value)

    @property
    @pulumi.getter(name="secondaryBlobMicrosoftEndpoint")
    def secondary_blob_microsoft_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The microsoft routing endpoint URL for blob storage in the secondary location.
        """
        return pulumi.get(self, "secondary_blob_microsoft_endpoint")

    @secondary_blob_microsoft_endpoint.setter
    def secondary_blob_microsoft_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_blob_microsoft_endpoint", value)

    @property
    @pulumi.getter(name="secondaryBlobMicrosoftHost")
    def secondary_blob_microsoft_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The microsoft routing hostname with port if applicable for blob storage in the secondary location.
        """
        return pulumi.get(self, "secondary_blob_microsoft_host")

    @secondary_blob_microsoft_host.setter
    def secondary_blob_microsoft_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_blob_microsoft_host", value)

    @property
    @pulumi.getter(name="secondaryConnectionString")
    def secondary_connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The connection string associated with the secondary location.
        """
        return pulumi.get(self, "secondary_connection_string")

    @secondary_connection_string.setter
    def secondary_connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_connection_string", value)

    @property
    @pulumi.getter(name="secondaryDfsEndpoint")
    def secondary_dfs_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint URL for DFS storage in the secondary location.
        """
        return pulumi.get(self, "secondary_dfs_endpoint")

    @secondary_dfs_endpoint.setter
    def secondary_dfs_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_dfs_endpoint", value)

    @property
    @pulumi.getter(name="secondaryDfsHost")
    def secondary_dfs_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname with port if applicable for DFS storage in the secondary location.
        """
        return pulumi.get(self, "secondary_dfs_host")

    @secondary_dfs_host.setter
    def secondary_dfs_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_dfs_host", value)

    @property
    @pulumi.getter(name="secondaryDfsInternetEndpoint")
    def secondary_dfs_internet_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The internet routing endpoint URL for DFS storage in the secondary location.
        """
        return pulumi.get(self, "secondary_dfs_internet_endpoint")

    @secondary_dfs_internet_endpoint.setter
    def secondary_dfs_internet_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_dfs_internet_endpoint", value)

    @property
    @pulumi.getter(name="secondaryDfsInternetHost")
    def secondary_dfs_internet_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The internet routing hostname with port if applicable for DFS storage in the secondary location.
        """
        return pulumi.get(self, "secondary_dfs_internet_host")

    @secondary_dfs_internet_host.setter
    def secondary_dfs_internet_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_dfs_internet_host", value)

    @property
    @pulumi.getter(name="secondaryDfsMicrosoftEndpoint")
    def secondary_dfs_microsoft_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The microsoft routing endpoint URL for DFS storage in the secondary location.
        """
        return pulumi.get(self, "secondary_dfs_microsoft_endpoint")

    @secondary_dfs_microsoft_endpoint.setter
    def secondary_dfs_microsoft_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_dfs_microsoft_endpoint", value)

    @property
    @pulumi.getter(name="secondaryDfsMicrosoftHost")
    def secondary_dfs_microsoft_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The microsoft routing hostname with port if applicable for DFS storage in the secondary location.
        """
        return pulumi.get(self, "secondary_dfs_microsoft_host")

    @secondary_dfs_microsoft_host.setter
    def secondary_dfs_microsoft_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_dfs_microsoft_host", value)

    @property
    @pulumi.getter(name="secondaryFileEndpoint")
    def secondary_file_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint URL for file storage in the secondary location.
        """
        return pulumi.get(self, "secondary_file_endpoint")

    @secondary_file_endpoint.setter
    def secondary_file_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_file_endpoint", value)

    @property
    @pulumi.getter(name="secondaryFileHost")
    def secondary_file_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname with port if applicable for file storage in the secondary location.
        """
        return pulumi.get(self, "secondary_file_host")

    @secondary_file_host.setter
    def secondary_file_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_file_host", value)

    @property
    @pulumi.getter(name="secondaryFileInternetEndpoint")
    def secondary_file_internet_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The internet routing endpoint URL for file storage in the secondary location.
        """
        return pulumi.get(self, "secondary_file_internet_endpoint")

    @secondary_file_internet_endpoint.setter
    def secondary_file_internet_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_file_internet_endpoint", value)

    @property
    @pulumi.getter(name="secondaryFileInternetHost")
    def secondary_file_internet_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The internet routing hostname with port if applicable for file storage in the secondary location.
        """
        return pulumi.get(self, "secondary_file_internet_host")

    @secondary_file_internet_host.setter
    def secondary_file_internet_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_file_internet_host", value)

    @property
    @pulumi.getter(name="secondaryFileMicrosoftEndpoint")
    def secondary_file_microsoft_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The microsoft routing endpoint URL for file storage in the secondary location.
        """
        return pulumi.get(self, "secondary_file_microsoft_endpoint")

    @secondary_file_microsoft_endpoint.setter
    def secondary_file_microsoft_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_file_microsoft_endpoint", value)

    @property
    @pulumi.getter(name="secondaryFileMicrosoftHost")
    def secondary_file_microsoft_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The microsoft routing hostname with port if applicable for file storage in the secondary location.
        """
        return pulumi.get(self, "secondary_file_microsoft_host")

    @secondary_file_microsoft_host.setter
    def secondary_file_microsoft_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_file_microsoft_host", value)

    @property
    @pulumi.getter(name="secondaryLocation")
    def secondary_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The secondary location of the storage account.
        """
        return pulumi.get(self, "secondary_location")

    @secondary_location.setter
    def secondary_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_location", value)

    @property
    @pulumi.getter(name="secondaryQueueEndpoint")
    def secondary_queue_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint URL for queue storage in the secondary location.
        """
        return pulumi.get(self, "secondary_queue_endpoint")

    @secondary_queue_endpoint.setter
    def secondary_queue_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_queue_endpoint", value)

    @property
    @pulumi.getter(name="secondaryQueueHost")
    def secondary_queue_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname with port if applicable for queue storage in the secondary location.
        """
        return pulumi.get(self, "secondary_queue_host")

    @secondary_queue_host.setter
    def secondary_queue_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_queue_host", value)

    @property
    @pulumi.getter(name="secondaryQueueMicrosoftEndpoint")
    def secondary_queue_microsoft_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The microsoft routing endpoint URL for queue storage in the secondary location.
        """
        return pulumi.get(self, "secondary_queue_microsoft_endpoint")

    @secondary_queue_microsoft_endpoint.setter
    def secondary_queue_microsoft_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_queue_microsoft_endpoint", value)

    @property
    @pulumi.getter(name="secondaryQueueMicrosoftHost")
    def secondary_queue_microsoft_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The microsoft routing hostname with port if applicable for queue storage in the secondary location.
        """
        return pulumi.get(self, "secondary_queue_microsoft_host")

    @secondary_queue_microsoft_host.setter
    def secondary_queue_microsoft_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_queue_microsoft_host", value)

    @property
    @pulumi.getter(name="secondaryTableEndpoint")
    def secondary_table_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint URL for table storage in the secondary location.
        """
        return pulumi.get(self, "secondary_table_endpoint")

    @secondary_table_endpoint.setter
    def secondary_table_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_table_endpoint", value)

    @property
    @pulumi.getter(name="secondaryTableHost")
    def secondary_table_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname with port if applicable for table storage in the secondary location.
        """
        return pulumi.get(self, "secondary_table_host")

    @secondary_table_host.setter
    def secondary_table_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_table_host", value)

    @property
    @pulumi.getter(name="secondaryTableMicrosoftEndpoint")
    def secondary_table_microsoft_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The microsoft routing endpoint URL for table storage in the secondary location.
        """
        return pulumi.get(self, "secondary_table_microsoft_endpoint")

    @secondary_table_microsoft_endpoint.setter
    def secondary_table_microsoft_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_table_microsoft_endpoint", value)

    @property
    @pulumi.getter(name="secondaryTableMicrosoftHost")
    def secondary_table_microsoft_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The microsoft routing hostname with port if applicable for table storage in the secondary location.
        """
        return pulumi.get(self, "secondary_table_microsoft_host")

    @secondary_table_microsoft_host.setter
    def secondary_table_microsoft_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_table_microsoft_host", value)

    @property
    @pulumi.getter(name="secondaryWebEndpoint")
    def secondary_web_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint URL for web storage in the secondary location.
        """
        return pulumi.get(self, "secondary_web_endpoint")

    @secondary_web_endpoint.setter
    def secondary_web_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_web_endpoint", value)

    @property
    @pulumi.getter(name="secondaryWebHost")
    def secondary_web_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname with port if applicable for web storage in the secondary location.
        """
        return pulumi.get(self, "secondary_web_host")

    @secondary_web_host.setter
    def secondary_web_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_web_host", value)

    @property
    @pulumi.getter(name="secondaryWebInternetEndpoint")
    def secondary_web_internet_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The internet routing endpoint URL for web storage in the secondary location.
        """
        return pulumi.get(self, "secondary_web_internet_endpoint")

    @secondary_web_internet_endpoint.setter
    def secondary_web_internet_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_web_internet_endpoint", value)

    @property
    @pulumi.getter(name="secondaryWebInternetHost")
    def secondary_web_internet_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The internet routing hostname with port if applicable for web storage in the secondary location.
        """
        return pulumi.get(self, "secondary_web_internet_host")

    @secondary_web_internet_host.setter
    def secondary_web_internet_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_web_internet_host", value)

    @property
    @pulumi.getter(name="secondaryWebMicrosoftEndpoint")
    def secondary_web_microsoft_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The microsoft routing endpoint URL for web storage in the secondary location.
        """
        return pulumi.get(self, "secondary_web_microsoft_endpoint")

    @secondary_web_microsoft_endpoint.setter
    def secondary_web_microsoft_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_web_microsoft_endpoint", value)

    @property
    @pulumi.getter(name="secondaryWebMicrosoftHost")
    def secondary_web_microsoft_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The microsoft routing hostname with port if applicable for web storage in the secondary location.
        """
        return pulumi.get(self, "secondary_web_microsoft_host")

    @secondary_web_microsoft_host.setter
    def secondary_web_microsoft_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_web_microsoft_host", value)

    @property
    @pulumi.getter(name="sftpEnabled")
    def sftp_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean, enable SFTP for the storage account

        > **Note:** SFTP support requires `is_hns_enabled` set to `true`. [More information on SFTP support can be found here](https://learn.microsoft.com/azure/storage/blobs/secure-file-transfer-protocol-support). Defaults to `false`
        """
        return pulumi.get(self, "sftp_enabled")

    @sftp_enabled.setter
    def sftp_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "sftp_enabled", value)

    @property
    @pulumi.getter(name="shareProperties")
    def share_properties(self) -> Optional[pulumi.Input['AccountSharePropertiesArgs']]:
        """
        A `share_properties` block as defined below.

        > **Note:** `share_properties` can only be configured when either `account_tier` is `Standard` and `account_kind` is either `Storage` or `StorageV2` - or when `account_tier` is `Premium` and `account_kind` is `FileStorage`.
        """
        return pulumi.get(self, "share_properties")

    @share_properties.setter
    def share_properties(self, value: Optional[pulumi.Input['AccountSharePropertiesArgs']]):
        pulumi.set(self, "share_properties", value)

    @property
    @pulumi.getter(name="sharedAccessKeyEnabled")
    def shared_access_key_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "shared_access_key_enabled")

    @shared_access_key_enabled.setter
    def shared_access_key_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "shared_access_key_enabled", value)

    @property
    @pulumi.getter(name="staticWebsite")
    @_utilities.deprecated("""this block has been deprecated and superseded by the `storage.AccountStaticWebsite` resource and will be removed in v5.0 of the AzureRM provider""")
    def static_website(self) -> Optional[pulumi.Input['AccountStaticWebsiteArgs']]:
        """
        A `static_website` block as defined below.

        > **Note:** `static_website` can only be set when the `account_kind` is set to `StorageV2` or `BlockBlobStorage`.

        > **Note:** If `static_website` is specified, the service will automatically create a `storage.Container` named `$web`.
        """
        return pulumi.get(self, "static_website")

    @static_website.setter
    def static_website(self, value: Optional[pulumi.Input['AccountStaticWebsiteArgs']]):
        pulumi.set(self, "static_website", value)

    @property
    @pulumi.getter(name="tableEncryptionKeyType")
    def table_encryption_key_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The encryption type of the table service. Possible values are `Service` and `Account`. Changing this forces a new resource to be created. Default value is `Service`.

        > **Note:** `queue_encryption_key_type` and `table_encryption_key_type` cannot be set to `Account` when `account_kind` is set `Storage`
        """
        return pulumi.get(self, "table_encryption_key_type")

    @table_encryption_key_type.setter
    def table_encryption_key_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "table_encryption_key_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:storage/account:Account")
class Account(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_tier: Optional[pulumi.Input[builtins.str]] = None,
                 account_kind: Optional[pulumi.Input[builtins.str]] = None,
                 account_replication_type: Optional[pulumi.Input[builtins.str]] = None,
                 account_tier: Optional[pulumi.Input[builtins.str]] = None,
                 allow_nested_items_to_be_public: Optional[pulumi.Input[builtins.bool]] = None,
                 allowed_copy_scope: Optional[pulumi.Input[builtins.str]] = None,
                 azure_files_authentication: Optional[pulumi.Input[Union['AccountAzureFilesAuthenticationArgs', 'AccountAzureFilesAuthenticationArgsDict']]] = None,
                 blob_properties: Optional[pulumi.Input[Union['AccountBlobPropertiesArgs', 'AccountBlobPropertiesArgsDict']]] = None,
                 cross_tenant_replication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 custom_domain: Optional[pulumi.Input[Union['AccountCustomDomainArgs', 'AccountCustomDomainArgsDict']]] = None,
                 customer_managed_key: Optional[pulumi.Input[Union['AccountCustomerManagedKeyArgs', 'AccountCustomerManagedKeyArgsDict']]] = None,
                 default_to_oauth_authentication: Optional[pulumi.Input[builtins.bool]] = None,
                 dns_endpoint_type: Optional[pulumi.Input[builtins.str]] = None,
                 edge_zone: Optional[pulumi.Input[builtins.str]] = None,
                 https_traffic_only_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['AccountIdentityArgs', 'AccountIdentityArgsDict']]] = None,
                 immutability_policy: Optional[pulumi.Input[Union['AccountImmutabilityPolicyArgs', 'AccountImmutabilityPolicyArgsDict']]] = None,
                 infrastructure_encryption_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_hns_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 large_file_share_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 local_user_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 min_tls_version: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_rules: Optional[pulumi.Input[Union['AccountNetworkRulesArgs', 'AccountNetworkRulesArgsDict']]] = None,
                 nfsv3_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 queue_encryption_key_type: Optional[pulumi.Input[builtins.str]] = None,
                 queue_properties: Optional[pulumi.Input[Union['AccountQueuePropertiesArgs', 'AccountQueuePropertiesArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing: Optional[pulumi.Input[Union['AccountRoutingArgs', 'AccountRoutingArgsDict']]] = None,
                 sas_policy: Optional[pulumi.Input[Union['AccountSasPolicyArgs', 'AccountSasPolicyArgsDict']]] = None,
                 sftp_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 share_properties: Optional[pulumi.Input[Union['AccountSharePropertiesArgs', 'AccountSharePropertiesArgsDict']]] = None,
                 shared_access_key_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 static_website: Optional[pulumi.Input[Union['AccountStaticWebsiteArgs', 'AccountStaticWebsiteArgsDict']]] = None,
                 table_encryption_key_type: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an Azure Storage Account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="storageaccountname",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="GRS",
            tags={
                "environment": "staging",
            })
        ```

        ### With Network Rules

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="virtnetname",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="subnetname",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"],
            service_endpoints=[
                "Microsoft.Sql",
                "Microsoft.Storage",
            ])
        example_account = azure.storage.Account("example",
            name="storageaccountname",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS",
            network_rules={
                "default_action": "Deny",
                "ip_rules": ["100.0.0.1"],
                "virtual_network_subnet_ids": [example_subnet.id],
            },
            tags={
                "environment": "staging",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Storage`: 2023-05-01

        ## Import

        Storage Accounts can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/account:Account storageAcc1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myresourcegroup/providers/Microsoft.Storage/storageAccounts/myaccount
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_tier: Defines the access tier for `BlobStorage`, `FileStorage` and `StorageV2` accounts. Valid options are `Hot`, `Cool`, `Cold` and `Premium`. Defaults to `Hot`.
        :param pulumi.Input[builtins.str] account_kind: Defines the Kind of account. Valid options are `BlobStorage`, `BlockBlobStorage`, `FileStorage`, `Storage` and `StorageV2`. Defaults to `StorageV2`.
               
               > **Note:** Changing the `account_kind` value from `Storage` to `StorageV2` will not trigger a force new on the storage account, it will only upgrade the existing storage account from `Storage` to `StorageV2` keeping the existing storage account in place.
        :param pulumi.Input[builtins.str] account_replication_type: Defines the type of replication to use for this storage account. Valid options are `LRS`, `GRS`, `RAGRS`, `ZRS`, `GZRS` and `RAGZRS`. Changing this forces a new resource to be created when types `LRS`, `GRS` and `RAGRS` are changed to `ZRS`, `GZRS` or `RAGZRS` and vice versa.
        :param pulumi.Input[builtins.str] account_tier: Defines the Tier to use for this storage account. Valid options are `Standard` and `Premium`. For `BlockBlobStorage` and `FileStorage` accounts only `Premium` is valid. Changing this forces a new resource to be created.
               
               > **Note:** Blobs with a tier of `Premium` are of account kind `StorageV2`.
        :param pulumi.Input[builtins.bool] allow_nested_items_to_be_public: Allow or disallow nested items within this Account to opt into being public. Defaults to `true`.
               
               > **Note:** At this time `allow_nested_items_to_be_public` is only supported in the Public Cloud, China Cloud, and US Government Cloud.
        :param pulumi.Input[builtins.str] allowed_copy_scope: Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet. Possible values are `AAD` and `PrivateLink`.
        :param pulumi.Input[Union['AccountAzureFilesAuthenticationArgs', 'AccountAzureFilesAuthenticationArgsDict']] azure_files_authentication: A `azure_files_authentication` block as defined below.
        :param pulumi.Input[Union['AccountBlobPropertiesArgs', 'AccountBlobPropertiesArgsDict']] blob_properties: A `blob_properties` block as defined below.
        :param pulumi.Input[builtins.bool] cross_tenant_replication_enabled: Should cross Tenant replication be enabled? Defaults to `false`.
        :param pulumi.Input[Union['AccountCustomDomainArgs', 'AccountCustomDomainArgsDict']] custom_domain: A `custom_domain` block as documented below.
        :param pulumi.Input[Union['AccountCustomerManagedKeyArgs', 'AccountCustomerManagedKeyArgsDict']] customer_managed_key: A `customer_managed_key` block as documented below.
               
               > **Note:** It's possible to define a Customer Managed Key both within either the `customer_managed_key` block or by using the `storage.CustomerManagedKey` resource. However, it's not possible to use both methods to manage a Customer Managed Key for a Storage Account, since these will conflict. When using the `storage.CustomerManagedKey` resource, you will need to use `ignore_changes` on the `customer_managed_key` block.
        :param pulumi.Input[builtins.bool] default_to_oauth_authentication: Default to Azure Active Directory authorization in the Azure portal when accessing the Storage Account. The default value is `false`
        :param pulumi.Input[builtins.str] dns_endpoint_type: Specifies which DNS endpoint type to use. Possible values are `Standard` and `AzureDnsZone`. Defaults to `Standard`. Changing this forces a new resource to be created.
               
               > **Note:** Azure DNS zone support requires `PartitionedDns` feature to be enabled. To enable this feature for your subscription, use the following command: `az feature register --namespace "Microsoft.Storage" --name "PartitionedDns"`.
        :param pulumi.Input[builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Storage Account should exist. Changing this forces a new Storage Account to be created.
        :param pulumi.Input[builtins.bool] https_traffic_only_enabled: Boolean flag which forces HTTPS if enabled, see [here](https://docs.microsoft.com/azure/storage/storage-require-secure-transfer/) for more information. Defaults to `true`.
        :param pulumi.Input[Union['AccountIdentityArgs', 'AccountIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[Union['AccountImmutabilityPolicyArgs', 'AccountImmutabilityPolicyArgsDict']] immutability_policy: An `immutability_policy` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] infrastructure_encryption_enabled: Is infrastructure encryption enabled? Changing this forces a new resource to be created. Defaults to `false`.
               
               > **Note:** This can only be `true` when `account_kind` is `StorageV2` or when `account_tier` is `Premium` *and* `account_kind` is one of `BlockBlobStorage` or `FileStorage`.
        :param pulumi.Input[builtins.bool] is_hns_enabled: Is Hierarchical Namespace enabled? This can be used with Azure Data Lake Storage Gen 2 ([see here for more information](https://docs.microsoft.com/azure/storage/blobs/data-lake-storage-quickstart-create-account/)). Changing this forces a new resource to be created.
               
               > **Note:** This can only be `true` when `account_tier` is `Standard` or when `account_tier` is `Premium` *and* `account_kind` is `BlockBlobStorage`
        :param pulumi.Input[builtins.bool] large_file_share_enabled: Are Large File Shares Enabled? Defaults to `false`.
               
               > **Note:** Large File Shares are enabled by default when using an `account_kind` of `FileStorage`.
        :param pulumi.Input[builtins.bool] local_user_enabled: Is Local User Enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] min_tls_version: The minimum supported TLS version for the storage account. Possible values are `TLS1_0`, `TLS1_1`, and `TLS1_2`. Defaults to `TLS1_2` for new storage accounts.
               
               > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
               
               > **Note:** At this time `min_tls_version` is only supported in the Public Cloud, China Cloud, and US Government Cloud.
        :param pulumi.Input[builtins.str] name: Specifies the name of the storage account. Only lowercase Alphanumeric characters allowed. Changing this forces a new resource to be created. This must be unique across the entire Azure service, not just within the resource group.
        :param pulumi.Input[Union['AccountNetworkRulesArgs', 'AccountNetworkRulesArgsDict']] network_rules: A `network_rules` block as documented below.
        :param pulumi.Input[builtins.bool] nfsv3_enabled: Is NFSv3 protocol enabled? Changing this forces a new resource to be created. Defaults to `false`.
               
               > **Note:** This can only be `true` when `account_tier` is `Standard` and `account_kind` is `StorageV2`, or `account_tier` is `Premium` and `account_kind` is `BlockBlobStorage`. Additionally, the `is_hns_enabled` is `true` and `account_replication_type` must be `LRS` or `RAGRS`.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Whether the public network access is enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] queue_encryption_key_type: The encryption type of the queue service. Possible values are `Service` and `Account`. Changing this forces a new resource to be created. Default value is `Service`.
        :param pulumi.Input[Union['AccountQueuePropertiesArgs', 'AccountQueuePropertiesArgsDict']] queue_properties: A `queue_properties` block as defined below.
               
               > **Note:** `queue_properties` can only be configured when `account_tier` is set to `Standard` and `account_kind` is set to either `Storage` or `StorageV2`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the storage account. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['AccountRoutingArgs', 'AccountRoutingArgsDict']] routing: A `routing` block as defined below.
        :param pulumi.Input[Union['AccountSasPolicyArgs', 'AccountSasPolicyArgsDict']] sas_policy: A `sas_policy` block as defined below.
        :param pulumi.Input[builtins.bool] sftp_enabled: Boolean, enable SFTP for the storage account
               
               > **Note:** SFTP support requires `is_hns_enabled` set to `true`. [More information on SFTP support can be found here](https://learn.microsoft.com/azure/storage/blobs/secure-file-transfer-protocol-support). Defaults to `false`
        :param pulumi.Input[Union['AccountSharePropertiesArgs', 'AccountSharePropertiesArgsDict']] share_properties: A `share_properties` block as defined below.
               
               > **Note:** `share_properties` can only be configured when either `account_tier` is `Standard` and `account_kind` is either `Storage` or `StorageV2` - or when `account_tier` is `Premium` and `account_kind` is `FileStorage`.
        :param pulumi.Input[Union['AccountStaticWebsiteArgs', 'AccountStaticWebsiteArgsDict']] static_website: A `static_website` block as defined below.
               
               > **Note:** `static_website` can only be set when the `account_kind` is set to `StorageV2` or `BlockBlobStorage`.
               
               > **Note:** If `static_website` is specified, the service will automatically create a `storage.Container` named `$web`.
        :param pulumi.Input[builtins.str] table_encryption_key_type: The encryption type of the table service. Possible values are `Service` and `Account`. Changing this forces a new resource to be created. Default value is `Service`.
               
               > **Note:** `queue_encryption_key_type` and `table_encryption_key_type` cannot be set to `Account` when `account_kind` is set `Storage`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Storage Account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="storageaccountname",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="GRS",
            tags={
                "environment": "staging",
            })
        ```

        ### With Network Rules

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="virtnetname",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="subnetname",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"],
            service_endpoints=[
                "Microsoft.Sql",
                "Microsoft.Storage",
            ])
        example_account = azure.storage.Account("example",
            name="storageaccountname",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS",
            network_rules={
                "default_action": "Deny",
                "ip_rules": ["100.0.0.1"],
                "virtual_network_subnet_ids": [example_subnet.id],
            },
            tags={
                "environment": "staging",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Storage`: 2023-05-01

        ## Import

        Storage Accounts can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/account:Account storageAcc1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myresourcegroup/providers/Microsoft.Storage/storageAccounts/myaccount
        ```

        :param str resource_name: The name of the resource.
        :param AccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_tier: Optional[pulumi.Input[builtins.str]] = None,
                 account_kind: Optional[pulumi.Input[builtins.str]] = None,
                 account_replication_type: Optional[pulumi.Input[builtins.str]] = None,
                 account_tier: Optional[pulumi.Input[builtins.str]] = None,
                 allow_nested_items_to_be_public: Optional[pulumi.Input[builtins.bool]] = None,
                 allowed_copy_scope: Optional[pulumi.Input[builtins.str]] = None,
                 azure_files_authentication: Optional[pulumi.Input[Union['AccountAzureFilesAuthenticationArgs', 'AccountAzureFilesAuthenticationArgsDict']]] = None,
                 blob_properties: Optional[pulumi.Input[Union['AccountBlobPropertiesArgs', 'AccountBlobPropertiesArgsDict']]] = None,
                 cross_tenant_replication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 custom_domain: Optional[pulumi.Input[Union['AccountCustomDomainArgs', 'AccountCustomDomainArgsDict']]] = None,
                 customer_managed_key: Optional[pulumi.Input[Union['AccountCustomerManagedKeyArgs', 'AccountCustomerManagedKeyArgsDict']]] = None,
                 default_to_oauth_authentication: Optional[pulumi.Input[builtins.bool]] = None,
                 dns_endpoint_type: Optional[pulumi.Input[builtins.str]] = None,
                 edge_zone: Optional[pulumi.Input[builtins.str]] = None,
                 https_traffic_only_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['AccountIdentityArgs', 'AccountIdentityArgsDict']]] = None,
                 immutability_policy: Optional[pulumi.Input[Union['AccountImmutabilityPolicyArgs', 'AccountImmutabilityPolicyArgsDict']]] = None,
                 infrastructure_encryption_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_hns_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 large_file_share_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 local_user_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 min_tls_version: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_rules: Optional[pulumi.Input[Union['AccountNetworkRulesArgs', 'AccountNetworkRulesArgsDict']]] = None,
                 nfsv3_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 queue_encryption_key_type: Optional[pulumi.Input[builtins.str]] = None,
                 queue_properties: Optional[pulumi.Input[Union['AccountQueuePropertiesArgs', 'AccountQueuePropertiesArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing: Optional[pulumi.Input[Union['AccountRoutingArgs', 'AccountRoutingArgsDict']]] = None,
                 sas_policy: Optional[pulumi.Input[Union['AccountSasPolicyArgs', 'AccountSasPolicyArgsDict']]] = None,
                 sftp_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 share_properties: Optional[pulumi.Input[Union['AccountSharePropertiesArgs', 'AccountSharePropertiesArgsDict']]] = None,
                 shared_access_key_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 static_website: Optional[pulumi.Input[Union['AccountStaticWebsiteArgs', 'AccountStaticWebsiteArgsDict']]] = None,
                 table_encryption_key_type: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountArgs.__new__(AccountArgs)

            __props__.__dict__["access_tier"] = access_tier
            __props__.__dict__["account_kind"] = account_kind
            if account_replication_type is None and not opts.urn:
                raise TypeError("Missing required property 'account_replication_type'")
            __props__.__dict__["account_replication_type"] = account_replication_type
            if account_tier is None and not opts.urn:
                raise TypeError("Missing required property 'account_tier'")
            __props__.__dict__["account_tier"] = account_tier
            __props__.__dict__["allow_nested_items_to_be_public"] = allow_nested_items_to_be_public
            __props__.__dict__["allowed_copy_scope"] = allowed_copy_scope
            __props__.__dict__["azure_files_authentication"] = azure_files_authentication
            __props__.__dict__["blob_properties"] = blob_properties
            __props__.__dict__["cross_tenant_replication_enabled"] = cross_tenant_replication_enabled
            __props__.__dict__["custom_domain"] = custom_domain
            __props__.__dict__["customer_managed_key"] = customer_managed_key
            __props__.__dict__["default_to_oauth_authentication"] = default_to_oauth_authentication
            __props__.__dict__["dns_endpoint_type"] = dns_endpoint_type
            __props__.__dict__["edge_zone"] = edge_zone
            __props__.__dict__["https_traffic_only_enabled"] = https_traffic_only_enabled
            __props__.__dict__["identity"] = identity
            __props__.__dict__["immutability_policy"] = immutability_policy
            __props__.__dict__["infrastructure_encryption_enabled"] = infrastructure_encryption_enabled
            __props__.__dict__["is_hns_enabled"] = is_hns_enabled
            __props__.__dict__["large_file_share_enabled"] = large_file_share_enabled
            __props__.__dict__["local_user_enabled"] = local_user_enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["min_tls_version"] = min_tls_version
            __props__.__dict__["name"] = name
            __props__.__dict__["network_rules"] = network_rules
            __props__.__dict__["nfsv3_enabled"] = nfsv3_enabled
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            __props__.__dict__["queue_encryption_key_type"] = queue_encryption_key_type
            __props__.__dict__["queue_properties"] = queue_properties
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["routing"] = routing
            __props__.__dict__["sas_policy"] = sas_policy
            __props__.__dict__["sftp_enabled"] = sftp_enabled
            __props__.__dict__["share_properties"] = share_properties
            __props__.__dict__["shared_access_key_enabled"] = shared_access_key_enabled
            __props__.__dict__["static_website"] = static_website
            __props__.__dict__["table_encryption_key_type"] = table_encryption_key_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["primary_access_key"] = None
            __props__.__dict__["primary_blob_connection_string"] = None
            __props__.__dict__["primary_blob_endpoint"] = None
            __props__.__dict__["primary_blob_host"] = None
            __props__.__dict__["primary_blob_internet_endpoint"] = None
            __props__.__dict__["primary_blob_internet_host"] = None
            __props__.__dict__["primary_blob_microsoft_endpoint"] = None
            __props__.__dict__["primary_blob_microsoft_host"] = None
            __props__.__dict__["primary_connection_string"] = None
            __props__.__dict__["primary_dfs_endpoint"] = None
            __props__.__dict__["primary_dfs_host"] = None
            __props__.__dict__["primary_dfs_internet_endpoint"] = None
            __props__.__dict__["primary_dfs_internet_host"] = None
            __props__.__dict__["primary_dfs_microsoft_endpoint"] = None
            __props__.__dict__["primary_dfs_microsoft_host"] = None
            __props__.__dict__["primary_file_endpoint"] = None
            __props__.__dict__["primary_file_host"] = None
            __props__.__dict__["primary_file_internet_endpoint"] = None
            __props__.__dict__["primary_file_internet_host"] = None
            __props__.__dict__["primary_file_microsoft_endpoint"] = None
            __props__.__dict__["primary_file_microsoft_host"] = None
            __props__.__dict__["primary_location"] = None
            __props__.__dict__["primary_queue_endpoint"] = None
            __props__.__dict__["primary_queue_host"] = None
            __props__.__dict__["primary_queue_microsoft_endpoint"] = None
            __props__.__dict__["primary_queue_microsoft_host"] = None
            __props__.__dict__["primary_table_endpoint"] = None
            __props__.__dict__["primary_table_host"] = None
            __props__.__dict__["primary_table_microsoft_endpoint"] = None
            __props__.__dict__["primary_table_microsoft_host"] = None
            __props__.__dict__["primary_web_endpoint"] = None
            __props__.__dict__["primary_web_host"] = None
            __props__.__dict__["primary_web_internet_endpoint"] = None
            __props__.__dict__["primary_web_internet_host"] = None
            __props__.__dict__["primary_web_microsoft_endpoint"] = None
            __props__.__dict__["primary_web_microsoft_host"] = None
            __props__.__dict__["secondary_access_key"] = None
            __props__.__dict__["secondary_blob_connection_string"] = None
            __props__.__dict__["secondary_blob_endpoint"] = None
            __props__.__dict__["secondary_blob_host"] = None
            __props__.__dict__["secondary_blob_internet_endpoint"] = None
            __props__.__dict__["secondary_blob_internet_host"] = None
            __props__.__dict__["secondary_blob_microsoft_endpoint"] = None
            __props__.__dict__["secondary_blob_microsoft_host"] = None
            __props__.__dict__["secondary_connection_string"] = None
            __props__.__dict__["secondary_dfs_endpoint"] = None
            __props__.__dict__["secondary_dfs_host"] = None
            __props__.__dict__["secondary_dfs_internet_endpoint"] = None
            __props__.__dict__["secondary_dfs_internet_host"] = None
            __props__.__dict__["secondary_dfs_microsoft_endpoint"] = None
            __props__.__dict__["secondary_dfs_microsoft_host"] = None
            __props__.__dict__["secondary_file_endpoint"] = None
            __props__.__dict__["secondary_file_host"] = None
            __props__.__dict__["secondary_file_internet_endpoint"] = None
            __props__.__dict__["secondary_file_internet_host"] = None
            __props__.__dict__["secondary_file_microsoft_endpoint"] = None
            __props__.__dict__["secondary_file_microsoft_host"] = None
            __props__.__dict__["secondary_location"] = None
            __props__.__dict__["secondary_queue_endpoint"] = None
            __props__.__dict__["secondary_queue_host"] = None
            __props__.__dict__["secondary_queue_microsoft_endpoint"] = None
            __props__.__dict__["secondary_queue_microsoft_host"] = None
            __props__.__dict__["secondary_table_endpoint"] = None
            __props__.__dict__["secondary_table_host"] = None
            __props__.__dict__["secondary_table_microsoft_endpoint"] = None
            __props__.__dict__["secondary_table_microsoft_host"] = None
            __props__.__dict__["secondary_web_endpoint"] = None
            __props__.__dict__["secondary_web_host"] = None
            __props__.__dict__["secondary_web_internet_endpoint"] = None
            __props__.__dict__["secondary_web_internet_host"] = None
            __props__.__dict__["secondary_web_microsoft_endpoint"] = None
            __props__.__dict__["secondary_web_microsoft_host"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["primaryAccessKey", "primaryBlobConnectionString", "primaryConnectionString", "secondaryAccessKey", "secondaryBlobConnectionString", "secondaryConnectionString"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Account, __self__).__init__(
            'azure:storage/account:Account',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_tier: Optional[pulumi.Input[builtins.str]] = None,
            account_kind: Optional[pulumi.Input[builtins.str]] = None,
            account_replication_type: Optional[pulumi.Input[builtins.str]] = None,
            account_tier: Optional[pulumi.Input[builtins.str]] = None,
            allow_nested_items_to_be_public: Optional[pulumi.Input[builtins.bool]] = None,
            allowed_copy_scope: Optional[pulumi.Input[builtins.str]] = None,
            azure_files_authentication: Optional[pulumi.Input[Union['AccountAzureFilesAuthenticationArgs', 'AccountAzureFilesAuthenticationArgsDict']]] = None,
            blob_properties: Optional[pulumi.Input[Union['AccountBlobPropertiesArgs', 'AccountBlobPropertiesArgsDict']]] = None,
            cross_tenant_replication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            custom_domain: Optional[pulumi.Input[Union['AccountCustomDomainArgs', 'AccountCustomDomainArgsDict']]] = None,
            customer_managed_key: Optional[pulumi.Input[Union['AccountCustomerManagedKeyArgs', 'AccountCustomerManagedKeyArgsDict']]] = None,
            default_to_oauth_authentication: Optional[pulumi.Input[builtins.bool]] = None,
            dns_endpoint_type: Optional[pulumi.Input[builtins.str]] = None,
            edge_zone: Optional[pulumi.Input[builtins.str]] = None,
            https_traffic_only_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            identity: Optional[pulumi.Input[Union['AccountIdentityArgs', 'AccountIdentityArgsDict']]] = None,
            immutability_policy: Optional[pulumi.Input[Union['AccountImmutabilityPolicyArgs', 'AccountImmutabilityPolicyArgsDict']]] = None,
            infrastructure_encryption_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            is_hns_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            large_file_share_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            local_user_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            min_tls_version: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_rules: Optional[pulumi.Input[Union['AccountNetworkRulesArgs', 'AccountNetworkRulesArgsDict']]] = None,
            nfsv3_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            primary_access_key: Optional[pulumi.Input[builtins.str]] = None,
            primary_blob_connection_string: Optional[pulumi.Input[builtins.str]] = None,
            primary_blob_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            primary_blob_host: Optional[pulumi.Input[builtins.str]] = None,
            primary_blob_internet_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            primary_blob_internet_host: Optional[pulumi.Input[builtins.str]] = None,
            primary_blob_microsoft_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            primary_blob_microsoft_host: Optional[pulumi.Input[builtins.str]] = None,
            primary_connection_string: Optional[pulumi.Input[builtins.str]] = None,
            primary_dfs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            primary_dfs_host: Optional[pulumi.Input[builtins.str]] = None,
            primary_dfs_internet_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            primary_dfs_internet_host: Optional[pulumi.Input[builtins.str]] = None,
            primary_dfs_microsoft_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            primary_dfs_microsoft_host: Optional[pulumi.Input[builtins.str]] = None,
            primary_file_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            primary_file_host: Optional[pulumi.Input[builtins.str]] = None,
            primary_file_internet_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            primary_file_internet_host: Optional[pulumi.Input[builtins.str]] = None,
            primary_file_microsoft_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            primary_file_microsoft_host: Optional[pulumi.Input[builtins.str]] = None,
            primary_location: Optional[pulumi.Input[builtins.str]] = None,
            primary_queue_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            primary_queue_host: Optional[pulumi.Input[builtins.str]] = None,
            primary_queue_microsoft_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            primary_queue_microsoft_host: Optional[pulumi.Input[builtins.str]] = None,
            primary_table_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            primary_table_host: Optional[pulumi.Input[builtins.str]] = None,
            primary_table_microsoft_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            primary_table_microsoft_host: Optional[pulumi.Input[builtins.str]] = None,
            primary_web_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            primary_web_host: Optional[pulumi.Input[builtins.str]] = None,
            primary_web_internet_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            primary_web_internet_host: Optional[pulumi.Input[builtins.str]] = None,
            primary_web_microsoft_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            primary_web_microsoft_host: Optional[pulumi.Input[builtins.str]] = None,
            public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            queue_encryption_key_type: Optional[pulumi.Input[builtins.str]] = None,
            queue_properties: Optional[pulumi.Input[Union['AccountQueuePropertiesArgs', 'AccountQueuePropertiesArgsDict']]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            routing: Optional[pulumi.Input[Union['AccountRoutingArgs', 'AccountRoutingArgsDict']]] = None,
            sas_policy: Optional[pulumi.Input[Union['AccountSasPolicyArgs', 'AccountSasPolicyArgsDict']]] = None,
            secondary_access_key: Optional[pulumi.Input[builtins.str]] = None,
            secondary_blob_connection_string: Optional[pulumi.Input[builtins.str]] = None,
            secondary_blob_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            secondary_blob_host: Optional[pulumi.Input[builtins.str]] = None,
            secondary_blob_internet_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            secondary_blob_internet_host: Optional[pulumi.Input[builtins.str]] = None,
            secondary_blob_microsoft_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            secondary_blob_microsoft_host: Optional[pulumi.Input[builtins.str]] = None,
            secondary_connection_string: Optional[pulumi.Input[builtins.str]] = None,
            secondary_dfs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            secondary_dfs_host: Optional[pulumi.Input[builtins.str]] = None,
            secondary_dfs_internet_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            secondary_dfs_internet_host: Optional[pulumi.Input[builtins.str]] = None,
            secondary_dfs_microsoft_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            secondary_dfs_microsoft_host: Optional[pulumi.Input[builtins.str]] = None,
            secondary_file_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            secondary_file_host: Optional[pulumi.Input[builtins.str]] = None,
            secondary_file_internet_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            secondary_file_internet_host: Optional[pulumi.Input[builtins.str]] = None,
            secondary_file_microsoft_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            secondary_file_microsoft_host: Optional[pulumi.Input[builtins.str]] = None,
            secondary_location: Optional[pulumi.Input[builtins.str]] = None,
            secondary_queue_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            secondary_queue_host: Optional[pulumi.Input[builtins.str]] = None,
            secondary_queue_microsoft_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            secondary_queue_microsoft_host: Optional[pulumi.Input[builtins.str]] = None,
            secondary_table_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            secondary_table_host: Optional[pulumi.Input[builtins.str]] = None,
            secondary_table_microsoft_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            secondary_table_microsoft_host: Optional[pulumi.Input[builtins.str]] = None,
            secondary_web_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            secondary_web_host: Optional[pulumi.Input[builtins.str]] = None,
            secondary_web_internet_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            secondary_web_internet_host: Optional[pulumi.Input[builtins.str]] = None,
            secondary_web_microsoft_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            secondary_web_microsoft_host: Optional[pulumi.Input[builtins.str]] = None,
            sftp_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            share_properties: Optional[pulumi.Input[Union['AccountSharePropertiesArgs', 'AccountSharePropertiesArgsDict']]] = None,
            shared_access_key_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            static_website: Optional[pulumi.Input[Union['AccountStaticWebsiteArgs', 'AccountStaticWebsiteArgsDict']]] = None,
            table_encryption_key_type: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'Account':
        """
        Get an existing Account resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_tier: Defines the access tier for `BlobStorage`, `FileStorage` and `StorageV2` accounts. Valid options are `Hot`, `Cool`, `Cold` and `Premium`. Defaults to `Hot`.
        :param pulumi.Input[builtins.str] account_kind: Defines the Kind of account. Valid options are `BlobStorage`, `BlockBlobStorage`, `FileStorage`, `Storage` and `StorageV2`. Defaults to `StorageV2`.
               
               > **Note:** Changing the `account_kind` value from `Storage` to `StorageV2` will not trigger a force new on the storage account, it will only upgrade the existing storage account from `Storage` to `StorageV2` keeping the existing storage account in place.
        :param pulumi.Input[builtins.str] account_replication_type: Defines the type of replication to use for this storage account. Valid options are `LRS`, `GRS`, `RAGRS`, `ZRS`, `GZRS` and `RAGZRS`. Changing this forces a new resource to be created when types `LRS`, `GRS` and `RAGRS` are changed to `ZRS`, `GZRS` or `RAGZRS` and vice versa.
        :param pulumi.Input[builtins.str] account_tier: Defines the Tier to use for this storage account. Valid options are `Standard` and `Premium`. For `BlockBlobStorage` and `FileStorage` accounts only `Premium` is valid. Changing this forces a new resource to be created.
               
               > **Note:** Blobs with a tier of `Premium` are of account kind `StorageV2`.
        :param pulumi.Input[builtins.bool] allow_nested_items_to_be_public: Allow or disallow nested items within this Account to opt into being public. Defaults to `true`.
               
               > **Note:** At this time `allow_nested_items_to_be_public` is only supported in the Public Cloud, China Cloud, and US Government Cloud.
        :param pulumi.Input[builtins.str] allowed_copy_scope: Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet. Possible values are `AAD` and `PrivateLink`.
        :param pulumi.Input[Union['AccountAzureFilesAuthenticationArgs', 'AccountAzureFilesAuthenticationArgsDict']] azure_files_authentication: A `azure_files_authentication` block as defined below.
        :param pulumi.Input[Union['AccountBlobPropertiesArgs', 'AccountBlobPropertiesArgsDict']] blob_properties: A `blob_properties` block as defined below.
        :param pulumi.Input[builtins.bool] cross_tenant_replication_enabled: Should cross Tenant replication be enabled? Defaults to `false`.
        :param pulumi.Input[Union['AccountCustomDomainArgs', 'AccountCustomDomainArgsDict']] custom_domain: A `custom_domain` block as documented below.
        :param pulumi.Input[Union['AccountCustomerManagedKeyArgs', 'AccountCustomerManagedKeyArgsDict']] customer_managed_key: A `customer_managed_key` block as documented below.
               
               > **Note:** It's possible to define a Customer Managed Key both within either the `customer_managed_key` block or by using the `storage.CustomerManagedKey` resource. However, it's not possible to use both methods to manage a Customer Managed Key for a Storage Account, since these will conflict. When using the `storage.CustomerManagedKey` resource, you will need to use `ignore_changes` on the `customer_managed_key` block.
        :param pulumi.Input[builtins.bool] default_to_oauth_authentication: Default to Azure Active Directory authorization in the Azure portal when accessing the Storage Account. The default value is `false`
        :param pulumi.Input[builtins.str] dns_endpoint_type: Specifies which DNS endpoint type to use. Possible values are `Standard` and `AzureDnsZone`. Defaults to `Standard`. Changing this forces a new resource to be created.
               
               > **Note:** Azure DNS zone support requires `PartitionedDns` feature to be enabled. To enable this feature for your subscription, use the following command: `az feature register --namespace "Microsoft.Storage" --name "PartitionedDns"`.
        :param pulumi.Input[builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Storage Account should exist. Changing this forces a new Storage Account to be created.
        :param pulumi.Input[builtins.bool] https_traffic_only_enabled: Boolean flag which forces HTTPS if enabled, see [here](https://docs.microsoft.com/azure/storage/storage-require-secure-transfer/) for more information. Defaults to `true`.
        :param pulumi.Input[Union['AccountIdentityArgs', 'AccountIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[Union['AccountImmutabilityPolicyArgs', 'AccountImmutabilityPolicyArgsDict']] immutability_policy: An `immutability_policy` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] infrastructure_encryption_enabled: Is infrastructure encryption enabled? Changing this forces a new resource to be created. Defaults to `false`.
               
               > **Note:** This can only be `true` when `account_kind` is `StorageV2` or when `account_tier` is `Premium` *and* `account_kind` is one of `BlockBlobStorage` or `FileStorage`.
        :param pulumi.Input[builtins.bool] is_hns_enabled: Is Hierarchical Namespace enabled? This can be used with Azure Data Lake Storage Gen 2 ([see here for more information](https://docs.microsoft.com/azure/storage/blobs/data-lake-storage-quickstart-create-account/)). Changing this forces a new resource to be created.
               
               > **Note:** This can only be `true` when `account_tier` is `Standard` or when `account_tier` is `Premium` *and* `account_kind` is `BlockBlobStorage`
        :param pulumi.Input[builtins.bool] large_file_share_enabled: Are Large File Shares Enabled? Defaults to `false`.
               
               > **Note:** Large File Shares are enabled by default when using an `account_kind` of `FileStorage`.
        :param pulumi.Input[builtins.bool] local_user_enabled: Is Local User Enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] min_tls_version: The minimum supported TLS version for the storage account. Possible values are `TLS1_0`, `TLS1_1`, and `TLS1_2`. Defaults to `TLS1_2` for new storage accounts.
               
               > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
               
               > **Note:** At this time `min_tls_version` is only supported in the Public Cloud, China Cloud, and US Government Cloud.
        :param pulumi.Input[builtins.str] name: Specifies the name of the storage account. Only lowercase Alphanumeric characters allowed. Changing this forces a new resource to be created. This must be unique across the entire Azure service, not just within the resource group.
        :param pulumi.Input[Union['AccountNetworkRulesArgs', 'AccountNetworkRulesArgsDict']] network_rules: A `network_rules` block as documented below.
        :param pulumi.Input[builtins.bool] nfsv3_enabled: Is NFSv3 protocol enabled? Changing this forces a new resource to be created. Defaults to `false`.
               
               > **Note:** This can only be `true` when `account_tier` is `Standard` and `account_kind` is `StorageV2`, or `account_tier` is `Premium` and `account_kind` is `BlockBlobStorage`. Additionally, the `is_hns_enabled` is `true` and `account_replication_type` must be `LRS` or `RAGRS`.
        :param pulumi.Input[builtins.str] primary_access_key: The primary access key for the storage account.
        :param pulumi.Input[builtins.str] primary_blob_connection_string: The connection string associated with the primary blob location.
        :param pulumi.Input[builtins.str] primary_blob_endpoint: The endpoint URL for blob storage in the primary location.
        :param pulumi.Input[builtins.str] primary_blob_host: The hostname with port if applicable for blob storage in the primary location.
        :param pulumi.Input[builtins.str] primary_blob_internet_endpoint: The internet routing endpoint URL for blob storage in the primary location.
        :param pulumi.Input[builtins.str] primary_blob_internet_host: The internet routing hostname with port if applicable for blob storage in the primary location.
        :param pulumi.Input[builtins.str] primary_blob_microsoft_endpoint: The microsoft routing endpoint URL for blob storage in the primary location.
        :param pulumi.Input[builtins.str] primary_blob_microsoft_host: The microsoft routing hostname with port if applicable for blob storage in the primary location.
        :param pulumi.Input[builtins.str] primary_connection_string: The connection string associated with the primary location.
        :param pulumi.Input[builtins.str] primary_dfs_endpoint: The endpoint URL for DFS storage in the primary location.
        :param pulumi.Input[builtins.str] primary_dfs_host: The hostname with port if applicable for DFS storage in the primary location.
        :param pulumi.Input[builtins.str] primary_dfs_internet_endpoint: The internet routing endpoint URL for DFS storage in the primary location.
        :param pulumi.Input[builtins.str] primary_dfs_internet_host: The internet routing hostname with port if applicable for DFS storage in the primary location.
        :param pulumi.Input[builtins.str] primary_dfs_microsoft_endpoint: The microsoft routing endpoint URL for DFS storage in the primary location.
        :param pulumi.Input[builtins.str] primary_dfs_microsoft_host: The microsoft routing hostname with port if applicable for DFS storage in the primary location.
        :param pulumi.Input[builtins.str] primary_file_endpoint: The endpoint URL for file storage in the primary location.
        :param pulumi.Input[builtins.str] primary_file_host: The hostname with port if applicable for file storage in the primary location.
        :param pulumi.Input[builtins.str] primary_file_internet_endpoint: The internet routing endpoint URL for file storage in the primary location.
        :param pulumi.Input[builtins.str] primary_file_internet_host: The internet routing hostname with port if applicable for file storage in the primary location.
        :param pulumi.Input[builtins.str] primary_file_microsoft_endpoint: The microsoft routing endpoint URL for file storage in the primary location.
        :param pulumi.Input[builtins.str] primary_file_microsoft_host: The microsoft routing hostname with port if applicable for file storage in the primary location.
        :param pulumi.Input[builtins.str] primary_location: The primary location of the storage account.
        :param pulumi.Input[builtins.str] primary_queue_endpoint: The endpoint URL for queue storage in the primary location.
        :param pulumi.Input[builtins.str] primary_queue_host: The hostname with port if applicable for queue storage in the primary location.
        :param pulumi.Input[builtins.str] primary_queue_microsoft_endpoint: The microsoft routing endpoint URL for queue storage in the primary location.
        :param pulumi.Input[builtins.str] primary_queue_microsoft_host: The microsoft routing hostname with port if applicable for queue storage in the primary location.
        :param pulumi.Input[builtins.str] primary_table_endpoint: The endpoint URL for table storage in the primary location.
        :param pulumi.Input[builtins.str] primary_table_host: The hostname with port if applicable for table storage in the primary location.
        :param pulumi.Input[builtins.str] primary_table_microsoft_endpoint: The microsoft routing endpoint URL for table storage in the primary location.
        :param pulumi.Input[builtins.str] primary_table_microsoft_host: The microsoft routing hostname with port if applicable for table storage in the primary location.
        :param pulumi.Input[builtins.str] primary_web_endpoint: The endpoint URL for web storage in the primary location.
        :param pulumi.Input[builtins.str] primary_web_host: The hostname with port if applicable for web storage in the primary location.
        :param pulumi.Input[builtins.str] primary_web_internet_endpoint: The internet routing endpoint URL for web storage in the primary location.
        :param pulumi.Input[builtins.str] primary_web_internet_host: The internet routing hostname with port if applicable for web storage in the primary location.
        :param pulumi.Input[builtins.str] primary_web_microsoft_endpoint: The microsoft routing endpoint URL for web storage in the primary location.
        :param pulumi.Input[builtins.str] primary_web_microsoft_host: The microsoft routing hostname with port if applicable for web storage in the primary location.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Whether the public network access is enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] queue_encryption_key_type: The encryption type of the queue service. Possible values are `Service` and `Account`. Changing this forces a new resource to be created. Default value is `Service`.
        :param pulumi.Input[Union['AccountQueuePropertiesArgs', 'AccountQueuePropertiesArgsDict']] queue_properties: A `queue_properties` block as defined below.
               
               > **Note:** `queue_properties` can only be configured when `account_tier` is set to `Standard` and `account_kind` is set to either `Storage` or `StorageV2`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the storage account. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['AccountRoutingArgs', 'AccountRoutingArgsDict']] routing: A `routing` block as defined below.
        :param pulumi.Input[Union['AccountSasPolicyArgs', 'AccountSasPolicyArgsDict']] sas_policy: A `sas_policy` block as defined below.
        :param pulumi.Input[builtins.str] secondary_access_key: The secondary access key for the storage account.
        :param pulumi.Input[builtins.str] secondary_blob_connection_string: The connection string associated with the secondary blob location.
        :param pulumi.Input[builtins.str] secondary_blob_endpoint: The endpoint URL for blob storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_blob_host: The hostname with port if applicable for blob storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_blob_internet_endpoint: The internet routing endpoint URL for blob storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_blob_internet_host: The internet routing hostname with port if applicable for blob storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_blob_microsoft_endpoint: The microsoft routing endpoint URL for blob storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_blob_microsoft_host: The microsoft routing hostname with port if applicable for blob storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_connection_string: The connection string associated with the secondary location.
        :param pulumi.Input[builtins.str] secondary_dfs_endpoint: The endpoint URL for DFS storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_dfs_host: The hostname with port if applicable for DFS storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_dfs_internet_endpoint: The internet routing endpoint URL for DFS storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_dfs_internet_host: The internet routing hostname with port if applicable for DFS storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_dfs_microsoft_endpoint: The microsoft routing endpoint URL for DFS storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_dfs_microsoft_host: The microsoft routing hostname with port if applicable for DFS storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_file_endpoint: The endpoint URL for file storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_file_host: The hostname with port if applicable for file storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_file_internet_endpoint: The internet routing endpoint URL for file storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_file_internet_host: The internet routing hostname with port if applicable for file storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_file_microsoft_endpoint: The microsoft routing endpoint URL for file storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_file_microsoft_host: The microsoft routing hostname with port if applicable for file storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_location: The secondary location of the storage account.
        :param pulumi.Input[builtins.str] secondary_queue_endpoint: The endpoint URL for queue storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_queue_host: The hostname with port if applicable for queue storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_queue_microsoft_endpoint: The microsoft routing endpoint URL for queue storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_queue_microsoft_host: The microsoft routing hostname with port if applicable for queue storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_table_endpoint: The endpoint URL for table storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_table_host: The hostname with port if applicable for table storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_table_microsoft_endpoint: The microsoft routing endpoint URL for table storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_table_microsoft_host: The microsoft routing hostname with port if applicable for table storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_web_endpoint: The endpoint URL for web storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_web_host: The hostname with port if applicable for web storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_web_internet_endpoint: The internet routing endpoint URL for web storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_web_internet_host: The internet routing hostname with port if applicable for web storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_web_microsoft_endpoint: The microsoft routing endpoint URL for web storage in the secondary location.
        :param pulumi.Input[builtins.str] secondary_web_microsoft_host: The microsoft routing hostname with port if applicable for web storage in the secondary location.
        :param pulumi.Input[builtins.bool] sftp_enabled: Boolean, enable SFTP for the storage account
               
               > **Note:** SFTP support requires `is_hns_enabled` set to `true`. [More information on SFTP support can be found here](https://learn.microsoft.com/azure/storage/blobs/secure-file-transfer-protocol-support). Defaults to `false`
        :param pulumi.Input[Union['AccountSharePropertiesArgs', 'AccountSharePropertiesArgsDict']] share_properties: A `share_properties` block as defined below.
               
               > **Note:** `share_properties` can only be configured when either `account_tier` is `Standard` and `account_kind` is either `Storage` or `StorageV2` - or when `account_tier` is `Premium` and `account_kind` is `FileStorage`.
        :param pulumi.Input[Union['AccountStaticWebsiteArgs', 'AccountStaticWebsiteArgsDict']] static_website: A `static_website` block as defined below.
               
               > **Note:** `static_website` can only be set when the `account_kind` is set to `StorageV2` or `BlockBlobStorage`.
               
               > **Note:** If `static_website` is specified, the service will automatically create a `storage.Container` named `$web`.
        :param pulumi.Input[builtins.str] table_encryption_key_type: The encryption type of the table service. Possible values are `Service` and `Account`. Changing this forces a new resource to be created. Default value is `Service`.
               
               > **Note:** `queue_encryption_key_type` and `table_encryption_key_type` cannot be set to `Account` when `account_kind` is set `Storage`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountState.__new__(_AccountState)

        __props__.__dict__["access_tier"] = access_tier
        __props__.__dict__["account_kind"] = account_kind
        __props__.__dict__["account_replication_type"] = account_replication_type
        __props__.__dict__["account_tier"] = account_tier
        __props__.__dict__["allow_nested_items_to_be_public"] = allow_nested_items_to_be_public
        __props__.__dict__["allowed_copy_scope"] = allowed_copy_scope
        __props__.__dict__["azure_files_authentication"] = azure_files_authentication
        __props__.__dict__["blob_properties"] = blob_properties
        __props__.__dict__["cross_tenant_replication_enabled"] = cross_tenant_replication_enabled
        __props__.__dict__["custom_domain"] = custom_domain
        __props__.__dict__["customer_managed_key"] = customer_managed_key
        __props__.__dict__["default_to_oauth_authentication"] = default_to_oauth_authentication
        __props__.__dict__["dns_endpoint_type"] = dns_endpoint_type
        __props__.__dict__["edge_zone"] = edge_zone
        __props__.__dict__["https_traffic_only_enabled"] = https_traffic_only_enabled
        __props__.__dict__["identity"] = identity
        __props__.__dict__["immutability_policy"] = immutability_policy
        __props__.__dict__["infrastructure_encryption_enabled"] = infrastructure_encryption_enabled
        __props__.__dict__["is_hns_enabled"] = is_hns_enabled
        __props__.__dict__["large_file_share_enabled"] = large_file_share_enabled
        __props__.__dict__["local_user_enabled"] = local_user_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["min_tls_version"] = min_tls_version
        __props__.__dict__["name"] = name
        __props__.__dict__["network_rules"] = network_rules
        __props__.__dict__["nfsv3_enabled"] = nfsv3_enabled
        __props__.__dict__["primary_access_key"] = primary_access_key
        __props__.__dict__["primary_blob_connection_string"] = primary_blob_connection_string
        __props__.__dict__["primary_blob_endpoint"] = primary_blob_endpoint
        __props__.__dict__["primary_blob_host"] = primary_blob_host
        __props__.__dict__["primary_blob_internet_endpoint"] = primary_blob_internet_endpoint
        __props__.__dict__["primary_blob_internet_host"] = primary_blob_internet_host
        __props__.__dict__["primary_blob_microsoft_endpoint"] = primary_blob_microsoft_endpoint
        __props__.__dict__["primary_blob_microsoft_host"] = primary_blob_microsoft_host
        __props__.__dict__["primary_connection_string"] = primary_connection_string
        __props__.__dict__["primary_dfs_endpoint"] = primary_dfs_endpoint
        __props__.__dict__["primary_dfs_host"] = primary_dfs_host
        __props__.__dict__["primary_dfs_internet_endpoint"] = primary_dfs_internet_endpoint
        __props__.__dict__["primary_dfs_internet_host"] = primary_dfs_internet_host
        __props__.__dict__["primary_dfs_microsoft_endpoint"] = primary_dfs_microsoft_endpoint
        __props__.__dict__["primary_dfs_microsoft_host"] = primary_dfs_microsoft_host
        __props__.__dict__["primary_file_endpoint"] = primary_file_endpoint
        __props__.__dict__["primary_file_host"] = primary_file_host
        __props__.__dict__["primary_file_internet_endpoint"] = primary_file_internet_endpoint
        __props__.__dict__["primary_file_internet_host"] = primary_file_internet_host
        __props__.__dict__["primary_file_microsoft_endpoint"] = primary_file_microsoft_endpoint
        __props__.__dict__["primary_file_microsoft_host"] = primary_file_microsoft_host
        __props__.__dict__["primary_location"] = primary_location
        __props__.__dict__["primary_queue_endpoint"] = primary_queue_endpoint
        __props__.__dict__["primary_queue_host"] = primary_queue_host
        __props__.__dict__["primary_queue_microsoft_endpoint"] = primary_queue_microsoft_endpoint
        __props__.__dict__["primary_queue_microsoft_host"] = primary_queue_microsoft_host
        __props__.__dict__["primary_table_endpoint"] = primary_table_endpoint
        __props__.__dict__["primary_table_host"] = primary_table_host
        __props__.__dict__["primary_table_microsoft_endpoint"] = primary_table_microsoft_endpoint
        __props__.__dict__["primary_table_microsoft_host"] = primary_table_microsoft_host
        __props__.__dict__["primary_web_endpoint"] = primary_web_endpoint
        __props__.__dict__["primary_web_host"] = primary_web_host
        __props__.__dict__["primary_web_internet_endpoint"] = primary_web_internet_endpoint
        __props__.__dict__["primary_web_internet_host"] = primary_web_internet_host
        __props__.__dict__["primary_web_microsoft_endpoint"] = primary_web_microsoft_endpoint
        __props__.__dict__["primary_web_microsoft_host"] = primary_web_microsoft_host
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["queue_encryption_key_type"] = queue_encryption_key_type
        __props__.__dict__["queue_properties"] = queue_properties
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["routing"] = routing
        __props__.__dict__["sas_policy"] = sas_policy
        __props__.__dict__["secondary_access_key"] = secondary_access_key
        __props__.__dict__["secondary_blob_connection_string"] = secondary_blob_connection_string
        __props__.__dict__["secondary_blob_endpoint"] = secondary_blob_endpoint
        __props__.__dict__["secondary_blob_host"] = secondary_blob_host
        __props__.__dict__["secondary_blob_internet_endpoint"] = secondary_blob_internet_endpoint
        __props__.__dict__["secondary_blob_internet_host"] = secondary_blob_internet_host
        __props__.__dict__["secondary_blob_microsoft_endpoint"] = secondary_blob_microsoft_endpoint
        __props__.__dict__["secondary_blob_microsoft_host"] = secondary_blob_microsoft_host
        __props__.__dict__["secondary_connection_string"] = secondary_connection_string
        __props__.__dict__["secondary_dfs_endpoint"] = secondary_dfs_endpoint
        __props__.__dict__["secondary_dfs_host"] = secondary_dfs_host
        __props__.__dict__["secondary_dfs_internet_endpoint"] = secondary_dfs_internet_endpoint
        __props__.__dict__["secondary_dfs_internet_host"] = secondary_dfs_internet_host
        __props__.__dict__["secondary_dfs_microsoft_endpoint"] = secondary_dfs_microsoft_endpoint
        __props__.__dict__["secondary_dfs_microsoft_host"] = secondary_dfs_microsoft_host
        __props__.__dict__["secondary_file_endpoint"] = secondary_file_endpoint
        __props__.__dict__["secondary_file_host"] = secondary_file_host
        __props__.__dict__["secondary_file_internet_endpoint"] = secondary_file_internet_endpoint
        __props__.__dict__["secondary_file_internet_host"] = secondary_file_internet_host
        __props__.__dict__["secondary_file_microsoft_endpoint"] = secondary_file_microsoft_endpoint
        __props__.__dict__["secondary_file_microsoft_host"] = secondary_file_microsoft_host
        __props__.__dict__["secondary_location"] = secondary_location
        __props__.__dict__["secondary_queue_endpoint"] = secondary_queue_endpoint
        __props__.__dict__["secondary_queue_host"] = secondary_queue_host
        __props__.__dict__["secondary_queue_microsoft_endpoint"] = secondary_queue_microsoft_endpoint
        __props__.__dict__["secondary_queue_microsoft_host"] = secondary_queue_microsoft_host
        __props__.__dict__["secondary_table_endpoint"] = secondary_table_endpoint
        __props__.__dict__["secondary_table_host"] = secondary_table_host
        __props__.__dict__["secondary_table_microsoft_endpoint"] = secondary_table_microsoft_endpoint
        __props__.__dict__["secondary_table_microsoft_host"] = secondary_table_microsoft_host
        __props__.__dict__["secondary_web_endpoint"] = secondary_web_endpoint
        __props__.__dict__["secondary_web_host"] = secondary_web_host
        __props__.__dict__["secondary_web_internet_endpoint"] = secondary_web_internet_endpoint
        __props__.__dict__["secondary_web_internet_host"] = secondary_web_internet_host
        __props__.__dict__["secondary_web_microsoft_endpoint"] = secondary_web_microsoft_endpoint
        __props__.__dict__["secondary_web_microsoft_host"] = secondary_web_microsoft_host
        __props__.__dict__["sftp_enabled"] = sftp_enabled
        __props__.__dict__["share_properties"] = share_properties
        __props__.__dict__["shared_access_key_enabled"] = shared_access_key_enabled
        __props__.__dict__["static_website"] = static_website
        __props__.__dict__["table_encryption_key_type"] = table_encryption_key_type
        __props__.__dict__["tags"] = tags
        return Account(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessTier")
    def access_tier(self) -> pulumi.Output[builtins.str]:
        """
        Defines the access tier for `BlobStorage`, `FileStorage` and `StorageV2` accounts. Valid options are `Hot`, `Cool`, `Cold` and `Premium`. Defaults to `Hot`.
        """
        return pulumi.get(self, "access_tier")

    @property
    @pulumi.getter(name="accountKind")
    def account_kind(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Defines the Kind of account. Valid options are `BlobStorage`, `BlockBlobStorage`, `FileStorage`, `Storage` and `StorageV2`. Defaults to `StorageV2`.

        > **Note:** Changing the `account_kind` value from `Storage` to `StorageV2` will not trigger a force new on the storage account, it will only upgrade the existing storage account from `Storage` to `StorageV2` keeping the existing storage account in place.
        """
        return pulumi.get(self, "account_kind")

    @property
    @pulumi.getter(name="accountReplicationType")
    def account_replication_type(self) -> pulumi.Output[builtins.str]:
        """
        Defines the type of replication to use for this storage account. Valid options are `LRS`, `GRS`, `RAGRS`, `ZRS`, `GZRS` and `RAGZRS`. Changing this forces a new resource to be created when types `LRS`, `GRS` and `RAGRS` are changed to `ZRS`, `GZRS` or `RAGZRS` and vice versa.
        """
        return pulumi.get(self, "account_replication_type")

    @property
    @pulumi.getter(name="accountTier")
    def account_tier(self) -> pulumi.Output[builtins.str]:
        """
        Defines the Tier to use for this storage account. Valid options are `Standard` and `Premium`. For `BlockBlobStorage` and `FileStorage` accounts only `Premium` is valid. Changing this forces a new resource to be created.

        > **Note:** Blobs with a tier of `Premium` are of account kind `StorageV2`.
        """
        return pulumi.get(self, "account_tier")

    @property
    @pulumi.getter(name="allowNestedItemsToBePublic")
    def allow_nested_items_to_be_public(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Allow or disallow nested items within this Account to opt into being public. Defaults to `true`.

        > **Note:** At this time `allow_nested_items_to_be_public` is only supported in the Public Cloud, China Cloud, and US Government Cloud.
        """
        return pulumi.get(self, "allow_nested_items_to_be_public")

    @property
    @pulumi.getter(name="allowedCopyScope")
    def allowed_copy_scope(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet. Possible values are `AAD` and `PrivateLink`.
        """
        return pulumi.get(self, "allowed_copy_scope")

    @property
    @pulumi.getter(name="azureFilesAuthentication")
    def azure_files_authentication(self) -> pulumi.Output[Optional['outputs.AccountAzureFilesAuthentication']]:
        """
        A `azure_files_authentication` block as defined below.
        """
        return pulumi.get(self, "azure_files_authentication")

    @property
    @pulumi.getter(name="blobProperties")
    def blob_properties(self) -> pulumi.Output['outputs.AccountBlobProperties']:
        """
        A `blob_properties` block as defined below.
        """
        return pulumi.get(self, "blob_properties")

    @property
    @pulumi.getter(name="crossTenantReplicationEnabled")
    def cross_tenant_replication_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Should cross Tenant replication be enabled? Defaults to `false`.
        """
        return pulumi.get(self, "cross_tenant_replication_enabled")

    @property
    @pulumi.getter(name="customDomain")
    def custom_domain(self) -> pulumi.Output[Optional['outputs.AccountCustomDomain']]:
        """
        A `custom_domain` block as documented below.
        """
        return pulumi.get(self, "custom_domain")

    @property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> pulumi.Output[Optional['outputs.AccountCustomerManagedKey']]:
        """
        A `customer_managed_key` block as documented below.

        > **Note:** It's possible to define a Customer Managed Key both within either the `customer_managed_key` block or by using the `storage.CustomerManagedKey` resource. However, it's not possible to use both methods to manage a Customer Managed Key for a Storage Account, since these will conflict. When using the `storage.CustomerManagedKey` resource, you will need to use `ignore_changes` on the `customer_managed_key` block.
        """
        return pulumi.get(self, "customer_managed_key")

    @property
    @pulumi.getter(name="defaultToOauthAuthentication")
    def default_to_oauth_authentication(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Default to Azure Active Directory authorization in the Azure portal when accessing the Storage Account. The default value is `false`
        """
        return pulumi.get(self, "default_to_oauth_authentication")

    @property
    @pulumi.getter(name="dnsEndpointType")
    def dns_endpoint_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies which DNS endpoint type to use. Possible values are `Standard` and `AzureDnsZone`. Defaults to `Standard`. Changing this forces a new resource to be created.

        > **Note:** Azure DNS zone support requires `PartitionedDns` feature to be enabled. To enable this feature for your subscription, use the following command: `az feature register --namespace "Microsoft.Storage" --name "PartitionedDns"`.
        """
        return pulumi.get(self, "dns_endpoint_type")

    @property
    @pulumi.getter(name="edgeZone")
    def edge_zone(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the Edge Zone within the Azure Region where this Storage Account should exist. Changing this forces a new Storage Account to be created.
        """
        return pulumi.get(self, "edge_zone")

    @property
    @pulumi.getter(name="httpsTrafficOnlyEnabled")
    def https_traffic_only_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Boolean flag which forces HTTPS if enabled, see [here](https://docs.microsoft.com/azure/storage/storage-require-secure-transfer/) for more information. Defaults to `true`.
        """
        return pulumi.get(self, "https_traffic_only_enabled")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.AccountIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="immutabilityPolicy")
    def immutability_policy(self) -> pulumi.Output[Optional['outputs.AccountImmutabilityPolicy']]:
        """
        An `immutability_policy` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "immutability_policy")

    @property
    @pulumi.getter(name="infrastructureEncryptionEnabled")
    def infrastructure_encryption_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is infrastructure encryption enabled? Changing this forces a new resource to be created. Defaults to `false`.

        > **Note:** This can only be `true` when `account_kind` is `StorageV2` or when `account_tier` is `Premium` *and* `account_kind` is one of `BlockBlobStorage` or `FileStorage`.
        """
        return pulumi.get(self, "infrastructure_encryption_enabled")

    @property
    @pulumi.getter(name="isHnsEnabled")
    def is_hns_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is Hierarchical Namespace enabled? This can be used with Azure Data Lake Storage Gen 2 ([see here for more information](https://docs.microsoft.com/azure/storage/blobs/data-lake-storage-quickstart-create-account/)). Changing this forces a new resource to be created.

        > **Note:** This can only be `true` when `account_tier` is `Standard` or when `account_tier` is `Premium` *and* `account_kind` is `BlockBlobStorage`
        """
        return pulumi.get(self, "is_hns_enabled")

    @property
    @pulumi.getter(name="largeFileShareEnabled")
    def large_file_share_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Are Large File Shares Enabled? Defaults to `false`.

        > **Note:** Large File Shares are enabled by default when using an `account_kind` of `FileStorage`.
        """
        return pulumi.get(self, "large_file_share_enabled")

    @property
    @pulumi.getter(name="localUserEnabled")
    def local_user_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is Local User Enabled? Defaults to `true`.
        """
        return pulumi.get(self, "local_user_enabled")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The minimum supported TLS version for the storage account. Possible values are `TLS1_0`, `TLS1_1`, and `TLS1_2`. Defaults to `TLS1_2` for new storage accounts.

        > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.

        > **Note:** At this time `min_tls_version` is only supported in the Public Cloud, China Cloud, and US Government Cloud.
        """
        return pulumi.get(self, "min_tls_version")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the storage account. Only lowercase Alphanumeric characters allowed. Changing this forces a new resource to be created. This must be unique across the entire Azure service, not just within the resource group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkRules")
    def network_rules(self) -> pulumi.Output['outputs.AccountNetworkRules']:
        """
        A `network_rules` block as documented below.
        """
        return pulumi.get(self, "network_rules")

    @property
    @pulumi.getter(name="nfsv3Enabled")
    def nfsv3_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is NFSv3 protocol enabled? Changing this forces a new resource to be created. Defaults to `false`.

        > **Note:** This can only be `true` when `account_tier` is `Standard` and `account_kind` is `StorageV2`, or `account_tier` is `Premium` and `account_kind` is `BlockBlobStorage`. Additionally, the `is_hns_enabled` is `true` and `account_replication_type` must be `LRS` or `RAGRS`.
        """
        return pulumi.get(self, "nfsv3_enabled")

    @property
    @pulumi.getter(name="primaryAccessKey")
    def primary_access_key(self) -> pulumi.Output[builtins.str]:
        """
        The primary access key for the storage account.
        """
        return pulumi.get(self, "primary_access_key")

    @property
    @pulumi.getter(name="primaryBlobConnectionString")
    def primary_blob_connection_string(self) -> pulumi.Output[builtins.str]:
        """
        The connection string associated with the primary blob location.
        """
        return pulumi.get(self, "primary_blob_connection_string")

    @property
    @pulumi.getter(name="primaryBlobEndpoint")
    def primary_blob_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The endpoint URL for blob storage in the primary location.
        """
        return pulumi.get(self, "primary_blob_endpoint")

    @property
    @pulumi.getter(name="primaryBlobHost")
    def primary_blob_host(self) -> pulumi.Output[builtins.str]:
        """
        The hostname with port if applicable for blob storage in the primary location.
        """
        return pulumi.get(self, "primary_blob_host")

    @property
    @pulumi.getter(name="primaryBlobInternetEndpoint")
    def primary_blob_internet_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The internet routing endpoint URL for blob storage in the primary location.
        """
        return pulumi.get(self, "primary_blob_internet_endpoint")

    @property
    @pulumi.getter(name="primaryBlobInternetHost")
    def primary_blob_internet_host(self) -> pulumi.Output[builtins.str]:
        """
        The internet routing hostname with port if applicable for blob storage in the primary location.
        """
        return pulumi.get(self, "primary_blob_internet_host")

    @property
    @pulumi.getter(name="primaryBlobMicrosoftEndpoint")
    def primary_blob_microsoft_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The microsoft routing endpoint URL for blob storage in the primary location.
        """
        return pulumi.get(self, "primary_blob_microsoft_endpoint")

    @property
    @pulumi.getter(name="primaryBlobMicrosoftHost")
    def primary_blob_microsoft_host(self) -> pulumi.Output[builtins.str]:
        """
        The microsoft routing hostname with port if applicable for blob storage in the primary location.
        """
        return pulumi.get(self, "primary_blob_microsoft_host")

    @property
    @pulumi.getter(name="primaryConnectionString")
    def primary_connection_string(self) -> pulumi.Output[builtins.str]:
        """
        The connection string associated with the primary location.
        """
        return pulumi.get(self, "primary_connection_string")

    @property
    @pulumi.getter(name="primaryDfsEndpoint")
    def primary_dfs_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The endpoint URL for DFS storage in the primary location.
        """
        return pulumi.get(self, "primary_dfs_endpoint")

    @property
    @pulumi.getter(name="primaryDfsHost")
    def primary_dfs_host(self) -> pulumi.Output[builtins.str]:
        """
        The hostname with port if applicable for DFS storage in the primary location.
        """
        return pulumi.get(self, "primary_dfs_host")

    @property
    @pulumi.getter(name="primaryDfsInternetEndpoint")
    def primary_dfs_internet_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The internet routing endpoint URL for DFS storage in the primary location.
        """
        return pulumi.get(self, "primary_dfs_internet_endpoint")

    @property
    @pulumi.getter(name="primaryDfsInternetHost")
    def primary_dfs_internet_host(self) -> pulumi.Output[builtins.str]:
        """
        The internet routing hostname with port if applicable for DFS storage in the primary location.
        """
        return pulumi.get(self, "primary_dfs_internet_host")

    @property
    @pulumi.getter(name="primaryDfsMicrosoftEndpoint")
    def primary_dfs_microsoft_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The microsoft routing endpoint URL for DFS storage in the primary location.
        """
        return pulumi.get(self, "primary_dfs_microsoft_endpoint")

    @property
    @pulumi.getter(name="primaryDfsMicrosoftHost")
    def primary_dfs_microsoft_host(self) -> pulumi.Output[builtins.str]:
        """
        The microsoft routing hostname with port if applicable for DFS storage in the primary location.
        """
        return pulumi.get(self, "primary_dfs_microsoft_host")

    @property
    @pulumi.getter(name="primaryFileEndpoint")
    def primary_file_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The endpoint URL for file storage in the primary location.
        """
        return pulumi.get(self, "primary_file_endpoint")

    @property
    @pulumi.getter(name="primaryFileHost")
    def primary_file_host(self) -> pulumi.Output[builtins.str]:
        """
        The hostname with port if applicable for file storage in the primary location.
        """
        return pulumi.get(self, "primary_file_host")

    @property
    @pulumi.getter(name="primaryFileInternetEndpoint")
    def primary_file_internet_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The internet routing endpoint URL for file storage in the primary location.
        """
        return pulumi.get(self, "primary_file_internet_endpoint")

    @property
    @pulumi.getter(name="primaryFileInternetHost")
    def primary_file_internet_host(self) -> pulumi.Output[builtins.str]:
        """
        The internet routing hostname with port if applicable for file storage in the primary location.
        """
        return pulumi.get(self, "primary_file_internet_host")

    @property
    @pulumi.getter(name="primaryFileMicrosoftEndpoint")
    def primary_file_microsoft_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The microsoft routing endpoint URL for file storage in the primary location.
        """
        return pulumi.get(self, "primary_file_microsoft_endpoint")

    @property
    @pulumi.getter(name="primaryFileMicrosoftHost")
    def primary_file_microsoft_host(self) -> pulumi.Output[builtins.str]:
        """
        The microsoft routing hostname with port if applicable for file storage in the primary location.
        """
        return pulumi.get(self, "primary_file_microsoft_host")

    @property
    @pulumi.getter(name="primaryLocation")
    def primary_location(self) -> pulumi.Output[builtins.str]:
        """
        The primary location of the storage account.
        """
        return pulumi.get(self, "primary_location")

    @property
    @pulumi.getter(name="primaryQueueEndpoint")
    def primary_queue_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The endpoint URL for queue storage in the primary location.
        """
        return pulumi.get(self, "primary_queue_endpoint")

    @property
    @pulumi.getter(name="primaryQueueHost")
    def primary_queue_host(self) -> pulumi.Output[builtins.str]:
        """
        The hostname with port if applicable for queue storage in the primary location.
        """
        return pulumi.get(self, "primary_queue_host")

    @property
    @pulumi.getter(name="primaryQueueMicrosoftEndpoint")
    def primary_queue_microsoft_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The microsoft routing endpoint URL for queue storage in the primary location.
        """
        return pulumi.get(self, "primary_queue_microsoft_endpoint")

    @property
    @pulumi.getter(name="primaryQueueMicrosoftHost")
    def primary_queue_microsoft_host(self) -> pulumi.Output[builtins.str]:
        """
        The microsoft routing hostname with port if applicable for queue storage in the primary location.
        """
        return pulumi.get(self, "primary_queue_microsoft_host")

    @property
    @pulumi.getter(name="primaryTableEndpoint")
    def primary_table_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The endpoint URL for table storage in the primary location.
        """
        return pulumi.get(self, "primary_table_endpoint")

    @property
    @pulumi.getter(name="primaryTableHost")
    def primary_table_host(self) -> pulumi.Output[builtins.str]:
        """
        The hostname with port if applicable for table storage in the primary location.
        """
        return pulumi.get(self, "primary_table_host")

    @property
    @pulumi.getter(name="primaryTableMicrosoftEndpoint")
    def primary_table_microsoft_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The microsoft routing endpoint URL for table storage in the primary location.
        """
        return pulumi.get(self, "primary_table_microsoft_endpoint")

    @property
    @pulumi.getter(name="primaryTableMicrosoftHost")
    def primary_table_microsoft_host(self) -> pulumi.Output[builtins.str]:
        """
        The microsoft routing hostname with port if applicable for table storage in the primary location.
        """
        return pulumi.get(self, "primary_table_microsoft_host")

    @property
    @pulumi.getter(name="primaryWebEndpoint")
    def primary_web_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The endpoint URL for web storage in the primary location.
        """
        return pulumi.get(self, "primary_web_endpoint")

    @property
    @pulumi.getter(name="primaryWebHost")
    def primary_web_host(self) -> pulumi.Output[builtins.str]:
        """
        The hostname with port if applicable for web storage in the primary location.
        """
        return pulumi.get(self, "primary_web_host")

    @property
    @pulumi.getter(name="primaryWebInternetEndpoint")
    def primary_web_internet_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The internet routing endpoint URL for web storage in the primary location.
        """
        return pulumi.get(self, "primary_web_internet_endpoint")

    @property
    @pulumi.getter(name="primaryWebInternetHost")
    def primary_web_internet_host(self) -> pulumi.Output[builtins.str]:
        """
        The internet routing hostname with port if applicable for web storage in the primary location.
        """
        return pulumi.get(self, "primary_web_internet_host")

    @property
    @pulumi.getter(name="primaryWebMicrosoftEndpoint")
    def primary_web_microsoft_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The microsoft routing endpoint URL for web storage in the primary location.
        """
        return pulumi.get(self, "primary_web_microsoft_endpoint")

    @property
    @pulumi.getter(name="primaryWebMicrosoftHost")
    def primary_web_microsoft_host(self) -> pulumi.Output[builtins.str]:
        """
        The microsoft routing hostname with port if applicable for web storage in the primary location.
        """
        return pulumi.get(self, "primary_web_microsoft_host")

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the public network access is enabled? Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @property
    @pulumi.getter(name="queueEncryptionKeyType")
    def queue_encryption_key_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The encryption type of the queue service. Possible values are `Service` and `Account`. Changing this forces a new resource to be created. Default value is `Service`.
        """
        return pulumi.get(self, "queue_encryption_key_type")

    @property
    @pulumi.getter(name="queueProperties")
    @_utilities.deprecated("""this block has been deprecated and superseded by the `storage.AccountQueueProperties` resource and will be removed in v5.0 of the AzureRM provider""")
    def queue_properties(self) -> pulumi.Output['outputs.AccountQueueProperties']:
        """
        A `queue_properties` block as defined below.

        > **Note:** `queue_properties` can only be configured when `account_tier` is set to `Standard` and `account_kind` is set to either `Storage` or `StorageV2`.
        """
        return pulumi.get(self, "queue_properties")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group in which to create the storage account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def routing(self) -> pulumi.Output['outputs.AccountRouting']:
        """
        A `routing` block as defined below.
        """
        return pulumi.get(self, "routing")

    @property
    @pulumi.getter(name="sasPolicy")
    def sas_policy(self) -> pulumi.Output[Optional['outputs.AccountSasPolicy']]:
        """
        A `sas_policy` block as defined below.
        """
        return pulumi.get(self, "sas_policy")

    @property
    @pulumi.getter(name="secondaryAccessKey")
    def secondary_access_key(self) -> pulumi.Output[builtins.str]:
        """
        The secondary access key for the storage account.
        """
        return pulumi.get(self, "secondary_access_key")

    @property
    @pulumi.getter(name="secondaryBlobConnectionString")
    def secondary_blob_connection_string(self) -> pulumi.Output[builtins.str]:
        """
        The connection string associated with the secondary blob location.
        """
        return pulumi.get(self, "secondary_blob_connection_string")

    @property
    @pulumi.getter(name="secondaryBlobEndpoint")
    def secondary_blob_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The endpoint URL for blob storage in the secondary location.
        """
        return pulumi.get(self, "secondary_blob_endpoint")

    @property
    @pulumi.getter(name="secondaryBlobHost")
    def secondary_blob_host(self) -> pulumi.Output[builtins.str]:
        """
        The hostname with port if applicable for blob storage in the secondary location.
        """
        return pulumi.get(self, "secondary_blob_host")

    @property
    @pulumi.getter(name="secondaryBlobInternetEndpoint")
    def secondary_blob_internet_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The internet routing endpoint URL for blob storage in the secondary location.
        """
        return pulumi.get(self, "secondary_blob_internet_endpoint")

    @property
    @pulumi.getter(name="secondaryBlobInternetHost")
    def secondary_blob_internet_host(self) -> pulumi.Output[builtins.str]:
        """
        The internet routing hostname with port if applicable for blob storage in the secondary location.
        """
        return pulumi.get(self, "secondary_blob_internet_host")

    @property
    @pulumi.getter(name="secondaryBlobMicrosoftEndpoint")
    def secondary_blob_microsoft_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The microsoft routing endpoint URL for blob storage in the secondary location.
        """
        return pulumi.get(self, "secondary_blob_microsoft_endpoint")

    @property
    @pulumi.getter(name="secondaryBlobMicrosoftHost")
    def secondary_blob_microsoft_host(self) -> pulumi.Output[builtins.str]:
        """
        The microsoft routing hostname with port if applicable for blob storage in the secondary location.
        """
        return pulumi.get(self, "secondary_blob_microsoft_host")

    @property
    @pulumi.getter(name="secondaryConnectionString")
    def secondary_connection_string(self) -> pulumi.Output[builtins.str]:
        """
        The connection string associated with the secondary location.
        """
        return pulumi.get(self, "secondary_connection_string")

    @property
    @pulumi.getter(name="secondaryDfsEndpoint")
    def secondary_dfs_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The endpoint URL for DFS storage in the secondary location.
        """
        return pulumi.get(self, "secondary_dfs_endpoint")

    @property
    @pulumi.getter(name="secondaryDfsHost")
    def secondary_dfs_host(self) -> pulumi.Output[builtins.str]:
        """
        The hostname with port if applicable for DFS storage in the secondary location.
        """
        return pulumi.get(self, "secondary_dfs_host")

    @property
    @pulumi.getter(name="secondaryDfsInternetEndpoint")
    def secondary_dfs_internet_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The internet routing endpoint URL for DFS storage in the secondary location.
        """
        return pulumi.get(self, "secondary_dfs_internet_endpoint")

    @property
    @pulumi.getter(name="secondaryDfsInternetHost")
    def secondary_dfs_internet_host(self) -> pulumi.Output[builtins.str]:
        """
        The internet routing hostname with port if applicable for DFS storage in the secondary location.
        """
        return pulumi.get(self, "secondary_dfs_internet_host")

    @property
    @pulumi.getter(name="secondaryDfsMicrosoftEndpoint")
    def secondary_dfs_microsoft_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The microsoft routing endpoint URL for DFS storage in the secondary location.
        """
        return pulumi.get(self, "secondary_dfs_microsoft_endpoint")

    @property
    @pulumi.getter(name="secondaryDfsMicrosoftHost")
    def secondary_dfs_microsoft_host(self) -> pulumi.Output[builtins.str]:
        """
        The microsoft routing hostname with port if applicable for DFS storage in the secondary location.
        """
        return pulumi.get(self, "secondary_dfs_microsoft_host")

    @property
    @pulumi.getter(name="secondaryFileEndpoint")
    def secondary_file_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The endpoint URL for file storage in the secondary location.
        """
        return pulumi.get(self, "secondary_file_endpoint")

    @property
    @pulumi.getter(name="secondaryFileHost")
    def secondary_file_host(self) -> pulumi.Output[builtins.str]:
        """
        The hostname with port if applicable for file storage in the secondary location.
        """
        return pulumi.get(self, "secondary_file_host")

    @property
    @pulumi.getter(name="secondaryFileInternetEndpoint")
    def secondary_file_internet_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The internet routing endpoint URL for file storage in the secondary location.
        """
        return pulumi.get(self, "secondary_file_internet_endpoint")

    @property
    @pulumi.getter(name="secondaryFileInternetHost")
    def secondary_file_internet_host(self) -> pulumi.Output[builtins.str]:
        """
        The internet routing hostname with port if applicable for file storage in the secondary location.
        """
        return pulumi.get(self, "secondary_file_internet_host")

    @property
    @pulumi.getter(name="secondaryFileMicrosoftEndpoint")
    def secondary_file_microsoft_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The microsoft routing endpoint URL for file storage in the secondary location.
        """
        return pulumi.get(self, "secondary_file_microsoft_endpoint")

    @property
    @pulumi.getter(name="secondaryFileMicrosoftHost")
    def secondary_file_microsoft_host(self) -> pulumi.Output[builtins.str]:
        """
        The microsoft routing hostname with port if applicable for file storage in the secondary location.
        """
        return pulumi.get(self, "secondary_file_microsoft_host")

    @property
    @pulumi.getter(name="secondaryLocation")
    def secondary_location(self) -> pulumi.Output[builtins.str]:
        """
        The secondary location of the storage account.
        """
        return pulumi.get(self, "secondary_location")

    @property
    @pulumi.getter(name="secondaryQueueEndpoint")
    def secondary_queue_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The endpoint URL for queue storage in the secondary location.
        """
        return pulumi.get(self, "secondary_queue_endpoint")

    @property
    @pulumi.getter(name="secondaryQueueHost")
    def secondary_queue_host(self) -> pulumi.Output[builtins.str]:
        """
        The hostname with port if applicable for queue storage in the secondary location.
        """
        return pulumi.get(self, "secondary_queue_host")

    @property
    @pulumi.getter(name="secondaryQueueMicrosoftEndpoint")
    def secondary_queue_microsoft_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The microsoft routing endpoint URL for queue storage in the secondary location.
        """
        return pulumi.get(self, "secondary_queue_microsoft_endpoint")

    @property
    @pulumi.getter(name="secondaryQueueMicrosoftHost")
    def secondary_queue_microsoft_host(self) -> pulumi.Output[builtins.str]:
        """
        The microsoft routing hostname with port if applicable for queue storage in the secondary location.
        """
        return pulumi.get(self, "secondary_queue_microsoft_host")

    @property
    @pulumi.getter(name="secondaryTableEndpoint")
    def secondary_table_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The endpoint URL for table storage in the secondary location.
        """
        return pulumi.get(self, "secondary_table_endpoint")

    @property
    @pulumi.getter(name="secondaryTableHost")
    def secondary_table_host(self) -> pulumi.Output[builtins.str]:
        """
        The hostname with port if applicable for table storage in the secondary location.
        """
        return pulumi.get(self, "secondary_table_host")

    @property
    @pulumi.getter(name="secondaryTableMicrosoftEndpoint")
    def secondary_table_microsoft_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The microsoft routing endpoint URL for table storage in the secondary location.
        """
        return pulumi.get(self, "secondary_table_microsoft_endpoint")

    @property
    @pulumi.getter(name="secondaryTableMicrosoftHost")
    def secondary_table_microsoft_host(self) -> pulumi.Output[builtins.str]:
        """
        The microsoft routing hostname with port if applicable for table storage in the secondary location.
        """
        return pulumi.get(self, "secondary_table_microsoft_host")

    @property
    @pulumi.getter(name="secondaryWebEndpoint")
    def secondary_web_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The endpoint URL for web storage in the secondary location.
        """
        return pulumi.get(self, "secondary_web_endpoint")

    @property
    @pulumi.getter(name="secondaryWebHost")
    def secondary_web_host(self) -> pulumi.Output[builtins.str]:
        """
        The hostname with port if applicable for web storage in the secondary location.
        """
        return pulumi.get(self, "secondary_web_host")

    @property
    @pulumi.getter(name="secondaryWebInternetEndpoint")
    def secondary_web_internet_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The internet routing endpoint URL for web storage in the secondary location.
        """
        return pulumi.get(self, "secondary_web_internet_endpoint")

    @property
    @pulumi.getter(name="secondaryWebInternetHost")
    def secondary_web_internet_host(self) -> pulumi.Output[builtins.str]:
        """
        The internet routing hostname with port if applicable for web storage in the secondary location.
        """
        return pulumi.get(self, "secondary_web_internet_host")

    @property
    @pulumi.getter(name="secondaryWebMicrosoftEndpoint")
    def secondary_web_microsoft_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The microsoft routing endpoint URL for web storage in the secondary location.
        """
        return pulumi.get(self, "secondary_web_microsoft_endpoint")

    @property
    @pulumi.getter(name="secondaryWebMicrosoftHost")
    def secondary_web_microsoft_host(self) -> pulumi.Output[builtins.str]:
        """
        The microsoft routing hostname with port if applicable for web storage in the secondary location.
        """
        return pulumi.get(self, "secondary_web_microsoft_host")

    @property
    @pulumi.getter(name="sftpEnabled")
    def sftp_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Boolean, enable SFTP for the storage account

        > **Note:** SFTP support requires `is_hns_enabled` set to `true`. [More information on SFTP support can be found here](https://learn.microsoft.com/azure/storage/blobs/secure-file-transfer-protocol-support). Defaults to `false`
        """
        return pulumi.get(self, "sftp_enabled")

    @property
    @pulumi.getter(name="shareProperties")
    def share_properties(self) -> pulumi.Output['outputs.AccountShareProperties']:
        """
        A `share_properties` block as defined below.

        > **Note:** `share_properties` can only be configured when either `account_tier` is `Standard` and `account_kind` is either `Storage` or `StorageV2` - or when `account_tier` is `Premium` and `account_kind` is `FileStorage`.
        """
        return pulumi.get(self, "share_properties")

    @property
    @pulumi.getter(name="sharedAccessKeyEnabled")
    def shared_access_key_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "shared_access_key_enabled")

    @property
    @pulumi.getter(name="staticWebsite")
    @_utilities.deprecated("""this block has been deprecated and superseded by the `storage.AccountStaticWebsite` resource and will be removed in v5.0 of the AzureRM provider""")
    def static_website(self) -> pulumi.Output['outputs.AccountStaticWebsite']:
        """
        A `static_website` block as defined below.

        > **Note:** `static_website` can only be set when the `account_kind` is set to `StorageV2` or `BlockBlobStorage`.

        > **Note:** If `static_website` is specified, the service will automatically create a `storage.Container` named `$web`.
        """
        return pulumi.get(self, "static_website")

    @property
    @pulumi.getter(name="tableEncryptionKeyType")
    def table_encryption_key_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The encryption type of the table service. Possible values are `Service` and `Account`. Changing this forces a new resource to be created. Default value is `Service`.

        > **Note:** `queue_encryption_key_type` and `table_encryption_key_type` cannot be set to `Account` when `account_kind` is set `Storage`
        """
        return pulumi.get(self, "table_encryption_key_type")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

