# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BlobArgs', 'Blob']

@pulumi.input_type
class BlobArgs:
    def __init__(__self__, *,
                 storage_account_name: pulumi.Input[builtins.str],
                 storage_container_name: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 access_tier: Optional[pulumi.Input[builtins.str]] = None,
                 cache_control: Optional[pulumi.Input[builtins.str]] = None,
                 content_md5: Optional[pulumi.Input[builtins.str]] = None,
                 content_type: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_scope: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parallelism: Optional[pulumi.Input[builtins.int]] = None,
                 size: Optional[pulumi.Input[builtins.int]] = None,
                 source: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]] = None,
                 source_content: Optional[pulumi.Input[builtins.str]] = None,
                 source_uri: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Blob resource.
        :param pulumi.Input[builtins.str] storage_account_name: Specifies the storage account in which to create the storage container. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] storage_container_name: The name of the storage container in which this blob should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] type: The type of the storage blob to be created. Possible values are `Append`, `Block` or `Page`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] access_tier: The access tier of the storage blob. Possible values are `Archive`, `Cool` and `Hot`.
        :param pulumi.Input[builtins.str] cache_control: Controls the [cache control header](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Cache-Control) content of the response when blob is requested .
        :param pulumi.Input[builtins.str] content_md5: The MD5 sum of the blob contents. Cannot be defined if `source_uri` is defined, or if blob type is Append or Page. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] content_type: The content type of the storage blob. Cannot be defined if `source_uri` is defined. Defaults to `application/octet-stream`.
        :param pulumi.Input[builtins.str] encryption_scope: The encryption scope to use for this blob.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: A map of custom blob metadata.
        :param pulumi.Input[builtins.str] name: The name of the storage blob. Must be unique within the storage container the blob is located. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] parallelism: The number of workers per CPU core to run for concurrent uploads. Defaults to `8`. Changing this forces a new resource to be created.
               
               > **NOTE:** `parallelism` is only applicable for Page blobs - support for [Block Blobs is blocked on the upstream issue](https://github.com/jackofallops/giovanni/issues/15).
        :param pulumi.Input[builtins.int] size: Used only for `page` blobs to specify the size in bytes of the blob to be created. Must be a multiple of 512. Defaults to `0`. Changing this forces a new resource to be created.
               
               > **Note:** `size` is required if `source_uri` is not set.
        :param pulumi.Input[Union[pulumi.Asset, pulumi.Archive]] source: An absolute path to a file on the local system. This field cannot be specified for Append blobs and cannot be specified if `source_content` or `source_uri` is specified. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_content: The content for this blob which should be defined inline. This field can only be specified for Block blobs and cannot be specified if `source` or `source_uri` is specified. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_uri: The URI of an existing blob, or a file in the Azure File service, to use as the source contents for the blob to be created. Changing this forces a new resource to be created. This field cannot be specified for Append blobs and cannot be specified if `source` or `source_content` is specified.
        """
        pulumi.set(__self__, "storage_account_name", storage_account_name)
        pulumi.set(__self__, "storage_container_name", storage_container_name)
        pulumi.set(__self__, "type", type)
        if access_tier is not None:
            pulumi.set(__self__, "access_tier", access_tier)
        if cache_control is not None:
            pulumi.set(__self__, "cache_control", cache_control)
        if content_md5 is not None:
            pulumi.set(__self__, "content_md5", content_md5)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if encryption_scope is not None:
            pulumi.set(__self__, "encryption_scope", encryption_scope)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parallelism is not None:
            pulumi.set(__self__, "parallelism", parallelism)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_content is not None:
            pulumi.set(__self__, "source_content", source_content)
        if source_uri is not None:
            pulumi.set(__self__, "source_uri", source_uri)

    @property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the storage account in which to create the storage container. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_name")

    @storage_account_name.setter
    def storage_account_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "storage_account_name", value)

    @property
    @pulumi.getter(name="storageContainerName")
    def storage_container_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the storage container in which this blob should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_container_name")

    @storage_container_name.setter
    def storage_container_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "storage_container_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of the storage blob to be created. Possible values are `Append`, `Block` or `Page`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="accessTier")
    def access_tier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The access tier of the storage blob. Possible values are `Archive`, `Cool` and `Hot`.
        """
        return pulumi.get(self, "access_tier")

    @access_tier.setter
    def access_tier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_tier", value)

    @property
    @pulumi.getter(name="cacheControl")
    def cache_control(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Controls the [cache control header](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Cache-Control) content of the response when blob is requested .
        """
        return pulumi.get(self, "cache_control")

    @cache_control.setter
    def cache_control(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cache_control", value)

    @property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The MD5 sum of the blob contents. Cannot be defined if `source_uri` is defined, or if blob type is Append or Page. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "content_md5")

    @content_md5.setter
    def content_md5(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_md5", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The content type of the storage blob. Cannot be defined if `source_uri` is defined. Defaults to `application/octet-stream`.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="encryptionScope")
    def encryption_scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The encryption scope to use for this blob.
        """
        return pulumi.get(self, "encryption_scope")

    @encryption_scope.setter
    def encryption_scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "encryption_scope", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of custom blob metadata.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the storage blob. Must be unique within the storage container the blob is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parallelism(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of workers per CPU core to run for concurrent uploads. Defaults to `8`. Changing this forces a new resource to be created.

        > **NOTE:** `parallelism` is only applicable for Page blobs - support for [Block Blobs is blocked on the upstream issue](https://github.com/jackofallops/giovanni/issues/15).
        """
        return pulumi.get(self, "parallelism")

    @parallelism.setter
    def parallelism(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "parallelism", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Used only for `page` blobs to specify the size in bytes of the blob to be created. Must be a multiple of 512. Defaults to `0`. Changing this forces a new resource to be created.

        > **Note:** `size` is required if `source_uri` is not set.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]:
        """
        An absolute path to a file on the local system. This field cannot be specified for Append blobs and cannot be specified if `source_content` or `source_uri` is specified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="sourceContent")
    def source_content(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The content for this blob which should be defined inline. This field can only be specified for Block blobs and cannot be specified if `source` or `source_uri` is specified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_content")

    @source_content.setter
    def source_content(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_content", value)

    @property
    @pulumi.getter(name="sourceUri")
    def source_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI of an existing blob, or a file in the Azure File service, to use as the source contents for the blob to be created. Changing this forces a new resource to be created. This field cannot be specified for Append blobs and cannot be specified if `source` or `source_content` is specified.
        """
        return pulumi.get(self, "source_uri")

    @source_uri.setter
    def source_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_uri", value)


@pulumi.input_type
class _BlobState:
    def __init__(__self__, *,
                 access_tier: Optional[pulumi.Input[builtins.str]] = None,
                 cache_control: Optional[pulumi.Input[builtins.str]] = None,
                 content_md5: Optional[pulumi.Input[builtins.str]] = None,
                 content_type: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_scope: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parallelism: Optional[pulumi.Input[builtins.int]] = None,
                 size: Optional[pulumi.Input[builtins.int]] = None,
                 source: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]] = None,
                 source_content: Optional[pulumi.Input[builtins.str]] = None,
                 source_uri: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_name: Optional[pulumi.Input[builtins.str]] = None,
                 storage_container_name: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Blob resources.
        :param pulumi.Input[builtins.str] access_tier: The access tier of the storage blob. Possible values are `Archive`, `Cool` and `Hot`.
        :param pulumi.Input[builtins.str] cache_control: Controls the [cache control header](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Cache-Control) content of the response when blob is requested .
        :param pulumi.Input[builtins.str] content_md5: The MD5 sum of the blob contents. Cannot be defined if `source_uri` is defined, or if blob type is Append or Page. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] content_type: The content type of the storage blob. Cannot be defined if `source_uri` is defined. Defaults to `application/octet-stream`.
        :param pulumi.Input[builtins.str] encryption_scope: The encryption scope to use for this blob.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: A map of custom blob metadata.
        :param pulumi.Input[builtins.str] name: The name of the storage blob. Must be unique within the storage container the blob is located. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] parallelism: The number of workers per CPU core to run for concurrent uploads. Defaults to `8`. Changing this forces a new resource to be created.
               
               > **NOTE:** `parallelism` is only applicable for Page blobs - support for [Block Blobs is blocked on the upstream issue](https://github.com/jackofallops/giovanni/issues/15).
        :param pulumi.Input[builtins.int] size: Used only for `page` blobs to specify the size in bytes of the blob to be created. Must be a multiple of 512. Defaults to `0`. Changing this forces a new resource to be created.
               
               > **Note:** `size` is required if `source_uri` is not set.
        :param pulumi.Input[Union[pulumi.Asset, pulumi.Archive]] source: An absolute path to a file on the local system. This field cannot be specified for Append blobs and cannot be specified if `source_content` or `source_uri` is specified. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_content: The content for this blob which should be defined inline. This field can only be specified for Block blobs and cannot be specified if `source` or `source_uri` is specified. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_uri: The URI of an existing blob, or a file in the Azure File service, to use as the source contents for the blob to be created. Changing this forces a new resource to be created. This field cannot be specified for Append blobs and cannot be specified if `source` or `source_content` is specified.
        :param pulumi.Input[builtins.str] storage_account_name: Specifies the storage account in which to create the storage container. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] storage_container_name: The name of the storage container in which this blob should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] type: The type of the storage blob to be created. Possible values are `Append`, `Block` or `Page`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] url: The URL of the blob
        """
        if access_tier is not None:
            pulumi.set(__self__, "access_tier", access_tier)
        if cache_control is not None:
            pulumi.set(__self__, "cache_control", cache_control)
        if content_md5 is not None:
            pulumi.set(__self__, "content_md5", content_md5)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if encryption_scope is not None:
            pulumi.set(__self__, "encryption_scope", encryption_scope)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parallelism is not None:
            pulumi.set(__self__, "parallelism", parallelism)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_content is not None:
            pulumi.set(__self__, "source_content", source_content)
        if source_uri is not None:
            pulumi.set(__self__, "source_uri", source_uri)
        if storage_account_name is not None:
            pulumi.set(__self__, "storage_account_name", storage_account_name)
        if storage_container_name is not None:
            pulumi.set(__self__, "storage_container_name", storage_container_name)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="accessTier")
    def access_tier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The access tier of the storage blob. Possible values are `Archive`, `Cool` and `Hot`.
        """
        return pulumi.get(self, "access_tier")

    @access_tier.setter
    def access_tier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_tier", value)

    @property
    @pulumi.getter(name="cacheControl")
    def cache_control(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Controls the [cache control header](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Cache-Control) content of the response when blob is requested .
        """
        return pulumi.get(self, "cache_control")

    @cache_control.setter
    def cache_control(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cache_control", value)

    @property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The MD5 sum of the blob contents. Cannot be defined if `source_uri` is defined, or if blob type is Append or Page. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "content_md5")

    @content_md5.setter
    def content_md5(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_md5", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The content type of the storage blob. Cannot be defined if `source_uri` is defined. Defaults to `application/octet-stream`.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="encryptionScope")
    def encryption_scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The encryption scope to use for this blob.
        """
        return pulumi.get(self, "encryption_scope")

    @encryption_scope.setter
    def encryption_scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "encryption_scope", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of custom blob metadata.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the storage blob. Must be unique within the storage container the blob is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parallelism(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of workers per CPU core to run for concurrent uploads. Defaults to `8`. Changing this forces a new resource to be created.

        > **NOTE:** `parallelism` is only applicable for Page blobs - support for [Block Blobs is blocked on the upstream issue](https://github.com/jackofallops/giovanni/issues/15).
        """
        return pulumi.get(self, "parallelism")

    @parallelism.setter
    def parallelism(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "parallelism", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Used only for `page` blobs to specify the size in bytes of the blob to be created. Must be a multiple of 512. Defaults to `0`. Changing this forces a new resource to be created.

        > **Note:** `size` is required if `source_uri` is not set.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]:
        """
        An absolute path to a file on the local system. This field cannot be specified for Append blobs and cannot be specified if `source_content` or `source_uri` is specified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="sourceContent")
    def source_content(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The content for this blob which should be defined inline. This field can only be specified for Block blobs and cannot be specified if `source` or `source_uri` is specified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_content")

    @source_content.setter
    def source_content(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_content", value)

    @property
    @pulumi.getter(name="sourceUri")
    def source_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI of an existing blob, or a file in the Azure File service, to use as the source contents for the blob to be created. Changing this forces a new resource to be created. This field cannot be specified for Append blobs and cannot be specified if `source` or `source_content` is specified.
        """
        return pulumi.get(self, "source_uri")

    @source_uri.setter
    def source_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_uri", value)

    @property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the storage account in which to create the storage container. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_name")

    @storage_account_name.setter
    def storage_account_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_account_name", value)

    @property
    @pulumi.getter(name="storageContainerName")
    def storage_container_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the storage container in which this blob should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_container_name")

    @storage_container_name.setter
    def storage_container_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_container_name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the storage blob to be created. Possible values are `Append`, `Block` or `Page`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL of the blob
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("azure:storage/blob:Blob")
class Blob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_tier: Optional[pulumi.Input[builtins.str]] = None,
                 cache_control: Optional[pulumi.Input[builtins.str]] = None,
                 content_md5: Optional[pulumi.Input[builtins.str]] = None,
                 content_type: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_scope: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parallelism: Optional[pulumi.Input[builtins.int]] = None,
                 size: Optional[pulumi.Input[builtins.int]] = None,
                 source: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]] = None,
                 source_content: Optional[pulumi.Input[builtins.str]] = None,
                 source_uri: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_name: Optional[pulumi.Input[builtins.str]] = None,
                 storage_container_name: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Blob within a Storage Container.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestoracc",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="content",
            storage_account_id=example_account.id,
            container_access_type="private")
        example_blob = azure.storage.Blob("example",
            name="my-awesome-content.zip",
            storage_account_name=example_account.name,
            storage_container_name=example_container.name,
            type="Block",
            source=pulumi.FileAsset("some-local-file.zip"))
        ```

        ## Import

        Storage Blob's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/blob:Blob blob1 https://example.blob.core.windows.net/container/blob.vhd
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_tier: The access tier of the storage blob. Possible values are `Archive`, `Cool` and `Hot`.
        :param pulumi.Input[builtins.str] cache_control: Controls the [cache control header](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Cache-Control) content of the response when blob is requested .
        :param pulumi.Input[builtins.str] content_md5: The MD5 sum of the blob contents. Cannot be defined if `source_uri` is defined, or if blob type is Append or Page. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] content_type: The content type of the storage blob. Cannot be defined if `source_uri` is defined. Defaults to `application/octet-stream`.
        :param pulumi.Input[builtins.str] encryption_scope: The encryption scope to use for this blob.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: A map of custom blob metadata.
        :param pulumi.Input[builtins.str] name: The name of the storage blob. Must be unique within the storage container the blob is located. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] parallelism: The number of workers per CPU core to run for concurrent uploads. Defaults to `8`. Changing this forces a new resource to be created.
               
               > **NOTE:** `parallelism` is only applicable for Page blobs - support for [Block Blobs is blocked on the upstream issue](https://github.com/jackofallops/giovanni/issues/15).
        :param pulumi.Input[builtins.int] size: Used only for `page` blobs to specify the size in bytes of the blob to be created. Must be a multiple of 512. Defaults to `0`. Changing this forces a new resource to be created.
               
               > **Note:** `size` is required if `source_uri` is not set.
        :param pulumi.Input[Union[pulumi.Asset, pulumi.Archive]] source: An absolute path to a file on the local system. This field cannot be specified for Append blobs and cannot be specified if `source_content` or `source_uri` is specified. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_content: The content for this blob which should be defined inline. This field can only be specified for Block blobs and cannot be specified if `source` or `source_uri` is specified. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_uri: The URI of an existing blob, or a file in the Azure File service, to use as the source contents for the blob to be created. Changing this forces a new resource to be created. This field cannot be specified for Append blobs and cannot be specified if `source` or `source_content` is specified.
        :param pulumi.Input[builtins.str] storage_account_name: Specifies the storage account in which to create the storage container. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] storage_container_name: The name of the storage container in which this blob should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] type: The type of the storage blob to be created. Possible values are `Append`, `Block` or `Page`. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BlobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Blob within a Storage Container.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestoracc",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="content",
            storage_account_id=example_account.id,
            container_access_type="private")
        example_blob = azure.storage.Blob("example",
            name="my-awesome-content.zip",
            storage_account_name=example_account.name,
            storage_container_name=example_container.name,
            type="Block",
            source=pulumi.FileAsset("some-local-file.zip"))
        ```

        ## Import

        Storage Blob's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/blob:Blob blob1 https://example.blob.core.windows.net/container/blob.vhd
        ```

        :param str resource_name: The name of the resource.
        :param BlobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BlobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_tier: Optional[pulumi.Input[builtins.str]] = None,
                 cache_control: Optional[pulumi.Input[builtins.str]] = None,
                 content_md5: Optional[pulumi.Input[builtins.str]] = None,
                 content_type: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_scope: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parallelism: Optional[pulumi.Input[builtins.int]] = None,
                 size: Optional[pulumi.Input[builtins.int]] = None,
                 source: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]] = None,
                 source_content: Optional[pulumi.Input[builtins.str]] = None,
                 source_uri: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_name: Optional[pulumi.Input[builtins.str]] = None,
                 storage_container_name: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BlobArgs.__new__(BlobArgs)

            __props__.__dict__["access_tier"] = access_tier
            __props__.__dict__["cache_control"] = cache_control
            __props__.__dict__["content_md5"] = content_md5
            __props__.__dict__["content_type"] = content_type
            __props__.__dict__["encryption_scope"] = encryption_scope
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["name"] = name
            __props__.__dict__["parallelism"] = parallelism
            __props__.__dict__["size"] = size
            __props__.__dict__["source"] = source
            __props__.__dict__["source_content"] = source_content
            __props__.__dict__["source_uri"] = source_uri
            if storage_account_name is None and not opts.urn:
                raise TypeError("Missing required property 'storage_account_name'")
            __props__.__dict__["storage_account_name"] = storage_account_name
            if storage_container_name is None and not opts.urn:
                raise TypeError("Missing required property 'storage_container_name'")
            __props__.__dict__["storage_container_name"] = storage_container_name
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["url"] = None
        super(Blob, __self__).__init__(
            'azure:storage/blob:Blob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_tier: Optional[pulumi.Input[builtins.str]] = None,
            cache_control: Optional[pulumi.Input[builtins.str]] = None,
            content_md5: Optional[pulumi.Input[builtins.str]] = None,
            content_type: Optional[pulumi.Input[builtins.str]] = None,
            encryption_scope: Optional[pulumi.Input[builtins.str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            parallelism: Optional[pulumi.Input[builtins.int]] = None,
            size: Optional[pulumi.Input[builtins.int]] = None,
            source: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]] = None,
            source_content: Optional[pulumi.Input[builtins.str]] = None,
            source_uri: Optional[pulumi.Input[builtins.str]] = None,
            storage_account_name: Optional[pulumi.Input[builtins.str]] = None,
            storage_container_name: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            url: Optional[pulumi.Input[builtins.str]] = None) -> 'Blob':
        """
        Get an existing Blob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_tier: The access tier of the storage blob. Possible values are `Archive`, `Cool` and `Hot`.
        :param pulumi.Input[builtins.str] cache_control: Controls the [cache control header](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Cache-Control) content of the response when blob is requested .
        :param pulumi.Input[builtins.str] content_md5: The MD5 sum of the blob contents. Cannot be defined if `source_uri` is defined, or if blob type is Append or Page. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] content_type: The content type of the storage blob. Cannot be defined if `source_uri` is defined. Defaults to `application/octet-stream`.
        :param pulumi.Input[builtins.str] encryption_scope: The encryption scope to use for this blob.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: A map of custom blob metadata.
        :param pulumi.Input[builtins.str] name: The name of the storage blob. Must be unique within the storage container the blob is located. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] parallelism: The number of workers per CPU core to run for concurrent uploads. Defaults to `8`. Changing this forces a new resource to be created.
               
               > **NOTE:** `parallelism` is only applicable for Page blobs - support for [Block Blobs is blocked on the upstream issue](https://github.com/jackofallops/giovanni/issues/15).
        :param pulumi.Input[builtins.int] size: Used only for `page` blobs to specify the size in bytes of the blob to be created. Must be a multiple of 512. Defaults to `0`. Changing this forces a new resource to be created.
               
               > **Note:** `size` is required if `source_uri` is not set.
        :param pulumi.Input[Union[pulumi.Asset, pulumi.Archive]] source: An absolute path to a file on the local system. This field cannot be specified for Append blobs and cannot be specified if `source_content` or `source_uri` is specified. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_content: The content for this blob which should be defined inline. This field can only be specified for Block blobs and cannot be specified if `source` or `source_uri` is specified. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_uri: The URI of an existing blob, or a file in the Azure File service, to use as the source contents for the blob to be created. Changing this forces a new resource to be created. This field cannot be specified for Append blobs and cannot be specified if `source` or `source_content` is specified.
        :param pulumi.Input[builtins.str] storage_account_name: Specifies the storage account in which to create the storage container. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] storage_container_name: The name of the storage container in which this blob should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] type: The type of the storage blob to be created. Possible values are `Append`, `Block` or `Page`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] url: The URL of the blob
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BlobState.__new__(_BlobState)

        __props__.__dict__["access_tier"] = access_tier
        __props__.__dict__["cache_control"] = cache_control
        __props__.__dict__["content_md5"] = content_md5
        __props__.__dict__["content_type"] = content_type
        __props__.__dict__["encryption_scope"] = encryption_scope
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["parallelism"] = parallelism
        __props__.__dict__["size"] = size
        __props__.__dict__["source"] = source
        __props__.__dict__["source_content"] = source_content
        __props__.__dict__["source_uri"] = source_uri
        __props__.__dict__["storage_account_name"] = storage_account_name
        __props__.__dict__["storage_container_name"] = storage_container_name
        __props__.__dict__["type"] = type
        __props__.__dict__["url"] = url
        return Blob(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessTier")
    def access_tier(self) -> pulumi.Output[builtins.str]:
        """
        The access tier of the storage blob. Possible values are `Archive`, `Cool` and `Hot`.
        """
        return pulumi.get(self, "access_tier")

    @property
    @pulumi.getter(name="cacheControl")
    def cache_control(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Controls the [cache control header](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Cache-Control) content of the response when blob is requested .
        """
        return pulumi.get(self, "cache_control")

    @property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The MD5 sum of the blob contents. Cannot be defined if `source_uri` is defined, or if blob type is Append or Page. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "content_md5")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The content type of the storage blob. Cannot be defined if `source_uri` is defined. Defaults to `application/octet-stream`.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="encryptionScope")
    def encryption_scope(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The encryption scope to use for this blob.
        """
        return pulumi.get(self, "encryption_scope")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of custom blob metadata.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the storage blob. Must be unique within the storage container the blob is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parallelism(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of workers per CPU core to run for concurrent uploads. Defaults to `8`. Changing this forces a new resource to be created.

        > **NOTE:** `parallelism` is only applicable for Page blobs - support for [Block Blobs is blocked on the upstream issue](https://github.com/jackofallops/giovanni/issues/15).
        """
        return pulumi.get(self, "parallelism")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Used only for `page` blobs to specify the size in bytes of the blob to be created. Must be a multiple of 512. Defaults to `0`. Changing this forces a new resource to be created.

        > **Note:** `size` is required if `source_uri` is not set.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[Optional[Union[pulumi.Asset, pulumi.Archive]]]:
        """
        An absolute path to a file on the local system. This field cannot be specified for Append blobs and cannot be specified if `source_content` or `source_uri` is specified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="sourceContent")
    def source_content(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The content for this blob which should be defined inline. This field can only be specified for Block blobs and cannot be specified if `source` or `source_uri` is specified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_content")

    @property
    @pulumi.getter(name="sourceUri")
    def source_uri(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The URI of an existing blob, or a file in the Azure File service, to use as the source contents for the blob to be created. Changing this forces a new resource to be created. This field cannot be specified for Append blobs and cannot be specified if `source` or `source_content` is specified.
        """
        return pulumi.get(self, "source_uri")

    @property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the storage account in which to create the storage container. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_name")

    @property
    @pulumi.getter(name="storageContainerName")
    def storage_container_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the storage container in which this blob should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_container_name")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The type of the storage blob to be created. Possible values are `Append`, `Block` or `Page`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[builtins.str]:
        """
        The URL of the blob
        """
        return pulumi.get(self, "url")

