# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CustomerManagedKeyArgs', 'CustomerManagedKey']

@pulumi.input_type
class CustomerManagedKeyArgs:
    def __init__(__self__, *,
                 key_name: pulumi.Input[builtins.str],
                 storage_account_id: pulumi.Input[builtins.str],
                 federated_identity_client_id: Optional[pulumi.Input[builtins.str]] = None,
                 key_vault_id: Optional[pulumi.Input[builtins.str]] = None,
                 key_vault_uri: Optional[pulumi.Input[builtins.str]] = None,
                 key_version: Optional[pulumi.Input[builtins.str]] = None,
                 managed_hsm_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 user_assigned_identity_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CustomerManagedKey resource.
        :param pulumi.Input[builtins.str] key_name: The name of Key Vault Key.
        :param pulumi.Input[builtins.str] storage_account_id: The ID of the Storage Account. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] federated_identity_client_id: The Client ID of the multi-tenant application to be used in conjunction with the user-assigned identity for cross-tenant customer-managed-keys server-side encryption on the storage account.
        :param pulumi.Input[builtins.str] key_vault_uri: URI pointing at the Key Vault. Required when using `federated_identity_client_id`. Exactly one of `managed_hsm_key_id`, `key_vault_id`, or `key_vault_uri` must be specified.
        :param pulumi.Input[builtins.str] key_version: The version of Key Vault Key. Remove or omit this argument to enable Automatic Key Rotation.
        :param pulumi.Input[builtins.str] managed_hsm_key_id: Key ID of a key in a managed HSM.  Exactly one of `managed_hsm_key_id`, `key_vault_id`, or `key_vault_uri` must be specified.
        :param pulumi.Input[builtins.str] user_assigned_identity_id: The ID of a user assigned identity.
        """
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        if federated_identity_client_id is not None:
            pulumi.set(__self__, "federated_identity_client_id", federated_identity_client_id)
        if key_vault_id is not None:
            pulumi.set(__self__, "key_vault_id", key_vault_id)
        if key_vault_uri is not None:
            pulumi.set(__self__, "key_vault_uri", key_vault_uri)
        if key_version is not None:
            pulumi.set(__self__, "key_version", key_version)
        if managed_hsm_key_id is not None:
            pulumi.set(__self__, "managed_hsm_key_id", managed_hsm_key_id)
        if user_assigned_identity_id is not None:
            pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of Key Vault Key.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Storage Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "storage_account_id", value)

    @property
    @pulumi.getter(name="federatedIdentityClientId")
    def federated_identity_client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Client ID of the multi-tenant application to be used in conjunction with the user-assigned identity for cross-tenant customer-managed-keys server-side encryption on the storage account.
        """
        return pulumi.get(self, "federated_identity_client_id")

    @federated_identity_client_id.setter
    def federated_identity_client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "federated_identity_client_id", value)

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "key_vault_id")

    @key_vault_id.setter
    def key_vault_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_vault_id", value)

    @property
    @pulumi.getter(name="keyVaultUri")
    def key_vault_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URI pointing at the Key Vault. Required when using `federated_identity_client_id`. Exactly one of `managed_hsm_key_id`, `key_vault_id`, or `key_vault_uri` must be specified.
        """
        return pulumi.get(self, "key_vault_uri")

    @key_vault_uri.setter
    def key_vault_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_vault_uri", value)

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of Key Vault Key. Remove or omit this argument to enable Automatic Key Rotation.
        """
        return pulumi.get(self, "key_version")

    @key_version.setter
    def key_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_version", value)

    @property
    @pulumi.getter(name="managedHsmKeyId")
    def managed_hsm_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Key ID of a key in a managed HSM.  Exactly one of `managed_hsm_key_id`, `key_vault_id`, or `key_vault_uri` must be specified.
        """
        return pulumi.get(self, "managed_hsm_key_id")

    @managed_hsm_key_id.setter
    def managed_hsm_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "managed_hsm_key_id", value)

    @property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of a user assigned identity.
        """
        return pulumi.get(self, "user_assigned_identity_id")

    @user_assigned_identity_id.setter
    def user_assigned_identity_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_assigned_identity_id", value)


@pulumi.input_type
class _CustomerManagedKeyState:
    def __init__(__self__, *,
                 federated_identity_client_id: Optional[pulumi.Input[builtins.str]] = None,
                 key_name: Optional[pulumi.Input[builtins.str]] = None,
                 key_vault_id: Optional[pulumi.Input[builtins.str]] = None,
                 key_vault_uri: Optional[pulumi.Input[builtins.str]] = None,
                 key_version: Optional[pulumi.Input[builtins.str]] = None,
                 managed_hsm_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 user_assigned_identity_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CustomerManagedKey resources.
        :param pulumi.Input[builtins.str] federated_identity_client_id: The Client ID of the multi-tenant application to be used in conjunction with the user-assigned identity for cross-tenant customer-managed-keys server-side encryption on the storage account.
        :param pulumi.Input[builtins.str] key_name: The name of Key Vault Key.
        :param pulumi.Input[builtins.str] key_vault_uri: URI pointing at the Key Vault. Required when using `federated_identity_client_id`. Exactly one of `managed_hsm_key_id`, `key_vault_id`, or `key_vault_uri` must be specified.
        :param pulumi.Input[builtins.str] key_version: The version of Key Vault Key. Remove or omit this argument to enable Automatic Key Rotation.
        :param pulumi.Input[builtins.str] managed_hsm_key_id: Key ID of a key in a managed HSM.  Exactly one of `managed_hsm_key_id`, `key_vault_id`, or `key_vault_uri` must be specified.
        :param pulumi.Input[builtins.str] storage_account_id: The ID of the Storage Account. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] user_assigned_identity_id: The ID of a user assigned identity.
        """
        if federated_identity_client_id is not None:
            pulumi.set(__self__, "federated_identity_client_id", federated_identity_client_id)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if key_vault_id is not None:
            pulumi.set(__self__, "key_vault_id", key_vault_id)
        if key_vault_uri is not None:
            pulumi.set(__self__, "key_vault_uri", key_vault_uri)
        if key_version is not None:
            pulumi.set(__self__, "key_version", key_version)
        if managed_hsm_key_id is not None:
            pulumi.set(__self__, "managed_hsm_key_id", managed_hsm_key_id)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)
        if user_assigned_identity_id is not None:
            pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)

    @property
    @pulumi.getter(name="federatedIdentityClientId")
    def federated_identity_client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Client ID of the multi-tenant application to be used in conjunction with the user-assigned identity for cross-tenant customer-managed-keys server-side encryption on the storage account.
        """
        return pulumi.get(self, "federated_identity_client_id")

    @federated_identity_client_id.setter
    def federated_identity_client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "federated_identity_client_id", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of Key Vault Key.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "key_vault_id")

    @key_vault_id.setter
    def key_vault_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_vault_id", value)

    @property
    @pulumi.getter(name="keyVaultUri")
    def key_vault_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URI pointing at the Key Vault. Required when using `federated_identity_client_id`. Exactly one of `managed_hsm_key_id`, `key_vault_id`, or `key_vault_uri` must be specified.
        """
        return pulumi.get(self, "key_vault_uri")

    @key_vault_uri.setter
    def key_vault_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_vault_uri", value)

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of Key Vault Key. Remove or omit this argument to enable Automatic Key Rotation.
        """
        return pulumi.get(self, "key_version")

    @key_version.setter
    def key_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_version", value)

    @property
    @pulumi.getter(name="managedHsmKeyId")
    def managed_hsm_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Key ID of a key in a managed HSM.  Exactly one of `managed_hsm_key_id`, `key_vault_id`, or `key_vault_uri` must be specified.
        """
        return pulumi.get(self, "managed_hsm_key_id")

    @managed_hsm_key_id.setter
    def managed_hsm_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "managed_hsm_key_id", value)

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Storage Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_account_id", value)

    @property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of a user assigned identity.
        """
        return pulumi.get(self, "user_assigned_identity_id")

    @user_assigned_identity_id.setter
    def user_assigned_identity_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_assigned_identity_id", value)


@pulumi.type_token("azure:storage/customerManagedKey:CustomerManagedKey")
class CustomerManagedKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 federated_identity_client_id: Optional[pulumi.Input[builtins.str]] = None,
                 key_name: Optional[pulumi.Input[builtins.str]] = None,
                 key_vault_id: Optional[pulumi.Input[builtins.str]] = None,
                 key_vault_uri: Optional[pulumi.Input[builtins.str]] = None,
                 key_version: Optional[pulumi.Input[builtins.str]] = None,
                 managed_hsm_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 user_assigned_identity_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Customer Managed Key for a Storage Account.

        > **Note:** It's possible to define a Customer Managed Key both within the `storage.Account` resource via the `customer_managed_key` block and by using the `storage.CustomerManagedKey` resource. However it's not possible to use both methods to manage a Customer Managed Key for a Storage Account, since there'll be conflicts.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekv",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            purge_protection_enabled=True)
        example_account = azure.storage.Account("example",
            name="examplestor",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="GRS",
            identity={
                "type": "SystemAssigned",
            })
        storage = azure.keyvault.AccessPolicy("storage",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=example_account.identity.principal_id,
            secret_permissions=["Get"],
            key_permissions=[
                "Get",
                "UnwrapKey",
                "WrapKey",
            ])
        client = azure.keyvault.AccessPolicy("client",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=current.object_id,
            secret_permissions=["Get"],
            key_permissions=[
                "Get",
                "Create",
                "Delete",
                "List",
                "Restore",
                "Recover",
                "UnwrapKey",
                "WrapKey",
                "Purge",
                "Encrypt",
                "Decrypt",
                "Sign",
                "Verify",
                "GetRotationPolicy",
                "SetRotationPolicy",
            ])
        example_key = azure.keyvault.Key("example",
            name="tfex-key",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "decrypt",
                "encrypt",
                "sign",
                "unwrapKey",
                "verify",
                "wrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    client,
                    storage,
                ]))
        example_customer_managed_key = azure.storage.CustomerManagedKey("example",
            storage_account_id=example_account.id,
            key_vault_id=example_key_vault.id,
            key_name=example_key.name)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Storage`: 2023-05-01

        ## Import

        Customer Managed Keys for a Storage Account can be imported using the `resource id` of the Storage Account, e.g.

        ```sh
        $ pulumi import azure:storage/customerManagedKey:CustomerManagedKey example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myresourcegroup/providers/Microsoft.Storage/storageAccounts/myaccount
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] federated_identity_client_id: The Client ID of the multi-tenant application to be used in conjunction with the user-assigned identity for cross-tenant customer-managed-keys server-side encryption on the storage account.
        :param pulumi.Input[builtins.str] key_name: The name of Key Vault Key.
        :param pulumi.Input[builtins.str] key_vault_uri: URI pointing at the Key Vault. Required when using `federated_identity_client_id`. Exactly one of `managed_hsm_key_id`, `key_vault_id`, or `key_vault_uri` must be specified.
        :param pulumi.Input[builtins.str] key_version: The version of Key Vault Key. Remove or omit this argument to enable Automatic Key Rotation.
        :param pulumi.Input[builtins.str] managed_hsm_key_id: Key ID of a key in a managed HSM.  Exactly one of `managed_hsm_key_id`, `key_vault_id`, or `key_vault_uri` must be specified.
        :param pulumi.Input[builtins.str] storage_account_id: The ID of the Storage Account. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] user_assigned_identity_id: The ID of a user assigned identity.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomerManagedKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Customer Managed Key for a Storage Account.

        > **Note:** It's possible to define a Customer Managed Key both within the `storage.Account` resource via the `customer_managed_key` block and by using the `storage.CustomerManagedKey` resource. However it's not possible to use both methods to manage a Customer Managed Key for a Storage Account, since there'll be conflicts.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekv",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            purge_protection_enabled=True)
        example_account = azure.storage.Account("example",
            name="examplestor",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="GRS",
            identity={
                "type": "SystemAssigned",
            })
        storage = azure.keyvault.AccessPolicy("storage",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=example_account.identity.principal_id,
            secret_permissions=["Get"],
            key_permissions=[
                "Get",
                "UnwrapKey",
                "WrapKey",
            ])
        client = azure.keyvault.AccessPolicy("client",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=current.object_id,
            secret_permissions=["Get"],
            key_permissions=[
                "Get",
                "Create",
                "Delete",
                "List",
                "Restore",
                "Recover",
                "UnwrapKey",
                "WrapKey",
                "Purge",
                "Encrypt",
                "Decrypt",
                "Sign",
                "Verify",
                "GetRotationPolicy",
                "SetRotationPolicy",
            ])
        example_key = azure.keyvault.Key("example",
            name="tfex-key",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "decrypt",
                "encrypt",
                "sign",
                "unwrapKey",
                "verify",
                "wrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    client,
                    storage,
                ]))
        example_customer_managed_key = azure.storage.CustomerManagedKey("example",
            storage_account_id=example_account.id,
            key_vault_id=example_key_vault.id,
            key_name=example_key.name)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Storage`: 2023-05-01

        ## Import

        Customer Managed Keys for a Storage Account can be imported using the `resource id` of the Storage Account, e.g.

        ```sh
        $ pulumi import azure:storage/customerManagedKey:CustomerManagedKey example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myresourcegroup/providers/Microsoft.Storage/storageAccounts/myaccount
        ```

        :param str resource_name: The name of the resource.
        :param CustomerManagedKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomerManagedKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 federated_identity_client_id: Optional[pulumi.Input[builtins.str]] = None,
                 key_name: Optional[pulumi.Input[builtins.str]] = None,
                 key_vault_id: Optional[pulumi.Input[builtins.str]] = None,
                 key_vault_uri: Optional[pulumi.Input[builtins.str]] = None,
                 key_version: Optional[pulumi.Input[builtins.str]] = None,
                 managed_hsm_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 user_assigned_identity_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomerManagedKeyArgs.__new__(CustomerManagedKeyArgs)

            __props__.__dict__["federated_identity_client_id"] = federated_identity_client_id
            if key_name is None and not opts.urn:
                raise TypeError("Missing required property 'key_name'")
            __props__.__dict__["key_name"] = key_name
            __props__.__dict__["key_vault_id"] = key_vault_id
            __props__.__dict__["key_vault_uri"] = key_vault_uri
            __props__.__dict__["key_version"] = key_version
            __props__.__dict__["managed_hsm_key_id"] = managed_hsm_key_id
            if storage_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_account_id'")
            __props__.__dict__["storage_account_id"] = storage_account_id
            __props__.__dict__["user_assigned_identity_id"] = user_assigned_identity_id
        super(CustomerManagedKey, __self__).__init__(
            'azure:storage/customerManagedKey:CustomerManagedKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            federated_identity_client_id: Optional[pulumi.Input[builtins.str]] = None,
            key_name: Optional[pulumi.Input[builtins.str]] = None,
            key_vault_id: Optional[pulumi.Input[builtins.str]] = None,
            key_vault_uri: Optional[pulumi.Input[builtins.str]] = None,
            key_version: Optional[pulumi.Input[builtins.str]] = None,
            managed_hsm_key_id: Optional[pulumi.Input[builtins.str]] = None,
            storage_account_id: Optional[pulumi.Input[builtins.str]] = None,
            user_assigned_identity_id: Optional[pulumi.Input[builtins.str]] = None) -> 'CustomerManagedKey':
        """
        Get an existing CustomerManagedKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] federated_identity_client_id: The Client ID of the multi-tenant application to be used in conjunction with the user-assigned identity for cross-tenant customer-managed-keys server-side encryption on the storage account.
        :param pulumi.Input[builtins.str] key_name: The name of Key Vault Key.
        :param pulumi.Input[builtins.str] key_vault_uri: URI pointing at the Key Vault. Required when using `federated_identity_client_id`. Exactly one of `managed_hsm_key_id`, `key_vault_id`, or `key_vault_uri` must be specified.
        :param pulumi.Input[builtins.str] key_version: The version of Key Vault Key. Remove or omit this argument to enable Automatic Key Rotation.
        :param pulumi.Input[builtins.str] managed_hsm_key_id: Key ID of a key in a managed HSM.  Exactly one of `managed_hsm_key_id`, `key_vault_id`, or `key_vault_uri` must be specified.
        :param pulumi.Input[builtins.str] storage_account_id: The ID of the Storage Account. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] user_assigned_identity_id: The ID of a user assigned identity.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomerManagedKeyState.__new__(_CustomerManagedKeyState)

        __props__.__dict__["federated_identity_client_id"] = federated_identity_client_id
        __props__.__dict__["key_name"] = key_name
        __props__.__dict__["key_vault_id"] = key_vault_id
        __props__.__dict__["key_vault_uri"] = key_vault_uri
        __props__.__dict__["key_version"] = key_version
        __props__.__dict__["managed_hsm_key_id"] = managed_hsm_key_id
        __props__.__dict__["storage_account_id"] = storage_account_id
        __props__.__dict__["user_assigned_identity_id"] = user_assigned_identity_id
        return CustomerManagedKey(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="federatedIdentityClientId")
    def federated_identity_client_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Client ID of the multi-tenant application to be used in conjunction with the user-assigned identity for cross-tenant customer-managed-keys server-side encryption on the storage account.
        """
        return pulumi.get(self, "federated_identity_client_id")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of Key Vault Key.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "key_vault_id")

    @property
    @pulumi.getter(name="keyVaultUri")
    def key_vault_uri(self) -> pulumi.Output[builtins.str]:
        """
        URI pointing at the Key Vault. Required when using `federated_identity_client_id`. Exactly one of `managed_hsm_key_id`, `key_vault_id`, or `key_vault_uri` must be specified.
        """
        return pulumi.get(self, "key_vault_uri")

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The version of Key Vault Key. Remove or omit this argument to enable Automatic Key Rotation.
        """
        return pulumi.get(self, "key_version")

    @property
    @pulumi.getter(name="managedHsmKeyId")
    def managed_hsm_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Key ID of a key in a managed HSM.  Exactly one of `managed_hsm_key_id`, `key_vault_id`, or `key_vault_uri` must be specified.
        """
        return pulumi.get(self, "managed_hsm_key_id")

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Storage Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_id")

    @property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of a user assigned identity.
        """
        return pulumi.get(self, "user_assigned_identity_id")

