# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DataLakeGen2PathArgs', 'DataLakeGen2Path']

@pulumi.input_type
class DataLakeGen2PathArgs:
    def __init__(__self__, *,
                 filesystem_name: pulumi.Input[builtins.str],
                 path: pulumi.Input[builtins.str],
                 resource: pulumi.Input[builtins.str],
                 storage_account_id: pulumi.Input[builtins.str],
                 aces: Optional[pulumi.Input[Sequence[pulumi.Input['DataLakeGen2PathAceArgs']]]] = None,
                 group: Optional[pulumi.Input[builtins.str]] = None,
                 owner: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a DataLakeGen2Path resource.
        :param pulumi.Input[builtins.str] filesystem_name: The name of the Data Lake Gen2 File System which should be created within the Storage Account. Must be unique within the storage account the queue is located. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] path: The path which should be created within the Data Lake Gen2 File System in the Storage Account. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource: Specifies the type for path to create. Currently only `directory` is supported. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] storage_account_id: Specifies the ID of the Storage Account in which the Data Lake Gen2 File System should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['DataLakeGen2PathAceArgs']]] aces: One or more `ace` blocks as defined below to specify the entries for the ACL for the path.
        :param pulumi.Input[builtins.str] group: Specifies the Object ID of the Azure Active Directory Group to make the owning group. Possible values also include `$superuser`.
        :param pulumi.Input[builtins.str] owner: Specifies the Object ID of the Azure Active Directory User to make the owning user. Possible values also include `$superuser`.
        """
        pulumi.set(__self__, "filesystem_name", filesystem_name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        if aces is not None:
            pulumi.set(__self__, "aces", aces)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)

    @property
    @pulumi.getter(name="filesystemName")
    def filesystem_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Data Lake Gen2 File System which should be created within the Storage Account. Must be unique within the storage account the queue is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "filesystem_name")

    @filesystem_name.setter
    def filesystem_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "filesystem_name", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[builtins.str]:
        """
        The path which should be created within the Data Lake Gen2 File System in the Storage Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def resource(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the type for path to create. Currently only `directory` is supported. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource", value)

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the ID of the Storage Account in which the Data Lake Gen2 File System should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "storage_account_id", value)

    @property
    @pulumi.getter
    def aces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataLakeGen2PathAceArgs']]]]:
        """
        One or more `ace` blocks as defined below to specify the entries for the ACL for the path.
        """
        return pulumi.get(self, "aces")

    @aces.setter
    def aces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataLakeGen2PathAceArgs']]]]):
        pulumi.set(self, "aces", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Object ID of the Azure Active Directory Group to make the owning group. Possible values also include `$superuser`.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Object ID of the Azure Active Directory User to make the owning user. Possible values also include `$superuser`.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner", value)


@pulumi.input_type
class _DataLakeGen2PathState:
    def __init__(__self__, *,
                 aces: Optional[pulumi.Input[Sequence[pulumi.Input['DataLakeGen2PathAceArgs']]]] = None,
                 filesystem_name: Optional[pulumi.Input[builtins.str]] = None,
                 group: Optional[pulumi.Input[builtins.str]] = None,
                 owner: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 resource: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DataLakeGen2Path resources.
        :param pulumi.Input[Sequence[pulumi.Input['DataLakeGen2PathAceArgs']]] aces: One or more `ace` blocks as defined below to specify the entries for the ACL for the path.
        :param pulumi.Input[builtins.str] filesystem_name: The name of the Data Lake Gen2 File System which should be created within the Storage Account. Must be unique within the storage account the queue is located. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] group: Specifies the Object ID of the Azure Active Directory Group to make the owning group. Possible values also include `$superuser`.
        :param pulumi.Input[builtins.str] owner: Specifies the Object ID of the Azure Active Directory User to make the owning user. Possible values also include `$superuser`.
        :param pulumi.Input[builtins.str] path: The path which should be created within the Data Lake Gen2 File System in the Storage Account. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource: Specifies the type for path to create. Currently only `directory` is supported. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] storage_account_id: Specifies the ID of the Storage Account in which the Data Lake Gen2 File System should exist. Changing this forces a new resource to be created.
        """
        if aces is not None:
            pulumi.set(__self__, "aces", aces)
        if filesystem_name is not None:
            pulumi.set(__self__, "filesystem_name", filesystem_name)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)

    @property
    @pulumi.getter
    def aces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataLakeGen2PathAceArgs']]]]:
        """
        One or more `ace` blocks as defined below to specify the entries for the ACL for the path.
        """
        return pulumi.get(self, "aces")

    @aces.setter
    def aces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataLakeGen2PathAceArgs']]]]):
        pulumi.set(self, "aces", value)

    @property
    @pulumi.getter(name="filesystemName")
    def filesystem_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Data Lake Gen2 File System which should be created within the Storage Account. Must be unique within the storage account the queue is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "filesystem_name")

    @filesystem_name.setter
    def filesystem_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filesystem_name", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Object ID of the Azure Active Directory Group to make the owning group. Possible values also include `$superuser`.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Object ID of the Azure Active Directory User to make the owning user. Possible values also include `$superuser`.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path which should be created within the Data Lake Gen2 File System in the Storage Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def resource(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the type for path to create. Currently only `directory` is supported. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource", value)

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the ID of the Storage Account in which the Data Lake Gen2 File System should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_account_id", value)


@pulumi.type_token("azure:storage/dataLakeGen2Path:DataLakeGen2Path")
class DataLakeGen2Path(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataLakeGen2PathAceArgs', 'DataLakeGen2PathAceArgsDict']]]]] = None,
                 filesystem_name: Optional[pulumi.Input[builtins.str]] = None,
                 group: Optional[pulumi.Input[builtins.str]] = None,
                 owner: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 resource: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Data Lake Gen2 Path in a File System within an Azure Storage Account.

        > **Note:** This resource requires some `Storage` specific roles which are not granted by default. Some of the built-ins roles that can be attributed are [`Storage Account Contributor`](https://docs.microsoft.com/azure/role-based-access-control/built-in-roles#storage-account-contributor), [`Storage Blob Data Owner`](https://docs.microsoft.com/azure/role-based-access-control/built-in-roles#storage-blob-data-owner), [`Storage Blob Data Contributor`](https://docs.microsoft.com/azure/role-based-access-control/built-in-roles#storage-blob-data-contributor), [`Storage Blob Data Reader`](https://docs.microsoft.com/azure/role-based-access-control/built-in-roles#storage-blob-data-reader).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestorageacc",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS",
            account_kind="StorageV2",
            is_hns_enabled=True)
        example_data_lake_gen2_filesystem = azure.storage.DataLakeGen2Filesystem("example",
            name="example",
            storage_account_id=example_account.id)
        example_data_lake_gen2_path = azure.storage.DataLakeGen2Path("example",
            path="example",
            filesystem_name=example_data_lake_gen2_filesystem.name,
            storage_account_id=example_account.id,
            resource="directory")
        ```

        ## Import

        Data Lake Gen2 Paths can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/dataLakeGen2Path:DataLakeGen2Path example https://account1.dfs.core.windows.net/fileSystem1/path
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DataLakeGen2PathAceArgs', 'DataLakeGen2PathAceArgsDict']]]] aces: One or more `ace` blocks as defined below to specify the entries for the ACL for the path.
        :param pulumi.Input[builtins.str] filesystem_name: The name of the Data Lake Gen2 File System which should be created within the Storage Account. Must be unique within the storage account the queue is located. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] group: Specifies the Object ID of the Azure Active Directory Group to make the owning group. Possible values also include `$superuser`.
        :param pulumi.Input[builtins.str] owner: Specifies the Object ID of the Azure Active Directory User to make the owning user. Possible values also include `$superuser`.
        :param pulumi.Input[builtins.str] path: The path which should be created within the Data Lake Gen2 File System in the Storage Account. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource: Specifies the type for path to create. Currently only `directory` is supported. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] storage_account_id: Specifies the ID of the Storage Account in which the Data Lake Gen2 File System should exist. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataLakeGen2PathArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Data Lake Gen2 Path in a File System within an Azure Storage Account.

        > **Note:** This resource requires some `Storage` specific roles which are not granted by default. Some of the built-ins roles that can be attributed are [`Storage Account Contributor`](https://docs.microsoft.com/azure/role-based-access-control/built-in-roles#storage-account-contributor), [`Storage Blob Data Owner`](https://docs.microsoft.com/azure/role-based-access-control/built-in-roles#storage-blob-data-owner), [`Storage Blob Data Contributor`](https://docs.microsoft.com/azure/role-based-access-control/built-in-roles#storage-blob-data-contributor), [`Storage Blob Data Reader`](https://docs.microsoft.com/azure/role-based-access-control/built-in-roles#storage-blob-data-reader).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestorageacc",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS",
            account_kind="StorageV2",
            is_hns_enabled=True)
        example_data_lake_gen2_filesystem = azure.storage.DataLakeGen2Filesystem("example",
            name="example",
            storage_account_id=example_account.id)
        example_data_lake_gen2_path = azure.storage.DataLakeGen2Path("example",
            path="example",
            filesystem_name=example_data_lake_gen2_filesystem.name,
            storage_account_id=example_account.id,
            resource="directory")
        ```

        ## Import

        Data Lake Gen2 Paths can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/dataLakeGen2Path:DataLakeGen2Path example https://account1.dfs.core.windows.net/fileSystem1/path
        ```

        :param str resource_name: The name of the resource.
        :param DataLakeGen2PathArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataLakeGen2PathArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataLakeGen2PathAceArgs', 'DataLakeGen2PathAceArgsDict']]]]] = None,
                 filesystem_name: Optional[pulumi.Input[builtins.str]] = None,
                 group: Optional[pulumi.Input[builtins.str]] = None,
                 owner: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 resource: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataLakeGen2PathArgs.__new__(DataLakeGen2PathArgs)

            __props__.__dict__["aces"] = aces
            if filesystem_name is None and not opts.urn:
                raise TypeError("Missing required property 'filesystem_name'")
            __props__.__dict__["filesystem_name"] = filesystem_name
            __props__.__dict__["group"] = group
            __props__.__dict__["owner"] = owner
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            if resource is None and not opts.urn:
                raise TypeError("Missing required property 'resource'")
            __props__.__dict__["resource"] = resource
            if storage_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_account_id'")
            __props__.__dict__["storage_account_id"] = storage_account_id
        super(DataLakeGen2Path, __self__).__init__(
            'azure:storage/dataLakeGen2Path:DataLakeGen2Path',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataLakeGen2PathAceArgs', 'DataLakeGen2PathAceArgsDict']]]]] = None,
            filesystem_name: Optional[pulumi.Input[builtins.str]] = None,
            group: Optional[pulumi.Input[builtins.str]] = None,
            owner: Optional[pulumi.Input[builtins.str]] = None,
            path: Optional[pulumi.Input[builtins.str]] = None,
            resource: Optional[pulumi.Input[builtins.str]] = None,
            storage_account_id: Optional[pulumi.Input[builtins.str]] = None) -> 'DataLakeGen2Path':
        """
        Get an existing DataLakeGen2Path resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DataLakeGen2PathAceArgs', 'DataLakeGen2PathAceArgsDict']]]] aces: One or more `ace` blocks as defined below to specify the entries for the ACL for the path.
        :param pulumi.Input[builtins.str] filesystem_name: The name of the Data Lake Gen2 File System which should be created within the Storage Account. Must be unique within the storage account the queue is located. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] group: Specifies the Object ID of the Azure Active Directory Group to make the owning group. Possible values also include `$superuser`.
        :param pulumi.Input[builtins.str] owner: Specifies the Object ID of the Azure Active Directory User to make the owning user. Possible values also include `$superuser`.
        :param pulumi.Input[builtins.str] path: The path which should be created within the Data Lake Gen2 File System in the Storage Account. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource: Specifies the type for path to create. Currently only `directory` is supported. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] storage_account_id: Specifies the ID of the Storage Account in which the Data Lake Gen2 File System should exist. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataLakeGen2PathState.__new__(_DataLakeGen2PathState)

        __props__.__dict__["aces"] = aces
        __props__.__dict__["filesystem_name"] = filesystem_name
        __props__.__dict__["group"] = group
        __props__.__dict__["owner"] = owner
        __props__.__dict__["path"] = path
        __props__.__dict__["resource"] = resource
        __props__.__dict__["storage_account_id"] = storage_account_id
        return DataLakeGen2Path(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def aces(self) -> pulumi.Output[Sequence['outputs.DataLakeGen2PathAce']]:
        """
        One or more `ace` blocks as defined below to specify the entries for the ACL for the path.
        """
        return pulumi.get(self, "aces")

    @property
    @pulumi.getter(name="filesystemName")
    def filesystem_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Data Lake Gen2 File System which should be created within the Storage Account. Must be unique within the storage account the queue is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "filesystem_name")

    @property
    @pulumi.getter
    def group(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Object ID of the Azure Active Directory Group to make the owning group. Possible values also include `$superuser`.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Object ID of the Azure Active Directory User to make the owning user. Possible values also include `$superuser`.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[builtins.str]:
        """
        The path which should be created within the Data Lake Gen2 File System in the Storage Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def resource(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the type for path to create. Currently only `directory` is supported. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the ID of the Storage Account in which the Data Lake Gen2 File System should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_id")

