# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAccountSASResult',
    'AwaitableGetAccountSASResult',
    'get_account_sas',
    'get_account_sas_output',
]

@pulumi.output_type
class GetAccountSASResult:
    """
    A collection of values returned by getAccountSAS.
    """
    def __init__(__self__, connection_string=None, expiry=None, https_only=None, id=None, ip_addresses=None, permissions=None, resource_types=None, sas=None, services=None, signed_version=None, start=None):
        if connection_string and not isinstance(connection_string, str):
            raise TypeError("Expected argument 'connection_string' to be a str")
        pulumi.set(__self__, "connection_string", connection_string)
        if expiry and not isinstance(expiry, str):
            raise TypeError("Expected argument 'expiry' to be a str")
        pulumi.set(__self__, "expiry", expiry)
        if https_only and not isinstance(https_only, bool):
            raise TypeError("Expected argument 'https_only' to be a bool")
        pulumi.set(__self__, "https_only", https_only)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_addresses and not isinstance(ip_addresses, str):
            raise TypeError("Expected argument 'ip_addresses' to be a str")
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        if permissions and not isinstance(permissions, dict):
            raise TypeError("Expected argument 'permissions' to be a dict")
        pulumi.set(__self__, "permissions", permissions)
        if resource_types and not isinstance(resource_types, dict):
            raise TypeError("Expected argument 'resource_types' to be a dict")
        pulumi.set(__self__, "resource_types", resource_types)
        if sas and not isinstance(sas, str):
            raise TypeError("Expected argument 'sas' to be a str")
        pulumi.set(__self__, "sas", sas)
        if services and not isinstance(services, dict):
            raise TypeError("Expected argument 'services' to be a dict")
        pulumi.set(__self__, "services", services)
        if signed_version and not isinstance(signed_version, str):
            raise TypeError("Expected argument 'signed_version' to be a str")
        pulumi.set(__self__, "signed_version", signed_version)
        if start and not isinstance(start, str):
            raise TypeError("Expected argument 'start' to be a str")
        pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> builtins.str:
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def expiry(self) -> builtins.str:
        return pulumi.get(self, "expiry")

    @property
    @pulumi.getter(name="httpsOnly")
    def https_only(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "https_only")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[builtins.str]:
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter
    def permissions(self) -> 'outputs.GetAccountSASPermissionsResult':
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> 'outputs.GetAccountSASResourceTypesResult':
        return pulumi.get(self, "resource_types")

    @property
    @pulumi.getter
    def sas(self) -> builtins.str:
        """
        The computed Account Shared Access Signature (SAS).
        """
        return pulumi.get(self, "sas")

    @property
    @pulumi.getter
    def services(self) -> 'outputs.GetAccountSASServicesResult':
        return pulumi.get(self, "services")

    @property
    @pulumi.getter(name="signedVersion")
    def signed_version(self) -> Optional[builtins.str]:
        return pulumi.get(self, "signed_version")

    @property
    @pulumi.getter
    def start(self) -> builtins.str:
        return pulumi.get(self, "start")


class AwaitableGetAccountSASResult(GetAccountSASResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountSASResult(
            connection_string=self.connection_string,
            expiry=self.expiry,
            https_only=self.https_only,
            id=self.id,
            ip_addresses=self.ip_addresses,
            permissions=self.permissions,
            resource_types=self.resource_types,
            sas=self.sas,
            services=self.services,
            signed_version=self.signed_version,
            start=self.start)


def get_account_sas(connection_string: Optional[builtins.str] = None,
                    expiry: Optional[builtins.str] = None,
                    https_only: Optional[builtins.bool] = None,
                    ip_addresses: Optional[builtins.str] = None,
                    permissions: Optional[Union['GetAccountSASPermissionsArgs', 'GetAccountSASPermissionsArgsDict']] = None,
                    resource_types: Optional[Union['GetAccountSASResourceTypesArgs', 'GetAccountSASResourceTypesArgsDict']] = None,
                    services: Optional[Union['GetAccountSASServicesArgs', 'GetAccountSASServicesArgsDict']] = None,
                    signed_version: Optional[builtins.str] = None,
                    start: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountSASResult:
    """
    Use this data source to obtain a Shared Access Signature (SAS Token) for an existing Storage Account.

    Shared access signatures allow fine-grained, ephemeral access control to various aspects of an Azure Storage Account.

    Note that this is an [Account SAS](https://docs.microsoft.com/rest/api/storageservices/constructing-an-account-sas)
    and *not* a [Service SAS](https://docs.microsoft.com/rest/api/storageservices/constructing-a-service-sas).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example_resource_group = azure.core.ResourceGroup("example",
        name="resourceGroupName",
        location="West Europe")
    example_account = azure.storage.Account("example",
        name="storageaccountname",
        resource_group_name=example_resource_group.name,
        location=example_resource_group.location,
        account_tier="Standard",
        account_replication_type="GRS",
        tags={
            "environment": "staging",
        })
    example = azure.storage.get_account_sas_output(connection_string=example_account.primary_connection_string,
        https_only=True,
        signed_version="2022-11-02",
        resource_types={
            "service": True,
            "container": False,
            "object": False,
        },
        services={
            "blob": True,
            "queue": False,
            "table": False,
            "file": False,
        },
        start="2018-03-21T00:00:00Z",
        expiry="2020-03-21T00:00:00Z",
        permissions={
            "read": True,
            "write": True,
            "delete": False,
            "list": False,
            "add": True,
            "create": True,
            "update": False,
            "process": False,
            "tag": False,
            "filter": False,
        })
    pulumi.export("sasUrlQueryString", example.sas)
    ```


    :param builtins.str connection_string: The connection string for the storage account to which this SAS applies. Typically directly from the `primary_connection_string` attribute of a `storage.Account` resource.
    :param builtins.str expiry: The expiration time and date of this SAS. Must be a valid ISO-8601 format time/date string.
           
           > **Note:** The [ISO-8601 Time offset from UTC](https://en.wikipedia.org/wiki/ISO_8601#Time_offsets_from_UTC) is currently not supported by the service, which will result into 409 error.
    :param builtins.bool https_only: Only permit `https` access. If `false`, both `http` and `https` are permitted. Defaults to `true`.
    :param builtins.str ip_addresses: IP address, or a range of IP addresses, from which to accept requests. When specifying a range, note that the range is inclusive.
    :param Union['GetAccountSASPermissionsArgs', 'GetAccountSASPermissionsArgsDict'] permissions: A `permissions` block as defined below.
    :param Union['GetAccountSASResourceTypesArgs', 'GetAccountSASResourceTypesArgsDict'] resource_types: A `resource_types` block as defined below.
    :param Union['GetAccountSASServicesArgs', 'GetAccountSASServicesArgsDict'] services: A `services` block as defined below.
    :param builtins.str signed_version: Specifies the signed storage service version to use to authorize requests made with this account SAS. Defaults to `2022-11-02`.
    :param builtins.str start: The starting time and date of validity of this SAS. Must be a valid ISO-8601 format time/date string.
    """
    __args__ = dict()
    __args__['connectionString'] = connection_string
    __args__['expiry'] = expiry
    __args__['httpsOnly'] = https_only
    __args__['ipAddresses'] = ip_addresses
    __args__['permissions'] = permissions
    __args__['resourceTypes'] = resource_types
    __args__['services'] = services
    __args__['signedVersion'] = signed_version
    __args__['start'] = start
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:storage/getAccountSAS:getAccountSAS', __args__, opts=opts, typ=GetAccountSASResult).value

    return AwaitableGetAccountSASResult(
        connection_string=pulumi.get(__ret__, 'connection_string'),
        expiry=pulumi.get(__ret__, 'expiry'),
        https_only=pulumi.get(__ret__, 'https_only'),
        id=pulumi.get(__ret__, 'id'),
        ip_addresses=pulumi.get(__ret__, 'ip_addresses'),
        permissions=pulumi.get(__ret__, 'permissions'),
        resource_types=pulumi.get(__ret__, 'resource_types'),
        sas=pulumi.get(__ret__, 'sas'),
        services=pulumi.get(__ret__, 'services'),
        signed_version=pulumi.get(__ret__, 'signed_version'),
        start=pulumi.get(__ret__, 'start'))
def get_account_sas_output(connection_string: Optional[pulumi.Input[builtins.str]] = None,
                           expiry: Optional[pulumi.Input[builtins.str]] = None,
                           https_only: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                           ip_addresses: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           permissions: Optional[pulumi.Input[Union['GetAccountSASPermissionsArgs', 'GetAccountSASPermissionsArgsDict']]] = None,
                           resource_types: Optional[pulumi.Input[Union['GetAccountSASResourceTypesArgs', 'GetAccountSASResourceTypesArgsDict']]] = None,
                           services: Optional[pulumi.Input[Union['GetAccountSASServicesArgs', 'GetAccountSASServicesArgsDict']]] = None,
                           signed_version: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           start: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountSASResult]:
    """
    Use this data source to obtain a Shared Access Signature (SAS Token) for an existing Storage Account.

    Shared access signatures allow fine-grained, ephemeral access control to various aspects of an Azure Storage Account.

    Note that this is an [Account SAS](https://docs.microsoft.com/rest/api/storageservices/constructing-an-account-sas)
    and *not* a [Service SAS](https://docs.microsoft.com/rest/api/storageservices/constructing-a-service-sas).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example_resource_group = azure.core.ResourceGroup("example",
        name="resourceGroupName",
        location="West Europe")
    example_account = azure.storage.Account("example",
        name="storageaccountname",
        resource_group_name=example_resource_group.name,
        location=example_resource_group.location,
        account_tier="Standard",
        account_replication_type="GRS",
        tags={
            "environment": "staging",
        })
    example = azure.storage.get_account_sas_output(connection_string=example_account.primary_connection_string,
        https_only=True,
        signed_version="2022-11-02",
        resource_types={
            "service": True,
            "container": False,
            "object": False,
        },
        services={
            "blob": True,
            "queue": False,
            "table": False,
            "file": False,
        },
        start="2018-03-21T00:00:00Z",
        expiry="2020-03-21T00:00:00Z",
        permissions={
            "read": True,
            "write": True,
            "delete": False,
            "list": False,
            "add": True,
            "create": True,
            "update": False,
            "process": False,
            "tag": False,
            "filter": False,
        })
    pulumi.export("sasUrlQueryString", example.sas)
    ```


    :param builtins.str connection_string: The connection string for the storage account to which this SAS applies. Typically directly from the `primary_connection_string` attribute of a `storage.Account` resource.
    :param builtins.str expiry: The expiration time and date of this SAS. Must be a valid ISO-8601 format time/date string.
           
           > **Note:** The [ISO-8601 Time offset from UTC](https://en.wikipedia.org/wiki/ISO_8601#Time_offsets_from_UTC) is currently not supported by the service, which will result into 409 error.
    :param builtins.bool https_only: Only permit `https` access. If `false`, both `http` and `https` are permitted. Defaults to `true`.
    :param builtins.str ip_addresses: IP address, or a range of IP addresses, from which to accept requests. When specifying a range, note that the range is inclusive.
    :param Union['GetAccountSASPermissionsArgs', 'GetAccountSASPermissionsArgsDict'] permissions: A `permissions` block as defined below.
    :param Union['GetAccountSASResourceTypesArgs', 'GetAccountSASResourceTypesArgsDict'] resource_types: A `resource_types` block as defined below.
    :param Union['GetAccountSASServicesArgs', 'GetAccountSASServicesArgsDict'] services: A `services` block as defined below.
    :param builtins.str signed_version: Specifies the signed storage service version to use to authorize requests made with this account SAS. Defaults to `2022-11-02`.
    :param builtins.str start: The starting time and date of validity of this SAS. Must be a valid ISO-8601 format time/date string.
    """
    __args__ = dict()
    __args__['connectionString'] = connection_string
    __args__['expiry'] = expiry
    __args__['httpsOnly'] = https_only
    __args__['ipAddresses'] = ip_addresses
    __args__['permissions'] = permissions
    __args__['resourceTypes'] = resource_types
    __args__['services'] = services
    __args__['signedVersion'] = signed_version
    __args__['start'] = start
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:storage/getAccountSAS:getAccountSAS', __args__, opts=opts, typ=GetAccountSASResult)
    return __ret__.apply(lambda __response__: GetAccountSASResult(
        connection_string=pulumi.get(__response__, 'connection_string'),
        expiry=pulumi.get(__response__, 'expiry'),
        https_only=pulumi.get(__response__, 'https_only'),
        id=pulumi.get(__response__, 'id'),
        ip_addresses=pulumi.get(__response__, 'ip_addresses'),
        permissions=pulumi.get(__response__, 'permissions'),
        resource_types=pulumi.get(__response__, 'resource_types'),
        sas=pulumi.get(__response__, 'sas'),
        services=pulumi.get(__response__, 'services'),
        signed_version=pulumi.get(__response__, 'signed_version'),
        start=pulumi.get(__response__, 'start')))
