# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetContainersResult',
    'AwaitableGetContainersResult',
    'get_containers',
    'get_containers_output',
]

@pulumi.output_type
class GetContainersResult:
    """
    A collection of values returned by getContainers.
    """
    def __init__(__self__, containers=None, id=None, name_prefix=None, storage_account_id=None):
        if containers and not isinstance(containers, list):
            raise TypeError("Expected argument 'containers' to be a list")
        pulumi.set(__self__, "containers", containers)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name_prefix and not isinstance(name_prefix, str):
            raise TypeError("Expected argument 'name_prefix' to be a str")
        pulumi.set(__self__, "name_prefix", name_prefix)
        if storage_account_id and not isinstance(storage_account_id, str):
            raise TypeError("Expected argument 'storage_account_id' to be a str")
        pulumi.set(__self__, "storage_account_id", storage_account_id)

    @property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.GetContainersContainerResult']:
        """
        A `containers` block as defined below.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name_prefix")

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> builtins.str:
        return pulumi.get(self, "storage_account_id")


class AwaitableGetContainersResult(GetContainersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetContainersResult(
            containers=self.containers,
            id=self.id,
            name_prefix=self.name_prefix,
            storage_account_id=self.storage_account_id)


def get_containers(name_prefix: Optional[builtins.str] = None,
                   storage_account_id: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetContainersResult:
    """
    Use this data source to access information about the existing Storage Containers within a Storage Account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.storage.get_containers(storage_account_id="/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Storage/storageAccounts/sa1")
    pulumi.export("containerId", example.containers[0].resource_manager_id)
    ```


    :param builtins.str name_prefix: A prefix match used for the Storage Container `name` field.
    :param builtins.str storage_account_id: The ID of the Storage Account that the Storage Containers reside in.
    """
    __args__ = dict()
    __args__['namePrefix'] = name_prefix
    __args__['storageAccountId'] = storage_account_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:storage/getContainers:getContainers', __args__, opts=opts, typ=GetContainersResult).value

    return AwaitableGetContainersResult(
        containers=pulumi.get(__ret__, 'containers'),
        id=pulumi.get(__ret__, 'id'),
        name_prefix=pulumi.get(__ret__, 'name_prefix'),
        storage_account_id=pulumi.get(__ret__, 'storage_account_id'))
def get_containers_output(name_prefix: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          storage_account_id: Optional[pulumi.Input[builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetContainersResult]:
    """
    Use this data source to access information about the existing Storage Containers within a Storage Account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.storage.get_containers(storage_account_id="/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Storage/storageAccounts/sa1")
    pulumi.export("containerId", example.containers[0].resource_manager_id)
    ```


    :param builtins.str name_prefix: A prefix match used for the Storage Container `name` field.
    :param builtins.str storage_account_id: The ID of the Storage Account that the Storage Containers reside in.
    """
    __args__ = dict()
    __args__['namePrefix'] = name_prefix
    __args__['storageAccountId'] = storage_account_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:storage/getContainers:getContainers', __args__, opts=opts, typ=GetContainersResult)
    return __ret__.apply(lambda __response__: GetContainersResult(
        containers=pulumi.get(__response__, 'containers'),
        id=pulumi.get(__response__, 'id'),
        name_prefix=pulumi.get(__response__, 'name_prefix'),
        storage_account_id=pulumi.get(__response__, 'storage_account_id')))
