# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetQueueResult',
    'AwaitableGetQueueResult',
    'get_queue',
    'get_queue_output',
]

@pulumi.output_type
class GetQueueResult:
    """
    A collection of values returned by getQueue.
    """
    def __init__(__self__, id=None, metadata=None, name=None, resource_manager_id=None, storage_account_name=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_manager_id and not isinstance(resource_manager_id, str):
            raise TypeError("Expected argument 'resource_manager_id' to be a str")
        pulumi.set(__self__, "resource_manager_id", resource_manager_id)
        if storage_account_name and not isinstance(storage_account_name, str):
            raise TypeError("Expected argument 'storage_account_name' to be a str")
        pulumi.set(__self__, "storage_account_name", storage_account_name)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, builtins.str]:
        """
        A mapping of MetaData for this Queue.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceManagerId")
    def resource_manager_id(self) -> builtins.str:
        """
        The Resource Manager ID of this Storage Queue.
        """
        return pulumi.get(self, "resource_manager_id")

    @property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> builtins.str:
        return pulumi.get(self, "storage_account_name")


class AwaitableGetQueueResult(GetQueueResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetQueueResult(
            id=self.id,
            metadata=self.metadata,
            name=self.name,
            resource_manager_id=self.resource_manager_id,
            storage_account_name=self.storage_account_name)


def get_queue(metadata: Optional[Mapping[str, builtins.str]] = None,
              name: Optional[builtins.str] = None,
              storage_account_name: Optional[builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetQueueResult:
    """
    Use this data source to access information about an existing Storage Queue.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.storage.get_queue(name="example-queue-name",
        storage_account_name="example-storage-account-name")
    ```


    :param Mapping[str, builtins.str] metadata: A mapping of MetaData for this Queue.
    :param builtins.str name: The name of the Queue.
    :param builtins.str storage_account_name: The name of the Storage Account where the Queue exists.
    """
    __args__ = dict()
    __args__['metadata'] = metadata
    __args__['name'] = name
    __args__['storageAccountName'] = storage_account_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:storage/getQueue:getQueue', __args__, opts=opts, typ=GetQueueResult).value

    return AwaitableGetQueueResult(
        id=pulumi.get(__ret__, 'id'),
        metadata=pulumi.get(__ret__, 'metadata'),
        name=pulumi.get(__ret__, 'name'),
        resource_manager_id=pulumi.get(__ret__, 'resource_manager_id'),
        storage_account_name=pulumi.get(__ret__, 'storage_account_name'))
def get_queue_output(metadata: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                     name: Optional[pulumi.Input[builtins.str]] = None,
                     storage_account_name: Optional[pulumi.Input[builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetQueueResult]:
    """
    Use this data source to access information about an existing Storage Queue.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.storage.get_queue(name="example-queue-name",
        storage_account_name="example-storage-account-name")
    ```


    :param Mapping[str, builtins.str] metadata: A mapping of MetaData for this Queue.
    :param builtins.str name: The name of the Queue.
    :param builtins.str storage_account_name: The name of the Storage Account where the Queue exists.
    """
    __args__ = dict()
    __args__['metadata'] = metadata
    __args__['name'] = name
    __args__['storageAccountName'] = storage_account_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:storage/getQueue:getQueue', __args__, opts=opts, typ=GetQueueResult)
    return __ret__.apply(lambda __response__: GetQueueResult(
        id=pulumi.get(__response__, 'id'),
        metadata=pulumi.get(__response__, 'metadata'),
        name=pulumi.get(__response__, 'name'),
        resource_manager_id=pulumi.get(__response__, 'resource_manager_id'),
        storage_account_name=pulumi.get(__response__, 'storage_account_name')))
