# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSyncGroupResult',
    'AwaitableGetSyncGroupResult',
    'get_sync_group',
    'get_sync_group_output',
]

@pulumi.output_type
class GetSyncGroupResult:
    """
    A collection of values returned by getSyncGroup.
    """
    def __init__(__self__, id=None, name=None, storage_sync_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if storage_sync_id and not isinstance(storage_sync_id, str):
            raise TypeError("Expected argument 'storage_sync_id' to be a str")
        pulumi.set(__self__, "storage_sync_id", storage_sync_id)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="storageSyncId")
    def storage_sync_id(self) -> builtins.str:
        return pulumi.get(self, "storage_sync_id")


class AwaitableGetSyncGroupResult(GetSyncGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSyncGroupResult(
            id=self.id,
            name=self.name,
            storage_sync_id=self.storage_sync_id)


def get_sync_group(name: Optional[builtins.str] = None,
                   storage_sync_id: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSyncGroupResult:
    """
    Use this data source to access information about an existing Storage Sync Group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.storage.get_sync_group(name="existing-ss-group",
        storage_sync_id="existing-ss-id")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.StorageSync`: 2020-03-01


    :param builtins.str name: The name of this Storage Sync Group.
    :param builtins.str storage_sync_id: The resource ID of the Storage Sync where this Storage Sync Group is.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['storageSyncId'] = storage_sync_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:storage/getSyncGroup:getSyncGroup', __args__, opts=opts, typ=GetSyncGroupResult).value

    return AwaitableGetSyncGroupResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        storage_sync_id=pulumi.get(__ret__, 'storage_sync_id'))
def get_sync_group_output(name: Optional[pulumi.Input[builtins.str]] = None,
                          storage_sync_id: Optional[pulumi.Input[builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSyncGroupResult]:
    """
    Use this data source to access information about an existing Storage Sync Group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.storage.get_sync_group(name="existing-ss-group",
        storage_sync_id="existing-ss-id")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.StorageSync`: 2020-03-01


    :param builtins.str name: The name of this Storage Sync Group.
    :param builtins.str storage_sync_id: The resource ID of the Storage Sync where this Storage Sync Group is.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['storageSyncId'] = storage_sync_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:storage/getSyncGroup:getSyncGroup', __args__, opts=opts, typ=GetSyncGroupResult)
    return __ret__.apply(lambda __response__: GetSyncGroupResult(
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        storage_sync_id=pulumi.get(__response__, 'storage_sync_id')))
