# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTableResult',
    'AwaitableGetTableResult',
    'get_table',
    'get_table_output',
]

@pulumi.output_type
class GetTableResult:
    """
    A collection of values returned by getTable.
    """
    def __init__(__self__, acls=None, id=None, name=None, resource_manager_id=None, storage_account_name=None):
        if acls and not isinstance(acls, list):
            raise TypeError("Expected argument 'acls' to be a list")
        pulumi.set(__self__, "acls", acls)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_manager_id and not isinstance(resource_manager_id, str):
            raise TypeError("Expected argument 'resource_manager_id' to be a str")
        pulumi.set(__self__, "resource_manager_id", resource_manager_id)
        if storage_account_name and not isinstance(storage_account_name, str):
            raise TypeError("Expected argument 'storage_account_name' to be a str")
        pulumi.set(__self__, "storage_account_name", storage_account_name)

    @property
    @pulumi.getter
    def acls(self) -> Sequence['outputs.GetTableAclResult']:
        """
        A mapping of ACLs for this Table.
        """
        return pulumi.get(self, "acls")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the Storage Table.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceManagerId")
    def resource_manager_id(self) -> builtins.str:
        """
        The Resource Manager ID of this Storage Table.
        """
        return pulumi.get(self, "resource_manager_id")

    @property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> builtins.str:
        return pulumi.get(self, "storage_account_name")


class AwaitableGetTableResult(GetTableResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTableResult(
            acls=self.acls,
            id=self.id,
            name=self.name,
            resource_manager_id=self.resource_manager_id,
            storage_account_name=self.storage_account_name)


def get_table(name: Optional[builtins.str] = None,
              storage_account_name: Optional[builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTableResult:
    """
    Use this data source to access information about an existing Storage Table.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.storage.get_table(name="example-table-name",
        storage_account_name="example-storage-account-name")
    ```


    :param builtins.str name: The name of the Table.
    :param builtins.str storage_account_name: The name of the Storage Account where the Table exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['storageAccountName'] = storage_account_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:storage/getTable:getTable', __args__, opts=opts, typ=GetTableResult).value

    return AwaitableGetTableResult(
        acls=pulumi.get(__ret__, 'acls'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        resource_manager_id=pulumi.get(__ret__, 'resource_manager_id'),
        storage_account_name=pulumi.get(__ret__, 'storage_account_name'))
def get_table_output(name: Optional[pulumi.Input[builtins.str]] = None,
                     storage_account_name: Optional[pulumi.Input[builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTableResult]:
    """
    Use this data source to access information about an existing Storage Table.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.storage.get_table(name="example-table-name",
        storage_account_name="example-storage-account-name")
    ```


    :param builtins.str name: The name of the Table.
    :param builtins.str storage_account_name: The name of the Storage Account where the Table exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['storageAccountName'] = storage_account_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:storage/getTable:getTable', __args__, opts=opts, typ=GetTableResult)
    return __ret__.apply(lambda __response__: GetTableResult(
        acls=pulumi.get(__response__, 'acls'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        resource_manager_id=pulumi.get(__response__, 'resource_manager_id'),
        storage_account_name=pulumi.get(__response__, 'storage_account_name')))
