# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MoverProjectArgs', 'MoverProject']

@pulumi.input_type
class MoverProjectArgs:
    def __init__(__self__, *,
                 storage_mover_id: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a MoverProject resource.
        :param pulumi.Input[builtins.str] storage_mover_id: Specifies the ID of the storage mover for this Storage Mover Project. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] description: Specifies a description for this Storage Mover Project.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Storage Mover Project. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "storage_mover_id", storage_mover_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="storageMoverId")
    def storage_mover_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the ID of the storage mover for this Storage Mover Project. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_mover_id")

    @storage_mover_id.setter
    def storage_mover_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "storage_mover_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a description for this Storage Mover Project.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name which should be used for this Storage Mover Project. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _MoverProjectState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 storage_mover_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering MoverProject resources.
        :param pulumi.Input[builtins.str] description: Specifies a description for this Storage Mover Project.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Storage Mover Project. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] storage_mover_id: Specifies the ID of the storage mover for this Storage Mover Project. Changing this forces a new resource to be created.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if storage_mover_id is not None:
            pulumi.set(__self__, "storage_mover_id", storage_mover_id)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a description for this Storage Mover Project.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name which should be used for this Storage Mover Project. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="storageMoverId")
    def storage_mover_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the ID of the storage mover for this Storage Mover Project. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_mover_id")

    @storage_mover_id.setter
    def storage_mover_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_mover_id", value)


@pulumi.type_token("azure:storage/moverProject:MoverProject")
class MoverProject(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 storage_mover_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Storage Mover Project.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_mover = azure.storage.Mover("example",
            name="example-ssm",
            resource_group_name=example.name,
            location=example.location)
        example_mover_project = azure.storage.MoverProject("example",
            name="example-sp",
            storage_mover_id=example_mover.id,
            description="Example Project Description")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StorageMover`: 2023-03-01

        ## Import

        Storage Mover Project can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/moverProject:MoverProject example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.StorageMover/storageMovers/storageMover1/projects/project1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Specifies a description for this Storage Mover Project.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Storage Mover Project. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] storage_mover_id: Specifies the ID of the storage mover for this Storage Mover Project. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MoverProjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Storage Mover Project.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_mover = azure.storage.Mover("example",
            name="example-ssm",
            resource_group_name=example.name,
            location=example.location)
        example_mover_project = azure.storage.MoverProject("example",
            name="example-sp",
            storage_mover_id=example_mover.id,
            description="Example Project Description")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StorageMover`: 2023-03-01

        ## Import

        Storage Mover Project can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/moverProject:MoverProject example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.StorageMover/storageMovers/storageMover1/projects/project1
        ```

        :param str resource_name: The name of the resource.
        :param MoverProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MoverProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 storage_mover_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MoverProjectArgs.__new__(MoverProjectArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if storage_mover_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_mover_id'")
            __props__.__dict__["storage_mover_id"] = storage_mover_id
        super(MoverProject, __self__).__init__(
            'azure:storage/moverProject:MoverProject',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            storage_mover_id: Optional[pulumi.Input[builtins.str]] = None) -> 'MoverProject':
        """
        Get an existing MoverProject resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Specifies a description for this Storage Mover Project.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Storage Mover Project. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] storage_mover_id: Specifies the ID of the storage mover for this Storage Mover Project. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MoverProjectState.__new__(_MoverProjectState)

        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["storage_mover_id"] = storage_mover_id
        return MoverProject(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies a description for this Storage Mover Project.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name which should be used for this Storage Mover Project. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="storageMoverId")
    def storage_mover_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the ID of the storage mover for this Storage Mover Project. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_mover_id")

