# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ObjectReplicationArgs', 'ObjectReplication']

@pulumi.input_type
class ObjectReplicationArgs:
    def __init__(__self__, *,
                 destination_storage_account_id: pulumi.Input[builtins.str],
                 rules: pulumi.Input[Sequence[pulumi.Input['ObjectReplicationRuleArgs']]],
                 source_storage_account_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a ObjectReplication resource.
        :param pulumi.Input[builtins.str] destination_storage_account_id: The ID of the destination storage account. Changing this forces a new Storage Object Replication to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ObjectReplicationRuleArgs']]] rules: One or more `rules` blocks as defined below.
        :param pulumi.Input[builtins.str] source_storage_account_id: The ID of the source storage account. Changing this forces a new Storage Object Replication to be created.
        """
        pulumi.set(__self__, "destination_storage_account_id", destination_storage_account_id)
        pulumi.set(__self__, "rules", rules)
        pulumi.set(__self__, "source_storage_account_id", source_storage_account_id)

    @property
    @pulumi.getter(name="destinationStorageAccountId")
    def destination_storage_account_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the destination storage account. Changing this forces a new Storage Object Replication to be created.
        """
        return pulumi.get(self, "destination_storage_account_id")

    @destination_storage_account_id.setter
    def destination_storage_account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "destination_storage_account_id", value)

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['ObjectReplicationRuleArgs']]]:
        """
        One or more `rules` blocks as defined below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['ObjectReplicationRuleArgs']]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="sourceStorageAccountId")
    def source_storage_account_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the source storage account. Changing this forces a new Storage Object Replication to be created.
        """
        return pulumi.get(self, "source_storage_account_id")

    @source_storage_account_id.setter
    def source_storage_account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_storage_account_id", value)


@pulumi.input_type
class _ObjectReplicationState:
    def __init__(__self__, *,
                 destination_object_replication_id: Optional[pulumi.Input[builtins.str]] = None,
                 destination_storage_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectReplicationRuleArgs']]]] = None,
                 source_object_replication_id: Optional[pulumi.Input[builtins.str]] = None,
                 source_storage_account_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ObjectReplication resources.
        :param pulumi.Input[builtins.str] destination_object_replication_id: The ID of the Object Replication in the destination storage account.
        :param pulumi.Input[builtins.str] destination_storage_account_id: The ID of the destination storage account. Changing this forces a new Storage Object Replication to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ObjectReplicationRuleArgs']]] rules: One or more `rules` blocks as defined below.
        :param pulumi.Input[builtins.str] source_object_replication_id: The ID of the Object Replication in the source storage account.
        :param pulumi.Input[builtins.str] source_storage_account_id: The ID of the source storage account. Changing this forces a new Storage Object Replication to be created.
        """
        if destination_object_replication_id is not None:
            pulumi.set(__self__, "destination_object_replication_id", destination_object_replication_id)
        if destination_storage_account_id is not None:
            pulumi.set(__self__, "destination_storage_account_id", destination_storage_account_id)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if source_object_replication_id is not None:
            pulumi.set(__self__, "source_object_replication_id", source_object_replication_id)
        if source_storage_account_id is not None:
            pulumi.set(__self__, "source_storage_account_id", source_storage_account_id)

    @property
    @pulumi.getter(name="destinationObjectReplicationId")
    def destination_object_replication_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Object Replication in the destination storage account.
        """
        return pulumi.get(self, "destination_object_replication_id")

    @destination_object_replication_id.setter
    def destination_object_replication_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_object_replication_id", value)

    @property
    @pulumi.getter(name="destinationStorageAccountId")
    def destination_storage_account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the destination storage account. Changing this forces a new Storage Object Replication to be created.
        """
        return pulumi.get(self, "destination_storage_account_id")

    @destination_storage_account_id.setter
    def destination_storage_account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_storage_account_id", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectReplicationRuleArgs']]]]:
        """
        One or more `rules` blocks as defined below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectReplicationRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="sourceObjectReplicationId")
    def source_object_replication_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Object Replication in the source storage account.
        """
        return pulumi.get(self, "source_object_replication_id")

    @source_object_replication_id.setter
    def source_object_replication_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_object_replication_id", value)

    @property
    @pulumi.getter(name="sourceStorageAccountId")
    def source_storage_account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the source storage account. Changing this forces a new Storage Object Replication to be created.
        """
        return pulumi.get(self, "source_storage_account_id")

    @source_storage_account_id.setter
    def source_storage_account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_storage_account_id", value)


@pulumi.type_token("azure:storage/objectReplication:ObjectReplication")
class ObjectReplication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_storage_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObjectReplicationRuleArgs', 'ObjectReplicationRuleArgsDict']]]]] = None,
                 source_storage_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Storage Object Replication.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        src = azure.core.ResourceGroup("src",
            name="srcResourceGroupName",
            location="West Europe")
        src_account = azure.storage.Account("src",
            name="srcstorageaccount",
            resource_group_name=src.name,
            location=src.location,
            account_tier="Standard",
            account_replication_type="LRS",
            blob_properties={
                "versioning_enabled": True,
                "change_feed_enabled": True,
            })
        src_container = azure.storage.Container("src",
            name="srcstrcontainer",
            storage_account_name=src_account.name,
            container_access_type="private")
        dst = azure.core.ResourceGroup("dst",
            name="dstResourceGroupName",
            location="East US")
        dst_account = azure.storage.Account("dst",
            name="dststorageaccount",
            resource_group_name=dst.name,
            location=dst.location,
            account_tier="Standard",
            account_replication_type="LRS",
            blob_properties={
                "versioning_enabled": True,
                "change_feed_enabled": True,
            })
        dst_container = azure.storage.Container("dst",
            name="dststrcontainer",
            storage_account_name=dst_account.name,
            container_access_type="private")
        example = azure.storage.ObjectReplication("example",
            source_storage_account_id=src_account.id,
            destination_storage_account_id=dst_account.id,
            rules=[{
                "source_container_name": src_container.name,
                "destination_container_name": dst_container.name,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Storage`: 2023-05-01

        ## Import

        Storage Object Replication Policies can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/objectReplication:ObjectReplication example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Storage/storageAccounts/storageAccount1/objectReplicationPolicies/objectReplicationPolicy1;/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group2/providers/Microsoft.Storage/storageAccounts/storageAccount2/objectReplicationPolicies/objectReplicationPolicy2
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] destination_storage_account_id: The ID of the destination storage account. Changing this forces a new Storage Object Replication to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ObjectReplicationRuleArgs', 'ObjectReplicationRuleArgsDict']]]] rules: One or more `rules` blocks as defined below.
        :param pulumi.Input[builtins.str] source_storage_account_id: The ID of the source storage account. Changing this forces a new Storage Object Replication to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ObjectReplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Storage Object Replication.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        src = azure.core.ResourceGroup("src",
            name="srcResourceGroupName",
            location="West Europe")
        src_account = azure.storage.Account("src",
            name="srcstorageaccount",
            resource_group_name=src.name,
            location=src.location,
            account_tier="Standard",
            account_replication_type="LRS",
            blob_properties={
                "versioning_enabled": True,
                "change_feed_enabled": True,
            })
        src_container = azure.storage.Container("src",
            name="srcstrcontainer",
            storage_account_name=src_account.name,
            container_access_type="private")
        dst = azure.core.ResourceGroup("dst",
            name="dstResourceGroupName",
            location="East US")
        dst_account = azure.storage.Account("dst",
            name="dststorageaccount",
            resource_group_name=dst.name,
            location=dst.location,
            account_tier="Standard",
            account_replication_type="LRS",
            blob_properties={
                "versioning_enabled": True,
                "change_feed_enabled": True,
            })
        dst_container = azure.storage.Container("dst",
            name="dststrcontainer",
            storage_account_name=dst_account.name,
            container_access_type="private")
        example = azure.storage.ObjectReplication("example",
            source_storage_account_id=src_account.id,
            destination_storage_account_id=dst_account.id,
            rules=[{
                "source_container_name": src_container.name,
                "destination_container_name": dst_container.name,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Storage`: 2023-05-01

        ## Import

        Storage Object Replication Policies can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/objectReplication:ObjectReplication example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Storage/storageAccounts/storageAccount1/objectReplicationPolicies/objectReplicationPolicy1;/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group2/providers/Microsoft.Storage/storageAccounts/storageAccount2/objectReplicationPolicies/objectReplicationPolicy2
        ```

        :param str resource_name: The name of the resource.
        :param ObjectReplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ObjectReplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_storage_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObjectReplicationRuleArgs', 'ObjectReplicationRuleArgsDict']]]]] = None,
                 source_storage_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ObjectReplicationArgs.__new__(ObjectReplicationArgs)

            if destination_storage_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'destination_storage_account_id'")
            __props__.__dict__["destination_storage_account_id"] = destination_storage_account_id
            if rules is None and not opts.urn:
                raise TypeError("Missing required property 'rules'")
            __props__.__dict__["rules"] = rules
            if source_storage_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_storage_account_id'")
            __props__.__dict__["source_storage_account_id"] = source_storage_account_id
            __props__.__dict__["destination_object_replication_id"] = None
            __props__.__dict__["source_object_replication_id"] = None
        super(ObjectReplication, __self__).__init__(
            'azure:storage/objectReplication:ObjectReplication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            destination_object_replication_id: Optional[pulumi.Input[builtins.str]] = None,
            destination_storage_account_id: Optional[pulumi.Input[builtins.str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObjectReplicationRuleArgs', 'ObjectReplicationRuleArgsDict']]]]] = None,
            source_object_replication_id: Optional[pulumi.Input[builtins.str]] = None,
            source_storage_account_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ObjectReplication':
        """
        Get an existing ObjectReplication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] destination_object_replication_id: The ID of the Object Replication in the destination storage account.
        :param pulumi.Input[builtins.str] destination_storage_account_id: The ID of the destination storage account. Changing this forces a new Storage Object Replication to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ObjectReplicationRuleArgs', 'ObjectReplicationRuleArgsDict']]]] rules: One or more `rules` blocks as defined below.
        :param pulumi.Input[builtins.str] source_object_replication_id: The ID of the Object Replication in the source storage account.
        :param pulumi.Input[builtins.str] source_storage_account_id: The ID of the source storage account. Changing this forces a new Storage Object Replication to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ObjectReplicationState.__new__(_ObjectReplicationState)

        __props__.__dict__["destination_object_replication_id"] = destination_object_replication_id
        __props__.__dict__["destination_storage_account_id"] = destination_storage_account_id
        __props__.__dict__["rules"] = rules
        __props__.__dict__["source_object_replication_id"] = source_object_replication_id
        __props__.__dict__["source_storage_account_id"] = source_storage_account_id
        return ObjectReplication(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="destinationObjectReplicationId")
    def destination_object_replication_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Object Replication in the destination storage account.
        """
        return pulumi.get(self, "destination_object_replication_id")

    @property
    @pulumi.getter(name="destinationStorageAccountId")
    def destination_storage_account_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the destination storage account. Changing this forces a new Storage Object Replication to be created.
        """
        return pulumi.get(self, "destination_storage_account_id")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.ObjectReplicationRule']]:
        """
        One or more `rules` blocks as defined below.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="sourceObjectReplicationId")
    def source_object_replication_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Object Replication in the source storage account.
        """
        return pulumi.get(self, "source_object_replication_id")

    @property
    @pulumi.getter(name="sourceStorageAccountId")
    def source_storage_account_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the source storage account. Changing this forces a new Storage Object Replication to be created.
        """
        return pulumi.get(self, "source_storage_account_id")

