# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SyncServerEndpointArgs', 'SyncServerEndpoint']

@pulumi.input_type
class SyncServerEndpointArgs:
    def __init__(__self__, *,
                 registered_server_id: pulumi.Input[builtins.str],
                 server_local_path: pulumi.Input[builtins.str],
                 storage_sync_group_id: pulumi.Input[builtins.str],
                 cloud_tiering_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 initial_download_policy: Optional[pulumi.Input[builtins.str]] = None,
                 local_cache_mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tier_files_older_than_days: Optional[pulumi.Input[builtins.int]] = None,
                 volume_free_space_percent: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a SyncServerEndpoint resource.
        :param pulumi.Input[builtins.str] registered_server_id: The ID of the Registered Server that will be associate with the Storage Sync Server Endpoint. Changing this forces a new Storage Sync Server Endpoint to be created.
               
               > **Note:** The target server must already be registered with the parent `storage.Sync` prior to creating this endpoint. For more information on registering a server see the [Microsoft documentation](https://learn.microsoft.com/azure/storage/file-sync/file-sync-server-registration)
        :param pulumi.Input[builtins.str] server_local_path: The path on the Windows Server to be synced to the Azure file share. Changing this forces a new Storage Sync Server Endpoint to be created.
        :param pulumi.Input[builtins.str] storage_sync_group_id: The ID of the Storage Sync Group where the Storage Sync Server Endpoint should exist. Changing this forces a new Storage Sync Server Endpoint to be created.
        :param pulumi.Input[builtins.bool] cloud_tiering_enabled: Is Cloud Tiering Enabled? Defaults to `false`.
        :param pulumi.Input[builtins.str] initial_download_policy: Specifies how the server initially downloads the Azure file share data. Valid Values includes `NamespaceThenModifiedFiles`, `NamespaceOnly`, and `AvoidTieredFiles`. Defaults to `NamespaceThenModifiedFiles`.
        :param pulumi.Input[builtins.str] local_cache_mode: Specifies how to handle the local cache. Valid Values include `UpdateLocallyCachedFiles` and `DownloadNewAndModifiedFiles`. Defaults to `UpdateLocallyCachedFiles`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Storage Sync. Changing this forces a new Storage Sync Server Endpoint to be created.
        :param pulumi.Input[builtins.int] tier_files_older_than_days: Files older than the specified age will be tiered to the cloud.
        :param pulumi.Input[builtins.int] volume_free_space_percent: What percentage of free space on the volume should be preserved? Defaults to `20`.
        """
        pulumi.set(__self__, "registered_server_id", registered_server_id)
        pulumi.set(__self__, "server_local_path", server_local_path)
        pulumi.set(__self__, "storage_sync_group_id", storage_sync_group_id)
        if cloud_tiering_enabled is not None:
            pulumi.set(__self__, "cloud_tiering_enabled", cloud_tiering_enabled)
        if initial_download_policy is not None:
            pulumi.set(__self__, "initial_download_policy", initial_download_policy)
        if local_cache_mode is not None:
            pulumi.set(__self__, "local_cache_mode", local_cache_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier_files_older_than_days is not None:
            pulumi.set(__self__, "tier_files_older_than_days", tier_files_older_than_days)
        if volume_free_space_percent is not None:
            pulumi.set(__self__, "volume_free_space_percent", volume_free_space_percent)

    @property
    @pulumi.getter(name="registeredServerId")
    def registered_server_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Registered Server that will be associate with the Storage Sync Server Endpoint. Changing this forces a new Storage Sync Server Endpoint to be created.

        > **Note:** The target server must already be registered with the parent `storage.Sync` prior to creating this endpoint. For more information on registering a server see the [Microsoft documentation](https://learn.microsoft.com/azure/storage/file-sync/file-sync-server-registration)
        """
        return pulumi.get(self, "registered_server_id")

    @registered_server_id.setter
    def registered_server_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "registered_server_id", value)

    @property
    @pulumi.getter(name="serverLocalPath")
    def server_local_path(self) -> pulumi.Input[builtins.str]:
        """
        The path on the Windows Server to be synced to the Azure file share. Changing this forces a new Storage Sync Server Endpoint to be created.
        """
        return pulumi.get(self, "server_local_path")

    @server_local_path.setter
    def server_local_path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "server_local_path", value)

    @property
    @pulumi.getter(name="storageSyncGroupId")
    def storage_sync_group_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Storage Sync Group where the Storage Sync Server Endpoint should exist. Changing this forces a new Storage Sync Server Endpoint to be created.
        """
        return pulumi.get(self, "storage_sync_group_id")

    @storage_sync_group_id.setter
    def storage_sync_group_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "storage_sync_group_id", value)

    @property
    @pulumi.getter(name="cloudTieringEnabled")
    def cloud_tiering_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is Cloud Tiering Enabled? Defaults to `false`.
        """
        return pulumi.get(self, "cloud_tiering_enabled")

    @cloud_tiering_enabled.setter
    def cloud_tiering_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "cloud_tiering_enabled", value)

    @property
    @pulumi.getter(name="initialDownloadPolicy")
    def initial_download_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies how the server initially downloads the Azure file share data. Valid Values includes `NamespaceThenModifiedFiles`, `NamespaceOnly`, and `AvoidTieredFiles`. Defaults to `NamespaceThenModifiedFiles`.
        """
        return pulumi.get(self, "initial_download_policy")

    @initial_download_policy.setter
    def initial_download_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "initial_download_policy", value)

    @property
    @pulumi.getter(name="localCacheMode")
    def local_cache_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies how to handle the local cache. Valid Values include `UpdateLocallyCachedFiles` and `DownloadNewAndModifiedFiles`. Defaults to `UpdateLocallyCachedFiles`.
        """
        return pulumi.get(self, "local_cache_mode")

    @local_cache_mode.setter
    def local_cache_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "local_cache_mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Storage Sync. Changing this forces a new Storage Sync Server Endpoint to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="tierFilesOlderThanDays")
    def tier_files_older_than_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Files older than the specified age will be tiered to the cloud.
        """
        return pulumi.get(self, "tier_files_older_than_days")

    @tier_files_older_than_days.setter
    def tier_files_older_than_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tier_files_older_than_days", value)

    @property
    @pulumi.getter(name="volumeFreeSpacePercent")
    def volume_free_space_percent(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        What percentage of free space on the volume should be preserved? Defaults to `20`.
        """
        return pulumi.get(self, "volume_free_space_percent")

    @volume_free_space_percent.setter
    def volume_free_space_percent(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "volume_free_space_percent", value)


@pulumi.input_type
class _SyncServerEndpointState:
    def __init__(__self__, *,
                 cloud_tiering_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 initial_download_policy: Optional[pulumi.Input[builtins.str]] = None,
                 local_cache_mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 registered_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 server_local_path: Optional[pulumi.Input[builtins.str]] = None,
                 storage_sync_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 tier_files_older_than_days: Optional[pulumi.Input[builtins.int]] = None,
                 volume_free_space_percent: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering SyncServerEndpoint resources.
        :param pulumi.Input[builtins.bool] cloud_tiering_enabled: Is Cloud Tiering Enabled? Defaults to `false`.
        :param pulumi.Input[builtins.str] initial_download_policy: Specifies how the server initially downloads the Azure file share data. Valid Values includes `NamespaceThenModifiedFiles`, `NamespaceOnly`, and `AvoidTieredFiles`. Defaults to `NamespaceThenModifiedFiles`.
        :param pulumi.Input[builtins.str] local_cache_mode: Specifies how to handle the local cache. Valid Values include `UpdateLocallyCachedFiles` and `DownloadNewAndModifiedFiles`. Defaults to `UpdateLocallyCachedFiles`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Storage Sync. Changing this forces a new Storage Sync Server Endpoint to be created.
        :param pulumi.Input[builtins.str] registered_server_id: The ID of the Registered Server that will be associate with the Storage Sync Server Endpoint. Changing this forces a new Storage Sync Server Endpoint to be created.
               
               > **Note:** The target server must already be registered with the parent `storage.Sync` prior to creating this endpoint. For more information on registering a server see the [Microsoft documentation](https://learn.microsoft.com/azure/storage/file-sync/file-sync-server-registration)
        :param pulumi.Input[builtins.str] server_local_path: The path on the Windows Server to be synced to the Azure file share. Changing this forces a new Storage Sync Server Endpoint to be created.
        :param pulumi.Input[builtins.str] storage_sync_group_id: The ID of the Storage Sync Group where the Storage Sync Server Endpoint should exist. Changing this forces a new Storage Sync Server Endpoint to be created.
        :param pulumi.Input[builtins.int] tier_files_older_than_days: Files older than the specified age will be tiered to the cloud.
        :param pulumi.Input[builtins.int] volume_free_space_percent: What percentage of free space on the volume should be preserved? Defaults to `20`.
        """
        if cloud_tiering_enabled is not None:
            pulumi.set(__self__, "cloud_tiering_enabled", cloud_tiering_enabled)
        if initial_download_policy is not None:
            pulumi.set(__self__, "initial_download_policy", initial_download_policy)
        if local_cache_mode is not None:
            pulumi.set(__self__, "local_cache_mode", local_cache_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if registered_server_id is not None:
            pulumi.set(__self__, "registered_server_id", registered_server_id)
        if server_local_path is not None:
            pulumi.set(__self__, "server_local_path", server_local_path)
        if storage_sync_group_id is not None:
            pulumi.set(__self__, "storage_sync_group_id", storage_sync_group_id)
        if tier_files_older_than_days is not None:
            pulumi.set(__self__, "tier_files_older_than_days", tier_files_older_than_days)
        if volume_free_space_percent is not None:
            pulumi.set(__self__, "volume_free_space_percent", volume_free_space_percent)

    @property
    @pulumi.getter(name="cloudTieringEnabled")
    def cloud_tiering_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is Cloud Tiering Enabled? Defaults to `false`.
        """
        return pulumi.get(self, "cloud_tiering_enabled")

    @cloud_tiering_enabled.setter
    def cloud_tiering_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "cloud_tiering_enabled", value)

    @property
    @pulumi.getter(name="initialDownloadPolicy")
    def initial_download_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies how the server initially downloads the Azure file share data. Valid Values includes `NamespaceThenModifiedFiles`, `NamespaceOnly`, and `AvoidTieredFiles`. Defaults to `NamespaceThenModifiedFiles`.
        """
        return pulumi.get(self, "initial_download_policy")

    @initial_download_policy.setter
    def initial_download_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "initial_download_policy", value)

    @property
    @pulumi.getter(name="localCacheMode")
    def local_cache_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies how to handle the local cache. Valid Values include `UpdateLocallyCachedFiles` and `DownloadNewAndModifiedFiles`. Defaults to `UpdateLocallyCachedFiles`.
        """
        return pulumi.get(self, "local_cache_mode")

    @local_cache_mode.setter
    def local_cache_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "local_cache_mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Storage Sync. Changing this forces a new Storage Sync Server Endpoint to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="registeredServerId")
    def registered_server_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Registered Server that will be associate with the Storage Sync Server Endpoint. Changing this forces a new Storage Sync Server Endpoint to be created.

        > **Note:** The target server must already be registered with the parent `storage.Sync` prior to creating this endpoint. For more information on registering a server see the [Microsoft documentation](https://learn.microsoft.com/azure/storage/file-sync/file-sync-server-registration)
        """
        return pulumi.get(self, "registered_server_id")

    @registered_server_id.setter
    def registered_server_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "registered_server_id", value)

    @property
    @pulumi.getter(name="serverLocalPath")
    def server_local_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path on the Windows Server to be synced to the Azure file share. Changing this forces a new Storage Sync Server Endpoint to be created.
        """
        return pulumi.get(self, "server_local_path")

    @server_local_path.setter
    def server_local_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server_local_path", value)

    @property
    @pulumi.getter(name="storageSyncGroupId")
    def storage_sync_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Storage Sync Group where the Storage Sync Server Endpoint should exist. Changing this forces a new Storage Sync Server Endpoint to be created.
        """
        return pulumi.get(self, "storage_sync_group_id")

    @storage_sync_group_id.setter
    def storage_sync_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_sync_group_id", value)

    @property
    @pulumi.getter(name="tierFilesOlderThanDays")
    def tier_files_older_than_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Files older than the specified age will be tiered to the cloud.
        """
        return pulumi.get(self, "tier_files_older_than_days")

    @tier_files_older_than_days.setter
    def tier_files_older_than_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tier_files_older_than_days", value)

    @property
    @pulumi.getter(name="volumeFreeSpacePercent")
    def volume_free_space_percent(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        What percentage of free space on the volume should be preserved? Defaults to `20`.
        """
        return pulumi.get(self, "volume_free_space_percent")

    @volume_free_space_percent.setter
    def volume_free_space_percent(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "volume_free_space_percent", value)


@pulumi.type_token("azure:storage/syncServerEndpoint:SyncServerEndpoint")
class SyncServerEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_tiering_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 initial_download_policy: Optional[pulumi.Input[builtins.str]] = None,
                 local_cache_mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 registered_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 server_local_path: Optional[pulumi.Input[builtins.str]] = None,
                 storage_sync_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 tier_files_older_than_days: Optional[pulumi.Input[builtins.int]] = None,
                 volume_free_space_percent: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        Manages a Storage Sync Server Endpoint.

        > **Note:** The parent `storage.SyncGroup` must have an `storage.SyncCloudEndpoint` available before an `storage.SyncServerEndpoint` resource can be created.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_sync = azure.storage.Sync("example",
            name="example-storage-sync",
            resource_group_name=example.name,
            location=example.location)
        example_sync_group = azure.storage.SyncGroup("example",
            name="example-storage-sync-group",
            storage_sync_id=example_sync.id)
        example_account = azure.storage.Account("example",
            name="example-storage-account",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_share = azure.storage.Share("example",
            name="example-storage-share",
            storage_account_name=example_account.name,
            quota=1,
            acls=[{
                "id": "GhostedRecall",
                "access_policies": [{
                    "permissions": "r",
                }],
            }])
        example_sync_cloud_endpoint = azure.storage.SyncCloudEndpoint("example",
            name="example-ss-ce",
            storage_sync_group_id=example_sync_group.id,
            file_share_name=example_share.name,
            storage_account_id=example_account.id)
        example_sync_server_endpoint = azure.storage.SyncServerEndpoint("example",
            name="example-storage-sync-server-endpoint",
            storage_sync_group_id=example_sync_group.id,
            registered_server_id=example_sync.registered_servers[0],
            opts = pulumi.ResourceOptions(depends_on=[example_sync_cloud_endpoint]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StorageSync`: 2020-03-01

        ## Import

        Storage Sync Server Endpoints can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/syncServerEndpoint:SyncServerEndpoint example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.StorageSync/storageSyncServices/sync1/syncGroups/syncGroup1/serverEndpoints/endpoint1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] cloud_tiering_enabled: Is Cloud Tiering Enabled? Defaults to `false`.
        :param pulumi.Input[builtins.str] initial_download_policy: Specifies how the server initially downloads the Azure file share data. Valid Values includes `NamespaceThenModifiedFiles`, `NamespaceOnly`, and `AvoidTieredFiles`. Defaults to `NamespaceThenModifiedFiles`.
        :param pulumi.Input[builtins.str] local_cache_mode: Specifies how to handle the local cache. Valid Values include `UpdateLocallyCachedFiles` and `DownloadNewAndModifiedFiles`. Defaults to `UpdateLocallyCachedFiles`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Storage Sync. Changing this forces a new Storage Sync Server Endpoint to be created.
        :param pulumi.Input[builtins.str] registered_server_id: The ID of the Registered Server that will be associate with the Storage Sync Server Endpoint. Changing this forces a new Storage Sync Server Endpoint to be created.
               
               > **Note:** The target server must already be registered with the parent `storage.Sync` prior to creating this endpoint. For more information on registering a server see the [Microsoft documentation](https://learn.microsoft.com/azure/storage/file-sync/file-sync-server-registration)
        :param pulumi.Input[builtins.str] server_local_path: The path on the Windows Server to be synced to the Azure file share. Changing this forces a new Storage Sync Server Endpoint to be created.
        :param pulumi.Input[builtins.str] storage_sync_group_id: The ID of the Storage Sync Group where the Storage Sync Server Endpoint should exist. Changing this forces a new Storage Sync Server Endpoint to be created.
        :param pulumi.Input[builtins.int] tier_files_older_than_days: Files older than the specified age will be tiered to the cloud.
        :param pulumi.Input[builtins.int] volume_free_space_percent: What percentage of free space on the volume should be preserved? Defaults to `20`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SyncServerEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Storage Sync Server Endpoint.

        > **Note:** The parent `storage.SyncGroup` must have an `storage.SyncCloudEndpoint` available before an `storage.SyncServerEndpoint` resource can be created.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_sync = azure.storage.Sync("example",
            name="example-storage-sync",
            resource_group_name=example.name,
            location=example.location)
        example_sync_group = azure.storage.SyncGroup("example",
            name="example-storage-sync-group",
            storage_sync_id=example_sync.id)
        example_account = azure.storage.Account("example",
            name="example-storage-account",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_share = azure.storage.Share("example",
            name="example-storage-share",
            storage_account_name=example_account.name,
            quota=1,
            acls=[{
                "id": "GhostedRecall",
                "access_policies": [{
                    "permissions": "r",
                }],
            }])
        example_sync_cloud_endpoint = azure.storage.SyncCloudEndpoint("example",
            name="example-ss-ce",
            storage_sync_group_id=example_sync_group.id,
            file_share_name=example_share.name,
            storage_account_id=example_account.id)
        example_sync_server_endpoint = azure.storage.SyncServerEndpoint("example",
            name="example-storage-sync-server-endpoint",
            storage_sync_group_id=example_sync_group.id,
            registered_server_id=example_sync.registered_servers[0],
            opts = pulumi.ResourceOptions(depends_on=[example_sync_cloud_endpoint]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StorageSync`: 2020-03-01

        ## Import

        Storage Sync Server Endpoints can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/syncServerEndpoint:SyncServerEndpoint example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.StorageSync/storageSyncServices/sync1/syncGroups/syncGroup1/serverEndpoints/endpoint1
        ```

        :param str resource_name: The name of the resource.
        :param SyncServerEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SyncServerEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_tiering_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 initial_download_policy: Optional[pulumi.Input[builtins.str]] = None,
                 local_cache_mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 registered_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 server_local_path: Optional[pulumi.Input[builtins.str]] = None,
                 storage_sync_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 tier_files_older_than_days: Optional[pulumi.Input[builtins.int]] = None,
                 volume_free_space_percent: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SyncServerEndpointArgs.__new__(SyncServerEndpointArgs)

            __props__.__dict__["cloud_tiering_enabled"] = cloud_tiering_enabled
            __props__.__dict__["initial_download_policy"] = initial_download_policy
            __props__.__dict__["local_cache_mode"] = local_cache_mode
            __props__.__dict__["name"] = name
            if registered_server_id is None and not opts.urn:
                raise TypeError("Missing required property 'registered_server_id'")
            __props__.__dict__["registered_server_id"] = registered_server_id
            if server_local_path is None and not opts.urn:
                raise TypeError("Missing required property 'server_local_path'")
            __props__.__dict__["server_local_path"] = server_local_path
            if storage_sync_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_sync_group_id'")
            __props__.__dict__["storage_sync_group_id"] = storage_sync_group_id
            __props__.__dict__["tier_files_older_than_days"] = tier_files_older_than_days
            __props__.__dict__["volume_free_space_percent"] = volume_free_space_percent
        super(SyncServerEndpoint, __self__).__init__(
            'azure:storage/syncServerEndpoint:SyncServerEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud_tiering_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            initial_download_policy: Optional[pulumi.Input[builtins.str]] = None,
            local_cache_mode: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            registered_server_id: Optional[pulumi.Input[builtins.str]] = None,
            server_local_path: Optional[pulumi.Input[builtins.str]] = None,
            storage_sync_group_id: Optional[pulumi.Input[builtins.str]] = None,
            tier_files_older_than_days: Optional[pulumi.Input[builtins.int]] = None,
            volume_free_space_percent: Optional[pulumi.Input[builtins.int]] = None) -> 'SyncServerEndpoint':
        """
        Get an existing SyncServerEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] cloud_tiering_enabled: Is Cloud Tiering Enabled? Defaults to `false`.
        :param pulumi.Input[builtins.str] initial_download_policy: Specifies how the server initially downloads the Azure file share data. Valid Values includes `NamespaceThenModifiedFiles`, `NamespaceOnly`, and `AvoidTieredFiles`. Defaults to `NamespaceThenModifiedFiles`.
        :param pulumi.Input[builtins.str] local_cache_mode: Specifies how to handle the local cache. Valid Values include `UpdateLocallyCachedFiles` and `DownloadNewAndModifiedFiles`. Defaults to `UpdateLocallyCachedFiles`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Storage Sync. Changing this forces a new Storage Sync Server Endpoint to be created.
        :param pulumi.Input[builtins.str] registered_server_id: The ID of the Registered Server that will be associate with the Storage Sync Server Endpoint. Changing this forces a new Storage Sync Server Endpoint to be created.
               
               > **Note:** The target server must already be registered with the parent `storage.Sync` prior to creating this endpoint. For more information on registering a server see the [Microsoft documentation](https://learn.microsoft.com/azure/storage/file-sync/file-sync-server-registration)
        :param pulumi.Input[builtins.str] server_local_path: The path on the Windows Server to be synced to the Azure file share. Changing this forces a new Storage Sync Server Endpoint to be created.
        :param pulumi.Input[builtins.str] storage_sync_group_id: The ID of the Storage Sync Group where the Storage Sync Server Endpoint should exist. Changing this forces a new Storage Sync Server Endpoint to be created.
        :param pulumi.Input[builtins.int] tier_files_older_than_days: Files older than the specified age will be tiered to the cloud.
        :param pulumi.Input[builtins.int] volume_free_space_percent: What percentage of free space on the volume should be preserved? Defaults to `20`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SyncServerEndpointState.__new__(_SyncServerEndpointState)

        __props__.__dict__["cloud_tiering_enabled"] = cloud_tiering_enabled
        __props__.__dict__["initial_download_policy"] = initial_download_policy
        __props__.__dict__["local_cache_mode"] = local_cache_mode
        __props__.__dict__["name"] = name
        __props__.__dict__["registered_server_id"] = registered_server_id
        __props__.__dict__["server_local_path"] = server_local_path
        __props__.__dict__["storage_sync_group_id"] = storage_sync_group_id
        __props__.__dict__["tier_files_older_than_days"] = tier_files_older_than_days
        __props__.__dict__["volume_free_space_percent"] = volume_free_space_percent
        return SyncServerEndpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cloudTieringEnabled")
    def cloud_tiering_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is Cloud Tiering Enabled? Defaults to `false`.
        """
        return pulumi.get(self, "cloud_tiering_enabled")

    @property
    @pulumi.getter(name="initialDownloadPolicy")
    def initial_download_policy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies how the server initially downloads the Azure file share data. Valid Values includes `NamespaceThenModifiedFiles`, `NamespaceOnly`, and `AvoidTieredFiles`. Defaults to `NamespaceThenModifiedFiles`.
        """
        return pulumi.get(self, "initial_download_policy")

    @property
    @pulumi.getter(name="localCacheMode")
    def local_cache_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies how to handle the local cache. Valid Values include `UpdateLocallyCachedFiles` and `DownloadNewAndModifiedFiles`. Defaults to `UpdateLocallyCachedFiles`.
        """
        return pulumi.get(self, "local_cache_mode")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Storage Sync. Changing this forces a new Storage Sync Server Endpoint to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="registeredServerId")
    def registered_server_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Registered Server that will be associate with the Storage Sync Server Endpoint. Changing this forces a new Storage Sync Server Endpoint to be created.

        > **Note:** The target server must already be registered with the parent `storage.Sync` prior to creating this endpoint. For more information on registering a server see the [Microsoft documentation](https://learn.microsoft.com/azure/storage/file-sync/file-sync-server-registration)
        """
        return pulumi.get(self, "registered_server_id")

    @property
    @pulumi.getter(name="serverLocalPath")
    def server_local_path(self) -> pulumi.Output[builtins.str]:
        """
        The path on the Windows Server to be synced to the Azure file share. Changing this forces a new Storage Sync Server Endpoint to be created.
        """
        return pulumi.get(self, "server_local_path")

    @property
    @pulumi.getter(name="storageSyncGroupId")
    def storage_sync_group_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Storage Sync Group where the Storage Sync Server Endpoint should exist. Changing this forces a new Storage Sync Server Endpoint to be created.
        """
        return pulumi.get(self, "storage_sync_group_id")

    @property
    @pulumi.getter(name="tierFilesOlderThanDays")
    def tier_files_older_than_days(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Files older than the specified age will be tiered to the cloud.
        """
        return pulumi.get(self, "tier_files_older_than_days")

    @property
    @pulumi.getter(name="volumeFreeSpacePercent")
    def volume_free_space_percent(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        What percentage of free space on the volume should be preserved? Defaults to `20`.
        """
        return pulumi.get(self, "volume_free_space_percent")

