# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['JobScheduleArgs', 'JobSchedule']

@pulumi.input_type
class JobScheduleArgs:
    def __init__(__self__, *,
                 start_mode: pulumi.Input[builtins.str],
                 stream_analytics_job_id: pulumi.Input[builtins.str],
                 start_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a JobSchedule resource.
        :param pulumi.Input[builtins.str] start_mode: The starting mode of the Stream Analytics Job. Possible values are `JobStartTime`, `CustomTime` and `LastOutputEventTime`.
               
               > **Note:** Setting `start_mode` to `LastOutputEventTime` is only possible if the job had been previously started and produced output.
        :param pulumi.Input[builtins.str] stream_analytics_job_id: The ID of the Stream Analytics Job that should be scheduled or started. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] start_time: The time in ISO8601 format at which the Stream Analytics Job should be started e.g. `2022-04-01T00:00:00Z`. This property can only be specified if `start_mode` is set to `CustomTime`
        """
        pulumi.set(__self__, "start_mode", start_mode)
        pulumi.set(__self__, "stream_analytics_job_id", stream_analytics_job_id)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="startMode")
    def start_mode(self) -> pulumi.Input[builtins.str]:
        """
        The starting mode of the Stream Analytics Job. Possible values are `JobStartTime`, `CustomTime` and `LastOutputEventTime`.

        > **Note:** Setting `start_mode` to `LastOutputEventTime` is only possible if the job had been previously started and produced output.
        """
        return pulumi.get(self, "start_mode")

    @start_mode.setter
    def start_mode(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "start_mode", value)

    @property
    @pulumi.getter(name="streamAnalyticsJobId")
    def stream_analytics_job_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Stream Analytics Job that should be scheduled or started. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "stream_analytics_job_id")

    @stream_analytics_job_id.setter
    def stream_analytics_job_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "stream_analytics_job_id", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time in ISO8601 format at which the Stream Analytics Job should be started e.g. `2022-04-01T00:00:00Z`. This property can only be specified if `start_mode` is set to `CustomTime`
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class _JobScheduleState:
    def __init__(__self__, *,
                 last_output_time: Optional[pulumi.Input[builtins.str]] = None,
                 start_mode: Optional[pulumi.Input[builtins.str]] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None,
                 stream_analytics_job_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering JobSchedule resources.
        :param pulumi.Input[builtins.str] last_output_time: The time at which the Stream Analytics job last produced an output.
        :param pulumi.Input[builtins.str] start_mode: The starting mode of the Stream Analytics Job. Possible values are `JobStartTime`, `CustomTime` and `LastOutputEventTime`.
               
               > **Note:** Setting `start_mode` to `LastOutputEventTime` is only possible if the job had been previously started and produced output.
        :param pulumi.Input[builtins.str] start_time: The time in ISO8601 format at which the Stream Analytics Job should be started e.g. `2022-04-01T00:00:00Z`. This property can only be specified if `start_mode` is set to `CustomTime`
        :param pulumi.Input[builtins.str] stream_analytics_job_id: The ID of the Stream Analytics Job that should be scheduled or started. Changing this forces a new resource to be created.
        """
        if last_output_time is not None:
            pulumi.set(__self__, "last_output_time", last_output_time)
        if start_mode is not None:
            pulumi.set(__self__, "start_mode", start_mode)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if stream_analytics_job_id is not None:
            pulumi.set(__self__, "stream_analytics_job_id", stream_analytics_job_id)

    @property
    @pulumi.getter(name="lastOutputTime")
    def last_output_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time at which the Stream Analytics job last produced an output.
        """
        return pulumi.get(self, "last_output_time")

    @last_output_time.setter
    def last_output_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_output_time", value)

    @property
    @pulumi.getter(name="startMode")
    def start_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The starting mode of the Stream Analytics Job. Possible values are `JobStartTime`, `CustomTime` and `LastOutputEventTime`.

        > **Note:** Setting `start_mode` to `LastOutputEventTime` is only possible if the job had been previously started and produced output.
        """
        return pulumi.get(self, "start_mode")

    @start_mode.setter
    def start_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "start_mode", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time in ISO8601 format at which the Stream Analytics Job should be started e.g. `2022-04-01T00:00:00Z`. This property can only be specified if `start_mode` is set to `CustomTime`
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="streamAnalyticsJobId")
    def stream_analytics_job_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Stream Analytics Job that should be scheduled or started. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "stream_analytics_job_id")

    @stream_analytics_job_id.setter
    def stream_analytics_job_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "stream_analytics_job_id", value)


@pulumi.type_token("azure:streamanalytics/jobSchedule:JobSchedule")
class JobSchedule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 start_mode: Optional[pulumi.Input[builtins.str]] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None,
                 stream_analytics_job_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Stream Analytics Job Schedule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="example",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_blob = azure.storage.Blob("example",
            name="example",
            storage_account_name=example_account.name,
            storage_container_name=example_container.name,
            type="Block",
            source=pulumi.FileAsset("example.csv"))
        example_job = azure.streamanalytics.Job("example",
            name="example-job",
            resource_group_name=example.name,
            location=example.location,
            compatibility_level="1.2",
            data_locale="en-GB",
            events_late_arrival_max_delay_in_seconds=60,
            events_out_of_order_max_delay_in_seconds=50,
            events_out_of_order_policy="Adjust",
            output_error_policy="Drop",
            streaming_units=3,
            tags={
                "environment": "Example",
            },
            transformation_query=\"\"\"    SELECT *
            INTO [exampleoutput]
            FROM [exampleinput]
        \"\"\")
        example_stream_input_blob = azure.streamanalytics.StreamInputBlob("example",
            name="exampleinput",
            stream_analytics_job_name=example_job.name,
            resource_group_name=example_job.resource_group_name,
            storage_account_name=example_account.name,
            storage_account_key=example_account.primary_access_key,
            storage_container_name=example_container.name,
            path_pattern="",
            date_format="yyyy/MM/dd",
            time_format="HH",
            serialization={
                "type": "Csv",
                "encoding": "UTF8",
                "field_delimiter": ",",
            })
        example_output_blob = azure.streamanalytics.OutputBlob("example",
            name="exampleoutput",
            stream_analytics_job_name=example_job.name,
            resource_group_name=example_job.resource_group_name,
            storage_account_name=example_account.name,
            storage_account_key=example_account.primary_access_key,
            storage_container_name=example_container.name,
            path_pattern="example-{date}-{time}",
            date_format="yyyy-MM-dd",
            time_format="HH",
            serialization={
                "type": "Avro",
            })
        example_job_schedule = azure.streamanalytics.JobSchedule("example",
            stream_analytics_job_id=example_job.id,
            start_mode="CustomTime",
            start_time="2022-09-21T00:00:00Z",
            opts = pulumi.ResourceOptions(depends_on=[
                    example_job,
                    example_stream_input_blob,
                    example_output_blob,
                ]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StreamAnalytics`: 2021-10-01-preview

        ## Import

        Stream Analytics Job's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:streamanalytics/jobSchedule:JobSchedule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.StreamAnalytics/streamingJobs/job1/schedule/default
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] start_mode: The starting mode of the Stream Analytics Job. Possible values are `JobStartTime`, `CustomTime` and `LastOutputEventTime`.
               
               > **Note:** Setting `start_mode` to `LastOutputEventTime` is only possible if the job had been previously started and produced output.
        :param pulumi.Input[builtins.str] start_time: The time in ISO8601 format at which the Stream Analytics Job should be started e.g. `2022-04-01T00:00:00Z`. This property can only be specified if `start_mode` is set to `CustomTime`
        :param pulumi.Input[builtins.str] stream_analytics_job_id: The ID of the Stream Analytics Job that should be scheduled or started. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobScheduleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Stream Analytics Job Schedule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="example",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_blob = azure.storage.Blob("example",
            name="example",
            storage_account_name=example_account.name,
            storage_container_name=example_container.name,
            type="Block",
            source=pulumi.FileAsset("example.csv"))
        example_job = azure.streamanalytics.Job("example",
            name="example-job",
            resource_group_name=example.name,
            location=example.location,
            compatibility_level="1.2",
            data_locale="en-GB",
            events_late_arrival_max_delay_in_seconds=60,
            events_out_of_order_max_delay_in_seconds=50,
            events_out_of_order_policy="Adjust",
            output_error_policy="Drop",
            streaming_units=3,
            tags={
                "environment": "Example",
            },
            transformation_query=\"\"\"    SELECT *
            INTO [exampleoutput]
            FROM [exampleinput]
        \"\"\")
        example_stream_input_blob = azure.streamanalytics.StreamInputBlob("example",
            name="exampleinput",
            stream_analytics_job_name=example_job.name,
            resource_group_name=example_job.resource_group_name,
            storage_account_name=example_account.name,
            storage_account_key=example_account.primary_access_key,
            storage_container_name=example_container.name,
            path_pattern="",
            date_format="yyyy/MM/dd",
            time_format="HH",
            serialization={
                "type": "Csv",
                "encoding": "UTF8",
                "field_delimiter": ",",
            })
        example_output_blob = azure.streamanalytics.OutputBlob("example",
            name="exampleoutput",
            stream_analytics_job_name=example_job.name,
            resource_group_name=example_job.resource_group_name,
            storage_account_name=example_account.name,
            storage_account_key=example_account.primary_access_key,
            storage_container_name=example_container.name,
            path_pattern="example-{date}-{time}",
            date_format="yyyy-MM-dd",
            time_format="HH",
            serialization={
                "type": "Avro",
            })
        example_job_schedule = azure.streamanalytics.JobSchedule("example",
            stream_analytics_job_id=example_job.id,
            start_mode="CustomTime",
            start_time="2022-09-21T00:00:00Z",
            opts = pulumi.ResourceOptions(depends_on=[
                    example_job,
                    example_stream_input_blob,
                    example_output_blob,
                ]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StreamAnalytics`: 2021-10-01-preview

        ## Import

        Stream Analytics Job's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:streamanalytics/jobSchedule:JobSchedule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.StreamAnalytics/streamingJobs/job1/schedule/default
        ```

        :param str resource_name: The name of the resource.
        :param JobScheduleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobScheduleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 start_mode: Optional[pulumi.Input[builtins.str]] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None,
                 stream_analytics_job_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobScheduleArgs.__new__(JobScheduleArgs)

            if start_mode is None and not opts.urn:
                raise TypeError("Missing required property 'start_mode'")
            __props__.__dict__["start_mode"] = start_mode
            __props__.__dict__["start_time"] = start_time
            if stream_analytics_job_id is None and not opts.urn:
                raise TypeError("Missing required property 'stream_analytics_job_id'")
            __props__.__dict__["stream_analytics_job_id"] = stream_analytics_job_id
            __props__.__dict__["last_output_time"] = None
        super(JobSchedule, __self__).__init__(
            'azure:streamanalytics/jobSchedule:JobSchedule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            last_output_time: Optional[pulumi.Input[builtins.str]] = None,
            start_mode: Optional[pulumi.Input[builtins.str]] = None,
            start_time: Optional[pulumi.Input[builtins.str]] = None,
            stream_analytics_job_id: Optional[pulumi.Input[builtins.str]] = None) -> 'JobSchedule':
        """
        Get an existing JobSchedule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] last_output_time: The time at which the Stream Analytics job last produced an output.
        :param pulumi.Input[builtins.str] start_mode: The starting mode of the Stream Analytics Job. Possible values are `JobStartTime`, `CustomTime` and `LastOutputEventTime`.
               
               > **Note:** Setting `start_mode` to `LastOutputEventTime` is only possible if the job had been previously started and produced output.
        :param pulumi.Input[builtins.str] start_time: The time in ISO8601 format at which the Stream Analytics Job should be started e.g. `2022-04-01T00:00:00Z`. This property can only be specified if `start_mode` is set to `CustomTime`
        :param pulumi.Input[builtins.str] stream_analytics_job_id: The ID of the Stream Analytics Job that should be scheduled or started. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobScheduleState.__new__(_JobScheduleState)

        __props__.__dict__["last_output_time"] = last_output_time
        __props__.__dict__["start_mode"] = start_mode
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["stream_analytics_job_id"] = stream_analytics_job_id
        return JobSchedule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="lastOutputTime")
    def last_output_time(self) -> pulumi.Output[builtins.str]:
        """
        The time at which the Stream Analytics job last produced an output.
        """
        return pulumi.get(self, "last_output_time")

    @property
    @pulumi.getter(name="startMode")
    def start_mode(self) -> pulumi.Output[builtins.str]:
        """
        The starting mode of the Stream Analytics Job. Possible values are `JobStartTime`, `CustomTime` and `LastOutputEventTime`.

        > **Note:** Setting `start_mode` to `LastOutputEventTime` is only possible if the job had been previously started and produced output.
        """
        return pulumi.get(self, "start_mode")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[builtins.str]:
        """
        The time in ISO8601 format at which the Stream Analytics Job should be started e.g. `2022-04-01T00:00:00Z`. This property can only be specified if `start_mode` is set to `CustomTime`
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="streamAnalyticsJobId")
    def stream_analytics_job_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Stream Analytics Job that should be scheduled or started. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "stream_analytics_job_id")

