# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['OutputMssqlArgs', 'OutputMssql']

@pulumi.input_type
class OutputMssqlArgs:
    def __init__(__self__, *,
                 database: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 server: pulumi.Input[builtins.str],
                 stream_analytics_job_name: pulumi.Input[builtins.str],
                 table: pulumi.Input[builtins.str],
                 authentication_mode: Optional[pulumi.Input[builtins.str]] = None,
                 max_batch_count: Optional[pulumi.Input[builtins.float]] = None,
                 max_writer_count: Optional[pulumi.Input[builtins.float]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a OutputMssql resource.
        :param pulumi.Input[builtins.str] database: The MS SQL database name where the reference table exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Stream Analytics Job exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] server: The SQL server url. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] stream_analytics_job_name: The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] table: Table in the database that the output points to. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] authentication_mode: The authentication mode for the Stream Output. Possible values are `Msi` and `ConnectionString`. Defaults to `ConnectionString`.
        :param pulumi.Input[builtins.float] max_batch_count: The max batch count to write to the SQL Database. Defaults to `10000`. Possible values are between `1` and `1073741824`.
        :param pulumi.Input[builtins.float] max_writer_count: The max writer count for the SQL Database. Defaults to `1`. Possible values are `0` which bases the writer count on the query partition and `1` which corresponds to a single writer.
        :param pulumi.Input[builtins.str] name: The name of the Stream Output. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] password: Password used together with username, to login to the Microsoft SQL Server. Required if `authentication_mode` is `ConnectionString`.
        :param pulumi.Input[builtins.str] user: Username used to login to the Microsoft SQL Server. Changing this forces a new resource to be created. Required if `authentication_mode` is `ConnectionString`.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "server", server)
        pulumi.set(__self__, "stream_analytics_job_name", stream_analytics_job_name)
        pulumi.set(__self__, "table", table)
        if authentication_mode is not None:
            pulumi.set(__self__, "authentication_mode", authentication_mode)
        if max_batch_count is not None:
            pulumi.set(__self__, "max_batch_count", max_batch_count)
        if max_writer_count is not None:
            pulumi.set(__self__, "max_writer_count", max_writer_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Input[builtins.str]:
        """
        The MS SQL database name where the reference table exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Resource Group where the Stream Analytics Job exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def server(self) -> pulumi.Input[builtins.str]:
        """
        The SQL server url. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter(name="streamAnalyticsJobName")
    def stream_analytics_job_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "stream_analytics_job_name")

    @stream_analytics_job_name.setter
    def stream_analytics_job_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "stream_analytics_job_name", value)

    @property
    @pulumi.getter
    def table(self) -> pulumi.Input[builtins.str]:
        """
        Table in the database that the output points to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "table", value)

    @property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The authentication mode for the Stream Output. Possible values are `Msi` and `ConnectionString`. Defaults to `ConnectionString`.
        """
        return pulumi.get(self, "authentication_mode")

    @authentication_mode.setter
    def authentication_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_mode", value)

    @property
    @pulumi.getter(name="maxBatchCount")
    def max_batch_count(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The max batch count to write to the SQL Database. Defaults to `10000`. Possible values are between `1` and `1073741824`.
        """
        return pulumi.get(self, "max_batch_count")

    @max_batch_count.setter
    def max_batch_count(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "max_batch_count", value)

    @property
    @pulumi.getter(name="maxWriterCount")
    def max_writer_count(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The max writer count for the SQL Database. Defaults to `1`. Possible values are `0` which bases the writer count on the query partition and `1` which corresponds to a single writer.
        """
        return pulumi.get(self, "max_writer_count")

    @max_writer_count.setter
    def max_writer_count(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "max_writer_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Stream Output. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Password used together with username, to login to the Microsoft SQL Server. Required if `authentication_mode` is `ConnectionString`.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Username used to login to the Microsoft SQL Server. Changing this forces a new resource to be created. Required if `authentication_mode` is `ConnectionString`.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class _OutputMssqlState:
    def __init__(__self__, *,
                 authentication_mode: Optional[pulumi.Input[builtins.str]] = None,
                 database: Optional[pulumi.Input[builtins.str]] = None,
                 max_batch_count: Optional[pulumi.Input[builtins.float]] = None,
                 max_writer_count: Optional[pulumi.Input[builtins.float]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 server: Optional[pulumi.Input[builtins.str]] = None,
                 stream_analytics_job_name: Optional[pulumi.Input[builtins.str]] = None,
                 table: Optional[pulumi.Input[builtins.str]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering OutputMssql resources.
        :param pulumi.Input[builtins.str] authentication_mode: The authentication mode for the Stream Output. Possible values are `Msi` and `ConnectionString`. Defaults to `ConnectionString`.
        :param pulumi.Input[builtins.str] database: The MS SQL database name where the reference table exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.float] max_batch_count: The max batch count to write to the SQL Database. Defaults to `10000`. Possible values are between `1` and `1073741824`.
        :param pulumi.Input[builtins.float] max_writer_count: The max writer count for the SQL Database. Defaults to `1`. Possible values are `0` which bases the writer count on the query partition and `1` which corresponds to a single writer.
        :param pulumi.Input[builtins.str] name: The name of the Stream Output. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] password: Password used together with username, to login to the Microsoft SQL Server. Required if `authentication_mode` is `ConnectionString`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Stream Analytics Job exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] server: The SQL server url. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] stream_analytics_job_name: The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] table: Table in the database that the output points to. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] user: Username used to login to the Microsoft SQL Server. Changing this forces a new resource to be created. Required if `authentication_mode` is `ConnectionString`.
        """
        if authentication_mode is not None:
            pulumi.set(__self__, "authentication_mode", authentication_mode)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if max_batch_count is not None:
            pulumi.set(__self__, "max_batch_count", max_batch_count)
        if max_writer_count is not None:
            pulumi.set(__self__, "max_writer_count", max_writer_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if stream_analytics_job_name is not None:
            pulumi.set(__self__, "stream_analytics_job_name", stream_analytics_job_name)
        if table is not None:
            pulumi.set(__self__, "table", table)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The authentication mode for the Stream Output. Possible values are `Msi` and `ConnectionString`. Defaults to `ConnectionString`.
        """
        return pulumi.get(self, "authentication_mode")

    @authentication_mode.setter
    def authentication_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_mode", value)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The MS SQL database name where the reference table exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="maxBatchCount")
    def max_batch_count(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The max batch count to write to the SQL Database. Defaults to `10000`. Possible values are between `1` and `1073741824`.
        """
        return pulumi.get(self, "max_batch_count")

    @max_batch_count.setter
    def max_batch_count(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "max_batch_count", value)

    @property
    @pulumi.getter(name="maxWriterCount")
    def max_writer_count(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The max writer count for the SQL Database. Defaults to `1`. Possible values are `0` which bases the writer count on the query partition and `1` which corresponds to a single writer.
        """
        return pulumi.get(self, "max_writer_count")

    @max_writer_count.setter
    def max_writer_count(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "max_writer_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Stream Output. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Password used together with username, to login to the Microsoft SQL Server. Required if `authentication_mode` is `ConnectionString`.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Resource Group where the Stream Analytics Job exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def server(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SQL server url. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter(name="streamAnalyticsJobName")
    def stream_analytics_job_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "stream_analytics_job_name")

    @stream_analytics_job_name.setter
    def stream_analytics_job_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "stream_analytics_job_name", value)

    @property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Table in the database that the output points to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "table", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Username used to login to the Microsoft SQL Server. Changing this forces a new resource to be created. Required if `authentication_mode` is `ConnectionString`.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user", value)


@pulumi.type_token("azure:streamanalytics/outputMssql:OutputMssql")
class OutputMssql(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_mode: Optional[pulumi.Input[builtins.str]] = None,
                 database: Optional[pulumi.Input[builtins.str]] = None,
                 max_batch_count: Optional[pulumi.Input[builtins.float]] = None,
                 max_writer_count: Optional[pulumi.Input[builtins.float]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 server: Optional[pulumi.Input[builtins.str]] = None,
                 stream_analytics_job_name: Optional[pulumi.Input[builtins.str]] = None,
                 table: Optional[pulumi.Input[builtins.str]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Stream Analytics Output to Microsoft SQL Server Database.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="rg-example",
            location="West Europe")
        example = azure.streamanalytics.get_job_output(name="example-job",
            resource_group_name=example_resource_group.name)
        example_server = azure.mssql.Server("example",
            name="example-server",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            version="12.0",
            administrator_login="dbadmin",
            administrator_login_password="example-password")
        example_database = azure.mssql.Database("example",
            name="exampledb",
            server_id=test["id"])
        example_output_mssql = azure.streamanalytics.OutputMssql("example",
            name="example-output-sql",
            stream_analytics_job_name=example.name,
            resource_group_name=example.resource_group_name,
            server=example_server.fully_qualified_domain_name,
            user=example_server.administrator_login,
            password=example_server.administrator_login_password,
            database=example_database.name,
            table="ExampleTable")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StreamAnalytics`: 2021-10-01-preview

        ## Import

        Stream Analytics Outputs to Microsoft SQL Server Database can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:streamanalytics/outputMssql:OutputMssql example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.StreamAnalytics/streamingJobs/job1/outputs/output1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] authentication_mode: The authentication mode for the Stream Output. Possible values are `Msi` and `ConnectionString`. Defaults to `ConnectionString`.
        :param pulumi.Input[builtins.str] database: The MS SQL database name where the reference table exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.float] max_batch_count: The max batch count to write to the SQL Database. Defaults to `10000`. Possible values are between `1` and `1073741824`.
        :param pulumi.Input[builtins.float] max_writer_count: The max writer count for the SQL Database. Defaults to `1`. Possible values are `0` which bases the writer count on the query partition and `1` which corresponds to a single writer.
        :param pulumi.Input[builtins.str] name: The name of the Stream Output. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] password: Password used together with username, to login to the Microsoft SQL Server. Required if `authentication_mode` is `ConnectionString`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Stream Analytics Job exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] server: The SQL server url. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] stream_analytics_job_name: The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] table: Table in the database that the output points to. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] user: Username used to login to the Microsoft SQL Server. Changing this forces a new resource to be created. Required if `authentication_mode` is `ConnectionString`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OutputMssqlArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Stream Analytics Output to Microsoft SQL Server Database.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="rg-example",
            location="West Europe")
        example = azure.streamanalytics.get_job_output(name="example-job",
            resource_group_name=example_resource_group.name)
        example_server = azure.mssql.Server("example",
            name="example-server",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            version="12.0",
            administrator_login="dbadmin",
            administrator_login_password="example-password")
        example_database = azure.mssql.Database("example",
            name="exampledb",
            server_id=test["id"])
        example_output_mssql = azure.streamanalytics.OutputMssql("example",
            name="example-output-sql",
            stream_analytics_job_name=example.name,
            resource_group_name=example.resource_group_name,
            server=example_server.fully_qualified_domain_name,
            user=example_server.administrator_login,
            password=example_server.administrator_login_password,
            database=example_database.name,
            table="ExampleTable")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StreamAnalytics`: 2021-10-01-preview

        ## Import

        Stream Analytics Outputs to Microsoft SQL Server Database can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:streamanalytics/outputMssql:OutputMssql example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.StreamAnalytics/streamingJobs/job1/outputs/output1
        ```

        :param str resource_name: The name of the resource.
        :param OutputMssqlArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OutputMssqlArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_mode: Optional[pulumi.Input[builtins.str]] = None,
                 database: Optional[pulumi.Input[builtins.str]] = None,
                 max_batch_count: Optional[pulumi.Input[builtins.float]] = None,
                 max_writer_count: Optional[pulumi.Input[builtins.float]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 server: Optional[pulumi.Input[builtins.str]] = None,
                 stream_analytics_job_name: Optional[pulumi.Input[builtins.str]] = None,
                 table: Optional[pulumi.Input[builtins.str]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OutputMssqlArgs.__new__(OutputMssqlArgs)

            __props__.__dict__["authentication_mode"] = authentication_mode
            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            __props__.__dict__["max_batch_count"] = max_batch_count
            __props__.__dict__["max_writer_count"] = max_writer_count
            __props__.__dict__["name"] = name
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if server is None and not opts.urn:
                raise TypeError("Missing required property 'server'")
            __props__.__dict__["server"] = server
            if stream_analytics_job_name is None and not opts.urn:
                raise TypeError("Missing required property 'stream_analytics_job_name'")
            __props__.__dict__["stream_analytics_job_name"] = stream_analytics_job_name
            if table is None and not opts.urn:
                raise TypeError("Missing required property 'table'")
            __props__.__dict__["table"] = table
            __props__.__dict__["user"] = user
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(OutputMssql, __self__).__init__(
            'azure:streamanalytics/outputMssql:OutputMssql',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_mode: Optional[pulumi.Input[builtins.str]] = None,
            database: Optional[pulumi.Input[builtins.str]] = None,
            max_batch_count: Optional[pulumi.Input[builtins.float]] = None,
            max_writer_count: Optional[pulumi.Input[builtins.float]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            password: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            server: Optional[pulumi.Input[builtins.str]] = None,
            stream_analytics_job_name: Optional[pulumi.Input[builtins.str]] = None,
            table: Optional[pulumi.Input[builtins.str]] = None,
            user: Optional[pulumi.Input[builtins.str]] = None) -> 'OutputMssql':
        """
        Get an existing OutputMssql resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] authentication_mode: The authentication mode for the Stream Output. Possible values are `Msi` and `ConnectionString`. Defaults to `ConnectionString`.
        :param pulumi.Input[builtins.str] database: The MS SQL database name where the reference table exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.float] max_batch_count: The max batch count to write to the SQL Database. Defaults to `10000`. Possible values are between `1` and `1073741824`.
        :param pulumi.Input[builtins.float] max_writer_count: The max writer count for the SQL Database. Defaults to `1`. Possible values are `0` which bases the writer count on the query partition and `1` which corresponds to a single writer.
        :param pulumi.Input[builtins.str] name: The name of the Stream Output. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] password: Password used together with username, to login to the Microsoft SQL Server. Required if `authentication_mode` is `ConnectionString`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Stream Analytics Job exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] server: The SQL server url. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] stream_analytics_job_name: The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] table: Table in the database that the output points to. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] user: Username used to login to the Microsoft SQL Server. Changing this forces a new resource to be created. Required if `authentication_mode` is `ConnectionString`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OutputMssqlState.__new__(_OutputMssqlState)

        __props__.__dict__["authentication_mode"] = authentication_mode
        __props__.__dict__["database"] = database
        __props__.__dict__["max_batch_count"] = max_batch_count
        __props__.__dict__["max_writer_count"] = max_writer_count
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["server"] = server
        __props__.__dict__["stream_analytics_job_name"] = stream_analytics_job_name
        __props__.__dict__["table"] = table
        __props__.__dict__["user"] = user
        return OutputMssql(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The authentication mode for the Stream Output. Possible values are `Msi` and `ConnectionString`. Defaults to `ConnectionString`.
        """
        return pulumi.get(self, "authentication_mode")

    @property
    @pulumi.getter
    def database(self) -> pulumi.Output[builtins.str]:
        """
        The MS SQL database name where the reference table exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="maxBatchCount")
    def max_batch_count(self) -> pulumi.Output[Optional[builtins.float]]:
        """
        The max batch count to write to the SQL Database. Defaults to `10000`. Possible values are between `1` and `1073741824`.
        """
        return pulumi.get(self, "max_batch_count")

    @property
    @pulumi.getter(name="maxWriterCount")
    def max_writer_count(self) -> pulumi.Output[Optional[builtins.float]]:
        """
        The max writer count for the SQL Database. Defaults to `1`. Possible values are `0` which bases the writer count on the query partition and `1` which corresponds to a single writer.
        """
        return pulumi.get(self, "max_writer_count")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Stream Output. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Password used together with username, to login to the Microsoft SQL Server. Required if `authentication_mode` is `ConnectionString`.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Resource Group where the Stream Analytics Job exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def server(self) -> pulumi.Output[builtins.str]:
        """
        The SQL server url. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "server")

    @property
    @pulumi.getter(name="streamAnalyticsJobName")
    def stream_analytics_job_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "stream_analytics_job_name")

    @property
    @pulumi.getter
    def table(self) -> pulumi.Output[builtins.str]:
        """
        Table in the database that the output points to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter
    def user(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Username used to login to the Microsoft SQL Server. Changing this forces a new resource to be created. Required if `authentication_mode` is `ConnectionString`.
        """
        return pulumi.get(self, "user")

