# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ReferenceInputMssqlArgs', 'ReferenceInputMssql']

@pulumi.input_type
class ReferenceInputMssqlArgs:
    def __init__(__self__, *,
                 database: pulumi.Input[builtins.str],
                 full_snapshot_query: pulumi.Input[builtins.str],
                 password: pulumi.Input[builtins.str],
                 refresh_type: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 server: pulumi.Input[builtins.str],
                 stream_analytics_job_name: pulumi.Input[builtins.str],
                 username: pulumi.Input[builtins.str],
                 delta_snapshot_query: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_interval_duration: Optional[pulumi.Input[builtins.str]] = None,
                 table: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ReferenceInputMssql resource.
        :param pulumi.Input[builtins.str] database: The MS SQL database name where the reference data exists.
        :param pulumi.Input[builtins.str] full_snapshot_query: The query used to retrieve the reference data from the MS SQL database.
        :param pulumi.Input[builtins.str] password: The password to connect to the MS SQL database.
        :param pulumi.Input[builtins.str] refresh_type: Defines whether and how the reference data should be refreshed. Accepted values are `Static`, `RefreshPeriodicallyWithFull` and `RefreshPeriodicallyWithDelta`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Stream Analytics Job should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] server: The fully qualified domain name of the MS SQL server.
        :param pulumi.Input[builtins.str] stream_analytics_job_name: The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] username: The username to connect to the MS SQL database.
        :param pulumi.Input[builtins.str] delta_snapshot_query: The query used to retrieve incremental changes in the reference data from the MS SQL database. Cannot be set when `refresh_type` is `Static`.
        :param pulumi.Input[builtins.str] name: The name of the Reference Input MS SQL data. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] refresh_interval_duration: The frequency in `hh:mm:ss` with which the reference data should be retrieved from the MS SQL database e.g. `00:20:00` for every 20 minutes. Must be set when `refresh_type` is `RefreshPeriodicallyWithFull` or `RefreshPeriodicallyWithDelta`.
        :param pulumi.Input[builtins.str] table: The name of the table in the Azure SQL database.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "full_snapshot_query", full_snapshot_query)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "refresh_type", refresh_type)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "server", server)
        pulumi.set(__self__, "stream_analytics_job_name", stream_analytics_job_name)
        pulumi.set(__self__, "username", username)
        if delta_snapshot_query is not None:
            pulumi.set(__self__, "delta_snapshot_query", delta_snapshot_query)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if refresh_interval_duration is not None:
            pulumi.set(__self__, "refresh_interval_duration", refresh_interval_duration)
        if table is not None:
            pulumi.set(__self__, "table", table)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Input[builtins.str]:
        """
        The MS SQL database name where the reference data exists.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="fullSnapshotQuery")
    def full_snapshot_query(self) -> pulumi.Input[builtins.str]:
        """
        The query used to retrieve the reference data from the MS SQL database.
        """
        return pulumi.get(self, "full_snapshot_query")

    @full_snapshot_query.setter
    def full_snapshot_query(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "full_snapshot_query", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[builtins.str]:
        """
        The password to connect to the MS SQL database.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="refreshType")
    def refresh_type(self) -> pulumi.Input[builtins.str]:
        """
        Defines whether and how the reference data should be refreshed. Accepted values are `Static`, `RefreshPeriodicallyWithFull` and `RefreshPeriodicallyWithDelta`.
        """
        return pulumi.get(self, "refresh_type")

    @refresh_type.setter
    def refresh_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "refresh_type", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Resource Group where the Stream Analytics Job should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def server(self) -> pulumi.Input[builtins.str]:
        """
        The fully qualified domain name of the MS SQL server.
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter(name="streamAnalyticsJobName")
    def stream_analytics_job_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "stream_analytics_job_name")

    @stream_analytics_job_name.setter
    def stream_analytics_job_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "stream_analytics_job_name", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[builtins.str]:
        """
        The username to connect to the MS SQL database.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="deltaSnapshotQuery")
    def delta_snapshot_query(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The query used to retrieve incremental changes in the reference data from the MS SQL database. Cannot be set when `refresh_type` is `Static`.
        """
        return pulumi.get(self, "delta_snapshot_query")

    @delta_snapshot_query.setter
    def delta_snapshot_query(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delta_snapshot_query", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Reference Input MS SQL data. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="refreshIntervalDuration")
    def refresh_interval_duration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The frequency in `hh:mm:ss` with which the reference data should be retrieved from the MS SQL database e.g. `00:20:00` for every 20 minutes. Must be set when `refresh_type` is `RefreshPeriodicallyWithFull` or `RefreshPeriodicallyWithDelta`.
        """
        return pulumi.get(self, "refresh_interval_duration")

    @refresh_interval_duration.setter
    def refresh_interval_duration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "refresh_interval_duration", value)

    @property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the table in the Azure SQL database.
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "table", value)


@pulumi.input_type
class _ReferenceInputMssqlState:
    def __init__(__self__, *,
                 database: Optional[pulumi.Input[builtins.str]] = None,
                 delta_snapshot_query: Optional[pulumi.Input[builtins.str]] = None,
                 full_snapshot_query: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_interval_duration: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_type: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 server: Optional[pulumi.Input[builtins.str]] = None,
                 stream_analytics_job_name: Optional[pulumi.Input[builtins.str]] = None,
                 table: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ReferenceInputMssql resources.
        :param pulumi.Input[builtins.str] database: The MS SQL database name where the reference data exists.
        :param pulumi.Input[builtins.str] delta_snapshot_query: The query used to retrieve incremental changes in the reference data from the MS SQL database. Cannot be set when `refresh_type` is `Static`.
        :param pulumi.Input[builtins.str] full_snapshot_query: The query used to retrieve the reference data from the MS SQL database.
        :param pulumi.Input[builtins.str] name: The name of the Reference Input MS SQL data. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] password: The password to connect to the MS SQL database.
        :param pulumi.Input[builtins.str] refresh_interval_duration: The frequency in `hh:mm:ss` with which the reference data should be retrieved from the MS SQL database e.g. `00:20:00` for every 20 minutes. Must be set when `refresh_type` is `RefreshPeriodicallyWithFull` or `RefreshPeriodicallyWithDelta`.
        :param pulumi.Input[builtins.str] refresh_type: Defines whether and how the reference data should be refreshed. Accepted values are `Static`, `RefreshPeriodicallyWithFull` and `RefreshPeriodicallyWithDelta`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Stream Analytics Job should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] server: The fully qualified domain name of the MS SQL server.
        :param pulumi.Input[builtins.str] stream_analytics_job_name: The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] table: The name of the table in the Azure SQL database.
        :param pulumi.Input[builtins.str] username: The username to connect to the MS SQL database.
        """
        if database is not None:
            pulumi.set(__self__, "database", database)
        if delta_snapshot_query is not None:
            pulumi.set(__self__, "delta_snapshot_query", delta_snapshot_query)
        if full_snapshot_query is not None:
            pulumi.set(__self__, "full_snapshot_query", full_snapshot_query)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if refresh_interval_duration is not None:
            pulumi.set(__self__, "refresh_interval_duration", refresh_interval_duration)
        if refresh_type is not None:
            pulumi.set(__self__, "refresh_type", refresh_type)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if stream_analytics_job_name is not None:
            pulumi.set(__self__, "stream_analytics_job_name", stream_analytics_job_name)
        if table is not None:
            pulumi.set(__self__, "table", table)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The MS SQL database name where the reference data exists.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="deltaSnapshotQuery")
    def delta_snapshot_query(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The query used to retrieve incremental changes in the reference data from the MS SQL database. Cannot be set when `refresh_type` is `Static`.
        """
        return pulumi.get(self, "delta_snapshot_query")

    @delta_snapshot_query.setter
    def delta_snapshot_query(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delta_snapshot_query", value)

    @property
    @pulumi.getter(name="fullSnapshotQuery")
    def full_snapshot_query(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The query used to retrieve the reference data from the MS SQL database.
        """
        return pulumi.get(self, "full_snapshot_query")

    @full_snapshot_query.setter
    def full_snapshot_query(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "full_snapshot_query", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Reference Input MS SQL data. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password to connect to the MS SQL database.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="refreshIntervalDuration")
    def refresh_interval_duration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The frequency in `hh:mm:ss` with which the reference data should be retrieved from the MS SQL database e.g. `00:20:00` for every 20 minutes. Must be set when `refresh_type` is `RefreshPeriodicallyWithFull` or `RefreshPeriodicallyWithDelta`.
        """
        return pulumi.get(self, "refresh_interval_duration")

    @refresh_interval_duration.setter
    def refresh_interval_duration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "refresh_interval_duration", value)

    @property
    @pulumi.getter(name="refreshType")
    def refresh_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Defines whether and how the reference data should be refreshed. Accepted values are `Static`, `RefreshPeriodicallyWithFull` and `RefreshPeriodicallyWithDelta`.
        """
        return pulumi.get(self, "refresh_type")

    @refresh_type.setter
    def refresh_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "refresh_type", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Resource Group where the Stream Analytics Job should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def server(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The fully qualified domain name of the MS SQL server.
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter(name="streamAnalyticsJobName")
    def stream_analytics_job_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "stream_analytics_job_name")

    @stream_analytics_job_name.setter
    def stream_analytics_job_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "stream_analytics_job_name", value)

    @property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the table in the Azure SQL database.
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "table", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The username to connect to the MS SQL database.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("azure:streamanalytics/referenceInputMssql:ReferenceInputMssql")
class ReferenceInputMssql(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database: Optional[pulumi.Input[builtins.str]] = None,
                 delta_snapshot_query: Optional[pulumi.Input[builtins.str]] = None,
                 full_snapshot_query: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_interval_duration: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_type: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 server: Optional[pulumi.Input[builtins.str]] = None,
                 stream_analytics_job_name: Optional[pulumi.Input[builtins.str]] = None,
                 table: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Stream Analytics Reference Input from MS SQL. Reference data (also known as a lookup table) is a finite data set that is static or slowly changing in nature, used to perform a lookup or to correlate with your data stream. Learn more [here](https://docs.microsoft.com/azure/stream-analytics/stream-analytics-use-reference-data#azure-sql-database).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example = azure.streamanalytics.get_job_output(name="example-job",
            resource_group_name=example_resource_group.name)
        example_server = azure.mssql.Server("example",
            name="example-sqlserver",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            version="12.0",
            administrator_login="admin",
            administrator_login_password="password")
        example_database = azure.mssql.Database("example",
            name="example-db",
            server_id=example_server.id)
        example_reference_input_mssql = azure.streamanalytics.ReferenceInputMssql("example",
            name="example-reference-input",
            resource_group_name=example.resource_group_name,
            stream_analytics_job_name=example.name,
            server=example_server.fully_qualified_domain_name,
            database=example_database.name,
            username="exampleuser",
            password="examplepassword",
            refresh_type="RefreshPeriodicallyWithFull",
            refresh_interval_duration="00:20:00",
            full_snapshot_query=\"\"\"    SELECT *
            INTO [YourOutputAlias]
            FROM [YourInputAlias]
        \"\"\")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StreamAnalytics`: 2020-03-01

        ## Import

        Stream Analytics can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:streamanalytics/referenceInputMssql:ReferenceInputMssql example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.StreamAnalytics/streamingJobs/job1/inputs/input1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] database: The MS SQL database name where the reference data exists.
        :param pulumi.Input[builtins.str] delta_snapshot_query: The query used to retrieve incremental changes in the reference data from the MS SQL database. Cannot be set when `refresh_type` is `Static`.
        :param pulumi.Input[builtins.str] full_snapshot_query: The query used to retrieve the reference data from the MS SQL database.
        :param pulumi.Input[builtins.str] name: The name of the Reference Input MS SQL data. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] password: The password to connect to the MS SQL database.
        :param pulumi.Input[builtins.str] refresh_interval_duration: The frequency in `hh:mm:ss` with which the reference data should be retrieved from the MS SQL database e.g. `00:20:00` for every 20 minutes. Must be set when `refresh_type` is `RefreshPeriodicallyWithFull` or `RefreshPeriodicallyWithDelta`.
        :param pulumi.Input[builtins.str] refresh_type: Defines whether and how the reference data should be refreshed. Accepted values are `Static`, `RefreshPeriodicallyWithFull` and `RefreshPeriodicallyWithDelta`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Stream Analytics Job should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] server: The fully qualified domain name of the MS SQL server.
        :param pulumi.Input[builtins.str] stream_analytics_job_name: The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] table: The name of the table in the Azure SQL database.
        :param pulumi.Input[builtins.str] username: The username to connect to the MS SQL database.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReferenceInputMssqlArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Stream Analytics Reference Input from MS SQL. Reference data (also known as a lookup table) is a finite data set that is static or slowly changing in nature, used to perform a lookup or to correlate with your data stream. Learn more [here](https://docs.microsoft.com/azure/stream-analytics/stream-analytics-use-reference-data#azure-sql-database).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example = azure.streamanalytics.get_job_output(name="example-job",
            resource_group_name=example_resource_group.name)
        example_server = azure.mssql.Server("example",
            name="example-sqlserver",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            version="12.0",
            administrator_login="admin",
            administrator_login_password="password")
        example_database = azure.mssql.Database("example",
            name="example-db",
            server_id=example_server.id)
        example_reference_input_mssql = azure.streamanalytics.ReferenceInputMssql("example",
            name="example-reference-input",
            resource_group_name=example.resource_group_name,
            stream_analytics_job_name=example.name,
            server=example_server.fully_qualified_domain_name,
            database=example_database.name,
            username="exampleuser",
            password="examplepassword",
            refresh_type="RefreshPeriodicallyWithFull",
            refresh_interval_duration="00:20:00",
            full_snapshot_query=\"\"\"    SELECT *
            INTO [YourOutputAlias]
            FROM [YourInputAlias]
        \"\"\")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StreamAnalytics`: 2020-03-01

        ## Import

        Stream Analytics can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:streamanalytics/referenceInputMssql:ReferenceInputMssql example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.StreamAnalytics/streamingJobs/job1/inputs/input1
        ```

        :param str resource_name: The name of the resource.
        :param ReferenceInputMssqlArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReferenceInputMssqlArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database: Optional[pulumi.Input[builtins.str]] = None,
                 delta_snapshot_query: Optional[pulumi.Input[builtins.str]] = None,
                 full_snapshot_query: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_interval_duration: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_type: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 server: Optional[pulumi.Input[builtins.str]] = None,
                 stream_analytics_job_name: Optional[pulumi.Input[builtins.str]] = None,
                 table: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReferenceInputMssqlArgs.__new__(ReferenceInputMssqlArgs)

            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            __props__.__dict__["delta_snapshot_query"] = delta_snapshot_query
            if full_snapshot_query is None and not opts.urn:
                raise TypeError("Missing required property 'full_snapshot_query'")
            __props__.__dict__["full_snapshot_query"] = full_snapshot_query
            __props__.__dict__["name"] = name
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["refresh_interval_duration"] = refresh_interval_duration
            if refresh_type is None and not opts.urn:
                raise TypeError("Missing required property 'refresh_type'")
            __props__.__dict__["refresh_type"] = refresh_type
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if server is None and not opts.urn:
                raise TypeError("Missing required property 'server'")
            __props__.__dict__["server"] = server
            if stream_analytics_job_name is None and not opts.urn:
                raise TypeError("Missing required property 'stream_analytics_job_name'")
            __props__.__dict__["stream_analytics_job_name"] = stream_analytics_job_name
            __props__.__dict__["table"] = table
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ReferenceInputMssql, __self__).__init__(
            'azure:streamanalytics/referenceInputMssql:ReferenceInputMssql',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            database: Optional[pulumi.Input[builtins.str]] = None,
            delta_snapshot_query: Optional[pulumi.Input[builtins.str]] = None,
            full_snapshot_query: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            password: Optional[pulumi.Input[builtins.str]] = None,
            refresh_interval_duration: Optional[pulumi.Input[builtins.str]] = None,
            refresh_type: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            server: Optional[pulumi.Input[builtins.str]] = None,
            stream_analytics_job_name: Optional[pulumi.Input[builtins.str]] = None,
            table: Optional[pulumi.Input[builtins.str]] = None,
            username: Optional[pulumi.Input[builtins.str]] = None) -> 'ReferenceInputMssql':
        """
        Get an existing ReferenceInputMssql resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] database: The MS SQL database name where the reference data exists.
        :param pulumi.Input[builtins.str] delta_snapshot_query: The query used to retrieve incremental changes in the reference data from the MS SQL database. Cannot be set when `refresh_type` is `Static`.
        :param pulumi.Input[builtins.str] full_snapshot_query: The query used to retrieve the reference data from the MS SQL database.
        :param pulumi.Input[builtins.str] name: The name of the Reference Input MS SQL data. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] password: The password to connect to the MS SQL database.
        :param pulumi.Input[builtins.str] refresh_interval_duration: The frequency in `hh:mm:ss` with which the reference data should be retrieved from the MS SQL database e.g. `00:20:00` for every 20 minutes. Must be set when `refresh_type` is `RefreshPeriodicallyWithFull` or `RefreshPeriodicallyWithDelta`.
        :param pulumi.Input[builtins.str] refresh_type: Defines whether and how the reference data should be refreshed. Accepted values are `Static`, `RefreshPeriodicallyWithFull` and `RefreshPeriodicallyWithDelta`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Stream Analytics Job should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] server: The fully qualified domain name of the MS SQL server.
        :param pulumi.Input[builtins.str] stream_analytics_job_name: The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] table: The name of the table in the Azure SQL database.
        :param pulumi.Input[builtins.str] username: The username to connect to the MS SQL database.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReferenceInputMssqlState.__new__(_ReferenceInputMssqlState)

        __props__.__dict__["database"] = database
        __props__.__dict__["delta_snapshot_query"] = delta_snapshot_query
        __props__.__dict__["full_snapshot_query"] = full_snapshot_query
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["refresh_interval_duration"] = refresh_interval_duration
        __props__.__dict__["refresh_type"] = refresh_type
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["server"] = server
        __props__.__dict__["stream_analytics_job_name"] = stream_analytics_job_name
        __props__.__dict__["table"] = table
        __props__.__dict__["username"] = username
        return ReferenceInputMssql(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Output[builtins.str]:
        """
        The MS SQL database name where the reference data exists.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="deltaSnapshotQuery")
    def delta_snapshot_query(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The query used to retrieve incremental changes in the reference data from the MS SQL database. Cannot be set when `refresh_type` is `Static`.
        """
        return pulumi.get(self, "delta_snapshot_query")

    @property
    @pulumi.getter(name="fullSnapshotQuery")
    def full_snapshot_query(self) -> pulumi.Output[builtins.str]:
        """
        The query used to retrieve the reference data from the MS SQL database.
        """
        return pulumi.get(self, "full_snapshot_query")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Reference Input MS SQL data. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[builtins.str]:
        """
        The password to connect to the MS SQL database.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="refreshIntervalDuration")
    def refresh_interval_duration(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The frequency in `hh:mm:ss` with which the reference data should be retrieved from the MS SQL database e.g. `00:20:00` for every 20 minutes. Must be set when `refresh_type` is `RefreshPeriodicallyWithFull` or `RefreshPeriodicallyWithDelta`.
        """
        return pulumi.get(self, "refresh_interval_duration")

    @property
    @pulumi.getter(name="refreshType")
    def refresh_type(self) -> pulumi.Output[builtins.str]:
        """
        Defines whether and how the reference data should be refreshed. Accepted values are `Static`, `RefreshPeriodicallyWithFull` and `RefreshPeriodicallyWithDelta`.
        """
        return pulumi.get(self, "refresh_type")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Resource Group where the Stream Analytics Job should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def server(self) -> pulumi.Output[builtins.str]:
        """
        The fully qualified domain name of the MS SQL server.
        """
        return pulumi.get(self, "server")

    @property
    @pulumi.getter(name="streamAnalyticsJobName")
    def stream_analytics_job_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "stream_analytics_job_name")

    @property
    @pulumi.getter
    def table(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the table in the Azure SQL database.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[builtins.str]:
        """
        The username to connect to the MS SQL database.
        """
        return pulumi.get(self, "username")

