# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SparkPoolArgs', 'SparkPool']

@pulumi.input_type
class SparkPoolArgs:
    def __init__(__self__, *,
                 node_size: pulumi.Input[builtins.str],
                 node_size_family: pulumi.Input[builtins.str],
                 spark_version: pulumi.Input[builtins.str],
                 synapse_workspace_id: pulumi.Input[builtins.str],
                 auto_pause: Optional[pulumi.Input['SparkPoolAutoPauseArgs']] = None,
                 auto_scale: Optional[pulumi.Input['SparkPoolAutoScaleArgs']] = None,
                 cache_size: Optional[pulumi.Input[builtins.int]] = None,
                 compute_isolation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 dynamic_executor_allocation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 library_requirement: Optional[pulumi.Input['SparkPoolLibraryRequirementArgs']] = None,
                 max_executors: Optional[pulumi.Input[builtins.int]] = None,
                 min_executors: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_count: Optional[pulumi.Input[builtins.int]] = None,
                 session_level_packages_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 spark_config: Optional[pulumi.Input['SparkPoolSparkConfigArgs']] = None,
                 spark_events_folder: Optional[pulumi.Input[builtins.str]] = None,
                 spark_log_folder: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a SparkPool resource.
        :param pulumi.Input[builtins.str] node_size: The level of node in the Spark Pool. Possible values are `Small`, `Medium`, `Large`, `None`, `XLarge`, `XXLarge` and `XXXLarge`.
        :param pulumi.Input[builtins.str] node_size_family: The kind of nodes that the Spark Pool provides. Possible values are `HardwareAcceleratedFPGA`, `HardwareAcceleratedGPU`, `MemoryOptimized`, and `None`.
        :param pulumi.Input[builtins.str] spark_version: The Apache Spark version. Possible values are `3.2`, `3.3`, and `3.4`.
        :param pulumi.Input[builtins.str] synapse_workspace_id: The ID of the Synapse Workspace where the Synapse Spark Pool should exist. Changing this forces a new Synapse Spark Pool to be created.
        :param pulumi.Input['SparkPoolAutoPauseArgs'] auto_pause: An `auto_pause` block as defined below.
        :param pulumi.Input['SparkPoolAutoScaleArgs'] auto_scale: An `auto_scale` block as defined below. Exactly one of `node_count` or `auto_scale` must be specified.
        :param pulumi.Input[builtins.int] cache_size: The cache size in the Spark Pool.
        :param pulumi.Input[builtins.bool] compute_isolation_enabled: Indicates whether compute isolation is enabled or not. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Synapse Spark Pool. Changing this forces a new Synapse Spark Pool to be created.
        :param pulumi.Input[builtins.int] node_count: The number of nodes in the Spark Pool. Exactly one of `node_count` or `auto_scale` must be specified.
        """
        pulumi.set(__self__, "node_size", node_size)
        pulumi.set(__self__, "node_size_family", node_size_family)
        pulumi.set(__self__, "spark_version", spark_version)
        pulumi.set(__self__, "synapse_workspace_id", synapse_workspace_id)
        if auto_pause is not None:
            pulumi.set(__self__, "auto_pause", auto_pause)
        if auto_scale is not None:
            pulumi.set(__self__, "auto_scale", auto_scale)
        if cache_size is not None:
            pulumi.set(__self__, "cache_size", cache_size)
        if compute_isolation_enabled is not None:
            pulumi.set(__self__, "compute_isolation_enabled", compute_isolation_enabled)
        if dynamic_executor_allocation_enabled is not None:
            pulumi.set(__self__, "dynamic_executor_allocation_enabled", dynamic_executor_allocation_enabled)
        if library_requirement is not None:
            pulumi.set(__self__, "library_requirement", library_requirement)
        if max_executors is not None:
            pulumi.set(__self__, "max_executors", max_executors)
        if min_executors is not None:
            pulumi.set(__self__, "min_executors", min_executors)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if session_level_packages_enabled is not None:
            pulumi.set(__self__, "session_level_packages_enabled", session_level_packages_enabled)
        if spark_config is not None:
            pulumi.set(__self__, "spark_config", spark_config)
        if spark_events_folder is not None:
            pulumi.set(__self__, "spark_events_folder", spark_events_folder)
        if spark_log_folder is not None:
            pulumi.set(__self__, "spark_log_folder", spark_log_folder)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="nodeSize")
    def node_size(self) -> pulumi.Input[builtins.str]:
        """
        The level of node in the Spark Pool. Possible values are `Small`, `Medium`, `Large`, `None`, `XLarge`, `XXLarge` and `XXXLarge`.
        """
        return pulumi.get(self, "node_size")

    @node_size.setter
    def node_size(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "node_size", value)

    @property
    @pulumi.getter(name="nodeSizeFamily")
    def node_size_family(self) -> pulumi.Input[builtins.str]:
        """
        The kind of nodes that the Spark Pool provides. Possible values are `HardwareAcceleratedFPGA`, `HardwareAcceleratedGPU`, `MemoryOptimized`, and `None`.
        """
        return pulumi.get(self, "node_size_family")

    @node_size_family.setter
    def node_size_family(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "node_size_family", value)

    @property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> pulumi.Input[builtins.str]:
        """
        The Apache Spark version. Possible values are `3.2`, `3.3`, and `3.4`.
        """
        return pulumi.get(self, "spark_version")

    @spark_version.setter
    def spark_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "spark_version", value)

    @property
    @pulumi.getter(name="synapseWorkspaceId")
    def synapse_workspace_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Synapse Workspace where the Synapse Spark Pool should exist. Changing this forces a new Synapse Spark Pool to be created.
        """
        return pulumi.get(self, "synapse_workspace_id")

    @synapse_workspace_id.setter
    def synapse_workspace_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "synapse_workspace_id", value)

    @property
    @pulumi.getter(name="autoPause")
    def auto_pause(self) -> Optional[pulumi.Input['SparkPoolAutoPauseArgs']]:
        """
        An `auto_pause` block as defined below.
        """
        return pulumi.get(self, "auto_pause")

    @auto_pause.setter
    def auto_pause(self, value: Optional[pulumi.Input['SparkPoolAutoPauseArgs']]):
        pulumi.set(self, "auto_pause", value)

    @property
    @pulumi.getter(name="autoScale")
    def auto_scale(self) -> Optional[pulumi.Input['SparkPoolAutoScaleArgs']]:
        """
        An `auto_scale` block as defined below. Exactly one of `node_count` or `auto_scale` must be specified.
        """
        return pulumi.get(self, "auto_scale")

    @auto_scale.setter
    def auto_scale(self, value: Optional[pulumi.Input['SparkPoolAutoScaleArgs']]):
        pulumi.set(self, "auto_scale", value)

    @property
    @pulumi.getter(name="cacheSize")
    def cache_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The cache size in the Spark Pool.
        """
        return pulumi.get(self, "cache_size")

    @cache_size.setter
    def cache_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cache_size", value)

    @property
    @pulumi.getter(name="computeIsolationEnabled")
    def compute_isolation_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether compute isolation is enabled or not. Defaults to `false`.
        """
        return pulumi.get(self, "compute_isolation_enabled")

    @compute_isolation_enabled.setter
    def compute_isolation_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "compute_isolation_enabled", value)

    @property
    @pulumi.getter(name="dynamicExecutorAllocationEnabled")
    def dynamic_executor_allocation_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "dynamic_executor_allocation_enabled")

    @dynamic_executor_allocation_enabled.setter
    def dynamic_executor_allocation_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "dynamic_executor_allocation_enabled", value)

    @property
    @pulumi.getter(name="libraryRequirement")
    def library_requirement(self) -> Optional[pulumi.Input['SparkPoolLibraryRequirementArgs']]:
        return pulumi.get(self, "library_requirement")

    @library_requirement.setter
    def library_requirement(self, value: Optional[pulumi.Input['SparkPoolLibraryRequirementArgs']]):
        pulumi.set(self, "library_requirement", value)

    @property
    @pulumi.getter(name="maxExecutors")
    def max_executors(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "max_executors")

    @max_executors.setter
    def max_executors(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_executors", value)

    @property
    @pulumi.getter(name="minExecutors")
    def min_executors(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "min_executors")

    @min_executors.setter
    def min_executors(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_executors", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Synapse Spark Pool. Changing this forces a new Synapse Spark Pool to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of nodes in the Spark Pool. Exactly one of `node_count` or `auto_scale` must be specified.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="sessionLevelPackagesEnabled")
    def session_level_packages_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "session_level_packages_enabled")

    @session_level_packages_enabled.setter
    def session_level_packages_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "session_level_packages_enabled", value)

    @property
    @pulumi.getter(name="sparkConfig")
    def spark_config(self) -> Optional[pulumi.Input['SparkPoolSparkConfigArgs']]:
        return pulumi.get(self, "spark_config")

    @spark_config.setter
    def spark_config(self, value: Optional[pulumi.Input['SparkPoolSparkConfigArgs']]):
        pulumi.set(self, "spark_config", value)

    @property
    @pulumi.getter(name="sparkEventsFolder")
    def spark_events_folder(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "spark_events_folder")

    @spark_events_folder.setter
    def spark_events_folder(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spark_events_folder", value)

    @property
    @pulumi.getter(name="sparkLogFolder")
    def spark_log_folder(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "spark_log_folder")

    @spark_log_folder.setter
    def spark_log_folder(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spark_log_folder", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _SparkPoolState:
    def __init__(__self__, *,
                 auto_pause: Optional[pulumi.Input['SparkPoolAutoPauseArgs']] = None,
                 auto_scale: Optional[pulumi.Input['SparkPoolAutoScaleArgs']] = None,
                 cache_size: Optional[pulumi.Input[builtins.int]] = None,
                 compute_isolation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 dynamic_executor_allocation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 library_requirement: Optional[pulumi.Input['SparkPoolLibraryRequirementArgs']] = None,
                 max_executors: Optional[pulumi.Input[builtins.int]] = None,
                 min_executors: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_count: Optional[pulumi.Input[builtins.int]] = None,
                 node_size: Optional[pulumi.Input[builtins.str]] = None,
                 node_size_family: Optional[pulumi.Input[builtins.str]] = None,
                 session_level_packages_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 spark_config: Optional[pulumi.Input['SparkPoolSparkConfigArgs']] = None,
                 spark_events_folder: Optional[pulumi.Input[builtins.str]] = None,
                 spark_log_folder: Optional[pulumi.Input[builtins.str]] = None,
                 spark_version: Optional[pulumi.Input[builtins.str]] = None,
                 synapse_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering SparkPool resources.
        :param pulumi.Input['SparkPoolAutoPauseArgs'] auto_pause: An `auto_pause` block as defined below.
        :param pulumi.Input['SparkPoolAutoScaleArgs'] auto_scale: An `auto_scale` block as defined below. Exactly one of `node_count` or `auto_scale` must be specified.
        :param pulumi.Input[builtins.int] cache_size: The cache size in the Spark Pool.
        :param pulumi.Input[builtins.bool] compute_isolation_enabled: Indicates whether compute isolation is enabled or not. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Synapse Spark Pool. Changing this forces a new Synapse Spark Pool to be created.
        :param pulumi.Input[builtins.int] node_count: The number of nodes in the Spark Pool. Exactly one of `node_count` or `auto_scale` must be specified.
        :param pulumi.Input[builtins.str] node_size: The level of node in the Spark Pool. Possible values are `Small`, `Medium`, `Large`, `None`, `XLarge`, `XXLarge` and `XXXLarge`.
        :param pulumi.Input[builtins.str] node_size_family: The kind of nodes that the Spark Pool provides. Possible values are `HardwareAcceleratedFPGA`, `HardwareAcceleratedGPU`, `MemoryOptimized`, and `None`.
        :param pulumi.Input[builtins.str] spark_version: The Apache Spark version. Possible values are `3.2`, `3.3`, and `3.4`.
        :param pulumi.Input[builtins.str] synapse_workspace_id: The ID of the Synapse Workspace where the Synapse Spark Pool should exist. Changing this forces a new Synapse Spark Pool to be created.
        """
        if auto_pause is not None:
            pulumi.set(__self__, "auto_pause", auto_pause)
        if auto_scale is not None:
            pulumi.set(__self__, "auto_scale", auto_scale)
        if cache_size is not None:
            pulumi.set(__self__, "cache_size", cache_size)
        if compute_isolation_enabled is not None:
            pulumi.set(__self__, "compute_isolation_enabled", compute_isolation_enabled)
        if dynamic_executor_allocation_enabled is not None:
            pulumi.set(__self__, "dynamic_executor_allocation_enabled", dynamic_executor_allocation_enabled)
        if library_requirement is not None:
            pulumi.set(__self__, "library_requirement", library_requirement)
        if max_executors is not None:
            pulumi.set(__self__, "max_executors", max_executors)
        if min_executors is not None:
            pulumi.set(__self__, "min_executors", min_executors)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if node_size is not None:
            pulumi.set(__self__, "node_size", node_size)
        if node_size_family is not None:
            pulumi.set(__self__, "node_size_family", node_size_family)
        if session_level_packages_enabled is not None:
            pulumi.set(__self__, "session_level_packages_enabled", session_level_packages_enabled)
        if spark_config is not None:
            pulumi.set(__self__, "spark_config", spark_config)
        if spark_events_folder is not None:
            pulumi.set(__self__, "spark_events_folder", spark_events_folder)
        if spark_log_folder is not None:
            pulumi.set(__self__, "spark_log_folder", spark_log_folder)
        if spark_version is not None:
            pulumi.set(__self__, "spark_version", spark_version)
        if synapse_workspace_id is not None:
            pulumi.set(__self__, "synapse_workspace_id", synapse_workspace_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="autoPause")
    def auto_pause(self) -> Optional[pulumi.Input['SparkPoolAutoPauseArgs']]:
        """
        An `auto_pause` block as defined below.
        """
        return pulumi.get(self, "auto_pause")

    @auto_pause.setter
    def auto_pause(self, value: Optional[pulumi.Input['SparkPoolAutoPauseArgs']]):
        pulumi.set(self, "auto_pause", value)

    @property
    @pulumi.getter(name="autoScale")
    def auto_scale(self) -> Optional[pulumi.Input['SparkPoolAutoScaleArgs']]:
        """
        An `auto_scale` block as defined below. Exactly one of `node_count` or `auto_scale` must be specified.
        """
        return pulumi.get(self, "auto_scale")

    @auto_scale.setter
    def auto_scale(self, value: Optional[pulumi.Input['SparkPoolAutoScaleArgs']]):
        pulumi.set(self, "auto_scale", value)

    @property
    @pulumi.getter(name="cacheSize")
    def cache_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The cache size in the Spark Pool.
        """
        return pulumi.get(self, "cache_size")

    @cache_size.setter
    def cache_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cache_size", value)

    @property
    @pulumi.getter(name="computeIsolationEnabled")
    def compute_isolation_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether compute isolation is enabled or not. Defaults to `false`.
        """
        return pulumi.get(self, "compute_isolation_enabled")

    @compute_isolation_enabled.setter
    def compute_isolation_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "compute_isolation_enabled", value)

    @property
    @pulumi.getter(name="dynamicExecutorAllocationEnabled")
    def dynamic_executor_allocation_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "dynamic_executor_allocation_enabled")

    @dynamic_executor_allocation_enabled.setter
    def dynamic_executor_allocation_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "dynamic_executor_allocation_enabled", value)

    @property
    @pulumi.getter(name="libraryRequirement")
    def library_requirement(self) -> Optional[pulumi.Input['SparkPoolLibraryRequirementArgs']]:
        return pulumi.get(self, "library_requirement")

    @library_requirement.setter
    def library_requirement(self, value: Optional[pulumi.Input['SparkPoolLibraryRequirementArgs']]):
        pulumi.set(self, "library_requirement", value)

    @property
    @pulumi.getter(name="maxExecutors")
    def max_executors(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "max_executors")

    @max_executors.setter
    def max_executors(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_executors", value)

    @property
    @pulumi.getter(name="minExecutors")
    def min_executors(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "min_executors")

    @min_executors.setter
    def min_executors(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_executors", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Synapse Spark Pool. Changing this forces a new Synapse Spark Pool to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of nodes in the Spark Pool. Exactly one of `node_count` or `auto_scale` must be specified.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="nodeSize")
    def node_size(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The level of node in the Spark Pool. Possible values are `Small`, `Medium`, `Large`, `None`, `XLarge`, `XXLarge` and `XXXLarge`.
        """
        return pulumi.get(self, "node_size")

    @node_size.setter
    def node_size(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_size", value)

    @property
    @pulumi.getter(name="nodeSizeFamily")
    def node_size_family(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The kind of nodes that the Spark Pool provides. Possible values are `HardwareAcceleratedFPGA`, `HardwareAcceleratedGPU`, `MemoryOptimized`, and `None`.
        """
        return pulumi.get(self, "node_size_family")

    @node_size_family.setter
    def node_size_family(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_size_family", value)

    @property
    @pulumi.getter(name="sessionLevelPackagesEnabled")
    def session_level_packages_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "session_level_packages_enabled")

    @session_level_packages_enabled.setter
    def session_level_packages_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "session_level_packages_enabled", value)

    @property
    @pulumi.getter(name="sparkConfig")
    def spark_config(self) -> Optional[pulumi.Input['SparkPoolSparkConfigArgs']]:
        return pulumi.get(self, "spark_config")

    @spark_config.setter
    def spark_config(self, value: Optional[pulumi.Input['SparkPoolSparkConfigArgs']]):
        pulumi.set(self, "spark_config", value)

    @property
    @pulumi.getter(name="sparkEventsFolder")
    def spark_events_folder(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "spark_events_folder")

    @spark_events_folder.setter
    def spark_events_folder(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spark_events_folder", value)

    @property
    @pulumi.getter(name="sparkLogFolder")
    def spark_log_folder(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "spark_log_folder")

    @spark_log_folder.setter
    def spark_log_folder(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spark_log_folder", value)

    @property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Apache Spark version. Possible values are `3.2`, `3.3`, and `3.4`.
        """
        return pulumi.get(self, "spark_version")

    @spark_version.setter
    def spark_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spark_version", value)

    @property
    @pulumi.getter(name="synapseWorkspaceId")
    def synapse_workspace_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Synapse Workspace where the Synapse Spark Pool should exist. Changing this forces a new Synapse Spark Pool to be created.
        """
        return pulumi.get(self, "synapse_workspace_id")

    @synapse_workspace_id.setter
    def synapse_workspace_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "synapse_workspace_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:synapse/sparkPool:SparkPool")
class SparkPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pause: Optional[pulumi.Input[Union['SparkPoolAutoPauseArgs', 'SparkPoolAutoPauseArgsDict']]] = None,
                 auto_scale: Optional[pulumi.Input[Union['SparkPoolAutoScaleArgs', 'SparkPoolAutoScaleArgsDict']]] = None,
                 cache_size: Optional[pulumi.Input[builtins.int]] = None,
                 compute_isolation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 dynamic_executor_allocation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 library_requirement: Optional[pulumi.Input[Union['SparkPoolLibraryRequirementArgs', 'SparkPoolLibraryRequirementArgsDict']]] = None,
                 max_executors: Optional[pulumi.Input[builtins.int]] = None,
                 min_executors: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_count: Optional[pulumi.Input[builtins.int]] = None,
                 node_size: Optional[pulumi.Input[builtins.str]] = None,
                 node_size_family: Optional[pulumi.Input[builtins.str]] = None,
                 session_level_packages_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 spark_config: Optional[pulumi.Input[Union['SparkPoolSparkConfigArgs', 'SparkPoolSparkConfigArgsDict']]] = None,
                 spark_events_folder: Optional[pulumi.Input[builtins.str]] = None,
                 spark_log_folder: Optional[pulumi.Input[builtins.str]] = None,
                 spark_version: Optional[pulumi.Input[builtins.str]] = None,
                 synapse_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Synapse Spark Pool.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestorageacc",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS",
            account_kind="StorageV2",
            is_hns_enabled=True)
        example_data_lake_gen2_filesystem = azure.storage.DataLakeGen2Filesystem("example",
            name="example",
            storage_account_id=example_account.id)
        example_workspace = azure.synapse.Workspace("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            storage_data_lake_gen2_filesystem_id=example_data_lake_gen2_filesystem.id,
            sql_administrator_login="sqladminuser",
            sql_administrator_login_password="H@Sh1CoR3!",
            identity={
                "type": "SystemAssigned",
            })
        example_spark_pool = azure.synapse.SparkPool("example",
            name="example",
            synapse_workspace_id=example_workspace.id,
            node_size_family="MemoryOptimized",
            node_size="Small",
            cache_size=100,
            auto_scale={
                "max_node_count": 50,
                "min_node_count": 3,
            },
            auto_pause={
                "delay_in_minutes": 15,
            },
            library_requirement={
                "content": \"\"\"appnope==0.1.0
        beautifulsoup4==4.6.3
        \"\"\",
                "filename": "requirements.txt",
            },
            spark_config={
                "content": "spark.shuffle.spill                true\\n",
                "filename": "config.txt",
            },
            spark_version="3.2",
            tags={
                "ENV": "Production",
            })
        ```

        ## Import

        Synapse Spark Pool can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:synapse/sparkPool:SparkPool example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Synapse/workspaces/workspace1/bigDataPools/sparkPool1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SparkPoolAutoPauseArgs', 'SparkPoolAutoPauseArgsDict']] auto_pause: An `auto_pause` block as defined below.
        :param pulumi.Input[Union['SparkPoolAutoScaleArgs', 'SparkPoolAutoScaleArgsDict']] auto_scale: An `auto_scale` block as defined below. Exactly one of `node_count` or `auto_scale` must be specified.
        :param pulumi.Input[builtins.int] cache_size: The cache size in the Spark Pool.
        :param pulumi.Input[builtins.bool] compute_isolation_enabled: Indicates whether compute isolation is enabled or not. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Synapse Spark Pool. Changing this forces a new Synapse Spark Pool to be created.
        :param pulumi.Input[builtins.int] node_count: The number of nodes in the Spark Pool. Exactly one of `node_count` or `auto_scale` must be specified.
        :param pulumi.Input[builtins.str] node_size: The level of node in the Spark Pool. Possible values are `Small`, `Medium`, `Large`, `None`, `XLarge`, `XXLarge` and `XXXLarge`.
        :param pulumi.Input[builtins.str] node_size_family: The kind of nodes that the Spark Pool provides. Possible values are `HardwareAcceleratedFPGA`, `HardwareAcceleratedGPU`, `MemoryOptimized`, and `None`.
        :param pulumi.Input[builtins.str] spark_version: The Apache Spark version. Possible values are `3.2`, `3.3`, and `3.4`.
        :param pulumi.Input[builtins.str] synapse_workspace_id: The ID of the Synapse Workspace where the Synapse Spark Pool should exist. Changing this forces a new Synapse Spark Pool to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SparkPoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Synapse Spark Pool.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestorageacc",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS",
            account_kind="StorageV2",
            is_hns_enabled=True)
        example_data_lake_gen2_filesystem = azure.storage.DataLakeGen2Filesystem("example",
            name="example",
            storage_account_id=example_account.id)
        example_workspace = azure.synapse.Workspace("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            storage_data_lake_gen2_filesystem_id=example_data_lake_gen2_filesystem.id,
            sql_administrator_login="sqladminuser",
            sql_administrator_login_password="H@Sh1CoR3!",
            identity={
                "type": "SystemAssigned",
            })
        example_spark_pool = azure.synapse.SparkPool("example",
            name="example",
            synapse_workspace_id=example_workspace.id,
            node_size_family="MemoryOptimized",
            node_size="Small",
            cache_size=100,
            auto_scale={
                "max_node_count": 50,
                "min_node_count": 3,
            },
            auto_pause={
                "delay_in_minutes": 15,
            },
            library_requirement={
                "content": \"\"\"appnope==0.1.0
        beautifulsoup4==4.6.3
        \"\"\",
                "filename": "requirements.txt",
            },
            spark_config={
                "content": "spark.shuffle.spill                true\\n",
                "filename": "config.txt",
            },
            spark_version="3.2",
            tags={
                "ENV": "Production",
            })
        ```

        ## Import

        Synapse Spark Pool can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:synapse/sparkPool:SparkPool example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Synapse/workspaces/workspace1/bigDataPools/sparkPool1
        ```

        :param str resource_name: The name of the resource.
        :param SparkPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SparkPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pause: Optional[pulumi.Input[Union['SparkPoolAutoPauseArgs', 'SparkPoolAutoPauseArgsDict']]] = None,
                 auto_scale: Optional[pulumi.Input[Union['SparkPoolAutoScaleArgs', 'SparkPoolAutoScaleArgsDict']]] = None,
                 cache_size: Optional[pulumi.Input[builtins.int]] = None,
                 compute_isolation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 dynamic_executor_allocation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 library_requirement: Optional[pulumi.Input[Union['SparkPoolLibraryRequirementArgs', 'SparkPoolLibraryRequirementArgsDict']]] = None,
                 max_executors: Optional[pulumi.Input[builtins.int]] = None,
                 min_executors: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_count: Optional[pulumi.Input[builtins.int]] = None,
                 node_size: Optional[pulumi.Input[builtins.str]] = None,
                 node_size_family: Optional[pulumi.Input[builtins.str]] = None,
                 session_level_packages_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 spark_config: Optional[pulumi.Input[Union['SparkPoolSparkConfigArgs', 'SparkPoolSparkConfigArgsDict']]] = None,
                 spark_events_folder: Optional[pulumi.Input[builtins.str]] = None,
                 spark_log_folder: Optional[pulumi.Input[builtins.str]] = None,
                 spark_version: Optional[pulumi.Input[builtins.str]] = None,
                 synapse_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SparkPoolArgs.__new__(SparkPoolArgs)

            __props__.__dict__["auto_pause"] = auto_pause
            __props__.__dict__["auto_scale"] = auto_scale
            __props__.__dict__["cache_size"] = cache_size
            __props__.__dict__["compute_isolation_enabled"] = compute_isolation_enabled
            __props__.__dict__["dynamic_executor_allocation_enabled"] = dynamic_executor_allocation_enabled
            __props__.__dict__["library_requirement"] = library_requirement
            __props__.__dict__["max_executors"] = max_executors
            __props__.__dict__["min_executors"] = min_executors
            __props__.__dict__["name"] = name
            __props__.__dict__["node_count"] = node_count
            if node_size is None and not opts.urn:
                raise TypeError("Missing required property 'node_size'")
            __props__.__dict__["node_size"] = node_size
            if node_size_family is None and not opts.urn:
                raise TypeError("Missing required property 'node_size_family'")
            __props__.__dict__["node_size_family"] = node_size_family
            __props__.__dict__["session_level_packages_enabled"] = session_level_packages_enabled
            __props__.__dict__["spark_config"] = spark_config
            __props__.__dict__["spark_events_folder"] = spark_events_folder
            __props__.__dict__["spark_log_folder"] = spark_log_folder
            if spark_version is None and not opts.urn:
                raise TypeError("Missing required property 'spark_version'")
            __props__.__dict__["spark_version"] = spark_version
            if synapse_workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'synapse_workspace_id'")
            __props__.__dict__["synapse_workspace_id"] = synapse_workspace_id
            __props__.__dict__["tags"] = tags
        super(SparkPool, __self__).__init__(
            'azure:synapse/sparkPool:SparkPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_pause: Optional[pulumi.Input[Union['SparkPoolAutoPauseArgs', 'SparkPoolAutoPauseArgsDict']]] = None,
            auto_scale: Optional[pulumi.Input[Union['SparkPoolAutoScaleArgs', 'SparkPoolAutoScaleArgsDict']]] = None,
            cache_size: Optional[pulumi.Input[builtins.int]] = None,
            compute_isolation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            dynamic_executor_allocation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            library_requirement: Optional[pulumi.Input[Union['SparkPoolLibraryRequirementArgs', 'SparkPoolLibraryRequirementArgsDict']]] = None,
            max_executors: Optional[pulumi.Input[builtins.int]] = None,
            min_executors: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            node_count: Optional[pulumi.Input[builtins.int]] = None,
            node_size: Optional[pulumi.Input[builtins.str]] = None,
            node_size_family: Optional[pulumi.Input[builtins.str]] = None,
            session_level_packages_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            spark_config: Optional[pulumi.Input[Union['SparkPoolSparkConfigArgs', 'SparkPoolSparkConfigArgsDict']]] = None,
            spark_events_folder: Optional[pulumi.Input[builtins.str]] = None,
            spark_log_folder: Optional[pulumi.Input[builtins.str]] = None,
            spark_version: Optional[pulumi.Input[builtins.str]] = None,
            synapse_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'SparkPool':
        """
        Get an existing SparkPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SparkPoolAutoPauseArgs', 'SparkPoolAutoPauseArgsDict']] auto_pause: An `auto_pause` block as defined below.
        :param pulumi.Input[Union['SparkPoolAutoScaleArgs', 'SparkPoolAutoScaleArgsDict']] auto_scale: An `auto_scale` block as defined below. Exactly one of `node_count` or `auto_scale` must be specified.
        :param pulumi.Input[builtins.int] cache_size: The cache size in the Spark Pool.
        :param pulumi.Input[builtins.bool] compute_isolation_enabled: Indicates whether compute isolation is enabled or not. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Synapse Spark Pool. Changing this forces a new Synapse Spark Pool to be created.
        :param pulumi.Input[builtins.int] node_count: The number of nodes in the Spark Pool. Exactly one of `node_count` or `auto_scale` must be specified.
        :param pulumi.Input[builtins.str] node_size: The level of node in the Spark Pool. Possible values are `Small`, `Medium`, `Large`, `None`, `XLarge`, `XXLarge` and `XXXLarge`.
        :param pulumi.Input[builtins.str] node_size_family: The kind of nodes that the Spark Pool provides. Possible values are `HardwareAcceleratedFPGA`, `HardwareAcceleratedGPU`, `MemoryOptimized`, and `None`.
        :param pulumi.Input[builtins.str] spark_version: The Apache Spark version. Possible values are `3.2`, `3.3`, and `3.4`.
        :param pulumi.Input[builtins.str] synapse_workspace_id: The ID of the Synapse Workspace where the Synapse Spark Pool should exist. Changing this forces a new Synapse Spark Pool to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SparkPoolState.__new__(_SparkPoolState)

        __props__.__dict__["auto_pause"] = auto_pause
        __props__.__dict__["auto_scale"] = auto_scale
        __props__.__dict__["cache_size"] = cache_size
        __props__.__dict__["compute_isolation_enabled"] = compute_isolation_enabled
        __props__.__dict__["dynamic_executor_allocation_enabled"] = dynamic_executor_allocation_enabled
        __props__.__dict__["library_requirement"] = library_requirement
        __props__.__dict__["max_executors"] = max_executors
        __props__.__dict__["min_executors"] = min_executors
        __props__.__dict__["name"] = name
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["node_size"] = node_size
        __props__.__dict__["node_size_family"] = node_size_family
        __props__.__dict__["session_level_packages_enabled"] = session_level_packages_enabled
        __props__.__dict__["spark_config"] = spark_config
        __props__.__dict__["spark_events_folder"] = spark_events_folder
        __props__.__dict__["spark_log_folder"] = spark_log_folder
        __props__.__dict__["spark_version"] = spark_version
        __props__.__dict__["synapse_workspace_id"] = synapse_workspace_id
        __props__.__dict__["tags"] = tags
        return SparkPool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoPause")
    def auto_pause(self) -> pulumi.Output[Optional['outputs.SparkPoolAutoPause']]:
        """
        An `auto_pause` block as defined below.
        """
        return pulumi.get(self, "auto_pause")

    @property
    @pulumi.getter(name="autoScale")
    def auto_scale(self) -> pulumi.Output[Optional['outputs.SparkPoolAutoScale']]:
        """
        An `auto_scale` block as defined below. Exactly one of `node_count` or `auto_scale` must be specified.
        """
        return pulumi.get(self, "auto_scale")

    @property
    @pulumi.getter(name="cacheSize")
    def cache_size(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The cache size in the Spark Pool.
        """
        return pulumi.get(self, "cache_size")

    @property
    @pulumi.getter(name="computeIsolationEnabled")
    def compute_isolation_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether compute isolation is enabled or not. Defaults to `false`.
        """
        return pulumi.get(self, "compute_isolation_enabled")

    @property
    @pulumi.getter(name="dynamicExecutorAllocationEnabled")
    def dynamic_executor_allocation_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "dynamic_executor_allocation_enabled")

    @property
    @pulumi.getter(name="libraryRequirement")
    def library_requirement(self) -> pulumi.Output[Optional['outputs.SparkPoolLibraryRequirement']]:
        return pulumi.get(self, "library_requirement")

    @property
    @pulumi.getter(name="maxExecutors")
    def max_executors(self) -> pulumi.Output[Optional[builtins.int]]:
        return pulumi.get(self, "max_executors")

    @property
    @pulumi.getter(name="minExecutors")
    def min_executors(self) -> pulumi.Output[Optional[builtins.int]]:
        return pulumi.get(self, "min_executors")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Synapse Spark Pool. Changing this forces a new Synapse Spark Pool to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[builtins.int]:
        """
        The number of nodes in the Spark Pool. Exactly one of `node_count` or `auto_scale` must be specified.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nodeSize")
    def node_size(self) -> pulumi.Output[builtins.str]:
        """
        The level of node in the Spark Pool. Possible values are `Small`, `Medium`, `Large`, `None`, `XLarge`, `XXLarge` and `XXXLarge`.
        """
        return pulumi.get(self, "node_size")

    @property
    @pulumi.getter(name="nodeSizeFamily")
    def node_size_family(self) -> pulumi.Output[builtins.str]:
        """
        The kind of nodes that the Spark Pool provides. Possible values are `HardwareAcceleratedFPGA`, `HardwareAcceleratedGPU`, `MemoryOptimized`, and `None`.
        """
        return pulumi.get(self, "node_size_family")

    @property
    @pulumi.getter(name="sessionLevelPackagesEnabled")
    def session_level_packages_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "session_level_packages_enabled")

    @property
    @pulumi.getter(name="sparkConfig")
    def spark_config(self) -> pulumi.Output[Optional['outputs.SparkPoolSparkConfig']]:
        return pulumi.get(self, "spark_config")

    @property
    @pulumi.getter(name="sparkEventsFolder")
    def spark_events_folder(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "spark_events_folder")

    @property
    @pulumi.getter(name="sparkLogFolder")
    def spark_log_folder(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "spark_log_folder")

    @property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> pulumi.Output[builtins.str]:
        """
        The Apache Spark version. Possible values are `3.2`, `3.3`, and `3.4`.
        """
        return pulumi.get(self, "spark_version")

    @property
    @pulumi.getter(name="synapseWorkspaceId")
    def synapse_workspace_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Synapse Workspace where the Synapse Spark Pool should exist. Changing this forces a new Synapse Spark Pool to be created.
        """
        return pulumi.get(self, "synapse_workspace_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        return pulumi.get(self, "tags")

