# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SqlPoolExtendedAuditingPolicyArgs', 'SqlPoolExtendedAuditingPolicy']

@pulumi.input_type
class SqlPoolExtendedAuditingPolicyArgs:
    def __init__(__self__, *,
                 sql_pool_id: pulumi.Input[builtins.str],
                 log_monitoring_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 retention_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 storage_account_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_access_key_is_secondary: Optional[pulumi.Input[builtins.bool]] = None,
                 storage_endpoint: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a SqlPoolExtendedAuditingPolicy resource.
        :param pulumi.Input[builtins.str] sql_pool_id: The ID of the Synapse SQL pool to set the extended auditing policy. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] log_monitoring_enabled: Enable audit events to Azure Monitor? To enable server audit events to Azure Monitor, please enable its master database audit events to Azure Monitor. Defaults to `true`.
        :param pulumi.Input[builtins.int] retention_in_days: The number of days to retain logs for in the storage account. Defaults to `0`.
        :param pulumi.Input[builtins.str] storage_account_access_key: The access key to use for the auditing storage account.
        :param pulumi.Input[builtins.bool] storage_account_access_key_is_secondary: Is `storage_account_access_key` value the storage's secondary key?
        :param pulumi.Input[builtins.str] storage_endpoint: The blob storage endpoint (e.g. <https://example.blob.core.windows.net>). This blob storage will hold all extended auditing logs.
        """
        pulumi.set(__self__, "sql_pool_id", sql_pool_id)
        if log_monitoring_enabled is not None:
            pulumi.set(__self__, "log_monitoring_enabled", log_monitoring_enabled)
        if retention_in_days is not None:
            pulumi.set(__self__, "retention_in_days", retention_in_days)
        if storage_account_access_key is not None:
            pulumi.set(__self__, "storage_account_access_key", storage_account_access_key)
        if storage_account_access_key_is_secondary is not None:
            pulumi.set(__self__, "storage_account_access_key_is_secondary", storage_account_access_key_is_secondary)
        if storage_endpoint is not None:
            pulumi.set(__self__, "storage_endpoint", storage_endpoint)

    @property
    @pulumi.getter(name="sqlPoolId")
    def sql_pool_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Synapse SQL pool to set the extended auditing policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sql_pool_id")

    @sql_pool_id.setter
    def sql_pool_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "sql_pool_id", value)

    @property
    @pulumi.getter(name="logMonitoringEnabled")
    def log_monitoring_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable audit events to Azure Monitor? To enable server audit events to Azure Monitor, please enable its master database audit events to Azure Monitor. Defaults to `true`.
        """
        return pulumi.get(self, "log_monitoring_enabled")

    @log_monitoring_enabled.setter
    def log_monitoring_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "log_monitoring_enabled", value)

    @property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of days to retain logs for in the storage account. Defaults to `0`.
        """
        return pulumi.get(self, "retention_in_days")

    @retention_in_days.setter
    def retention_in_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retention_in_days", value)

    @property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The access key to use for the auditing storage account.
        """
        return pulumi.get(self, "storage_account_access_key")

    @storage_account_access_key.setter
    def storage_account_access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_account_access_key", value)

    @property
    @pulumi.getter(name="storageAccountAccessKeyIsSecondary")
    def storage_account_access_key_is_secondary(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is `storage_account_access_key` value the storage's secondary key?
        """
        return pulumi.get(self, "storage_account_access_key_is_secondary")

    @storage_account_access_key_is_secondary.setter
    def storage_account_access_key_is_secondary(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "storage_account_access_key_is_secondary", value)

    @property
    @pulumi.getter(name="storageEndpoint")
    def storage_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The blob storage endpoint (e.g. <https://example.blob.core.windows.net>). This blob storage will hold all extended auditing logs.
        """
        return pulumi.get(self, "storage_endpoint")

    @storage_endpoint.setter
    def storage_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_endpoint", value)


@pulumi.input_type
class _SqlPoolExtendedAuditingPolicyState:
    def __init__(__self__, *,
                 log_monitoring_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 retention_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 sql_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_access_key_is_secondary: Optional[pulumi.Input[builtins.bool]] = None,
                 storage_endpoint: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SqlPoolExtendedAuditingPolicy resources.
        :param pulumi.Input[builtins.bool] log_monitoring_enabled: Enable audit events to Azure Monitor? To enable server audit events to Azure Monitor, please enable its master database audit events to Azure Monitor. Defaults to `true`.
        :param pulumi.Input[builtins.int] retention_in_days: The number of days to retain logs for in the storage account. Defaults to `0`.
        :param pulumi.Input[builtins.str] sql_pool_id: The ID of the Synapse SQL pool to set the extended auditing policy. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] storage_account_access_key: The access key to use for the auditing storage account.
        :param pulumi.Input[builtins.bool] storage_account_access_key_is_secondary: Is `storage_account_access_key` value the storage's secondary key?
        :param pulumi.Input[builtins.str] storage_endpoint: The blob storage endpoint (e.g. <https://example.blob.core.windows.net>). This blob storage will hold all extended auditing logs.
        """
        if log_monitoring_enabled is not None:
            pulumi.set(__self__, "log_monitoring_enabled", log_monitoring_enabled)
        if retention_in_days is not None:
            pulumi.set(__self__, "retention_in_days", retention_in_days)
        if sql_pool_id is not None:
            pulumi.set(__self__, "sql_pool_id", sql_pool_id)
        if storage_account_access_key is not None:
            pulumi.set(__self__, "storage_account_access_key", storage_account_access_key)
        if storage_account_access_key_is_secondary is not None:
            pulumi.set(__self__, "storage_account_access_key_is_secondary", storage_account_access_key_is_secondary)
        if storage_endpoint is not None:
            pulumi.set(__self__, "storage_endpoint", storage_endpoint)

    @property
    @pulumi.getter(name="logMonitoringEnabled")
    def log_monitoring_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable audit events to Azure Monitor? To enable server audit events to Azure Monitor, please enable its master database audit events to Azure Monitor. Defaults to `true`.
        """
        return pulumi.get(self, "log_monitoring_enabled")

    @log_monitoring_enabled.setter
    def log_monitoring_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "log_monitoring_enabled", value)

    @property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of days to retain logs for in the storage account. Defaults to `0`.
        """
        return pulumi.get(self, "retention_in_days")

    @retention_in_days.setter
    def retention_in_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retention_in_days", value)

    @property
    @pulumi.getter(name="sqlPoolId")
    def sql_pool_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Synapse SQL pool to set the extended auditing policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sql_pool_id")

    @sql_pool_id.setter
    def sql_pool_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sql_pool_id", value)

    @property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The access key to use for the auditing storage account.
        """
        return pulumi.get(self, "storage_account_access_key")

    @storage_account_access_key.setter
    def storage_account_access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_account_access_key", value)

    @property
    @pulumi.getter(name="storageAccountAccessKeyIsSecondary")
    def storage_account_access_key_is_secondary(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is `storage_account_access_key` value the storage's secondary key?
        """
        return pulumi.get(self, "storage_account_access_key_is_secondary")

    @storage_account_access_key_is_secondary.setter
    def storage_account_access_key_is_secondary(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "storage_account_access_key_is_secondary", value)

    @property
    @pulumi.getter(name="storageEndpoint")
    def storage_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The blob storage endpoint (e.g. <https://example.blob.core.windows.net>). This blob storage will hold all extended auditing logs.
        """
        return pulumi.get(self, "storage_endpoint")

    @storage_endpoint.setter
    def storage_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_endpoint", value)


@pulumi.type_token("azure:synapse/sqlPoolExtendedAuditingPolicy:SqlPoolExtendedAuditingPolicy")
class SqlPoolExtendedAuditingPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 log_monitoring_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 retention_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 sql_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_access_key_is_secondary: Optional[pulumi.Input[builtins.bool]] = None,
                 storage_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Synapse SQL Pool Extended Auditing Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestorageacc",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS",
            account_kind="BlobStorage")
        example_data_lake_gen2_filesystem = azure.storage.DataLakeGen2Filesystem("example",
            name="example",
            storage_account_id=example_account.id)
        example_workspace = azure.synapse.Workspace("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            storage_data_lake_gen2_filesystem_id=example_data_lake_gen2_filesystem.id,
            sql_administrator_login="sqladminuser",
            sql_administrator_login_password="H@Sh1CoR3!",
            identity={
                "type": "SystemAssigned",
            })
        example_sql_pool = azure.synapse.SqlPool("example",
            name="examplesqlpool",
            synapse_workspace_id=example_workspace.id,
            sku_name="DW100c",
            create_mode="Default")
        audit_logs = azure.storage.Account("audit_logs",
            name="examplesa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_sql_pool_extended_auditing_policy = azure.synapse.SqlPoolExtendedAuditingPolicy("example",
            sql_pool_id=example_sql_pool.id,
            storage_endpoint=audit_logs.primary_blob_endpoint,
            storage_account_access_key=audit_logs.primary_access_key,
            storage_account_access_key_is_secondary=False,
            retention_in_days=6)
        ```

        ## Import

        Synapse SQL Pool Extended Auditing Policys can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:synapse/sqlPoolExtendedAuditingPolicy:SqlPoolExtendedAuditingPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Synapse/workspaces/workspace1/sqlPools/sqlPool1/extendedAuditingSettings/default
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] log_monitoring_enabled: Enable audit events to Azure Monitor? To enable server audit events to Azure Monitor, please enable its master database audit events to Azure Monitor. Defaults to `true`.
        :param pulumi.Input[builtins.int] retention_in_days: The number of days to retain logs for in the storage account. Defaults to `0`.
        :param pulumi.Input[builtins.str] sql_pool_id: The ID of the Synapse SQL pool to set the extended auditing policy. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] storage_account_access_key: The access key to use for the auditing storage account.
        :param pulumi.Input[builtins.bool] storage_account_access_key_is_secondary: Is `storage_account_access_key` value the storage's secondary key?
        :param pulumi.Input[builtins.str] storage_endpoint: The blob storage endpoint (e.g. <https://example.blob.core.windows.net>). This blob storage will hold all extended auditing logs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SqlPoolExtendedAuditingPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Synapse SQL Pool Extended Auditing Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestorageacc",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS",
            account_kind="BlobStorage")
        example_data_lake_gen2_filesystem = azure.storage.DataLakeGen2Filesystem("example",
            name="example",
            storage_account_id=example_account.id)
        example_workspace = azure.synapse.Workspace("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            storage_data_lake_gen2_filesystem_id=example_data_lake_gen2_filesystem.id,
            sql_administrator_login="sqladminuser",
            sql_administrator_login_password="H@Sh1CoR3!",
            identity={
                "type": "SystemAssigned",
            })
        example_sql_pool = azure.synapse.SqlPool("example",
            name="examplesqlpool",
            synapse_workspace_id=example_workspace.id,
            sku_name="DW100c",
            create_mode="Default")
        audit_logs = azure.storage.Account("audit_logs",
            name="examplesa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_sql_pool_extended_auditing_policy = azure.synapse.SqlPoolExtendedAuditingPolicy("example",
            sql_pool_id=example_sql_pool.id,
            storage_endpoint=audit_logs.primary_blob_endpoint,
            storage_account_access_key=audit_logs.primary_access_key,
            storage_account_access_key_is_secondary=False,
            retention_in_days=6)
        ```

        ## Import

        Synapse SQL Pool Extended Auditing Policys can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:synapse/sqlPoolExtendedAuditingPolicy:SqlPoolExtendedAuditingPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Synapse/workspaces/workspace1/sqlPools/sqlPool1/extendedAuditingSettings/default
        ```

        :param str resource_name: The name of the resource.
        :param SqlPoolExtendedAuditingPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SqlPoolExtendedAuditingPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 log_monitoring_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 retention_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 sql_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_access_key_is_secondary: Optional[pulumi.Input[builtins.bool]] = None,
                 storage_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SqlPoolExtendedAuditingPolicyArgs.__new__(SqlPoolExtendedAuditingPolicyArgs)

            __props__.__dict__["log_monitoring_enabled"] = log_monitoring_enabled
            __props__.__dict__["retention_in_days"] = retention_in_days
            if sql_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'sql_pool_id'")
            __props__.__dict__["sql_pool_id"] = sql_pool_id
            __props__.__dict__["storage_account_access_key"] = None if storage_account_access_key is None else pulumi.Output.secret(storage_account_access_key)
            __props__.__dict__["storage_account_access_key_is_secondary"] = storage_account_access_key_is_secondary
            __props__.__dict__["storage_endpoint"] = storage_endpoint
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["storageAccountAccessKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SqlPoolExtendedAuditingPolicy, __self__).__init__(
            'azure:synapse/sqlPoolExtendedAuditingPolicy:SqlPoolExtendedAuditingPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            log_monitoring_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            retention_in_days: Optional[pulumi.Input[builtins.int]] = None,
            sql_pool_id: Optional[pulumi.Input[builtins.str]] = None,
            storage_account_access_key: Optional[pulumi.Input[builtins.str]] = None,
            storage_account_access_key_is_secondary: Optional[pulumi.Input[builtins.bool]] = None,
            storage_endpoint: Optional[pulumi.Input[builtins.str]] = None) -> 'SqlPoolExtendedAuditingPolicy':
        """
        Get an existing SqlPoolExtendedAuditingPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] log_monitoring_enabled: Enable audit events to Azure Monitor? To enable server audit events to Azure Monitor, please enable its master database audit events to Azure Monitor. Defaults to `true`.
        :param pulumi.Input[builtins.int] retention_in_days: The number of days to retain logs for in the storage account. Defaults to `0`.
        :param pulumi.Input[builtins.str] sql_pool_id: The ID of the Synapse SQL pool to set the extended auditing policy. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] storage_account_access_key: The access key to use for the auditing storage account.
        :param pulumi.Input[builtins.bool] storage_account_access_key_is_secondary: Is `storage_account_access_key` value the storage's secondary key?
        :param pulumi.Input[builtins.str] storage_endpoint: The blob storage endpoint (e.g. <https://example.blob.core.windows.net>). This blob storage will hold all extended auditing logs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SqlPoolExtendedAuditingPolicyState.__new__(_SqlPoolExtendedAuditingPolicyState)

        __props__.__dict__["log_monitoring_enabled"] = log_monitoring_enabled
        __props__.__dict__["retention_in_days"] = retention_in_days
        __props__.__dict__["sql_pool_id"] = sql_pool_id
        __props__.__dict__["storage_account_access_key"] = storage_account_access_key
        __props__.__dict__["storage_account_access_key_is_secondary"] = storage_account_access_key_is_secondary
        __props__.__dict__["storage_endpoint"] = storage_endpoint
        return SqlPoolExtendedAuditingPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="logMonitoringEnabled")
    def log_monitoring_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable audit events to Azure Monitor? To enable server audit events to Azure Monitor, please enable its master database audit events to Azure Monitor. Defaults to `true`.
        """
        return pulumi.get(self, "log_monitoring_enabled")

    @property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of days to retain logs for in the storage account. Defaults to `0`.
        """
        return pulumi.get(self, "retention_in_days")

    @property
    @pulumi.getter(name="sqlPoolId")
    def sql_pool_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Synapse SQL pool to set the extended auditing policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sql_pool_id")

    @property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The access key to use for the auditing storage account.
        """
        return pulumi.get(self, "storage_account_access_key")

    @property
    @pulumi.getter(name="storageAccountAccessKeyIsSecondary")
    def storage_account_access_key_is_secondary(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is `storage_account_access_key` value the storage's secondary key?
        """
        return pulumi.get(self, "storage_account_access_key_is_secondary")

    @property
    @pulumi.getter(name="storageEndpoint")
    def storage_endpoint(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The blob storage endpoint (e.g. <https://example.blob.core.windows.net>). This blob storage will hold all extended auditing logs.
        """
        return pulumi.get(self, "storage_endpoint")

