# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SqlPoolVulnerabilityAssessmentBaselineArgs', 'SqlPoolVulnerabilityAssessmentBaseline']

@pulumi.input_type
class SqlPoolVulnerabilityAssessmentBaselineArgs:
    def __init__(__self__, *,
                 rule_name: pulumi.Input[builtins.str],
                 sql_pool_vulnerability_assessment_id: pulumi.Input[builtins.str],
                 baselines: Optional[pulumi.Input[Sequence[pulumi.Input['SqlPoolVulnerabilityAssessmentBaselineBaselineArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a SqlPoolVulnerabilityAssessmentBaseline resource.
        :param pulumi.Input[builtins.str] rule_name: The ID of the vulnerability assessment rule.
        :param pulumi.Input[builtins.str] sql_pool_vulnerability_assessment_id: The ID of the Synapse SQL Pool Vulnerability Assessment. Changing this forces a new Synapse SQL Pool Vulnerability Assessment Rule Baseline to be created.
        :param pulumi.Input[Sequence[pulumi.Input['SqlPoolVulnerabilityAssessmentBaselineBaselineArgs']]] baselines: One or more `baseline` blocks as defined below.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Synapse SQL Pool Vulnerability Assessment Rule Baseline.
        """
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "sql_pool_vulnerability_assessment_id", sql_pool_vulnerability_assessment_id)
        if baselines is not None:
            pulumi.set(__self__, "baselines", baselines)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the vulnerability assessment rule.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "rule_name", value)

    @property
    @pulumi.getter(name="sqlPoolVulnerabilityAssessmentId")
    def sql_pool_vulnerability_assessment_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Synapse SQL Pool Vulnerability Assessment. Changing this forces a new Synapse SQL Pool Vulnerability Assessment Rule Baseline to be created.
        """
        return pulumi.get(self, "sql_pool_vulnerability_assessment_id")

    @sql_pool_vulnerability_assessment_id.setter
    def sql_pool_vulnerability_assessment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "sql_pool_vulnerability_assessment_id", value)

    @property
    @pulumi.getter
    def baselines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SqlPoolVulnerabilityAssessmentBaselineBaselineArgs']]]]:
        """
        One or more `baseline` blocks as defined below.
        """
        return pulumi.get(self, "baselines")

    @baselines.setter
    def baselines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SqlPoolVulnerabilityAssessmentBaselineBaselineArgs']]]]):
        pulumi.set(self, "baselines", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Synapse SQL Pool Vulnerability Assessment Rule Baseline.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _SqlPoolVulnerabilityAssessmentBaselineState:
    def __init__(__self__, *,
                 baselines: Optional[pulumi.Input[Sequence[pulumi.Input['SqlPoolVulnerabilityAssessmentBaselineBaselineArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[builtins.str]] = None,
                 sql_pool_vulnerability_assessment_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SqlPoolVulnerabilityAssessmentBaseline resources.
        :param pulumi.Input[Sequence[pulumi.Input['SqlPoolVulnerabilityAssessmentBaselineBaselineArgs']]] baselines: One or more `baseline` blocks as defined below.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Synapse SQL Pool Vulnerability Assessment Rule Baseline.
        :param pulumi.Input[builtins.str] rule_name: The ID of the vulnerability assessment rule.
        :param pulumi.Input[builtins.str] sql_pool_vulnerability_assessment_id: The ID of the Synapse SQL Pool Vulnerability Assessment. Changing this forces a new Synapse SQL Pool Vulnerability Assessment Rule Baseline to be created.
        """
        if baselines is not None:
            pulumi.set(__self__, "baselines", baselines)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if sql_pool_vulnerability_assessment_id is not None:
            pulumi.set(__self__, "sql_pool_vulnerability_assessment_id", sql_pool_vulnerability_assessment_id)

    @property
    @pulumi.getter
    def baselines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SqlPoolVulnerabilityAssessmentBaselineBaselineArgs']]]]:
        """
        One or more `baseline` blocks as defined below.
        """
        return pulumi.get(self, "baselines")

    @baselines.setter
    def baselines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SqlPoolVulnerabilityAssessmentBaselineBaselineArgs']]]]):
        pulumi.set(self, "baselines", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Synapse SQL Pool Vulnerability Assessment Rule Baseline.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the vulnerability assessment rule.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @property
    @pulumi.getter(name="sqlPoolVulnerabilityAssessmentId")
    def sql_pool_vulnerability_assessment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Synapse SQL Pool Vulnerability Assessment. Changing this forces a new Synapse SQL Pool Vulnerability Assessment Rule Baseline to be created.
        """
        return pulumi.get(self, "sql_pool_vulnerability_assessment_id")

    @sql_pool_vulnerability_assessment_id.setter
    def sql_pool_vulnerability_assessment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sql_pool_vulnerability_assessment_id", value)


@pulumi.type_token("azure:synapse/sqlPoolVulnerabilityAssessmentBaseline:SqlPoolVulnerabilityAssessmentBaseline")
class SqlPoolVulnerabilityAssessmentBaseline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 baselines: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SqlPoolVulnerabilityAssessmentBaselineBaselineArgs', 'SqlPoolVulnerabilityAssessmentBaselineBaselineArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[builtins.str]] = None,
                 sql_pool_vulnerability_assessment_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Synapse SQL Pool Vulnerability Assessment Rule Baseline.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="west europe")
        example_account = azure.storage.Account("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            account_kind="BlobStorage",
            account_tier="Standard",
            account_replication_type="LRS")
        example_data_lake_gen2_filesystem = azure.storage.DataLakeGen2Filesystem("example",
            name="example",
            storage_account_id=example_account.id)
        example_workspace = azure.synapse.Workspace("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            storage_data_lake_gen2_filesystem_id=example_data_lake_gen2_filesystem.id,
            sql_administrator_login="sqladminuser",
            sql_administrator_login_password="H@Sh1CoR3!",
            identity={
                "type": "SystemAssigned",
            })
        example_sql_pool = azure.synapse.SqlPool("example",
            name="example",
            synapse_workspace_id=example_workspace.id,
            sku_name="DW100c",
            create_mode="Default")
        example_container = azure.storage.Container("example",
            name="example",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_sql_pool_security_alert_policy = azure.synapse.SqlPoolSecurityAlertPolicy("example",
            sql_pool_id=example_sql_pool.id,
            policy_state="Enabled",
            storage_endpoint=example_account.primary_blob_endpoint,
            storage_account_access_key=example_account.primary_access_key)
        example_sql_pool_vulnerability_assessment = azure.synapse.SqlPoolVulnerabilityAssessment("example",
            sql_pool_security_alert_policy_id=example_sql_pool_security_alert_policy.id,
            storage_container_path=pulumi.Output.all(
                primary_blob_endpoint=example_account.primary_blob_endpoint,
                name=example_container.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['primary_blob_endpoint']}{resolved_outputs['name']}/")
        ,
            storage_account_access_key=example_account.primary_access_key)
        example_sql_pool_vulnerability_assessment_baseline = azure.synapse.SqlPoolVulnerabilityAssessmentBaseline("example",
            name="default",
            rule_name="VA1017",
            sql_pool_vulnerability_assessment_id=example_sql_pool_vulnerability_assessment.id,
            baselines=[
                {
                    "results": [
                        "userA",
                        "SELECT",
                    ],
                },
                {
                    "results": [
                        "userB",
                        "SELECT",
                    ],
                },
            ])
        ```

        ## Import

        Synapse SQL Pool Vulnerability Assessment Rule Baselines can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:synapse/sqlPoolVulnerabilityAssessmentBaseline:SqlPoolVulnerabilityAssessmentBaseline example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.Synapse/workspaces/workspace1/sqlPools/sqlPool1/vulnerabilityAssessments/default/rules/rule1/baselines/baseline1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SqlPoolVulnerabilityAssessmentBaselineBaselineArgs', 'SqlPoolVulnerabilityAssessmentBaselineBaselineArgsDict']]]] baselines: One or more `baseline` blocks as defined below.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Synapse SQL Pool Vulnerability Assessment Rule Baseline.
        :param pulumi.Input[builtins.str] rule_name: The ID of the vulnerability assessment rule.
        :param pulumi.Input[builtins.str] sql_pool_vulnerability_assessment_id: The ID of the Synapse SQL Pool Vulnerability Assessment. Changing this forces a new Synapse SQL Pool Vulnerability Assessment Rule Baseline to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SqlPoolVulnerabilityAssessmentBaselineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Synapse SQL Pool Vulnerability Assessment Rule Baseline.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="west europe")
        example_account = azure.storage.Account("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            account_kind="BlobStorage",
            account_tier="Standard",
            account_replication_type="LRS")
        example_data_lake_gen2_filesystem = azure.storage.DataLakeGen2Filesystem("example",
            name="example",
            storage_account_id=example_account.id)
        example_workspace = azure.synapse.Workspace("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            storage_data_lake_gen2_filesystem_id=example_data_lake_gen2_filesystem.id,
            sql_administrator_login="sqladminuser",
            sql_administrator_login_password="H@Sh1CoR3!",
            identity={
                "type": "SystemAssigned",
            })
        example_sql_pool = azure.synapse.SqlPool("example",
            name="example",
            synapse_workspace_id=example_workspace.id,
            sku_name="DW100c",
            create_mode="Default")
        example_container = azure.storage.Container("example",
            name="example",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_sql_pool_security_alert_policy = azure.synapse.SqlPoolSecurityAlertPolicy("example",
            sql_pool_id=example_sql_pool.id,
            policy_state="Enabled",
            storage_endpoint=example_account.primary_blob_endpoint,
            storage_account_access_key=example_account.primary_access_key)
        example_sql_pool_vulnerability_assessment = azure.synapse.SqlPoolVulnerabilityAssessment("example",
            sql_pool_security_alert_policy_id=example_sql_pool_security_alert_policy.id,
            storage_container_path=pulumi.Output.all(
                primary_blob_endpoint=example_account.primary_blob_endpoint,
                name=example_container.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['primary_blob_endpoint']}{resolved_outputs['name']}/")
        ,
            storage_account_access_key=example_account.primary_access_key)
        example_sql_pool_vulnerability_assessment_baseline = azure.synapse.SqlPoolVulnerabilityAssessmentBaseline("example",
            name="default",
            rule_name="VA1017",
            sql_pool_vulnerability_assessment_id=example_sql_pool_vulnerability_assessment.id,
            baselines=[
                {
                    "results": [
                        "userA",
                        "SELECT",
                    ],
                },
                {
                    "results": [
                        "userB",
                        "SELECT",
                    ],
                },
            ])
        ```

        ## Import

        Synapse SQL Pool Vulnerability Assessment Rule Baselines can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:synapse/sqlPoolVulnerabilityAssessmentBaseline:SqlPoolVulnerabilityAssessmentBaseline example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.Synapse/workspaces/workspace1/sqlPools/sqlPool1/vulnerabilityAssessments/default/rules/rule1/baselines/baseline1
        ```

        :param str resource_name: The name of the resource.
        :param SqlPoolVulnerabilityAssessmentBaselineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SqlPoolVulnerabilityAssessmentBaselineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 baselines: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SqlPoolVulnerabilityAssessmentBaselineBaselineArgs', 'SqlPoolVulnerabilityAssessmentBaselineBaselineArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[builtins.str]] = None,
                 sql_pool_vulnerability_assessment_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SqlPoolVulnerabilityAssessmentBaselineArgs.__new__(SqlPoolVulnerabilityAssessmentBaselineArgs)

            __props__.__dict__["baselines"] = baselines
            __props__.__dict__["name"] = name
            if rule_name is None and not opts.urn:
                raise TypeError("Missing required property 'rule_name'")
            __props__.__dict__["rule_name"] = rule_name
            if sql_pool_vulnerability_assessment_id is None and not opts.urn:
                raise TypeError("Missing required property 'sql_pool_vulnerability_assessment_id'")
            __props__.__dict__["sql_pool_vulnerability_assessment_id"] = sql_pool_vulnerability_assessment_id
        super(SqlPoolVulnerabilityAssessmentBaseline, __self__).__init__(
            'azure:synapse/sqlPoolVulnerabilityAssessmentBaseline:SqlPoolVulnerabilityAssessmentBaseline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            baselines: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SqlPoolVulnerabilityAssessmentBaselineBaselineArgs', 'SqlPoolVulnerabilityAssessmentBaselineBaselineArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            rule_name: Optional[pulumi.Input[builtins.str]] = None,
            sql_pool_vulnerability_assessment_id: Optional[pulumi.Input[builtins.str]] = None) -> 'SqlPoolVulnerabilityAssessmentBaseline':
        """
        Get an existing SqlPoolVulnerabilityAssessmentBaseline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SqlPoolVulnerabilityAssessmentBaselineBaselineArgs', 'SqlPoolVulnerabilityAssessmentBaselineBaselineArgsDict']]]] baselines: One or more `baseline` blocks as defined below.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Synapse SQL Pool Vulnerability Assessment Rule Baseline.
        :param pulumi.Input[builtins.str] rule_name: The ID of the vulnerability assessment rule.
        :param pulumi.Input[builtins.str] sql_pool_vulnerability_assessment_id: The ID of the Synapse SQL Pool Vulnerability Assessment. Changing this forces a new Synapse SQL Pool Vulnerability Assessment Rule Baseline to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SqlPoolVulnerabilityAssessmentBaselineState.__new__(_SqlPoolVulnerabilityAssessmentBaselineState)

        __props__.__dict__["baselines"] = baselines
        __props__.__dict__["name"] = name
        __props__.__dict__["rule_name"] = rule_name
        __props__.__dict__["sql_pool_vulnerability_assessment_id"] = sql_pool_vulnerability_assessment_id
        return SqlPoolVulnerabilityAssessmentBaseline(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def baselines(self) -> pulumi.Output[Optional[Sequence['outputs.SqlPoolVulnerabilityAssessmentBaselineBaseline']]]:
        """
        One or more `baseline` blocks as defined below.
        """
        return pulumi.get(self, "baselines")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Synapse SQL Pool Vulnerability Assessment Rule Baseline.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the vulnerability assessment rule.
        """
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter(name="sqlPoolVulnerabilityAssessmentId")
    def sql_pool_vulnerability_assessment_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Synapse SQL Pool Vulnerability Assessment. Changing this forces a new Synapse SQL Pool Vulnerability Assessment Rule Baseline to be created.
        """
        return pulumi.get(self, "sql_pool_vulnerability_assessment_id")

