# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkspaceArgs', 'Workspace']

@pulumi.input_type
class WorkspaceArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[builtins.str],
                 storage_data_lake_gen2_filesystem_id: pulumi.Input[builtins.str],
                 azure_devops_repo: Optional[pulumi.Input['WorkspaceAzureDevopsRepoArgs']] = None,
                 azuread_authentication_only: Optional[pulumi.Input[builtins.bool]] = None,
                 compute_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input['WorkspaceCustomerManagedKeyArgs']] = None,
                 data_exfiltration_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 github_repo: Optional[pulumi.Input['WorkspaceGithubRepoArgs']] = None,
                 identity: Optional[pulumi.Input['WorkspaceIdentityArgs']] = None,
                 linking_allowed_for_aad_tenant_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 managed_resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 managed_virtual_network_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 purview_id: Optional[pulumi.Input[builtins.str]] = None,
                 sql_administrator_login: Optional[pulumi.Input[builtins.str]] = None,
                 sql_administrator_login_password: Optional[pulumi.Input[builtins.str]] = None,
                 sql_identity_control_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Workspace resource.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group where the synapse Workspace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] storage_data_lake_gen2_filesystem_id: Specifies the ID of storage data lake gen2 filesystem resource. Changing this forces a new resource to be created.
        :param pulumi.Input['WorkspaceAzureDevopsRepoArgs'] azure_devops_repo: An `azure_devops_repo` block as defined below.
        :param pulumi.Input[builtins.bool] azuread_authentication_only: Is Azure Active Directory Authentication the only way to authenticate with resources inside this synapse Workspace. Defaults to `false`.
        :param pulumi.Input[builtins.str] compute_subnet_id: Subnet ID used for computes in workspace Changing this forces a new resource to be created.
        :param pulumi.Input['WorkspaceCustomerManagedKeyArgs'] customer_managed_key: A `customer_managed_key` block as defined below.
        :param pulumi.Input[builtins.bool] data_exfiltration_protection_enabled: Is data exfiltration protection enabled in this workspace? If set to `true`, `managed_virtual_network_enabled` must also be set to `true`. Changing this forces a new resource to be created.
        :param pulumi.Input['WorkspaceGithubRepoArgs'] github_repo: A `github_repo` block as defined below.
        :param pulumi.Input['WorkspaceIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] linking_allowed_for_aad_tenant_ids: Allowed AAD Tenant Ids For Linking.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the synapse Workspace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] managed_resource_group_name: Workspace managed resource group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] managed_virtual_network_enabled: Is Virtual Network enabled for all computes in this workspace? Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this synapse Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Whether public network access is allowed for the Cognitive Account. Defaults to `true`.
        :param pulumi.Input[builtins.str] purview_id: The ID of purview account.
        :param pulumi.Input[builtins.str] sql_administrator_login: Specifies The login name of the SQL administrator. Changing this forces a new resource to be created. If this is not provided `customer_managed_key` must be provided.
        :param pulumi.Input[builtins.str] sql_administrator_login_password: The Password associated with the `sql_administrator_login` for the SQL administrator. If this is not provided `customer_managed_key` must be provided.
        :param pulumi.Input[builtins.bool] sql_identity_control_enabled: Are pipelines (running as workspace's system assigned identity) allowed to access SQL pools?
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Synapse Workspace.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "storage_data_lake_gen2_filesystem_id", storage_data_lake_gen2_filesystem_id)
        if azure_devops_repo is not None:
            pulumi.set(__self__, "azure_devops_repo", azure_devops_repo)
        if azuread_authentication_only is not None:
            pulumi.set(__self__, "azuread_authentication_only", azuread_authentication_only)
        if compute_subnet_id is not None:
            pulumi.set(__self__, "compute_subnet_id", compute_subnet_id)
        if customer_managed_key is not None:
            pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if data_exfiltration_protection_enabled is not None:
            pulumi.set(__self__, "data_exfiltration_protection_enabled", data_exfiltration_protection_enabled)
        if github_repo is not None:
            pulumi.set(__self__, "github_repo", github_repo)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if linking_allowed_for_aad_tenant_ids is not None:
            pulumi.set(__self__, "linking_allowed_for_aad_tenant_ids", linking_allowed_for_aad_tenant_ids)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_resource_group_name is not None:
            pulumi.set(__self__, "managed_resource_group_name", managed_resource_group_name)
        if managed_virtual_network_enabled is not None:
            pulumi.set(__self__, "managed_virtual_network_enabled", managed_virtual_network_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if purview_id is not None:
            pulumi.set(__self__, "purview_id", purview_id)
        if sql_administrator_login is not None:
            pulumi.set(__self__, "sql_administrator_login", sql_administrator_login)
        if sql_administrator_login_password is not None:
            pulumi.set(__self__, "sql_administrator_login_password", sql_administrator_login_password)
        if sql_identity_control_enabled is not None:
            pulumi.set(__self__, "sql_identity_control_enabled", sql_identity_control_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the name of the Resource Group where the synapse Workspace should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="storageDataLakeGen2FilesystemId")
    def storage_data_lake_gen2_filesystem_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the ID of storage data lake gen2 filesystem resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_data_lake_gen2_filesystem_id")

    @storage_data_lake_gen2_filesystem_id.setter
    def storage_data_lake_gen2_filesystem_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "storage_data_lake_gen2_filesystem_id", value)

    @property
    @pulumi.getter(name="azureDevopsRepo")
    def azure_devops_repo(self) -> Optional[pulumi.Input['WorkspaceAzureDevopsRepoArgs']]:
        """
        An `azure_devops_repo` block as defined below.
        """
        return pulumi.get(self, "azure_devops_repo")

    @azure_devops_repo.setter
    def azure_devops_repo(self, value: Optional[pulumi.Input['WorkspaceAzureDevopsRepoArgs']]):
        pulumi.set(self, "azure_devops_repo", value)

    @property
    @pulumi.getter(name="azureadAuthenticationOnly")
    def azuread_authentication_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is Azure Active Directory Authentication the only way to authenticate with resources inside this synapse Workspace. Defaults to `false`.
        """
        return pulumi.get(self, "azuread_authentication_only")

    @azuread_authentication_only.setter
    def azuread_authentication_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "azuread_authentication_only", value)

    @property
    @pulumi.getter(name="computeSubnetId")
    def compute_subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Subnet ID used for computes in workspace Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "compute_subnet_id")

    @compute_subnet_id.setter
    def compute_subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compute_subnet_id", value)

    @property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> Optional[pulumi.Input['WorkspaceCustomerManagedKeyArgs']]:
        """
        A `customer_managed_key` block as defined below.
        """
        return pulumi.get(self, "customer_managed_key")

    @customer_managed_key.setter
    def customer_managed_key(self, value: Optional[pulumi.Input['WorkspaceCustomerManagedKeyArgs']]):
        pulumi.set(self, "customer_managed_key", value)

    @property
    @pulumi.getter(name="dataExfiltrationProtectionEnabled")
    def data_exfiltration_protection_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is data exfiltration protection enabled in this workspace? If set to `true`, `managed_virtual_network_enabled` must also be set to `true`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_exfiltration_protection_enabled")

    @data_exfiltration_protection_enabled.setter
    def data_exfiltration_protection_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "data_exfiltration_protection_enabled", value)

    @property
    @pulumi.getter(name="githubRepo")
    def github_repo(self) -> Optional[pulumi.Input['WorkspaceGithubRepoArgs']]:
        """
        A `github_repo` block as defined below.
        """
        return pulumi.get(self, "github_repo")

    @github_repo.setter
    def github_repo(self, value: Optional[pulumi.Input['WorkspaceGithubRepoArgs']]):
        pulumi.set(self, "github_repo", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['WorkspaceIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['WorkspaceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="linkingAllowedForAadTenantIds")
    def linking_allowed_for_aad_tenant_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Allowed AAD Tenant Ids For Linking.
        """
        return pulumi.get(self, "linking_allowed_for_aad_tenant_ids")

    @linking_allowed_for_aad_tenant_ids.setter
    def linking_allowed_for_aad_tenant_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "linking_allowed_for_aad_tenant_ids", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Azure Region where the synapse Workspace should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="managedResourceGroupName")
    def managed_resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Workspace managed resource group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_resource_group_name")

    @managed_resource_group_name.setter
    def managed_resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "managed_resource_group_name", value)

    @property
    @pulumi.getter(name="managedVirtualNetworkEnabled")
    def managed_virtual_network_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is Virtual Network enabled for all computes in this workspace? Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_virtual_network_enabled")

    @managed_virtual_network_enabled.setter
    def managed_virtual_network_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "managed_virtual_network_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name which should be used for this synapse Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether public network access is allowed for the Cognitive Account. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter(name="purviewId")
    def purview_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of purview account.
        """
        return pulumi.get(self, "purview_id")

    @purview_id.setter
    def purview_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "purview_id", value)

    @property
    @pulumi.getter(name="sqlAdministratorLogin")
    def sql_administrator_login(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies The login name of the SQL administrator. Changing this forces a new resource to be created. If this is not provided `customer_managed_key` must be provided.
        """
        return pulumi.get(self, "sql_administrator_login")

    @sql_administrator_login.setter
    def sql_administrator_login(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sql_administrator_login", value)

    @property
    @pulumi.getter(name="sqlAdministratorLoginPassword")
    def sql_administrator_login_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Password associated with the `sql_administrator_login` for the SQL administrator. If this is not provided `customer_managed_key` must be provided.
        """
        return pulumi.get(self, "sql_administrator_login_password")

    @sql_administrator_login_password.setter
    def sql_administrator_login_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sql_administrator_login_password", value)

    @property
    @pulumi.getter(name="sqlIdentityControlEnabled")
    def sql_identity_control_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Are pipelines (running as workspace's system assigned identity) allowed to access SQL pools?
        """
        return pulumi.get(self, "sql_identity_control_enabled")

    @sql_identity_control_enabled.setter
    def sql_identity_control_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "sql_identity_control_enabled", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Synapse Workspace.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _WorkspaceState:
    def __init__(__self__, *,
                 azure_devops_repo: Optional[pulumi.Input['WorkspaceAzureDevopsRepoArgs']] = None,
                 azuread_authentication_only: Optional[pulumi.Input[builtins.bool]] = None,
                 compute_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 connectivity_endpoints: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 customer_managed_key: Optional[pulumi.Input['WorkspaceCustomerManagedKeyArgs']] = None,
                 data_exfiltration_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 github_repo: Optional[pulumi.Input['WorkspaceGithubRepoArgs']] = None,
                 identity: Optional[pulumi.Input['WorkspaceIdentityArgs']] = None,
                 linking_allowed_for_aad_tenant_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 managed_resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 managed_virtual_network_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 purview_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 sql_administrator_login: Optional[pulumi.Input[builtins.str]] = None,
                 sql_administrator_login_password: Optional[pulumi.Input[builtins.str]] = None,
                 sql_identity_control_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 storage_data_lake_gen2_filesystem_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Workspace resources.
        :param pulumi.Input['WorkspaceAzureDevopsRepoArgs'] azure_devops_repo: An `azure_devops_repo` block as defined below.
        :param pulumi.Input[builtins.bool] azuread_authentication_only: Is Azure Active Directory Authentication the only way to authenticate with resources inside this synapse Workspace. Defaults to `false`.
        :param pulumi.Input[builtins.str] compute_subnet_id: Subnet ID used for computes in workspace Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] connectivity_endpoints: A map of Connectivity endpoints for this Synapse Workspace. Possible key values are `dev`, `sql`, `sqlOnDemand`, and `web`.
        :param pulumi.Input['WorkspaceCustomerManagedKeyArgs'] customer_managed_key: A `customer_managed_key` block as defined below.
        :param pulumi.Input[builtins.bool] data_exfiltration_protection_enabled: Is data exfiltration protection enabled in this workspace? If set to `true`, `managed_virtual_network_enabled` must also be set to `true`. Changing this forces a new resource to be created.
        :param pulumi.Input['WorkspaceGithubRepoArgs'] github_repo: A `github_repo` block as defined below.
        :param pulumi.Input['WorkspaceIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] linking_allowed_for_aad_tenant_ids: Allowed AAD Tenant Ids For Linking.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the synapse Workspace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] managed_resource_group_name: Workspace managed resource group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] managed_virtual_network_enabled: Is Virtual Network enabled for all computes in this workspace? Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this synapse Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Whether public network access is allowed for the Cognitive Account. Defaults to `true`.
        :param pulumi.Input[builtins.str] purview_id: The ID of purview account.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group where the synapse Workspace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sql_administrator_login: Specifies The login name of the SQL administrator. Changing this forces a new resource to be created. If this is not provided `customer_managed_key` must be provided.
        :param pulumi.Input[builtins.str] sql_administrator_login_password: The Password associated with the `sql_administrator_login` for the SQL administrator. If this is not provided `customer_managed_key` must be provided.
        :param pulumi.Input[builtins.bool] sql_identity_control_enabled: Are pipelines (running as workspace's system assigned identity) allowed to access SQL pools?
        :param pulumi.Input[builtins.str] storage_data_lake_gen2_filesystem_id: Specifies the ID of storage data lake gen2 filesystem resource. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Synapse Workspace.
        """
        if azure_devops_repo is not None:
            pulumi.set(__self__, "azure_devops_repo", azure_devops_repo)
        if azuread_authentication_only is not None:
            pulumi.set(__self__, "azuread_authentication_only", azuread_authentication_only)
        if compute_subnet_id is not None:
            pulumi.set(__self__, "compute_subnet_id", compute_subnet_id)
        if connectivity_endpoints is not None:
            pulumi.set(__self__, "connectivity_endpoints", connectivity_endpoints)
        if customer_managed_key is not None:
            pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if data_exfiltration_protection_enabled is not None:
            pulumi.set(__self__, "data_exfiltration_protection_enabled", data_exfiltration_protection_enabled)
        if github_repo is not None:
            pulumi.set(__self__, "github_repo", github_repo)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if linking_allowed_for_aad_tenant_ids is not None:
            pulumi.set(__self__, "linking_allowed_for_aad_tenant_ids", linking_allowed_for_aad_tenant_ids)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_resource_group_name is not None:
            pulumi.set(__self__, "managed_resource_group_name", managed_resource_group_name)
        if managed_virtual_network_enabled is not None:
            pulumi.set(__self__, "managed_virtual_network_enabled", managed_virtual_network_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if purview_id is not None:
            pulumi.set(__self__, "purview_id", purview_id)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sql_administrator_login is not None:
            pulumi.set(__self__, "sql_administrator_login", sql_administrator_login)
        if sql_administrator_login_password is not None:
            pulumi.set(__self__, "sql_administrator_login_password", sql_administrator_login_password)
        if sql_identity_control_enabled is not None:
            pulumi.set(__self__, "sql_identity_control_enabled", sql_identity_control_enabled)
        if storage_data_lake_gen2_filesystem_id is not None:
            pulumi.set(__self__, "storage_data_lake_gen2_filesystem_id", storage_data_lake_gen2_filesystem_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="azureDevopsRepo")
    def azure_devops_repo(self) -> Optional[pulumi.Input['WorkspaceAzureDevopsRepoArgs']]:
        """
        An `azure_devops_repo` block as defined below.
        """
        return pulumi.get(self, "azure_devops_repo")

    @azure_devops_repo.setter
    def azure_devops_repo(self, value: Optional[pulumi.Input['WorkspaceAzureDevopsRepoArgs']]):
        pulumi.set(self, "azure_devops_repo", value)

    @property
    @pulumi.getter(name="azureadAuthenticationOnly")
    def azuread_authentication_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is Azure Active Directory Authentication the only way to authenticate with resources inside this synapse Workspace. Defaults to `false`.
        """
        return pulumi.get(self, "azuread_authentication_only")

    @azuread_authentication_only.setter
    def azuread_authentication_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "azuread_authentication_only", value)

    @property
    @pulumi.getter(name="computeSubnetId")
    def compute_subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Subnet ID used for computes in workspace Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "compute_subnet_id")

    @compute_subnet_id.setter
    def compute_subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compute_subnet_id", value)

    @property
    @pulumi.getter(name="connectivityEndpoints")
    def connectivity_endpoints(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of Connectivity endpoints for this Synapse Workspace. Possible key values are `dev`, `sql`, `sqlOnDemand`, and `web`.
        """
        return pulumi.get(self, "connectivity_endpoints")

    @connectivity_endpoints.setter
    def connectivity_endpoints(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "connectivity_endpoints", value)

    @property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> Optional[pulumi.Input['WorkspaceCustomerManagedKeyArgs']]:
        """
        A `customer_managed_key` block as defined below.
        """
        return pulumi.get(self, "customer_managed_key")

    @customer_managed_key.setter
    def customer_managed_key(self, value: Optional[pulumi.Input['WorkspaceCustomerManagedKeyArgs']]):
        pulumi.set(self, "customer_managed_key", value)

    @property
    @pulumi.getter(name="dataExfiltrationProtectionEnabled")
    def data_exfiltration_protection_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is data exfiltration protection enabled in this workspace? If set to `true`, `managed_virtual_network_enabled` must also be set to `true`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_exfiltration_protection_enabled")

    @data_exfiltration_protection_enabled.setter
    def data_exfiltration_protection_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "data_exfiltration_protection_enabled", value)

    @property
    @pulumi.getter(name="githubRepo")
    def github_repo(self) -> Optional[pulumi.Input['WorkspaceGithubRepoArgs']]:
        """
        A `github_repo` block as defined below.
        """
        return pulumi.get(self, "github_repo")

    @github_repo.setter
    def github_repo(self, value: Optional[pulumi.Input['WorkspaceGithubRepoArgs']]):
        pulumi.set(self, "github_repo", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['WorkspaceIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['WorkspaceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="linkingAllowedForAadTenantIds")
    def linking_allowed_for_aad_tenant_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Allowed AAD Tenant Ids For Linking.
        """
        return pulumi.get(self, "linking_allowed_for_aad_tenant_ids")

    @linking_allowed_for_aad_tenant_ids.setter
    def linking_allowed_for_aad_tenant_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "linking_allowed_for_aad_tenant_ids", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Azure Region where the synapse Workspace should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="managedResourceGroupName")
    def managed_resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Workspace managed resource group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_resource_group_name")

    @managed_resource_group_name.setter
    def managed_resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "managed_resource_group_name", value)

    @property
    @pulumi.getter(name="managedVirtualNetworkEnabled")
    def managed_virtual_network_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is Virtual Network enabled for all computes in this workspace? Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_virtual_network_enabled")

    @managed_virtual_network_enabled.setter
    def managed_virtual_network_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "managed_virtual_network_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name which should be used for this synapse Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether public network access is allowed for the Cognitive Account. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter(name="purviewId")
    def purview_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of purview account.
        """
        return pulumi.get(self, "purview_id")

    @purview_id.setter
    def purview_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "purview_id", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Resource Group where the synapse Workspace should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="sqlAdministratorLogin")
    def sql_administrator_login(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies The login name of the SQL administrator. Changing this forces a new resource to be created. If this is not provided `customer_managed_key` must be provided.
        """
        return pulumi.get(self, "sql_administrator_login")

    @sql_administrator_login.setter
    def sql_administrator_login(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sql_administrator_login", value)

    @property
    @pulumi.getter(name="sqlAdministratorLoginPassword")
    def sql_administrator_login_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Password associated with the `sql_administrator_login` for the SQL administrator. If this is not provided `customer_managed_key` must be provided.
        """
        return pulumi.get(self, "sql_administrator_login_password")

    @sql_administrator_login_password.setter
    def sql_administrator_login_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sql_administrator_login_password", value)

    @property
    @pulumi.getter(name="sqlIdentityControlEnabled")
    def sql_identity_control_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Are pipelines (running as workspace's system assigned identity) allowed to access SQL pools?
        """
        return pulumi.get(self, "sql_identity_control_enabled")

    @sql_identity_control_enabled.setter
    def sql_identity_control_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "sql_identity_control_enabled", value)

    @property
    @pulumi.getter(name="storageDataLakeGen2FilesystemId")
    def storage_data_lake_gen2_filesystem_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the ID of storage data lake gen2 filesystem resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_data_lake_gen2_filesystem_id")

    @storage_data_lake_gen2_filesystem_id.setter
    def storage_data_lake_gen2_filesystem_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_data_lake_gen2_filesystem_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Synapse Workspace.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:synapse/workspace:Workspace")
class Workspace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 azure_devops_repo: Optional[pulumi.Input[Union['WorkspaceAzureDevopsRepoArgs', 'WorkspaceAzureDevopsRepoArgsDict']]] = None,
                 azuread_authentication_only: Optional[pulumi.Input[builtins.bool]] = None,
                 compute_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input[Union['WorkspaceCustomerManagedKeyArgs', 'WorkspaceCustomerManagedKeyArgsDict']]] = None,
                 data_exfiltration_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 github_repo: Optional[pulumi.Input[Union['WorkspaceGithubRepoArgs', 'WorkspaceGithubRepoArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['WorkspaceIdentityArgs', 'WorkspaceIdentityArgsDict']]] = None,
                 linking_allowed_for_aad_tenant_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 managed_resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 managed_virtual_network_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 purview_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 sql_administrator_login: Optional[pulumi.Input[builtins.str]] = None,
                 sql_administrator_login_password: Optional[pulumi.Input[builtins.str]] = None,
                 sql_identity_control_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 storage_data_lake_gen2_filesystem_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Synapse Workspace.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestorageacc",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS",
            account_kind="StorageV2",
            is_hns_enabled=True)
        example_data_lake_gen2_filesystem = azure.storage.DataLakeGen2Filesystem("example",
            name="example",
            storage_account_id=example_account.id)
        example_workspace = azure.synapse.Workspace("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            storage_data_lake_gen2_filesystem_id=example_data_lake_gen2_filesystem.id,
            sql_administrator_login="sqladminuser",
            sql_administrator_login_password="H@Sh1CoR3!",
            identity={
                "type": "SystemAssigned",
            },
            tags={
                "Env": "production",
            })
        ```

        ### Creating A Workspace With Customer Managed Key And Azure AD Admin

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestorageacc",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS",
            account_kind="StorageV2",
            is_hns_enabled=True)
        example_data_lake_gen2_filesystem = azure.storage.DataLakeGen2Filesystem("example",
            name="example",
            storage_account_id=example_account.id)
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            purge_protection_enabled=True)
        deployer = azure.keyvault.AccessPolicy("deployer",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=current.object_id,
            key_permissions=[
                "Create",
                "Get",
                "Delete",
                "Purge",
                "GetRotationPolicy",
            ])
        example_key = azure.keyvault.Key("example",
            name="workspaceencryptionkey",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "unwrapKey",
                "wrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[deployer]))
        example_workspace = azure.synapse.Workspace("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            storage_data_lake_gen2_filesystem_id=example_data_lake_gen2_filesystem.id,
            sql_administrator_login="sqladminuser",
            sql_administrator_login_password="H@Sh1CoR3!",
            customer_managed_key={
                "key_versionless_id": example_key.versionless_id,
                "key_name": "enckey",
            },
            identity={
                "type": "SystemAssigned",
            },
            tags={
                "Env": "production",
            })
        workspace_policy = azure.keyvault.AccessPolicy("workspace_policy",
            key_vault_id=example_key_vault.id,
            tenant_id=example_workspace.identity.tenant_id,
            object_id=example_workspace.identity.principal_id,
            key_permissions=[
                "Get",
                "WrapKey",
                "UnwrapKey",
            ])
        example_workspace_key = azure.synapse.WorkspaceKey("example",
            customer_managed_key_versionless_id=example_key.versionless_id,
            synapse_workspace_id=example_workspace.id,
            active=True,
            customer_managed_key_name="enckey",
            opts = pulumi.ResourceOptions(depends_on=[workspace_policy]))
        example_workspace_aad_admin = azure.synapse.WorkspaceAadAdmin("example",
            synapse_workspace_id=example_workspace.id,
            login="AzureAD Admin",
            object_id="00000000-0000-0000-0000-000000000000",
            tenant_id="00000000-0000-0000-0000-000000000000",
            opts = pulumi.ResourceOptions(depends_on=[example_workspace_key]))
        ```

        ## Import

        Synapse Workspace can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:synapse/workspace:Workspace example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Synapse/workspaces/workspace1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['WorkspaceAzureDevopsRepoArgs', 'WorkspaceAzureDevopsRepoArgsDict']] azure_devops_repo: An `azure_devops_repo` block as defined below.
        :param pulumi.Input[builtins.bool] azuread_authentication_only: Is Azure Active Directory Authentication the only way to authenticate with resources inside this synapse Workspace. Defaults to `false`.
        :param pulumi.Input[builtins.str] compute_subnet_id: Subnet ID used for computes in workspace Changing this forces a new resource to be created.
        :param pulumi.Input[Union['WorkspaceCustomerManagedKeyArgs', 'WorkspaceCustomerManagedKeyArgsDict']] customer_managed_key: A `customer_managed_key` block as defined below.
        :param pulumi.Input[builtins.bool] data_exfiltration_protection_enabled: Is data exfiltration protection enabled in this workspace? If set to `true`, `managed_virtual_network_enabled` must also be set to `true`. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['WorkspaceGithubRepoArgs', 'WorkspaceGithubRepoArgsDict']] github_repo: A `github_repo` block as defined below.
        :param pulumi.Input[Union['WorkspaceIdentityArgs', 'WorkspaceIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] linking_allowed_for_aad_tenant_ids: Allowed AAD Tenant Ids For Linking.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the synapse Workspace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] managed_resource_group_name: Workspace managed resource group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] managed_virtual_network_enabled: Is Virtual Network enabled for all computes in this workspace? Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this synapse Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Whether public network access is allowed for the Cognitive Account. Defaults to `true`.
        :param pulumi.Input[builtins.str] purview_id: The ID of purview account.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group where the synapse Workspace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sql_administrator_login: Specifies The login name of the SQL administrator. Changing this forces a new resource to be created. If this is not provided `customer_managed_key` must be provided.
        :param pulumi.Input[builtins.str] sql_administrator_login_password: The Password associated with the `sql_administrator_login` for the SQL administrator. If this is not provided `customer_managed_key` must be provided.
        :param pulumi.Input[builtins.bool] sql_identity_control_enabled: Are pipelines (running as workspace's system assigned identity) allowed to access SQL pools?
        :param pulumi.Input[builtins.str] storage_data_lake_gen2_filesystem_id: Specifies the ID of storage data lake gen2 filesystem resource. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Synapse Workspace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Synapse Workspace.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestorageacc",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS",
            account_kind="StorageV2",
            is_hns_enabled=True)
        example_data_lake_gen2_filesystem = azure.storage.DataLakeGen2Filesystem("example",
            name="example",
            storage_account_id=example_account.id)
        example_workspace = azure.synapse.Workspace("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            storage_data_lake_gen2_filesystem_id=example_data_lake_gen2_filesystem.id,
            sql_administrator_login="sqladminuser",
            sql_administrator_login_password="H@Sh1CoR3!",
            identity={
                "type": "SystemAssigned",
            },
            tags={
                "Env": "production",
            })
        ```

        ### Creating A Workspace With Customer Managed Key And Azure AD Admin

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestorageacc",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS",
            account_kind="StorageV2",
            is_hns_enabled=True)
        example_data_lake_gen2_filesystem = azure.storage.DataLakeGen2Filesystem("example",
            name="example",
            storage_account_id=example_account.id)
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            purge_protection_enabled=True)
        deployer = azure.keyvault.AccessPolicy("deployer",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=current.object_id,
            key_permissions=[
                "Create",
                "Get",
                "Delete",
                "Purge",
                "GetRotationPolicy",
            ])
        example_key = azure.keyvault.Key("example",
            name="workspaceencryptionkey",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "unwrapKey",
                "wrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[deployer]))
        example_workspace = azure.synapse.Workspace("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            storage_data_lake_gen2_filesystem_id=example_data_lake_gen2_filesystem.id,
            sql_administrator_login="sqladminuser",
            sql_administrator_login_password="H@Sh1CoR3!",
            customer_managed_key={
                "key_versionless_id": example_key.versionless_id,
                "key_name": "enckey",
            },
            identity={
                "type": "SystemAssigned",
            },
            tags={
                "Env": "production",
            })
        workspace_policy = azure.keyvault.AccessPolicy("workspace_policy",
            key_vault_id=example_key_vault.id,
            tenant_id=example_workspace.identity.tenant_id,
            object_id=example_workspace.identity.principal_id,
            key_permissions=[
                "Get",
                "WrapKey",
                "UnwrapKey",
            ])
        example_workspace_key = azure.synapse.WorkspaceKey("example",
            customer_managed_key_versionless_id=example_key.versionless_id,
            synapse_workspace_id=example_workspace.id,
            active=True,
            customer_managed_key_name="enckey",
            opts = pulumi.ResourceOptions(depends_on=[workspace_policy]))
        example_workspace_aad_admin = azure.synapse.WorkspaceAadAdmin("example",
            synapse_workspace_id=example_workspace.id,
            login="AzureAD Admin",
            object_id="00000000-0000-0000-0000-000000000000",
            tenant_id="00000000-0000-0000-0000-000000000000",
            opts = pulumi.ResourceOptions(depends_on=[example_workspace_key]))
        ```

        ## Import

        Synapse Workspace can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:synapse/workspace:Workspace example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Synapse/workspaces/workspace1
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 azure_devops_repo: Optional[pulumi.Input[Union['WorkspaceAzureDevopsRepoArgs', 'WorkspaceAzureDevopsRepoArgsDict']]] = None,
                 azuread_authentication_only: Optional[pulumi.Input[builtins.bool]] = None,
                 compute_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input[Union['WorkspaceCustomerManagedKeyArgs', 'WorkspaceCustomerManagedKeyArgsDict']]] = None,
                 data_exfiltration_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 github_repo: Optional[pulumi.Input[Union['WorkspaceGithubRepoArgs', 'WorkspaceGithubRepoArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['WorkspaceIdentityArgs', 'WorkspaceIdentityArgsDict']]] = None,
                 linking_allowed_for_aad_tenant_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 managed_resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 managed_virtual_network_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 purview_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 sql_administrator_login: Optional[pulumi.Input[builtins.str]] = None,
                 sql_administrator_login_password: Optional[pulumi.Input[builtins.str]] = None,
                 sql_identity_control_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 storage_data_lake_gen2_filesystem_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceArgs.__new__(WorkspaceArgs)

            __props__.__dict__["azure_devops_repo"] = azure_devops_repo
            __props__.__dict__["azuread_authentication_only"] = azuread_authentication_only
            __props__.__dict__["compute_subnet_id"] = compute_subnet_id
            __props__.__dict__["customer_managed_key"] = customer_managed_key
            __props__.__dict__["data_exfiltration_protection_enabled"] = data_exfiltration_protection_enabled
            __props__.__dict__["github_repo"] = github_repo
            __props__.__dict__["identity"] = identity
            __props__.__dict__["linking_allowed_for_aad_tenant_ids"] = linking_allowed_for_aad_tenant_ids
            __props__.__dict__["location"] = location
            __props__.__dict__["managed_resource_group_name"] = managed_resource_group_name
            __props__.__dict__["managed_virtual_network_enabled"] = managed_virtual_network_enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            __props__.__dict__["purview_id"] = purview_id
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["sql_administrator_login"] = sql_administrator_login
            __props__.__dict__["sql_administrator_login_password"] = None if sql_administrator_login_password is None else pulumi.Output.secret(sql_administrator_login_password)
            __props__.__dict__["sql_identity_control_enabled"] = sql_identity_control_enabled
            if storage_data_lake_gen2_filesystem_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_data_lake_gen2_filesystem_id'")
            __props__.__dict__["storage_data_lake_gen2_filesystem_id"] = storage_data_lake_gen2_filesystem_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["connectivity_endpoints"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["sqlAdministratorLoginPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Workspace, __self__).__init__(
            'azure:synapse/workspace:Workspace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            azure_devops_repo: Optional[pulumi.Input[Union['WorkspaceAzureDevopsRepoArgs', 'WorkspaceAzureDevopsRepoArgsDict']]] = None,
            azuread_authentication_only: Optional[pulumi.Input[builtins.bool]] = None,
            compute_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
            connectivity_endpoints: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            customer_managed_key: Optional[pulumi.Input[Union['WorkspaceCustomerManagedKeyArgs', 'WorkspaceCustomerManagedKeyArgsDict']]] = None,
            data_exfiltration_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            github_repo: Optional[pulumi.Input[Union['WorkspaceGithubRepoArgs', 'WorkspaceGithubRepoArgsDict']]] = None,
            identity: Optional[pulumi.Input[Union['WorkspaceIdentityArgs', 'WorkspaceIdentityArgsDict']]] = None,
            linking_allowed_for_aad_tenant_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            managed_resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            managed_virtual_network_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            purview_id: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            sql_administrator_login: Optional[pulumi.Input[builtins.str]] = None,
            sql_administrator_login_password: Optional[pulumi.Input[builtins.str]] = None,
            sql_identity_control_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            storage_data_lake_gen2_filesystem_id: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'Workspace':
        """
        Get an existing Workspace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['WorkspaceAzureDevopsRepoArgs', 'WorkspaceAzureDevopsRepoArgsDict']] azure_devops_repo: An `azure_devops_repo` block as defined below.
        :param pulumi.Input[builtins.bool] azuread_authentication_only: Is Azure Active Directory Authentication the only way to authenticate with resources inside this synapse Workspace. Defaults to `false`.
        :param pulumi.Input[builtins.str] compute_subnet_id: Subnet ID used for computes in workspace Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] connectivity_endpoints: A map of Connectivity endpoints for this Synapse Workspace. Possible key values are `dev`, `sql`, `sqlOnDemand`, and `web`.
        :param pulumi.Input[Union['WorkspaceCustomerManagedKeyArgs', 'WorkspaceCustomerManagedKeyArgsDict']] customer_managed_key: A `customer_managed_key` block as defined below.
        :param pulumi.Input[builtins.bool] data_exfiltration_protection_enabled: Is data exfiltration protection enabled in this workspace? If set to `true`, `managed_virtual_network_enabled` must also be set to `true`. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['WorkspaceGithubRepoArgs', 'WorkspaceGithubRepoArgsDict']] github_repo: A `github_repo` block as defined below.
        :param pulumi.Input[Union['WorkspaceIdentityArgs', 'WorkspaceIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] linking_allowed_for_aad_tenant_ids: Allowed AAD Tenant Ids For Linking.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the synapse Workspace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] managed_resource_group_name: Workspace managed resource group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] managed_virtual_network_enabled: Is Virtual Network enabled for all computes in this workspace? Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this synapse Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Whether public network access is allowed for the Cognitive Account. Defaults to `true`.
        :param pulumi.Input[builtins.str] purview_id: The ID of purview account.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group where the synapse Workspace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sql_administrator_login: Specifies The login name of the SQL administrator. Changing this forces a new resource to be created. If this is not provided `customer_managed_key` must be provided.
        :param pulumi.Input[builtins.str] sql_administrator_login_password: The Password associated with the `sql_administrator_login` for the SQL administrator. If this is not provided `customer_managed_key` must be provided.
        :param pulumi.Input[builtins.bool] sql_identity_control_enabled: Are pipelines (running as workspace's system assigned identity) allowed to access SQL pools?
        :param pulumi.Input[builtins.str] storage_data_lake_gen2_filesystem_id: Specifies the ID of storage data lake gen2 filesystem resource. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Synapse Workspace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceState.__new__(_WorkspaceState)

        __props__.__dict__["azure_devops_repo"] = azure_devops_repo
        __props__.__dict__["azuread_authentication_only"] = azuread_authentication_only
        __props__.__dict__["compute_subnet_id"] = compute_subnet_id
        __props__.__dict__["connectivity_endpoints"] = connectivity_endpoints
        __props__.__dict__["customer_managed_key"] = customer_managed_key
        __props__.__dict__["data_exfiltration_protection_enabled"] = data_exfiltration_protection_enabled
        __props__.__dict__["github_repo"] = github_repo
        __props__.__dict__["identity"] = identity
        __props__.__dict__["linking_allowed_for_aad_tenant_ids"] = linking_allowed_for_aad_tenant_ids
        __props__.__dict__["location"] = location
        __props__.__dict__["managed_resource_group_name"] = managed_resource_group_name
        __props__.__dict__["managed_virtual_network_enabled"] = managed_virtual_network_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["purview_id"] = purview_id
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sql_administrator_login"] = sql_administrator_login
        __props__.__dict__["sql_administrator_login_password"] = sql_administrator_login_password
        __props__.__dict__["sql_identity_control_enabled"] = sql_identity_control_enabled
        __props__.__dict__["storage_data_lake_gen2_filesystem_id"] = storage_data_lake_gen2_filesystem_id
        __props__.__dict__["tags"] = tags
        return Workspace(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="azureDevopsRepo")
    def azure_devops_repo(self) -> pulumi.Output[Optional['outputs.WorkspaceAzureDevopsRepo']]:
        """
        An `azure_devops_repo` block as defined below.
        """
        return pulumi.get(self, "azure_devops_repo")

    @property
    @pulumi.getter(name="azureadAuthenticationOnly")
    def azuread_authentication_only(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is Azure Active Directory Authentication the only way to authenticate with resources inside this synapse Workspace. Defaults to `false`.
        """
        return pulumi.get(self, "azuread_authentication_only")

    @property
    @pulumi.getter(name="computeSubnetId")
    def compute_subnet_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Subnet ID used for computes in workspace Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "compute_subnet_id")

    @property
    @pulumi.getter(name="connectivityEndpoints")
    def connectivity_endpoints(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of Connectivity endpoints for this Synapse Workspace. Possible key values are `dev`, `sql`, `sqlOnDemand`, and `web`.
        """
        return pulumi.get(self, "connectivity_endpoints")

    @property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> pulumi.Output[Optional['outputs.WorkspaceCustomerManagedKey']]:
        """
        A `customer_managed_key` block as defined below.
        """
        return pulumi.get(self, "customer_managed_key")

    @property
    @pulumi.getter(name="dataExfiltrationProtectionEnabled")
    def data_exfiltration_protection_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is data exfiltration protection enabled in this workspace? If set to `true`, `managed_virtual_network_enabled` must also be set to `true`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_exfiltration_protection_enabled")

    @property
    @pulumi.getter(name="githubRepo")
    def github_repo(self) -> pulumi.Output[Optional['outputs.WorkspaceGithubRepo']]:
        """
        A `github_repo` block as defined below.
        """
        return pulumi.get(self, "github_repo")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.WorkspaceIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="linkingAllowedForAadTenantIds")
    def linking_allowed_for_aad_tenant_ids(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Allowed AAD Tenant Ids For Linking.
        """
        return pulumi.get(self, "linking_allowed_for_aad_tenant_ids")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Azure Region where the synapse Workspace should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="managedResourceGroupName")
    def managed_resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        Workspace managed resource group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_resource_group_name")

    @property
    @pulumi.getter(name="managedVirtualNetworkEnabled")
    def managed_virtual_network_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is Virtual Network enabled for all computes in this workspace? Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_virtual_network_enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name which should be used for this synapse Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether public network access is allowed for the Cognitive Account. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @property
    @pulumi.getter(name="purviewId")
    def purview_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of purview account.
        """
        return pulumi.get(self, "purview_id")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Resource Group where the synapse Workspace should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="sqlAdministratorLogin")
    def sql_administrator_login(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies The login name of the SQL administrator. Changing this forces a new resource to be created. If this is not provided `customer_managed_key` must be provided.
        """
        return pulumi.get(self, "sql_administrator_login")

    @property
    @pulumi.getter(name="sqlAdministratorLoginPassword")
    def sql_administrator_login_password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Password associated with the `sql_administrator_login` for the SQL administrator. If this is not provided `customer_managed_key` must be provided.
        """
        return pulumi.get(self, "sql_administrator_login_password")

    @property
    @pulumi.getter(name="sqlIdentityControlEnabled")
    def sql_identity_control_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Are pipelines (running as workspace's system assigned identity) allowed to access SQL pools?
        """
        return pulumi.get(self, "sql_identity_control_enabled")

    @property
    @pulumi.getter(name="storageDataLakeGen2FilesystemId")
    def storage_data_lake_gen2_filesystem_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the ID of storage data lake gen2 filesystem resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_data_lake_gen2_filesystem_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Synapse Workspace.
        """
        return pulumi.get(self, "tags")

