# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WorkspaceKeyArgs', 'WorkspaceKey']

@pulumi.input_type
class WorkspaceKeyArgs:
    def __init__(__self__, *,
                 active: pulumi.Input[builtins.bool],
                 customer_managed_key_name: pulumi.Input[builtins.str],
                 synapse_workspace_id: pulumi.Input[builtins.str],
                 customer_managed_key_versionless_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a WorkspaceKey resource.
        :param pulumi.Input[builtins.bool] active: Specifies if the workspace should be encrypted with this key.
               
               > **Note:** Only one key can actively encrypt a workspace. When performing a key rotation, setting a new key as the active key will disable existing keys.
        :param pulumi.Input[builtins.str] customer_managed_key_name: Specifies the name of the workspace key. Should match the name of the key in the synapse workspace.
        :param pulumi.Input[builtins.str] synapse_workspace_id: The ID of the Synapse Workspace where the encryption key should be configured.
        :param pulumi.Input[builtins.str] customer_managed_key_versionless_id: The Azure Key Vault Key Versionless ID to be used as the Customer Managed Key (CMK) for double encryption
        """
        pulumi.set(__self__, "active", active)
        pulumi.set(__self__, "customer_managed_key_name", customer_managed_key_name)
        pulumi.set(__self__, "synapse_workspace_id", synapse_workspace_id)
        if customer_managed_key_versionless_id is not None:
            pulumi.set(__self__, "customer_managed_key_versionless_id", customer_managed_key_versionless_id)

    @property
    @pulumi.getter
    def active(self) -> pulumi.Input[builtins.bool]:
        """
        Specifies if the workspace should be encrypted with this key.

        > **Note:** Only one key can actively encrypt a workspace. When performing a key rotation, setting a new key as the active key will disable existing keys.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="customerManagedKeyName")
    def customer_managed_key_name(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the name of the workspace key. Should match the name of the key in the synapse workspace.
        """
        return pulumi.get(self, "customer_managed_key_name")

    @customer_managed_key_name.setter
    def customer_managed_key_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "customer_managed_key_name", value)

    @property
    @pulumi.getter(name="synapseWorkspaceId")
    def synapse_workspace_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Synapse Workspace where the encryption key should be configured.
        """
        return pulumi.get(self, "synapse_workspace_id")

    @synapse_workspace_id.setter
    def synapse_workspace_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "synapse_workspace_id", value)

    @property
    @pulumi.getter(name="customerManagedKeyVersionlessId")
    def customer_managed_key_versionless_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Key Vault Key Versionless ID to be used as the Customer Managed Key (CMK) for double encryption
        """
        return pulumi.get(self, "customer_managed_key_versionless_id")

    @customer_managed_key_versionless_id.setter
    def customer_managed_key_versionless_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_managed_key_versionless_id", value)


@pulumi.input_type
class _WorkspaceKeyState:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 customer_managed_key_name: Optional[pulumi.Input[builtins.str]] = None,
                 customer_managed_key_versionless_id: Optional[pulumi.Input[builtins.str]] = None,
                 synapse_workspace_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceKey resources.
        :param pulumi.Input[builtins.bool] active: Specifies if the workspace should be encrypted with this key.
               
               > **Note:** Only one key can actively encrypt a workspace. When performing a key rotation, setting a new key as the active key will disable existing keys.
        :param pulumi.Input[builtins.str] customer_managed_key_name: Specifies the name of the workspace key. Should match the name of the key in the synapse workspace.
        :param pulumi.Input[builtins.str] customer_managed_key_versionless_id: The Azure Key Vault Key Versionless ID to be used as the Customer Managed Key (CMK) for double encryption
        :param pulumi.Input[builtins.str] synapse_workspace_id: The ID of the Synapse Workspace where the encryption key should be configured.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if customer_managed_key_name is not None:
            pulumi.set(__self__, "customer_managed_key_name", customer_managed_key_name)
        if customer_managed_key_versionless_id is not None:
            pulumi.set(__self__, "customer_managed_key_versionless_id", customer_managed_key_versionless_id)
        if synapse_workspace_id is not None:
            pulumi.set(__self__, "synapse_workspace_id", synapse_workspace_id)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if the workspace should be encrypted with this key.

        > **Note:** Only one key can actively encrypt a workspace. When performing a key rotation, setting a new key as the active key will disable existing keys.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="customerManagedKeyName")
    def customer_managed_key_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the workspace key. Should match the name of the key in the synapse workspace.
        """
        return pulumi.get(self, "customer_managed_key_name")

    @customer_managed_key_name.setter
    def customer_managed_key_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_managed_key_name", value)

    @property
    @pulumi.getter(name="customerManagedKeyVersionlessId")
    def customer_managed_key_versionless_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Key Vault Key Versionless ID to be used as the Customer Managed Key (CMK) for double encryption
        """
        return pulumi.get(self, "customer_managed_key_versionless_id")

    @customer_managed_key_versionless_id.setter
    def customer_managed_key_versionless_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_managed_key_versionless_id", value)

    @property
    @pulumi.getter(name="synapseWorkspaceId")
    def synapse_workspace_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Synapse Workspace where the encryption key should be configured.
        """
        return pulumi.get(self, "synapse_workspace_id")

    @synapse_workspace_id.setter
    def synapse_workspace_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "synapse_workspace_id", value)


@pulumi.type_token("azure:synapse/workspaceKey:WorkspaceKey")
class WorkspaceKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 customer_managed_key_name: Optional[pulumi.Input[builtins.str]] = None,
                 customer_managed_key_versionless_id: Optional[pulumi.Input[builtins.str]] = None,
                 synapse_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages Synapse Workspace keys

        > **Note:** Keys that are actively protecting a workspace cannot be deleted. When the keys resource is deleted, if the key is inactive it will be deleted, if it is active it will not be deleted.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestorageacc",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS",
            account_kind="StorageV2",
            is_hns_enabled=True)
        example_data_lake_gen2_filesystem = azure.storage.DataLakeGen2Filesystem("example",
            name="example",
            storage_account_id=example_account.id)
        current = azure.core.get_client_config()
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            purge_protection_enabled=True)
        deployer = azure.keyvault.AccessPolicy("deployer",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=current.object_id,
            key_permissions=[
                "Create",
                "Get",
                "Delete",
                "Purge",
                "GetRotationPolicy",
            ])
        example_key = azure.keyvault.Key("example",
            name="workspaceEncryptionKey",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "unwrapKey",
                "wrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[deployer]))
        example_workspace = azure.synapse.Workspace("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            storage_data_lake_gen2_filesystem_id=example_data_lake_gen2_filesystem.id,
            sql_administrator_login="sqladminuser",
            sql_administrator_login_password="H@Sh1CoR3!",
            customer_managed_key={
                "key_versionless_id": example_key.versionless_id,
                "key_name": "enckey",
            },
            identity={
                "type": "SystemAssigned",
            },
            tags={
                "Env": "production",
            })
        workspace_policy = azure.keyvault.AccessPolicy("workspace_policy",
            key_vault_id=example_key_vault.id,
            tenant_id=example_workspace.identity.tenant_id,
            object_id=example_workspace.identity.principal_id,
            key_permissions=[
                "Get",
                "WrapKey",
                "UnwrapKey",
            ])
        example_workspace_key = azure.synapse.WorkspaceKey("example",
            customer_managed_key_versionless_id=example_key.versionless_id,
            synapse_workspace_id=example_workspace.id,
            active=True,
            customer_managed_key_name="enckey",
            opts = pulumi.ResourceOptions(depends_on=[workspace_policy]))
        ```

        ## Import

        Synapse Workspace Keys can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:synapse/workspaceKey:WorkspaceKey example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Synapse/workspaces/workspace1/keys/key1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] active: Specifies if the workspace should be encrypted with this key.
               
               > **Note:** Only one key can actively encrypt a workspace. When performing a key rotation, setting a new key as the active key will disable existing keys.
        :param pulumi.Input[builtins.str] customer_managed_key_name: Specifies the name of the workspace key. Should match the name of the key in the synapse workspace.
        :param pulumi.Input[builtins.str] customer_managed_key_versionless_id: The Azure Key Vault Key Versionless ID to be used as the Customer Managed Key (CMK) for double encryption
        :param pulumi.Input[builtins.str] synapse_workspace_id: The ID of the Synapse Workspace where the encryption key should be configured.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Synapse Workspace keys

        > **Note:** Keys that are actively protecting a workspace cannot be deleted. When the keys resource is deleted, if the key is inactive it will be deleted, if it is active it will not be deleted.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestorageacc",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS",
            account_kind="StorageV2",
            is_hns_enabled=True)
        example_data_lake_gen2_filesystem = azure.storage.DataLakeGen2Filesystem("example",
            name="example",
            storage_account_id=example_account.id)
        current = azure.core.get_client_config()
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            purge_protection_enabled=True)
        deployer = azure.keyvault.AccessPolicy("deployer",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=current.object_id,
            key_permissions=[
                "Create",
                "Get",
                "Delete",
                "Purge",
                "GetRotationPolicy",
            ])
        example_key = azure.keyvault.Key("example",
            name="workspaceEncryptionKey",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "unwrapKey",
                "wrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[deployer]))
        example_workspace = azure.synapse.Workspace("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            storage_data_lake_gen2_filesystem_id=example_data_lake_gen2_filesystem.id,
            sql_administrator_login="sqladminuser",
            sql_administrator_login_password="H@Sh1CoR3!",
            customer_managed_key={
                "key_versionless_id": example_key.versionless_id,
                "key_name": "enckey",
            },
            identity={
                "type": "SystemAssigned",
            },
            tags={
                "Env": "production",
            })
        workspace_policy = azure.keyvault.AccessPolicy("workspace_policy",
            key_vault_id=example_key_vault.id,
            tenant_id=example_workspace.identity.tenant_id,
            object_id=example_workspace.identity.principal_id,
            key_permissions=[
                "Get",
                "WrapKey",
                "UnwrapKey",
            ])
        example_workspace_key = azure.synapse.WorkspaceKey("example",
            customer_managed_key_versionless_id=example_key.versionless_id,
            synapse_workspace_id=example_workspace.id,
            active=True,
            customer_managed_key_name="enckey",
            opts = pulumi.ResourceOptions(depends_on=[workspace_policy]))
        ```

        ## Import

        Synapse Workspace Keys can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:synapse/workspaceKey:WorkspaceKey example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Synapse/workspaces/workspace1/keys/key1
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 customer_managed_key_name: Optional[pulumi.Input[builtins.str]] = None,
                 customer_managed_key_versionless_id: Optional[pulumi.Input[builtins.str]] = None,
                 synapse_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceKeyArgs.__new__(WorkspaceKeyArgs)

            if active is None and not opts.urn:
                raise TypeError("Missing required property 'active'")
            __props__.__dict__["active"] = active
            if customer_managed_key_name is None and not opts.urn:
                raise TypeError("Missing required property 'customer_managed_key_name'")
            __props__.__dict__["customer_managed_key_name"] = customer_managed_key_name
            __props__.__dict__["customer_managed_key_versionless_id"] = customer_managed_key_versionless_id
            if synapse_workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'synapse_workspace_id'")
            __props__.__dict__["synapse_workspace_id"] = synapse_workspace_id
        super(WorkspaceKey, __self__).__init__(
            'azure:synapse/workspaceKey:WorkspaceKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active: Optional[pulumi.Input[builtins.bool]] = None,
            customer_managed_key_name: Optional[pulumi.Input[builtins.str]] = None,
            customer_managed_key_versionless_id: Optional[pulumi.Input[builtins.str]] = None,
            synapse_workspace_id: Optional[pulumi.Input[builtins.str]] = None) -> 'WorkspaceKey':
        """
        Get an existing WorkspaceKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] active: Specifies if the workspace should be encrypted with this key.
               
               > **Note:** Only one key can actively encrypt a workspace. When performing a key rotation, setting a new key as the active key will disable existing keys.
        :param pulumi.Input[builtins.str] customer_managed_key_name: Specifies the name of the workspace key. Should match the name of the key in the synapse workspace.
        :param pulumi.Input[builtins.str] customer_managed_key_versionless_id: The Azure Key Vault Key Versionless ID to be used as the Customer Managed Key (CMK) for double encryption
        :param pulumi.Input[builtins.str] synapse_workspace_id: The ID of the Synapse Workspace where the encryption key should be configured.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceKeyState.__new__(_WorkspaceKeyState)

        __props__.__dict__["active"] = active
        __props__.__dict__["customer_managed_key_name"] = customer_managed_key_name
        __props__.__dict__["customer_managed_key_versionless_id"] = customer_managed_key_versionless_id
        __props__.__dict__["synapse_workspace_id"] = synapse_workspace_id
        return WorkspaceKey(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[builtins.bool]:
        """
        Specifies if the workspace should be encrypted with this key.

        > **Note:** Only one key can actively encrypt a workspace. When performing a key rotation, setting a new key as the active key will disable existing keys.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="customerManagedKeyName")
    def customer_managed_key_name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the workspace key. Should match the name of the key in the synapse workspace.
        """
        return pulumi.get(self, "customer_managed_key_name")

    @property
    @pulumi.getter(name="customerManagedKeyVersionlessId")
    def customer_managed_key_versionless_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Azure Key Vault Key Versionless ID to be used as the Customer Managed Key (CMK) for double encryption
        """
        return pulumi.get(self, "customer_managed_key_versionless_id")

    @property
    @pulumi.getter(name="synapseWorkspaceId")
    def synapse_workspace_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Synapse Workspace where the encryption key should be configured.
        """
        return pulumi.get(self, "synapse_workspace_id")

