# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVirtualMachineManagerInventoryItemsResult',
    'AwaitableGetVirtualMachineManagerInventoryItemsResult',
    'get_virtual_machine_manager_inventory_items',
    'get_virtual_machine_manager_inventory_items_output',
]

@pulumi.output_type
class GetVirtualMachineManagerInventoryItemsResult:
    """
    A collection of values returned by getVirtualMachineManagerInventoryItems.
    """
    def __init__(__self__, id=None, inventory_items=None, inventory_type=None, system_center_virtual_machine_manager_server_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if inventory_items and not isinstance(inventory_items, list):
            raise TypeError("Expected argument 'inventory_items' to be a list")
        pulumi.set(__self__, "inventory_items", inventory_items)
        if inventory_type and not isinstance(inventory_type, str):
            raise TypeError("Expected argument 'inventory_type' to be a str")
        pulumi.set(__self__, "inventory_type", inventory_type)
        if system_center_virtual_machine_manager_server_id and not isinstance(system_center_virtual_machine_manager_server_id, str):
            raise TypeError("Expected argument 'system_center_virtual_machine_manager_server_id' to be a str")
        pulumi.set(__self__, "system_center_virtual_machine_manager_server_id", system_center_virtual_machine_manager_server_id)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inventoryItems")
    def inventory_items(self) -> Sequence['outputs.GetVirtualMachineManagerInventoryItemsInventoryItemResult']:
        """
        One or more `inventory_items` blocks as defined below.
        """
        return pulumi.get(self, "inventory_items")

    @property
    @pulumi.getter(name="inventoryType")
    def inventory_type(self) -> builtins.str:
        return pulumi.get(self, "inventory_type")

    @property
    @pulumi.getter(name="systemCenterVirtualMachineManagerServerId")
    def system_center_virtual_machine_manager_server_id(self) -> builtins.str:
        return pulumi.get(self, "system_center_virtual_machine_manager_server_id")


class AwaitableGetVirtualMachineManagerInventoryItemsResult(GetVirtualMachineManagerInventoryItemsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVirtualMachineManagerInventoryItemsResult(
            id=self.id,
            inventory_items=self.inventory_items,
            inventory_type=self.inventory_type,
            system_center_virtual_machine_manager_server_id=self.system_center_virtual_machine_manager_server_id)


def get_virtual_machine_manager_inventory_items(inventory_type: Optional[builtins.str] = None,
                                                system_center_virtual_machine_manager_server_id: Optional[builtins.str] = None,
                                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVirtualMachineManagerInventoryItemsResult:
    """
    Use this data source to access information about existing System Center Virtual Machine Manager Inventory Items.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.systemcenter.get_virtual_machine_manager_inventory_items(inventory_type="Cloud",
        system_center_virtual_machine_manager_server_id=example_azurerm_system_center_virtual_machine_manager_server["id"])
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ScVmm`: 2023-10-07


    :param builtins.str inventory_type: The inventory type of the System Center Virtual Machine Manager Inventory Item. Possible values are `Cloud`, `VirtualMachine`, `VirtualMachineTemplate` and `VirtualNetwork`.
    :param builtins.str system_center_virtual_machine_manager_server_id: The ID of the System Center Virtual Machine Manager Server.
    """
    __args__ = dict()
    __args__['inventoryType'] = inventory_type
    __args__['systemCenterVirtualMachineManagerServerId'] = system_center_virtual_machine_manager_server_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:systemcenter/getVirtualMachineManagerInventoryItems:getVirtualMachineManagerInventoryItems', __args__, opts=opts, typ=GetVirtualMachineManagerInventoryItemsResult).value

    return AwaitableGetVirtualMachineManagerInventoryItemsResult(
        id=pulumi.get(__ret__, 'id'),
        inventory_items=pulumi.get(__ret__, 'inventory_items'),
        inventory_type=pulumi.get(__ret__, 'inventory_type'),
        system_center_virtual_machine_manager_server_id=pulumi.get(__ret__, 'system_center_virtual_machine_manager_server_id'))
def get_virtual_machine_manager_inventory_items_output(inventory_type: Optional[pulumi.Input[builtins.str]] = None,
                                                       system_center_virtual_machine_manager_server_id: Optional[pulumi.Input[builtins.str]] = None,
                                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVirtualMachineManagerInventoryItemsResult]:
    """
    Use this data source to access information about existing System Center Virtual Machine Manager Inventory Items.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.systemcenter.get_virtual_machine_manager_inventory_items(inventory_type="Cloud",
        system_center_virtual_machine_manager_server_id=example_azurerm_system_center_virtual_machine_manager_server["id"])
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ScVmm`: 2023-10-07


    :param builtins.str inventory_type: The inventory type of the System Center Virtual Machine Manager Inventory Item. Possible values are `Cloud`, `VirtualMachine`, `VirtualMachineTemplate` and `VirtualNetwork`.
    :param builtins.str system_center_virtual_machine_manager_server_id: The ID of the System Center Virtual Machine Manager Server.
    """
    __args__ = dict()
    __args__['inventoryType'] = inventory_type
    __args__['systemCenterVirtualMachineManagerServerId'] = system_center_virtual_machine_manager_server_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:systemcenter/getVirtualMachineManagerInventoryItems:getVirtualMachineManagerInventoryItems', __args__, opts=opts, typ=GetVirtualMachineManagerInventoryItemsResult)
    return __ret__.apply(lambda __response__: GetVirtualMachineManagerInventoryItemsResult(
        id=pulumi.get(__response__, 'id'),
        inventory_items=pulumi.get(__response__, 'inventory_items'),
        inventory_type=pulumi.get(__response__, 'inventory_type'),
        system_center_virtual_machine_manager_server_id=pulumi.get(__response__, 'system_center_virtual_machine_manager_server_id')))
