# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VirtualMachineManagerVirtualMachineInstanceArgs', 'VirtualMachineManagerVirtualMachineInstance']

@pulumi.input_type
class VirtualMachineManagerVirtualMachineInstanceArgs:
    def __init__(__self__, *,
                 custom_location_id: pulumi.Input[builtins.str],
                 infrastructure: pulumi.Input['VirtualMachineManagerVirtualMachineInstanceInfrastructureArgs'],
                 scoped_resource_id: pulumi.Input[builtins.str],
                 hardware: Optional[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceHardwareArgs']] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceNetworkInterfaceArgs']]]] = None,
                 operating_system: Optional[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceOperatingSystemArgs']] = None,
                 storage_disks: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceStorageDiskArgs']]]] = None,
                 system_center_virtual_machine_manager_availability_set_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a VirtualMachineManagerVirtualMachineInstance resource.
        :param pulumi.Input[builtins.str] custom_location_id: The ID of the Custom Location for the System Center Virtual Machine Manager Virtual Machine Instance. Changing this forces a new resource to be created.
        :param pulumi.Input['VirtualMachineManagerVirtualMachineInstanceInfrastructureArgs'] infrastructure: An `infrastructure` block as defined below.
        :param pulumi.Input[builtins.str] scoped_resource_id: The ID of the Hybrid Compute Machine where this System Center Virtual Machine Manager Virtual Machine Instance is stored. Changing this forces a new resource to be created.
        :param pulumi.Input['VirtualMachineManagerVirtualMachineInstanceHardwareArgs'] hardware: A `hardware` block as defined below. Changing this forces a new resource to be created.
               
               > **Note:** This resource will be restarted while updating `hardware`.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceNetworkInterfaceArgs']]] network_interfaces: A `network_interface` block as defined below.
               
               > **Note:** This resource will be restarted while updating `network_interface`.
        :param pulumi.Input['VirtualMachineManagerVirtualMachineInstanceOperatingSystemArgs'] operating_system: An `operating_system` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceStorageDiskArgs']]] storage_disks: A `storage_disk` block as defined below.
               
               > **Note:** This resource will be restarted while updating `storage_disk`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] system_center_virtual_machine_manager_availability_set_ids: A list of IDs of System Center Virtual Machine Manager Availability Set.
        """
        pulumi.set(__self__, "custom_location_id", custom_location_id)
        pulumi.set(__self__, "infrastructure", infrastructure)
        pulumi.set(__self__, "scoped_resource_id", scoped_resource_id)
        if hardware is not None:
            pulumi.set(__self__, "hardware", hardware)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if operating_system is not None:
            pulumi.set(__self__, "operating_system", operating_system)
        if storage_disks is not None:
            pulumi.set(__self__, "storage_disks", storage_disks)
        if system_center_virtual_machine_manager_availability_set_ids is not None:
            pulumi.set(__self__, "system_center_virtual_machine_manager_availability_set_ids", system_center_virtual_machine_manager_availability_set_ids)

    @property
    @pulumi.getter(name="customLocationId")
    def custom_location_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Custom Location for the System Center Virtual Machine Manager Virtual Machine Instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "custom_location_id")

    @custom_location_id.setter
    def custom_location_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "custom_location_id", value)

    @property
    @pulumi.getter
    def infrastructure(self) -> pulumi.Input['VirtualMachineManagerVirtualMachineInstanceInfrastructureArgs']:
        """
        An `infrastructure` block as defined below.
        """
        return pulumi.get(self, "infrastructure")

    @infrastructure.setter
    def infrastructure(self, value: pulumi.Input['VirtualMachineManagerVirtualMachineInstanceInfrastructureArgs']):
        pulumi.set(self, "infrastructure", value)

    @property
    @pulumi.getter(name="scopedResourceId")
    def scoped_resource_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Hybrid Compute Machine where this System Center Virtual Machine Manager Virtual Machine Instance is stored. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "scoped_resource_id")

    @scoped_resource_id.setter
    def scoped_resource_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "scoped_resource_id", value)

    @property
    @pulumi.getter
    def hardware(self) -> Optional[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceHardwareArgs']]:
        """
        A `hardware` block as defined below. Changing this forces a new resource to be created.

        > **Note:** This resource will be restarted while updating `hardware`.
        """
        return pulumi.get(self, "hardware")

    @hardware.setter
    def hardware(self, value: Optional[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceHardwareArgs']]):
        pulumi.set(self, "hardware", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceNetworkInterfaceArgs']]]]:
        """
        A `network_interface` block as defined below.

        > **Note:** This resource will be restarted while updating `network_interface`.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> Optional[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceOperatingSystemArgs']]:
        """
        An `operating_system` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "operating_system")

    @operating_system.setter
    def operating_system(self, value: Optional[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceOperatingSystemArgs']]):
        pulumi.set(self, "operating_system", value)

    @property
    @pulumi.getter(name="storageDisks")
    def storage_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceStorageDiskArgs']]]]:
        """
        A `storage_disk` block as defined below.

        > **Note:** This resource will be restarted while updating `storage_disk`.
        """
        return pulumi.get(self, "storage_disks")

    @storage_disks.setter
    def storage_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceStorageDiskArgs']]]]):
        pulumi.set(self, "storage_disks", value)

    @property
    @pulumi.getter(name="systemCenterVirtualMachineManagerAvailabilitySetIds")
    def system_center_virtual_machine_manager_availability_set_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of IDs of System Center Virtual Machine Manager Availability Set.
        """
        return pulumi.get(self, "system_center_virtual_machine_manager_availability_set_ids")

    @system_center_virtual_machine_manager_availability_set_ids.setter
    def system_center_virtual_machine_manager_availability_set_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_center_virtual_machine_manager_availability_set_ids", value)


@pulumi.input_type
class _VirtualMachineManagerVirtualMachineInstanceState:
    def __init__(__self__, *,
                 custom_location_id: Optional[pulumi.Input[builtins.str]] = None,
                 hardware: Optional[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceHardwareArgs']] = None,
                 infrastructure: Optional[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceInfrastructureArgs']] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceNetworkInterfaceArgs']]]] = None,
                 operating_system: Optional[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceOperatingSystemArgs']] = None,
                 scoped_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 storage_disks: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceStorageDiskArgs']]]] = None,
                 system_center_virtual_machine_manager_availability_set_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering VirtualMachineManagerVirtualMachineInstance resources.
        :param pulumi.Input[builtins.str] custom_location_id: The ID of the Custom Location for the System Center Virtual Machine Manager Virtual Machine Instance. Changing this forces a new resource to be created.
        :param pulumi.Input['VirtualMachineManagerVirtualMachineInstanceHardwareArgs'] hardware: A `hardware` block as defined below. Changing this forces a new resource to be created.
               
               > **Note:** This resource will be restarted while updating `hardware`.
        :param pulumi.Input['VirtualMachineManagerVirtualMachineInstanceInfrastructureArgs'] infrastructure: An `infrastructure` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceNetworkInterfaceArgs']]] network_interfaces: A `network_interface` block as defined below.
               
               > **Note:** This resource will be restarted while updating `network_interface`.
        :param pulumi.Input['VirtualMachineManagerVirtualMachineInstanceOperatingSystemArgs'] operating_system: An `operating_system` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] scoped_resource_id: The ID of the Hybrid Compute Machine where this System Center Virtual Machine Manager Virtual Machine Instance is stored. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceStorageDiskArgs']]] storage_disks: A `storage_disk` block as defined below.
               
               > **Note:** This resource will be restarted while updating `storage_disk`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] system_center_virtual_machine_manager_availability_set_ids: A list of IDs of System Center Virtual Machine Manager Availability Set.
        """
        if custom_location_id is not None:
            pulumi.set(__self__, "custom_location_id", custom_location_id)
        if hardware is not None:
            pulumi.set(__self__, "hardware", hardware)
        if infrastructure is not None:
            pulumi.set(__self__, "infrastructure", infrastructure)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if operating_system is not None:
            pulumi.set(__self__, "operating_system", operating_system)
        if scoped_resource_id is not None:
            pulumi.set(__self__, "scoped_resource_id", scoped_resource_id)
        if storage_disks is not None:
            pulumi.set(__self__, "storage_disks", storage_disks)
        if system_center_virtual_machine_manager_availability_set_ids is not None:
            pulumi.set(__self__, "system_center_virtual_machine_manager_availability_set_ids", system_center_virtual_machine_manager_availability_set_ids)

    @property
    @pulumi.getter(name="customLocationId")
    def custom_location_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Custom Location for the System Center Virtual Machine Manager Virtual Machine Instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "custom_location_id")

    @custom_location_id.setter
    def custom_location_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_location_id", value)

    @property
    @pulumi.getter
    def hardware(self) -> Optional[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceHardwareArgs']]:
        """
        A `hardware` block as defined below. Changing this forces a new resource to be created.

        > **Note:** This resource will be restarted while updating `hardware`.
        """
        return pulumi.get(self, "hardware")

    @hardware.setter
    def hardware(self, value: Optional[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceHardwareArgs']]):
        pulumi.set(self, "hardware", value)

    @property
    @pulumi.getter
    def infrastructure(self) -> Optional[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceInfrastructureArgs']]:
        """
        An `infrastructure` block as defined below.
        """
        return pulumi.get(self, "infrastructure")

    @infrastructure.setter
    def infrastructure(self, value: Optional[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceInfrastructureArgs']]):
        pulumi.set(self, "infrastructure", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceNetworkInterfaceArgs']]]]:
        """
        A `network_interface` block as defined below.

        > **Note:** This resource will be restarted while updating `network_interface`.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> Optional[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceOperatingSystemArgs']]:
        """
        An `operating_system` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "operating_system")

    @operating_system.setter
    def operating_system(self, value: Optional[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceOperatingSystemArgs']]):
        pulumi.set(self, "operating_system", value)

    @property
    @pulumi.getter(name="scopedResourceId")
    def scoped_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Hybrid Compute Machine where this System Center Virtual Machine Manager Virtual Machine Instance is stored. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "scoped_resource_id")

    @scoped_resource_id.setter
    def scoped_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scoped_resource_id", value)

    @property
    @pulumi.getter(name="storageDisks")
    def storage_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceStorageDiskArgs']]]]:
        """
        A `storage_disk` block as defined below.

        > **Note:** This resource will be restarted while updating `storage_disk`.
        """
        return pulumi.get(self, "storage_disks")

    @storage_disks.setter
    def storage_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineManagerVirtualMachineInstanceStorageDiskArgs']]]]):
        pulumi.set(self, "storage_disks", value)

    @property
    @pulumi.getter(name="systemCenterVirtualMachineManagerAvailabilitySetIds")
    def system_center_virtual_machine_manager_availability_set_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of IDs of System Center Virtual Machine Manager Availability Set.
        """
        return pulumi.get(self, "system_center_virtual_machine_manager_availability_set_ids")

    @system_center_virtual_machine_manager_availability_set_ids.setter
    def system_center_virtual_machine_manager_availability_set_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_center_virtual_machine_manager_availability_set_ids", value)


@pulumi.type_token("azure:systemcenter/virtualMachineManagerVirtualMachineInstance:VirtualMachineManagerVirtualMachineInstance")
class VirtualMachineManagerVirtualMachineInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_location_id: Optional[pulumi.Input[builtins.str]] = None,
                 hardware: Optional[pulumi.Input[Union['VirtualMachineManagerVirtualMachineInstanceHardwareArgs', 'VirtualMachineManagerVirtualMachineInstanceHardwareArgsDict']]] = None,
                 infrastructure: Optional[pulumi.Input[Union['VirtualMachineManagerVirtualMachineInstanceInfrastructureArgs', 'VirtualMachineManagerVirtualMachineInstanceInfrastructureArgsDict']]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineManagerVirtualMachineInstanceNetworkInterfaceArgs', 'VirtualMachineManagerVirtualMachineInstanceNetworkInterfaceArgsDict']]]]] = None,
                 operating_system: Optional[pulumi.Input[Union['VirtualMachineManagerVirtualMachineInstanceOperatingSystemArgs', 'VirtualMachineManagerVirtualMachineInstanceOperatingSystemArgsDict']]] = None,
                 scoped_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 storage_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineManagerVirtualMachineInstanceStorageDiskArgs', 'VirtualMachineManagerVirtualMachineInstanceStorageDiskArgsDict']]]]] = None,
                 system_center_virtual_machine_manager_availability_set_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a System Center Virtual Machine Manager Virtual Machine Instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_arc_machine = azure.arcmachine.ArcMachine("example",
            name="example-arcmachine",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            kind="SCVMM")
        example_virtual_machine_manager_server = azure.systemcenter.VirtualMachineManagerServer("example",
            name="example-scvmmms",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            custom_location_id="/subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.ExtendedLocation/customLocations/customLocation1",
            fqdn="example.labtest",
            username="testUser",
            password="H@Sh1CoR3!")
        example = azure.systemcenter.get_virtual_machine_manager_inventory_items_output(inventory_type="Cloud",
            system_center_virtual_machine_manager_server_id=example_virtual_machine_manager_server.id)
        example_virtual_machine_manager_cloud = azure.systemcenter.VirtualMachineManagerCloud("example",
            name="example-scvmmc",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            custom_location_id=example_virtual_machine_manager_server.custom_location_id,
            system_center_virtual_machine_manager_server_inventory_item_id=example.inventory_items[0].id)
        example2 = azure.systemcenter.get_virtual_machine_manager_inventory_items_output(inventory_type="VirtualMachineTemplate",
            system_center_virtual_machine_manager_server_id=example_virtual_machine_manager_server.id)
        example_virtual_machine_manager_virtual_machine_template = azure.systemcenter.VirtualMachineManagerVirtualMachineTemplate("example",
            name="example-scvmmvmt",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            custom_location_id=example_virtual_machine_manager_server.custom_location_id,
            system_center_virtual_machine_manager_server_inventory_item_id=example2.inventory_items[0].id)
        example_virtual_machine_manager_virtual_machine_instance = azure.systemcenter.VirtualMachineManagerVirtualMachineInstance("example",
            scoped_resource_id=example_arc_machine.id,
            custom_location_id=example_virtual_machine_manager_server.custom_location_id,
            infrastructure={
                "system_center_virtual_machine_manager_cloud_id": example_virtual_machine_manager_cloud.id,
                "system_center_virtual_machine_manager_template_id": example_virtual_machine_manager_virtual_machine_template.id,
                "system_center_virtual_machine_manager_virtual_machine_server_id": example_virtual_machine_manager_server.id,
            },
            operating_system={
                "computer_name": "testComputer",
            },
            hardware={
                "cpu_count": 1,
                "memory_in_mb": 1024,
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ScVmm`: 2023-10-07

        ## Import

        System Center Virtual Machine Manager Virtual Machine Instances can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:systemcenter/virtualMachineManagerVirtualMachineInstance:VirtualMachineManagerVirtualMachineInstance example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.HybridCompute/machines/machine1/providers/Microsoft.ScVmm/virtualMachineInstances/default
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] custom_location_id: The ID of the Custom Location for the System Center Virtual Machine Manager Virtual Machine Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['VirtualMachineManagerVirtualMachineInstanceHardwareArgs', 'VirtualMachineManagerVirtualMachineInstanceHardwareArgsDict']] hardware: A `hardware` block as defined below. Changing this forces a new resource to be created.
               
               > **Note:** This resource will be restarted while updating `hardware`.
        :param pulumi.Input[Union['VirtualMachineManagerVirtualMachineInstanceInfrastructureArgs', 'VirtualMachineManagerVirtualMachineInstanceInfrastructureArgsDict']] infrastructure: An `infrastructure` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineManagerVirtualMachineInstanceNetworkInterfaceArgs', 'VirtualMachineManagerVirtualMachineInstanceNetworkInterfaceArgsDict']]]] network_interfaces: A `network_interface` block as defined below.
               
               > **Note:** This resource will be restarted while updating `network_interface`.
        :param pulumi.Input[Union['VirtualMachineManagerVirtualMachineInstanceOperatingSystemArgs', 'VirtualMachineManagerVirtualMachineInstanceOperatingSystemArgsDict']] operating_system: An `operating_system` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] scoped_resource_id: The ID of the Hybrid Compute Machine where this System Center Virtual Machine Manager Virtual Machine Instance is stored. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineManagerVirtualMachineInstanceStorageDiskArgs', 'VirtualMachineManagerVirtualMachineInstanceStorageDiskArgsDict']]]] storage_disks: A `storage_disk` block as defined below.
               
               > **Note:** This resource will be restarted while updating `storage_disk`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] system_center_virtual_machine_manager_availability_set_ids: A list of IDs of System Center Virtual Machine Manager Availability Set.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualMachineManagerVirtualMachineInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a System Center Virtual Machine Manager Virtual Machine Instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_arc_machine = azure.arcmachine.ArcMachine("example",
            name="example-arcmachine",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            kind="SCVMM")
        example_virtual_machine_manager_server = azure.systemcenter.VirtualMachineManagerServer("example",
            name="example-scvmmms",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            custom_location_id="/subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.ExtendedLocation/customLocations/customLocation1",
            fqdn="example.labtest",
            username="testUser",
            password="H@Sh1CoR3!")
        example = azure.systemcenter.get_virtual_machine_manager_inventory_items_output(inventory_type="Cloud",
            system_center_virtual_machine_manager_server_id=example_virtual_machine_manager_server.id)
        example_virtual_machine_manager_cloud = azure.systemcenter.VirtualMachineManagerCloud("example",
            name="example-scvmmc",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            custom_location_id=example_virtual_machine_manager_server.custom_location_id,
            system_center_virtual_machine_manager_server_inventory_item_id=example.inventory_items[0].id)
        example2 = azure.systemcenter.get_virtual_machine_manager_inventory_items_output(inventory_type="VirtualMachineTemplate",
            system_center_virtual_machine_manager_server_id=example_virtual_machine_manager_server.id)
        example_virtual_machine_manager_virtual_machine_template = azure.systemcenter.VirtualMachineManagerVirtualMachineTemplate("example",
            name="example-scvmmvmt",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            custom_location_id=example_virtual_machine_manager_server.custom_location_id,
            system_center_virtual_machine_manager_server_inventory_item_id=example2.inventory_items[0].id)
        example_virtual_machine_manager_virtual_machine_instance = azure.systemcenter.VirtualMachineManagerVirtualMachineInstance("example",
            scoped_resource_id=example_arc_machine.id,
            custom_location_id=example_virtual_machine_manager_server.custom_location_id,
            infrastructure={
                "system_center_virtual_machine_manager_cloud_id": example_virtual_machine_manager_cloud.id,
                "system_center_virtual_machine_manager_template_id": example_virtual_machine_manager_virtual_machine_template.id,
                "system_center_virtual_machine_manager_virtual_machine_server_id": example_virtual_machine_manager_server.id,
            },
            operating_system={
                "computer_name": "testComputer",
            },
            hardware={
                "cpu_count": 1,
                "memory_in_mb": 1024,
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ScVmm`: 2023-10-07

        ## Import

        System Center Virtual Machine Manager Virtual Machine Instances can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:systemcenter/virtualMachineManagerVirtualMachineInstance:VirtualMachineManagerVirtualMachineInstance example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.HybridCompute/machines/machine1/providers/Microsoft.ScVmm/virtualMachineInstances/default
        ```

        :param str resource_name: The name of the resource.
        :param VirtualMachineManagerVirtualMachineInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualMachineManagerVirtualMachineInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_location_id: Optional[pulumi.Input[builtins.str]] = None,
                 hardware: Optional[pulumi.Input[Union['VirtualMachineManagerVirtualMachineInstanceHardwareArgs', 'VirtualMachineManagerVirtualMachineInstanceHardwareArgsDict']]] = None,
                 infrastructure: Optional[pulumi.Input[Union['VirtualMachineManagerVirtualMachineInstanceInfrastructureArgs', 'VirtualMachineManagerVirtualMachineInstanceInfrastructureArgsDict']]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineManagerVirtualMachineInstanceNetworkInterfaceArgs', 'VirtualMachineManagerVirtualMachineInstanceNetworkInterfaceArgsDict']]]]] = None,
                 operating_system: Optional[pulumi.Input[Union['VirtualMachineManagerVirtualMachineInstanceOperatingSystemArgs', 'VirtualMachineManagerVirtualMachineInstanceOperatingSystemArgsDict']]] = None,
                 scoped_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 storage_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineManagerVirtualMachineInstanceStorageDiskArgs', 'VirtualMachineManagerVirtualMachineInstanceStorageDiskArgsDict']]]]] = None,
                 system_center_virtual_machine_manager_availability_set_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualMachineManagerVirtualMachineInstanceArgs.__new__(VirtualMachineManagerVirtualMachineInstanceArgs)

            if custom_location_id is None and not opts.urn:
                raise TypeError("Missing required property 'custom_location_id'")
            __props__.__dict__["custom_location_id"] = custom_location_id
            __props__.__dict__["hardware"] = hardware
            if infrastructure is None and not opts.urn:
                raise TypeError("Missing required property 'infrastructure'")
            __props__.__dict__["infrastructure"] = infrastructure
            __props__.__dict__["network_interfaces"] = network_interfaces
            __props__.__dict__["operating_system"] = operating_system
            if scoped_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'scoped_resource_id'")
            __props__.__dict__["scoped_resource_id"] = scoped_resource_id
            __props__.__dict__["storage_disks"] = storage_disks
            __props__.__dict__["system_center_virtual_machine_manager_availability_set_ids"] = system_center_virtual_machine_manager_availability_set_ids
        super(VirtualMachineManagerVirtualMachineInstance, __self__).__init__(
            'azure:systemcenter/virtualMachineManagerVirtualMachineInstance:VirtualMachineManagerVirtualMachineInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_location_id: Optional[pulumi.Input[builtins.str]] = None,
            hardware: Optional[pulumi.Input[Union['VirtualMachineManagerVirtualMachineInstanceHardwareArgs', 'VirtualMachineManagerVirtualMachineInstanceHardwareArgsDict']]] = None,
            infrastructure: Optional[pulumi.Input[Union['VirtualMachineManagerVirtualMachineInstanceInfrastructureArgs', 'VirtualMachineManagerVirtualMachineInstanceInfrastructureArgsDict']]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineManagerVirtualMachineInstanceNetworkInterfaceArgs', 'VirtualMachineManagerVirtualMachineInstanceNetworkInterfaceArgsDict']]]]] = None,
            operating_system: Optional[pulumi.Input[Union['VirtualMachineManagerVirtualMachineInstanceOperatingSystemArgs', 'VirtualMachineManagerVirtualMachineInstanceOperatingSystemArgsDict']]] = None,
            scoped_resource_id: Optional[pulumi.Input[builtins.str]] = None,
            storage_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineManagerVirtualMachineInstanceStorageDiskArgs', 'VirtualMachineManagerVirtualMachineInstanceStorageDiskArgsDict']]]]] = None,
            system_center_virtual_machine_manager_availability_set_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'VirtualMachineManagerVirtualMachineInstance':
        """
        Get an existing VirtualMachineManagerVirtualMachineInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] custom_location_id: The ID of the Custom Location for the System Center Virtual Machine Manager Virtual Machine Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['VirtualMachineManagerVirtualMachineInstanceHardwareArgs', 'VirtualMachineManagerVirtualMachineInstanceHardwareArgsDict']] hardware: A `hardware` block as defined below. Changing this forces a new resource to be created.
               
               > **Note:** This resource will be restarted while updating `hardware`.
        :param pulumi.Input[Union['VirtualMachineManagerVirtualMachineInstanceInfrastructureArgs', 'VirtualMachineManagerVirtualMachineInstanceInfrastructureArgsDict']] infrastructure: An `infrastructure` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineManagerVirtualMachineInstanceNetworkInterfaceArgs', 'VirtualMachineManagerVirtualMachineInstanceNetworkInterfaceArgsDict']]]] network_interfaces: A `network_interface` block as defined below.
               
               > **Note:** This resource will be restarted while updating `network_interface`.
        :param pulumi.Input[Union['VirtualMachineManagerVirtualMachineInstanceOperatingSystemArgs', 'VirtualMachineManagerVirtualMachineInstanceOperatingSystemArgsDict']] operating_system: An `operating_system` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] scoped_resource_id: The ID of the Hybrid Compute Machine where this System Center Virtual Machine Manager Virtual Machine Instance is stored. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineManagerVirtualMachineInstanceStorageDiskArgs', 'VirtualMachineManagerVirtualMachineInstanceStorageDiskArgsDict']]]] storage_disks: A `storage_disk` block as defined below.
               
               > **Note:** This resource will be restarted while updating `storage_disk`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] system_center_virtual_machine_manager_availability_set_ids: A list of IDs of System Center Virtual Machine Manager Availability Set.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualMachineManagerVirtualMachineInstanceState.__new__(_VirtualMachineManagerVirtualMachineInstanceState)

        __props__.__dict__["custom_location_id"] = custom_location_id
        __props__.__dict__["hardware"] = hardware
        __props__.__dict__["infrastructure"] = infrastructure
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["operating_system"] = operating_system
        __props__.__dict__["scoped_resource_id"] = scoped_resource_id
        __props__.__dict__["storage_disks"] = storage_disks
        __props__.__dict__["system_center_virtual_machine_manager_availability_set_ids"] = system_center_virtual_machine_manager_availability_set_ids
        return VirtualMachineManagerVirtualMachineInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="customLocationId")
    def custom_location_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Custom Location for the System Center Virtual Machine Manager Virtual Machine Instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "custom_location_id")

    @property
    @pulumi.getter
    def hardware(self) -> pulumi.Output[Optional['outputs.VirtualMachineManagerVirtualMachineInstanceHardware']]:
        """
        A `hardware` block as defined below. Changing this forces a new resource to be created.

        > **Note:** This resource will be restarted while updating `hardware`.
        """
        return pulumi.get(self, "hardware")

    @property
    @pulumi.getter
    def infrastructure(self) -> pulumi.Output['outputs.VirtualMachineManagerVirtualMachineInstanceInfrastructure']:
        """
        An `infrastructure` block as defined below.
        """
        return pulumi.get(self, "infrastructure")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.VirtualMachineManagerVirtualMachineInstanceNetworkInterface']]]:
        """
        A `network_interface` block as defined below.

        > **Note:** This resource will be restarted while updating `network_interface`.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> pulumi.Output[Optional['outputs.VirtualMachineManagerVirtualMachineInstanceOperatingSystem']]:
        """
        An `operating_system` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "operating_system")

    @property
    @pulumi.getter(name="scopedResourceId")
    def scoped_resource_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Hybrid Compute Machine where this System Center Virtual Machine Manager Virtual Machine Instance is stored. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "scoped_resource_id")

    @property
    @pulumi.getter(name="storageDisks")
    def storage_disks(self) -> pulumi.Output[Optional[Sequence['outputs.VirtualMachineManagerVirtualMachineInstanceStorageDisk']]]:
        """
        A `storage_disk` block as defined below.

        > **Note:** This resource will be restarted while updating `storage_disk`.
        """
        return pulumi.get(self, "storage_disks")

    @property
    @pulumi.getter(name="systemCenterVirtualMachineManagerAvailabilitySetIds")
    def system_center_virtual_machine_manager_availability_set_ids(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of IDs of System Center Virtual Machine Manager Availability Set.
        """
        return pulumi.get(self, "system_center_virtual_machine_manager_availability_set_ids")

