# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VirtualMachineManagerVirtualMachineInstanceGuestAgentArgs', 'VirtualMachineManagerVirtualMachineInstanceGuestAgent']

@pulumi.input_type
class VirtualMachineManagerVirtualMachineInstanceGuestAgentArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[builtins.str],
                 scoped_resource_id: pulumi.Input[builtins.str],
                 username: pulumi.Input[builtins.str],
                 provisioning_action: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a VirtualMachineManagerVirtualMachineInstanceGuestAgent resource.
        :param pulumi.Input[builtins.str] password: The password that is used to connect to the System Center Virtual Machine Manager Virtual Machine Instance Guest Agent. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] scoped_resource_id: The ID of the Hybrid Compute Machine where this System Center Virtual Machine Manager Virtual Machine Instance Guest Agent is stored. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] username: The username that is used to connect to the System Center Virtual Machine Manager Virtual Machine Instance Guest Agent. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] provisioning_action: The provisioning action that is used to define the different types of operations for the System Center Virtual Machine Manager Virtual Machine Instance Guest Agent. Possible values are `install`, `repair` and `uninstall`. Defaults to `install`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "scoped_resource_id", scoped_resource_id)
        pulumi.set(__self__, "username", username)
        if provisioning_action is not None:
            pulumi.set(__self__, "provisioning_action", provisioning_action)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[builtins.str]:
        """
        The password that is used to connect to the System Center Virtual Machine Manager Virtual Machine Instance Guest Agent. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="scopedResourceId")
    def scoped_resource_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Hybrid Compute Machine where this System Center Virtual Machine Manager Virtual Machine Instance Guest Agent is stored. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "scoped_resource_id")

    @scoped_resource_id.setter
    def scoped_resource_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "scoped_resource_id", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[builtins.str]:
        """
        The username that is used to connect to the System Center Virtual Machine Manager Virtual Machine Instance Guest Agent. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="provisioningAction")
    def provisioning_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The provisioning action that is used to define the different types of operations for the System Center Virtual Machine Manager Virtual Machine Instance Guest Agent. Possible values are `install`, `repair` and `uninstall`. Defaults to `install`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "provisioning_action")

    @provisioning_action.setter
    def provisioning_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "provisioning_action", value)


@pulumi.input_type
class _VirtualMachineManagerVirtualMachineInstanceGuestAgentState:
    def __init__(__self__, *,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 provisioning_action: Optional[pulumi.Input[builtins.str]] = None,
                 scoped_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering VirtualMachineManagerVirtualMachineInstanceGuestAgent resources.
        :param pulumi.Input[builtins.str] password: The password that is used to connect to the System Center Virtual Machine Manager Virtual Machine Instance Guest Agent. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] provisioning_action: The provisioning action that is used to define the different types of operations for the System Center Virtual Machine Manager Virtual Machine Instance Guest Agent. Possible values are `install`, `repair` and `uninstall`. Defaults to `install`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] scoped_resource_id: The ID of the Hybrid Compute Machine where this System Center Virtual Machine Manager Virtual Machine Instance Guest Agent is stored. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] username: The username that is used to connect to the System Center Virtual Machine Manager Virtual Machine Instance Guest Agent. Changing this forces a new resource to be created.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if provisioning_action is not None:
            pulumi.set(__self__, "provisioning_action", provisioning_action)
        if scoped_resource_id is not None:
            pulumi.set(__self__, "scoped_resource_id", scoped_resource_id)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password that is used to connect to the System Center Virtual Machine Manager Virtual Machine Instance Guest Agent. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="provisioningAction")
    def provisioning_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The provisioning action that is used to define the different types of operations for the System Center Virtual Machine Manager Virtual Machine Instance Guest Agent. Possible values are `install`, `repair` and `uninstall`. Defaults to `install`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "provisioning_action")

    @provisioning_action.setter
    def provisioning_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "provisioning_action", value)

    @property
    @pulumi.getter(name="scopedResourceId")
    def scoped_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Hybrid Compute Machine where this System Center Virtual Machine Manager Virtual Machine Instance Guest Agent is stored. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "scoped_resource_id")

    @scoped_resource_id.setter
    def scoped_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scoped_resource_id", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The username that is used to connect to the System Center Virtual Machine Manager Virtual Machine Instance Guest Agent. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("azure:systemcenter/virtualMachineManagerVirtualMachineInstanceGuestAgent:VirtualMachineManagerVirtualMachineInstanceGuestAgent")
class VirtualMachineManagerVirtualMachineInstanceGuestAgent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 provisioning_action: Optional[pulumi.Input[builtins.str]] = None,
                 scoped_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a System Center Virtual Machine Manager Virtual Machine Instance Guest Agent.

        > **Note:** By request of the service team the provider is no longer automatically registering the `Microsoft.ScVmm` Resource Provider for this resource. To register it you can run `az provider register --namespace Microsoft.ScVmm`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_arc_machine = azure.arcmachine.ArcMachine("example",
            name="example-arcmachine",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            kind="SCVMM",
            identity={
                "type": "SystemAssigned",
            })
        example_virtual_machine_manager_server = azure.systemcenter.VirtualMachineManagerServer("example",
            name="example-scvmmms",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            custom_location_id="/subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.ExtendedLocation/customLocations/customLocation1",
            fqdn="example.labtest",
            username="testUser",
            password="H@Sh1CoR3!")
        example = azure.systemcenter.get_virtual_machine_manager_inventory_items_output(inventory_type="Cloud",
            system_center_virtual_machine_manager_server_id=example_virtual_machine_manager_server.id)
        example_virtual_machine_manager_cloud = azure.systemcenter.VirtualMachineManagerCloud("example",
            name="example-scvmmc",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            custom_location_id=example_virtual_machine_manager_server.custom_location_id,
            system_center_virtual_machine_manager_server_inventory_item_id=example.inventory_items[0].id)
        example2 = azure.systemcenter.get_virtual_machine_manager_inventory_items_output(inventory_type="VirtualMachineTemplate",
            system_center_virtual_machine_manager_server_id=example_virtual_machine_manager_server.id)
        example_virtual_machine_manager_virtual_machine_template = azure.systemcenter.VirtualMachineManagerVirtualMachineTemplate("example",
            name="example-scvmmvmt",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            custom_location_id=example_virtual_machine_manager_server.custom_location_id,
            system_center_virtual_machine_manager_server_inventory_item_id=example2.inventory_items[0].id)
        example_virtual_machine_manager_virtual_machine_instance = azure.systemcenter.VirtualMachineManagerVirtualMachineInstance("example",
            scoped_resource_id=example_arc_machine.id,
            custom_location_id=example_virtual_machine_manager_server.custom_location_id,
            infrastructure={
                "checkpoint_type": "Standard",
                "system_center_virtual_machine_manager_cloud_id": example_virtual_machine_manager_cloud.id,
                "system_center_virtual_machine_manager_template_id": example_virtual_machine_manager_virtual_machine_template.id,
                "system_center_virtual_machine_manager_virtual_machine_server_id": example_virtual_machine_manager_server.id,
            },
            operating_system={
                "admin_password": "AdminPassword123!",
            })
        example_virtual_machine_manager_virtual_machine_instance_guest_agent = azure.systemcenter.VirtualMachineManagerVirtualMachineInstanceGuestAgent("example",
            scoped_resource_id=example_arc_machine.id,
            username="Administrator",
            password="AdminPassword123!",
            opts = pulumi.ResourceOptions(depends_on=[example_virtual_machine_manager_virtual_machine_instance]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ScVmm`: 2023-10-07

        ## Import

        System Center Virtual Machine Manager Virtual Machine Instance Guest Agents can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:systemcenter/virtualMachineManagerVirtualMachineInstanceGuestAgent:VirtualMachineManagerVirtualMachineInstanceGuestAgent example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.HybridCompute/machines/machine1/providers/Microsoft.ScVmm/virtualMachineInstances/default/guestAgents/default
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] password: The password that is used to connect to the System Center Virtual Machine Manager Virtual Machine Instance Guest Agent. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] provisioning_action: The provisioning action that is used to define the different types of operations for the System Center Virtual Machine Manager Virtual Machine Instance Guest Agent. Possible values are `install`, `repair` and `uninstall`. Defaults to `install`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] scoped_resource_id: The ID of the Hybrid Compute Machine where this System Center Virtual Machine Manager Virtual Machine Instance Guest Agent is stored. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] username: The username that is used to connect to the System Center Virtual Machine Manager Virtual Machine Instance Guest Agent. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualMachineManagerVirtualMachineInstanceGuestAgentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a System Center Virtual Machine Manager Virtual Machine Instance Guest Agent.

        > **Note:** By request of the service team the provider is no longer automatically registering the `Microsoft.ScVmm` Resource Provider for this resource. To register it you can run `az provider register --namespace Microsoft.ScVmm`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_arc_machine = azure.arcmachine.ArcMachine("example",
            name="example-arcmachine",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            kind="SCVMM",
            identity={
                "type": "SystemAssigned",
            })
        example_virtual_machine_manager_server = azure.systemcenter.VirtualMachineManagerServer("example",
            name="example-scvmmms",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            custom_location_id="/subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.ExtendedLocation/customLocations/customLocation1",
            fqdn="example.labtest",
            username="testUser",
            password="H@Sh1CoR3!")
        example = azure.systemcenter.get_virtual_machine_manager_inventory_items_output(inventory_type="Cloud",
            system_center_virtual_machine_manager_server_id=example_virtual_machine_manager_server.id)
        example_virtual_machine_manager_cloud = azure.systemcenter.VirtualMachineManagerCloud("example",
            name="example-scvmmc",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            custom_location_id=example_virtual_machine_manager_server.custom_location_id,
            system_center_virtual_machine_manager_server_inventory_item_id=example.inventory_items[0].id)
        example2 = azure.systemcenter.get_virtual_machine_manager_inventory_items_output(inventory_type="VirtualMachineTemplate",
            system_center_virtual_machine_manager_server_id=example_virtual_machine_manager_server.id)
        example_virtual_machine_manager_virtual_machine_template = azure.systemcenter.VirtualMachineManagerVirtualMachineTemplate("example",
            name="example-scvmmvmt",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            custom_location_id=example_virtual_machine_manager_server.custom_location_id,
            system_center_virtual_machine_manager_server_inventory_item_id=example2.inventory_items[0].id)
        example_virtual_machine_manager_virtual_machine_instance = azure.systemcenter.VirtualMachineManagerVirtualMachineInstance("example",
            scoped_resource_id=example_arc_machine.id,
            custom_location_id=example_virtual_machine_manager_server.custom_location_id,
            infrastructure={
                "checkpoint_type": "Standard",
                "system_center_virtual_machine_manager_cloud_id": example_virtual_machine_manager_cloud.id,
                "system_center_virtual_machine_manager_template_id": example_virtual_machine_manager_virtual_machine_template.id,
                "system_center_virtual_machine_manager_virtual_machine_server_id": example_virtual_machine_manager_server.id,
            },
            operating_system={
                "admin_password": "AdminPassword123!",
            })
        example_virtual_machine_manager_virtual_machine_instance_guest_agent = azure.systemcenter.VirtualMachineManagerVirtualMachineInstanceGuestAgent("example",
            scoped_resource_id=example_arc_machine.id,
            username="Administrator",
            password="AdminPassword123!",
            opts = pulumi.ResourceOptions(depends_on=[example_virtual_machine_manager_virtual_machine_instance]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ScVmm`: 2023-10-07

        ## Import

        System Center Virtual Machine Manager Virtual Machine Instance Guest Agents can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:systemcenter/virtualMachineManagerVirtualMachineInstanceGuestAgent:VirtualMachineManagerVirtualMachineInstanceGuestAgent example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.HybridCompute/machines/machine1/providers/Microsoft.ScVmm/virtualMachineInstances/default/guestAgents/default
        ```

        :param str resource_name: The name of the resource.
        :param VirtualMachineManagerVirtualMachineInstanceGuestAgentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualMachineManagerVirtualMachineInstanceGuestAgentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 provisioning_action: Optional[pulumi.Input[builtins.str]] = None,
                 scoped_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualMachineManagerVirtualMachineInstanceGuestAgentArgs.__new__(VirtualMachineManagerVirtualMachineInstanceGuestAgentArgs)

            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["provisioning_action"] = provisioning_action
            if scoped_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'scoped_resource_id'")
            __props__.__dict__["scoped_resource_id"] = scoped_resource_id
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(VirtualMachineManagerVirtualMachineInstanceGuestAgent, __self__).__init__(
            'azure:systemcenter/virtualMachineManagerVirtualMachineInstanceGuestAgent:VirtualMachineManagerVirtualMachineInstanceGuestAgent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            password: Optional[pulumi.Input[builtins.str]] = None,
            provisioning_action: Optional[pulumi.Input[builtins.str]] = None,
            scoped_resource_id: Optional[pulumi.Input[builtins.str]] = None,
            username: Optional[pulumi.Input[builtins.str]] = None) -> 'VirtualMachineManagerVirtualMachineInstanceGuestAgent':
        """
        Get an existing VirtualMachineManagerVirtualMachineInstanceGuestAgent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] password: The password that is used to connect to the System Center Virtual Machine Manager Virtual Machine Instance Guest Agent. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] provisioning_action: The provisioning action that is used to define the different types of operations for the System Center Virtual Machine Manager Virtual Machine Instance Guest Agent. Possible values are `install`, `repair` and `uninstall`. Defaults to `install`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] scoped_resource_id: The ID of the Hybrid Compute Machine where this System Center Virtual Machine Manager Virtual Machine Instance Guest Agent is stored. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] username: The username that is used to connect to the System Center Virtual Machine Manager Virtual Machine Instance Guest Agent. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualMachineManagerVirtualMachineInstanceGuestAgentState.__new__(_VirtualMachineManagerVirtualMachineInstanceGuestAgentState)

        __props__.__dict__["password"] = password
        __props__.__dict__["provisioning_action"] = provisioning_action
        __props__.__dict__["scoped_resource_id"] = scoped_resource_id
        __props__.__dict__["username"] = username
        return VirtualMachineManagerVirtualMachineInstanceGuestAgent(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[builtins.str]:
        """
        The password that is used to connect to the System Center Virtual Machine Manager Virtual Machine Instance Guest Agent. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="provisioningAction")
    def provisioning_action(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The provisioning action that is used to define the different types of operations for the System Center Virtual Machine Manager Virtual Machine Instance Guest Agent. Possible values are `install`, `repair` and `uninstall`. Defaults to `install`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "provisioning_action")

    @property
    @pulumi.getter(name="scopedResourceId")
    def scoped_resource_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Hybrid Compute Machine where this System Center Virtual Machine Manager Virtual Machine Instance Guest Agent is stored. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "scoped_resource_id")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[builtins.str]:
        """
        The username that is used to connect to the System Center Virtual Machine Manager Virtual Machine Instance Guest Agent. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "username")

