# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VirtualMachineManagerVirtualMachineTemplateArgs', 'VirtualMachineManagerVirtualMachineTemplate']

@pulumi.input_type
class VirtualMachineManagerVirtualMachineTemplateArgs:
    def __init__(__self__, *,
                 custom_location_id: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 system_center_virtual_machine_manager_server_inventory_item_id: pulumi.Input[builtins.str],
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a VirtualMachineManagerVirtualMachineTemplate resource.
        :param pulumi.Input[builtins.str] custom_location_id: The ID of the Custom Location for the System Center Virtual Machine Manager Virtual Machine Template. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the System Center Virtual Machine Manager Virtual Machine Template should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] system_center_virtual_machine_manager_server_inventory_item_id: The ID of the System Center Virtual Machine Manager Server Inventory Item. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] location: The Azure Region where the System Center Virtual Machine Manager Virtual Machine Template should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the System Center Virtual Machine Manager Virtual Machine Template. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the System Center Virtual Machine Manager Virtual Machine Template.
        """
        pulumi.set(__self__, "custom_location_id", custom_location_id)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "system_center_virtual_machine_manager_server_inventory_item_id", system_center_virtual_machine_manager_server_inventory_item_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="customLocationId")
    def custom_location_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Custom Location for the System Center Virtual Machine Manager Virtual Machine Template. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "custom_location_id")

    @custom_location_id.setter
    def custom_location_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "custom_location_id", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Resource Group where the System Center Virtual Machine Manager Virtual Machine Template should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="systemCenterVirtualMachineManagerServerInventoryItemId")
    def system_center_virtual_machine_manager_server_inventory_item_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the System Center Virtual Machine Manager Server Inventory Item. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "system_center_virtual_machine_manager_server_inventory_item_id")

    @system_center_virtual_machine_manager_server_inventory_item_id.setter
    def system_center_virtual_machine_manager_server_inventory_item_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "system_center_virtual_machine_manager_server_inventory_item_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the System Center Virtual Machine Manager Virtual Machine Template should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the System Center Virtual Machine Manager Virtual Machine Template. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the System Center Virtual Machine Manager Virtual Machine Template.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _VirtualMachineManagerVirtualMachineTemplateState:
    def __init__(__self__, *,
                 custom_location_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 system_center_virtual_machine_manager_server_inventory_item_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering VirtualMachineManagerVirtualMachineTemplate resources.
        :param pulumi.Input[builtins.str] custom_location_id: The ID of the Custom Location for the System Center Virtual Machine Manager Virtual Machine Template. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] location: The Azure Region where the System Center Virtual Machine Manager Virtual Machine Template should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the System Center Virtual Machine Manager Virtual Machine Template. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the System Center Virtual Machine Manager Virtual Machine Template should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] system_center_virtual_machine_manager_server_inventory_item_id: The ID of the System Center Virtual Machine Manager Server Inventory Item. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the System Center Virtual Machine Manager Virtual Machine Template.
        """
        if custom_location_id is not None:
            pulumi.set(__self__, "custom_location_id", custom_location_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if system_center_virtual_machine_manager_server_inventory_item_id is not None:
            pulumi.set(__self__, "system_center_virtual_machine_manager_server_inventory_item_id", system_center_virtual_machine_manager_server_inventory_item_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="customLocationId")
    def custom_location_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Custom Location for the System Center Virtual Machine Manager Virtual Machine Template. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "custom_location_id")

    @custom_location_id.setter
    def custom_location_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_location_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the System Center Virtual Machine Manager Virtual Machine Template should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the System Center Virtual Machine Manager Virtual Machine Template. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Resource Group where the System Center Virtual Machine Manager Virtual Machine Template should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="systemCenterVirtualMachineManagerServerInventoryItemId")
    def system_center_virtual_machine_manager_server_inventory_item_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the System Center Virtual Machine Manager Server Inventory Item. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "system_center_virtual_machine_manager_server_inventory_item_id")

    @system_center_virtual_machine_manager_server_inventory_item_id.setter
    def system_center_virtual_machine_manager_server_inventory_item_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "system_center_virtual_machine_manager_server_inventory_item_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the System Center Virtual Machine Manager Virtual Machine Template.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:systemcenter/virtualMachineManagerVirtualMachineTemplate:VirtualMachineManagerVirtualMachineTemplate")
class VirtualMachineManagerVirtualMachineTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_location_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 system_center_virtual_machine_manager_server_inventory_item_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a System Center Virtual Machine Manager Virtual Machine Template.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_machine_manager_server = azure.systemcenter.VirtualMachineManagerServer("example",
            name="example-scvmmms",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            custom_location_id="/subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.ExtendedLocation/customLocations/customLocation1",
            fqdn="example.labtest",
            username="testUser",
            password="H@Sh1CoR3!")
        example = azure.systemcenter.get_virtual_machine_manager_inventory_items_output(inventory_type="VirtualMachineTemplate",
            system_center_virtual_machine_manager_server_id=example_virtual_machine_manager_server.id)
        example_virtual_machine_manager_virtual_machine_template = azure.systemcenter.VirtualMachineManagerVirtualMachineTemplate("example",
            name="example-scvmmvmtemplate",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            custom_location_id=example_virtual_machine_manager_server.custom_location_id,
            system_center_virtual_machine_manager_server_inventory_item_id=example.inventory_items[0].id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ScVmm`: 2023-10-07

        ## Import

        System Center Virtual Machine Manager Virtual Machine Templates can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:systemcenter/virtualMachineManagerVirtualMachineTemplate:VirtualMachineManagerVirtualMachineTemplate example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.ScVmm/virtualMachineTemplates/virtualMachineTemplate1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] custom_location_id: The ID of the Custom Location for the System Center Virtual Machine Manager Virtual Machine Template. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] location: The Azure Region where the System Center Virtual Machine Manager Virtual Machine Template should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the System Center Virtual Machine Manager Virtual Machine Template. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the System Center Virtual Machine Manager Virtual Machine Template should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] system_center_virtual_machine_manager_server_inventory_item_id: The ID of the System Center Virtual Machine Manager Server Inventory Item. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the System Center Virtual Machine Manager Virtual Machine Template.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualMachineManagerVirtualMachineTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a System Center Virtual Machine Manager Virtual Machine Template.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_machine_manager_server = azure.systemcenter.VirtualMachineManagerServer("example",
            name="example-scvmmms",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            custom_location_id="/subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.ExtendedLocation/customLocations/customLocation1",
            fqdn="example.labtest",
            username="testUser",
            password="H@Sh1CoR3!")
        example = azure.systemcenter.get_virtual_machine_manager_inventory_items_output(inventory_type="VirtualMachineTemplate",
            system_center_virtual_machine_manager_server_id=example_virtual_machine_manager_server.id)
        example_virtual_machine_manager_virtual_machine_template = azure.systemcenter.VirtualMachineManagerVirtualMachineTemplate("example",
            name="example-scvmmvmtemplate",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            custom_location_id=example_virtual_machine_manager_server.custom_location_id,
            system_center_virtual_machine_manager_server_inventory_item_id=example.inventory_items[0].id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ScVmm`: 2023-10-07

        ## Import

        System Center Virtual Machine Manager Virtual Machine Templates can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:systemcenter/virtualMachineManagerVirtualMachineTemplate:VirtualMachineManagerVirtualMachineTemplate example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.ScVmm/virtualMachineTemplates/virtualMachineTemplate1
        ```

        :param str resource_name: The name of the resource.
        :param VirtualMachineManagerVirtualMachineTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualMachineManagerVirtualMachineTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_location_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 system_center_virtual_machine_manager_server_inventory_item_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualMachineManagerVirtualMachineTemplateArgs.__new__(VirtualMachineManagerVirtualMachineTemplateArgs)

            if custom_location_id is None and not opts.urn:
                raise TypeError("Missing required property 'custom_location_id'")
            __props__.__dict__["custom_location_id"] = custom_location_id
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if system_center_virtual_machine_manager_server_inventory_item_id is None and not opts.urn:
                raise TypeError("Missing required property 'system_center_virtual_machine_manager_server_inventory_item_id'")
            __props__.__dict__["system_center_virtual_machine_manager_server_inventory_item_id"] = system_center_virtual_machine_manager_server_inventory_item_id
            __props__.__dict__["tags"] = tags
        super(VirtualMachineManagerVirtualMachineTemplate, __self__).__init__(
            'azure:systemcenter/virtualMachineManagerVirtualMachineTemplate:VirtualMachineManagerVirtualMachineTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_location_id: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            system_center_virtual_machine_manager_server_inventory_item_id: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'VirtualMachineManagerVirtualMachineTemplate':
        """
        Get an existing VirtualMachineManagerVirtualMachineTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] custom_location_id: The ID of the Custom Location for the System Center Virtual Machine Manager Virtual Machine Template. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] location: The Azure Region where the System Center Virtual Machine Manager Virtual Machine Template should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the System Center Virtual Machine Manager Virtual Machine Template. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the System Center Virtual Machine Manager Virtual Machine Template should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] system_center_virtual_machine_manager_server_inventory_item_id: The ID of the System Center Virtual Machine Manager Server Inventory Item. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the System Center Virtual Machine Manager Virtual Machine Template.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualMachineManagerVirtualMachineTemplateState.__new__(_VirtualMachineManagerVirtualMachineTemplateState)

        __props__.__dict__["custom_location_id"] = custom_location_id
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["system_center_virtual_machine_manager_server_inventory_item_id"] = system_center_virtual_machine_manager_server_inventory_item_id
        __props__.__dict__["tags"] = tags
        return VirtualMachineManagerVirtualMachineTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="customLocationId")
    def custom_location_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Custom Location for the System Center Virtual Machine Manager Virtual Machine Template. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "custom_location_id")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The Azure Region where the System Center Virtual Machine Manager Virtual Machine Template should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the System Center Virtual Machine Manager Virtual Machine Template. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Resource Group where the System Center Virtual Machine Manager Virtual Machine Template should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="systemCenterVirtualMachineManagerServerInventoryItemId")
    def system_center_virtual_machine_manager_server_inventory_item_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the System Center Virtual Machine Manager Server Inventory Item. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "system_center_virtual_machine_manager_server_inventory_item_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags which should be assigned to the System Center Virtual Machine Manager Virtual Machine Template.
        """
        return pulumi.get(self, "tags")

