# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AccountIdentityArgs',
    'AccountIdentityArgsDict',
    'AccountStorageArgs',
    'AccountStorageArgsDict',
]

MYPY = False

if not MYPY:
    class AccountIdentityArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        Specifies the identity type of the Video Indexer Account. Possible values are `SystemAssigned` (where Azure will generate a Service Principal for you), `UserAssigned` where you can specify the Service Principal IDs in the `identity_ids` field, and `SystemAssigned, UserAssigned` which assigns both a system managed identity as well as the specified user assigned identities.
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Specifies a list of user managed identity ids to be assigned. Required if `type` is `UserAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[builtins.str]]
        tenant_id: NotRequired[pulumi.Input[builtins.str]]
elif False:
    AccountIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] type: Specifies the identity type of the Video Indexer Account. Possible values are `SystemAssigned` (where Azure will generate a Service Principal for you), `UserAssigned` where you can specify the Service Principal IDs in the `identity_ids` field, and `SystemAssigned, UserAssigned` which assigns both a system managed identity as well as the specified user assigned identities.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] identity_ids: Specifies a list of user managed identity ids to be assigned. Required if `type` is `UserAssigned`.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the identity type of the Video Indexer Account. Possible values are `SystemAssigned` (where Azure will generate a Service Principal for you), `UserAssigned` where you can specify the Service Principal IDs in the `identity_ids` field, and `SystemAssigned, UserAssigned` which assigns both a system managed identity as well as the specified user assigned identities.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of user managed identity ids to be assigned. Required if `type` is `UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class AccountStorageArgsDict(TypedDict):
        storage_account_id: pulumi.Input[builtins.str]
        """
        The ID of the storage account to be associated with the Video Indexer Account. Changing this forces a new Video Indexer Account to be created.
        """
        user_assigned_identity_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The reference to the user assigned identity to use to access the Storage Account.
        """
elif False:
    AccountStorageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountStorageArgs:
    def __init__(__self__, *,
                 storage_account_id: pulumi.Input[builtins.str],
                 user_assigned_identity_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] storage_account_id: The ID of the storage account to be associated with the Video Indexer Account. Changing this forces a new Video Indexer Account to be created.
        :param pulumi.Input[builtins.str] user_assigned_identity_id: The reference to the user assigned identity to use to access the Storage Account.
        """
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        if user_assigned_identity_id is not None:
            pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the storage account to be associated with the Video Indexer Account. Changing this forces a new Video Indexer Account to be created.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "storage_account_id", value)

    @property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The reference to the user assigned identity to use to access the Storage Account.
        """
        return pulumi.get(self, "user_assigned_identity_id")

    @user_assigned_identity_id.setter
    def user_assigned_identity_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_assigned_identity_id", value)


