# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ServicesCommunicationsGatewayServiceLocationArgs',
    'ServicesCommunicationsGatewayServiceLocationArgsDict',
]

MYPY = False

if not MYPY:
    class ServicesCommunicationsGatewayServiceLocationArgsDict(TypedDict):
        location: pulumi.Input[builtins.str]
        """
        Specifies the region in which the resources needed for Teams Calling will be deployed.
        """
        operator_addresses: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        IP address to use to contact the operator network from this region.
        """
        allowed_media_source_address_prefixes: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Specifies the allowed source IP address or CIDR ranges for media.
        """
        allowed_signaling_source_address_prefixes: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Specifies the allowed source IP address or CIDR ranges for signaling.
        """
        esrp_addresses: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        IP address to use to contact the ESRP from this region.

        !> **Note:** The `esrp_addresses` must be specified for each `service_location` when the`e911_type` is set to `DirectToEsrp`.  The `esrp_addresses` must not be specified for each `service_location` when the`e911_type` is set to `Standard`.
        """
elif False:
    ServicesCommunicationsGatewayServiceLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServicesCommunicationsGatewayServiceLocationArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[builtins.str],
                 operator_addresses: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 allowed_media_source_address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 allowed_signaling_source_address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 esrp_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] location: Specifies the region in which the resources needed for Teams Calling will be deployed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] operator_addresses: IP address to use to contact the operator network from this region.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_media_source_address_prefixes: Specifies the allowed source IP address or CIDR ranges for media.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_signaling_source_address_prefixes: Specifies the allowed source IP address or CIDR ranges for signaling.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] esrp_addresses: IP address to use to contact the ESRP from this region.
               
               !> **Note:** The `esrp_addresses` must be specified for each `service_location` when the`e911_type` is set to `DirectToEsrp`.  The `esrp_addresses` must not be specified for each `service_location` when the`e911_type` is set to `Standard`.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "operator_addresses", operator_addresses)
        if allowed_media_source_address_prefixes is not None:
            pulumi.set(__self__, "allowed_media_source_address_prefixes", allowed_media_source_address_prefixes)
        if allowed_signaling_source_address_prefixes is not None:
            pulumi.set(__self__, "allowed_signaling_source_address_prefixes", allowed_signaling_source_address_prefixes)
        if esrp_addresses is not None:
            pulumi.set(__self__, "esrp_addresses", esrp_addresses)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the region in which the resources needed for Teams Calling will be deployed.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="operatorAddresses")
    def operator_addresses(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        IP address to use to contact the operator network from this region.
        """
        return pulumi.get(self, "operator_addresses")

    @operator_addresses.setter
    def operator_addresses(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "operator_addresses", value)

    @property
    @pulumi.getter(name="allowedMediaSourceAddressPrefixes")
    def allowed_media_source_address_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies the allowed source IP address or CIDR ranges for media.
        """
        return pulumi.get(self, "allowed_media_source_address_prefixes")

    @allowed_media_source_address_prefixes.setter
    def allowed_media_source_address_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_media_source_address_prefixes", value)

    @property
    @pulumi.getter(name="allowedSignalingSourceAddressPrefixes")
    def allowed_signaling_source_address_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies the allowed source IP address or CIDR ranges for signaling.
        """
        return pulumi.get(self, "allowed_signaling_source_address_prefixes")

    @allowed_signaling_source_address_prefixes.setter
    def allowed_signaling_source_address_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_signaling_source_address_prefixes", value)

    @property
    @pulumi.getter(name="esrpAddresses")
    def esrp_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        IP address to use to contact the ESRP from this region.

        !> **Note:** The `esrp_addresses` must be specified for each `service_location` when the`e911_type` is set to `DirectToEsrp`.  The `esrp_addresses` must not be specified for each `service_location` when the`e911_type` is set to `Standard`.
        """
        return pulumi.get(self, "esrp_addresses")

    @esrp_addresses.setter
    def esrp_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "esrp_addresses", value)


