# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ServicesCommunicationsGatewayTestLineArgs', 'ServicesCommunicationsGatewayTestLine']

@pulumi.input_type
class ServicesCommunicationsGatewayTestLineArgs:
    def __init__(__self__, *,
                 phone_number: pulumi.Input[builtins.str],
                 purpose: pulumi.Input[builtins.str],
                 voice_services_communications_gateway_id: pulumi.Input[builtins.str],
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a ServicesCommunicationsGatewayTestLine resource.
        :param pulumi.Input[builtins.str] phone_number: Specifies the phone number.
        :param pulumi.Input[builtins.str] purpose: The purpose of the Voice Services Communications Gateway Test Line. Possible values are `Automated` or `Manual`.
        :param pulumi.Input[builtins.str] voice_services_communications_gateway_id: Specifies the ID of the Voice Services Communications Gateway. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the Voice Services Communications Gateway Test Line should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Voice Services Communications Gateway Test Line. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Voice Services Communications Gateway Test Line.
        """
        pulumi.set(__self__, "phone_number", phone_number)
        pulumi.set(__self__, "purpose", purpose)
        pulumi.set(__self__, "voice_services_communications_gateway_id", voice_services_communications_gateway_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the phone number.
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "phone_number", value)

    @property
    @pulumi.getter
    def purpose(self) -> pulumi.Input[builtins.str]:
        """
        The purpose of the Voice Services Communications Gateway Test Line. Possible values are `Automated` or `Manual`.
        """
        return pulumi.get(self, "purpose")

    @purpose.setter
    def purpose(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "purpose", value)

    @property
    @pulumi.getter(name="voiceServicesCommunicationsGatewayId")
    def voice_services_communications_gateway_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the ID of the Voice Services Communications Gateway. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "voice_services_communications_gateway_id")

    @voice_services_communications_gateway_id.setter
    def voice_services_communications_gateway_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "voice_services_communications_gateway_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Azure Region where the Voice Services Communications Gateway Test Line should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name which should be used for this Voice Services Communications Gateway Test Line. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Voice Services Communications Gateway Test Line.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ServicesCommunicationsGatewayTestLineState:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 phone_number: Optional[pulumi.Input[builtins.str]] = None,
                 purpose: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 voice_services_communications_gateway_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServicesCommunicationsGatewayTestLine resources.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the Voice Services Communications Gateway Test Line should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Voice Services Communications Gateway Test Line. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] phone_number: Specifies the phone number.
        :param pulumi.Input[builtins.str] purpose: The purpose of the Voice Services Communications Gateway Test Line. Possible values are `Automated` or `Manual`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Voice Services Communications Gateway Test Line.
        :param pulumi.Input[builtins.str] voice_services_communications_gateway_id: Specifies the ID of the Voice Services Communications Gateway. Changing this forces a new resource to be created.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)
        if purpose is not None:
            pulumi.set(__self__, "purpose", purpose)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if voice_services_communications_gateway_id is not None:
            pulumi.set(__self__, "voice_services_communications_gateway_id", voice_services_communications_gateway_id)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Azure Region where the Voice Services Communications Gateway Test Line should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name which should be used for this Voice Services Communications Gateway Test Line. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the phone number.
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "phone_number", value)

    @property
    @pulumi.getter
    def purpose(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The purpose of the Voice Services Communications Gateway Test Line. Possible values are `Automated` or `Manual`.
        """
        return pulumi.get(self, "purpose")

    @purpose.setter
    def purpose(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "purpose", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Voice Services Communications Gateway Test Line.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="voiceServicesCommunicationsGatewayId")
    def voice_services_communications_gateway_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the ID of the Voice Services Communications Gateway. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "voice_services_communications_gateway_id")

    @voice_services_communications_gateway_id.setter
    def voice_services_communications_gateway_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "voice_services_communications_gateway_id", value)


@pulumi.type_token("azure:voice/servicesCommunicationsGatewayTestLine:ServicesCommunicationsGatewayTestLine")
class ServicesCommunicationsGatewayTestLine(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 phone_number: Optional[pulumi.Input[builtins.str]] = None,
                 purpose: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 voice_services_communications_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Voice Services Communications Gateway Test Line.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Central US")
        example_services_communications_gateway = azure.voice.ServicesCommunicationsGateway("example",
            name="example-vcg",
            resource_group_name=example.name)
        example_services_communications_gateway_test_line = azure.voice.ServicesCommunicationsGatewayTestLine("example",
            name="example-vtl",
            location="West Central US",
            voice_services_communications_gateway_id=example_services_communications_gateway.id,
            phone_number="123456789",
            purpose="Automated",
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.VoiceServices`: 2023-04-03

        ## Import

        Voice Services Communications Gateway Test Line can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:voice/servicesCommunicationsGatewayTestLine:ServicesCommunicationsGatewayTestLine example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.VoiceServices/communicationsGateways/communicationsGateway1/testLines/testLine1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the Voice Services Communications Gateway Test Line should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Voice Services Communications Gateway Test Line. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] phone_number: Specifies the phone number.
        :param pulumi.Input[builtins.str] purpose: The purpose of the Voice Services Communications Gateway Test Line. Possible values are `Automated` or `Manual`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Voice Services Communications Gateway Test Line.
        :param pulumi.Input[builtins.str] voice_services_communications_gateway_id: Specifies the ID of the Voice Services Communications Gateway. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServicesCommunicationsGatewayTestLineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Voice Services Communications Gateway Test Line.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Central US")
        example_services_communications_gateway = azure.voice.ServicesCommunicationsGateway("example",
            name="example-vcg",
            resource_group_name=example.name)
        example_services_communications_gateway_test_line = azure.voice.ServicesCommunicationsGatewayTestLine("example",
            name="example-vtl",
            location="West Central US",
            voice_services_communications_gateway_id=example_services_communications_gateway.id,
            phone_number="123456789",
            purpose="Automated",
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.VoiceServices`: 2023-04-03

        ## Import

        Voice Services Communications Gateway Test Line can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:voice/servicesCommunicationsGatewayTestLine:ServicesCommunicationsGatewayTestLine example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.VoiceServices/communicationsGateways/communicationsGateway1/testLines/testLine1
        ```

        :param str resource_name: The name of the resource.
        :param ServicesCommunicationsGatewayTestLineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServicesCommunicationsGatewayTestLineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 phone_number: Optional[pulumi.Input[builtins.str]] = None,
                 purpose: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 voice_services_communications_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServicesCommunicationsGatewayTestLineArgs.__new__(ServicesCommunicationsGatewayTestLineArgs)

            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if phone_number is None and not opts.urn:
                raise TypeError("Missing required property 'phone_number'")
            __props__.__dict__["phone_number"] = phone_number
            if purpose is None and not opts.urn:
                raise TypeError("Missing required property 'purpose'")
            __props__.__dict__["purpose"] = purpose
            __props__.__dict__["tags"] = tags
            if voice_services_communications_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'voice_services_communications_gateway_id'")
            __props__.__dict__["voice_services_communications_gateway_id"] = voice_services_communications_gateway_id
        super(ServicesCommunicationsGatewayTestLine, __self__).__init__(
            'azure:voice/servicesCommunicationsGatewayTestLine:ServicesCommunicationsGatewayTestLine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            phone_number: Optional[pulumi.Input[builtins.str]] = None,
            purpose: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            voice_services_communications_gateway_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ServicesCommunicationsGatewayTestLine':
        """
        Get an existing ServicesCommunicationsGatewayTestLine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the Voice Services Communications Gateway Test Line should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Voice Services Communications Gateway Test Line. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] phone_number: Specifies the phone number.
        :param pulumi.Input[builtins.str] purpose: The purpose of the Voice Services Communications Gateway Test Line. Possible values are `Automated` or `Manual`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Voice Services Communications Gateway Test Line.
        :param pulumi.Input[builtins.str] voice_services_communications_gateway_id: Specifies the ID of the Voice Services Communications Gateway. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServicesCommunicationsGatewayTestLineState.__new__(_ServicesCommunicationsGatewayTestLineState)

        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["phone_number"] = phone_number
        __props__.__dict__["purpose"] = purpose
        __props__.__dict__["tags"] = tags
        __props__.__dict__["voice_services_communications_gateway_id"] = voice_services_communications_gateway_id
        return ServicesCommunicationsGatewayTestLine(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Azure Region where the Voice Services Communications Gateway Test Line should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name which should be used for this Voice Services Communications Gateway Test Line. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the phone number.
        """
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter
    def purpose(self) -> pulumi.Output[builtins.str]:
        """
        The purpose of the Voice Services Communications Gateway Test Line. Possible values are `Automated` or `Manual`.
        """
        return pulumi.get(self, "purpose")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Voice Services Communications Gateway Test Line.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="voiceServicesCommunicationsGatewayId")
    def voice_services_communications_gateway_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the ID of the Voice Services Communications Gateway. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "voice_services_communications_gateway_id")

