# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'HubEventHandlerArgs',
    'HubEventHandlerArgsDict',
    'HubEventHandlerAuthArgs',
    'HubEventHandlerAuthArgsDict',
    'HubEventListenerArgs',
    'HubEventListenerArgsDict',
    'NetworkAclPrivateEndpointArgs',
    'NetworkAclPrivateEndpointArgsDict',
    'NetworkAclPublicNetworkArgs',
    'NetworkAclPublicNetworkArgsDict',
    'ServiceIdentityArgs',
    'ServiceIdentityArgsDict',
    'ServiceLiveTraceArgs',
    'ServiceLiveTraceArgsDict',
    'SocketioIdentityArgs',
    'SocketioIdentityArgsDict',
    'SocketioSkuArgs',
    'SocketioSkuArgsDict',
]

MYPY = False

if not MYPY:
    class HubEventHandlerArgsDict(TypedDict):
        url_template: pulumi.Input[builtins.str]
        """
        The Event Handler URL Template. Two predefined parameters `{hub}` and `{event}` are available to use in the template. The value of the EventHandler URL is dynamically calculated when the client request comes in. Example: `http://example.com/api/{hub}/{event}`.
        """
        auth: NotRequired[pulumi.Input['HubEventHandlerAuthArgsDict']]
        """
        An `auth` block as defined below.
        """
        system_events: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Specifies the list of system events. Supported values are `connect`, `connected` and `disconnected`.
        """
        user_event_pattern: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the matching event names. There are 3 kind of patterns supported: * `*` matches any event name * `,` Combine multiple events with `,` for example `event1,event2`, it matches event `event1` and `event2` * The single event name, for example `event1`, it matches `event1`.
        """
elif False:
    HubEventHandlerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HubEventHandlerArgs:
    def __init__(__self__, *,
                 url_template: pulumi.Input[builtins.str],
                 auth: Optional[pulumi.Input['HubEventHandlerAuthArgs']] = None,
                 system_events: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user_event_pattern: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] url_template: The Event Handler URL Template. Two predefined parameters `{hub}` and `{event}` are available to use in the template. The value of the EventHandler URL is dynamically calculated when the client request comes in. Example: `http://example.com/api/{hub}/{event}`.
        :param pulumi.Input['HubEventHandlerAuthArgs'] auth: An `auth` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] system_events: Specifies the list of system events. Supported values are `connect`, `connected` and `disconnected`.
        :param pulumi.Input[builtins.str] user_event_pattern: Specifies the matching event names. There are 3 kind of patterns supported: * `*` matches any event name * `,` Combine multiple events with `,` for example `event1,event2`, it matches event `event1` and `event2` * The single event name, for example `event1`, it matches `event1`.
        """
        pulumi.set(__self__, "url_template", url_template)
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if system_events is not None:
            pulumi.set(__self__, "system_events", system_events)
        if user_event_pattern is not None:
            pulumi.set(__self__, "user_event_pattern", user_event_pattern)

    @property
    @pulumi.getter(name="urlTemplate")
    def url_template(self) -> pulumi.Input[builtins.str]:
        """
        The Event Handler URL Template. Two predefined parameters `{hub}` and `{event}` are available to use in the template. The value of the EventHandler URL is dynamically calculated when the client request comes in. Example: `http://example.com/api/{hub}/{event}`.
        """
        return pulumi.get(self, "url_template")

    @url_template.setter
    def url_template(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "url_template", value)

    @property
    @pulumi.getter
    def auth(self) -> Optional[pulumi.Input['HubEventHandlerAuthArgs']]:
        """
        An `auth` block as defined below.
        """
        return pulumi.get(self, "auth")

    @auth.setter
    def auth(self, value: Optional[pulumi.Input['HubEventHandlerAuthArgs']]):
        pulumi.set(self, "auth", value)

    @property
    @pulumi.getter(name="systemEvents")
    def system_events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies the list of system events. Supported values are `connect`, `connected` and `disconnected`.
        """
        return pulumi.get(self, "system_events")

    @system_events.setter
    def system_events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_events", value)

    @property
    @pulumi.getter(name="userEventPattern")
    def user_event_pattern(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the matching event names. There are 3 kind of patterns supported: * `*` matches any event name * `,` Combine multiple events with `,` for example `event1,event2`, it matches event `event1` and `event2` * The single event name, for example `event1`, it matches `event1`.
        """
        return pulumi.get(self, "user_event_pattern")

    @user_event_pattern.setter
    def user_event_pattern(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_event_pattern", value)


if not MYPY:
    class HubEventHandlerAuthArgsDict(TypedDict):
        managed_identity_id: pulumi.Input[builtins.str]
        """
        Specify the identity ID of the target resource.

        > **Note:** `managed_identity_id` is required if the auth block is defined
        """
elif False:
    HubEventHandlerAuthArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HubEventHandlerAuthArgs:
    def __init__(__self__, *,
                 managed_identity_id: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] managed_identity_id: Specify the identity ID of the target resource.
               
               > **Note:** `managed_identity_id` is required if the auth block is defined
        """
        pulumi.set(__self__, "managed_identity_id", managed_identity_id)

    @property
    @pulumi.getter(name="managedIdentityId")
    def managed_identity_id(self) -> pulumi.Input[builtins.str]:
        """
        Specify the identity ID of the target resource.

        > **Note:** `managed_identity_id` is required if the auth block is defined
        """
        return pulumi.get(self, "managed_identity_id")

    @managed_identity_id.setter
    def managed_identity_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "managed_identity_id", value)


if not MYPY:
    class HubEventListenerArgsDict(TypedDict):
        eventhub_name: pulumi.Input[builtins.str]
        """
        Specifies the event hub name to receive the events.
        """
        eventhub_namespace_name: pulumi.Input[builtins.str]
        """
        Specifies the event hub namespace name to receive the events.
        """
        system_event_name_filters: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Specifies the list of system events. Supported values are `connected` and `disconnected`.
        """
        user_event_name_filters: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Specifies the list of matching user event names. `["*"]` can be used to match all events.
        """
elif False:
    HubEventListenerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HubEventListenerArgs:
    def __init__(__self__, *,
                 eventhub_name: pulumi.Input[builtins.str],
                 eventhub_namespace_name: pulumi.Input[builtins.str],
                 system_event_name_filters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user_event_name_filters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] eventhub_name: Specifies the event hub name to receive the events.
        :param pulumi.Input[builtins.str] eventhub_namespace_name: Specifies the event hub namespace name to receive the events.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] system_event_name_filters: Specifies the list of system events. Supported values are `connected` and `disconnected`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] user_event_name_filters: Specifies the list of matching user event names. `["*"]` can be used to match all events.
        """
        pulumi.set(__self__, "eventhub_name", eventhub_name)
        pulumi.set(__self__, "eventhub_namespace_name", eventhub_namespace_name)
        if system_event_name_filters is not None:
            pulumi.set(__self__, "system_event_name_filters", system_event_name_filters)
        if user_event_name_filters is not None:
            pulumi.set(__self__, "user_event_name_filters", user_event_name_filters)

    @property
    @pulumi.getter(name="eventhubName")
    def eventhub_name(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the event hub name to receive the events.
        """
        return pulumi.get(self, "eventhub_name")

    @eventhub_name.setter
    def eventhub_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "eventhub_name", value)

    @property
    @pulumi.getter(name="eventhubNamespaceName")
    def eventhub_namespace_name(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the event hub namespace name to receive the events.
        """
        return pulumi.get(self, "eventhub_namespace_name")

    @eventhub_namespace_name.setter
    def eventhub_namespace_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "eventhub_namespace_name", value)

    @property
    @pulumi.getter(name="systemEventNameFilters")
    def system_event_name_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies the list of system events. Supported values are `connected` and `disconnected`.
        """
        return pulumi.get(self, "system_event_name_filters")

    @system_event_name_filters.setter
    def system_event_name_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_event_name_filters", value)

    @property
    @pulumi.getter(name="userEventNameFilters")
    def user_event_name_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies the list of matching user event names. `["*"]` can be used to match all events.
        """
        return pulumi.get(self, "user_event_name_filters")

    @user_event_name_filters.setter
    def user_event_name_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "user_event_name_filters", value)


if not MYPY:
    class NetworkAclPrivateEndpointArgsDict(TypedDict):
        id: pulumi.Input[builtins.str]
        """
        The ID of the Private Endpoint which is based on the Web Pubsub service.
        """
        allowed_request_types: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The allowed request types for the Private Endpoint Connection. Possible values are `ClientConnection`, `ServerConnection`, `RESTAPI` and `Trace`.
        """
        denied_request_types: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The denied request types for the Private Endpoint Connection. Possible values are `ClientConnection`, `ServerConnection`, `RESTAPI` and `Trace`.

        > **Note:** When `default_action` is `Allow`, `allowed_request_types`cannot be set. When `default_action` is `Deny`, `denied_request_types`cannot be set.
        """
elif False:
    NetworkAclPrivateEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkAclPrivateEndpointArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[builtins.str],
                 allowed_request_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 denied_request_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] id: The ID of the Private Endpoint which is based on the Web Pubsub service.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_request_types: The allowed request types for the Private Endpoint Connection. Possible values are `ClientConnection`, `ServerConnection`, `RESTAPI` and `Trace`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] denied_request_types: The denied request types for the Private Endpoint Connection. Possible values are `ClientConnection`, `ServerConnection`, `RESTAPI` and `Trace`.
               
               > **Note:** When `default_action` is `Allow`, `allowed_request_types`cannot be set. When `default_action` is `Deny`, `denied_request_types`cannot be set.
        """
        pulumi.set(__self__, "id", id)
        if allowed_request_types is not None:
            pulumi.set(__self__, "allowed_request_types", allowed_request_types)
        if denied_request_types is not None:
            pulumi.set(__self__, "denied_request_types", denied_request_types)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Private Endpoint which is based on the Web Pubsub service.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="allowedRequestTypes")
    def allowed_request_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The allowed request types for the Private Endpoint Connection. Possible values are `ClientConnection`, `ServerConnection`, `RESTAPI` and `Trace`.
        """
        return pulumi.get(self, "allowed_request_types")

    @allowed_request_types.setter
    def allowed_request_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_request_types", value)

    @property
    @pulumi.getter(name="deniedRequestTypes")
    def denied_request_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The denied request types for the Private Endpoint Connection. Possible values are `ClientConnection`, `ServerConnection`, `RESTAPI` and `Trace`.

        > **Note:** When `default_action` is `Allow`, `allowed_request_types`cannot be set. When `default_action` is `Deny`, `denied_request_types`cannot be set.
        """
        return pulumi.get(self, "denied_request_types")

    @denied_request_types.setter
    def denied_request_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "denied_request_types", value)


if not MYPY:
    class NetworkAclPublicNetworkArgsDict(TypedDict):
        allowed_request_types: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The allowed request types for the public network. Possible values are `ClientConnection`, `ServerConnection`, `RESTAPI` and `Trace`.
        """
        denied_request_types: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The denied request types for the public network. Possible values are `ClientConnection`, `ServerConnection`, `RESTAPI` and `Trace`.

        > **Note:** When `default_action` is `Allow`, `allowed_request_types`cannot be set. When `default_action` is `Deny`, `denied_request_types`cannot be set.
        """
elif False:
    NetworkAclPublicNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkAclPublicNetworkArgs:
    def __init__(__self__, *,
                 allowed_request_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 denied_request_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_request_types: The allowed request types for the public network. Possible values are `ClientConnection`, `ServerConnection`, `RESTAPI` and `Trace`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] denied_request_types: The denied request types for the public network. Possible values are `ClientConnection`, `ServerConnection`, `RESTAPI` and `Trace`.
               
               > **Note:** When `default_action` is `Allow`, `allowed_request_types`cannot be set. When `default_action` is `Deny`, `denied_request_types`cannot be set.
        """
        if allowed_request_types is not None:
            pulumi.set(__self__, "allowed_request_types", allowed_request_types)
        if denied_request_types is not None:
            pulumi.set(__self__, "denied_request_types", denied_request_types)

    @property
    @pulumi.getter(name="allowedRequestTypes")
    def allowed_request_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The allowed request types for the public network. Possible values are `ClientConnection`, `ServerConnection`, `RESTAPI` and `Trace`.
        """
        return pulumi.get(self, "allowed_request_types")

    @allowed_request_types.setter
    def allowed_request_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_request_types", value)

    @property
    @pulumi.getter(name="deniedRequestTypes")
    def denied_request_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The denied request types for the public network. Possible values are `ClientConnection`, `ServerConnection`, `RESTAPI` and `Trace`.

        > **Note:** When `default_action` is `Allow`, `allowed_request_types`cannot be set. When `default_action` is `Deny`, `denied_request_types`cannot be set.
        """
        return pulumi.get(self, "denied_request_types")

    @denied_request_types.setter
    def denied_request_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "denied_request_types", value)


if not MYPY:
    class ServiceIdentityArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this Web PubSub. Possible values are `SystemAssigned`, `UserAssigned`.
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Web PubSub.

        > **Note:** This is required when `type` is set to `UserAssigned`
        """
        principal_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The Principal ID associated with this Managed Service Identity.
        """
        tenant_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The Tenant ID associated with this Managed Service Identity.
        """
elif False:
    ServiceIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this Web PubSub. Possible values are `SystemAssigned`, `UserAssigned`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Web PubSub.
               
               > **Note:** This is required when `type` is set to `UserAssigned`
        :param pulumi.Input[builtins.str] principal_id: The Principal ID associated with this Managed Service Identity.
        :param pulumi.Input[builtins.str] tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this Web PubSub. Possible values are `SystemAssigned`, `UserAssigned`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Web PubSub.

        > **Note:** This is required when `type` is set to `UserAssigned`
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class ServiceLiveTraceArgsDict(TypedDict):
        connectivity_logs_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether the log category `ConnectivityLogs` is enabled? Defaults to `true`
        """
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether the live trace is enabled? Defaults to `true`.
        """
        http_request_logs_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether the log category `HttpRequestLogs` is enabled? Defaults to `true`
        """
        messaging_logs_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether the log category `MessagingLogs` is enabled? Defaults to `true`
        """
elif False:
    ServiceLiveTraceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceLiveTraceArgs:
    def __init__(__self__, *,
                 connectivity_logs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 http_request_logs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 messaging_logs_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.bool] connectivity_logs_enabled: Whether the log category `ConnectivityLogs` is enabled? Defaults to `true`
        :param pulumi.Input[builtins.bool] enabled: Whether the live trace is enabled? Defaults to `true`.
        :param pulumi.Input[builtins.bool] http_request_logs_enabled: Whether the log category `HttpRequestLogs` is enabled? Defaults to `true`
        :param pulumi.Input[builtins.bool] messaging_logs_enabled: Whether the log category `MessagingLogs` is enabled? Defaults to `true`
        """
        if connectivity_logs_enabled is not None:
            pulumi.set(__self__, "connectivity_logs_enabled", connectivity_logs_enabled)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if http_request_logs_enabled is not None:
            pulumi.set(__self__, "http_request_logs_enabled", http_request_logs_enabled)
        if messaging_logs_enabled is not None:
            pulumi.set(__self__, "messaging_logs_enabled", messaging_logs_enabled)

    @property
    @pulumi.getter(name="connectivityLogsEnabled")
    def connectivity_logs_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the log category `ConnectivityLogs` is enabled? Defaults to `true`
        """
        return pulumi.get(self, "connectivity_logs_enabled")

    @connectivity_logs_enabled.setter
    def connectivity_logs_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "connectivity_logs_enabled", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the live trace is enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="httpRequestLogsEnabled")
    def http_request_logs_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the log category `HttpRequestLogs` is enabled? Defaults to `true`
        """
        return pulumi.get(self, "http_request_logs_enabled")

    @http_request_logs_enabled.setter
    def http_request_logs_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "http_request_logs_enabled", value)

    @property
    @pulumi.getter(name="messagingLogsEnabled")
    def messaging_logs_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the log category `MessagingLogs` is enabled? Defaults to `true`
        """
        return pulumi.get(self, "messaging_logs_enabled")

    @messaging_logs_enabled.setter
    def messaging_logs_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "messaging_logs_enabled", value)


if not MYPY:
    class SocketioIdentityArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        The type of Managed Identity for this Web PubSub Service. Possible Values are `SystemAssigned` and `UserAssigned`.
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Specifies a list of User Assigned Managed Identity IDs for this Web PubSub Service.

        > **Note:** `identity_ids` is required when `type` is `UserAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[builtins.str]]
        tenant_id: NotRequired[pulumi.Input[builtins.str]]
elif False:
    SocketioIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SocketioIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] type: The type of Managed Identity for this Web PubSub Service. Possible Values are `SystemAssigned` and `UserAssigned`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] identity_ids: Specifies a list of User Assigned Managed Identity IDs for this Web PubSub Service.
               
               > **Note:** `identity_ids` is required when `type` is `UserAssigned`.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of Managed Identity for this Web PubSub Service. Possible Values are `SystemAssigned` and `UserAssigned`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of User Assigned Managed Identity IDs for this Web PubSub Service.

        > **Note:** `identity_ids` is required when `type` is `UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class SocketioSkuArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        The name which should be used for this Web PubSub Service. Changing this forces a new Web PubSub Service to be created.
        """
        capacity: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of units associated with this Web PubSub Service. Defaults to `1`. Possible values are `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `10`, `20`, `30`, `40`, `50`, `60`, `70`, `80`, `90`, `100`, `200`, `300`, `400`, `500`, `600`, `700`, `800`, `900` and `1000`.

        > **Note:** The valid range depends on which `sku` is used. For `Free_F1` only `1` is supported, for `Standard_S1` and `Premium_P1` `1` through `100` are supported, and for `Premium_P2` the minimum capacity is `100`.
        """
elif False:
    SocketioSkuArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SocketioSkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 capacity: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] name: The name which should be used for this Web PubSub Service. Changing this forces a new Web PubSub Service to be created.
        :param pulumi.Input[builtins.int] capacity: The number of units associated with this Web PubSub Service. Defaults to `1`. Possible values are `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `10`, `20`, `30`, `40`, `50`, `60`, `70`, `80`, `90`, `100`, `200`, `300`, `400`, `500`, `600`, `700`, `800`, `900` and `1000`.
               
               > **Note:** The valid range depends on which `sku` is used. For `Free_F1` only `1` is supported, for `Standard_S1` and `Premium_P1` `1` through `100` are supported, and for `Premium_P2` the minimum capacity is `100`.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name which should be used for this Web PubSub Service. Changing this forces a new Web PubSub Service to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of units associated with this Web PubSub Service. Defaults to `1`. Possible values are `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `10`, `20`, `30`, `40`, `50`, `60`, `70`, `80`, `90`, `100`, `200`, `300`, `400`, `500`, `600`, `700`, `800`, `900` and `1000`.

        > **Note:** The valid range depends on which `sku` is used. For `Free_F1` only `1` is supported, for `Standard_S1` and `Premium_P1` `1` through `100` are supported, and for `Premium_P2` the minimum capacity is `100`.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "capacity", value)


