# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetPrivateLinkResourceResult',
    'AwaitableGetPrivateLinkResourceResult',
    'get_private_link_resource',
    'get_private_link_resource_output',
]

@pulumi.output_type
class GetPrivateLinkResourceResult:
    """
    A collection of values returned by getPrivateLinkResource.
    """
    def __init__(__self__, id=None, shared_private_link_resource_types=None, web_pubsub_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if shared_private_link_resource_types and not isinstance(shared_private_link_resource_types, list):
            raise TypeError("Expected argument 'shared_private_link_resource_types' to be a list")
        pulumi.set(__self__, "shared_private_link_resource_types", shared_private_link_resource_types)
        if web_pubsub_id and not isinstance(web_pubsub_id, str):
            raise TypeError("Expected argument 'web_pubsub_id' to be a str")
        pulumi.set(__self__, "web_pubsub_id", web_pubsub_id)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="sharedPrivateLinkResourceTypes")
    def shared_private_link_resource_types(self) -> Sequence['outputs.GetPrivateLinkResourceSharedPrivateLinkResourceTypeResult']:
        """
        A `shared_private_link_resource_types` block as defined below.
        """
        return pulumi.get(self, "shared_private_link_resource_types")

    @property
    @pulumi.getter(name="webPubsubId")
    def web_pubsub_id(self) -> builtins.str:
        return pulumi.get(self, "web_pubsub_id")


class AwaitableGetPrivateLinkResourceResult(GetPrivateLinkResourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPrivateLinkResourceResult(
            id=self.id,
            shared_private_link_resource_types=self.shared_private_link_resource_types,
            web_pubsub_id=self.web_pubsub_id)


def get_private_link_resource(web_pubsub_id: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPrivateLinkResourceResult:
    """
    Use this data source to access information about the Private Link Resource supported by the Web Pubsub Resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    test_resource_group = azure.core.ResourceGroup("test",
        name="terraform-webpubsub",
        location="east us")
    test_service = azure.webpubsub.Service("test",
        name="tfex-webpubsub",
        location=test_resource_group.location,
        resource_group_name=test_resource_group.name,
        sku="Standard_S1",
        capacity=1)
    test = azure.webpubsub.get_private_link_resource_output(web_pubsub_id=test_service.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.SignalRService`: 2024-03-01


    :param builtins.str web_pubsub_id: The ID of an existing Web Pubsub Resource which Private Link Resource should be retrieved for.
    """
    __args__ = dict()
    __args__['webPubsubId'] = web_pubsub_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:webpubsub/getPrivateLinkResource:getPrivateLinkResource', __args__, opts=opts, typ=GetPrivateLinkResourceResult).value

    return AwaitableGetPrivateLinkResourceResult(
        id=pulumi.get(__ret__, 'id'),
        shared_private_link_resource_types=pulumi.get(__ret__, 'shared_private_link_resource_types'),
        web_pubsub_id=pulumi.get(__ret__, 'web_pubsub_id'))
def get_private_link_resource_output(web_pubsub_id: Optional[pulumi.Input[builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPrivateLinkResourceResult]:
    """
    Use this data source to access information about the Private Link Resource supported by the Web Pubsub Resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    test_resource_group = azure.core.ResourceGroup("test",
        name="terraform-webpubsub",
        location="east us")
    test_service = azure.webpubsub.Service("test",
        name="tfex-webpubsub",
        location=test_resource_group.location,
        resource_group_name=test_resource_group.name,
        sku="Standard_S1",
        capacity=1)
    test = azure.webpubsub.get_private_link_resource_output(web_pubsub_id=test_service.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.SignalRService`: 2024-03-01


    :param builtins.str web_pubsub_id: The ID of an existing Web Pubsub Resource which Private Link Resource should be retrieved for.
    """
    __args__ = dict()
    __args__['webPubsubId'] = web_pubsub_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:webpubsub/getPrivateLinkResource:getPrivateLinkResource', __args__, opts=opts, typ=GetPrivateLinkResourceResult)
    return __ret__.apply(lambda __response__: GetPrivateLinkResourceResult(
        id=pulumi.get(__response__, 'id'),
        shared_private_link_resource_types=pulumi.get(__response__, 'shared_private_link_resource_types'),
        web_pubsub_id=pulumi.get(__response__, 'web_pubsub_id')))
