# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HubArgs', 'Hub']

@pulumi.input_type
class HubArgs:
    def __init__(__self__, *,
                 web_pubsub_id: pulumi.Input[builtins.str],
                 anonymous_connections_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 event_handlers: Optional[pulumi.Input[Sequence[pulumi.Input['HubEventHandlerArgs']]]] = None,
                 event_listeners: Optional[pulumi.Input[Sequence[pulumi.Input['HubEventListenerArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Hub resource.
        :param pulumi.Input[builtins.str] web_pubsub_id: Specifies the id of the Web Pubsub. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] anonymous_connections_enabled: Is anonymous connections are allowed for this hub? Defaults to `false`.
               Possible values are `true`, `false`.
        :param pulumi.Input[Sequence[pulumi.Input['HubEventHandlerArgs']]] event_handlers: An `event_handler` block as defined below.
               
               > **Note:** User can change the order of `event_handler` to change the priority accordingly.
        :param pulumi.Input[Sequence[pulumi.Input['HubEventListenerArgs']]] event_listeners: An `event_listener` block as defined below.
               
               > **Note:** The managed identity of Web PubSub service must be enabled and the identity must have the "Azure Event Hubs Data sender" role to access the Event Hub.
        :param pulumi.Input[builtins.str] name: The name of the Web Pubsub hub service. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "web_pubsub_id", web_pubsub_id)
        if anonymous_connections_enabled is not None:
            pulumi.set(__self__, "anonymous_connections_enabled", anonymous_connections_enabled)
        if event_handlers is not None:
            pulumi.set(__self__, "event_handlers", event_handlers)
        if event_listeners is not None:
            pulumi.set(__self__, "event_listeners", event_listeners)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="webPubsubId")
    def web_pubsub_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the id of the Web Pubsub. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "web_pubsub_id")

    @web_pubsub_id.setter
    def web_pubsub_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "web_pubsub_id", value)

    @property
    @pulumi.getter(name="anonymousConnectionsEnabled")
    def anonymous_connections_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is anonymous connections are allowed for this hub? Defaults to `false`.
        Possible values are `true`, `false`.
        """
        return pulumi.get(self, "anonymous_connections_enabled")

    @anonymous_connections_enabled.setter
    def anonymous_connections_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "anonymous_connections_enabled", value)

    @property
    @pulumi.getter(name="eventHandlers")
    def event_handlers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HubEventHandlerArgs']]]]:
        """
        An `event_handler` block as defined below.

        > **Note:** User can change the order of `event_handler` to change the priority accordingly.
        """
        return pulumi.get(self, "event_handlers")

    @event_handlers.setter
    def event_handlers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HubEventHandlerArgs']]]]):
        pulumi.set(self, "event_handlers", value)

    @property
    @pulumi.getter(name="eventListeners")
    def event_listeners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HubEventListenerArgs']]]]:
        """
        An `event_listener` block as defined below.

        > **Note:** The managed identity of Web PubSub service must be enabled and the identity must have the "Azure Event Hubs Data sender" role to access the Event Hub.
        """
        return pulumi.get(self, "event_listeners")

    @event_listeners.setter
    def event_listeners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HubEventListenerArgs']]]]):
        pulumi.set(self, "event_listeners", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Web Pubsub hub service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _HubState:
    def __init__(__self__, *,
                 anonymous_connections_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 event_handlers: Optional[pulumi.Input[Sequence[pulumi.Input['HubEventHandlerArgs']]]] = None,
                 event_listeners: Optional[pulumi.Input[Sequence[pulumi.Input['HubEventListenerArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 web_pubsub_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Hub resources.
        :param pulumi.Input[builtins.bool] anonymous_connections_enabled: Is anonymous connections are allowed for this hub? Defaults to `false`.
               Possible values are `true`, `false`.
        :param pulumi.Input[Sequence[pulumi.Input['HubEventHandlerArgs']]] event_handlers: An `event_handler` block as defined below.
               
               > **Note:** User can change the order of `event_handler` to change the priority accordingly.
        :param pulumi.Input[Sequence[pulumi.Input['HubEventListenerArgs']]] event_listeners: An `event_listener` block as defined below.
               
               > **Note:** The managed identity of Web PubSub service must be enabled and the identity must have the "Azure Event Hubs Data sender" role to access the Event Hub.
        :param pulumi.Input[builtins.str] name: The name of the Web Pubsub hub service. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] web_pubsub_id: Specifies the id of the Web Pubsub. Changing this forces a new resource to be created.
        """
        if anonymous_connections_enabled is not None:
            pulumi.set(__self__, "anonymous_connections_enabled", anonymous_connections_enabled)
        if event_handlers is not None:
            pulumi.set(__self__, "event_handlers", event_handlers)
        if event_listeners is not None:
            pulumi.set(__self__, "event_listeners", event_listeners)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if web_pubsub_id is not None:
            pulumi.set(__self__, "web_pubsub_id", web_pubsub_id)

    @property
    @pulumi.getter(name="anonymousConnectionsEnabled")
    def anonymous_connections_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is anonymous connections are allowed for this hub? Defaults to `false`.
        Possible values are `true`, `false`.
        """
        return pulumi.get(self, "anonymous_connections_enabled")

    @anonymous_connections_enabled.setter
    def anonymous_connections_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "anonymous_connections_enabled", value)

    @property
    @pulumi.getter(name="eventHandlers")
    def event_handlers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HubEventHandlerArgs']]]]:
        """
        An `event_handler` block as defined below.

        > **Note:** User can change the order of `event_handler` to change the priority accordingly.
        """
        return pulumi.get(self, "event_handlers")

    @event_handlers.setter
    def event_handlers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HubEventHandlerArgs']]]]):
        pulumi.set(self, "event_handlers", value)

    @property
    @pulumi.getter(name="eventListeners")
    def event_listeners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HubEventListenerArgs']]]]:
        """
        An `event_listener` block as defined below.

        > **Note:** The managed identity of Web PubSub service must be enabled and the identity must have the "Azure Event Hubs Data sender" role to access the Event Hub.
        """
        return pulumi.get(self, "event_listeners")

    @event_listeners.setter
    def event_listeners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HubEventListenerArgs']]]]):
        pulumi.set(self, "event_listeners", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Web Pubsub hub service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="webPubsubId")
    def web_pubsub_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the id of the Web Pubsub. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "web_pubsub_id")

    @web_pubsub_id.setter
    def web_pubsub_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "web_pubsub_id", value)


@pulumi.type_token("azure:webpubsub/hub:Hub")
class Hub(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 anonymous_connections_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 event_handlers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HubEventHandlerArgs', 'HubEventHandlerArgsDict']]]]] = None,
                 event_listeners: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HubEventListenerArgs', 'HubEventListenerArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 web_pubsub_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages the hub settings for a Web Pubsub.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="terraform-webpubsub",
            location="east us")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="tfex-uai",
            resource_group_name=example.name,
            location=example.location)
        example_service = azure.webpubsub.Service("example",
            name="tfex-webpubsub",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard_S1",
            capacity=1)
        example_hub = azure.webpubsub.Hub("example",
            name="tfex_wpsh",
            web_pubsub_id=example_service.id,
            event_handlers=[
                {
                    "url_template": "https://test.com/api/{hub}/{event}",
                    "user_event_pattern": "*",
                    "system_events": [
                        "connect",
                        "connected",
                    ],
                },
                {
                    "url_template": "https://test.com/api/{hub}/{event}",
                    "user_event_pattern": "event1, event2",
                    "system_events": ["connected"],
                    "auth": {
                        "managed_identity_id": example_user_assigned_identity.id,
                    },
                },
            ],
            event_listeners=[
                {
                    "system_event_name_filters": ["connected"],
                    "user_event_name_filters": [
                        "event1",
                        "event2",
                    ],
                    "eventhub_namespace_name": test["name"],
                    "eventhub_name": test1["name"],
                },
                {
                    "system_event_name_filters": ["connected"],
                    "user_event_name_filters": ["*"],
                    "eventhub_namespace_name": test["name"],
                    "eventhub_name": test1["name"],
                },
                {
                    "system_event_name_filters": ["connected"],
                    "user_event_name_filters": ["event1"],
                    "eventhub_namespace_name": test["name"],
                    "eventhub_name": test1["name"],
                },
            ],
            anonymous_connections_enabled=True,
            opts = pulumi.ResourceOptions(depends_on=[example_service]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.SignalRService`: 2024-03-01

        ## Import

        Web Pubsub Hub can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:webpubsub/hub:Hub example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.SignalRService/webPubSub/webPubSub1/hubs/webPubSubhub1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] anonymous_connections_enabled: Is anonymous connections are allowed for this hub? Defaults to `false`.
               Possible values are `true`, `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HubEventHandlerArgs', 'HubEventHandlerArgsDict']]]] event_handlers: An `event_handler` block as defined below.
               
               > **Note:** User can change the order of `event_handler` to change the priority accordingly.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HubEventListenerArgs', 'HubEventListenerArgsDict']]]] event_listeners: An `event_listener` block as defined below.
               
               > **Note:** The managed identity of Web PubSub service must be enabled and the identity must have the "Azure Event Hubs Data sender" role to access the Event Hub.
        :param pulumi.Input[builtins.str] name: The name of the Web Pubsub hub service. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] web_pubsub_id: Specifies the id of the Web Pubsub. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HubArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the hub settings for a Web Pubsub.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="terraform-webpubsub",
            location="east us")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="tfex-uai",
            resource_group_name=example.name,
            location=example.location)
        example_service = azure.webpubsub.Service("example",
            name="tfex-webpubsub",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard_S1",
            capacity=1)
        example_hub = azure.webpubsub.Hub("example",
            name="tfex_wpsh",
            web_pubsub_id=example_service.id,
            event_handlers=[
                {
                    "url_template": "https://test.com/api/{hub}/{event}",
                    "user_event_pattern": "*",
                    "system_events": [
                        "connect",
                        "connected",
                    ],
                },
                {
                    "url_template": "https://test.com/api/{hub}/{event}",
                    "user_event_pattern": "event1, event2",
                    "system_events": ["connected"],
                    "auth": {
                        "managed_identity_id": example_user_assigned_identity.id,
                    },
                },
            ],
            event_listeners=[
                {
                    "system_event_name_filters": ["connected"],
                    "user_event_name_filters": [
                        "event1",
                        "event2",
                    ],
                    "eventhub_namespace_name": test["name"],
                    "eventhub_name": test1["name"],
                },
                {
                    "system_event_name_filters": ["connected"],
                    "user_event_name_filters": ["*"],
                    "eventhub_namespace_name": test["name"],
                    "eventhub_name": test1["name"],
                },
                {
                    "system_event_name_filters": ["connected"],
                    "user_event_name_filters": ["event1"],
                    "eventhub_namespace_name": test["name"],
                    "eventhub_name": test1["name"],
                },
            ],
            anonymous_connections_enabled=True,
            opts = pulumi.ResourceOptions(depends_on=[example_service]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.SignalRService`: 2024-03-01

        ## Import

        Web Pubsub Hub can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:webpubsub/hub:Hub example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.SignalRService/webPubSub/webPubSub1/hubs/webPubSubhub1
        ```

        :param str resource_name: The name of the resource.
        :param HubArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HubArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 anonymous_connections_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 event_handlers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HubEventHandlerArgs', 'HubEventHandlerArgsDict']]]]] = None,
                 event_listeners: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HubEventListenerArgs', 'HubEventListenerArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 web_pubsub_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HubArgs.__new__(HubArgs)

            __props__.__dict__["anonymous_connections_enabled"] = anonymous_connections_enabled
            __props__.__dict__["event_handlers"] = event_handlers
            __props__.__dict__["event_listeners"] = event_listeners
            __props__.__dict__["name"] = name
            if web_pubsub_id is None and not opts.urn:
                raise TypeError("Missing required property 'web_pubsub_id'")
            __props__.__dict__["web_pubsub_id"] = web_pubsub_id
        super(Hub, __self__).__init__(
            'azure:webpubsub/hub:Hub',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            anonymous_connections_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            event_handlers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HubEventHandlerArgs', 'HubEventHandlerArgsDict']]]]] = None,
            event_listeners: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HubEventListenerArgs', 'HubEventListenerArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            web_pubsub_id: Optional[pulumi.Input[builtins.str]] = None) -> 'Hub':
        """
        Get an existing Hub resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] anonymous_connections_enabled: Is anonymous connections are allowed for this hub? Defaults to `false`.
               Possible values are `true`, `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HubEventHandlerArgs', 'HubEventHandlerArgsDict']]]] event_handlers: An `event_handler` block as defined below.
               
               > **Note:** User can change the order of `event_handler` to change the priority accordingly.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HubEventListenerArgs', 'HubEventListenerArgsDict']]]] event_listeners: An `event_listener` block as defined below.
               
               > **Note:** The managed identity of Web PubSub service must be enabled and the identity must have the "Azure Event Hubs Data sender" role to access the Event Hub.
        :param pulumi.Input[builtins.str] name: The name of the Web Pubsub hub service. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] web_pubsub_id: Specifies the id of the Web Pubsub. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HubState.__new__(_HubState)

        __props__.__dict__["anonymous_connections_enabled"] = anonymous_connections_enabled
        __props__.__dict__["event_handlers"] = event_handlers
        __props__.__dict__["event_listeners"] = event_listeners
        __props__.__dict__["name"] = name
        __props__.__dict__["web_pubsub_id"] = web_pubsub_id
        return Hub(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="anonymousConnectionsEnabled")
    def anonymous_connections_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is anonymous connections are allowed for this hub? Defaults to `false`.
        Possible values are `true`, `false`.
        """
        return pulumi.get(self, "anonymous_connections_enabled")

    @property
    @pulumi.getter(name="eventHandlers")
    def event_handlers(self) -> pulumi.Output[Optional[Sequence['outputs.HubEventHandler']]]:
        """
        An `event_handler` block as defined below.

        > **Note:** User can change the order of `event_handler` to change the priority accordingly.
        """
        return pulumi.get(self, "event_handlers")

    @property
    @pulumi.getter(name="eventListeners")
    def event_listeners(self) -> pulumi.Output[Optional[Sequence['outputs.HubEventListener']]]:
        """
        An `event_listener` block as defined below.

        > **Note:** The managed identity of Web PubSub service must be enabled and the identity must have the "Azure Event Hubs Data sender" role to access the Event Hub.
        """
        return pulumi.get(self, "event_listeners")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Web Pubsub hub service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="webPubsubId")
    def web_pubsub_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the id of the Web Pubsub. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "web_pubsub_id")

