# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkAclArgs', 'NetworkAcl']

@pulumi.input_type
class NetworkAclArgs:
    def __init__(__self__, *,
                 public_network: pulumi.Input['NetworkAclPublicNetworkArgs'],
                 web_pubsub_id: pulumi.Input[builtins.str],
                 default_action: Optional[pulumi.Input[builtins.str]] = None,
                 private_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclPrivateEndpointArgs']]]] = None):
        """
        The set of arguments for constructing a NetworkAcl resource.
        :param pulumi.Input['NetworkAclPublicNetworkArgs'] public_network: A `public_network` block as defined below.
        :param pulumi.Input[builtins.str] web_pubsub_id: The ID of the Web Pubsub service. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] default_action: The default action to control the network access when no other rule matches. Possible values are `Allow` and `Deny`. Defaults to `Deny`.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkAclPrivateEndpointArgs']]] private_endpoints: A `private_endpoint` block as defined below.
        """
        pulumi.set(__self__, "public_network", public_network)
        pulumi.set(__self__, "web_pubsub_id", web_pubsub_id)
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if private_endpoints is not None:
            pulumi.set(__self__, "private_endpoints", private_endpoints)

    @property
    @pulumi.getter(name="publicNetwork")
    def public_network(self) -> pulumi.Input['NetworkAclPublicNetworkArgs']:
        """
        A `public_network` block as defined below.
        """
        return pulumi.get(self, "public_network")

    @public_network.setter
    def public_network(self, value: pulumi.Input['NetworkAclPublicNetworkArgs']):
        pulumi.set(self, "public_network", value)

    @property
    @pulumi.getter(name="webPubsubId")
    def web_pubsub_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Web Pubsub service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "web_pubsub_id")

    @web_pubsub_id.setter
    def web_pubsub_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "web_pubsub_id", value)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The default action to control the network access when no other rule matches. Possible values are `Allow` and `Deny`. Defaults to `Deny`.
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_action", value)

    @property
    @pulumi.getter(name="privateEndpoints")
    def private_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclPrivateEndpointArgs']]]]:
        """
        A `private_endpoint` block as defined below.
        """
        return pulumi.get(self, "private_endpoints")

    @private_endpoints.setter
    def private_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclPrivateEndpointArgs']]]]):
        pulumi.set(self, "private_endpoints", value)


@pulumi.input_type
class _NetworkAclState:
    def __init__(__self__, *,
                 default_action: Optional[pulumi.Input[builtins.str]] = None,
                 private_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclPrivateEndpointArgs']]]] = None,
                 public_network: Optional[pulumi.Input['NetworkAclPublicNetworkArgs']] = None,
                 web_pubsub_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkAcl resources.
        :param pulumi.Input[builtins.str] default_action: The default action to control the network access when no other rule matches. Possible values are `Allow` and `Deny`. Defaults to `Deny`.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkAclPrivateEndpointArgs']]] private_endpoints: A `private_endpoint` block as defined below.
        :param pulumi.Input['NetworkAclPublicNetworkArgs'] public_network: A `public_network` block as defined below.
        :param pulumi.Input[builtins.str] web_pubsub_id: The ID of the Web Pubsub service. Changing this forces a new resource to be created.
        """
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if private_endpoints is not None:
            pulumi.set(__self__, "private_endpoints", private_endpoints)
        if public_network is not None:
            pulumi.set(__self__, "public_network", public_network)
        if web_pubsub_id is not None:
            pulumi.set(__self__, "web_pubsub_id", web_pubsub_id)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The default action to control the network access when no other rule matches. Possible values are `Allow` and `Deny`. Defaults to `Deny`.
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_action", value)

    @property
    @pulumi.getter(name="privateEndpoints")
    def private_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclPrivateEndpointArgs']]]]:
        """
        A `private_endpoint` block as defined below.
        """
        return pulumi.get(self, "private_endpoints")

    @private_endpoints.setter
    def private_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclPrivateEndpointArgs']]]]):
        pulumi.set(self, "private_endpoints", value)

    @property
    @pulumi.getter(name="publicNetwork")
    def public_network(self) -> Optional[pulumi.Input['NetworkAclPublicNetworkArgs']]:
        """
        A `public_network` block as defined below.
        """
        return pulumi.get(self, "public_network")

    @public_network.setter
    def public_network(self, value: Optional[pulumi.Input['NetworkAclPublicNetworkArgs']]):
        pulumi.set(self, "public_network", value)

    @property
    @pulumi.getter(name="webPubsubId")
    def web_pubsub_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Web Pubsub service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "web_pubsub_id")

    @web_pubsub_id.setter
    def web_pubsub_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "web_pubsub_id", value)


@pulumi.type_token("azure:webpubsub/networkAcl:NetworkAcl")
class NetworkAcl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_action: Optional[pulumi.Input[builtins.str]] = None,
                 private_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkAclPrivateEndpointArgs', 'NetworkAclPrivateEndpointArgsDict']]]]] = None,
                 public_network: Optional[pulumi.Input[Union['NetworkAclPublicNetworkArgs', 'NetworkAclPublicNetworkArgsDict']]] = None,
                 web_pubsub_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages the Network ACL for a Web Pubsub.

        ## Import

        Network ACLs for a Web Pubsub service can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:webpubsub/networkAcl:NetworkAcl example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.SignalRService/webPubSub/webpubsub1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] default_action: The default action to control the network access when no other rule matches. Possible values are `Allow` and `Deny`. Defaults to `Deny`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkAclPrivateEndpointArgs', 'NetworkAclPrivateEndpointArgsDict']]]] private_endpoints: A `private_endpoint` block as defined below.
        :param pulumi.Input[Union['NetworkAclPublicNetworkArgs', 'NetworkAclPublicNetworkArgsDict']] public_network: A `public_network` block as defined below.
        :param pulumi.Input[builtins.str] web_pubsub_id: The ID of the Web Pubsub service. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkAclArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the Network ACL for a Web Pubsub.

        ## Import

        Network ACLs for a Web Pubsub service can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:webpubsub/networkAcl:NetworkAcl example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.SignalRService/webPubSub/webpubsub1
        ```

        :param str resource_name: The name of the resource.
        :param NetworkAclArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkAclArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_action: Optional[pulumi.Input[builtins.str]] = None,
                 private_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkAclPrivateEndpointArgs', 'NetworkAclPrivateEndpointArgsDict']]]]] = None,
                 public_network: Optional[pulumi.Input[Union['NetworkAclPublicNetworkArgs', 'NetworkAclPublicNetworkArgsDict']]] = None,
                 web_pubsub_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkAclArgs.__new__(NetworkAclArgs)

            __props__.__dict__["default_action"] = default_action
            __props__.__dict__["private_endpoints"] = private_endpoints
            if public_network is None and not opts.urn:
                raise TypeError("Missing required property 'public_network'")
            __props__.__dict__["public_network"] = public_network
            if web_pubsub_id is None and not opts.urn:
                raise TypeError("Missing required property 'web_pubsub_id'")
            __props__.__dict__["web_pubsub_id"] = web_pubsub_id
        super(NetworkAcl, __self__).__init__(
            'azure:webpubsub/networkAcl:NetworkAcl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_action: Optional[pulumi.Input[builtins.str]] = None,
            private_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkAclPrivateEndpointArgs', 'NetworkAclPrivateEndpointArgsDict']]]]] = None,
            public_network: Optional[pulumi.Input[Union['NetworkAclPublicNetworkArgs', 'NetworkAclPublicNetworkArgsDict']]] = None,
            web_pubsub_id: Optional[pulumi.Input[builtins.str]] = None) -> 'NetworkAcl':
        """
        Get an existing NetworkAcl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] default_action: The default action to control the network access when no other rule matches. Possible values are `Allow` and `Deny`. Defaults to `Deny`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkAclPrivateEndpointArgs', 'NetworkAclPrivateEndpointArgsDict']]]] private_endpoints: A `private_endpoint` block as defined below.
        :param pulumi.Input[Union['NetworkAclPublicNetworkArgs', 'NetworkAclPublicNetworkArgsDict']] public_network: A `public_network` block as defined below.
        :param pulumi.Input[builtins.str] web_pubsub_id: The ID of the Web Pubsub service. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkAclState.__new__(_NetworkAclState)

        __props__.__dict__["default_action"] = default_action
        __props__.__dict__["private_endpoints"] = private_endpoints
        __props__.__dict__["public_network"] = public_network
        __props__.__dict__["web_pubsub_id"] = web_pubsub_id
        return NetworkAcl(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The default action to control the network access when no other rule matches. Possible values are `Allow` and `Deny`. Defaults to `Deny`.
        """
        return pulumi.get(self, "default_action")

    @property
    @pulumi.getter(name="privateEndpoints")
    def private_endpoints(self) -> pulumi.Output[Optional[Sequence['outputs.NetworkAclPrivateEndpoint']]]:
        """
        A `private_endpoint` block as defined below.
        """
        return pulumi.get(self, "private_endpoints")

    @property
    @pulumi.getter(name="publicNetwork")
    def public_network(self) -> pulumi.Output['outputs.NetworkAclPublicNetwork']:
        """
        A `public_network` block as defined below.
        """
        return pulumi.get(self, "public_network")

    @property
    @pulumi.getter(name="webPubsubId")
    def web_pubsub_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Web Pubsub service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "web_pubsub_id")

