# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceArgs', 'Service']

@pulumi.input_type
class ServiceArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[builtins.str],
                 sku: pulumi.Input[builtins.str],
                 aad_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 capacity: Optional[pulumi.Input[builtins.int]] = None,
                 identity: Optional[pulumi.Input['ServiceIdentityArgs']] = None,
                 live_trace: Optional[pulumi.Input['ServiceLiveTraceArgs']] = None,
                 local_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tls_client_cert_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a Service resource.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Web PubSub service. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sku: Specifies which SKU to use. Possible values are `Free_F1`, `Standard_S1`, `Premium_P1` and `Premium_P2`.
        :param pulumi.Input[builtins.bool] aad_auth_enabled: Whether to enable AAD auth? Defaults to `true`.
        :param pulumi.Input[builtins.int] capacity: Specifies the number of units associated with this Web PubSub resource. Valid values are `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `10`, `20`, `30`, `40`, `50`, `60`, `70`, `80`, `90`, `100`, `200`, `300`, `400`, `500`, `600`, `700`, `800`, `900` and `1000`.
               
               > **Note:** The valid capacity range for sku `Free_F1` is `1`, for sku `Premium_P2` is from `100` to `1000`, and from `1` to `100` for sku `Standard_S1` and `Premium_P1`.
        :param pulumi.Input['ServiceIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input['ServiceLiveTraceArgs'] live_trace: A `live_trace` block as defined below.
        :param pulumi.Input[builtins.bool] local_auth_enabled: Whether to enable local auth? Defaults to `true`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the Web PubSub service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the Web PubSub service. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Whether to enable public network access? Defaults to `true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.bool] tls_client_cert_enabled: Whether to request client certificate during TLS handshake? Defaults to `false`.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku", sku)
        if aad_auth_enabled is not None:
            pulumi.set(__self__, "aad_auth_enabled", aad_auth_enabled)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if live_trace is not None:
            pulumi.set(__self__, "live_trace", live_trace)
        if local_auth_enabled is not None:
            pulumi.set(__self__, "local_auth_enabled", local_auth_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tls_client_cert_enabled is not None:
            pulumi.set(__self__, "tls_client_cert_enabled", tls_client_cert_enabled)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group in which to create the Web PubSub service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Input[builtins.str]:
        """
        Specifies which SKU to use. Possible values are `Free_F1`, `Standard_S1`, `Premium_P1` and `Premium_P2`.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter(name="aadAuthEnabled")
    def aad_auth_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable AAD auth? Defaults to `true`.
        """
        return pulumi.get(self, "aad_auth_enabled")

    @aad_auth_enabled.setter
    def aad_auth_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "aad_auth_enabled", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of units associated with this Web PubSub resource. Valid values are `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `10`, `20`, `30`, `40`, `50`, `60`, `70`, `80`, `90`, `100`, `200`, `300`, `400`, `500`, `600`, `700`, `800`, `900` and `1000`.

        > **Note:** The valid capacity range for sku `Free_F1` is `1`, for sku `Premium_P2` is from `100` to `1000`, and from `1` to `100` for sku `Standard_S1` and `Premium_P1`.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ServiceIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ServiceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="liveTrace")
    def live_trace(self) -> Optional[pulumi.Input['ServiceLiveTraceArgs']]:
        """
        A `live_trace` block as defined below.
        """
        return pulumi.get(self, "live_trace")

    @live_trace.setter
    def live_trace(self, value: Optional[pulumi.Input['ServiceLiveTraceArgs']]):
        pulumi.set(self, "live_trace", value)

    @property
    @pulumi.getter(name="localAuthEnabled")
    def local_auth_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable local auth? Defaults to `true`.
        """
        return pulumi.get(self, "local_auth_enabled")

    @local_auth_enabled.setter
    def local_auth_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "local_auth_enabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the Web PubSub service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Web PubSub service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable public network access? Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tlsClientCertEnabled")
    def tls_client_cert_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to request client certificate during TLS handshake? Defaults to `false`.
        """
        return pulumi.get(self, "tls_client_cert_enabled")

    @tls_client_cert_enabled.setter
    def tls_client_cert_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "tls_client_cert_enabled", value)


@pulumi.input_type
class _ServiceState:
    def __init__(__self__, *,
                 aad_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 capacity: Optional[pulumi.Input[builtins.int]] = None,
                 external_ip: Optional[pulumi.Input[builtins.str]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 identity: Optional[pulumi.Input['ServiceIdentityArgs']] = None,
                 live_trace: Optional[pulumi.Input['ServiceLiveTraceArgs']] = None,
                 local_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 primary_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 primary_connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 public_port: Optional[pulumi.Input[builtins.int]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 server_port: Optional[pulumi.Input[builtins.int]] = None,
                 sku: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tls_client_cert_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Service resources.
        :param pulumi.Input[builtins.bool] aad_auth_enabled: Whether to enable AAD auth? Defaults to `true`.
        :param pulumi.Input[builtins.int] capacity: Specifies the number of units associated with this Web PubSub resource. Valid values are `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `10`, `20`, `30`, `40`, `50`, `60`, `70`, `80`, `90`, `100`, `200`, `300`, `400`, `500`, `600`, `700`, `800`, `900` and `1000`.
               
               > **Note:** The valid capacity range for sku `Free_F1` is `1`, for sku `Premium_P2` is from `100` to `1000`, and from `1` to `100` for sku `Standard_S1` and `Premium_P1`.
        :param pulumi.Input[builtins.str] external_ip: The publicly accessible IP of the Web PubSub service.
        :param pulumi.Input[builtins.str] hostname: The FQDN of the Web PubSub service.
        :param pulumi.Input['ServiceIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input['ServiceLiveTraceArgs'] live_trace: A `live_trace` block as defined below.
        :param pulumi.Input[builtins.bool] local_auth_enabled: Whether to enable local auth? Defaults to `true`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the Web PubSub service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the Web PubSub service. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] primary_access_key: The primary access key for the Web PubSub service.
        :param pulumi.Input[builtins.str] primary_connection_string: The primary connection string for the Web PubSub service.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Whether to enable public network access? Defaults to `true`.
        :param pulumi.Input[builtins.int] public_port: The publicly accessible port of the Web PubSub service which is designed for browser/client use.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Web PubSub service. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] secondary_access_key: The secondary access key for the Web PubSub service.
        :param pulumi.Input[builtins.str] secondary_connection_string: The secondary connection string for the Web PubSub service.
        :param pulumi.Input[builtins.int] server_port: The publicly accessible port of the Web PubSub service which is designed for customer server side use.
        :param pulumi.Input[builtins.str] sku: Specifies which SKU to use. Possible values are `Free_F1`, `Standard_S1`, `Premium_P1` and `Premium_P2`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.bool] tls_client_cert_enabled: Whether to request client certificate during TLS handshake? Defaults to `false`.
        """
        if aad_auth_enabled is not None:
            pulumi.set(__self__, "aad_auth_enabled", aad_auth_enabled)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if external_ip is not None:
            pulumi.set(__self__, "external_ip", external_ip)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if live_trace is not None:
            pulumi.set(__self__, "live_trace", live_trace)
        if local_auth_enabled is not None:
            pulumi.set(__self__, "local_auth_enabled", local_auth_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_access_key is not None:
            pulumi.set(__self__, "primary_access_key", primary_access_key)
        if primary_connection_string is not None:
            pulumi.set(__self__, "primary_connection_string", primary_connection_string)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if public_port is not None:
            pulumi.set(__self__, "public_port", public_port)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if secondary_access_key is not None:
            pulumi.set(__self__, "secondary_access_key", secondary_access_key)
        if secondary_connection_string is not None:
            pulumi.set(__self__, "secondary_connection_string", secondary_connection_string)
        if server_port is not None:
            pulumi.set(__self__, "server_port", server_port)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tls_client_cert_enabled is not None:
            pulumi.set(__self__, "tls_client_cert_enabled", tls_client_cert_enabled)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="aadAuthEnabled")
    def aad_auth_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable AAD auth? Defaults to `true`.
        """
        return pulumi.get(self, "aad_auth_enabled")

    @aad_auth_enabled.setter
    def aad_auth_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "aad_auth_enabled", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of units associated with this Web PubSub resource. Valid values are `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `10`, `20`, `30`, `40`, `50`, `60`, `70`, `80`, `90`, `100`, `200`, `300`, `400`, `500`, `600`, `700`, `800`, `900` and `1000`.

        > **Note:** The valid capacity range for sku `Free_F1` is `1`, for sku `Premium_P2` is from `100` to `1000`, and from `1` to `100` for sku `Standard_S1` and `Premium_P1`.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter(name="externalIp")
    def external_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The publicly accessible IP of the Web PubSub service.
        """
        return pulumi.get(self, "external_ip")

    @external_ip.setter
    def external_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_ip", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The FQDN of the Web PubSub service.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ServiceIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ServiceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="liveTrace")
    def live_trace(self) -> Optional[pulumi.Input['ServiceLiveTraceArgs']]:
        """
        A `live_trace` block as defined below.
        """
        return pulumi.get(self, "live_trace")

    @live_trace.setter
    def live_trace(self, value: Optional[pulumi.Input['ServiceLiveTraceArgs']]):
        pulumi.set(self, "live_trace", value)

    @property
    @pulumi.getter(name="localAuthEnabled")
    def local_auth_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable local auth? Defaults to `true`.
        """
        return pulumi.get(self, "local_auth_enabled")

    @local_auth_enabled.setter
    def local_auth_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "local_auth_enabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the Web PubSub service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Web PubSub service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="primaryAccessKey")
    def primary_access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The primary access key for the Web PubSub service.
        """
        return pulumi.get(self, "primary_access_key")

    @primary_access_key.setter
    def primary_access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_access_key", value)

    @property
    @pulumi.getter(name="primaryConnectionString")
    def primary_connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The primary connection string for the Web PubSub service.
        """
        return pulumi.get(self, "primary_connection_string")

    @primary_connection_string.setter
    def primary_connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_connection_string", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable public network access? Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter(name="publicPort")
    def public_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The publicly accessible port of the Web PubSub service which is designed for browser/client use.
        """
        return pulumi.get(self, "public_port")

    @public_port.setter
    def public_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "public_port", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group in which to create the Web PubSub service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="secondaryAccessKey")
    def secondary_access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The secondary access key for the Web PubSub service.
        """
        return pulumi.get(self, "secondary_access_key")

    @secondary_access_key.setter
    def secondary_access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_access_key", value)

    @property
    @pulumi.getter(name="secondaryConnectionString")
    def secondary_connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The secondary connection string for the Web PubSub service.
        """
        return pulumi.get(self, "secondary_connection_string")

    @secondary_connection_string.setter
    def secondary_connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_connection_string", value)

    @property
    @pulumi.getter(name="serverPort")
    def server_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The publicly accessible port of the Web PubSub service which is designed for customer server side use.
        """
        return pulumi.get(self, "server_port")

    @server_port.setter
    def server_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "server_port", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies which SKU to use. Possible values are `Free_F1`, `Standard_S1`, `Premium_P1` and `Premium_P2`.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tlsClientCertEnabled")
    def tls_client_cert_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to request client certificate during TLS handshake? Defaults to `false`.
        """
        return pulumi.get(self, "tls_client_cert_enabled")

    @tls_client_cert_enabled.setter
    def tls_client_cert_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "tls_client_cert_enabled", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("azure:webpubsub/service:Service")
class Service(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aad_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 capacity: Optional[pulumi.Input[builtins.int]] = None,
                 identity: Optional[pulumi.Input[Union['ServiceIdentityArgs', 'ServiceIdentityArgsDict']]] = None,
                 live_trace: Optional[pulumi.Input[Union['ServiceLiveTraceArgs', 'ServiceLiveTraceArgsDict']]] = None,
                 local_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 sku: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tls_client_cert_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        Manages an Azure Web PubSub Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="terraform-webpubsub",
            location="east us")
        example_service = azure.webpubsub.Service("example",
            name="tfex-webpubsub",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard_S1",
            capacity=1,
            public_network_access_enabled=False,
            live_trace={
                "enabled": True,
                "messaging_logs_enabled": True,
                "connectivity_logs_enabled": False,
            },
            identity={
                "type": "SystemAssigned",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.SignalRService`: 2024-03-01

        ## Import

        Web PubSub services can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:webpubsub/service:Service example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.SignalRService/webPubSub/pubsub1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] aad_auth_enabled: Whether to enable AAD auth? Defaults to `true`.
        :param pulumi.Input[builtins.int] capacity: Specifies the number of units associated with this Web PubSub resource. Valid values are `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `10`, `20`, `30`, `40`, `50`, `60`, `70`, `80`, `90`, `100`, `200`, `300`, `400`, `500`, `600`, `700`, `800`, `900` and `1000`.
               
               > **Note:** The valid capacity range for sku `Free_F1` is `1`, for sku `Premium_P2` is from `100` to `1000`, and from `1` to `100` for sku `Standard_S1` and `Premium_P1`.
        :param pulumi.Input[Union['ServiceIdentityArgs', 'ServiceIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[Union['ServiceLiveTraceArgs', 'ServiceLiveTraceArgsDict']] live_trace: A `live_trace` block as defined below.
        :param pulumi.Input[builtins.bool] local_auth_enabled: Whether to enable local auth? Defaults to `true`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the Web PubSub service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the Web PubSub service. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Whether to enable public network access? Defaults to `true`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Web PubSub service. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sku: Specifies which SKU to use. Possible values are `Free_F1`, `Standard_S1`, `Premium_P1` and `Premium_P2`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.bool] tls_client_cert_enabled: Whether to request client certificate during TLS handshake? Defaults to `false`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Web PubSub Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="terraform-webpubsub",
            location="east us")
        example_service = azure.webpubsub.Service("example",
            name="tfex-webpubsub",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard_S1",
            capacity=1,
            public_network_access_enabled=False,
            live_trace={
                "enabled": True,
                "messaging_logs_enabled": True,
                "connectivity_logs_enabled": False,
            },
            identity={
                "type": "SystemAssigned",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.SignalRService`: 2024-03-01

        ## Import

        Web PubSub services can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:webpubsub/service:Service example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.SignalRService/webPubSub/pubsub1
        ```

        :param str resource_name: The name of the resource.
        :param ServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aad_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 capacity: Optional[pulumi.Input[builtins.int]] = None,
                 identity: Optional[pulumi.Input[Union['ServiceIdentityArgs', 'ServiceIdentityArgsDict']]] = None,
                 live_trace: Optional[pulumi.Input[Union['ServiceLiveTraceArgs', 'ServiceLiveTraceArgsDict']]] = None,
                 local_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 sku: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tls_client_cert_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceArgs.__new__(ServiceArgs)

            __props__.__dict__["aad_auth_enabled"] = aad_auth_enabled
            __props__.__dict__["capacity"] = capacity
            __props__.__dict__["identity"] = identity
            __props__.__dict__["live_trace"] = live_trace
            __props__.__dict__["local_auth_enabled"] = local_auth_enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sku is None and not opts.urn:
                raise TypeError("Missing required property 'sku'")
            __props__.__dict__["sku"] = sku
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tls_client_cert_enabled"] = tls_client_cert_enabled
            __props__.__dict__["external_ip"] = None
            __props__.__dict__["hostname"] = None
            __props__.__dict__["primary_access_key"] = None
            __props__.__dict__["primary_connection_string"] = None
            __props__.__dict__["public_port"] = None
            __props__.__dict__["secondary_access_key"] = None
            __props__.__dict__["secondary_connection_string"] = None
            __props__.__dict__["server_port"] = None
            __props__.__dict__["version"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["primaryAccessKey", "primaryConnectionString", "secondaryAccessKey", "secondaryConnectionString"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Service, __self__).__init__(
            'azure:webpubsub/service:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aad_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            capacity: Optional[pulumi.Input[builtins.int]] = None,
            external_ip: Optional[pulumi.Input[builtins.str]] = None,
            hostname: Optional[pulumi.Input[builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['ServiceIdentityArgs', 'ServiceIdentityArgsDict']]] = None,
            live_trace: Optional[pulumi.Input[Union['ServiceLiveTraceArgs', 'ServiceLiveTraceArgsDict']]] = None,
            local_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            primary_access_key: Optional[pulumi.Input[builtins.str]] = None,
            primary_connection_string: Optional[pulumi.Input[builtins.str]] = None,
            public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            public_port: Optional[pulumi.Input[builtins.int]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            secondary_access_key: Optional[pulumi.Input[builtins.str]] = None,
            secondary_connection_string: Optional[pulumi.Input[builtins.str]] = None,
            server_port: Optional[pulumi.Input[builtins.int]] = None,
            sku: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tls_client_cert_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None) -> 'Service':
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] aad_auth_enabled: Whether to enable AAD auth? Defaults to `true`.
        :param pulumi.Input[builtins.int] capacity: Specifies the number of units associated with this Web PubSub resource. Valid values are `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `10`, `20`, `30`, `40`, `50`, `60`, `70`, `80`, `90`, `100`, `200`, `300`, `400`, `500`, `600`, `700`, `800`, `900` and `1000`.
               
               > **Note:** The valid capacity range for sku `Free_F1` is `1`, for sku `Premium_P2` is from `100` to `1000`, and from `1` to `100` for sku `Standard_S1` and `Premium_P1`.
        :param pulumi.Input[builtins.str] external_ip: The publicly accessible IP of the Web PubSub service.
        :param pulumi.Input[builtins.str] hostname: The FQDN of the Web PubSub service.
        :param pulumi.Input[Union['ServiceIdentityArgs', 'ServiceIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[Union['ServiceLiveTraceArgs', 'ServiceLiveTraceArgsDict']] live_trace: A `live_trace` block as defined below.
        :param pulumi.Input[builtins.bool] local_auth_enabled: Whether to enable local auth? Defaults to `true`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the Web PubSub service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the Web PubSub service. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] primary_access_key: The primary access key for the Web PubSub service.
        :param pulumi.Input[builtins.str] primary_connection_string: The primary connection string for the Web PubSub service.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Whether to enable public network access? Defaults to `true`.
        :param pulumi.Input[builtins.int] public_port: The publicly accessible port of the Web PubSub service which is designed for browser/client use.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Web PubSub service. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] secondary_access_key: The secondary access key for the Web PubSub service.
        :param pulumi.Input[builtins.str] secondary_connection_string: The secondary connection string for the Web PubSub service.
        :param pulumi.Input[builtins.int] server_port: The publicly accessible port of the Web PubSub service which is designed for customer server side use.
        :param pulumi.Input[builtins.str] sku: Specifies which SKU to use. Possible values are `Free_F1`, `Standard_S1`, `Premium_P1` and `Premium_P2`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.bool] tls_client_cert_enabled: Whether to request client certificate during TLS handshake? Defaults to `false`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceState.__new__(_ServiceState)

        __props__.__dict__["aad_auth_enabled"] = aad_auth_enabled
        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["external_ip"] = external_ip
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["identity"] = identity
        __props__.__dict__["live_trace"] = live_trace
        __props__.__dict__["local_auth_enabled"] = local_auth_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["primary_access_key"] = primary_access_key
        __props__.__dict__["primary_connection_string"] = primary_connection_string
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["public_port"] = public_port
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["secondary_access_key"] = secondary_access_key
        __props__.__dict__["secondary_connection_string"] = secondary_connection_string
        __props__.__dict__["server_port"] = server_port
        __props__.__dict__["sku"] = sku
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tls_client_cert_enabled"] = tls_client_cert_enabled
        __props__.__dict__["version"] = version
        return Service(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aadAuthEnabled")
    def aad_auth_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to enable AAD auth? Defaults to `true`.
        """
        return pulumi.get(self, "aad_auth_enabled")

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the number of units associated with this Web PubSub resource. Valid values are `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `10`, `20`, `30`, `40`, `50`, `60`, `70`, `80`, `90`, `100`, `200`, `300`, `400`, `500`, `600`, `700`, `800`, `900` and `1000`.

        > **Note:** The valid capacity range for sku `Free_F1` is `1`, for sku `Premium_P2` is from `100` to `1000`, and from `1` to `100` for sku `Standard_S1` and `Premium_P1`.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="externalIp")
    def external_ip(self) -> pulumi.Output[builtins.str]:
        """
        The publicly accessible IP of the Web PubSub service.
        """
        return pulumi.get(self, "external_ip")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[builtins.str]:
        """
        The FQDN of the Web PubSub service.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.ServiceIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="liveTrace")
    def live_trace(self) -> pulumi.Output[Optional['outputs.ServiceLiveTrace']]:
        """
        A `live_trace` block as defined below.
        """
        return pulumi.get(self, "live_trace")

    @property
    @pulumi.getter(name="localAuthEnabled")
    def local_auth_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to enable local auth? Defaults to `true`.
        """
        return pulumi.get(self, "local_auth_enabled")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the supported Azure location where the Web PubSub service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Web PubSub service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="primaryAccessKey")
    def primary_access_key(self) -> pulumi.Output[builtins.str]:
        """
        The primary access key for the Web PubSub service.
        """
        return pulumi.get(self, "primary_access_key")

    @property
    @pulumi.getter(name="primaryConnectionString")
    def primary_connection_string(self) -> pulumi.Output[builtins.str]:
        """
        The primary connection string for the Web PubSub service.
        """
        return pulumi.get(self, "primary_connection_string")

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to enable public network access? Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @property
    @pulumi.getter(name="publicPort")
    def public_port(self) -> pulumi.Output[builtins.int]:
        """
        The publicly accessible port of the Web PubSub service which is designed for browser/client use.
        """
        return pulumi.get(self, "public_port")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group in which to create the Web PubSub service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="secondaryAccessKey")
    def secondary_access_key(self) -> pulumi.Output[builtins.str]:
        """
        The secondary access key for the Web PubSub service.
        """
        return pulumi.get(self, "secondary_access_key")

    @property
    @pulumi.getter(name="secondaryConnectionString")
    def secondary_connection_string(self) -> pulumi.Output[builtins.str]:
        """
        The secondary connection string for the Web PubSub service.
        """
        return pulumi.get(self, "secondary_connection_string")

    @property
    @pulumi.getter(name="serverPort")
    def server_port(self) -> pulumi.Output[builtins.int]:
        """
        The publicly accessible port of the Web PubSub service which is designed for customer server side use.
        """
        return pulumi.get(self, "server_port")

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Output[builtins.str]:
        """
        Specifies which SKU to use. Possible values are `Free_F1`, `Standard_S1`, `Premium_P1` and `Premium_P2`.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tlsClientCertEnabled")
    def tls_client_cert_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to request client certificate during TLS handshake? Defaults to `false`.
        """
        return pulumi.get(self, "tls_client_cert_enabled")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "version")

