````markdown
# 🌈 CoolLog

یک لاگر رنگی و ساده برای پایتون 🚀  
با **CoolLog** می‌تونی پیام‌هات رو با رنگ‌های زیبا توی ترمینال نشون بدی و همزمان توی فایل `logs.txt` ذخیره کنی.  
سریع، سبک و بدون وابستگی به هیچ کتابخونه‌ای.

---

## ✨ ویژگی‌ها
- 🎨 لاگ‌های رنگی و واضح در ترمینال  
- 📝 ذخیره خودکار همه‌ی لاگ‌ها در فایل `logs.txt`  
- ⚡ بدون هیچ وابستگی خارجی  
- 🔥 پشتیبانی از سطوح مختلف لاگ:
  - `ERROR`
  - `WARNING`
  - `SUCCESS`
  - `INFO`
  - `DEBUG`
  - `CRITICAL`

---

## 📦 نصب

از [PyPI](https://pypi.org/project/coollog/) نصب کن:

```bash
pip install coollog
````

یا مستقیم از سورس:

```bash
git clone https://github.com/username/coollog.git
cd coollog
pip install .
```

---

## 🚀 استفاده

```python
from coollog import CoolLog

CoolLog.info("شروع برنامه...")
CoolLog.success("عملیات با موفقیت انجام شد ✅")
CoolLog.warning("این فقط یک هشدار است ⚠️")
CoolLog.error("خطا رخ داد ❌")
CoolLog.debug("این پیام فقط برای دیباگ است 🐛")
CoolLog.critical("خطای بحرانی! 🚨")
```

📌 خروجی ترمینال:
(مثال، رنگ‌ها واقعی هستند 👇)

```
[INFO-2025-08-27 11:30:45] شروع برنامه...
[SUCCESS-2025-08-27 11:30:45] عملیات با موفقیت انجام شد ✅
[WARNING-2025-08-27 11:30:45] این فقط یک هشدار است ⚠️
[ERROR-2025-08-27 11:30:45] خطا رخ داد ❌
[DEBUG-2025-08-27 11:30:45] این پیام فقط برای دیباگ است 🐛
[CRITICAL-2025-08-27 11:30:45] خطای بحرانی! 🚨
```

---

## 📜 لایسنس

این پروژه تحت لایسنس [MIT](LICENSE) منتشر شده.
آزاد هستی برای استفاده، تغییر و انتشار مجدد.
