"""
`pytest` testing framework file for GT-1
"""

from satnogsdecoders import decoder
from tests.shared_methods import check_type, load_objects


def test_answer():  # pylint: disable=too-many-locals
    """
    `pytest` entry point
    """
    beacon1 = bytearray([
        0x96, 0x9c, 0x68, 0xb4, 0x9c, 0xa6, 0x1e, 0x96, 0x96, 0x68, 0xaa, 0xac,
        0x8e, 0x05, 0x03, 0xf0, 0x01, 0x31, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd1, 0x01,
        0xb4, 0x01, 0x9f, 0x01, 0x9f, 0x01, 0x9b, 0x01, 0x4f, 0x3a, 0x09, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x80, 0x3a, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x96, 0x00, 0x32, 0x00, 0x14, 0x03, 0x00, 0x00,
        0x7d, 0x62, 0x01, 0x3c, 0x5e, 0xa7, 0x9f, 0xbf, 0x54, 0xf5, 0x24, 0x3d,
        0xcb, 0xa1, 0xa5, 0x3f, 0x8d, 0x97, 0xce, 0x3f, 0x48, 0x62, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x98, 0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0xa0, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x02, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x4f, 0x20, 0x48, 0xfe, 0x79, 0x00, 0x58, 0x1b,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    ])

    beacon2 = bytearray([
        0x96, 0x9c, 0x68, 0xb4, 0x9c, 0xa6, 0x1e, 0x96, 0x96, 0x68, 0xaa, 0xac,
        0x8e, 0x05, 0x03, 0xf0, 0x02, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    ])
    beacon1_keys = 50
    beacon2_keys = 55
    packets = [beacon1, beacon2]
    dut = 'Gt1'
    result = []

    for frame in packets:
        result = load_objects(decoder, dut, frame)
        count = check_type(result)
        if frame == beacon1:
            assert count == beacon1_keys
        if frame == beacon2:
            assert count == beacon2_keys
