"""A module to guide the output of an LLM using conditions and constraints"""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/04_pipelines.guider.ipynb.

# %% auto 0
__all__ = ['Guider']

# %% ../../nbs/04_pipelines.guider.ipynb 3
from guidance import models

# %% ../../nbs/04_pipelines.guider.ipynb 4
class Guider:
    def __init__(
        self,
        llm,
        **kwargs,
    ):
        """
        Guider Constructor. Note that the `callback` and`callback_manager` parameters to `onprem.LLM` 
        are not currently utilized by the `Guider`.

        **Args:**

        - *llm*: An `onprem.LLM` object

        """
        self.llm = llm
        if not llm.is_llamacpp():
            raise ValueError(f'The suppplied LLM is {llm.model_url}, but the Guider currently only supports local, on-premises llama.cpp-based models.')


    def prompt(self, guidance_program: str or guidance._grammar.Join, echo=True):
        """
        A guided prompt. Input is a [Guidance program](https://github.com/guidance-ai/guidance) (`guidance>=0.1.0`) 
        that specifies constraints and conditions on the output for the prompt.

        **Args:**

        - *guidance_program*: A Guidance program (`>=0.1.0`) in the form a string or a `guidance._grammar.Join` object
        - *echo*: If True, echo highlighted output in Jupyter notebook. Set `echo=False` if running stand-alone script.

        **Returns:**

        - A dictionary with keys specified in the Guidance program and values containing the model outputs
        """
        model = models.LlamaCpp(self.llm.llm.client, echo=echo) 
        output = model + guidance_program
        return output.__dict__['_variables']
