import requests as r

url = 'http://192.168.1.20:5500/rag/create'

body ={
    "index": "docs",
    "name_chunk": "test_chunk_1",
    "chunk_id": 1,
    "dtype" : "FLOAT32",
    "chunk_size": 1024,
    "raw_text" : "Dumb test to server endpoints",
    "embeddings" : [-0.022243177518248558, -0.022785693407058716, 0.03530530631542206, 0.011712792329490185, -0.0026273797266185284, 
    0.0002199626323999837, -0.03516620025038719, -0.0004581830289680511, 0.0747838169336319, -0.0028864662162959576, 0.028683822602033615, 
    -0.041342541575431824, -0.019474951550364494, -0.00020344369113445282, -0.022980444133281708, -0.002277873922139406, -0.003971499390900135, 
    -0.012317907065153122, -0.025275705382227898, 0.011434579268097878, 0.05500283092260361, 0.003592433175072074, 0.020935574546456337, 0.04632256552577019, 
    0.018376007676124573, -0.006176341790705919, -0.010752955451607704, 0.03922811895608902, 0.05032883957028389, -0.02882292866706848, 0.03794833645224571, 
    -0.021589376032352448, -0.05146951600909233, 0.003387250704690814, 0.02526179514825344, 0.06020542234182358, 0.0057138120755553246, 0.010106109082698822, 
    -0.007170955650508404, 0.0009154966101050377, 0.0012658719206228852, -0.022451838478446007, 0.014522749930620193, -0.029629748314619064, -0.025275705382227898, 
    0.004680943675339222, -0.027988288551568985, -0.029212428256869316, 0.005331268068403006, -0.0036550313234329224, -0.0375031940639019, -0.03227277845144272, 0.014258447103202343, 
    0.04278925061225891, -0.027863092720508575, 0.00888892449438572, 0.029907962307333946, -0.006760590709745884, 0.012255309149622917, -0.00021181184274610132, 0.015260016545653343, 
    -0.04935509338974953, 0.01470358856022358, -0.014536661095917225, -0.030047068372368813, -0.01431408990174532, -0.004594001919031143, 0.012547433376312256, 0.027404040098190308, 0.021116413176059723, 
    0.02334212139248848, 0.017499634996056557, 0.027751807123422623, -0.022284910082817078, -0.017388349398970604, -0.008318587206304073, 0.05430729687213898, -0.024677546694874763, -0.006781456526368856, 
    -0.0054216873832046986, -0.06293191760778427, 0.01238746102899313, -0.02985231950879097, -0.05486372113227844, -0.0009076718706637621, 0.013256878592073917, -0.07917959243059158, -0.007789981085807085, 0.0014840957010164857, -0.0033281303476542234, -0.006124177016317844, -0.02268831990659237, 
    -0.010989436879754066, 0.04693463444709778, 0.022465748712420464, -0.04312310740351677, 0.059148211032152176, 0.00025886905496008694, -0.05135823041200638, 0.013722886331379414, 0.014814874157309532, -0.04726849123835564, -0.04843698814511299, -0.01179625652730465, 0.034665413200855255, -0.006145042832940817, 
    0.03530530631542206, 0.037280622869729996, 0.006642349995672703, -0.0072822412475943565, -0.026833701878786087, -0.046044349670410156, -0.010210439562797546, -0.03296831250190735, 0.044736746698617935, 0.010613849386572838, 0.009654011577367783, 
    -0.08413179218769073, -0.005400821566581726, -0.026444202288985252, 0.002380465157330036, 0.01553822960704565, 0.04885431006550789, -0.028238680213689804, -0.01628940738737583, -0.04020186513662338, -0.015176552347838879, -0.042205002158880234, -0.010273037478327751, 0.012895200401544571, 0.06326577067375183, -0.019808808341622353, 0.06304319947957993, -0.013750707730650902, 0.01234572846442461, 0.0471850261092186, -0.04749106243252754, -0.04671206325292587, -0.00956359226256609, 0.04573831707239151, 0.023675978183746338, -0.015941640362143517, 0.040591366589069366, 0.009341021999716759, -0.0009824418229982257, -0.01457839272916317, -0.047602348029613495, 0.026638953015208244, 0.04946637898683548, 0.02142244763672352, 0.008833281695842743, 0.018570758402347565, -0.01761092059314251, -0.007588276173919439, -0.0551975779235363, -0.012498745694756508, 0.02591559663414955, 0.005539928562939167, -0.04557138681411743, -0.0067710233852267265, -0.021561553701758385, 0.020406967028975487, 0.036585088819265366, 0.009556637145578861, -0.03566698357462883, 0.01363246701657772, 0.04106432944536209, -0.04598870873451233, -0.043345678597688675, -0.004562702961266041, 0.00018062148592434824, 
    0.03255099058151245, 0.0556148998439312, -0.017346618697047234, -0.004868737887591124, 0.003950633108615875, 0.008770683780312538, -0.00512956315651536, 0.027751807123422623, -0.005995503161102533, 0.04042443633079529, 0.02898985706269741, 0.0033576905261725187, 0.010961616411805153, -0.05044012516736984, -0.005626870319247246, 0.01638678088784218, 0.059148211032152176, -0.04111997038125992, 0.01404283195734024, -0.005665124393999577, 0.03889426216483116, 0.0398123674094677, 0.03338563069701195, 0.007470035459846258, -0.06315448880195618, -0.0012406588066369295, -0.00959836971014738, 0.0202261283993721, 0.001789261237718165, -0.04440288990736008, -0.022883068770170212, 0.01858466863632202, -0.027404040098190308, -0.007949953898787498, 0.007386571262031794, 0.02362033538520336, 0.004274056293070316, 0.01126069575548172, -0.00794299878180027, 0.06154084950685501, 0.04025750979781151, -0.019224559888243675, 0.01261003129184246, -0.013674198649823666, 0.02681979164481163, -0.019391488283872604, 0.017680473625659943, 0.016943208873271942, -0.02150591090321541, -0.012429192662239075, 0.041787683963775635, 0.039005547761917114, -0.03360820189118385, -0.017624832689762115, 0.05425165221095085, 0.029268071055412292, 0.02669459581375122, 0.029629748314619064, -0.006322404369711876, -0.0020761690102517605, 0.004580091219395399, -0.0006059840088710189, 0.02071300335228443, 0.022855248302221298, -0.019155006855726242, 0.0006185905658639967, -0.026305096223950386, -0.01765265315771103, -0.01858466863632202, 0.013792439363896847, -0.03157724440097809, -0.04938291385769844, -0.03394205868244171, -0.0255956519395113, -0.005407777149230242, -0.008395095355808735, 0.01197709608823061, 0.03861604630947113, -0.007365704979747534, 0.026179900392889977, -0.03591737523674965, 0.06154084950685501, -0.021895410493016243, -0.013423806056380272, -0.0013249922776594758, -0.007275285664945841, -0.03071478195488453, 0.02014266513288021, -0.02407938800752163, -0.04910470172762871, 0.03836565464735031, -0.005039143841713667, 0.008520291186869144, -0.032161492854356766, -0.0556148998439312, 0.02149200066924095, -0.03282920643687248, -0.035722628235816956, 0.009222781285643578, 0.02220144495368004, 0.030520033091306686, 0.04089739918708801, -0.03010271117091179, -0.06944211572408676, -0.008923701010644436, 0.013889813795685768, -0.014787052758038044, -0.0507739819586277, -0.046906813979148865, -0.012665674090385437, -0.050384484231472015, -0.024510618299245834, -0.0051469518803060055, 0.022535301744937897, -0.035694804042577744, 0.007470035459846258, -0.007678695488721132, 0.009660967625677586, 0.025971239432692528, 0.008562023751437664, 0.06448991596698761, 0.010746000334620476, -0.007240509148687124, 0.014634035527706146, -0.007845623418688774, 0.0011206791969016194, -0.03460977226495743, -0.004767885431647301, -0.025053134188055992, 0.04025750979781151, 0.04036879539489746, -0.00941753014922142, 0.010899017564952374, -0.010168706998229027, -0.00788039993494749, 0.04651731625199318, 0.04287271574139595, 0.04618345946073532, -0.034581951797008514, -0.00960532482713461, 0.006176341790705919, -0.015899907797574997, 0.027779627591371536, 0.029880141839385033, -0.06899697333574295, 0.012790870852768421, -0.0423441119492054, 0.03625123202800751, -0.04643385112285614, -0.030575675889849663, -0.029546285048127174, -0.007789981085807085, 0.02789091318845749, -0.004507060162723064, -0.007595231290906668, -0.03135467320680618, -0.02726493403315544, 0.013180369511246681, 0.009967002086341381, -0.017944777384400368, -0.02854471653699875, 0.03741972893476486, -0.02355078235268593, -0.013827215880155563, -0.03079824522137642, -0.03029746189713478, 0.022883068770170212, -0.040647007524967194, 0.016971029341220856, -0.020365236327052116, -0.02260485477745533, 0.005887695588171482, -0.008012551814317703, 0.02784918248653412, 0.01441146433353424, -0.013771573081612587, 0.02641638182103634, 0.02915678545832634, 0.014286268502473831, 0.0015293053584173322, -0.02473318949341774, 0.014592303894460201, -0.004086262080818415, 0.02477492205798626, -0.03947851061820984, -0.006249372847378254, -0.007164000067859888, -0.007170955650508404, -0.01386199239641428, -0.014634035527706146, 0.027014540508389473, -0.007553499191999435, 0.04331785812973976, 0.021964963525533676, 0.04348478466272354, -0.028795108199119568, -0.01316645834594965, -0.007532633375376463, -0.005021755583584309, -0.04103650525212288, 0.06710512191057205, -0.008749817498028278, -0.01998964697122574, -0.0028864662162959576, 0.03499926999211311, -0.014592303894460201, 0.06905261427164078, 0.020462609827518463, -0.0013380335876718163, 0.045599211007356644, 0.037614479660987854, 0.017555277794599533, -0.029824499040842056, 0.03255099058151245, 0.012331818230450153, 0.016331138089299202, -0.0474075973033905, -0.012616987340152264, -0.03716933727264404, 0.007358749862760305, -0.036835480481386185, -0.017513547092676163, -0.048047490417957306, 0.03522184118628502, 0.025331348180770874, 0.021978873759508133, -0.037085872143507004, -0.0016440685139968991, 
    -0.021450268104672432, 0.019015898928046227, 0.03063131682574749, -0.040841758251190186, 0.007727382704615593, 0.004990456625819206, -0.02317519299685955, 0.023968102410435677, -0.03124338760972023, -0.00958445854485035, -0.020852109417319298, 0.00673624686896801, 0.01128156203776598, 0.06788411736488342, 0.015955550596117973, 0.013222101144492626, -0.006924041081219912, 0.051413875073194504, -0.005988548044115305, -0.016525888815522194, 0.03316306322813034, -0.011434579268097878, -0.004646167159080505, -0.0551975779235363, 0.02730666473507881, -0.0004581830289680511, 0.06126263365149498, 0.02517833188176155, 0.02227099984884262, 0.06571405380964279, -0.0349714495241642, 0.027960466220974922, 0.017137957736849785, -0.04910470172762871, 0.026513757184147835, -0.006997072137892246, -0.004882648587226868, 0.015093088150024414, 0.016984939575195312, -0.030826067551970482, 0.022368373349308968, -0.013639422133564949, -0.012728272005915642, -0.021672839298844337, -0.014592303894460201, -0.05547579377889633, -0.039367225021123886, -0.026402471587061882, -0.024343689903616905, 0.03872733190655708, -0.07044368237257004, -0.02317519299685955, -0.045181889086961746, -0.03819872811436653, -0.006670170929282904, -0.03730844333767891, -0.04348478466272354, 0.02624945342540741, 0.024135030806064606, 0.0375031940639019, -0.0025665205903351307, 0.02587386593222618, -0.0026430292055010796, -0.026430292055010796, 0.04849263280630112, 0.018640311434864998, 0.02239619567990303, 0.011879720725119114, 0.013625510968267918, 0.0051469518803060055, 0.0018362097907811403, 0.02441324293613434, 0.014536661095917225, -0.019029811024665833, 0.031382493674755096, -0.036501623690128326, -0.02915678545832634, 0.02485838532447815, -0.005692945793271065, 0.0015040922444313765, -0.012533523142337799, -0.021060770377516747, -0.07684259861707687, -0.031799815595149994, -0.05786842852830887, 0.02498358115553856, 0.13331995904445648, -0.02334212139248848, 0.03700241073966026, -0.009069763123989105, 0.012881290167570114, -0.04835352301597595, 0.033636026084423065, 0.017847402021288872, -0.017012761905789375, -0.00491394754499197, -0.023272568359971046, 0.021464180201292038, 0.010252171196043491, 0.02035132423043251, -0.02526179514825344, -0.03505491465330124, -0.05433511734008789, -0.012297041714191437, 0.048019666224718094, 0.021325072273612022, 0.012352683581411839, 0.002603036118671298, 0.00974443182349205, 0.02018439769744873, -0.04131472110748291, 0.01822299137711525, -0.0027421428821980953, 0.01318732462823391, -0.02403765544295311, -0.04131472110748291, -0.0067953672260046005, 0.008200345560908318, 0.034832343459129333, -0.010057421401143074, 0.01649806648492813, -0.020128754898905754, 0.022340552881360054, -0.0006629308336414397, -0.011156365275382996, -0.00603027967736125, -0.005995503161102533, -0.030742602422833443, -0.015079176984727383, -0.021464180201292038, -0.027863092720508575, 0.025080956518650055, -0.00604071281850338, 0.05580965057015419, -0.007004027254879475, 0.006231984589248896, 0.014773142524063587, 0.004941768944263458, -0.004176681861281395, 0.02469145692884922, -0.026305096223950386, 0.021185966208577156, 0.030742602422833443, -0.02522006258368492, -0.019850540906190872, -0.010968571528792381, -0.03858822584152222, -0.005407777149230242, -0.009807029739022255, 0.001734487945213914, -0.050718341022729874, 0.012658718973398209, -0.007845623418688774, 0.004427073989063501, 0.018737686797976494, 0.023369941860437393, 0.01834818720817566, 0.03550005704164505, -0.0442359633743763, 0.014940070919692516, 0.008346407674252987, 0.00584596348926425, 0.02473318949341774, 0.03719715774059296, 0.0174857247620821, -0.001506700529716909, -0.021074680611491203, -0.016762370243668556, -0.00034059429890476167, 0.006033757701516151, -0.020810376852750778, -0.02477492205798626, 0.027334487065672874, -0.05569836497306824, 0.015357390977442265, 0.025373080745339394, 0.027056273072957993, -0.008694174699485302, -0.022159714251756668, 0.0086385328322649, -0.005411254707723856, -0.01826472394168377, -0.03463759273290634, 0.01658153161406517, 0.02793264575302601, -0.044319428503513336, -0.01111463364213705, 0.034331560134887695, -0.018292544409632683, -0.007028371095657349, 0.015705157071352005, 0.01859857887029648, 0.010349545627832413, 0.029379356652498245, 0.004976545926183462, 0.01740226149559021, 0.012248354032635689, 0.005115652456879616, 0.018723774701356888, -0.01797259971499443, 0.014592303894460201, -5.846832937095314e-05, -0.01402196567505598, -0.02591559663414955, 0.021714571863412857, 0.020546074956655502, 0.0013093427987769246, 0.01813952624797821, 0.03238406404852867, 0.013813305646181107, -0.013055173680186272, 0.02732057496905327, 0.0023891592863947153, -0.031632885336875916, -0.0423441119492054, 0.0389777272939682, 0.025846043601632118, -0.008541157469153404, 0.013966322876513004, -0.011184186674654484, 0.020949484780430794, -0.032857026904821396, -0.006878831423819065, 0.02211798168718815, 0.004722675774246454, -0.02203451655805111, -0.02121378667652607, -0.012116202153265476, -0.011601507663726807, -0.01058602798730135, 0.013402940705418587, -0.030909530818462372, -0.004423596430569887, 0.02816912718117237, -0.016275495290756226, -0.01793086715042591, -0.012505701743066311, -0.004277534317225218, 0.03558351844549179, -0.06855183094739914, -0.041509468108415604, 0.0122205326333642, -0.005852918606251478, 0.025581741705536842, 0.007755204103887081, -0.024343689903616905, 0.0021022516302764416, -0.02235446311533451, -0.01986445114016533, -0.027098005637526512, -0.020949484780430794, -0.005772932432591915, 0.03600084036588669, 0.006134610157459974, -0.002140505937859416, 0.02686152420938015, -0.01769438572227955, -0.06092878058552742, -0.0368633009493351, -0.04996716231107712, 0.00019724910089280456, -0.00722659844905138, 0.021102501079440117, -0.023230835795402527, 0.0028377787675708532, -0.024135030806064606, 0.04009057953953743, -0.03360820189118385, -0.008624621666967869, -0.019725345075130463, -0.0112189631909132, -0.03722498193383217, 0.03669637441635132, 0.032495349645614624, 0.0005625131307169795, 0.05803535878658295, -0.006593662314116955, -0.010238260962069035, -0.0383378341794014, -0.026805881410837173, 0.04226064682006836, 0.020740823820233345, 0.03992365300655365, -0.012290085665881634, -0.027459682896733284, 
    -0.010474742390215397, -0.006864920724183321, 0.0006924910703673959, 0.04337349906563759, -0.033969879150390625, -0.015593872405588627, -0.02005920000374317, -0.042399752885103226, 0.026791969314217567, 0.01613638922572136, -0.017179690301418304, -0.014237580820918083, 0.001792738912627101, 0.037113696336746216, 0.017583100125193596, -0.04337349906563759, 0.03435938060283661, -0.01140675786882639, 0.014522749930620193, -0.005293013993650675, -0.001232834067195654, -0.01249179057776928, 0.005790320690721273, 0.0013536830665543675, -0.008221211843192577, -0.017861314117908478, -0.017221422865986824, -0.006684081628918648, -0.01150413230061531, 0.005574705079197884, -0.010871196165680885, 0.007998640649020672, -0.010453876107931137, -0.0008285549120046198, -0.005571227520704269, -0.020420879125595093, -0.016553709283471107, 0.03775358572602272, 0.024872295558452606, 0.0023491661995649338, 0.012874334119260311, -0.0064858547411859035, 0.01719360053539276, -0.011483266949653625, 0.005741633474826813, -0.019141096621751785, -0.021519822999835014, -0.0028742942959070206, -0.019669702276587486, 0.028962036594748497, -0.01649806648492813, -0.04857609421014786, -0.002940370002761483, 0.005466897506266832, -0.020671270787715912, -0.00820730160921812, -0.02624945342540741, -0.004340132232755423, -0.00878459494560957, -0.026193810626864433, -0.007949953898787498, 0.0043262215331196785, 0.0039680213667452335, -0.02567911520600319, -0.0022743961308151484, 4.041432930534938e-06, -0.030158353969454765, 0.012533523142337799, -0.030826067551970482, 0.0178056713193655, -0.022702230140566826, -0.028280412778258324, 0.031048638746142387, -0.006638871971517801, 0.020629538223147392, 0.06104006618261337, -0.0030812155455350876, 0.012408326379954815, 0.02871164306998253, 0.010676447302103043, 0.02898985706269741, -0.02186759002506733, -0.02121378667652607, -0.024051565676927567, 0.035110555589199066, 0.006221551913768053, 0.04156511276960373, -0.004340132232755423, -0.014439285732805729, 0.0393950454890728, 0.034748878329992294, -0.012394416145980358, -0.09225562959909439, -0.02142244763672352, -0.02924025058746338, -0.010509518906474113, 0.005265192594379187, 0.010537340305745602, 0.00151539477519691, 0.0012119680177420378, 0.0086385328322649, 0.03825436905026436, 0.018848972395062447, 0.049438558518886566, -0.08001422882080078, -0.018654221668839455, -0.00744221406057477, -0.019767075777053833, -0.049160342663526535, -0.02932371385395527, 0.03803179785609245, -0.0541403666138649, -0.014926159754395485, -0.10349546372890472, -0.01687365584075451, -0.01773611642420292, -0.007678695488721132, 0.00835336372256279, -0.017750028520822525, -0.006847532466053963, 0.04000711441040039, -0.009939180687069893, 0.012394416145980358, 0.03435938060283661, 0.0018344708951190114, -0.007963864132761955, -0.038476940244436264, 0.03942286595702171, 0.007553499191999435, -0.007852578535676003, -0.004374908749014139, 0.006346747744828463, -0.00982789508998394, 0.017457904294133186, -0.010947705246508121, 0.03664072975516319, 0.03316306322813034, 0.03177199512720108, 0.03383077308535576, 0.0003119035391137004, -0.026847612112760544, 0.05650518462061882, -0.04459764063358307, 0.017513547092676163, 0.03722498193383217, 0.005852918606251478, -0.005748588591814041, 0.012116202153265476, -0.012582209892570972, -0.007330928463488817, 0.0009354932699352503, 0.01592772826552391, -0.028767285868525505, -0.020754734054207802, -0.007553499191999435, 0.0018796806689351797, -0.010321724228560925, -0.028850750997662544, -0.012721316888928413, -0.018362097442150116, 0.009375798515975475, -0.004381864331662655, -0.024023745208978653, -0.03452630713582039, -0.020365236327052116, -0.024872295558452606, 0.02854471653699875, -0.07010982930660248, 0.035277485847473145, 0.05747893080115318, 0.03625123202800751, -0.0029542807023972273, -0.009041941724717617, -0.023328211158514023, -0.012623942457139492, -0.0324397049844265, -0.04415249824523926, -0.01111463364213705, -0.017221422865986824, -0.002563042799010873, 0.011733658611774445, 0.010919883847236633, 0.007122268434613943, 0.004420118406414986, 0.05416818708181381, 0.017304886132478714, -0.01862640120089054, 0.026277275756001472, -0.006291104946285486, 0.01653979904949665, 0.010252171196043491, 0.004694854374974966, 0.003815004136413336, 0.0478249192237854, -0.002250052522867918, 0.01859857887029648, 0.023495139554142952, 0.011942318640649319, -0.05391779541969299, 0.012227487750351429, -0.003129902994260192, 0.004360998049378395, -0.031605064868927, 0.005077398382127285, -0.021366804838180542, -0.005759021732956171, 0.03911683335900307, 0.0010111326118931174, 0.021199876442551613, -0.013249922543764114, -0.027626611292362213, 0.023369941860437393, 0.019335845485329628, 0.031799815595149994, -0.0030899099074304104, 0.022855248302221298, 0.034053344279527664, 0.02629118598997593, 0.01332643162459135, 0.00818643532693386, 0.011719748377799988, -0.018028240650892258, -0.024969670921564102, 0.004628778900951147, -0.01649806648492813, 0.029295891523361206, -0.04095304384827614, -0.051942478865385056, 0.010286947712302208, 0.03157724440097809, -0.006767545826733112, 0.004680943675339222, 0.028071751818060875, 0.024496708065271378, 0.00902803149074316, -0.018862882629036903, 0.014981802552938461, -0.05311097577214241, -0.007664784789085388, 0.023926369845867157, 0.010488652624189854, -0.029629748314619064, -0.005762499291449785, -0.009396664798259735, 0.0434013232588768, -0.006033757701516151, -0.015830354765057564, 0.016511976718902588, -0.029907962307333946, 0.01630331762135029, 0.005727722775191069, -0.0224379263818264, 0.03071478195488453, -0.025039223954081535, -0.009507949464023113, 0.019808808341622353, -0.029713213443756104, -0.005477330181747675, -0.008854147978127003, 0.0020726914517581463, 0.009000210091471672, -0.003049916587769985, -0.0034098555333912373, -0.00929928943514824, -0.03680766001343727, -0.02976885624229908, -0.0056512136943638325, 0.001813604962080717, 0.03419245034456253, 0.007066625636070967, -0.007956909015774727, 0.011295472271740437, -0.003839347744360566, -0.051942478865385056, 0.010759911499917507, -0.030909530818462372, 0.01249179057776928, 0.034053344279527664, -0.016025103628635406, -0.007783025503158569, 0.0014510578475892544, 0.007111835293471813, 0.019141096621751785, 0.021811947226524353, 0.014328000135719776, -0.018445562571287155, -0.045432280749082565, 0.009181048721075058, 0.062097277492284775, 0.04131472110748291, -0.0005520801059901714, 0.006826666183769703, 0.011003348045051098, 0.05380650982260704, 0.017861314117908478, -0.052554551512002945, 0.02595732919871807, 0.07739902287721634, 0.019808808341622353, -0.0007411784026771784, 0.0001785566273611039, 0.014161072671413422, 0.00915322732180357, 0.008909790776669979, 0.0283360555768013, 0.013270788826048374, -0.014689678326249123, -0.017416171729564667, -0.022006696090102196, 0.020031379535794258, 0.008527247235178947, -0.035110555589199066, -0.01111463364213705, -0.02567911520600319, 0.028850750997662544, -0.014634035527706146, -0.007685650605708361, -0.02211798168718815, 0.0021092069800943136, -0.01875159703195095, 0.006364136002957821, 0.009160182438790798, 0.030520033091306686, 0.008610711432993412, 0.015079176984727383, 0.012436147779226303, 0.013917635194957256, -0.002161371987313032, -0.037085872143507004, -0.028280412778258324, -0.005466897506266832, 0.01813952624797821, -0.03021399676799774, -0.0012050126679241657, -0.03516620025038719, 0.0014267141232267022, 0.010071332566440105, -0.008694174699485302, -0.005529495421797037, 0.0033055252861231565, -0.015065266750752926, -0.014814874157309532, 0.0042114583775401115, -0.012700450606644154, 0.062097277492284775, 0.0014423636021092534, 0.033107418566942215, 0.011907542124390602, 0.021895410493016243, 0.012575254775583744, 0.024510618299245834, 0.009654011577367783, 0.01588599756360054, -0.015566051006317139, -0.023161282762885094, -0.014536661095917225, 0.016692815348505974, 0.008756773546338081, 0.018570758402347565, 0.007365704979747534, -0.010982481762766838, 0.004214935936033726, 0.009904404170811176, -0.0013832432450726628, -0.012693495489656925, 0.016150299459695816, -0.008304676041007042, 0.0005912039196118712, -0.026680683717131615, -0.0368633009493351, -0.004959157668054104, 0.016929298639297485, 0.0021022516302764416, 0.007504811976104975, -0.023328211158514023, -0.007097924593836069, 0.02456626109778881, -0.013855037279427052, -0.007998640649020672, -0.004354042932391167, 0.018821150064468384, 0.018417740240693092, -0.010676447302103043, 0.0011024214327335358, 0.018807239830493927, 0.018779417499899864, 0.0045209708623588085, -0.04070264846086502, -0.004406208172440529, 0.03260663524270058, -0.028656000271439552, 0.002719538053497672, -0.001799694262444973, -0.02707018330693245, -0.00034255051286891103, 0.016108566895127296, -0.014244536869227886, 0.016108566895127296, -0.020977305248379707, -0.03374731168150902, -0.01641460321843624, -0.002703888574615121, -0.016637174412608147, -0.007400481961667538, -0.015510408207774162, 0.008881969377398491, -0.023314299061894417, 0.010175662115216255, -0.00401323102414608, 0.0010059160413220525, -0.03394205868244171, 0.047435417771339417, -0.03583391383290291, 0.014300179667770863, 0.015510408207774162, -0.016567619517445564, -0.009146272204816341, 0.014126296155154705, -0.029184607788920403, 0.0017788282129913568, 0.03385859727859497, -0.005964204203337431, 0.014995712786912918, 0.00674668001011014, -0.024427155032753944, 0.017471814528107643, -0.0022013650741428137, -0.00958445854485035, 0.039534151554107666, 0.025164419785141945, -0.004176681861281395, -0.0526658333837986, 0.02448279783129692, -0.022410105913877487, -0.033886417746543884, -0.015830354765057564, -0.035694804042577744, -0.0006933604599907994, 0.023884637281298637, 0.01167106069624424, -0.0010876413434743881, 0.00917409360408783, -0.005748588591814041, 0.02629118598997593, -0.022284910082817078, -0.01386199239641428, 0.013340341858565807, -0.05416818708181381, 0.01634504832327366, -0.013535091653466225, -0.024621903896331787, -0.03772576525807381, -0.0011858855141326785, 0.002333516487851739, 0.006117221433669329, 0.011003348045051098, -0.004941768944263458, 0.010015689767897129, 0.021019037812948227, 0.031271208077669144, 0.02439933270215988, 0.001690147677436471, -0.01212315820157528, 0.06732769310474396, 0.01110072247684002, 0.015287837944924831, -0.0152739267796278, 0.0012571776751428843, 0.011371981352567673, -0.007358749862760305, 0.022549211978912354, -0.023648155853152275, 0.0002421327808406204, -0.041175615042448044, -0.00806819461286068, -0.01859857887029648, -0.0014919204404577613, -0.016205942258238792, 0.03447066619992256, -0.01919673942029476, 0.014161072671413422, -0.018292544409632683, -0.020253950729966164, -0.000252565776463598, 0.00039797587669454515, 0.028363876044750214, 0.016442423686385155, 0.009452307596802711, -0.023731620982289314, -0.014174982905387878, -0.0044548953883349895, 0.05553143471479416, 0.01953059434890747, -0.01765265315771103, -0.006965773180127144, -0.006054623518139124, -0.02273005060851574, 0.03174417093396187, -0.0007937781629152596, -0.024343689903616905, 0.007783025503158569, 0.004124516621232033, -0.011643239296972752, -0.015246105380356312, -0.012742183171212673, -0.014689678326249123, -0.037447549402713776, -0.03427591547369957, 0.040313150733709335, 0.03764230012893677, -0.02722320146858692, -0.0019388010259717703, 0.011330248787999153, -0.013987189158797264, 0.03547223284840584, 0.014522749930620193, 0.02121378667652607, 0.005126085598021746, -0.027751807123422623, -0.01567733660340309, 0.013896769843995571, 0.042038075625896454, 0.000476875517051667, 0.025929508730769157, 0.007028371095657349, 0.01445319689810276, 0.05606004223227501, -0.003721107030287385, 0.015705157071352005, -0.00422884663566947, 0.01641460321843624, -0.03772576525807381, -0.004207980819046497, 0.013486403971910477, 0.015260016545653343, 0.0030899099074304104, -0.02064344845712185, -0.0029699301812797785, -0.0022900456096976995, 0.03369166702032089, -0.007164000067859888, -0.057924073189496994, -0.010328680276870728, -0.01349336002022028, 0.0070005496963858604, 0.03296831250190735, 0.000341681094141677, 0.0027612699195742607, 0.00958445854485035, 0.005571227520704269, -0.02140853740274906, -0.017944777384400368, 0.0034950582776218653, -0.020504342392086983, -0.030826067551970482, -0.01165019441395998, -0.0008302937494590878, -0.019113274291157722, -0.0034481098409742117, -0.006652782671153545, 0.004347087349742651, 0.0158025324344635, 0.004875693470239639, 0.023884637281298637, -0.012992574833333492, -0.0049035148695111275, 0.012804781086742878, -0.02637464925646782, 0.024496708065271378, -0.02555391937494278, -0.028850750997662544, 
    -0.009779208339750767, 0.016192032024264336, 0.011643239296972752, -0.03332998976111412, 0.003620254574343562, -0.01990618370473385, 0.013959367759525776, -0.01361160073429346, -0.04206589609384537, -0.0084785595536232, 0.009076719172298908, 0.014174982905387878, 0.0038810798432677984, 0.048548273742198944, 0.010120020247995853, 0.016470246016979218, 0.001751876319758594, 0.045014962553977966, 0.0013432500418275595, 0.034665413200855255, -0.001683192327618599, 0.0009363626595586538, 0.0300192479044199, -0.007525677792727947, 0.007275285664945841, 0.003388989483937621, 0.03430373594164848, 0.02730666473507881, 0.011538908816874027, -0.045432280749082565, -0.0070388042367994785, 0.022159714251756668, -0.0007568279397673905, 0.030325282365083694, 0.004541837144643068, 0.005133041180670261, 0.0020483476109802723, -0.0026430292055010796, 0.016818013042211533, 0.0042218915186822414, 0.02513659931719303, 0.0054703750647604465, -0.016943208873271942, 0.0077204275876283646, 0.03071478195488453, 0.013465538620948792, 0.01592772826552391, 0.018556848168373108, -0.003279442898929119, 0.015607783570885658, -0.022938711568713188, -0.029880141839385033, -0.015955550596117973, -0.00958445854485035, -0.01071122381836176, 0.053250085562467575, 0.008951522409915924, -0.015093088150024414, 0.013173414394259453, 0.022090159356594086, -0.01123982947319746, 0.006917085498571396, 0.010370411910116673, 0.015371301211416721, -0.013270788826048374, 0.001169366529211402, 0.015552140772342682, -0.02342558465898037, 0.020782556384801865, -0.04462546110153198, -0.035694804042577744, 0.04114779084920883, -0.005452986806631088, 0.01912718452513218, -0.009083674289286137, 0.0043018776923418045, 0.031605064868927, 0.0020935572683811188, -0.005859874188899994, -0.001744920969940722, -0.00015040923608466983, -0.0022187535651028156, -0.007090969011187553, -0.025790400803089142, 0.03010271117091179, 0.015524319373071194, -0.017388349398970604, 0.009021076373755932, 0.020114842802286148, 0.007546544075012207, -0.005178250838071108, 0.014091518707573414, -0.009528815746307373, 0.012728272005915642, -0.010780776850879192, 0.0310764592140913, 0.005216504912823439, -0.0064858547411859035, -0.010210439562797546, 0.00222223112359643, 0.01805606298148632, 0.014856606721878052, -0.021241609007120132, 0.02854471653699875, -0.00972356554120779, 0.005856396164745092, 0.03886644169688225, 0.01818125881254673, 0.010676447302103043, 0.026138167828321457, -0.03071478195488453, 0.01900198869407177, -0.007449169177561998, 0.01649806648492813, -0.005223460495471954, -0.04217718169093132, 0.0018049107166007161, -0.03410898894071579, 0.011559775099158287, -0.0012232704320922494, 0.0066666933707892895, -0.018167348578572273, 0.006033757701516151, 0.008548112586140633, -0.0052512818947434425, -0.0152739267796278, 0.003263793420046568, -0.016122478991746902, 0.01658153161406517, -0.0178056713193655, 0.012178800068795681, 0.010293903760612011, 0.008826326578855515, -0.008492469787597656, -0.019182827323675156, 0.04949419945478439, -0.017791759222745895, -0.01769438572227955, 0.025484366342425346, 0.005105219781398773, -0.012874334119260311, -0.022243177518248558, -0.00702141597867012, 0.006395435426384211, 0.019099364057183266, 0.03925593942403793, -0.036585088819265366, 0.012575254775583744, 0.021519822999835014, -0.02943499945104122, 0.010551250539720058, -0.004079306963831186, -0.025901686400175095, 0.0341368094086647, -0.004500105045735836, -0.009466217830777168, 0.013416850939393044, -0.03842129930853844, 0.013820260763168335, 0.00788039993494749, -0.03722498193383217, 0.004079306963831186, -0.012443103827536106, 0.0010346068302169442, 0.0026291185058653355, -0.008847192861139774, -0.006092878058552742, -0.030269639566540718, 0.007191821467131376, 0.018765507265925407, 0.030826067551970482, 0.031382493674755096, -0.003981932066380978, -0.02026786096394062, 0.02932371385395527, -0.014154116623103619, -0.0158025324344635, 0.02793264575302601, 2.6911189706879668e-05, 0.01900198869407177, 0.02583213336765766, 0.013048217631876469, -0.02629118598997593, -0.01904372125864029, -0.023356031626462936, -0.0027177990414202213, 0.002460451563820243, 0.03655726835131645, 0.022048428654670715, -0.019600149244070053, 0.009987868368625641, -0.048381347209215164, -0.008235123008489609, -0.00402366416528821, 0.029128964990377426, 0.010885107330977917, -0.01605292409658432, 0.003244666149839759, 0.01592772826552391, -0.00031320765265263617, -0.017708295956254005, 0.004274056293070316, -0.01711013726890087, -0.000837249041069299, 0.0013249922776594758, 0.0404522567987442, 0.0017597010591998696, 0.02485838532447815, 0.004333176650106907, 0.0305478535592556, 0.031966742128133774, 0.0029003769159317017, 0.02218753471970558, 0.008061239495873451, 0.0018309932202100754, 0.017221422865986824, 0.08691392838954926, 0.039200298488140106, 0.0011154626263305545, 0.0037489281967282295, -0.012137068435549736, -0.010286947712302208, 0.009104540571570396, 0.00612069945782423, 0.019794898107647896, 0.017944777384400368, 0.06999853998422623, 0.0007907352410256863, -0.019920093938708305, 0.05127476528286934, -0.0017536150990054011, -0.030353104695677757, -0.04089739918708801, -0.005654691718518734, -0.004079306963831186, -0.015065266750752926, 0.002569998148828745, -0.04206589609384537, 0.015913818031549454, 0.024594083428382874, 0.024663636460900307, -0.005988548044115305, 0.004079306963831186, 0.002338733058422804, 0.030965173617005348, 0.003048177808523178, -0.04320657253265381, -0.009549682028591633, 0.0015388689935207367, -0.011267650872468948, -0.021158143877983093, 0.0024239360354840755, -0.0029664526227861643, -0.03021399676799774, 0.002502183662727475, 0.03872733190655708, -0.000787692260928452, -0.0019301068969070911, 0.031132102012634277, -0.005922472104430199, -0.005327790509909391, 0.03992365300655365, -0.023648155853152275, 0.0009859194979071617, 0.0073726605623960495, 0.01291606668382883, 0.006809277925640345, -0.0032064118422567844, -0.011065945960581303, -0.010662536136806011, -0.006889264564961195, 0.002481317613273859, -0.010126975364983082, 0.007630008272826672, 0.06076185032725334, -0.02424631640315056, 0.01330556534230709, 0.020573895424604416, -0.00915322732180357, -0.040396615862846375, 0.038059622049331665]
}

# Yup, it's a real embedding
#x = requests.post(url=url, json=body)

#print(x.text)


# Quick test to see if everything works

if __name__ == "__main__":
    from openai import OpenAI

    # This is supposed to match the text and embedding above.
    text_1 = "Dumb test"
    # This one is not
    text_2 = "FastAPI is based on Starlette"

    def run_test(text, api_key=None):
        base_url = 'https://aquiles-deploy.onrender.com'
        client = OpenAI()
        embedding = client.embeddings.create(
            input=text,
            model="text-embedding-3-small"
        )
        body = {
            "index" : "docs",
            "embeddings": embedding.data[0].embedding,
            "dtype": "FLOAT32",
            "top_k": 5,
            "cosine_distance_threshold": 0.6
        }

        if api_key:
            header = {"X-API-Key": api_key}

            response = r.post(url=f"{base_url}/rag/query-rag", headers=header, json=body)
        else:
            response = r.post(url=f"{base_url}/rag/query-rag", json=body)

        return response.text

    print(f"Test with the following text: {text_1}")
    print("\n")
    print(run_test(text_1, api_key="dummy-api-key"))
    print("\n")
    print(f"Test with the following text: {text_2}")
    print("\n")
    print(run_test(text_2, api_key="dummy-api-key"))