Module blaxel.core.client.models.custom_domain_spec
===================================================

Classes
-------

`CustomDomainSpec(cname_records: blaxel.core.client.types.Unset | str = <blaxel.core.client.types.Unset object>, last_verified_at: blaxel.core.client.types.Unset | str = <blaxel.core.client.types.Unset object>, region: blaxel.core.client.types.Unset | str = <blaxel.core.client.types.Unset object>, status: blaxel.core.client.types.Unset | str = <blaxel.core.client.types.Unset object>, txt_records: blaxel.core.client.types.Unset | ForwardRef('CustomDomainSpecTxtRecords') = <blaxel.core.client.types.Unset object>, verification_error: blaxel.core.client.types.Unset | str = <blaxel.core.client.types.Unset object>)`
:   Custom domain specification
    
    Attributes:
        cname_records (Union[Unset, str]): CNAME target for the domain
        last_verified_at (Union[Unset, str]): Last verification attempt timestamp
        region (Union[Unset, str]): Region that the custom domain is associated with
        status (Union[Unset, str]): Current status of the domain (pending, verified, failed)
        txt_records (Union[Unset, CustomDomainSpecTxtRecords]): Map of TXT record names to values for domain
            verification
        verification_error (Union[Unset, str]): Error message if verification failed
    
    Method generated by attrs for class CustomDomainSpec.

    ### Static methods

    `from_dict(src_dict: dict[str, typing.Any]) ‑> ~T`
    :

    ### Instance variables

    `additional_keys: list[str]`
    :

    `additional_properties`
    :

    `cname_records`
    :

    `last_verified_at`
    :

    `region`
    :

    `status`
    :

    `txt_records`
    :

    `verification_error`
    :

    ### Methods

    `to_dict(self) ‑> dict[str, typing.Any]`
    :